<?php
/**
 * WordPress.com-specific functions and definitions
 *
 * @package Revelar
 */

/**
 * Enqueue WordPress.com-specific styles.
 */
function revelar_wpcom_styles() {
	wp_enqueue_style( 'revelar-wpcom', get_template_directory_uri() . '/inc/style-wpcom.css', '20151106' );
}
add_action( 'wp_enqueue_scripts', 'revelar_wpcom_styles' );

/**
 * De-queue Google fonts if custom fonts are being used instead.
 */
function revelar_dequeue_fonts() {
	if ( class_exists( 'TypekitData' ) && class_exists( 'CustomDesign' ) && CustomDesign::is_upgrade_active() ) {
		$custom_fonts = TypekitData::get( 'families' );
		if ( $custom_fonts && $custom_fonts['headings']['id'] && $custom_fonts['body-text']['id'] ) {
			wp_dequeue_style( 'revelar-fonts' );
		}
	}
}
add_action( 'wp_enqueue_scripts', 'revelar_dequeue_fonts' );

/**
 * Adds support for wp.com-specific theme functions.
 */
function revelar_add_wpcom_support() {
	global $themecolors;

	// Set a default theme color array for WP.com.
	if ( ! isset( $themecolors ) ) {
		$themecolors = array(
			'bg'     => 'ffffff',
			'border' => 'eeeeee',
			'text'   => '7f8c8d',
			'link'   => '00a185',
			'url'    => '00a185',
		);
	}

	add_theme_support( 'print-style' );
}
add_action( 'after_setup_theme', 'revelar_add_wpcom_support' );

/**
 * Remove the widont filter because of the limited space for post/page title in the design.
 */
function revelar_wido() {
    remove_filter( 'the_title', 'widont' );
}
add_action( 'init', 'revelar_wido' );
