<?php
/* Custom Colors: Revelar */

add_color_rule( 'bg', '#ecf0f1', array(

	// No contrast.
	array( 'body', 'background-color' ),

) );

// Not used.
add_color_rule( 'txt', '#404040', array(
) );

add_color_rule( 'link', '#00a185', array(

	array( 'a, a:visited', 'color', '#ffffff' ),

	array( 'a:hover, a:focus, a:active', 'color', '#ffffff' ),

	array( 'a:hover, a:focus, a:active', 'border-bottom-color', '#ffffff' ),

	array( '.widget a:hover, .widget a:focus, .widget a:active', 'color', 'bg' ),

	array( 'input[type="text"]:focus,
			input[type="email"]:focus,
			input[type="url"]:focus,
			input[type="password"]:focus,
			input[type="search"]:focus,
			textarea:focus', 'border-color' ),

	array( 'button,
			input[type="button"],
			input[type="reset"],
			input[type="submit"]', 'color', '#ffffff' ),

	array( 'button:hover,
			input[type="button"]:hover,
			input[type="reset"]:hover,
			input[type="submit"]:hover', 'border-color' ),

	array( 'button:hover,
			input[type="button"]:hover,
			input[type="reset"]:hover,
			input[type="submit"]:hover', 'background-color' ),

	array( '.widget button,
			.widget input[type="button"],
			.widget input[type="reset"],
			.widget input[type="submit"]', 'color', 'bg' ),

	array( '.widget button:hover,
			.widget input[type="button"]:hover,
			.widget input[type="reset"]:hover,
			.widget input[type="submit"]:hover', 'color', 'link' ),

	array( '.widget button,
			.widget input[type="button"],
			.widget input[type="reset"],
			.widget input[type="submit"],
			.widget button:hover,
			.widget input[type="button"]:hover,
			.widget input[type="reset"]:hover,
			.widget input[type="submit"]:hover', 'border-color', 'bg' ),

	array( '.comment-navigation a,
			.post-navigation a,
			.posts-navigation a,
			button,
			input[type="button"],
			input[type="reset"],
			input[type="submit"]', 'border-color' ),

	array( '.post-navigation a,
			.posts-navigation a', 'color' ),

	array( '.comment-navigation a:hover,
			.posts-navigation a:hover,
			.post-navigation a:hover', 'background-color' ),

	array( '.comment-navigation a:hover,
			.posts-navigation a:hover,
			.post-navigation a:hover', 'border-color' ),

	array( '#infinite-handle span', 'color', 'bg' ),

	array( '#infinite-handle span,
			#infinite-handle span:hover', 'border-color' ),

	array( '#infinite-handle span:hover', 'background-color' ),

	array( '.site-info a,
			.comment-metadata a:hover', 'color', '#ffffff' ),

	array( '.entry-title a:hover,
			.entry-meta a:hover', 'color', '#ffffff' ),

	array( '.menu-toggle.toggled', 'color', '#ffffff' ),

	array( '.main-navigation .current-menu-ancestor > a,
			.main-navigation .current-menu-item > a,
			.main-navigation .current_page_ancestor > a,
			.main-navigation .current_page_item > a,
			.main-navigation a:focus,
			.main-navigation a:hover,
			.menu-toggle,
			.site-branding,
			.site-header', 'background-color' ),
),
__( 'Accent color', 'revelar' ) );

// Not used.
add_color_rule( 'fg1', '#000000', array(
) );

// Not used.
add_color_rule( 'fg2', '#000000', array(
) );

add_color_rule( 'extra', '#ffffff', array(

	array( '#infinite-handle span:hover,
			.comment-navigation a:hover,
			.menu-toggle,
			.post-navigation a:hover,
			.posts-navigation a:hover,
			button:hover,
			input[type="button"]:hover,
			input[type="reset"]:hover,
			input[type="submit"]:hover', 'color', 'link' ),

	array( '.menu-toggle', 'border-color', 'link' ),

	array( '.main-navigation a:hover,
			.main-navigation a:focus', 'color', 'link' ),

	array( '.site-title a, .site-title a:visited', 'color', 'link' ),

	array( '.main-navigation li,
			.main-navigation ul ul,
			.site-footer', 'background-color' ),

) );

add_color_rule( 'extra', '#444444', array(

	array( '.entry-title a, .entry-title a:visited', 'color', '#ffffff' ),

	array( '.widget-title,
			.widget-title .rsswidget', 'color', 'bg' ),

) );

add_color_rule( 'extra', '#bdc3c8', array(

	array( '.comment-metadata,
			.comment-reply-link,
			.entry-meta,
			.entry-meta a,
			.entry-meta a:visited,
			.entry-meta span:after,
			.reply', 'color', 2 ),

	array( '.wp-caption-text', 'color', 'bg' ),

	array( '.comment-reply-link', 'border-bottom-color', '#ffffff' ),
) );

add_color_rule( 'extra', '#7f8c8d', array(

	array( '.widget,
			.widget a,
			.widget a:visited', 'color', 'bg' ),

) );

add_color_rule( 'extra', '#ecf0f1', array(

	array( '.entry-format:before', 'background-color', '-0.5' ),

) );

// Extra CSS
function revelar_extra_css() { ?>

	@media screen and (min-width: 48.0625em) {
		.site-header {
			background-color: #fff !important;
		}
	}

	.widget-area {
		background-color: rgba(0,0,0,0.2);
	}

	.blog .hentry .entry-thumbnail {
		background-color: rgba(0,0,0,0.3);
	}

<?php }
add_theme_support( 'custom_colors_extra_css', 'revelar_extra_css' );


// Additional color palettes
add_color_palette( array(
	'#ecf0f1',
	'',
	'#e2035c',
	'',
	''
), __( 'Rouge', 'revelar' ) );

add_color_palette( array(
	'#e9e9e9',
	'',
	'#333333',
	'',
	''
), __( 'Charcoal', 'revelar' ) );

add_color_palette( array(
	'#3e4147',
	'',
	'#dfba69',
	'',
	''
), __( 'Dark', 'revelar' ) );

add_color_palette( array(
	'#e9eaeb',
	'',
	'#1395cd',
	'',
	'',
), __( 'Blue', 'revelar' ) );

add_color_palette( array(
	'#c3cfd4',
	'',
	'#365a67',
	'',
	''
), __( 'Smoke', 'revelar' ) );

add_color_palette( array(
	'#f7f7f7',
	'',
	'#9cc954',
	'',
	'',
), __( 'Leaf', 'revelar' ) );
