<?php
/**
 * Title: Home Page Features
 * slug: cultivate/home-features
 * categories: featured, call-to-action 
 */
?>

<!-- wp:columns {"align":"wide","style":{"spacing":{"margin":{"top":"30px","bottom":"90px"}}}} -->
<div class="wp-block-columns alignwide" style="margin-top:30px;margin-bottom:90px"><!-- wp:column -->
<div class="wp-block-column"><!-- wp:group {"style":{"border":{"width":"2px"},"spacing":{"blockGap":"10px","padding":{"top":"20px","right":"30px","bottom":"30px","left":"30px"}}},"borderColor":"foreground","backgroundColor":"white","layout":{"type":"flex","orientation":"vertical","justifyContent":"center"}} -->
<div class="wp-block-group has-border-color has-foreground-border-color has-white-background-color has-background" style="border-width:2px;padding-top:20px;padding-right:30px;padding-bottom:30px;padding-left:30px"><!-- wp:image {"width":100,"height":100,"sizeSlug":"full","linkDestination":"none"} -->
<figure class="wp-block-image size-full is-resized"><img src="<?php echo esc_url( get_template_directory_uri() ) . '/assets/icons/donate_icon.png'; ?>" alt="" width="100" height="100"/></figure>
<!-- /wp:image -->

<!-- wp:paragraph {"align":"center"} -->
<p class="has-text-align-center"><strong><?php echo esc_html__( 'Donate', 'cultivate' ); ?></strong></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"align":"center","fontSize":"small"} -->
<p class="has-text-align-center has-small-font-size"><?php echo esc_html__( 'Your generous donation helps our nonprofit support the local community gardens and gardeners!', 'cultivate' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->

<!-- wp:column -->
<div class="wp-block-column"><!-- wp:group {"style":{"border":{"width":"2px"},"spacing":{"blockGap":"10px","padding":{"top":"20px","right":"30px","bottom":"30px","left":"30px"}}},"borderColor":"foreground","backgroundColor":"white","layout":{"type":"flex","orientation":"vertical","justifyContent":"center"}} -->
<div class="wp-block-group has-border-color has-foreground-border-color has-white-background-color has-background" style="border-width:2px;padding-top:20px;padding-right:30px;padding-bottom:30px;padding-left:30px"><!-- wp:image {"width":100,"height":100,"sizeSlug":"full","linkDestination":"none"} -->
<figure class="wp-block-image size-full is-resized"><img src="<?php echo esc_url( get_template_directory_uri() ) . '/assets/icons/heart_icon.png'; ?>" alt="" width="100" height="100"/></figure>
<!-- /wp:image -->

<!-- wp:paragraph {"align":"center"} -->
<p class="has-text-align-center"><strong><?php echo esc_html__( 'Volunteer', 'cultivate' ); ?></strong></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"align":"center","fontSize":"small"} -->
<p class="has-text-align-center has-small-font-size"><?php echo esc_html__( 'Whether a short-term event, project, or longer-term commitment, we welcome you to join the effort.', 'cultivate' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->

<!-- wp:column -->
<div class="wp-block-column"><!-- wp:group {"style":{"border":{"width":"2px"},"spacing":{"blockGap":"10px","padding":{"top":"20px","right":"30px","bottom":"30px","left":"30px"}}},"borderColor":"foreground","backgroundColor":"white","layout":{"type":"flex","orientation":"vertical","justifyContent":"center"}} -->
<div class="wp-block-group has-border-color has-foreground-border-color has-white-background-color has-background" style="border-width:2px;padding-top:20px;padding-right:30px;padding-bottom:30px;padding-left:30px"><!-- wp:image {"width":100,"height":100,"sizeSlug":"full","linkDestination":"none"} -->
<figure class="wp-block-image size-full is-resized"><img src="<?php echo esc_url( get_template_directory_uri() ) . '/assets/icons/spade_icon.png'; ?>" alt="" width="100" height="100"/></figure>
<!-- /wp:image -->

<!-- wp:paragraph {"align":"center"} -->
<p class="has-text-align-center"><strong><?php echo esc_html__( 'Adopt a Plot', 'cultivate' ); ?></strong></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"align":"center","fontSize":"small"} -->
<p class="has-text-align-center has-small-font-size"><?php echo esc_html__( 'Our members range from first-time gardeners to master gardeners happy to share their knowledge.', 'cultivate' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:column --></div>
<!-- /wp:columns -->