/**
 * External dependencies
 */
import { __ } from '@wordpress/i18n';

const SvgComponent = ( {
	text,
	image,
}: {
	text: React.ReactNode;
	image: React.ReactNode;
} ) => (
	<svg
		width="100%"
		height="100%"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
		xmlnsXlink="http://www.w3.org/1999/xlink"
		preserveAspectRatio="none"
		viewBox="0 0 840 458"
	>
		<g filter="url(#a)" transform="translate(90)">
			<rect
				x={ 19.234 }
				y={ 19 }
				width={ 624.535 }
				height={ 390 }
				rx={ 10 }
				fill="#fff"
			/>
			<rect
				opacity={ 0.5 }
				x={ 371.539 }
				y={ 217 }
				width={ 190.163 }
				height={ 8 }
				rx={ 4 }
				fill="#DCDCDE"
			/>
			<rect
				opacity={ 0.5 }
				x={ 371.539 }
				y={ 233 }
				width={ 210.18 }
				height={ 8 }
				rx={ 4 }
				fill="#DCDCDE"
			/>
			<rect
				opacity={ 0.5 }
				x={ 371.539 }
				y={ 249 }
				width={ 130.111 }
				height={ 8 }
				rx={ 4 }
				fill="#DCDCDE"
			/>
			<rect
				x={ 371.539 }
				y={ 281 }
				width={ 144.123 }
				height={ 25 }
				rx={ 4 }
				fill="#F6F7F7"
			/>
			<rect
				x={ 523.672 }
				y={ 281 }
				width={ 79 }
				height={ 25 }
				rx={ 4 }
				fill="#007CBA"
			/>
			<g mask="url(#mask0_1263_16533)">
				<path fill="url(#pattern1)" d="M17-53h371v465H17z" />
				<path fill="url(#pattern2)" d="M-138 42h643v428h-643z" />
			</g>
			<path
				opacity={ 0.5 }
				d="M19.234 29c0-5.523 4.477-10 10-10H633.77c5.523 0 10 4.477 10 10v14H19.234V29Z"
				fill="#DCDCDE"
			/>
			<ellipse
				cx={ 55.268 }
				cy={ 31 }
				rx={ 3.003 }
				ry={ 3 }
				fill="#fff"
			/>
			<ellipse
				cx={ 45.257 }
				cy={ 31 }
				rx={ 3.003 }
				ry={ 3 }
				fill="#fff"
			/>
			<ellipse
				cx={ 35.253 }
				cy={ 31 }
				rx={ 3.003 }
				ry={ 3 }
				fill="#fff"
			/>
			<defs>
				<filter
					id="a"
					x={ 0.688 }
					y={ 0.454 }
					width={ 661.628 }
					height={ 427.092 }
					filterUnits="userSpaceOnUse"
					colorInterpolationFilters="sRGB"
				>
					<feFlood floodOpacity={ 0 } result="BackgroundImageFix" />
					<feColorMatrix
						in="SourceAlpha"
						values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
						result="hardAlpha"
					/>
					<feOffset />
					<feGaussianBlur stdDeviation={ 9.273 } />
					<feColorMatrix values="0 0 0 0 0.65098 0 0 0 0 0.65098 0 0 0 0 0.65098 0 0 0 0.2 0" />
					<feBlend
						in2="BackgroundImageFix"
						result="effect1_dropShadow_1263_16533"
					/>
					<feBlend
						in="SourceGraphic"
						in2="effect1_dropShadow_1263_16533"
						result="shape"
					/>
				</filter>
			</defs>
		</g>

		<foreignObject
			x="0"
			y="0"
			width="313px"
			height="366px"
			transform="translate(109, 42)"
		>
			<img
				src={ image }
				style={ { borderBottomLeftRadius: '10px' } }
				alt={ __( 'Browser image', 'wc-calypso-bridge' ) }
			/>
		</foreignObject>
		<g filter="url(#b)" transform="translate(558 170)">
			<rect
				x={ 120 }
				y={ 24 }
				width={ 140 }
				height={ 140 }
				rx={ 10 }
				fill="url(#c)"
				shapeRendering="crispEdges"
			/>
		</g>
		<defs>
			<pattern
				id="c"
				patternContentUnits="objectBoundingBox"
				width={ 1 }
				height={ 1 }
			>
				<use
					xlinkHref="#d"
					transform="matrix(.00313 0 0 .00308 0 -.313)"
				/>
			</pattern>
			<filter
				id="b"
				x={ 120 }
				y={ 0 }
				width={ 208 }
				height={ 208 }
				filterUnits="userSpaceOnUse"
				colorInterpolationFilters="sRGB"
			>
				<feFlood floodOpacity={ 0 } result="BackgroundImageFix" />
				<feColorMatrix
					in="SourceAlpha"
					values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
					result="hardAlpha"
				/>
				<feOffset dy={ 10 } />
				<feGaussianBlur stdDeviation={ 17 } />
				<feComposite in2="hardAlpha" operator="out" />
				<feColorMatrix values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.07 0" />
				<feBlend
					in2="BackgroundImageFix"
					result="effect1_dropShadow_1266_16613"
				/>
				<feBlend
					in="SourceGraphic"
					in2="effect1_dropShadow_1266_16613"
					result="shape"
				/>
			</filter>
			<image
				id="d"
				width={ 320 }
				height={ 480 }
				xlinkHref="data:image/jpeg;base64,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"
			/>
		</defs>
		<g filter="url(#e)" transform="translate(-15 130)">
			<rect
				x={ 34.992 }
				y={ 24 }
				width={ 140 }
				height={ 140 }
				rx={ 10 }
				fill="#E8F1FE"
			/>
			<rect
				x={ 69.996 }
				y={ 59 }
				width={ 70 }
				height={ 70 }
				rx={ 8 }
				fill="url(#f)"
			/>
		</g>
		<defs>
			<pattern
				id="f"
				patternContentUnits="objectBoundingBox"
				width={ 1 }
				height={ 1 }
			>
				<use xlinkHref="#g" transform="scale(.00444)" />
			</pattern>
			<filter
				id="e"
				x={ 0.966 }
				y={ 0.607 }
				width={ 208.052 }
				height={ 208.052 }
				filterUnits="userSpaceOnUse"
				colorInterpolationFilters="sRGB"
			>
				<feFlood floodOpacity={ 0 } result="BackgroundImageFix" />
				<feColorMatrix
					in="SourceAlpha"
					values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
					result="hardAlpha"
				/>
				<feOffset dy={ 10.633 } />
				<feGaussianBlur stdDeviation={ 17.013 } />
				<feColorMatrix values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.07 0" />
				<feBlend
					in2="BackgroundImageFix"
					result="effect1_dropShadow_1266_16560"
				/>
				<feBlend
					in="SourceGraphic"
					in2="effect1_dropShadow_1266_16560"
					result="shape"
				/>
			</filter>
			<image
				id="g"
				width={ 225 }
				height={ 225 }
				xlinkHref="data:image/png;base64,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"
			/>
		</defs>
		{ /** Google search bar */ }
		<g filter="url(#h)" transform="translate(165 350)">
			<rect
				x={ 36.992 }
				y={ 30 }
				width={ 410 }
				height={ 50 }
				rx={ 25 }
				fill="#fff"
			/>
			<g clipPath="url(#i)">
				<path
					d="m59.299 57.5-.834 3.113-3.049.065A11.926 11.926 0 0 1 53.988 55c0-1.987.483-3.86 1.34-5.51l2.714.498 1.19 2.697A7.123 7.123 0 0 0 58.846 55c0 .88.16 1.722.452 2.5Z"
					fill="#FBBB00"
				/>
				<path
					d="M77.742 52.762a12.004 12.004 0 0 1-.053 4.74 11.978 11.978 0 0 1-4.217 6.841h-.001l-3.419-.175-.483-3.02a7.14 7.14 0 0 0 3.072-3.646h-6.407v-4.74h11.508Z"
					fill="#518EF8"
				/>
				<path
					d="m73.47 64.342.001.001a11.93 11.93 0 0 1-7.5 2.638c-4.563 0-8.53-2.55-10.553-6.303l3.883-3.178a7.124 7.124 0 0 0 10.267 3.648l3.903 3.194Z"
					fill="#28B446"
				/>
				<path
					d="m73.613 45.778-3.882 3.177a7.126 7.126 0 0 0-10.504 3.73l-3.902-3.195a11.978 11.978 0 0 1 10.64-6.47 11.93 11.93 0 0 1 7.648 2.758Z"
					fill="#F14336"
				/>
			</g>
			<mask
				id="j"
				style={ {
					maskType: 'luminance',
				} }
				maskUnits="userSpaceOnUse"
				x={ 406 }
				y={ 45 }
				width={ 21 }
				height={ 20 }
			>
				<path
					fillRule="evenodd"
					clipRule="evenodd"
					d="M419.751 57.57h.896l5.658 5.697-1.689 1.698-5.67-5.686v-.9l-.306-.32a7.318 7.318 0 0 1-4.797 1.79c-4.071 0-7.37-3.316-7.37-7.407s3.299-7.407 7.37-7.407 7.371 3.316 7.371 7.407a7.396 7.396 0 0 1-1.78 4.82l.317.308Zm-11.011-5.128c0 2.837 2.279 5.128 5.103 5.128s5.103-2.29 5.103-5.128-2.279-5.128-5.103-5.128-5.103 2.29-5.103 5.128Z"
					fill="#fff"
				/>
			</mask>
			<g mask="url(#j)">
				<path
					fill="#FFAB66"
					d="M402.781 41.326h27.215v27.349h-27.215z"
				/>
			</g>
		</g>
		<defs>
			<clipPath id="i">
				<path
					fill="#fff"
					transform="translate(53.988 43.02)"
					d="M0 0h23.962v23.962H0z"
				/>
			</clipPath>
			<filter
				id="h"
				x={ 0.662 }
				y={ 0.275 }
				width={ 482.661 }
				height={ 122.661 }
				filterUnits="userSpaceOnUse"
				colorInterpolationFilters="sRGB"
			>
				<feFlood floodOpacity={ 0 } result="BackgroundImageFix" />
				<feColorMatrix
					in="SourceAlpha"
					values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
					result="hardAlpha"
				/>
				<feOffset dy={ 6.606 } />
				<feGaussianBlur stdDeviation={ 18.165 } />
				<feColorMatrix values="0 0 0 0 0.397708 0 0 0 0 0.47749 0 0 0 0 0.575 0 0 0 0.1 0" />
				<feBlend
					in2="BackgroundImageFix"
					result="effect1_dropShadow_1266_16579"
				/>
				<feBlend
					in="SourceGraphic"
					in2="effect1_dropShadow_1266_16579"
					result="shape"
				/>
			</filter>
		</defs>

		<foreignObject x={ 463 } y={ 90 } width={ 180 } height={ 200 }>
			<h2 xmlns="http://www.w3.org/1999/xhtml">{ text }</h2>
		</foreignObject>
	</svg>
);

export default SvgComponent;
