<?php
/**
 * WP_REST_Help_Center_Jetpack_Search_AI file.
 *
 * @package automattic/jetpack-mu-wpcom
 */

namespace A8C\FSE;

use Automattic\Jetpack\Connection\Client;

/**
 * Class WP_REST_Help_Center_Jetpack_Search_AI.
 */
class WP_REST_Help_Center_Jetpack_Search_AI extends \WP_REST_Controller {
	/**
	 * WP_REST_Help_Center_Jetpack_Search_AI constructor.
	 */
	public function __construct() {
		$this->namespace = 'help-center';
		$this->rest_base = '/jetpack-search/ai';
	}

	/**
	 * Register available routes.
	 */
	public function register_rest_route() {
		register_rest_route(
			$this->namespace,
			$this->rest_base . '/search',
			array(
				'methods'             => \WP_REST_Server::READABLE,
				'callback'            => array( $this, 'get_search_results' ),
				'permission_callback' => 'is_user_logged_in',
			)
		);
	}

	/**
	 * Should return the sibyl articles.
	 *
	 * @param \WP_REST_Request $request The request sent to the API.
	 */
	public function get_search_results( \WP_REST_Request $request ) {
		$query_parameters = array(
			'query'   => $request['query'],
			'stop_at' => $request['stop_at'],
		);
		$body             = Client::wpcom_json_api_request_as_user(
			'sites/' . $request['site'] . '/jetpack-search/ai/search?' . http_build_query( $query_parameters ),
			'2',
			array(
				'timeout' => 75,
			)
		);

		if ( is_wp_error( $body ) ) {
			return $body;
		}

		$response = json_decode( wp_remote_retrieve_body( $body ) );

		return rest_ensure_response( $response );
	}
}
