/* DUPLICATOR-PRO (PHP MULTI-THREADED BUILD MODE) MYSQL SCRIPT CREATED ON : 2025-08-03 18:59:02 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;

CREATE TABLE IF NOT EXISTS `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(255) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT 0,
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=263052660 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE IF NOT EXISTS `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=661 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE IF NOT EXISTS `wp_bp_activity` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `component` varchar(75) NOT NULL,
  `type` varchar(75) NOT NULL,
  `action` text NOT NULL,
  `content` longtext NOT NULL,
  `primary_link` text NOT NULL,
  `item_id` bigint(20) NOT NULL,
  `secondary_item_id` bigint(20) DEFAULT NULL,
  `date_recorded` datetime NOT NULL,
  `hide_sitewide` tinyint(1) DEFAULT 0,
  `mptt_left` int(11) NOT NULL DEFAULT 0,
  `mptt_right` int(11) NOT NULL DEFAULT 0,
  `is_spam` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `date_recorded` (`date_recorded`),
  KEY `user_id` (`user_id`),
  KEY `item_id` (`item_id`),
  KEY `secondary_item_id` (`secondary_item_id`),
  KEY `component` (`component`),
  KEY `type` (`type`),
  KEY `mptt_left` (`mptt_left`),
  KEY `mptt_right` (`mptt_right`),
  KEY `hide_sitewide` (`hide_sitewide`),
  KEY `is_spam` (`is_spam`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE IF NOT EXISTS `wp_bp_activity_meta` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `activity_id` bigint(20) NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `activity_id` (`activity_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE IF NOT EXISTS `wp_bp_friends` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `initiator_user_id` bigint(20) NOT NULL,
  `friend_user_id` bigint(20) NOT NULL,
  `is_confirmed` tinyint(1) DEFAULT 0,
  `is_limited` tinyint(1) DEFAULT 0,
  `date_created` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `initiator_user_id` (`initiator_user_id`),
  KEY `friend_user_id` (`friend_user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE IF NOT EXISTS `wp_bp_groups` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `creator_id` bigint(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `slug` varchar(200) NOT NULL,
  `description` longtext NOT NULL,
  `status` varchar(10) NOT NULL DEFAULT 'public',
  `parent_id` bigint(20) NOT NULL DEFAULT 0,
  `enable_forum` tinyint(1) NOT NULL DEFAULT 1,
  `date_created` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `creator_id` (`creator_id`),
  KEY `status` (`status`),
  KEY `parent_id` (`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE IF NOT EXISTS `wp_bp_groups_groupmeta` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `group_id` bigint(20) NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `group_id` (`group_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE IF NOT EXISTS `wp_bp_groups_members` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `group_id` bigint(20) NOT NULL,
  `user_id` bigint(20) NOT NULL,
  `inviter_id` bigint(20) NOT NULL,
  `is_admin` tinyint(1) NOT NULL DEFAULT 0,
  `is_mod` tinyint(1) NOT NULL DEFAULT 0,
  `user_title` varchar(100) NOT NULL,
  `date_modified` datetime NOT NULL,
  `comments` longtext NOT NULL,
  `is_confirmed` tinyint(1) NOT NULL DEFAULT 0,
  `is_banned` tinyint(1) NOT NULL DEFAULT 0,
  `invite_sent` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `group_id` (`group_id`),
  KEY `is_admin` (`is_admin`),
  KEY `is_mod` (`is_mod`),
  KEY `user_id` (`user_id`),
  KEY `inviter_id` (`inviter_id`),
  KEY `is_confirmed` (`is_confirmed`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE IF NOT EXISTS `wp_bp_invitations` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `inviter_id` bigint(20) NOT NULL,
  `invitee_email` varchar(100) DEFAULT NULL,
  `class` varchar(120) NOT NULL,
  `item_id` bigint(20) NOT NULL,
  `secondary_item_id` bigint(20) DEFAULT NULL,
  `type` varchar(12) NOT NULL DEFAULT 'invite',
  `content` longtext DEFAULT '',
  `date_modified` datetime NOT NULL,
  `invite_sent` tinyint(1) NOT NULL DEFAULT 0,
  `accepted` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `inviter_id` (`inviter_id`),
  KEY `invitee_email` (`invitee_email`),
  KEY `class` (`class`),
  KEY `item_id` (`item_id`),
  KEY `secondary_item_id` (`secondary_item_id`),
  KEY `type` (`type`),
  KEY `invite_sent` (`invite_sent`),
  KEY `accepted` (`accepted`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE IF NOT EXISTS `wp_bp_messages_messages` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `thread_id` bigint(20) NOT NULL,
  `sender_id` bigint(20) NOT NULL,
  `subject` varchar(200) NOT NULL,
  `message` longtext NOT NULL,
  `date_sent` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `sender_id` (`sender_id`),
  KEY `thread_id` (`thread_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE IF NOT EXISTS `wp_bp_messages_meta` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `message_id` bigint(20) NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `message_id` (`message_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE IF NOT EXISTS `wp_bp_messages_notices` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `subject` varchar(200) NOT NULL,
  `message` longtext NOT NULL,
  `date_sent` datetime NOT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `is_active` (`is_active`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE IF NOT EXISTS `wp_bp_messages_recipients` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `thread_id` bigint(20) NOT NULL,
  `unread_count` int(10) NOT NULL DEFAULT 0,
  `sender_only` tinyint(1) NOT NULL DEFAULT 0,
  `is_deleted` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `thread_id` (`thread_id`),
  KEY `is_deleted` (`is_deleted`),
  KEY `sender_only` (`sender_only`),
  KEY `unread_count` (`unread_count`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE IF NOT EXISTS `wp_bp_notifications` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `item_id` bigint(20) NOT NULL,
  `secondary_item_id` bigint(20) DEFAULT NULL,
  `component_name` varchar(75) NOT NULL,
  `component_action` varchar(75) NOT NULL,
  `date_notified` datetime NOT NULL,
  `is_new` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `item_id` (`item_id`),
  KEY `secondary_item_id` (`secondary_item_id`),
  KEY `user_id` (`user_id`),
  KEY `is_new` (`is_new`),
  KEY `component_name` (`component_name`),
  KEY `component_action` (`component_action`),
  KEY `useritem` (`user_id`,`is_new`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE IF NOT EXISTS `wp_bp_notifications_meta` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `notification_id` bigint(20) NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `notification_id` (`notification_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE IF NOT EXISTS `wp_bp_optouts` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `email_address_hash` varchar(255) NOT NULL,
  `user_id` bigint(20) NOT NULL,
  `email_type` varchar(255) NOT NULL,
  `date_modified` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `email_type` (`email_type`),
  KEY `date_modified` (`date_modified`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE IF NOT EXISTS `wp_bp_user_blogs` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `blog_id` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `blog_id` (`blog_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE IF NOT EXISTS `wp_bp_user_blogs_blogmeta` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `blog_id` bigint(20) NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `blog_id` (`blog_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE IF NOT EXISTS `wp_bp_xprofile_data` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `field_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `value` longtext NOT NULL,
  `last_updated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `field_id` (`field_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE IF NOT EXISTS `wp_bp_xprofile_fields` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `group_id` bigint(20) unsigned NOT NULL,
  `parent_id` bigint(20) unsigned NOT NULL,
  `type` varchar(150) NOT NULL,
  `name` varchar(150) NOT NULL,
  `description` longtext NOT NULL,
  `is_required` tinyint(1) NOT NULL DEFAULT 0,
  `is_default_option` tinyint(1) NOT NULL DEFAULT 0,
  `field_order` bigint(20) NOT NULL DEFAULT 0,
  `option_order` bigint(20) NOT NULL DEFAULT 0,
  `order_by` varchar(15) NOT NULL DEFAULT '',
  `can_delete` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `group_id` (`group_id`),
  KEY `parent_id` (`parent_id`),
  KEY `field_order` (`field_order`),
  KEY `can_delete` (`can_delete`),
  KEY `is_required` (`is_required`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE IF NOT EXISTS `wp_bp_xprofile_groups` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(150) NOT NULL,
  `description` mediumtext NOT NULL,
  `group_order` bigint(20) NOT NULL DEFAULT 0,
  `can_delete` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `can_delete` (`can_delete`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE IF NOT EXISTS `wp_bp_xprofile_meta` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `object_id` bigint(20) NOT NULL,
  `object_type` varchar(150) NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `object_id` (`object_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE IF NOT EXISTS `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE IF NOT EXISTS `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE IF NOT EXISTS `wp_duplicator_activity_logs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(100) NOT NULL,
  `sub_type` varchar(100) NOT NULL,
  `severity` int(8) NOT NULL,
  `title` text NOT NULL,
  `data` longtext NOT NULL,
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `version` varchar(30) NOT NULL DEFAULT '',
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `type_idx` (`type`),
  KEY `sub_type_idx` (`sub_type`),
  KEY `severity_idx` (`severity`),
  KEY `created_at` (`created_at`),
  KEY `updated_at` (`updated_at`),
  KEY `version` (`version`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE IF NOT EXISTS `wp_duplicator_backups` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(100) NOT NULL,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `archive_name` varchar(350) NOT NULL DEFAULT '',
  `status` int(11) NOT NULL,
  `flags` set('MANUAL','SCHEDULE','SCHEDULE_RUN_NOW','DB_ONLY','MEDIA_ONLY','HAVE_LOCAL','HAVE_REMOTE','DISASTER_AVAIABLE','DISASTER_SET','CREATED_AFTER_RESTORE','ACTIVE','TEMPLATE','ZIP_ARCHIVE','DUP_ARCHIVE','TEMPORARY') NOT NULL DEFAULT '',
  `package` longtext NOT NULL,
  `version` varchar(30) NOT NULL DEFAULT '',
  `created` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `type_idx` (`type`),
  KEY `hash` (`hash`),
  KEY `flags` (`flags`),
  KEY `version` (`version`),
  KEY `created` (`created`),
  KEY `updated_at` (`updated_at`),
  KEY `status` (`status`),
  KEY `name` (`name`(191)),
  KEY `archive_name` (`archive_name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE IF NOT EXISTS `wp_duplicator_entities` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(100) NOT NULL,
  `value_1` varchar(255) NOT NULL DEFAULT '',
  `value_2` varchar(255) NOT NULL DEFAULT '',
  `value_3` varchar(255) NOT NULL DEFAULT '',
  `value_4` varchar(255) NOT NULL DEFAULT '',
  `value_5` varchar(255) NOT NULL DEFAULT '',
  `data` longtext NOT NULL,
  `version` varchar(30) NOT NULL DEFAULT '',
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `type_idx` (`type`),
  KEY `created_at` (`created_at`),
  KEY `updated_at` (`updated_at`),
  KEY `version` (`version`),
  KEY `value_1` (`value_1`(191)),
  KEY `value_2` (`value_2`(191)),
  KEY `value_3` (`value_3`(191)),
  KEY `value_4` (`value_4`(191)),
  KEY `value_5` (`value_5`(191))
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE IF NOT EXISTS `wp_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE IF NOT EXISTS `wp_e_events` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `event_data` text DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `created_at_index` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE IF NOT EXISTS `wp_frm_fields` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `field_key` varchar(100) DEFAULT NULL,
  `name` text DEFAULT NULL,
  `description` longtext DEFAULT NULL,
  `type` text DEFAULT NULL,
  `default_value` longtext DEFAULT NULL,
  `options` longtext DEFAULT NULL,
  `field_order` int(11) DEFAULT 0,
  `required` int(1) DEFAULT NULL,
  `field_options` longtext DEFAULT NULL,
  `form_id` int(11) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `field_key` (`field_key`),
  KEY `form_id` (`form_id`),
  KEY `idx_form_id_type` (`form_id`,`type`(30))
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE IF NOT EXISTS `wp_frm_forms` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `form_key` varchar(100) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `parent_form_id` int(11) DEFAULT 0,
  `logged_in` tinyint(1) DEFAULT NULL,
  `editable` tinyint(1) DEFAULT NULL,
  `is_template` tinyint(1) DEFAULT 0,
  `default_template` tinyint(1) DEFAULT 0,
  `status` varchar(255) DEFAULT NULL,
  `options` longtext DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `form_key` (`form_key`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE IF NOT EXISTS `wp_frm_items` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `item_key` varchar(100) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `ip` text DEFAULT NULL,
  `form_id` bigint(20) DEFAULT NULL,
  `post_id` bigint(20) DEFAULT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `parent_item_id` bigint(20) DEFAULT 0,
  `is_draft` tinyint(1) DEFAULT 0,
  `updated_by` bigint(20) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `item_key` (`item_key`),
  KEY `form_id` (`form_id`),
  KEY `post_id` (`post_id`),
  KEY `user_id` (`user_id`),
  KEY `parent_item_id` (`parent_item_id`),
  KEY `idx_is_draft_created_at` (`is_draft`,`created_at`),
  KEY `idx_form_id_is_draft` (`form_id`,`is_draft`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE IF NOT EXISTS `wp_frm_item_metas` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `meta_value` longtext DEFAULT NULL,
  `field_id` bigint(20) NOT NULL,
  `item_id` bigint(20) NOT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `field_id` (`field_id`),
  KEY `item_id` (`item_id`),
  KEY `idx_field_id_item_id` (`field_id`,`item_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE IF NOT EXISTS `wp_jetpack_sync_queue` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `queue_id` varchar(50) NOT NULL,
  `event_id` varchar(100) NOT NULL,
  `event_payload` longtext NOT NULL,
  `timestamp` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`ID`),
  KEY `event_id` (`event_id`),
  KEY `queue_id` (`queue_id`),
  KEY `queue_id_event_id` (`queue_id`,`event_id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB AUTO_INCREMENT=11271 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE IF NOT EXISTS `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE IF NOT EXISTS `wp_mwai_filemeta` (
  `meta_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `file_id` bigint(20) NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE IF NOT EXISTS `wp_mwai_files` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `refId` varchar(64) NOT NULL,
  `envId` varchar(128) DEFAULT NULL,
  `userId` bigint(20) unsigned DEFAULT NULL,
  `type` varchar(32) DEFAULT NULL,
  `status` varchar(32) DEFAULT NULL,
  `purpose` varchar(32) DEFAULT NULL,
  `created` datetime NOT NULL,
  `updated` datetime NOT NULL,
  `expires` datetime DEFAULT NULL,
  `path` text DEFAULT NULL,
  `url` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_file_id` (`refId`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE IF NOT EXISTS `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=14323 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE IF NOT EXISTS `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`)
) ENGINE=InnoDB AUTO_INCREMENT=13391 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE IF NOT EXISTS `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT 0,
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(255) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT 0,
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=1337 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE IF NOT EXISTS `wp_signups` (
  `signup_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `domain` varchar(200) NOT NULL DEFAULT '',
  `path` varchar(100) NOT NULL DEFAULT '',
  `title` longtext NOT NULL,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `activated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `active` tinyint(1) NOT NULL DEFAULT 0,
  `activation_key` varchar(50) NOT NULL DEFAULT '',
  `meta` longtext DEFAULT NULL,
  PRIMARY KEY (`signup_id`),
  KEY `activation_key` (`activation_key`),
  KEY `user_email` (`user_email`),
  KEY `user_login_email` (`user_login`,`user_email`),
  KEY `domain_path` (`domain`(140),`path`(51))
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE IF NOT EXISTS `wp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE IF NOT EXISTS `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`),
  KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=16110 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE IF NOT EXISTS `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_order` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE IF NOT EXISTS `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE IF NOT EXISTS `wp_wpgmza` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `map_id` int(11) NOT NULL,
  `address` varchar(700) NOT NULL,
  `description` mediumtext NOT NULL,
  `pic` varchar(700) NOT NULL,
  `link` varchar(2083) NOT NULL,
  `icon` varchar(700) NOT NULL,
  `lat` varchar(100) NOT NULL,
  `lng` varchar(100) NOT NULL,
  `anim` varchar(3) NOT NULL,
  `title` varchar(700) NOT NULL,
  `infoopen` varchar(3) NOT NULL,
  `category` varchar(500) NOT NULL,
  `approved` tinyint(1) DEFAULT 1,
  `retina` tinyint(1) DEFAULT 0,
  `type` tinyint(1) DEFAULT 0,
  `did` varchar(500) NOT NULL,
  `sticky` tinyint(1) DEFAULT 0,
  `other_data` longtext NOT NULL,
  `latlng` point DEFAULT NULL,
  `layergroup` int(3) DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE IF NOT EXISTS `wp_wpgmza_admin_notices` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `message` text DEFAULT NULL,
  `active_date` datetime DEFAULT NULL,
  `options` longtext DEFAULT NULL,
  `dismissed` tinyint(1) DEFAULT 1,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE IF NOT EXISTS `wp_wpgmza_circles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `map_id` int(11) NOT NULL,
  `name` text DEFAULT NULL,
  `center` point DEFAULT NULL,
  `radius` float DEFAULT NULL,
  `color` varchar(16) DEFAULT NULL,
  `opacity` float DEFAULT NULL,
  `lineColor` varchar(16) DEFAULT NULL,
  `lineOpacity` float DEFAULT 0,
  `description` text DEFAULT NULL,
  `hoverEnabled` tinyint(1) DEFAULT 0,
  `ohFillColor` varchar(16) DEFAULT NULL,
  `ohLineColor` varchar(16) DEFAULT NULL,
  `ohFillOpacity` float DEFAULT NULL,
  `ohLineOpacity` float DEFAULT NULL,
  `link` varchar(700) NOT NULL,
  `layergroup` int(3) DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE IF NOT EXISTS `wp_wpgmza_image_overlays` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `map_id` int(11) NOT NULL,
  `name` text DEFAULT NULL,
  `cornerA` point DEFAULT NULL,
  `cornerB` point DEFAULT NULL,
  `image` varchar(700) DEFAULT NULL,
  `opacity` float DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE IF NOT EXISTS `wp_wpgmza_maps` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `map_title` varchar(256) NOT NULL,
  `map_width` varchar(6) NOT NULL,
  `map_height` varchar(6) NOT NULL,
  `map_start_lat` varchar(700) NOT NULL,
  `map_start_lng` varchar(700) NOT NULL,
  `map_start_location` varchar(700) NOT NULL,
  `map_start_zoom` int(10) NOT NULL,
  `default_marker` varchar(700) NOT NULL,
  `type` int(10) NOT NULL,
  `alignment` int(10) NOT NULL,
  `directions_enabled` int(10) NOT NULL,
  `styling_enabled` int(10) NOT NULL,
  `styling_json` mediumtext NOT NULL,
  `active` int(1) NOT NULL,
  `kml` varchar(700) NOT NULL,
  `bicycle` int(10) NOT NULL,
  `traffic` int(10) NOT NULL,
  `dbox` int(10) NOT NULL,
  `dbox_width` varchar(10) NOT NULL,
  `listmarkers` int(10) NOT NULL,
  `listmarkers_advanced` int(10) NOT NULL,
  `filterbycat` tinyint(1) NOT NULL,
  `ugm_enabled` int(10) NOT NULL,
  `ugm_category_enabled` tinyint(1) NOT NULL,
  `fusion` varchar(100) NOT NULL,
  `map_width_type` varchar(3) NOT NULL,
  `map_height_type` varchar(3) NOT NULL,
  `mass_marker_support` int(10) NOT NULL,
  `ugm_access` int(10) NOT NULL,
  `order_markers_by` int(10) NOT NULL,
  `order_markers_choice` int(10) NOT NULL,
  `show_user_location` int(3) NOT NULL,
  `default_to` varchar(700) NOT NULL,
  `other_settings` longtext NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE IF NOT EXISTS `wp_wpgmza_point_labels` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `map_id` int(11) NOT NULL,
  `name` text DEFAULT NULL,
  `center` point DEFAULT NULL,
  `fillColor` varchar(16) DEFAULT NULL,
  `lineColor` varchar(16) DEFAULT NULL,
  `opacity` float DEFAULT NULL,
  `fontSize` varchar(3) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE IF NOT EXISTS `wp_wpgmza_polygon` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `map_id` int(11) NOT NULL,
  `polydata` longtext NOT NULL,
  `description` text NOT NULL,
  `innerpolydata` longtext NOT NULL,
  `linecolor` varchar(7) NOT NULL,
  `lineopacity` varchar(7) NOT NULL,
  `fillcolor` varchar(7) NOT NULL,
  `opacity` varchar(3) NOT NULL,
  `title` varchar(250) NOT NULL,
  `link` varchar(700) NOT NULL,
  `ohfillcolor` varchar(7) NOT NULL,
  `ohlinecolor` varchar(7) NOT NULL,
  `ohopacity` varchar(3) NOT NULL,
  `polyname` varchar(100) NOT NULL,
  `linethickness` varchar(3) NOT NULL,
  `layergroup` int(3) DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE IF NOT EXISTS `wp_wpgmza_polylines` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `map_id` int(11) NOT NULL,
  `polydata` longtext NOT NULL,
  `linecolor` varchar(7) NOT NULL,
  `linethickness` varchar(3) NOT NULL,
  `opacity` varchar(3) NOT NULL,
  `polyname` varchar(100) NOT NULL,
  `layergroup` int(3) DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE IF NOT EXISTS `wp_wpgmza_rectangles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `map_id` int(11) NOT NULL,
  `name` text DEFAULT NULL,
  `cornerA` point DEFAULT NULL,
  `cornerB` point DEFAULT NULL,
  `color` varchar(16) DEFAULT NULL,
  `opacity` float DEFAULT NULL,
  `lineColor` varchar(16) DEFAULT NULL,
  `lineOpacity` float DEFAULT 0,
  `description` text DEFAULT NULL,
  `hoverEnabled` tinyint(1) DEFAULT 0,
  `ohFillColor` varchar(16) DEFAULT NULL,
  `ohLineColor` varchar(16) DEFAULT NULL,
  `ohFillOpacity` float DEFAULT NULL,
  `ohLineOpacity` float DEFAULT NULL,
  `link` varchar(700) NOT NULL,
  `layergroup` int(3) DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE IF NOT EXISTS `wp_wpum_fieldmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `wpum_field_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `wpum_field_id` (`wpum_field_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=36 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE IF NOT EXISTS `wp_wpum_fields` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `group_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `field_order` bigint(20) unsigned NOT NULL DEFAULT 0,
  `type` varchar(20) NOT NULL DEFAULT 'text',
  `name` varchar(255) NOT NULL DEFAULT '',
  `description` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `group_id` (`group_id`),
  KEY `field_order` (`field_order`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE IF NOT EXISTS `wp_wpum_fieldsgroups` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `group_order` bigint(20) unsigned NOT NULL DEFAULT 0,
  `is_primary` tinyint(1) NOT NULL DEFAULT 0,
  `name` varchar(190) NOT NULL DEFAULT '',
  `description` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `name` (`name`),
  KEY `group_order` (`group_order`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE IF NOT EXISTS `wp_wpum_registration_formmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `wpum_registration_form_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `wpum_registration_form_id` (`wpum_registration_form_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE IF NOT EXISTS `wp_wpum_registration_forms` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE IF NOT EXISTS `wp_wpum_search_fields` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `meta_key` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE IF NOT EXISTS `wp_wpum_stripe_invoices` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `invoice_id` varchar(255) NOT NULL,
  `total` decimal(8,2) NOT NULL,
  `currency` varchar(20) NOT NULL,
  `gateway_mode` varchar(4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE IF NOT EXISTS `wp_wpum_stripe_subscriptions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `customer_id` varchar(255) NOT NULL,
  `plan_id` varchar(255) NOT NULL,
  `subscription_id` varchar(255) NOT NULL,
  `trial_ends_at` timestamp NULL DEFAULT NULL,
  `ends_at` timestamp NULL DEFAULT NULL,
  `gateway_mode` varchar(4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE IF NOT EXISTS `wp_yoast_indexable` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `permalink` mediumtext DEFAULT NULL,
  `permalink_hash` varchar(40) DEFAULT NULL,
  `object_id` bigint(20) DEFAULT NULL,
  `object_type` varchar(32) NOT NULL,
  `object_sub_type` varchar(32) DEFAULT NULL,
  `author_id` bigint(20) DEFAULT NULL,
  `post_parent` bigint(20) DEFAULT NULL,
  `title` text DEFAULT NULL,
  `description` text DEFAULT NULL,
  `breadcrumb_title` text DEFAULT NULL,
  `post_status` varchar(20) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `is_protected` tinyint(1) DEFAULT 0,
  `has_public_posts` tinyint(1) DEFAULT NULL,
  `number_of_pages` int(11) unsigned DEFAULT NULL,
  `canonical` mediumtext DEFAULT NULL,
  `primary_focus_keyword` varchar(191) DEFAULT NULL,
  `primary_focus_keyword_score` int(3) DEFAULT NULL,
  `readability_score` int(3) DEFAULT NULL,
  `is_cornerstone` tinyint(1) DEFAULT 0,
  `is_robots_noindex` tinyint(1) DEFAULT 0,
  `is_robots_nofollow` tinyint(1) DEFAULT 0,
  `is_robots_noarchive` tinyint(1) DEFAULT 0,
  `is_robots_noimageindex` tinyint(1) DEFAULT 0,
  `is_robots_nosnippet` tinyint(1) DEFAULT 0,
  `twitter_title` text DEFAULT NULL,
  `twitter_image` mediumtext DEFAULT NULL,
  `twitter_description` mediumtext DEFAULT NULL,
  `twitter_image_id` varchar(191) DEFAULT NULL,
  `twitter_image_source` text DEFAULT NULL,
  `open_graph_title` text DEFAULT NULL,
  `open_graph_description` mediumtext DEFAULT NULL,
  `open_graph_image` mediumtext DEFAULT NULL,
  `open_graph_image_id` varchar(191) DEFAULT NULL,
  `open_graph_image_source` text DEFAULT NULL,
  `open_graph_image_meta` text DEFAULT NULL,
  `link_count` int(11) DEFAULT NULL,
  `incoming_link_count` int(11) DEFAULT NULL,
  `prominent_words_version` int(11) unsigned DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `blog_id` bigint(20) NOT NULL DEFAULT 1,
  `language` varchar(32) DEFAULT NULL,
  `region` varchar(32) DEFAULT NULL,
  `schema_page_type` varchar(64) DEFAULT NULL,
  `schema_article_type` varchar(64) DEFAULT NULL,
  `has_ancestors` tinyint(1) DEFAULT 0,
  `estimated_reading_time_minutes` int(11) DEFAULT NULL,
  `version` int(11) DEFAULT 1,
  `object_last_modified` datetime DEFAULT NULL,
  `object_published_at` datetime DEFAULT NULL,
  `inclusive_language_score` int(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `object_type_and_sub_type` (`object_type`,`object_sub_type`),
  KEY `object_id_and_type` (`object_id`,`object_type`),
  KEY `permalink_hash_and_object_type` (`permalink_hash`,`object_type`),
  KEY `subpages` (`post_parent`,`object_type`,`post_status`,`object_id`),
  KEY `prominent_words` (`prominent_words_version`,`object_type`,`object_sub_type`,`post_status`),
  KEY `published_sitemap_index` (`object_published_at`,`is_robots_noindex`,`object_type`,`object_sub_type`)
) ENGINE=InnoDB AUTO_INCREMENT=66 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE IF NOT EXISTS `wp_yoast_indexable_hierarchy` (
  `indexable_id` int(11) unsigned NOT NULL,
  `ancestor_id` int(11) unsigned NOT NULL,
  `depth` int(11) unsigned DEFAULT NULL,
  `blog_id` bigint(20) NOT NULL DEFAULT 1,
  PRIMARY KEY (`indexable_id`,`ancestor_id`),
  KEY `indexable_id` (`indexable_id`),
  KEY `ancestor_id` (`ancestor_id`),
  KEY `depth` (`depth`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE IF NOT EXISTS `wp_yoast_migrations` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `version` varchar(191) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `wp_yoast_migrations_version` (`version`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE IF NOT EXISTS `wp_yoast_primary_term` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) DEFAULT NULL,
  `term_id` bigint(20) DEFAULT NULL,
  `taxonomy` varchar(32) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `blog_id` bigint(20) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `post_taxonomy` (`post_id`,`taxonomy`),
  KEY `post_term` (`post_id`,`term_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE IF NOT EXISTS `wp_yoast_seo_links` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(255) DEFAULT NULL,
  `post_id` bigint(20) unsigned DEFAULT NULL,
  `target_post_id` bigint(20) unsigned DEFAULT NULL,
  `type` varchar(8) DEFAULT NULL,
  `indexable_id` int(11) unsigned DEFAULT NULL,
  `target_indexable_id` int(11) unsigned DEFAULT NULL,
  `height` int(11) unsigned DEFAULT NULL,
  `width` int(11) unsigned DEFAULT NULL,
  `size` int(11) unsigned DEFAULT NULL,
  `language` varchar(32) DEFAULT NULL,
  `region` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `link_direction` (`post_id`,`type`),
  KEY `indexable_link_direction` (`indexable_id`,`type`)
) ENGINE=InnoDB AUTO_INCREMENT=379 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

/***** TABLE CREATION END *****/
INSERT IGNORE INTO `wp_users` VALUES 
("263052659","lebonouvreboite","$P$B1VOiky72MPvc7qdurJiGwJ1UhZfG//","lebonouvreboite","lebonouvreboite@gmail.com","http://creakonect.wordpress.com","2025-03-07 17:26:30","","0","LeBonOuvreBoite");

INSERT IGNORE INTO `wp_usermeta` VALUES 
("16","263052659","first_name","LeBonOuvreBoite"),
("17","263052659","nickname","lebonouvreboite"),
("18","263052659","rich_editing","true"),
("19","263052659","comment_shortcuts","false"),
("20","263052659","admin_color","modern"),
("21","263052659","show_admin_bar_front","true"),
("22","263052659","wp_capabilities","a:7:{s:13:\"administrator\";b:1;s:14:\"frm_view_forms\";b:1;s:14:\"frm_edit_forms\";b:1;s:16:\"frm_delete_forms\";b:1;s:19:\"frm_change_settings\";b:1;s:16:\"frm_view_entries\";b:1;s:18:\"frm_delete_entries\";b:1;}"),
("23","263052659","wp_user_level","10"),
("24","263052659","wp_dashboard_quick_press_last_post_id","1336"),
("25","263052659","wp_wpcom_site_count","1"),
("26","263052659","wp_user-settings","mfold=o&libraryContent=browse&editor=tinymce"),
("27","263052659","wp_user-settings-time","1754244674"),
("28","263052659","locale","fr_FR"),
("29","263052659","remove_duplicate_views_experiment_assignment_160125",NULL),
("30","263052659","wpcom_user_id","263052659"),
("31","263052659","wpcom_user_data","O:8:\"stdClass\":10:{s:2:\"ID\";i:263052659;s:5:\"login\";s:15:\"lebonouvreboite\";s:5:\"email\";s:25:\"lebonouvreboite@gmail.com\";s:3:\"url\";s:31:\"http://creakonect.wordpress.com\";s:10:\"first_name\";s:15:\"LeBonOuvreBoite\";s:9:\"last_name\";s:0:\"\";s:12:\"display_name\";s:15:\"LeBonOuvreBoite\";s:11:\"description\";s:0:\"\";s:16:\"two_step_enabled\";b:0;s:16:\"external_user_id\";i:263052659;}"),
("32","263052659","session_tokens","a:6:{s:64:\"11650ca52b1b9a3fa4a26cfc0a91a17fe2ea80163d32ead247735974d844daec\";a:4:{s:10:\"expiration\";i:1774193410;s:2:\"ip\";s:13:\"78.242.151.34\";s:2:\"ua\";s:125:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36 Edg/134.0.0.0\";s:5:\"login\";i:1742657410;}s:64:\"aba4e79c3e8b0bb1ab2ed83a3f2b486377640ea10b88cc650d3e8a0b1b88ae5b\";a:4:{s:10:\"expiration\";i:1774193465;s:2:\"ip\";s:13:\"78.242.151.34\";s:2:\"ua\";s:125:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36 Edg/134.0.0.0\";s:5:\"login\";i:1742657465;}s:64:\"8a5761e2297edf2095d4449c2c9518ea3737c1fa83c6958251933617a4091227\";a:4:{s:10:\"expiration\";i:1775235007;s:2:\"ip\";s:14:\"81.249.187.233\";s:2:\"ua\";s:117:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36\";s:5:\"login\";i:1743699007;}s:64:\"03fe13ffaf2174b630ff1cc2b23d9c4770d591f3aaa8b525fc3d40b866239d56\";a:4:{s:10:\"expiration\";i:1776191613;s:2:\"ip\";s:14:\"81.249.187.233\";s:2:\"ua\";s:117:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Safari/537.36\";s:5:\"login\";i:1744655613;}s:64:\"fe82876af289d4df59978de73927ded82e8d674bb8c7169712fb809f9ee37704\";a:4:{s:10:\"expiration\";i:1777135799;s:2:\"ip\";s:14:\"81.249.187.233\";s:2:\"ua\";s:117:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36\";s:5:\"login\";i:1745599799;}s:64:\"bf8d28e3159b37660e807dedc1ffa295284c841eb7d64941de8a8f4bc046ca90\";a:4:{s:10:\"expiration\";i:1780342766;s:2:\"ip\";s:12:\"90.0.145.155\";s:2:\"ua\";s:125:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Safari/537.36 Edg/136.0.0.0\";s:5:\"login\";i:1748806766;}}"),
("33","263052659","jetpack_tracks_anon_id","jetpack:dAHyjbq7c5GjG6s5LNFNmTp2"),
("34","263052659","elementor_introduction","a:5:{s:27:\"ai-get-started-announcement\";b:1;s:20:\"globals_introduction\";b:1;s:28:\"yoast-introduction-editor-v2\";b:1;s:14:\"ai_get_started\";b:1;s:59:\"ai_get_started_introduction_site_logo_with_ai_site-settings\";b:1;}"),
("35","263052659","last_name",""),
("36","263052659","description",""),
("37","263052659","syntax_highlighting","true"),
("38","263052659","use_ssl","0"),
("39","263052659","wp_persisted_preferences","a:5:{s:22:\"core/customize-widgets\";a:1:{s:12:\"welcomeGuide\";b:0;}s:9:\"_modified\";s:24:\"2025-05-30T18:04:02.355Z\";s:14:\"core/edit-post\";a:4:{s:14:\"fullscreenMode\";b:1;s:12:\"welcomeGuide\";b:0;s:19:\"metaBoxesMainIsOpen\";b:0;s:23:\"metaBoxesMainOpenHeight\";i:100;}s:4:\"core\";a:3:{s:26:\"isComplementaryAreaVisible\";b:0;s:10:\"openPanels\";a:5:{i:0;s:11:\"post-status\";i:1;s:23:\"taxonomy-panel-post_tag\";i:2;s:23:\"taxonomy-panel-category\";i:3;s:24:\"yoast-seo/document-panel\";i:4;s:48:\"jetpack-ai-assistant-plugin/jetpack-ai-assistant\";}s:9:\"focusMode\";b:1;}s:17:\"core/edit-widgets\";a:2:{s:26:\"isComplementaryAreaVisible\";b:1;s:12:\"welcomeGuide\";b:0;}}"),
("40","263052659","nav_menu_recently_edited","16085"),
("41","263052659","managenav-menuscolumnshidden","a:5:{i:0;s:11:\"link-target\";i:1;s:11:\"css-classes\";i:2;s:3:\"xfn\";i:3;s:11:\"description\";i:4;s:15:\"title-attribute\";}"),
("42","263052659","metaboxhidden_nav-menus","a:1:{i:0;s:12:\"add-post_tag\";}"),
("43","263052659","_e_notifications_dismissed","a:29:{i:0;s:17:\"ally-notification\";i:1;s:17:\"send-notification\";i:2;s:19:\"hello-biz-templates\";i:3;s:15:\"ai-site-planner\";i:4;s:14:\"grid-span-3.27\";i:5;s:16:\"local-fonts-3.27\";i:6;s:17:\"video-shorts-3.27\";i:7;s:15:\"hello-biz-theme\";i:8;s:23:\"dynamic-off-canvas-3.26\";i:9;s:16:\"css-loading-3.25\";i:10;s:20:\"image-optimizer-3.19\";i:11;s:19:\"variable-fonts-3.24\";i:12;s:18:\"floating-bars-3.24\";i:13;s:17:\"ai-featured-image\";i:14;s:18:\"search-widget-3.23\";i:15;s:21:\"floating-buttons-3.23\";i:16;s:16:\"link-in-bio-3.23\";i:17;s:20:\"nested-elements-3.23\";i:18;s:20:\"5-star-rating-prompt\";i:19;s:23:\"site-mailer-introducing\";i:20;s:12:\"classes-3.29\";i:21;s:12:\"send-connect\";i:22;s:14:\"style-tab-3.29\";i:23;s:15:\"responsive-3.29\";i:24;s:16:\"performance-3.29\";i:25;s:14:\"migration-host\";i:26;s:17:\"ai-isolate-object\";i:27;s:17:\"hello-biz-contact\";i:28;s:22:\"ai-site-planner-colors\";}"),
("45","263052659","_yoast_wpseo_introductions","a:1:{s:25:\"ai-fix-assessments-upsell\";b:1;}"),
("52","263052659","meta-box-order_page","a:3:{s:6:\"normal\";s:10:\"wpseo_meta\";s:8:\"advanced\";s:0:\"\";s:4:\"side\";s:25:\"neve-page-settings-notice\";}"),
("56","263052659","frm_reviewed","a:3:{s:4:\"time\";i:1748186733;s:9:\"dismissed\";b:0;s:5:\"asked\";i:0;}"),
("59","263052659","_yoast_wpseo_profile_updated","1743210124"),
("161","263052659","dismissed_wp_pointers","wpsl_signup_pointer,theme_editor_notice"),
("170","263052659","jetpack_donation_warning_dismissed","1"),
("189","263052659","wpsl_disable_location_warning","true"),
("190","263052659","wpsl_disable_key_warning","true"),
("267","263052659","elementor_dismissed_editor_notices","a:1:{i:0;s:20:\"image_optimizer_hint\";}"),
("297","263052659","meta-box-order_elementor-hf","a:3:{s:4:\"side\";s:49:\"submitdiv,pageparentdiv,sharing_meta,postimagediv\";s:6:\"normal\";s:44:\"wpseo_meta,ehf-meta-box,revisionsdiv,slugdiv\";s:8:\"advanced\";s:0:\"\";}"),
("298","263052659","screen_layout_elementor-hf","2"),
("299","263052659","wp_elementor_connect_common_data","a:7:{s:9:\"client_id\";s:32:\"tdAjFS59HOnrpqBJgCbvYKItvT5tZws7\";s:11:\"auth_secret\";s:32:\"scNrkRgucw3acBAwLEjLIeG5eY26UOsn\";s:12:\"access_token\";s:291:\"eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJzdWIiOiI4MDk3ODk1IiwiYXVkIjoiaHR0cHM6Ly9jcmVha29uZWN0LmNvbS8iLCJjbGllbnRfaWQiOiJ0ZEFqRlM1OUhPbnJwcUJKZ0NidllLSXR2VDV0WndzNyIsImNvbm5lY3RfdHlwZSI6ImxpYnJhcnkiLCJpYXQiOjE3NDU5MTYzNjgsImV4cCI6MzE3MjkwMzU4NzY4fQ.QYr6ieMH6O1KyICVIJhmt1TFJVKzUKUOWpwLAkvYdwQ\";s:19:\"access_token_secret\";s:32:\"oNOGYR6FgYsLIus2XJ0y3kIiPZz2sQwL\";s:10:\"token_type\";s:6:\"bearer\";s:4:\"user\";O:8:\"stdClass\":1:{s:5:\"email\";s:25:\"lebonouvreboite@gmail.com\";}s:19:\"data_share_opted_in\";b:1;}"),
("437","263052659","elementor_preferences","a:1:{s:25:\"enable_styleguide_preview\";s:0:\"\";}"),
("660","263052659","wp_yoast_notifications","a:1:{i:0;a:2:{s:7:\"message\";s:174:\"Yoast SEO a détecté que vous utilisez la version de 20.6.0 de Gutenberg. Veuillez la mettre à jour vers la dernière version pour éviter les problèmes de compatibilité.\";s:7:\"options\";a:10:{s:4:\"type\";s:5:\"error\";s:2:\"id\";s:31:\"wpseo-outdated-gutenberg-plugin\";s:7:\"user_id\";i:263052659;s:5:\"nonce\";N;s:8:\"priority\";i:1;s:9:\"data_json\";a:0:{}s:13:\"dismissal_key\";N;s:12:\"capabilities\";a:1:{i:0;s:20:\"wpseo_manage_options\";}s:16:\"capability_check\";s:3:\"all\";s:14:\"yoast_branding\";b:0;}}}");

INSERT IGNORE INTO `wp_bp_activity` VALUES 
("1","263052659","members","last_activity","","","","0",NULL,"2025-08-03 18:55:06","0","0","0","0");

INSERT IGNORE INTO `wp_bp_user_blogs` VALUES 
("1","263052659","1");

INSERT IGNORE INTO `wp_bp_user_blogs_blogmeta` VALUES 
("1","1","url","https://creakonect.com"),
("2","1","name","https://creakonect.com"),
("3","1","description",""),
("4","1","last_activity","2025-05-30 18:04:03"),
("5","1","close_comments_for_old_posts","0"),
("6","1","close_comments_days_old","14"),
("7","1","thread_comments_depth","3"),
("8","1","comment_moderation","0");

INSERT IGNORE INTO `wp_bp_xprofile_fields` VALUES 
("1","1","0","textbox","Name","","1","0","0","0","","0");

INSERT IGNORE INTO `wp_bp_xprofile_groups` VALUES 
("1","Base","","0","0");

INSERT IGNORE INTO `wp_bp_xprofile_meta` VALUES 
("1","1","field","allow_custom_visibility","disabled"),
("2","1","field","signup_position","1");

INSERT IGNORE INTO `wp_commentmeta` VALUES 
("1","1","akismet_result","false"),
("2","1","akismet_guid","88172ef36202ac989139e04905f72011"),
("3","1","akismet_as_submitted","a:15:{s:14:\"comment_author\";s:15:\"LeBonOuvreBoite\";s:20:\"comment_author_email\";s:25:\"lebonouvreboite@gmail.com\";s:18:\"comment_author_url\";s:31:\"http://creakonect.wordpress.com\";s:15:\"comment_content\";s:41:\"https://maps.app.goo.gl/SEw3mAzUtwuXRh9p8\";s:12:\"comment_type\";s:7:\"comment\";s:7:\"user_id\";i:263052659;s:7:\"user_ID\";i:263052659;s:17:\"comment_author_IP\";s:14:\"81.249.187.233\";s:13:\"comment_agent\";s:117:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36\";s:7:\"user_ip\";s:14:\"81.249.187.233\";s:10:\"user_agent\";s:117:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36\";s:4:\"blog\";s:22:\"https://creakonect.com\";s:9:\"blog_lang\";s:5:\"fr_FR\";s:12:\"blog_charset\";s:5:\"UTF-8\";s:9:\"permalink\";s:59:\"https://creakonect.com/2025/03/23/les-evenements-du-reseau/\";}"),
("4","1","akismet_history","a:3:{s:4:\"time\";d:1744820306.471995;s:5:\"event\";s:9:\"check-ham\";s:4:\"user\";s:15:\"lebonouvreboite\";}"),
("5","1","hc_post_as","jetpack"),
("6","1","hc_avatar","https://0.gravatar.com/avatar/3aac21a6825e05462c727ba873393d4c3849e4427854438d36e928d03df727e9?s=96&d=https%3A%2F%2Fs0.wp.com%2Fwp-content%2Fmu-plugins%2Fhighlander-comments%2Fimages%2Fwplogo.png&r=G"),
("7","1","hc_foreign_user_id","263052659");

INSERT IGNORE INTO `wp_comments` VALUES 
("1","137","LeBonOuvreBoite","lebonouvreboite@gmail.com","http://creakonect.wordpress.com","81.249.187.233","2025-04-16 18:18:26","2025-04-16 16:18:26","https://maps.app.goo.gl/SEw3mAzUtwuXRh9p8","0","1","Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36","comment","0","263052659");

INSERT IGNORE INTO `wp_duplicator_activity_logs` VALUES 
("1","websites_scan","scan_start","10","Scan","{\n    \"packageId\": 1,\n    \"packageName\": \"CopiedusiteCreaKonect\",\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"filterOn\": true,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 0,\n    \"dirCount\": 0,\n    \"size\": 0\n}","0","4.5.22.2","2025-07-29 17:56:33","2025-07-29 17:56:33"),
("2","websites_scan","scan_end","10","Scan Completed","{\n    \"packageId\": 1,\n    \"packageName\": \"CopiedusiteCreaKonect\",\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"filterOn\": true,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 28425,\n    \"dirCount\": 4678,\n    \"size\": 627486841\n}","1","4.5.22.2","2025-07-29 17:56:39","2025-07-29 17:56:39"),
("3","websites_scan","scan_start","10","Scan","{\n    \"packageId\": 2,\n    \"packageName\": \"CopiedusiteCreaKonect\",\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"filterOn\": true,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 0,\n    \"dirCount\": 0,\n    \"size\": 0\n}","0","4.5.22.2","2025-08-01 17:15:12","2025-08-01 17:15:12"),
("4","websites_scan","scan_end","10","Scan Completed","{\n    \"packageId\": 2,\n    \"packageName\": \"CopiedusiteCreaKonect\",\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"filterOn\": true,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 28430,\n    \"dirCount\": 4679,\n    \"size\": 627540209\n}","3","4.5.22.2","2025-08-01 17:15:17","2025-08-01 17:15:17"),
("5","backup_create","start","10","Backup create: CopiedusiteCreaKonect","{\n    \"packageId\": 3,\n    \"packageName\": \"CopiedusiteCreaKonect\",\n    \"packageStatus\": 10,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"filterOn\": true,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 28430,\n    \"dirCount\": 4679,\n    \"size\": 627540209,\n    \"dbFilterOn\": false,\n    \"dbFilterTables\": [],\n    \"dbPrefixFilter\": false,\n    \"dbPrefixSubFilter\": false,\n    \"archiveEngine\": \"Zip Archive\",\n    \"databaseEngine\": \"PHPCHUNKING\"\n}","0","4.5.22.2","2025-08-01 17:15:45","2025-08-01 17:15:45"),
("6","backup_create","db_dump","10","Backup create: CopiedusiteCreaKonect - DB Dump","{\n    \"packageId\": 3,\n    \"packageName\": \"CopiedusiteCreaKonect\",\n    \"packageStatus\": 20,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"filterOn\": true,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 28430,\n    \"dirCount\": 4679,\n    \"size\": 627540209,\n    \"dbFilterOn\": false,\n    \"dbFilterTables\": [],\n    \"dbPrefixFilter\": false,\n    \"dbPrefixSubFilter\": false,\n    \"archiveEngine\": \"Zip Archive\",\n    \"databaseEngine\": \"PHPCHUNKING\"\n}","5","4.5.22.2","2025-08-01 17:15:45","2025-08-01 17:15:45"),
("7","backup_create","file_dump","10","Backup create: CopiedusiteCreaKonect - File Dump","{\n    \"packageId\": 3,\n    \"packageName\": \"CopiedusiteCreaKonect\",\n    \"packageStatus\": 40,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"filterOn\": true,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 28430,\n    \"dirCount\": 4679,\n    \"size\": 627540209,\n    \"dbFilterOn\": false,\n    \"dbFilterTables\": [],\n    \"dbPrefixFilter\": false,\n    \"dbPrefixSubFilter\": false,\n    \"archiveEngine\": \"Zip Archive\",\n    \"databaseEngine\": \"PHPCHUNKING\"\n}","5","4.5.22.2","2025-08-01 17:15:56","2025-08-01 17:15:56"),
("8","backup_create","transfer","10","Backup create: CopiedusiteCreaKonect - Transfer","{\n    \"packageId\": 3,\n    \"packageName\": \"CopiedusiteCreaKonect\",\n    \"packageStatus\": 75,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"filterOn\": true,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 28430,\n    \"dirCount\": 4679,\n    \"size\": 245705451,\n    \"dbFilterOn\": false,\n    \"dbFilterTables\": [],\n    \"dbPrefixFilter\": false,\n    \"dbPrefixSubFilter\": false,\n    \"archiveEngine\": \"Zip Archive\",\n    \"databaseEngine\": \"PHPCHUNKING\"\n}","5","4.5.22.2","2025-08-01 17:17:04","2025-08-01 17:17:04"),
("9","backup_create","end","10","Backup create: CopiedusiteCreaKonect - Completed","{\n    \"packageId\": 3,\n    \"packageName\": \"CopiedusiteCreaKonect\",\n    \"packageStatus\": 100,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"filterOn\": true,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 28430,\n    \"dirCount\": 4679,\n    \"size\": 245705451,\n    \"dbFilterOn\": false,\n    \"dbFilterTables\": [],\n    \"dbPrefixFilter\": false,\n    \"dbPrefixSubFilter\": false,\n    \"archiveEngine\": \"Zip Archive\",\n    \"databaseEngine\": \"PHPCHUNKING\"\n}","5","4.5.22.2","2025-08-01 17:17:05","2025-08-01 17:17:05"),
("10","websites_scan","scan_start","10","Scan","{\n    \"packageId\": 4,\n    \"packageName\": \"CopiedusiteCreaKonect\",\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"filterOn\": true,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 0,\n    \"dirCount\": 0,\n    \"size\": 0\n}","0","4.5.22.2","2025-08-03 18:58:29","2025-08-03 18:58:29"),
("11","websites_scan","scan_end","10","Scan Completed","{\n    \"packageId\": 4,\n    \"packageName\": \"CopiedusiteCreaKonect\",\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"filterOn\": true,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 28430,\n    \"dirCount\": 4678,\n    \"size\": 626302123\n}","10","4.5.22.2","2025-08-03 18:58:34","2025-08-03 18:58:34"),
("12","backup_create","start","10","Backup create: CopiedusiteCreaKonect","{\n    \"packageId\": 5,\n    \"packageName\": \"CopiedusiteCreaKonect\",\n    \"packageStatus\": 10,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"filterOn\": true,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 28430,\n    \"dirCount\": 4678,\n    \"size\": 626302123,\n    \"dbFilterOn\": false,\n    \"dbFilterTables\": [],\n    \"dbPrefixFilter\": false,\n    \"dbPrefixSubFilter\": false,\n    \"archiveEngine\": \"Zip Archive\",\n    \"databaseEngine\": \"PHPCHUNKING\"\n}","0","4.5.22.2","2025-08-03 18:59:00","2025-08-03 18:59:00"),
("13","backup_create","db_dump","10","Backup create: CopiedusiteCreaKonect - DB Dump","{\n    \"packageId\": 5,\n    \"packageName\": \"CopiedusiteCreaKonect\",\n    \"packageStatus\": 20,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"filterOn\": true,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 28430,\n    \"dirCount\": 4678,\n    \"size\": 626302123,\n    \"dbFilterOn\": false,\n    \"dbFilterTables\": [],\n    \"dbPrefixFilter\": false,\n    \"dbPrefixSubFilter\": false,\n    \"archiveEngine\": \"Zip Archive\",\n    \"databaseEngine\": \"PHPCHUNKING\"\n}","12","4.5.22.2","2025-08-03 18:59:00","2025-08-03 18:59:00");

INSERT IGNORE INTO `wp_duplicator_backups` VALUES 
("3","Standard","CopiedusiteCreaKonect","2c2f4b8ae6fd37af1323_20250801171509","CopiedusiteCreaKonect_2c2f4b8ae6fd37af1323_20250801171509_archive.zip","100","MANUAL,HAVE_LOCAL,DISASTER_AVAIABLE,ZIP_ARCHIVE","{\n    \"ID\": 3,\n    \"VersionWP\": \"6.8.2\",\n    \"VersionDB\": \"11.4.7\",\n    \"VersionPHP\": \"8.2.29\",\n    \"VersionOS\": \"Linux\",\n    \"name\": \"CopiedusiteCreaKonect\",\n    \"hash\": \"2c2f4b8ae6fd37af1323_20250801171509\",\n    \"execType\": 0,\n    \"notes\": \"\",\n    \"StorePath\": \"\\/srv\\/htdocs\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/creakonect.com\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"CopiedusiteCreaKonect_2c2f4b8ae6fd37af1323_20250801171509_scan.json\",\n    \"timer_start\": 1754068545.524,\n    \"Runtime\": \"78.014 sec.\",\n    \"ExeSize\": \"127.66KB\",\n    \"ZipSize\": \"234.32MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/srv\\/htdocs\\/wp-content\\/ai1wm-backups\",\n            \"\\/srv\\/htdocs\\/wp-content\\/backups-dup-lite\",\n            \"\\/srv\\/htdocs\\/wp-content\\/backups-dup-pro\",\n            \"\\/srv\\/htdocs\\/wp-content\\/backupwordpress\",\n            \"\\/srv\\/htdocs\\/wp-content\\/bps-backup\",\n            \"\\/srv\\/htdocs\\/wp-content\\/cache\",\n            \"\\/srv\\/htdocs\\/wp-content\\/content\\/cache\",\n            \"\\/srv\\/htdocs\\/wp-content\\/contents\\/cache\",\n            \"\\/srv\\/htdocs\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/srv\\/htdocs\\/wp-content\\/managewp\\/backups\",\n            \"\\/srv\\/htdocs\\/wp-content\\/old-cache\",\n            \"\\/srv\\/htdocs\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/srv\\/htdocs\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/srv\\/htdocs\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/srv\\/htdocs\\/wp-content\\/updraft\",\n            \"\\/srv\\/htdocs\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/srv\\/htdocs\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/srv\\/htdocs\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/srv\\/htdocs\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/srv\\/htdocs\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/srv\\/htdocs\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/srv\\/htdocs\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/srv\\/htdocs\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/srv\\/htdocs\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/srv\\/htdocs\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/srv\\/htdocs\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/srv\\/htdocs\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/srv\\/htdocs\\/wp-content\\/wfcache\",\n            \"\\/srv\\/htdocs\\/wp-content\\/wishlist-backup\",\n            \"\\/srv\\/htdocs\\/wp-content\\/wpvividbackups\",\n            \"\\/wordpress\\/core\\/6.8.2\\/.opcache\",\n            \"\\/wordpress\\/core\\/6.8.2\\/.tmb\",\n            \"\\/wordpress\\/core\\/6.8.2\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/srv\\/htdocs\\/wp-content\\/debug.log\",\n            \"\\/wordpress\\/core\\/6.8.2\\/.htaccess\",\n            \"\\/wordpress\\/core\\/6.8.2\\/.user.ini\",\n            \"\\/wordpress\\/core\\/6.8.2\\/php.ini\",\n            \"\\/wordpress\\/core\\/6.8.2\\/web.config\",\n            \"\\/wordpress\\/core\\/wp-config.php\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": true,\n        \"FilterNames\": false,\n        \"File\": \"CopiedusiteCreaKonect_2c2f4b8ae6fd37af1323_20250801171509_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/\",\n        \"Size\": 245705451,\n        \"Dirs\": [],\n        \"DirCount\": 4679,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 28430,\n        \"file_count\": 33109,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"CopiedusiteCreaKonect_2c2f4b8ae6fd37af1323_20250801171509_installer.php\",\n        \"Size\": 130726,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"ot37oNAO7vU1Z3N9FOVUKUPE2dP3hlTRMQKO84yAlhOR5Bm\\/FYX4djMs+0JS9JyuMIIhH6JLa4SVBqgCe9pa1Q==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": false,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"latin1\",\n                \"utf8mb3\"\n            ],\n            \"collationList\": [\n                \"latin1_swedish_ci\",\n                \"utf8mb3_general_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"151049487\",\n            \"tablesBaseCount\": 67,\n            \"tablesFinalCount\": 67,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 6070,\n            \"tablesSizeOnDisk\": 17563648,\n            \"tablesList\": {\n                \"wp_bp_activity\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 180224\n                },\n                \"wp_bp_activity_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_bp_friends\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_bp_groups\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_bp_groups_groupmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_bp_groups_members\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"wp_bp_invitations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 163840\n                },\n                \"wp_bp_messages_messages\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_bp_messages_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_bp_messages_notices\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_bp_messages_recipients\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wp_bp_notifications\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"wp_bp_notifications_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_bp_optouts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_bp_user_blogs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 49152\n                },\n                \"wp_bp_user_blogs_blogmeta\": {\n                    \"inaccurateRows\": \"8\",\n                    \"insertedRows\": 8,\n                    \"size\": 49152\n                },\n                \"wp_bp_xprofile_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_bp_xprofile_fields\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 98304\n                },\n                \"wp_bp_xprofile_groups\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"wp_bp_xprofile_meta\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 49152\n                },\n                \"wp_commentmeta\": {\n                    \"inaccurateRows\": \"7\",\n                    \"insertedRows\": 7,\n                    \"size\": 49152\n                },\n                \"wp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 98304\n                },\n                \"wp_duplicator_activity_logs\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 6,\n                    \"size\": 114688\n                },\n                \"wp_duplicator_backups\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 2,\n                    \"size\": 212992\n                },\n                \"wp_duplicator_entities\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 9,\n                    \"size\": 163840\n                },\n                \"wp_duplicator_packages\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_frm_fields\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 5,\n                    \"size\": 65536\n                },\n                \"wp_frm_forms\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"wp_frm_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"wp_frm_item_metas\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_jetpack_sync_queue\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wp_links\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 32768\n                },\n                \"wp_mwai_filemeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_mwai_files\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_options\": {\n                    \"inaccurateRows\": \"509\",\n                    \"insertedRows\": 525,\n                    \"size\": 2244608\n                },\n                \"wp_postmeta\": {\n                    \"inaccurateRows\": \"4172\",\n                    \"insertedRows\": 4370,\n                    \"size\": 7110656\n                },\n                \"wp_posts\": {\n                    \"inaccurateRows\": \"882\",\n                    \"insertedRows\": 1005,\n                    \"size\": 4472832\n                },\n                \"wp_signups\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wp_termmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_terms\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 30,\n                    \"size\": 49152\n                },\n                \"wp_term_relationships\": {\n                    \"inaccurateRows\": \"57\",\n                    \"insertedRows\": 66,\n                    \"size\": 32768\n                },\n                \"wp_term_taxonomy\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 30,\n                    \"size\": 49152\n                },\n                \"wp_usermeta\": {\n                    \"inaccurateRows\": \"42\",\n                    \"insertedRows\": 42,\n                    \"size\": 49152\n                },\n                \"wp_users\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 65536\n                },\n                \"wp_wpgmza\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"wp_wpgmza_admin_notices\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wpgmza_circles\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wpgmza_image_overlays\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wpgmza_maps\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"wp_wpgmza_point_labels\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wpgmza_polygon\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wpgmza_polylines\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wpgmza_rectangles\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wpum_fieldmeta\": {\n                    \"inaccurateRows\": \"35\",\n                    \"insertedRows\": 35,\n                    \"size\": 49152\n                },\n                \"wp_wpum_fields\": {\n                    \"inaccurateRows\": \"11\",\n                    \"insertedRows\": 11,\n                    \"size\": 49152\n                },\n                \"wp_wpum_fieldsgroups\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 49152\n                },\n                \"wp_wpum_registration_formmeta\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 49152\n                },\n                \"wp_wpum_registration_forms\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"wp_wpum_search_fields\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 16384\n                },\n                \"wp_wpum_stripe_invoices\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wpum_stripe_subscriptions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_yoast_indexable\": {\n                    \"inaccurateRows\": \"59\",\n                    \"insertedRows\": 59,\n                    \"size\": 114688\n                },\n                \"wp_yoast_indexable_hierarchy\": {\n                    \"inaccurateRows\": \"58\",\n                    \"insertedRows\": 57,\n                    \"size\": 65536\n                },\n                \"wp_yoast_migrations\": {\n                    \"inaccurateRows\": \"24\",\n                    \"insertedRows\": 24,\n                    \"size\": 32768\n                },\n                \"wp_yoast_primary_term\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_yoast_seo_links\": {\n                    \"inaccurateRows\": \"111\",\n                    \"insertedRows\": 111,\n                    \"size\": 49152\n                }\n            },\n            \"dbEngine\": \"MariaDB\",\n            \"version\": \"11.4.7\",\n            \"versionComment\": \"MariaDB Server\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 8018375,\n        \"File\": \"CopiedusiteCreaKonect_2c2f4b8ae6fd37af1323_20250801171509_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MariaDB Server\",\n        \"dbStorePathPublic\": \"\\/srv\\/htdocs\\/wp-content\\/backups-dup-pro\\/tmp\\/CopiedusiteCreaKonect_2c2f4b8ae6fd37af1323_20250801171509_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"status\": 100,\n    \"progressPercent\": 100,\n    \"schedule_id\": -1,\n    \"descriptorsMng\": {\n        \"hash\": \"2c2f4b8-01171509\",\n        \"date\": \"20250801171509\",\n        \"mapping\": {\n            \"orig_files\": \"orig_files\",\n            \"archive_config\": \"archive.txt\",\n            \"scan\": \"scan.json\",\n            \"file_list\": \"scanned-files.txt\",\n            \"dir_list\": \"scanned-dirs.txt\",\n            \"file_index\": \"index.txt\",\n            \"manual_extract\": \"manual-extract\",\n            \"db_dump\": \"db_dumps\\/20250801171509-dump.sql\",\n            \"inst_chunk_data\": \"installer-chunk-data.json\",\n            \"inst_notices\": \"installer-notices.json\",\n            \"inst_db_data\": \"installer-db-data.json\",\n            \"inst_db_seek_log\": \"installer-db-seek-tell-log.txt\",\n            \"inst_extraction_data\": \"installer-extraction.json\",\n            \"inst_s3_data\": \"installer-s3data.json\",\n            \"inst_php_error_log\": \"php_error.log\",\n            \"params\": \"params.json\"\n        }\n    },\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 2,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 3,\n            \"storageClass\": \"Duplicator\\\\Models\\\\Storages\\\\AbstractStorageEntity\",\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1754068624,\n            \"stopped_timestamp\": 1754068625,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"packageExists\": true,\n            \"isDownloadFromRemote\": false,\n            \"copyExtraData\": []\n        }\n    ],\n    \"active_storage_id\": 3,\n    \"template_id\": -1,\n    \"buildEmailSent\": false,\n    \"version\": \"4.5.22.2\",\n    \"created\": \"2025-08-01 17:15:09\",\n    \"updated\": \"2025-08-01 17:17:05\",\n    \"flags\": [\n        \"MANUAL\",\n        \"ZIP_ARCHIVE\",\n        \"HAVE_LOCAL\",\n        \"DISASTER_AVAIABLE\"\n    ],\n    \"flagUpdatedAfterLoad\": false,\n    \"mainScanLogId\": 3,\n    \"mainActivityLogId\": 5\n}","4.5.22.2","2025-08-01 17:15:09","2025-08-01 17:17:05"),
("4","Standard","CopiedusiteCreaKonect","d35f4eb0e04407953532_20250803185826","CopiedusiteCreaKonect_d35f4eb0e04407953532_20250803185826_archive.zip","5","MANUAL,ZIP_ARCHIVE,TEMPORARY","{\n    \"ID\": 4,\n    \"VersionWP\": \"6.8.2\",\n    \"VersionDB\": \"11.4.7\",\n    \"VersionPHP\": \"8.2.29\",\n    \"VersionOS\": \"Linux\",\n    \"name\": \"CopiedusiteCreaKonect\",\n    \"hash\": \"d35f4eb0e04407953532_20250803185826\",\n    \"execType\": 0,\n    \"notes\": \"\",\n    \"StorePath\": \"\\/srv\\/htdocs\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/creakonect.com\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"CopiedusiteCreaKonect_d35f4eb0e04407953532_20250803185826_scan.json\",\n    \"timer_start\": -1,\n    \"Runtime\": \"\",\n    \"ExeSize\": \"0\",\n    \"ZipSize\": \"0\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/srv\\/htdocs\\/wp-content\\/ai1wm-backups\",\n            \"\\/srv\\/htdocs\\/wp-content\\/backups-dup-lite\",\n            \"\\/srv\\/htdocs\\/wp-content\\/backups-dup-pro\",\n            \"\\/srv\\/htdocs\\/wp-content\\/backupwordpress\",\n            \"\\/srv\\/htdocs\\/wp-content\\/bps-backup\",\n            \"\\/srv\\/htdocs\\/wp-content\\/cache\",\n            \"\\/srv\\/htdocs\\/wp-content\\/content\\/cache\",\n            \"\\/srv\\/htdocs\\/wp-content\\/contents\\/cache\",\n            \"\\/srv\\/htdocs\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/srv\\/htdocs\\/wp-content\\/managewp\\/backups\",\n            \"\\/srv\\/htdocs\\/wp-content\\/old-cache\",\n            \"\\/srv\\/htdocs\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/srv\\/htdocs\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/srv\\/htdocs\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/srv\\/htdocs\\/wp-content\\/updraft\",\n            \"\\/srv\\/htdocs\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/srv\\/htdocs\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/srv\\/htdocs\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/srv\\/htdocs\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/srv\\/htdocs\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/srv\\/htdocs\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/srv\\/htdocs\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/srv\\/htdocs\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/srv\\/htdocs\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/srv\\/htdocs\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/srv\\/htdocs\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/srv\\/htdocs\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/srv\\/htdocs\\/wp-content\\/wfcache\",\n            \"\\/srv\\/htdocs\\/wp-content\\/wishlist-backup\",\n            \"\\/srv\\/htdocs\\/wp-content\\/wpvividbackups\",\n            \"\\/wordpress\\/core\\/6.8.2\\/.opcache\",\n            \"\\/wordpress\\/core\\/6.8.2\\/.tmb\",\n            \"\\/wordpress\\/core\\/6.8.2\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/srv\\/htdocs\\/wp-content\\/debug.log\",\n            \"\\/wordpress\\/core\\/6.8.2\\/.htaccess\",\n            \"\\/wordpress\\/core\\/6.8.2\\/.user.ini\",\n            \"\\/wordpress\\/core\\/6.8.2\\/php.ini\",\n            \"\\/wordpress\\/core\\/6.8.2\\/web.config\",\n            \"\\/wordpress\\/core\\/wp-config.php\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": true,\n        \"FilterNames\": false,\n        \"File\": \"CopiedusiteCreaKonect_d35f4eb0e04407953532_20250803185826_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/\",\n        \"Size\": 626302123,\n        \"Dirs\": [],\n        \"DirCount\": 4678,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 28430,\n        \"file_count\": -1,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [\n                    {\n                        \"ubytes\": 142202723,\n                        \"bytes\": \"135.62MB\",\n                        \"nodes\": 5045,\n                        \"name\": \"jetpack\",\n                        \"dir\": \"srv\\/htdocs\\/wp-content\\/plugins\",\n                        \"path\": \"srv\\/htdocs\\/wp-content\\/plugins\\/jetpack\"\n                    },\n                    {\n                        \"ubytes\": 465913573,\n                        \"bytes\": \"444.33MB\",\n                        \"nodes\": 25031,\n                        \"name\": \"plugins\",\n                        \"dir\": \"srv\\/htdocs\\/wp-content\",\n                        \"path\": \"srv\\/htdocs\\/wp-content\\/plugins\"\n                    },\n                    {\n                        \"ubytes\": 551369244,\n                        \"bytes\": \"525.83MB\",\n                        \"nodes\": 29534,\n                        \"name\": \"wp-content\",\n                        \"dir\": \"srv\\/htdocs\",\n                        \"path\": \"srv\\/htdocs\\/wp-content\"\n                    }\n                ],\n                \"Core\": [],\n                \"Global\": [\n                    \"\\/wordpress\\/core\\/6.8.2\\/wp-snapshots\",\n                    \"\\/wordpress\\/core\\/6.8.2\\/.opcache\",\n                    \"\\/wordpress\\/core\\/6.8.2\\/.tmb\",\n                    \"\\/srv\\/htdocs\\/wp-content\\/backups-dup-lite\",\n                    \"\\/srv\\/htdocs\\/wp-content\\/backups-dup-pro\",\n                    \"\\/srv\\/htdocs\\/wp-content\\/ai1wm-backups\",\n                    \"\\/srv\\/htdocs\\/wp-content\\/backupwordpress\",\n                    \"\\/srv\\/htdocs\\/wp-content\\/content\\/cache\",\n                    \"\\/srv\\/htdocs\\/wp-content\\/contents\\/cache\",\n                    \"\\/srv\\/htdocs\\/wp-content\\/infinitewp\\/backups\",\n                    \"\\/srv\\/htdocs\\/wp-content\\/managewp\\/backups\",\n                    \"\\/srv\\/htdocs\\/wp-content\\/old-cache\",\n                    \"\\/srv\\/htdocs\\/wp-content\\/updraft\",\n                    \"\\/srv\\/htdocs\\/wp-content\\/wpvividbackups\",\n                    \"\\/srv\\/htdocs\\/wp-content\\/wishlist-backup\",\n                    \"\\/srv\\/htdocs\\/wp-content\\/wfcache\",\n                    \"\\/srv\\/htdocs\\/wp-content\\/bps-backup\",\n                    \"\\/srv\\/htdocs\\/wp-content\\/cache\",\n                    \"\\/srv\\/htdocs\\/wp-content\\/uploads\\/aiowps_backups\",\n                    \"\\/srv\\/htdocs\\/wp-content\\/uploads\\/backupbuddy_temp\",\n                    \"\\/srv\\/htdocs\\/wp-content\\/uploads\\/backupbuddy_backups\",\n                    \"\\/srv\\/htdocs\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n                    \"\\/srv\\/htdocs\\/wp-content\\/uploads\\/mainwp\\/backup\",\n                    \"\\/srv\\/htdocs\\/wp-content\\/uploads\\/pb_backupbuddy\",\n                    \"\\/srv\\/htdocs\\/wp-content\\/uploads\\/snapshots\",\n                    \"\\/srv\\/htdocs\\/wp-content\\/uploads\\/sucuri\",\n                    \"\\/srv\\/htdocs\\/wp-content\\/uploads\\/wp-clone\",\n                    \"\\/srv\\/htdocs\\/wp-content\\/uploads\\/wp_all_backup\",\n                    \"\\/srv\\/htdocs\\/wp-content\\/uploads\\/wpbackitup_backups\",\n                    \"\\/srv\\/htdocs\\/wp-content\\/uploads\\/backup-guard\",\n                    \"\\/srv\\/htdocs\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n                    \"\\/srv\\/htdocs\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n                    \"\\/srv\\/htdocs\\/wp-content\\/plugins\\/wordfence\\/tmp\"\n                ],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Files\": {\n                \"Size\": [\n                    {\n                        \"ubytes\": 4784788,\n                        \"bytes\": \"4.56MB\",\n                        \"nodes\": 1,\n                        \"name\": \"vips-heif.wasm\",\n                        \"dir\": \"srv\\/htdocs\\/wp-content\\/plugins\\/gutenberg\\/build\\/vips\",\n                        \"path\": \"srv\\/htdocs\\/wp-content\\/plugins\\/gutenberg\\/build\\/vips\\/vips-heif.wasm\"\n                    },\n                    {\n                        \"ubytes\": 5643656,\n                        \"bytes\": \"5.38MB\",\n                        \"nodes\": 1,\n                        \"name\": \"vips.wasm\",\n                        \"dir\": \"srv\\/htdocs\\/wp-content\\/plugins\\/gutenberg\\/build\\/vips\",\n                        \"path\": \"srv\\/htdocs\\/wp-content\\/plugins\\/gutenberg\\/build\\/vips\\/vips.wasm\"\n                    }\n                ],\n                \"Core\": [],\n                \"Global\": [\n                    \"error_log\",\n                    \"debug_log\",\n                    \"ws_ftp.log\",\n                    \"dbcache\",\n                    \"pgcache\",\n                    \"objectcache\",\n                    \".DS_Store\",\n                    \"\\/wordpress\\/core\\/6.8.2\\/.htaccess\",\n                    \"\\/wordpress\\/core\\/6.8.2\\/.user.ini\",\n                    \"\\/wordpress\\/core\\/6.8.2\\/php.ini\",\n                    \"\\/wordpress\\/core\\/6.8.2\\/web.config\",\n                    \"\\/srv\\/htdocs\\/wp-content\\/debug.log\",\n                    \"\\/wordpress\\/core\\/wp-config.php\"\n                ],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"TreeSize\": {\n                \"text\": \"\\/\",\n                \"type\": \"folder\",\n                \"children\": [\n                    {\n                        \"text\": \"\\/wordpress\\/core\\/6.8.2 <span class=\\\"size\\\" >71.46MB<\\/span> <span class=\\\"nodes\\\" >3574<\\/span>\",\n                        \"fullPath\": \"\\/wordpress\\/core\\/6.8.2\",\n                        \"type\": \"folder\",\n                        \"state\": {\n                            \"opened\": true,\n                            \"disabled\": true,\n                            \"selected\": false,\n                            \"checked\": false,\n                            \"checkbox_disabled\": true\n                        },\n                        \"children\": [\n                            {\n                                \"text\": \"No large files found during this scan.\",\n                                \"type\": \"info-text\",\n                                \"state\": {\n                                    \"opened\": false,\n                                    \"disabled\": true,\n                                    \"selected\": false,\n                                    \"checked\": false,\n                                    \"checkbox_disabled\": true\n                                }\n                            }\n                        ],\n                        \"li_attr\": {\n                            \"data-full-loaded\": false,\n                            \"class\": \" root-node core-node no-warnings\"\n                        },\n                        \"a_attr\": {\n                            \"title\": \"Core WordPress directories should not be filtered. Use caution when excluding files.\"\n                        }\n                    },\n                    {\n                        \"text\": \"\\/srv\\/htdocs\\/wp-content <span class=\\\"size\\\" >525.83MB<\\/span> <span class=\\\"nodes\\\" >29534<\\/span>\",\n                        \"fullPath\": \"\\/srv\\/htdocs\\/wp-content\",\n                        \"type\": \"folder\",\n                        \"state\": {\n                            \"opened\": true,\n                            \"disabled\": false,\n                            \"selected\": false,\n                            \"checked\": false,\n                            \"checkbox_disabled\": false\n                        },\n                        \"children\": [\n                            {\n                                \"text\": \"plugins <span class=\\\"size\\\" >444.33MB<\\/span> <span class=\\\"nodes\\\" >25031<\\/span>\",\n                                \"fullPath\": \"\\/srv\\/htdocs\\/wp-content\\/plugins\",\n                                \"type\": \"folder\",\n                                \"state\": {\n                                    \"opened\": true,\n                                    \"disabled\": false,\n                                    \"selected\": false,\n                                    \"checked\": false,\n                                    \"checkbox_disabled\": false\n                                },\n                                \"children\": [\n                                    {\n                                        \"text\": \"jetpack <span class=\\\"size\\\" >135.62MB<\\/span> <span class=\\\"nodes\\\" >5045<\\/span>\",\n                                        \"fullPath\": \"\\/srv\\/htdocs\\/wp-content\\/plugins\\/jetpack\",\n                                        \"type\": \"folder\",\n                                        \"state\": {\n                                            \"opened\": false,\n                                            \"disabled\": false,\n                                            \"selected\": false,\n                                            \"checked\": false,\n                                            \"checkbox_disabled\": false\n                                        },\n                                        \"children\": true,\n                                        \"li_attr\": {\n                                            \"data-full-loaded\": false,\n                                            \"class\": \" warning-node\"\n                                        },\n                                        \"a_attr\": []\n                                    },\n                                    {\n                                        \"text\": \"gutenberg <span class=\\\"size\\\" >77.87MB<\\/span> <span class=\\\"nodes\\\" >2852<\\/span>\",\n                                        \"fullPath\": \"\\/srv\\/htdocs\\/wp-content\\/plugins\\/gutenberg\",\n                                        \"type\": \"folder\",\n                                        \"state\": {\n                                            \"opened\": true,\n                                            \"disabled\": false,\n                                            \"selected\": false,\n                                            \"checked\": false,\n                                            \"checkbox_disabled\": false\n                                        },\n                                        \"children\": [\n                                            {\n                                                \"text\": \"build <span class=\\\"size\\\" >51.89MB<\\/span> <span class=\\\"nodes\\\" >966<\\/span>\",\n                                                \"fullPath\": \"\\/srv\\/htdocs\\/wp-content\\/plugins\\/gutenberg\\/build\",\n                                                \"type\": \"folder\",\n                                                \"state\": {\n                                                    \"opened\": true,\n                                                    \"disabled\": false,\n                                                    \"selected\": false,\n                                                    \"checked\": false,\n                                                    \"checkbox_disabled\": false\n                                                },\n                                                \"children\": [\n                                                    {\n                                                        \"text\": \"vips <span class=\\\"size\\\" >12.66MB<\\/span> <span class=\\\"nodes\\\" >8<\\/span>\",\n                                                        \"fullPath\": \"\\/srv\\/htdocs\\/wp-content\\/plugins\\/gutenberg\\/build\\/vips\",\n                                                        \"type\": \"folder\",\n                                                        \"state\": {\n                                                            \"opened\": true,\n                                                            \"disabled\": false,\n                                                            \"selected\": false,\n                                                            \"checked\": false,\n                                                            \"checkbox_disabled\": false\n                                                        },\n                                                        \"children\": [\n                                                            {\n                                                                \"text\": \"vips-heif.wasm <span class=\\\"size\\\" >4.56MB<\\/span> <span class=\\\"nodes\\\" >&nbsp;<\\/span>\",\n                                                                \"fullPath\": \"\\/srv\\/htdocs\\/wp-content\\/plugins\\/gutenberg\\/build\\/vips\\/vips-heif.wasm\",\n                                                                \"type\": \"file\",\n                                                                \"state\": {\n                                                                    \"opened\": false,\n                                                                    \"disabled\": false,\n                                                                    \"selected\": false,\n                                                                    \"checked\": false,\n                                                                    \"checkbox_disabled\": false\n                                                                },\n                                                                \"children\": null,\n                                                                \"li_attr\": {\n                                                                    \"class\": \" warning-node\"\n                                                                },\n                                                                \"a_attr\": []\n                                                            },\n                                                            {\n                                                                \"text\": \"vips.wasm <span class=\\\"size\\\" >5.38MB<\\/span> <span class=\\\"nodes\\\" >&nbsp;<\\/span>\",\n                                                                \"fullPath\": \"\\/srv\\/htdocs\\/wp-content\\/plugins\\/gutenberg\\/build\\/vips\\/vips.wasm\",\n                                                                \"type\": \"file\",\n                                                                \"state\": {\n                                                                    \"opened\": false,\n                                                                    \"disabled\": false,\n                                                                    \"selected\": false,\n                                                                    \"checked\": false,\n                                                                    \"checkbox_disabled\": false\n                                                                },\n                                                                \"children\": null,\n                                                                \"li_attr\": {\n                                                                    \"class\": \" warning-node\"\n                                                                },\n                                                                \"a_attr\": []\n                                                            }\n                                                        ],\n                                                        \"li_attr\": {\n                                                            \"data-full-loaded\": false,\n                                                            \"class\": \" warning-childs\"\n                                                        },\n                                                        \"a_attr\": []\n                                                    }\n                                                ],\n                                                \"li_attr\": {\n                                                    \"data-full-loaded\": false,\n                                                    \"class\": \" warning-childs\"\n                                                },\n                                                \"a_attr\": []\n                                            }\n                                        ],\n                                        \"li_attr\": {\n                                            \"data-full-loaded\": false,\n                                            \"class\": \" warning-childs\"\n                                        },\n                                        \"a_attr\": []\n                                    }\n                                ],\n                                \"li_attr\": {\n                                    \"data-full-loaded\": false,\n                                    \"class\": \" warning-node\"\n                                },\n                                \"a_attr\": []\n                            }\n                        ],\n                        \"li_attr\": {\n                            \"data-full-loaded\": false,\n                            \"class\": \" root-node warning-childs\"\n                        },\n                        \"a_attr\": []\n                    }\n                ],\n                \"state\": {\n                    \"opened\": true,\n                    \"disabled\": true,\n                    \"selected\": false,\n                    \"checked\": false,\n                    \"checkbox_disabled\": true\n                }\n            }\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"CopiedusiteCreaKonect_d35f4eb0e04407953532_20250803185826_installer.php\",\n        \"Size\": 0,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"N0EfHNFNfyolGorQSFMiAQTDtSxJf\\/i2UZrhDVTIl54KmxUydXGP5A\\/jVipInZkNTyEge2ECJki0IsPJ0r3CAw==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": false,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"latin1\",\n                \"utf8mb3\"\n            ],\n            \"collationList\": [\n                \"latin1_swedish_ci\",\n                \"utf8mb3_general_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"151049487\",\n            \"tablesBaseCount\": 67,\n            \"tablesFinalCount\": 67,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 6087,\n            \"tablesSizeOnDisk\": 17596416,\n            \"tablesList\": {\n                \"wp_bp_activity\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 180224\n                },\n                \"wp_bp_activity_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_bp_friends\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_bp_groups\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_bp_groups_groupmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_bp_groups_members\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"wp_bp_invitations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 163840\n                },\n                \"wp_bp_messages_messages\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_bp_messages_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_bp_messages_notices\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_bp_messages_recipients\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wp_bp_notifications\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"wp_bp_notifications_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_bp_optouts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_bp_user_blogs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_bp_user_blogs_blogmeta\": {\n                    \"inaccurateRows\": \"8\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_bp_xprofile_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_bp_xprofile_fields\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wp_bp_xprofile_groups\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_bp_xprofile_meta\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_commentmeta\": {\n                    \"inaccurateRows\": \"7\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wp_duplicator_activity_logs\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"wp_duplicator_backups\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 245760\n                },\n                \"wp_duplicator_entities\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 0,\n                    \"size\": 163840\n                },\n                \"wp_duplicator_packages\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_frm_fields\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_frm_forms\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_frm_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"wp_frm_item_metas\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_jetpack_sync_queue\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wp_links\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_mwai_filemeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_mwai_files\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_options\": {\n                    \"inaccurateRows\": \"518\",\n                    \"insertedRows\": 0,\n                    \"size\": 2244608\n                },\n                \"wp_postmeta\": {\n                    \"inaccurateRows\": \"4172\",\n                    \"insertedRows\": 0,\n                    \"size\": 7110656\n                },\n                \"wp_posts\": {\n                    \"inaccurateRows\": \"882\",\n                    \"insertedRows\": 0,\n                    \"size\": 4472832\n                },\n                \"wp_signups\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wp_termmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_terms\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_term_relationships\": {\n                    \"inaccurateRows\": \"57\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_term_taxonomy\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_usermeta\": {\n                    \"inaccurateRows\": \"42\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_users\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wpgmza\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wpgmza_admin_notices\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wpgmza_circles\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wpgmza_image_overlays\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wpgmza_maps\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wpgmza_point_labels\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wpgmza_polygon\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wpgmza_polylines\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wpgmza_rectangles\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wpum_fieldmeta\": {\n                    \"inaccurateRows\": \"35\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_wpum_fields\": {\n                    \"inaccurateRows\": \"11\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_wpum_fieldsgroups\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_wpum_registration_formmeta\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_wpum_registration_forms\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wpum_search_fields\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wpum_stripe_invoices\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wpum_stripe_subscriptions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_yoast_indexable\": {\n                    \"inaccurateRows\": \"59\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"wp_yoast_indexable_hierarchy\": {\n                    \"inaccurateRows\": \"58\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_yoast_migrations\": {\n                    \"inaccurateRows\": \"24\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_yoast_primary_term\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_yoast_seo_links\": {\n                    \"inaccurateRows\": \"111\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                }\n            },\n            \"dbEngine\": \"MariaDB\",\n            \"version\": \"11.4.7\",\n            \"versionComment\": \"MariaDB Server\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 0,\n        \"File\": \"CopiedusiteCreaKonect_d35f4eb0e04407953532_20250803185826_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MariaDB Server\",\n        \"dbStorePathPublic\": \"\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"status\": 5,\n    \"progressPercent\": 5,\n    \"schedule_id\": -1,\n    \"descriptorsMng\": null,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 2,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 3,\n            \"storageClass\": \"Duplicator\\\\Models\\\\Storages\\\\AbstractStorageEntity\",\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"packageExists\": true,\n            \"isDownloadFromRemote\": false,\n            \"copyExtraData\": []\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1,\n    \"buildEmailSent\": false,\n    \"version\": \"4.5.22.2\",\n    \"created\": \"2025-08-03 18:58:26\",\n    \"updated\": \"2025-08-03 18:58:34\",\n    \"flags\": [\n        \"MANUAL\",\n        \"ZIP_ARCHIVE\",\n        \"TEMPORARY\"\n    ],\n    \"flagUpdatedAfterLoad\": false,\n    \"mainScanLogId\": 10,\n    \"mainActivityLogId\": 0\n}","4.5.22.2","2025-08-03 18:58:26","2025-08-03 18:58:34"),
("5","Standard","CopiedusiteCreaKonect","d35f4eb0e04407953532_20250803185826","CopiedusiteCreaKonect_d35f4eb0e04407953532_20250803185826_archive.zip","20","MANUAL,ZIP_ARCHIVE","{\n    \"ID\": 5,\n    \"VersionWP\": \"6.8.2\",\n    \"VersionDB\": \"11.4.7\",\n    \"VersionPHP\": \"8.2.29\",\n    \"VersionOS\": \"Linux\",\n    \"name\": \"CopiedusiteCreaKonect\",\n    \"hash\": \"d35f4eb0e04407953532_20250803185826\",\n    \"execType\": 0,\n    \"notes\": \"\",\n    \"StorePath\": \"\\/srv\\/htdocs\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/creakonect.com\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"CopiedusiteCreaKonect_d35f4eb0e04407953532_20250803185826_scan.json\",\n    \"timer_start\": 1754247540.728584,\n    \"Runtime\": \"\",\n    \"ExeSize\": \"0\",\n    \"ZipSize\": \"0\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/srv\\/htdocs\\/wp-content\\/ai1wm-backups\",\n            \"\\/srv\\/htdocs\\/wp-content\\/backups-dup-lite\",\n            \"\\/srv\\/htdocs\\/wp-content\\/backups-dup-pro\",\n            \"\\/srv\\/htdocs\\/wp-content\\/backupwordpress\",\n            \"\\/srv\\/htdocs\\/wp-content\\/bps-backup\",\n            \"\\/srv\\/htdocs\\/wp-content\\/cache\",\n            \"\\/srv\\/htdocs\\/wp-content\\/content\\/cache\",\n            \"\\/srv\\/htdocs\\/wp-content\\/contents\\/cache\",\n            \"\\/srv\\/htdocs\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/srv\\/htdocs\\/wp-content\\/managewp\\/backups\",\n            \"\\/srv\\/htdocs\\/wp-content\\/old-cache\",\n            \"\\/srv\\/htdocs\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/srv\\/htdocs\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/srv\\/htdocs\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/srv\\/htdocs\\/wp-content\\/updraft\",\n            \"\\/srv\\/htdocs\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/srv\\/htdocs\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/srv\\/htdocs\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/srv\\/htdocs\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/srv\\/htdocs\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/srv\\/htdocs\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/srv\\/htdocs\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/srv\\/htdocs\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/srv\\/htdocs\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/srv\\/htdocs\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/srv\\/htdocs\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/srv\\/htdocs\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/srv\\/htdocs\\/wp-content\\/wfcache\",\n            \"\\/srv\\/htdocs\\/wp-content\\/wishlist-backup\",\n            \"\\/srv\\/htdocs\\/wp-content\\/wpvividbackups\",\n            \"\\/wordpress\\/core\\/6.8.2\\/.opcache\",\n            \"\\/wordpress\\/core\\/6.8.2\\/.tmb\",\n            \"\\/wordpress\\/core\\/6.8.2\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/srv\\/htdocs\\/wp-content\\/debug.log\",\n            \"\\/wordpress\\/core\\/6.8.2\\/.htaccess\",\n            \"\\/wordpress\\/core\\/6.8.2\\/.user.ini\",\n            \"\\/wordpress\\/core\\/6.8.2\\/php.ini\",\n            \"\\/wordpress\\/core\\/6.8.2\\/web.config\",\n            \"\\/wordpress\\/core\\/wp-config.php\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": true,\n        \"FilterNames\": false,\n        \"File\": \"CopiedusiteCreaKonect_d35f4eb0e04407953532_20250803185826_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/\",\n        \"Size\": 626302123,\n        \"Dirs\": [],\n        \"DirCount\": 4678,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 28430,\n        \"file_count\": -1,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [\n                    {\n                        \"ubytes\": 142202723,\n                        \"bytes\": \"135.62MB\",\n                        \"nodes\": 5045,\n                        \"name\": \"jetpack\",\n                        \"dir\": \"srv\\/htdocs\\/wp-content\\/plugins\",\n                        \"path\": \"srv\\/htdocs\\/wp-content\\/plugins\\/jetpack\"\n                    },\n                    {\n                        \"ubytes\": 465913573,\n                        \"bytes\": \"444.33MB\",\n                        \"nodes\": 25031,\n                        \"name\": \"plugins\",\n                        \"dir\": \"srv\\/htdocs\\/wp-content\",\n                        \"path\": \"srv\\/htdocs\\/wp-content\\/plugins\"\n                    },\n                    {\n                        \"ubytes\": 551369244,\n                        \"bytes\": \"525.83MB\",\n                        \"nodes\": 29534,\n                        \"name\": \"wp-content\",\n                        \"dir\": \"srv\\/htdocs\",\n                        \"path\": \"srv\\/htdocs\\/wp-content\"\n                    }\n                ],\n                \"Core\": [],\n                \"Global\": [\n                    \"\\/wordpress\\/core\\/6.8.2\\/wp-snapshots\",\n                    \"\\/wordpress\\/core\\/6.8.2\\/.opcache\",\n                    \"\\/wordpress\\/core\\/6.8.2\\/.tmb\",\n                    \"\\/srv\\/htdocs\\/wp-content\\/backups-dup-lite\",\n                    \"\\/srv\\/htdocs\\/wp-content\\/backups-dup-pro\",\n                    \"\\/srv\\/htdocs\\/wp-content\\/ai1wm-backups\",\n                    \"\\/srv\\/htdocs\\/wp-content\\/backupwordpress\",\n                    \"\\/srv\\/htdocs\\/wp-content\\/content\\/cache\",\n                    \"\\/srv\\/htdocs\\/wp-content\\/contents\\/cache\",\n                    \"\\/srv\\/htdocs\\/wp-content\\/infinitewp\\/backups\",\n                    \"\\/srv\\/htdocs\\/wp-content\\/managewp\\/backups\",\n                    \"\\/srv\\/htdocs\\/wp-content\\/old-cache\",\n                    \"\\/srv\\/htdocs\\/wp-content\\/updraft\",\n                    \"\\/srv\\/htdocs\\/wp-content\\/wpvividbackups\",\n                    \"\\/srv\\/htdocs\\/wp-content\\/wishlist-backup\",\n                    \"\\/srv\\/htdocs\\/wp-content\\/wfcache\",\n                    \"\\/srv\\/htdocs\\/wp-content\\/bps-backup\",\n                    \"\\/srv\\/htdocs\\/wp-content\\/cache\",\n                    \"\\/srv\\/htdocs\\/wp-content\\/uploads\\/aiowps_backups\",\n                    \"\\/srv\\/htdocs\\/wp-content\\/uploads\\/backupbuddy_temp\",\n                    \"\\/srv\\/htdocs\\/wp-content\\/uploads\\/backupbuddy_backups\",\n                    \"\\/srv\\/htdocs\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n                    \"\\/srv\\/htdocs\\/wp-content\\/uploads\\/mainwp\\/backup\",\n                    \"\\/srv\\/htdocs\\/wp-content\\/uploads\\/pb_backupbuddy\",\n                    \"\\/srv\\/htdocs\\/wp-content\\/uploads\\/snapshots\",\n                    \"\\/srv\\/htdocs\\/wp-content\\/uploads\\/sucuri\",\n                    \"\\/srv\\/htdocs\\/wp-content\\/uploads\\/wp-clone\",\n                    \"\\/srv\\/htdocs\\/wp-content\\/uploads\\/wp_all_backup\",\n                    \"\\/srv\\/htdocs\\/wp-content\\/uploads\\/wpbackitup_backups\",\n                    \"\\/srv\\/htdocs\\/wp-content\\/uploads\\/backup-guard\",\n                    \"\\/srv\\/htdocs\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n                    \"\\/srv\\/htdocs\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n                    \"\\/srv\\/htdocs\\/wp-content\\/plugins\\/wordfence\\/tmp\"\n                ],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Files\": {\n                \"Size\": [\n                    {\n                        \"ubytes\": 4784788,\n                        \"bytes\": \"4.56MB\",\n                        \"nodes\": 1,\n                        \"name\": \"vips-heif.wasm\",\n                        \"dir\": \"srv\\/htdocs\\/wp-content\\/plugins\\/gutenberg\\/build\\/vips\",\n                        \"path\": \"srv\\/htdocs\\/wp-content\\/plugins\\/gutenberg\\/build\\/vips\\/vips-heif.wasm\"\n                    },\n                    {\n                        \"ubytes\": 5643656,\n                        \"bytes\": \"5.38MB\",\n                        \"nodes\": 1,\n                        \"name\": \"vips.wasm\",\n                        \"dir\": \"srv\\/htdocs\\/wp-content\\/plugins\\/gutenberg\\/build\\/vips\",\n                        \"path\": \"srv\\/htdocs\\/wp-content\\/plugins\\/gutenberg\\/build\\/vips\\/vips.wasm\"\n                    }\n                ],\n                \"Core\": [],\n                \"Global\": [\n                    \"error_log\",\n                    \"debug_log\",\n                    \"ws_ftp.log\",\n                    \"dbcache\",\n                    \"pgcache\",\n                    \"objectcache\",\n                    \".DS_Store\",\n                    \"\\/wordpress\\/core\\/6.8.2\\/.htaccess\",\n                    \"\\/wordpress\\/core\\/6.8.2\\/.user.ini\",\n                    \"\\/wordpress\\/core\\/6.8.2\\/php.ini\",\n                    \"\\/wordpress\\/core\\/6.8.2\\/web.config\",\n                    \"\\/srv\\/htdocs\\/wp-content\\/debug.log\",\n                    \"\\/wordpress\\/core\\/wp-config.php\"\n                ],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"TreeSize\": {\n                \"treeList\": []\n            }\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"CopiedusiteCreaKonect_d35f4eb0e04407953532_20250803185826_installer.php\",\n        \"Size\": 0,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"HQsXcjMURMoyUfTJ6SdVwN+z2rFQKuTtqcvZrWdUdgNKw6jRSO5ZJWgTNRK+\\/DQDCaBGpqQblOj4ik3Cw5YIXA==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": false,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"latin1\",\n                \"utf8mb3\"\n            ],\n            \"collationList\": [\n                \"latin1_swedish_ci\",\n                \"utf8mb3_general_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"151049487\",\n            \"tablesBaseCount\": 67,\n            \"tablesFinalCount\": 67,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 6087,\n            \"tablesSizeOnDisk\": 17596416,\n            \"tablesList\": {\n                \"wp_bp_activity\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 180224\n                },\n                \"wp_bp_activity_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_bp_friends\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_bp_groups\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_bp_groups_groupmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_bp_groups_members\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"wp_bp_invitations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 163840\n                },\n                \"wp_bp_messages_messages\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_bp_messages_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_bp_messages_notices\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_bp_messages_recipients\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wp_bp_notifications\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"wp_bp_notifications_meta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_bp_optouts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_bp_user_blogs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_bp_user_blogs_blogmeta\": {\n                    \"inaccurateRows\": \"8\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_bp_xprofile_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_bp_xprofile_fields\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wp_bp_xprofile_groups\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_bp_xprofile_meta\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_commentmeta\": {\n                    \"inaccurateRows\": \"7\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wp_duplicator_activity_logs\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"wp_duplicator_backups\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 245760\n                },\n                \"wp_duplicator_entities\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 0,\n                    \"size\": 163840\n                },\n                \"wp_duplicator_packages\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_e_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_frm_fields\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_frm_forms\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_frm_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"wp_frm_item_metas\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_jetpack_sync_queue\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wp_links\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_mwai_filemeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_mwai_files\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_options\": {\n                    \"inaccurateRows\": \"518\",\n                    \"insertedRows\": 0,\n                    \"size\": 2244608\n                },\n                \"wp_postmeta\": {\n                    \"inaccurateRows\": \"4172\",\n                    \"insertedRows\": 0,\n                    \"size\": 7110656\n                },\n                \"wp_posts\": {\n                    \"inaccurateRows\": \"882\",\n                    \"insertedRows\": 0,\n                    \"size\": 4472832\n                },\n                \"wp_signups\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wp_termmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_terms\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_term_relationships\": {\n                    \"inaccurateRows\": \"57\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_term_taxonomy\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_usermeta\": {\n                    \"inaccurateRows\": \"42\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_users\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wpgmza\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wpgmza_admin_notices\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wpgmza_circles\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wpgmza_image_overlays\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wpgmza_maps\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wpgmza_point_labels\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wpgmza_polygon\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wpgmza_polylines\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wpgmza_rectangles\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wpum_fieldmeta\": {\n                    \"inaccurateRows\": \"35\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_wpum_fields\": {\n                    \"inaccurateRows\": \"11\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_wpum_fieldsgroups\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_wpum_registration_formmeta\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_wpum_registration_forms\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wpum_search_fields\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wpum_stripe_invoices\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wpum_stripe_subscriptions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_yoast_indexable\": {\n                    \"inaccurateRows\": \"59\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"wp_yoast_indexable_hierarchy\": {\n                    \"inaccurateRows\": \"58\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_yoast_migrations\": {\n                    \"inaccurateRows\": \"24\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_yoast_primary_term\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_yoast_seo_links\": {\n                    \"inaccurateRows\": \"111\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                }\n            },\n            \"dbEngine\": \"MariaDB\",\n            \"version\": \"11.4.7\",\n            \"versionComment\": \"MariaDB Server\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 0,\n        \"File\": \"CopiedusiteCreaKonect_d35f4eb0e04407953532_20250803185826_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MariaDB Server\",\n        \"dbStorePathPublic\": \"\\/srv\\/htdocs\\/wp-content\\/backups-dup-pro\\/tmp\\/CopiedusiteCreaKonect_d35f4eb0e04407953532_20250803185826_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"status\": 20,\n    \"progressPercent\": 20,\n    \"schedule_id\": -1,\n    \"descriptorsMng\": null,\n    \"build_progress\": {\n        \"thread_start_time\": 1754247543,\n        \"initialized\": true,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 2,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [\n            \"wp_users\",\n            \"wp_usermeta\",\n            \"wp_bp_activity\",\n            \"wp_bp_activity_meta\",\n            \"wp_bp_friends\",\n            \"wp_bp_groups\",\n            \"wp_bp_groups_groupmeta\",\n            \"wp_bp_groups_members\",\n            \"wp_bp_invitations\",\n            \"wp_bp_messages_messages\",\n            \"wp_bp_messages_meta\",\n            \"wp_bp_messages_notices\",\n            \"wp_bp_messages_recipients\",\n            \"wp_bp_notifications\",\n            \"wp_bp_notifications_meta\",\n            \"wp_bp_optouts\",\n            \"wp_bp_user_blogs\",\n            \"wp_bp_user_blogs_blogmeta\",\n            \"wp_bp_xprofile_data\",\n            \"wp_bp_xprofile_fields\",\n            \"wp_bp_xprofile_groups\",\n            \"wp_bp_xprofile_meta\",\n            \"wp_commentmeta\",\n            \"wp_comments\",\n            \"wp_duplicator_activity_logs\",\n            \"wp_duplicator_backups\",\n            \"wp_duplicator_entities\",\n            \"wp_duplicator_packages\",\n            \"wp_e_events\",\n            \"wp_frm_fields\",\n            \"wp_frm_forms\",\n            \"wp_frm_items\",\n            \"wp_frm_item_metas\",\n            \"wp_jetpack_sync_queue\",\n            \"wp_links\",\n            \"wp_mwai_filemeta\",\n            \"wp_mwai_files\",\n            \"wp_options\",\n            \"wp_postmeta\",\n            \"wp_posts\",\n            \"wp_signups\",\n            \"wp_termmeta\",\n            \"wp_terms\",\n            \"wp_term_relationships\",\n            \"wp_term_taxonomy\",\n            \"wp_wpgmza\",\n            \"wp_wpgmza_admin_notices\",\n            \"wp_wpgmza_circles\",\n            \"wp_wpgmza_image_overlays\",\n            \"wp_wpgmza_maps\",\n            \"wp_wpgmza_point_labels\",\n            \"wp_wpgmza_polygon\",\n            \"wp_wpgmza_polylines\",\n            \"wp_wpgmza_rectangles\",\n            \"wp_wpum_fieldmeta\",\n            \"wp_wpum_fields\",\n            \"wp_wpum_fieldsgroups\",\n            \"wp_wpum_registration_formmeta\",\n            \"wp_wpum_registration_forms\",\n            \"wp_wpum_search_fields\",\n            \"wp_wpum_stripe_invoices\",\n            \"wp_wpum_stripe_subscriptions\",\n            \"wp_yoast_indexable\",\n            \"wp_yoast_indexable_hierarchy\",\n            \"wp_yoast_migrations\",\n            \"wp_yoast_primary_term\",\n            \"wp_yoast_seo_links\"\n        ],\n        \"validationStage1\": false,\n        \"doneInit\": true,\n        \"doneFiltering\": true,\n        \"doneCreates\": true,\n        \"completed\": false,\n        \"startTime\": 1754247540.737811,\n        \"wasInterrupted\": true,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"countTotal\": 0,\n            \"impreciseTotalRows\": 6091,\n            \"tables\": {\n                \"wp_users\": {\n                    \"start\": \"1\",\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_usermeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_bp_activity\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_bp_activity_meta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_bp_friends\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_bp_groups\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_bp_groups_groupmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_bp_groups_members\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_bp_invitations\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_bp_messages_messages\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_bp_messages_meta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_bp_messages_notices\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_bp_messages_recipients\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_bp_notifications\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_bp_notifications_meta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_bp_optouts\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_bp_user_blogs\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_bp_user_blogs_blogmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_bp_xprofile_data\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_bp_xprofile_fields\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_bp_xprofile_groups\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_bp_xprofile_meta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_commentmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_comments\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_duplicator_activity_logs\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_duplicator_backups\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_duplicator_entities\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_duplicator_packages\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_e_events\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_frm_fields\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_frm_forms\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_frm_items\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_frm_item_metas\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_jetpack_sync_queue\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_links\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_mwai_filemeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_mwai_files\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_options\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_postmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_posts\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_signups\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_termmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_terms\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_term_relationships\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_term_taxonomy\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wpgmza\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wpgmza_admin_notices\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wpgmza_circles\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wpgmza_image_overlays\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wpgmza_maps\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wpgmza_point_labels\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wpgmza_polygon\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wpgmza_polylines\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wpgmza_rectangles\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wpum_fieldmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wpum_fields\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wpum_fieldsgroups\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wpum_registration_formmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wpum_registration_forms\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wpum_search_fields\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wpum_stripe_invoices\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wpum_stripe_subscriptions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_yoast_indexable\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_yoast_indexable_hierarchy\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_yoast_migrations\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_yoast_primary_term\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_yoast_seo_links\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                }\n            }\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 3,\n            \"storageClass\": \"Duplicator\\\\Models\\\\Storages\\\\AbstractStorageEntity\",\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"packageExists\": true,\n            \"isDownloadFromRemote\": false,\n            \"copyExtraData\": []\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1,\n    \"buildEmailSent\": false,\n    \"version\": \"4.5.22.2\",\n    \"created\": \"2025-08-03 18:58:26\",\n    \"updated\": \"2025-08-03 18:59:03\",\n    \"flags\": [\n        \"MANUAL\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false,\n    \"mainScanLogId\": 10,\n    \"mainActivityLogId\": 12\n}","4.5.22.2","2025-08-03 18:58:26","2025-08-03 18:59:03");

INSERT IGNORE INTO `wp_duplicator_entities` VALUES 
("1","DUP_PRO_Global_Entity","","","","","","{\n    \"uninstall_settings\": false,\n    \"uninstall_packages\": false,\n    \"crypt\": true,\n    \"email_summary_frequency\": \"weekly\",\n    \"email_summary_recipients\": [\n        \"lebonouvreboite@gmail.com\"\n    ],\n    \"usageTracking\": true,\n    \"amNotices\": true,\n    \"package_mysqldump\": false,\n    \"package_mysqldump_path\": \"\",\n    \"package_phpdump_mode\": 0,\n    \"package_mysqldump_qrylimit\": 131072,\n    \"packageMysqldumpOptions\": [\n        {\n            \"option\": \"quick\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"extended-insert\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"routines\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": true,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"disable-keys\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"compact\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        }\n    ],\n    \"archive_build_mode\": 2,\n    \"archive_compression\": true,\n    \"ziparchive_validation\": null,\n    \"ziparchive_mode\": 0,\n    \"ziparchive_chunk_size_in_mb\": 32,\n    \"homepath_as_abspath\": false,\n    \"server_load_reduction\": 0,\n    \"max_package_runtime_in_min\": 90,\n    \"max_package_transfer_time_in_min\": 90,\n    \"php_max_worker_time_in_sec\": 20,\n    \"cleanup_mode\": 0,\n    \"cleanup_email\": \"lebonouvreboite@gmail.com\",\n    \"auto_cleanup_hours\": 24,\n    \"lock_mode\": 1,\n    \"ajax_protocol\": \"https\",\n    \"custom_ajax_url\": \"https:\\/\\/creakonect.com\\/wp-admin\\/admin-ajax.php\",\n    \"clientside_kickoff\": false,\n    \"basic_auth_enabled\": false,\n    \"basic_auth_user\": \"\",\n    \"basic_auth_password\": \"\",\n    \"installer_name_mode\": \"withhash\",\n    \"installer_base_name\": \"installer.php\",\n    \"skip_archive_scan\": false,\n    \"send_email_on_build_mode\": 1,\n    \"notification_email_address\": \"\",\n    \"storage_htaccess_off\": false,\n    \"max_storage_retries\": 10,\n    \"purgeBackupRecords\": 0,\n    \"manual_mode_storage_ids\": [\n        3\n    ],\n    \"license_key_visible\": 1,\n    \"lkp\": \"\",\n    \"last_system_check_timestamp\": 0,\n    \"initial_activation_timestamp\": 1753457809,\n    \"ssl_useservercerts\": true,\n    \"ssl_disableverify\": true,\n    \"import_chunk_size\": 1024,\n    \"import_custom_path\": \"\",\n    \"ipv4_only\": false,\n    \"unhook_third_party_js\": false,\n    \"unhook_third_party_css\": false,\n    \"recoveryCustomPath\": \"\",\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 1,\n    \"version\": \"4.5.22.2\",\n    \"created\": \"2025-07-25 15:36:45\",\n    \"updated\": \"2025-08-03 18:58:26\"\n}","4.5.22.2","2025-07-25 15:36:45","2025-08-03 18:58:26"),
("2","Dynamic_Entity","","","","","","{\n    \"data\": \"wNWXze6P+ee6XtSHkFmUnF2uMvn4r8jpzThcC4lRV4+4YiShxjGmSOYVjVoi1mNod1wzHDmJYm2MBgic3HJmpOYVjVoi1mNoY4ei45+B5rKPEQTsIweBrF+AkijiOzs6Y2yXefGc+GI1sdc8SRCJqRU9YztI9UU+6Xtp7ZPXWa8k5AaKf4UwcF+AkijiOzs6oONubay8ICF6AMtg118RSPVEV4IhNBNuX23X7E0xX8B\\/oSiAZi85fL0pxbm+NV0j\",\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 2,\n    \"version\": \"4.5.22.2\",\n    \"created\": \"2025-07-25 15:36:45\",\n    \"updated\": \"2025-08-03 18:29:43\",\n    \"dataIsEncrypted\": true\n}","4.5.22.2","2025-07-25 15:36:45","2025-08-03 18:29:43"),
("3","DUP_PRO_Storage_Entity","","","","","","{\n    \"name\": \"Default\",\n    \"notes\": \"The default location for storage on this server.\",\n    \"storage_type\": -2,\n    \"config\": \"N764Clmnv5cyaDlPVJ9WeZ8keDIbMX14ajOPzt+fs3FMPSe38bI\\/FR\\/vZgvmZeic5pszoyQTyoEfNWJu9j53ztZX0KVGq\\/mOBRNzLWnEUUqBGCrNFt6b5VNJUv04t3k93rKFtaNXi3RFbH0iVpcXs4CRJnIjaS9dAPO0QMhx2jFmMn8pS9WR9qqcOtJXpakQnntULF2sftJI7oSjIqEcrUdzSRAW7svAaVp6pCn\\/IM4=\",\n    \"legacyEntity\": false,\n    \"local_storage_folder\": \"\",\n    \"local_max_files\": 10,\n    \"local_filter_protection\": true,\n    \"purge_package_record\": true,\n    \"dropbox_access_token\": \"\",\n    \"dropbox_access_token_secret\": \"\",\n    \"dropbox_v2_access_token\": \"\",\n    \"dropbox_storage_folder\": \"\",\n    \"dropbox_max_files\": 10,\n    \"dropbox_authorization_state\": 0,\n    \"onedrive_endpoint_url\": \"\",\n    \"onedrive_resource_id\": \"\",\n    \"onedrive_access_token\": \"\",\n    \"onedrive_refresh_token\": \"\",\n    \"onedrive_token_obtained\": 0,\n    \"onedrive_user_id\": \"\",\n    \"onedrive_storage_folder\": \"\",\n    \"onedrive_max_files\": 10,\n    \"onedrive_storage_folder_id\": \"\",\n    \"onedrive_authorization_state\": 0,\n    \"onedrive_storage_folder_web_url\": \"\",\n    \"ftp_server\": \"\",\n    \"ftp_port\": 21,\n    \"ftp_username\": \"\",\n    \"ftp_password\": \"\",\n    \"ftp_use_curl\": false,\n    \"ftp_storage_folder\": \"\",\n    \"ftp_max_files\": 10,\n    \"ftp_timeout_in_secs\": 15,\n    \"ftp_ssl\": false,\n    \"ftp_passive_mode\": false,\n    \"sftp_server\": \"\",\n    \"sftp_port\": 22,\n    \"sftp_username\": \"\",\n    \"sftp_password\": \"\",\n    \"sftp_private_key\": \"\",\n    \"sftp_private_key_password\": \"\",\n    \"sftp_storage_folder\": \"\",\n    \"sftp_timeout_in_secs\": 15,\n    \"sftp_max_files\": 10,\n    \"sftp_disable_chunking_mode\": false,\n    \"gdrive_access_token_set_json\": \"\",\n    \"gdrive_refresh_token\": \"\",\n    \"gdrive_storage_folder\": \"\",\n    \"gdrive_max_files\": 10,\n    \"gdrive_authorization_state\": 0,\n    \"gdrive_client_number\": -1,\n    \"s3_access_key\": \"\",\n    \"s3_bucket\": \"\",\n    \"s3_max_files\": 10,\n    \"s3_provider\": \"amazon\",\n    \"s3_region\": \"\",\n    \"s3_endpoint\": \"\",\n    \"s3_secret_key\": \"\",\n    \"s3_storage_class\": \"STANDARD\",\n    \"s3_storage_folder\": \"\",\n    \"s3_ACL_full_control\": true,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 3,\n    \"version\": \"4.5.22.2\",\n    \"created\": \"2025-07-25 15:36:45\",\n    \"updated\": \"2025-07-25 15:36:45\"\n}","4.5.22.2","2025-07-25 15:36:45","2025-07-25 15:36:45"),
("4","EmailSummary","","","","","","{\n    \"manualPackageIds\": [\n        3\n    ],\n    \"scheduledPackageIds\": [],\n    \"failedPackageIds\": [],\n    \"failedUploads\": [],\n    \"cancelledUploads\": [],\n    \"successfulUploads\": [],\n    \"scheduleIds\": [],\n    \"storageIds\": [\n        9\n    ],\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 4,\n    \"version\": \"4.5.22.2\",\n    \"created\": \"2025-07-25 15:36:45\",\n    \"updated\": \"2025-08-01 17:17:03\"\n}","4.5.22.2","2025-07-25 15:36:45","2025-08-01 17:17:03"),
("5","DUP_PRO_Package_Template_Entity","","","","","","{\n    \"name\": \"Default\",\n    \"package_name_format\": \"%year%%month%%day%_%sitetitle%\",\n    \"notes\": \"The default template.\",\n    \"filter_sites\": [],\n    \"archive_export_onlydb\": false,\n    \"archive_filter_on\": false,\n    \"archive_filter_dirs\": \"\",\n    \"archive_filter_exts\": \"\",\n    \"archive_filter_files\": \"\",\n    \"archive_filter_names\": false,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"database_filter_on\": false,\n    \"databasePrefixFilter\": false,\n    \"databasePrefixSubFilter\": false,\n    \"database_filter_tables\": \"\",\n    \"database_compatibility_modes\": \"\",\n    \"installer_opts_secure_on\": 0,\n    \"installerPassowrd\": \"xUf3UI0zaGC4r7MuRVwRnbqfEp6jzem2swtTPH5pUBJ7koY6iOPzSuEEhZRdPk7Fv8K1hCk746XIaSmPK2DerQ==\",\n    \"installer_opts_skip_scan\": false,\n    \"installer_opts_db_host\": \"\",\n    \"installer_opts_db_name\": \"\",\n    \"installer_opts_db_user\": \"\",\n    \"installer_opts_cpnl_enable\": false,\n    \"installer_opts_cpnl_host\": \"\",\n    \"installer_opts_cpnl_user\": \"\",\n    \"installer_opts_cpnl_pass\": \"\",\n    \"installer_opts_cpnl_db_action\": \"create\",\n    \"installer_opts_cpnl_db_host\": \"\",\n    \"installer_opts_cpnl_db_name\": \"\",\n    \"installer_opts_cpnl_db_user\": \"\",\n    \"installer_opts_brand\": -2,\n    \"is_default\": true,\n    \"is_manual\": false,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 5,\n    \"version\": \"4.5.22.2\",\n    \"created\": \"2025-07-25 15:36:45\",\n    \"updated\": \"2025-07-25 15:36:45\"\n}","4.5.22.2","2025-07-25 15:36:45","2025-07-25 15:36:45"),
("6","DUP_PRO_Package_Template_Entity","","","","","","{\n    \"name\": \"[Manual Mode]\",\n    \"package_name_format\": \"Copie du site Crea Konect\",\n    \"notes\": \"\",\n    \"filter_sites\": \"\",\n    \"archive_export_onlydb\": false,\n    \"archive_filter_on\": true,\n    \"archive_filter_dirs\": \"\",\n    \"archive_filter_exts\": \"\",\n    \"archive_filter_files\": \"\",\n    \"archive_filter_names\": false,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"database_filter_on\": false,\n    \"databasePrefixFilter\": false,\n    \"databasePrefixSubFilter\": false,\n    \"database_filter_tables\": \"\",\n    \"database_compatibility_modes\": \"\",\n    \"installer_opts_secure_on\": 0,\n    \"installerPassowrd\": \"I0z\\/UgJTfzlTXaLMhlmbYwNKexCLuqC\\/gkZbCIuYcyUqxHkmSzOtPM4d6PeXvOQc9uDCKK7ZhOiq5ZKV\\/ylzWw==\",\n    \"installer_opts_skip_scan\": false,\n    \"installer_opts_db_host\": \"\",\n    \"installer_opts_db_name\": \"\",\n    \"installer_opts_db_user\": \"\",\n    \"installer_opts_cpnl_enable\": false,\n    \"installer_opts_cpnl_host\": \"\",\n    \"installer_opts_cpnl_user\": \"\",\n    \"installer_opts_cpnl_pass\": \"\",\n    \"installer_opts_cpnl_db_action\": \"create\",\n    \"installer_opts_cpnl_db_host\": \"\",\n    \"installer_opts_cpnl_db_name\": \"\",\n    \"installer_opts_cpnl_db_user\": \"\",\n    \"installer_opts_brand\": -1,\n    \"is_default\": false,\n    \"is_manual\": true,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 6,\n    \"version\": \"4.5.22.2\",\n    \"created\": \"2025-07-25 15:36:45\",\n    \"updated\": \"2025-08-03 18:58:26\"\n}","4.5.22.2","2025-07-25 15:36:45","2025-08-03 18:58:26"),
("7","LicenseDataEntity","","","","","","{\n    \"licenseKey\": \"VAD+xoo91ewvS99B2FR2Y+6sRXiX77jOzsuil70hFGVFEVDQE1QwM\\/xbQ80+AplMsfzy0njtbqWuz87kFUdE+xYgodVIPdrUHEPHf9s\\/fFY6Jx5+YzWnfWgU97cLN6yS\",\n    \"status\": \"cOvzCv5PwE1pFLrS8Ok4kBU1AmaDHztJ7RjEozpHWlxHtyL3Ycc\\/b+0R9mXUA1jqII2OIABUurmL5VUXckcuHDvoedCWgZ3t\",\n    \"type\": \"FTdTTMao0tSWnZe6pcFzANXyVNbrIgIheNOBz+dGwhRNh+8bgKw4fq6cJe4Jd74xaGXSrl\\/U6bhDluXHDDh4bWZhceMQbcwD\",\n    \"data\": \"QX5uXqZNRSdwqtNRkHhsAsGzYFoKi4rPA7Rnhpga7EMfq3RJvIUXO7+kLz8hr\\/LGtc63LqFD87N\\/LcJKFLD9zTuStDBb2N1KRdVPWTKaGscyLEM+xt52ZWr9LkGqt142hP2hU4PizhDnV6zu253X7fOg3yt34p8YfWsDhEUeKHHHe6JCCb\\/bKjUHrU6hi0kD4vt4gkLckfBouuZXot71qiyOR7W\\/vNwlSXUKY+9uOBdwGFdAMQaAyL8ysoyQC8xSxrIWvHTR6365E6l2zQ5lriLYb2BiHpyydSR6cqvyuUHjY7V2VXJx4KgLndlHj0NvDNSgK6M\\/pf2bEoxObTvywP2mMG6wOhyZPT+CQHkyBmETP1swaG56z3tGAc3j4WHtSrXkABtAep22AR+DSMAc4R1f21DzzhTgMib9CNNG+\\/lSSY7XD57pwOLxTRr\\/s3XsYNmhDD7pJpNYu00xozz0pTpV172mLV2+H54qZQcqy4H3SfAQWoQM7UhH+X2LAr0FJ06qyVqmSnY+gpCoostnkLzTOnRefOGl\",\n    \"lastRemoteUpdate\": \"2025-08-01 15:45:13\",\n    \"lastFailureTime\": \"\",\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 7,\n    \"version\": \"4.5.22.2\",\n    \"created\": \"2025-07-25 15:36:45\",\n    \"updated\": \"2025-08-01 15:45:13\"\n}","4.5.22.2","2025-07-25 15:36:45","2025-08-01 15:45:13"),
("8","DUP_PRO_System_Global_Entity","","","","","","{\n    \"recommended_fixes\": [],\n    \"schedule_failed\": false,\n    \"package_check_ts\": 1754247539,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 8,\n    \"version\": \"4.5.22.2\",\n    \"created\": \"2025-07-25 15:36:47\",\n    \"updated\": \"2025-08-03 18:58:59\"\n}","4.5.22.2","2025-07-25 15:36:47","2025-08-03 18:58:59"),
("9","DUP_PRO_Storage_Entity","","","","","","{\n    \"name\": \"Copie du site Crea Konect.com\",\n    \"notes\": \"\",\n    \"storage_type\": 7,\n    \"config\": \"SCu18PzNYPWuvgjMYk7LJ4smEK6srvI9DDw5Vrqi+JQ9Jb7XJAJ2Fs2xaBb0XiVi7PL12aAF4z9bnflqsOqqvKlwdVBNmw8BtilwxGVJyfiD7g4Lf9GndARJHBish10z8soiYJaor9CkTumBz37uGt6ht1fU5ZS8jCQ0+IN9aaiToon+nxf0wMyatXMEBQPFtr7HF\\/WoMhCsJ8LImaiT0TxyixImh7m0Icz9kjUbkKX2cm44EqKnw8yBoAhRi46czfnocKjncH3ixczdGmDzmUpMkQ1fwQYLfxO2SkLy4nNbY86W1H1gcgxUwfXz86c8GG00s7hGu80dzT2nqWXxnKl+V2uDic66ckpMwN5BHTibndyXvBcgNU+uvcKLnYadJV1UpibOoqaX3KZuN7BXTQ==\",\n    \"legacyEntity\": false,\n    \"local_storage_folder\": \"\",\n    \"local_max_files\": 10,\n    \"local_filter_protection\": true,\n    \"purge_package_record\": true,\n    \"dropbox_access_token\": \"\",\n    \"dropbox_access_token_secret\": \"\",\n    \"dropbox_v2_access_token\": \"\",\n    \"dropbox_storage_folder\": \"\",\n    \"dropbox_max_files\": 10,\n    \"dropbox_authorization_state\": 0,\n    \"onedrive_endpoint_url\": \"\",\n    \"onedrive_resource_id\": \"\",\n    \"onedrive_access_token\": \"\",\n    \"onedrive_refresh_token\": \"\",\n    \"onedrive_token_obtained\": 0,\n    \"onedrive_user_id\": \"\",\n    \"onedrive_storage_folder\": \"\",\n    \"onedrive_max_files\": 10,\n    \"onedrive_storage_folder_id\": \"\",\n    \"onedrive_authorization_state\": 0,\n    \"onedrive_storage_folder_web_url\": \"\",\n    \"ftp_server\": \"\",\n    \"ftp_port\": 21,\n    \"ftp_username\": \"\",\n    \"ftp_password\": \"\",\n    \"ftp_use_curl\": false,\n    \"ftp_storage_folder\": \"\",\n    \"ftp_max_files\": 10,\n    \"ftp_timeout_in_secs\": 15,\n    \"ftp_ssl\": false,\n    \"ftp_passive_mode\": false,\n    \"sftp_server\": \"\",\n    \"sftp_port\": 22,\n    \"sftp_username\": \"\",\n    \"sftp_password\": \"\",\n    \"sftp_private_key\": \"\",\n    \"sftp_private_key_password\": \"\",\n    \"sftp_storage_folder\": \"\",\n    \"sftp_timeout_in_secs\": 15,\n    \"sftp_max_files\": 10,\n    \"sftp_disable_chunking_mode\": false,\n    \"gdrive_access_token_set_json\": \"\",\n    \"gdrive_refresh_token\": \"\",\n    \"gdrive_storage_folder\": \"\",\n    \"gdrive_max_files\": 10,\n    \"gdrive_authorization_state\": 0,\n    \"gdrive_client_number\": -1,\n    \"s3_access_key\": \"\",\n    \"s3_bucket\": \"\",\n    \"s3_max_files\": 10,\n    \"s3_provider\": \"amazon\",\n    \"s3_region\": \"\",\n    \"s3_endpoint\": \"\",\n    \"s3_secret_key\": \"\",\n    \"s3_storage_class\": \"STANDARD\",\n    \"s3_storage_folder\": \"\",\n    \"s3_ACL_full_control\": true,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 9,\n    \"version\": \"4.5.22.2\",\n    \"created\": \"2025-07-29 16:54:51\",\n    \"updated\": \"2025-07-29 17:29:30\"\n}","4.5.22.2","2025-07-29 16:54:51","2025-07-29 17:29:30");

INSERT IGNORE INTO `wp_frm_fields` VALUES 
("1","qh4icy","Name","First","text","","","1","1","a:18:{s:4:\"size\";s:0:\"\";s:3:\"max\";s:0:\"\";s:5:\"label\";s:0:\"\";s:5:\"blank\";s:0:\"\";s:18:\"required_indicator\";s:1:\"*\";s:7:\"invalid\";s:0:\"\";s:10:\"unique_msg\";s:0:\"\";s:14:\"separate_value\";i:0;s:14:\"clear_on_focus\";i:0;s:7:\"classes\";s:18:\"frm_first frm_half\";s:11:\"custom_html\";s:493:\"<div id=\"frm_field_[id]_container\" class=\"frm_form_field form-field [required_class][error_class]\">\n	<label for=\"field_[key]\" id=\"field_[key]_label\" class=\"frm_primary_label\">[field_name]\n		<span class=\"frm_required\" aria-hidden=\"true\">[required_label]</span>\n	</label>\n	[input]\n	[if description]<div class=\"frm_description\" id=\"frm_desc_field_[key]\">[description]</div>[/if description]\n	[if error]<div class=\"frm_error\" role=\"alert\" id=\"frm_error_field_[key]\">[error]</div>[/if error]\n</div>\";s:6:\"minnum\";i:1;s:6:\"maxnum\";i:10;s:4:\"step\";i:1;s:6:\"format\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:5:\"draft\";i:0;s:10:\"in_section\";i:0;}","1","2025-03-28 16:05:59"),
("2","ocfup1","Last","Last","text","","","2","1","a:18:{s:4:\"size\";s:0:\"\";s:3:\"max\";s:0:\"\";s:5:\"label\";s:6:\"hidden\";s:5:\"blank\";s:0:\"\";s:18:\"required_indicator\";s:1:\"*\";s:7:\"invalid\";s:0:\"\";s:10:\"unique_msg\";s:0:\"\";s:14:\"separate_value\";i:0;s:14:\"clear_on_focus\";i:0;s:7:\"classes\";s:8:\"frm_half\";s:11:\"custom_html\";s:493:\"<div id=\"frm_field_[id]_container\" class=\"frm_form_field form-field [required_class][error_class]\">\n	<label for=\"field_[key]\" id=\"field_[key]_label\" class=\"frm_primary_label\">[field_name]\n		<span class=\"frm_required\" aria-hidden=\"true\">[required_label]</span>\n	</label>\n	[input]\n	[if description]<div class=\"frm_description\" id=\"frm_desc_field_[key]\">[description]</div>[/if description]\n	[if error]<div class=\"frm_error\" role=\"alert\" id=\"frm_error_field_[key]\">[error]</div>[/if error]\n</div>\";s:6:\"minnum\";i:1;s:6:\"maxnum\";i:10;s:4:\"step\";i:1;s:6:\"format\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:5:\"draft\";i:0;s:10:\"in_section\";i:0;}","1","2025-03-28 16:05:59"),
("3","29yf4d","Email","","email","","","3","1","a:18:{s:4:\"size\";s:0:\"\";s:3:\"max\";s:0:\"\";s:5:\"label\";s:0:\"\";s:5:\"blank\";s:0:\"\";s:18:\"required_indicator\";s:1:\"*\";s:7:\"invalid\";s:34:\"Please enter a valid email address\";s:10:\"unique_msg\";s:0:\"\";s:14:\"separate_value\";i:0;s:14:\"clear_on_focus\";i:0;s:7:\"classes\";s:8:\"frm_full\";s:11:\"custom_html\";s:493:\"<div id=\"frm_field_[id]_container\" class=\"frm_form_field form-field [required_class][error_class]\">\n	<label for=\"field_[key]\" id=\"field_[key]_label\" class=\"frm_primary_label\">[field_name]\n		<span class=\"frm_required\" aria-hidden=\"true\">[required_label]</span>\n	</label>\n	[input]\n	[if description]<div class=\"frm_description\" id=\"frm_desc_field_[key]\">[description]</div>[/if description]\n	[if error]<div class=\"frm_error\" role=\"alert\" id=\"frm_error_field_[key]\">[error]</div>[/if error]\n</div>\";s:6:\"minnum\";i:1;s:6:\"maxnum\";i:10;s:4:\"step\";i:1;s:6:\"format\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:5:\"draft\";i:0;s:10:\"in_section\";i:0;}","1","2025-03-28 16:05:59"),
("4","e6lis6","Subject","","text","","","5","1","a:18:{s:4:\"size\";s:0:\"\";s:3:\"max\";s:0:\"\";s:5:\"label\";s:0:\"\";s:5:\"blank\";s:0:\"\";s:18:\"required_indicator\";s:1:\"*\";s:7:\"invalid\";s:0:\"\";s:10:\"unique_msg\";s:0:\"\";s:14:\"separate_value\";i:0;s:14:\"clear_on_focus\";i:0;s:7:\"classes\";s:8:\"frm_full\";s:11:\"custom_html\";s:493:\"<div id=\"frm_field_[id]_container\" class=\"frm_form_field form-field [required_class][error_class]\">\n	<label for=\"field_[key]\" id=\"field_[key]_label\" class=\"frm_primary_label\">[field_name]\n		<span class=\"frm_required\" aria-hidden=\"true\">[required_label]</span>\n	</label>\n	[input]\n	[if description]<div class=\"frm_description\" id=\"frm_desc_field_[key]\">[description]</div>[/if description]\n	[if error]<div class=\"frm_error\" role=\"alert\" id=\"frm_error_field_[key]\">[error]</div>[/if error]\n</div>\";s:6:\"minnum\";i:1;s:6:\"maxnum\";i:10;s:4:\"step\";i:1;s:6:\"format\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:5:\"draft\";i:0;s:10:\"in_section\";i:0;}","1","2025-03-28 16:05:59"),
("5","9jv0r1","Message","","textarea","","","6","1","a:18:{s:4:\"size\";s:0:\"\";s:3:\"max\";s:1:\"5\";s:5:\"label\";s:0:\"\";s:5:\"blank\";s:0:\"\";s:18:\"required_indicator\";s:1:\"*\";s:7:\"invalid\";s:0:\"\";s:10:\"unique_msg\";s:0:\"\";s:14:\"separate_value\";i:0;s:14:\"clear_on_focus\";i:0;s:7:\"classes\";s:8:\"frm_full\";s:11:\"custom_html\";s:493:\"<div id=\"frm_field_[id]_container\" class=\"frm_form_field form-field [required_class][error_class]\">\n	<label for=\"field_[key]\" id=\"field_[key]_label\" class=\"frm_primary_label\">[field_name]\n		<span class=\"frm_required\" aria-hidden=\"true\">[required_label]</span>\n	</label>\n	[input]\n	[if description]<div class=\"frm_description\" id=\"frm_desc_field_[key]\">[description]</div>[/if description]\n	[if error]<div class=\"frm_error\" role=\"alert\" id=\"frm_error_field_[key]\">[error]</div>[/if error]\n</div>\";s:6:\"minnum\";i:1;s:6:\"maxnum\";i:10;s:4:\"step\";i:1;s:6:\"format\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:5:\"draft\";i:0;s:10:\"in_section\";i:0;}","1","2025-03-28 16:05:59");

INSERT IGNORE INTO `wp_frm_forms` VALUES 
("1","contact-form","Contact Us","We would like to hear from you. Please send us a message by filling out the form below and we will get back with you shortly.","0","0","0","0","0","published","a:18:{s:12:\"custom_style\";i:1;s:12:\"submit_value\";s:7:\"Envoyer\";s:14:\"success_action\";s:7:\"message\";s:11:\"success_msg\";s:55:\"Vos réponses ont été soumises avec succès. Merci !\";s:9:\"show_form\";i:0;s:7:\"akismet\";s:0:\"\";s:8:\"honeypot\";s:5:\"basic\";s:8:\"antispam\";i:0;s:7:\"no_save\";i:0;s:9:\"ajax_load\";i:0;s:11:\"js_validate\";i:0;s:10:\"form_class\";s:0:\"\";s:11:\"before_html\";s:224:\"<legend class=\"frm_screen_reader\">[form_name]</legend>\n[if form_name]<h3 class=\"frm_form_title\">[form_name]</h3>[/if form_name]\n[if form_description]<div class=\"frm_description\">[form_description]</div>[/if form_description]\";s:10:\"after_html\";s:0:\"\";s:11:\"submit_html\";s:511:\"<div class=\"frm_submit frm_flex\">\n<button class=\"frm_button_submit\" type=\"submit\"  [button_action]>[button_label]</button>\n[if back_button]<button type=\"submit\" name=\"frm_prev_page\" formnovalidate=\"formnovalidate\" class=\"frm_prev_page\" [back_hook]>[back_label]</button>[/if back_button]\n[if save_draft]<button class=\"frm_save_draft\" [draft_hook]>[draft_label]</button>[/if save_draft]\n[if start_over]<a href=\"#\" tabindex=\"0\" class=\"frm_start_over\" [start_over_hook]>[start_over_label]</a>[/if start_over]\n</div>\";s:10:\"show_title\";i:0;s:16:\"show_description\";i:0;s:11:\"ajax_submit\";i:0;}","2025-03-28 16:05:59");

INSERT IGNORE INTO `wp_links` VALUES 
("1","https://dailypost.wordpress.com/","Get Inspired","","","","Y","1","0","0000-00-00 00:00:00","","",""),
("2","http://longreads.com/","Great Reads","","","","Y","1","0","0000-00-00 00:00:00","","",""),
("3","https://discover.wordpress.com/","Discover New Voices","","","","Y","1","0","0000-00-00 00:00:00","","",""),
("4","https://en.blog.wordpress.com/","WordPress.com Blog","","","","Y","1","0","0000-00-00 00:00:00","","","https://en.blog.wordpress.com/feed/"),
("5","https://en.support.wordpress.com/go-mobile/","Get Mobile","","","","Y","1","0","0000-00-00 00:00:00","","",""),
("6","https://crowdsignal.com/","Get Polling","","","","Y","1","0","0000-00-00 00:00:00","","",""),
("7","https://learn.wordpress.com/","Learn WordPress.com","","","","Y","1","0","0000-00-00 00:00:00","","",""),
("8","https://en.forums.wordpress.com/","Discuss","","","","Y","1","0","0000-00-00 00:00:00","","",""),
("9","https://en.support.wordpress.com/","Get Support","","","","Y","1","0","0000-00-00 00:00:00","","",""),
("10","https://wordpress.com/themes/","Theme Showcase","","","","Y","1","0","0000-00-00 00:00:00","","","");

INSERT IGNORE INTO `wp_options` VALUES 
("15","mailserver_url","mail.example.com","on"),
("16","mailserver_login","login@example.com","on"),
("17","mailserver_pass","","on"),
("18","mailserver_port","110","on"),
("34","active_plugins","a:21:{i:0;s:23:\"ai-engine/ai-engine.php\";i:1;s:19:\"akismet/akismet.php\";i:2;s:24:\"buddypress/bp-loader.php\";i:3;s:31:\"cookie-notice/cookie-notice.php\";i:4;s:39:\"crowdsignal-forms/crowdsignal-forms.php\";i:5;s:33:\"duplicator-pro/duplicator-pro.php\";i:6;s:38:\"easy-login-woocommerce/xoo-el-main.php\";i:7;s:23:\"elementor/elementor.php\";i:8;s:25:\"formidable/formidable.php\";i:9;s:23:\"gutenberg/gutenberg.php\";i:10;s:51:\"header-footer-elementor/header-footer-elementor.php\";i:11;s:19:\"jetpack/jetpack.php\";i:12;s:21:\"layout-grid/index.php\";i:13;s:27:\"optimole-wp/optimole-wp.php\";i:14;s:31:\"page-optimize/page-optimize.php\";i:15;s:23:\"polldaddy/polldaddy.php\";i:16;s:27:\"updraftplus/updraftplus.php\";i:17;s:24:\"wordpress-seo/wp-seo.php\";i:18;s:31:\"wp-google-maps/wpGoogleMaps.php\";i:19;s:37:\"wp-store-locator/wp-store-locator.php\";i:20;s:35:\"wp-user-manager/wp-user-manager.php\";}","on"),
("49","upload_path","","on"),
("53","tag_base","","on"),
("56","upload_url_path","","on"),
("80","uninstall_plugins","a:3:{s:31:\"page-optimize/page-optimize.php\";s:23:\"page_optimize_uninstall\";s:23:\"elementor/elementor.php\";a:2:{i:0;s:21:\"Elementor\\Maintenance\";i:1;s:9:\"uninstall\";}s:24:\"wordpress-seo/wp-seo.php\";s:14:\"__return_false\";}","off"),
("83","page_on_front","554","on"),
("86","finished_splitting_shared_terms","1","on"),
("88","medium_large_size_w","768","on"),
("89","medium_large_size_h","0","on"),
("91","show_comments_cookies_opt_in","1","on"),
("92","admin_email_lifespan","0","on"),
("93","disallowed_keys","","off"),
("94","comment_previously_approved","1","on"),
("95","auto_plugin_theme_update_emails","a:0:{}","off"),
("96","auto_update_core_dev","enabled","on"),
("97","auto_update_core_minor","enabled","on"),
("98","auto_update_core_major","unset","on"),
("99","wp_force_deactivated_plugins","a:0:{}","off"),
("100","wp_attachment_pages_enabled","1","on"),
("101","initial_db_version","58975","on"),
("102","wp_user_roles","a:8:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:92:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:20:\"wpseo_manage_options\";b:1;s:14:\"frm_view_forms\";b:1;s:14:\"frm_edit_forms\";b:1;s:16:\"frm_delete_forms\";b:1;s:19:\"frm_change_settings\";b:1;s:16:\"frm_view_entries\";b:1;s:18:\"frm_delete_entries\";b:1;s:11:\"bp_moderate\";b:1;s:20:\"manage_wpsl_settings\";b:1;s:10:\"edit_store\";b:1;s:10:\"read_store\";b:1;s:12:\"delete_store\";b:1;s:11:\"edit_stores\";b:1;s:18:\"edit_others_stores\";b:1;s:14:\"publish_stores\";b:1;s:19:\"read_private_stores\";b:1;s:13:\"delete_stores\";b:1;s:21:\"delete_private_stores\";b:1;s:23:\"delete_published_stores\";b:1;s:20:\"delete_others_stores\";b:1;s:19:\"edit_private_stores\";b:1;s:21:\"edit_published_stores\";b:1;s:20:\"duplicator_pro_basic\";b:1;s:21:\"duplicator_pro_create\";b:1;s:23:\"duplicator_pro_schedule\";b:1;s:22:\"duplicator_pro_storage\";b:1;s:29:\"duplicator_pro_backup_restore\";b:1;s:21:\"duplicator_pro_import\";b:1;s:21:\"duplicator_pro_export\";b:1;s:23:\"duplicator_pro_settings\";b:1;s:22:\"duplicator_pro_license\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:36:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:13:\"wpseo_manager\";a:2:{s:4:\"name\";s:11:\"SEO Manager\";s:12:\"capabilities\";a:38:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;s:20:\"wpseo_manage_options\";b:1;s:23:\"view_site_health_checks\";b:1;}}s:12:\"wpseo_editor\";a:2:{s:4:\"name\";s:10:\"SEO Editor\";s:12:\"capabilities\";a:36:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;}}s:26:\"wpsl_store_locator_manager\";a:2:{s:4:\"name\";s:21:\"Store Locator Manager\";s:12:\"capabilities\";a:37:{s:4:\"read\";b:1;s:10:\"edit_posts\";b:1;s:12:\"delete_posts\";b:1;s:15:\"unfiltered_html\";b:1;s:12:\"upload_files\";b:1;s:19:\"delete_others_pages\";b:1;s:19:\"delete_others_posts\";b:1;s:12:\"delete_pages\";b:1;s:20:\"delete_private_pages\";b:1;s:20:\"delete_private_posts\";b:1;s:22:\"delete_published_pages\";b:1;s:22:\"delete_published_posts\";b:1;s:17:\"edit_others_pages\";b:1;s:17:\"edit_others_posts\";b:1;s:10:\"edit_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"edit_private_posts\";b:1;s:20:\"edit_published_pages\";b:1;s:20:\"edit_published_posts\";b:1;s:17:\"moderate_comments\";b:1;s:13:\"publish_pages\";b:1;s:13:\"publish_posts\";b:1;s:18:\"read_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:10:\"edit_store\";b:1;s:10:\"read_store\";b:1;s:12:\"delete_store\";b:1;s:11:\"edit_stores\";b:1;s:18:\"edit_others_stores\";b:1;s:14:\"publish_stores\";b:1;s:19:\"read_private_stores\";b:1;s:13:\"delete_stores\";b:1;s:21:\"delete_private_stores\";b:1;s:23:\"delete_published_stores\";b:1;s:20:\"delete_others_stores\";b:1;s:19:\"edit_private_stores\";b:1;s:21:\"edit_published_stores\";b:1;}}}","on"),
("103","fresh_site","0","off"),
("104","user_count","1","off"),
("105","widget_block","a:11:{i:2;a:1:{s:7:\"content\";s:19:\"<!-- wp:search /-->\";}i:3;a:1:{s:7:\"content\";s:154:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Posts</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->\";}i:4;a:1:{s:7:\"content\";s:227:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Comments</h2><!-- /wp:heading --><!-- wp:latest-comments {\"displayAvatar\":false,\"displayDate\":false,\"displayExcerpt\":false} /--></div><!-- /wp:group -->\";}i:5;a:1:{s:7:\"content\";s:146:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Archives</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->\";}i:6;a:1:{s:7:\"content\";s:150:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Categories</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->\";}i:9;a:1:{s:7:\"content\";s:738:\"<!-- wp:cover {\"url\":\"https://creakonect.com/wp-content/uploads/2025/03/92c6a4e5-cb4a-4a85-9320-d6a961ee8163.jpg\",\"id\":156,\"alt\":\"Créa Konect Corporation\",\"dimRatio\":50,\"style\":{\"color\":{}}} -->\n<div class=\"wp-block-cover\"><img class=\"wp-block-cover__image-background wp-image-156\" alt=\"Créa Konect Corporation\" src=\"https://creakonect.com/wp-content/uploads/2025/03/92c6a4e5-cb4a-4a85-9320-d6a961ee8163.jpg\" data-object-fit=\"cover\"/><span aria-hidden=\"true\" class=\"wp-block-cover__background has-background-dim\"></span><div class=\"wp-block-cover__inner-container\"><!-- wp:paragraph {\"align\":\"center\",\"fontSize\":\"large\"} -->\n<p class=\"has-text-align-center has-large-font-size\"></p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:cover -->\";}i:11;a:1:{s:7:\"content\";s:101:\"<!-- wp:paragraph {\"align\":\"center\"} -->\n<p class=\"has-text-align-center\"></p>\n<!-- /wp:paragraph -->\";}i:13;a:1:{s:7:\"content\";s:56:\"<!-- wp:paragraph -->\n<p>2025</p>\n<!-- /wp:paragraph -->\";}i:14;a:1:{s:7:\"content\";s:52:\"<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->\";}i:16;a:1:{s:7:\"content\";s:317:\"<!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"66.66%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:66.66%\"></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"33.33%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:33.33%\"></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\";}s:12:\"_multiwidget\";i:1;}","on"),
("107","widget_pages","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("108","widget_calendar","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("110","widget_media_audio","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("111","widget_media_image","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("112","widget_media_gallery","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("113","widget_media_video","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("114","widget_meta","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("118","widget_tag_cloud","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("119","widget_nav_menu","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("120","widget_custom_html","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("121","jetpack_activated","1","auto"),
("122","jetpack_activation_source","a:2:{i:0;s:6:\"wp-cli\";i:1;N;}","auto"),
("123","jetpack_sync_settings_disable","0","on"),
("124","jetpack_options","a:10:{s:7:\"version\";s:19:\"14.9-a.7:1753791451\";s:11:\"old_version\";s:19:\"14.9-a.5:1753194690\";s:2:\"id\";s:9:\"242379716\";s:11:\"master_user\";i:263052659;s:21:\"publicize_connections\";b:0;s:28:\"fallback_no_verify_ssl_certs\";i:0;s:9:\"time_diff\";i:0;s:14:\"last_heartbeat\";i:1754234049;s:9:\"hide_jitm\";a:1:{s:12:\"upsell_nudge\";a:2:{s:14:\"last_dismissal\";i:1748185241;s:6:\"number\";i:2;}}s:16:\"first_admin_view\";b:1;}","auto"),
("128","theme_switched","","auto"),
("129","crowdsignal_forms_admin_notices","[\"core_setup\",\"setup_success\"]","off"),
("131","siteurl","http://creakonect.com/","yes"),
("132","home","http://creakonect.com/","yes"),
("133","blogname","","on"),
("134","blogdescription","","yes"),
("135","users_can_register","1","yes"),
("136","admin_email","lebonouvreboite@gmail.com","yes"),
("137","start_of_week","1","yes"),
("138","use_balanceTags","0","yes"),
("139","use_smilies","1","yes"),
("140","require_name_email","1","yes"),
("141","comments_notify","1","yes"),
("142","posts_per_rss","10","yes"),
("143","rss_use_excerpt","0","yes"),
("144","default_category","16080","yes"),
("145","default_comment_status","open","yes"),
("146","default_ping_status","open","yes"),
("147","default_pingback_flag","1","yes"),
("148","posts_per_page","10","yes"),
("149","date_format","j F Y","yes"),
("150","time_format","G \\h i \\m\\i\\n","yes"),
("151","links_updated_date_format","j F Y G \\h i \\m\\i\\n","yes"),
("152","comment_moderation","0","yes"),
("153","moderation_notify","1","yes"),
("154","permalink_structure","/%year%/%monthnum%/%day%/%postname%/","yes"),
("155","hack_file","0","yes"),
("156","blog_charset","UTF-8","yes"),
("157","moderation_keys","","yes"),
("158","category_base","","yes"),
("159","ping_sites","http://rpc.pingomatic.com/","yes"),
("160","comment_max_links","2","yes"),
("161","gmt_offset","1","yes"),
("162","default_email_category","1","yes"),
("163","recently_edited","a:4:{i:0;s:47:\"/srv/htdocs/wp-content/themes/revelar/style.css\";i:2;s:54:\"/srv/htdocs/wp-content/plugins/ai-engine/ai-engine.php\";i:3;s:44:\"/srv/htdocs/wp-content/themes/neve/style.css\";i:4;s:0:\"\";}","yes"),
("164","template","revelar","yes"),
("165","stylesheet","revelar","yes"),
("168","comment_registration","0","yes"),
("169","html_type","text/html","yes"),
("170","use_trackback","0","yes"),
("171","default_role","subscriber","yes"),
("172","db_version","60421","yes"),
("173","uploads_use_yearmonth_folders","1","yes"),
("174","blog_public","0","yes"),
("175","default_link_category","1356","yes"),
("176","show_on_front","page","on"),
("177","show_avatars","1","yes"),
("178","avatar_rating","G","yes"),
("179","thumbnail_size_w","150","yes"),
("180","thumbnail_size_h","150","yes"),
("181","thumbnail_crop","1","yes"),
("182","medium_size_w","300","yes"),
("183","medium_size_h","300","yes"),
("184","avatar_default","identicon","yes"),
("185","large_size_w","1024","yes"),
("186","large_size_h","1024","yes"),
("187","image_default_link_type","none","yes"),
("188","image_default_size","","yes"),
("189","image_default_align","","yes"),
("190","close_comments_for_old_posts","0","yes"),
("191","close_comments_days_old","14","yes"),
("192","thread_comments","1","yes"),
("193","thread_comments_depth","3","yes"),
("194","page_comments","1","yes"),
("195","comments_per_page","50","yes"),
("196","default_comments_page","newest","yes"),
("197","comment_order","asc","yes"),
("198","sticky_posts","a:0:{}","yes"),
("199","widget_categories","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("200","widget_text","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","auto"),
("201","widget_rss","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","auto"),
("202","timezone_string","Europe/Paris","yes"),
("203","page_for_posts","0","on"),
("204","default_post_format","0","yes"),
("205","link_manager_enabled","0","yes"),
("206","site_icon","0","yes"),
("207","wp_page_for_privacy_policy","0","yes"),
("208","widget_search","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("209","widget_recent-posts","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("210","site_creation_flow","premium","yes"),
("211","widget_recent-comments","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("212","widget_archives","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("213","post_count","2","yes"),
("214","sidebars_widgets","a:5:{s:19:\"wp_inactive_widgets\";a:8:{i:0;s:7:\"block-9\";i:1;s:8:\"block-13\";i:2;s:8:\"block-14\";i:3;s:7:\"block-2\";i:4;s:7:\"block-3\";i:5;s:7:\"block-4\";i:6;s:7:\"block-5\";i:7;s:7:\"block-6\";}s:9:\"sidebar-1\";a:0:{}s:9:\"sidebar-2\";a:2:{i:0;s:8:\"block-11\";i:1;s:8:\"block-16\";}s:9:\"sidebar-3\";a:0:{}s:13:\"array_version\";i:3;}","on"),
("215","sharing-services","a:2:{s:7:\"visible\";a:3:{i:0;s:10:\"press-this\";i:1;s:7:\"twitter\";i:2;s:8:\"facebook\";}s:6:\"hidden\";a:0:{}}","yes"),
("216","sharing-options","a:1:{s:6:\"global\";a:5:{s:12:\"button_style\";s:9:\"icon-text\";s:13:\"sharing_label\";b:0;s:10:\"open_links\";s:4:\"same\";s:4:\"show\";a:1:{i:0;s:4:\"post\";}s:6:\"custom\";a:0:{}}}","yes"),
("217","site_intent","build","yes"),
("218","jetpack_fonts","a:2:{s:8:\"migrated\";b:1;s:14:\"selected_fonts\";a:0:{}}","yes"),
("219","safecss_revision_migrated","0","yes"),
("220","cron","a:23:{i:1754247626;a:2:{s:17:\"jetpack_sync_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:21:\"jetpack_sync_interval\";s:4:\"args\";a:0:{}s:8:\"interval\";i:300;}}s:22:\"jetpack_sync_full_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:21:\"jetpack_sync_interval\";s:4:\"args\";a:0:{}s:8:\"interval\";i:300;}}}i:1754247789;a:1:{s:23:\"mwai_tasks_internal_run\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:8:\"mwai_5mn\";s:4:\"args\";a:0:{}s:8:\"interval\";i:300;}}}i:1754250789;a:1:{s:18:\"mwai_files_cleanup\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1754250889;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1754250896;a:1:{s:20:\"jetpack_clean_nonces\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1754252795;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1754276089;a:3:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1754276097;a:1:{s:26:\"wpcomsh_translation_update\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1754276142;a:1:{s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1754278928;a:1:{s:33:\"updraftplus_clean_temporary_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1754308800;a:1:{s:33:\"duplicator_pro_email_summary_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1754319289;a:1:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1754319296;a:1:{s:20:\"jetpack_v2_heartbeat\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1754319343;a:1:{s:24:\"jp_purge_transients_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1754319645;a:1:{s:28:\"elementor/tracker/send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1754322380;a:1:{s:31:\"wpseo_permalink_structure_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1754322381;a:1:{s:13:\"wpseo-reindex\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1754323558;a:1:{s:15:\"frm_daily_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1754330222;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1754456839;a:1:{s:30:\"duplicator_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1754751297;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1754837689;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}","on"),
("221","launch-status","unlaunched","yes"),
("222","WPLANG","fr_FR","yes"),
("223","wpcom_public_coming_soon","1","yes"),
("224","theme_mods_twentytwentyfive","a:5:{s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1741370038;s:4:\"data\";a:5:{s:19:\"wp_inactive_widgets\";a:8:{i:0;s:6:\"text-2\";i:1;s:6:\"text-4\";i:2;s:11:\"top-posts-2\";i:3;s:12:\"blog-stats-2\";i:4;s:12:\"top-clicks-2\";i:5;s:8:\"flickr-2\";i:6;s:17:\"recent-comments-2\";i:7;s:9:\"twitter-2\";}s:19:\"primary-widget-area\";a:9:{i:0;s:6:\"text-6\";i:1;s:18:\"facebook-likebox-3\";i:2;s:18:\"facebook-likebox-5\";i:3;s:18:\"twitter_timeline-3\";i:4;s:14:\"recent-posts-2\";i:5;s:8:\"search-2\";i:6;s:7:\"block-3\";i:7;s:10:\"archives-2\";i:8;s:7:\"block-5\";}s:21:\"secondary-widget-area\";a:0:{}s:18:\"footer-widget-area\";a:0:{}s:9:\"sidebar-1\";a:0:{}}}s:19:\"wp_classic_sidebars\";a:0:{}i:0;b:0;s:18:\"custom_css_post_id\";i:-1;s:14:\"colors_manager\";a:2:{i:0;b:0;s:6:\"cached\";b:0;}}","off"),
("225","current_theme","Revelar","yes"),
("226","safecss_rev","2","yes"),
("227","jetpack_testimonial","0","yes"),
("228","launchpad_checklist_tasks_statuses","a:16:{s:13:\"plan_selected\";b:1;s:14:\"plan_completed\";b:1;s:12:\"domain_claim\";b:1;s:22:\"domain_upsell_deferred\";b:1;s:16:\"design_completed\";b:1;s:19:\"site_theme_selected\";b:1;s:10:\"site_title\";b:1;s:10:\"setup_free\";b:1;s:13:\"setup_general\";b:1;s:11:\"site_edited\";b:1;s:21:\"install_custom_plugin\";b:1;s:12:\"add_new_page\";b:1;s:9:\"edit_page\";b:1;s:18:\"front_page_updated\";b:1;s:20:\"first_post_published\";b:1;s:14:\"review_plugins\";b:1;}","yes"),
("229","launchpad_screen","skipped","yes"),
("230","theme_mods_cultivate","a:5:{s:19:\"wp_classic_sidebars\";a:0:{}s:18:\"nav_menu_locations\";a:0:{}s:18:\"custom_css_post_id\";i:-1;s:14:\"colors_manager\";a:2:{i:0;b:0;s:6:\"cached\";b:0;}s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1742655320;s:4:\"data\";a:1:{s:19:\"wp_inactive_widgets\";a:0:{}}}}","off"),
("231","jetpack_private_options","a:2:{s:11:\"user_tokens\";a:1:{i:263052659;s:75:\"5^U!eUtsTprpP2!X%G!ytGPm!i&ADs(N.h1vDz*&cw$iOpIKTPZI$M^hn!4tdCeJ0.263052659\";}s:10:\"blog_token\";s:65:\"QHf#8wvM&XHy7P4Ch(bsDsrbRjlafGXs.plFqTyec^OrAgJFJ5b7nckZUbyz)c^eG\";}","auto"),
("233","jetpack_active_modules","a:40:{i:0;s:6:\"blocks\";i:1;s:8:\"carousel\";i:2;s:13:\"comment-likes\";i:3;s:8:\"comments\";i:4;s:12:\"contact-form\";i:5;s:9:\"copy-post\";i:6;s:20:\"custom-content-types\";i:7;s:10:\"custom-css\";i:8;s:21:\"enhanced-distribution\";i:9;s:16:\"google-analytics\";i:10;s:19:\"gravatar-hovercards\";i:11;s:15:\"infinite-scroll\";i:12;s:8:\"json-api\";i:13;s:5:\"latex\";i:14;s:5:\"likes\";i:15;s:6:\"manage\";i:16;s:5:\"notes\";i:17;s:6:\"photon\";i:18;s:10:\"photon-cdn\";i:19;s:13:\"post-by-email\";i:20;s:7:\"protect\";i:21;s:9:\"publicize\";i:22;s:6:\"search\";i:23;s:9:\"seo-tools\";i:24;s:10:\"sharedaddy\";i:25;s:10:\"shortcodes\";i:26;s:10:\"shortlinks\";i:27;s:8:\"sitemaps\";i:28;s:3:\"sso\";i:29;s:5:\"stats\";i:30;s:13:\"subscriptions\";i:31;s:13:\"tiled-gallery\";i:32;s:18:\"verification-tools\";i:33;s:10:\"videopress\";i:34;s:17:\"widget-visibility\";i:35;s:7:\"widgets\";i:36;s:13:\"related-posts\";i:37;s:12:\"google-fonts\";i:38;s:5:\"blaze\";i:39;s:18:\"account-protection\";}","auto"),
("234","finished_updating_comment_type","1","auto"),
("235","db_upgraded","","on"),
("236","wpcomsh_upgraded_db","1","auto"),
("237","jetpack_available_modules","a:1:{s:8:\"14.9-a.7\";a:43:{s:18:\"account-protection\";s:4:\"14.5\";s:5:\"blaze\";s:4:\"12.3\";s:6:\"blocks\";s:8:\"13.9-a.8\";s:8:\"carousel\";s:3:\"1.5\";s:13:\"comment-likes\";s:3:\"5.1\";s:8:\"comments\";s:3:\"1.4\";s:12:\"contact-form\";s:3:\"1.3\";s:9:\"copy-post\";s:3:\"7.0\";s:20:\"custom-content-types\";s:3:\"3.1\";s:12:\"google-fonts\";s:6:\"10.8.0\";s:19:\"gravatar-hovercards\";s:3:\"1.1\";s:15:\"infinite-scroll\";s:3:\"2.0\";s:8:\"json-api\";s:3:\"1.9\";s:5:\"latex\";s:3:\"1.1\";s:5:\"likes\";s:3:\"2.2\";s:8:\"markdown\";s:3:\"2.8\";s:7:\"monitor\";s:3:\"2.6\";s:5:\"notes\";s:3:\"1.9\";s:10:\"photon-cdn\";s:3:\"6.6\";s:6:\"photon\";s:3:\"2.0\";s:13:\"post-by-email\";s:3:\"2.0\";s:9:\"post-list\";s:4:\"11.3\";s:7:\"protect\";s:3:\"3.4\";s:9:\"publicize\";s:3:\"2.0\";s:13:\"related-posts\";s:3:\"2.9\";s:6:\"search\";s:3:\"5.0\";s:9:\"seo-tools\";s:3:\"4.4\";s:10:\"sharedaddy\";s:3:\"1.1\";s:10:\"shortcodes\";s:3:\"1.1\";s:10:\"shortlinks\";s:3:\"1.1\";s:8:\"sitemaps\";s:3:\"3.9\";s:3:\"sso\";s:3:\"2.6\";s:5:\"stats\";s:3:\"1.1\";s:13:\"subscriptions\";s:3:\"1.2\";s:13:\"tiled-gallery\";s:3:\"2.1\";s:10:\"vaultpress\";s:5:\"0:1.2\";s:18:\"verification-tools\";s:3:\"3.0\";s:10:\"videopress\";s:3:\"2.5\";s:3:\"waf\";s:4:\"10.9\";s:17:\"widget-visibility\";s:3:\"2.4\";s:7:\"widgets\";s:3:\"1.2\";s:21:\"woocommerce-analytics\";s:3:\"8.4\";s:7:\"wordads\";s:5:\"4.5.0\";}}","auto"),
("238","jetpack_sync_https_history_home_url","a:5:{i:0;s:5:\"https\";i:1;s:5:\"https\";i:2;s:5:\"https\";i:3;s:5:\"https\";i:4;s:5:\"https\";}","auto"),
("239","jetpack_sync_https_history_site_url","a:5:{i:0;s:5:\"https\";i:1;s:5:\"https\";i:2;s:5:\"https\";i:3;s:5:\"https\";i:4;s:5:\"https\";}","auto"),
("240","has_jetpack_search_product","","auto"),
("241","jetpack_search_ever_supported_search","1","off"),
("242","jetpack_search_plan_info","a:4:{s:20:\"search_subscriptions\";a:1:{i:0;a:23:{s:2:\"ID\";s:8:\"25856480\";s:7:\"user_id\";s:9:\"263052659\";s:7:\"blog_id\";s:9:\"242379716\";s:10:\"product_id\";s:4:\"1008\";s:6:\"expiry\";s:10:\"2026-03-22\";s:15:\"subscribed_date\";s:19:\"2025-03-22 14:28:58\";s:5:\"renew\";b:1;s:10:\"auto_renew\";b:1;s:12:\"ownership_id\";s:8:\"60861047\";s:22:\"most_recent_renew_date\";s:0:\"\";s:19:\"subscription_status\";s:6:\"active\";s:12:\"product_name\";s:22:\"WordPress.com Business\";s:15:\"product_name_en\";s:22:\"WordPress.com Business\";s:12:\"product_slug\";s:15:\"business-bundle\";s:12:\"product_type\";s:6:\"bundle\";s:4:\"cost\";i:300;s:8:\"currency\";s:3:\"EUR\";s:11:\"bill_period\";s:3:\"365\";s:9:\"available\";s:3:\"yes\";s:5:\"multi\";b:0;s:16:\"support_document\";N;s:17:\"is_instant_search\";b:0;s:4:\"tier\";N;}}s:23:\"supports_instant_search\";b:0;s:28:\"supports_only_classic_search\";b:1;s:15:\"supports_search\";b:1;}","auto"),
("243","jetpack_sync_settings_dedicated_sync_enabled","1","on"),
("244","jetpack_sync_settings_sync_via_cron","1","on"),
("245","jetpack_sync_settings_custom_queue_table_enabled","1","on"),
("246","jetpack_sync_settings_max_queue_size","5000","on"),
("247","jetpack_sync_settings_max_queue_lag","7200","on"),
("250","jetpack_sync_settings_dequeue_max_bytes","500000","on"),
("251","jetpack_sync_settings_upload_max_bytes","600000","on"),
("252","jetpack_sync_settings_upload_max_rows","500","on"),
("253","jetpack_sync_settings_sync_wait_time","10","on"),
("254","jetpack_sync_settings_sync_wait_threshold","10","on"),
("255","jetpack_sync_settings_enqueue_wait_time","1","on"),
("256","jetpack_sync_settings_queue_max_writes_sec","100","on"),
("257","jetpack_sync_settings_post_types_blacklist","a:43:{i:0;s:17:\"jp_sitemap_master\";i:1;s:10:\"jp_sitemap\";i:2;s:16:\"jp_sitemap_index\";i:3;s:14:\"jp_img_sitemap\";i:4;s:20:\"jp_img_sitemap_index\";i:5;s:14:\"jp_vid_sitemap\";i:6;s:20:\"jp_vid_sitemap_index\";i:7;s:10:\"_term_meta\";i:8;s:11:\"ai1ec_event\";i:9;s:6:\"ai_log\";i:10;s:17:\"amp_validated_url\";i:11;s:9:\"bwg_album\";i:12;s:11:\"bwg_gallery\";i:13;s:19:\"customize_changeset\";i:14;s:12:\"dn_wp_yt_log\";i:15;s:16:\"flamingo_contact\";i:16;s:16:\"flamingo_inbound\";i:17;s:17:\"flamingo_outbound\";i:18;s:4:\"http\";i:19;s:8:\"idx_page\";i:20;s:19:\"jetpack_inspect_log\";i:21;s:17:\"jetpack_migration\";i:22;s:11:\"msm_sitemap\";i:23;s:17:\"postman_sent_mail\";i:24;s:10:\"rssap-feed\";i:25;s:15:\"rssmi_feed_item\";i:26;s:16:\"scheduled-action\";i:27;s:20:\"secupress_log_action\";i:28;s:17:\"sg_optimizer_jobs\";i:29;s:14:\"sl-insta-media\";i:30;s:6:\"snitch\";i:31;s:19:\"vip-legacy-redirect\";i:32;s:15:\"wp-rest-api-log\";i:33;s:12:\"wp_automatic\";i:34;s:6:\"wp_log\";i:35;s:17:\"wpephpcompat_jobs\";i:36;s:15:\"wprss_feed_item\";i:37;s:15:\"tribe-ea-record\";i:38;s:17:\"wphb_minify_group\";i:39;s:16:\"bigcommerce_task\";i:40;s:20:\"secupress_log_err404\";i:41;s:20:\"iw_omnibus_price_log\";i:42;s:14:\"od_url_metrics\";}","on"),
("259","jetpack_sync_settings_taxonomies_blacklist","a:149:{i:0;s:9:\"ancestors\";i:1;s:13:\"archives_link\";i:2;s:13:\"attached_file\";i:3;s:14:\"attached_media\";i:4;s:19:\"attached_media_args\";i:5;s:10:\"attachment\";i:6;s:19:\"available_languages\";i:7;s:6:\"avatar\";i:8;s:20:\"avatar_comment_types\";i:9;s:11:\"avatar_data\";i:10;s:10:\"avatar_url\";i:11;s:12:\"bloginfo_rss\";i:12;s:13:\"blogs_of_user\";i:13;s:13:\"bookmark_link\";i:14;s:9:\"bookmarks\";i:15;s:8:\"calendar\";i:16;s:13:\"canonical_url\";i:17;s:19:\"categories_per_page\";i:18;s:19:\"categories_taxonomy\";i:19;s:13:\"category_form\";i:20;s:20:\"category_form_fields\";i:21;s:17:\"category_form_pre\";i:22;s:7:\"comment\";i:23;s:10:\"comment_ID\";i:24;s:14:\"comment_author\";i:25;s:17:\"comment_author_IP\";i:26;s:20:\"comment_author_email\";i:27;s:19:\"comment_author_link\";i:28;s:18:\"comment_author_url\";i:29;s:23:\"comment_author_url_link\";i:30;s:12:\"comment_date\";i:31;s:15:\"comment_excerpt\";i:32;s:12:\"comment_link\";i:33;s:20:\"comment_misc_actions\";i:34;s:12:\"comment_text\";i:35;s:12:\"comment_time\";i:36;s:12:\"comment_type\";i:37;s:13:\"comments_link\";i:38;s:15:\"comments_number\";i:39;s:21:\"comments_pagenum_link\";i:40;s:11:\"custom_logo\";i:41;s:8:\"date_sql\";i:42;s:22:\"default_comment_status\";i:43;s:16:\"delete_post_link\";i:44;s:18:\"edit_bookmark_link\";i:45;s:17:\"edit_comment_link\";i:46;s:14:\"edit_post_link\";i:47;s:13:\"edit_tag_link\";i:48;s:14:\"edit_term_link\";i:49;s:14:\"edit_user_link\";i:50;s:8:\"enclosed\";i:51;s:15:\"feed_build_date\";i:52;s:13:\"form_advanced\";i:53;s:17:\"form_after_editor\";i:54;s:16:\"form_after_title\";i:55;s:21:\"form_before_permalink\";i:56;s:8:\"form_top\";i:57;s:18:\"handle_product_cat\";i:58;s:16:\"header_image_tag\";i:59;s:16:\"header_video_url\";i:60;s:9:\"image_tag\";i:61;s:15:\"image_tag_class\";i:62;s:12:\"lastpostdate\";i:63;s:16:\"lastpostmodified\";i:64;s:4:\"link\";i:65;s:18:\"link_category_form\";i:66;s:25:\"link_category_form_fields\";i:67;s:22:\"link_category_form_pre\";i:68;s:15:\"main_network_id\";i:69;s:5:\"media\";i:70;s:15:\"media_item_args\";i:71;s:7:\"ms_user\";i:72;s:7:\"network\";i:73;s:12:\"object_terms\";i:74;s:6:\"option\";i:75;s:4:\"page\";i:76;s:9:\"page_form\";i:77;s:15:\"page_of_comment\";i:78;s:8:\"page_uri\";i:79;s:12:\"pagenum_link\";i:80;s:5:\"pages\";i:81;s:6:\"plugin\";i:82;s:4:\"post\";i:83;s:14:\"post_galleries\";i:84;s:12:\"post_gallery\";i:85;s:9:\"post_link\";i:86;s:18:\"post_modified_time\";i:87;s:11:\"post_status\";i:88;s:9:\"post_time\";i:89;s:8:\"postmeta\";i:90;s:14:\"posts_per_page\";i:91;s:19:\"product_search_form\";i:92;s:11:\"profile_url\";i:93;s:4:\"pung\";i:94;s:9:\"role_list\";i:95;s:16:\"sample_permalink\";i:96;s:21:\"sample_permalink_html\";i:97;s:8:\"schedule\";i:98;s:11:\"search_form\";i:99;s:12:\"search_query\";i:100;s:9:\"shortlink\";i:101;s:4:\"site\";i:102;s:18:\"site_email_content\";i:103;s:13:\"site_icon_url\";i:104;s:11:\"site_option\";i:105;s:13:\"space_allowed\";i:106;s:3:\"tag\";i:107;s:8:\"tag_form\";i:108;s:15:\"tag_form_fields\";i:109;s:12:\"tag_form_pre\";i:110;s:8:\"tag_link\";i:111;s:4:\"tags\";i:112;s:13:\"tags_per_page\";i:113;s:4:\"term\";i:114;s:9:\"term_link\";i:115;s:18:\"term_relationships\";i:116;s:15:\"term_taxonomies\";i:117;s:13:\"term_taxonomy\";i:118;s:5:\"terms\";i:119;s:10:\"terms_args\";i:120;s:14:\"terms_defaults\";i:121;s:12:\"terms_fields\";i:122;s:13:\"terms_orderby\";i:123;s:23:\"the_archive_description\";i:124;s:17:\"the_archive_title\";i:125;s:14:\"the_categories\";i:126;s:8:\"the_date\";i:127;s:11:\"the_excerpt\";i:128;s:8:\"the_guid\";i:129;s:17:\"the_modified_date\";i:130;s:17:\"the_modified_time\";i:131;s:25:\"the_post_type_description\";i:132;s:8:\"the_tags\";i:133;s:9:\"the_terms\";i:134;s:8:\"the_time\";i:135;s:21:\"theme_starter_content\";i:136;s:7:\"to_ping\";i:137;s:4:\"user\";i:138;s:17:\"user_created_user\";i:139;s:9:\"user_form\";i:140;s:12:\"user_profile\";i:141;s:19:\"user_profile_update\";i:142;s:8:\"usermeta\";i:143;s:12:\"usernumposts\";i:144;s:12:\"users_drafts\";i:145;s:7:\"webhook\";i:146;s:6:\"widget\";i:147;s:19:\"woocommerce_archive\";i:148;s:12:\"wp_title_rss\";}","on"),
("261","jetpack_sync_settings_render_filtered_content","0","on"),
("262","jetpack_sync_settings_post_meta_whitelist","a:83:{i:0;s:24:\"_feedback_akismet_values\";i:1;s:15:\"_feedback_email\";i:2;s:22:\"_feedback_extra_fields\";i:3;s:21:\"_g_feedback_shortcode\";i:4;s:23:\"_jetpack_post_thumbnail\";i:5;s:25:\"_last_editor_used_jetpack\";i:6;s:18:\"_menu_item_classes\";i:7;s:27:\"_menu_item_menu_item_parent\";i:8;s:17:\"_menu_item_object\";i:9;s:20:\"_menu_item_object_id\";i:10;s:19:\"_menu_item_orphaned\";i:11;s:15:\"_menu_item_type\";i:12;s:14:\"_menu_item_xfn\";i:13;s:24:\"_publicize_facebook_user\";i:14;s:23:\"_publicize_twitter_user\";i:15;s:13:\"_thumbnail_id\";i:16;s:17:\"_wp_attached_file\";i:17;s:27:\"_wp_attachment_backup_sizes\";i:18;s:22:\"_wp_attachment_context\";i:19;s:24:\"_wp_attachment_image_alt\";i:20;s:35:\"_wp_attachment_is_custom_background\";i:21;s:31:\"_wp_attachment_is_custom_header\";i:22;s:23:\"_wp_attachment_metadata\";i:23;s:12:\"_wp_old_date\";i:24;s:17:\"_wp_page_template\";i:25;s:30:\"_wp_trash_meta_comments_status\";i:26;s:21:\"_wpas_feature_enabled\";i:27;s:10:\"_wpas_mess\";i:28;s:13:\"_wpas_options\";i:29;s:24:\"advanced_seo_description\";i:30;s:13:\"content_width\";i:31;s:14:\"custom_css_add\";i:32;s:23:\"custom_css_preprocessor\";i:33;s:9:\"enclosure\";i:34;s:9:\"imagedata\";i:35;s:10:\"nova_price\";i:36;s:17:\"publicize_results\";i:37;s:16:\"sharing_disabled\";i:38;s:18:\"switch_like_status\";i:39;s:15:\"videopress_guid\";i:40;s:18:\"vimeo_poster_image\";i:41;s:28:\"_jetpack_blogging_prompt_key\";i:42;s:9:\"footnotes\";i:43;s:26:\"_jetpack_newsletter_access\";i:44;s:32:\"_jetpack_dont_email_post_to_subs\";i:45;s:47:\"_jetpack_memberships_contains_paywalled_content\";i:46;s:42:\"_jetpack_memberships_contains_paid_content\";i:47;s:25:\"jetpack_memberships_price\";i:48;s:28:\"jetpack_memberships_currency\";i:49;s:35:\"jetpack_memberships_site_subscriber\";i:50;s:30:\"jetpack_memberships_product_id\";i:51;s:24:\"jetpack_memberships_tier\";i:52;s:30:\"jetpack_memberships_is_deleted\";i:53;s:32:\"jetpack_memberships_is_sandboxed\";i:54;s:30:\"memberships_coupon_coupon_code\";i:55;s:34:\"memberships_coupon_can_be_combined\";i:56;s:43:\"memberships_coupon_first_time_purchase_only\";i:57;s:33:\"memberships_coupon_limit_per_user\";i:58;s:32:\"memberships_coupon_discount_type\";i:59;s:33:\"memberships_coupon_discount_value\";i:60;s:38:\"memberships_coupon_discount_percentage\";i:61;s:36:\"memberships_coupon_discount_currency\";i:62;s:29:\"memberships_coupon_start_date\";i:63;s:27:\"memberships_coupon_end_date\";i:64;s:38:\"memberships_coupon_plan_ids_allow_list\";i:65;s:27:\"memberships_coupon_duration\";i:66;s:35:\"memberships_coupon_email_allow_list\";i:67;s:29:\"memberships_coupon_is_deleted\";i:68;s:31:\"memberships_coupon_is_sandboxed\";i:69;s:24:\"memberships_gift_user_id\";i:70;s:24:\"memberships_gift_plan_id\";i:71;s:27:\"memberships_gift_is_deleted\";i:72;s:14:\"spay_paypal_id\";i:73;s:11:\"spay_status\";i:74;s:15:\"spay_product_id\";i:75;s:13:\"spay_quantity\";i:76;s:10:\"spay_price\";i:77;s:19:\"spay_customer_email\";i:78;s:13:\"spay_currency\";i:79;s:8:\"spay_cta\";i:80;s:10:\"spay_email\";i:81;s:13:\"spay_multiple\";i:82;s:20:\"spay_formatted_price\";}","on"),
("264","jetpack_sync_settings_comment_meta_whitelist","a:4:{i:0;s:9:\"hc_avatar\";i:1;s:18:\"hc_foreign_user_id\";i:2;s:10:\"hc_post_as\";i:3;s:15:\"hc_wpcom_id_sig\";}","on"),
("266","jetpack_sync_settings_max_enqueue_full_sync","100","on"),
("267","jetpack_sync_settings_max_queue_size_full_sync","1000","on"),
("268","jetpack_sync_settings_cron_sync_time_limit","240","on"),
("269","jetpack_sync_settings_known_importers","a:6:{s:16:\"Blogger_Importer\";s:7:\"blogger\";s:13:\"LJ_API_Import\";s:11:\"livejournal\";s:9:\"MT_Import\";s:2:\"mt\";s:10:\"RSS_Import\";s:3:\"rss\";s:20:\"WC_Tax_Rate_Importer\";s:12:\"woo-tax-rate\";s:9:\"WP_Import\";s:9:\"wordpress\";}","on"),
("270","jetpack_sync_settings_term_relationships_full_sync_item_size","100","on"),
("271","jetpack_sync_settings_sync_sender_enabled","1","on"),
("272","jetpack_sync_settings_full_sync_sender_enabled","1","on"),
("273","jetpack_sync_settings_full_sync_send_duration","9","on"),
("274","jetpack_sync_settings_full_sync_limits","a:7:{s:8:\"comments\";a:2:{s:10:\"chunk_size\";i:100;s:10:\"max_chunks\";i:10;}s:5:\"posts\";a:2:{s:10:\"chunk_size\";i:100;s:10:\"max_chunks\";i:1;}s:18:\"term_relationships\";a:2:{s:10:\"chunk_size\";i:1000;s:10:\"max_chunks\";i:10;}s:5:\"terms\";a:2:{s:10:\"chunk_size\";i:1000;s:10:\"max_chunks\";i:10;}s:5:\"users\";a:2:{s:10:\"chunk_size\";i:100;s:10:\"max_chunks\";i:10;}s:11:\"woocommerce\";a:2:{s:10:\"chunk_size\";i:100;s:10:\"max_chunks\";i:10;}s:23:\"woocommerce_hpos_orders\";a:2:{s:10:\"chunk_size\";i:100;s:10:\"max_chunks\";i:10;}}","on"),
("275","jetpack_sync_settings_checksum_disable","0","on"),
("276","jetpack_sync_settings_wpcom_rest_api_enabled","1","on"),
("278","widget_gravatar","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("279","widget_jetpack_posts_i_like","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("280","widget_music-player","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("281","widget_tlkio_widget","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("282","widget_akismet_widget","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("283","widget_pd_top_rated","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("284","widget_jetpack-search-filters","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("285","widget_wpcom-mailerlite","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("286","widget_blog_subscription","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("287","widget_authors","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("288","widget_blog-stats","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("289","widget_eu_cookie_law_widget","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("290","widget_wpcom_instagram_widget","a:3:{i:1;a:0:{}s:5:\"__i__\";a:4:{s:8:\"token_id\";i:0;s:5:\"title\";s:9:\"Instagram\";s:7:\"columns\";i:2;s:5:\"count\";i:6;}s:12:\"_multiwidget\";i:1;}","auto"),
("291","widget_widget_contact_info","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("292","widget_facebook-likebox","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("293","widget_flickr","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("294","widget_gallery","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("295","widget_wpcom-goodreads","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("296","widget_google_translate_widget","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("297","widget_grofile","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("298","widget_internet_defense_league_widget","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("299","widget_widget_mailchimp_subscriber_popup","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("300","widget_milestone_widget","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("301","widget_jetpack_my_community","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("302","widget_rss_links","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("303","widget_jetpack_widget_social_icons","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("304","widget_top-posts","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("305","widget_twitter_timeline","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("306","widget_upcoming_events_widget","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("307","widget_jetpack_display_posts_widget","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("308","widget_wpcom_category_cloud","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("309","widget_image","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("310","link_manager_check","1742655297","auto"),
("311","jetpack_portfolio","0","auto"),
("313","sharedaddy_disable_resources","0","auto"),
("314","gutenberg_version_migration","9.8.0","auto"),
("315","jetpack_package_versions","a:6:{s:6:\"backup\";s:6:\"4.2.13\";s:10:\"connection\";s:12:\"6.17.0-alpha\";s:4:\"sync\";s:12:\"4.17.0-alpha\";s:6:\"search\";s:6:\"0.52.9\";s:10:\"videopress\";s:6:\"0.30.6\";s:5:\"stats\";s:6:\"0.17.2\";}","auto"),
("331","jetpack_constants_sync_checksum","a:21:{s:7:\"ABSPATH\";i:418600299;s:17:\"ALTERNATE_WP_CRON\";i:634125391;s:16:\"ATOMIC_CLIENT_ID\";i:4237843977;s:26:\"AUTOMATIC_UPDATER_DISABLED\";i:634125391;s:15:\"DISABLE_WP_CRON\";i:634125391;s:18:\"DISALLOW_FILE_EDIT\";i:634125391;s:18:\"DISALLOW_FILE_MODS\";i:634125391;s:16:\"EMPTY_TRASH_DAYS\";i:2473281379;s:9:\"FS_METHOD\";i:3577458903;s:12:\"IS_PRESSABLE\";i:634125391;s:16:\"JETPACK__VERSION\";i:3781679040;s:11:\"PHP_VERSION\";i:526187386;s:19:\"WP_ACCESSIBLE_HOSTS\";i:634125391;s:19:\"WP_AUTO_UPDATE_CORE\";i:734881840;s:14:\"WP_CONTENT_DIR\";i:4025282661;s:20:\"WP_CRON_LOCK_TIMEOUT\";i:3994858278;s:8:\"WP_DEBUG\";i:734881840;s:22:\"WP_HTTP_BLOCK_EXTERNAL\";i:634125391;s:19:\"WP_MAX_MEMORY_LIMIT\";i:1839787262;s:15:\"WP_MEMORY_LIMIT\";i:1839787262;s:17:\"WP_POST_REVISIONS\";i:4261170317;}","auto"),
("332","jetpack_sync_https_history_main_network_site_url","a:5:{i:0;s:5:\"https\";i:1;s:5:\"https\";i:2;s:5:\"https\";i:3;s:5:\"https\";i:4;s:5:\"https\";}","auto"),
("374","jetpack_callables_sync_checksum","a:42:{s:21:\"get_loaded_extensions\";i:1377709313;s:11:\"get_plugins\";i:3992425569;s:10:\"get_themes\";i:3801148509;s:24:\"get_plugins_action_links\";i:478227881;s:28:\"has_file_system_write_access\";i:4261170317;s:8:\"home_url\";i:4881489;s:16:\"hosting_provider\";i:769900095;s:12:\"is_fse_theme\";i:734881840;s:15:\"is_main_network\";i:734881840;s:13:\"is_multi_site\";i:734881840;s:21:\"is_version_controlled\";i:734881840;s:6:\"locale\";i:577058967;s:17:\"main_network_site\";i:4881489;s:26:\"main_network_site_wpcom_id\";i:1437130018;s:14:\"paused_plugins\";i:223132457;s:13:\"paused_themes\";i:223132457;s:18:\"post_type_features\";i:3367418536;s:10:\"post_types\";i:1556119602;s:27:\"rest_api_allowed_post_types\";i:1843208324;s:32:\"rest_api_allowed_public_metadata\";i:3610467939;s:5:\"roles\";i:816847558;s:10:\"shortcodes\";i:2907657204;s:13:\"site_icon_url\";i:545804802;s:8:\"site_url\";i:4881489;s:10:\"taxonomies\";i:2430975212;s:13:\"theme_support\";i:2545115280;s:8:\"timezone\";i:3126062234;s:23:\"wp_get_environment_type\";i:1138987844;s:18:\"wp_max_upload_size\";i:3201742935;s:10:\"wp_version\";i:1455434799;s:14:\"active_modules\";i:780701054;s:33:\"jetpack_connection_active_plugins\";i:1117076940;s:27:\"jetpack_sync_active_modules\";i:3829104773;s:16:\"single_user_site\";i:4261170317;s:7:\"updates\";i:2252358820;s:24:\"available_jetpack_blocks\";i:2919085868;s:24:\"sso_is_two_step_required\";i:734881840;s:26:\"sso_should_hide_login_form\";i:734881840;s:18:\"sso_match_by_email\";i:4261170317;s:21:\"sso_new_user_override\";i:734881840;s:29:\"sso_bypass_default_login_form\";i:4261170317;s:24:\"jetpack_package_versions\";i:549402613;}","no"),
("375","jpsq_sync_checkout","0:0","no"),
("376","jetpack_plugin_api_action_links","a:17:{s:19:\"akismet/akismet.php\";a:1:{s:9:\"Réglages\";s:65:\"https://creakonect.com/wp-admin/admin.php?page=akismet-key-config\";}s:24:\"buddypress/bp-loader.php\";a:2:{s:9:\"Réglages\";s:70:\"https://creakonect.com/wp-admin/options-general.php?page=bp-components\";s:20:\"Salut, BuddyPress !\";s:87:\"https://creakonect.com/wp-admin/options-general.php?page=bp-components&hello=buddypress\";}s:31:\"cookie-notice/cookie-notice.php\";a:2:{s:9:\"Réglages\";s:60:\"https://creakonect.com/wp-admin/admin.php?page=cookie-notice\";s:23:\"Mise à niveau gratuite\";s:70:\"https://creakonect.com/wp-admin/admin.php?page=cookie-notice&welcome=1\";}s:39:\"crowdsignal-forms/crowdsignal-forms.php\";a:1:{s:9:\"Réglages\";s:77:\"https://creakonect.com/wp-admin/options-general.php?page=crowdsignal-settings\";}s:33:\"duplicator-pro/duplicator-pro.php\";a:1:{s:6:\"Manage\";s:70:\"https://creakonect.com/wp-admin/wp-admin/admin.php?page=duplicator-pro\";}s:23:\"elementor/elementor.php\";a:2:{s:9:\"Réglages\";s:56:\"https://creakonect.com/wp-admin/admin.php?page=elementor\";s:21:\"Obtenir Elementor Pro\";s:43:\"https://go.elementor.com/go-pro-wp-plugins/\";}s:25:\"formidable/formidable.php\";a:2:{s:24:\"Passer à la version Pro\";s:108:\"https://formidableforms.com/lite-upgrade/?utm_source=WordPress&utm_medium=plugin-row&utm_campaign=liteplugin\";s:20:\"Créer un Formulaire\";s:57:\"https://creakonect.com/wp-admin/admin.php?page=formidable\";}s:27:\"optimole-wp/optimole-wp.php\";a:2:{s:8:\"Settings\";s:55:\"https://creakonect.com/wp-admin/admin.php?page=optimole\";s:18:\"Rollback to v4.0.2\";s:94:\"https://creakonect.com/wp-admin/admin-post.php?action=optimole_wp_rollback&_wpnonce=730b529c9c\";}s:19:\"jetpack/jetpack.php\";a:1:{s:9:\"Réglages\";s:64:\"https://creakonect.com/wp-admin/admin.php?page=jetpack#/settings\";}s:38:\"easy-login-woocommerce/xoo-el-main.php\";a:3:{s:8:\"Settings\";s:78:\"https://creakonect.com/wp-admin/admin.php?page=easy-login-woocommerce-settings\";s:7:\"Support\";s:26:\"https://xootix.com/contact\";s:7:\"Upgrade\";s:53:\"https://xootix.com/plugins/easy-login-for-woocommerce\";}s:31:\"page-optimize/page-optimize.php\";a:1:{s:8:\"Settings\";s:70:\"https://creakonect.com/wp-admin/options-general.php?page=page-optimize\";}s:51:\"header-footer-elementor/header-footer-elementor.php\";a:2:{s:9:\"Réglages\";s:60:\"https://creakonect.com/wp-admin/admin.php?page=hfe#dashboard\";s:11:\"Get UAE Pro\";s:106:\"https://ultimateelementor.com/pricing/?utm_source=wp-admin&utm_medium=plugin-list&utm_campaign=uae-upgrade\";}s:27:\"updraftplus/updraftplus.php\";a:3:{s:19:\"Support Premium/Pro\";s:24:\"https://updraftplus.com/\";s:9:\"Réglages\";s:68:\"https://creakonect.com/wp-admin/options-general.php?page=updraftplus\";s:14:\"Visite guidée\";s:87:\"https://creakonect.com/wp-admin/options-general.php?page=updraftplus&updraftplus_tour=1\";}s:31:\"wp-google-maps/wpGoogleMaps.php\";a:3:{s:11:\"Version Pro\";s:121:\"https://www.wpgmaps.com/purchase-professional-version/?utm_source=plugin&utm_medium=link&utm_campaign=plugin_link_upgrade\";s:9:\"Réglages\";s:75:\"https://creakonect.com/wp-admin/admin.php?page=wp-google-maps-menu-settings\";s:10:\"Map Editor\";s:66:\"https://creakonect.com/wp-admin/admin.php?page=wp-google-maps-menu\";}s:37:\"wp-store-locator/wp-store-locator.php\";a:1:{s:8:\"Settings\";s:81:\"https://creakonect.com/wp-admin/edit.php?post_type=wpsl_stores&page=wpsl_settings\";}s:35:\"wp-user-manager/wp-user-manager.php\";a:3:{s:7:\"Modules\";s:146:\"https://wpusermanager.com/addons?utm_source=WP%20User%20Manager&utm_medium=insideplugin&utm_campaign=WP%20User%20Manager&utm_content=plugins-table\";s:13:\"Documentation\";s:145:\"https://wpusermanager.com/docs/?utm_source=WP%20User%20Manager&utm_medium=insideplugin&utm_campaign=WP%20User%20Manager&utm_content=plugins-table\";s:11:\"Paramètres\";s:60:\"https://creakonect.com/wp-admin/users.php?page=wpum-settings\";}s:24:\"wordpress-seo/wp-seo.php\";a:4:{s:28:\"Passer à la version premium\";s:148:\"https://yoa.st/1yb?php_version=8.2&platform=wordpress&platform_version=6.8.2&software=free&software_version=25.6&days_active=128&user_language=fr_FR\";s:39:\"Finissez votre first-time configuration\";s:88:\"https://creakonect.com/wp-admin/admin.php?page=wpseo_dashboard#/first-time-configuration\";s:3:\"FAQ\";s:148:\"https://yoa.st/1yc?php_version=8.2&platform=wordpress&platform_version=6.8.2&software=free&software_version=25.6&days_active=128&user_language=fr_FR\";s:9:\"Réglages\";s:62:\"https://creakonect.com/wp-admin/admin.php?page=wpseo_dashboard\";}}","auto"),
("377","jp_sync_retry_after_sync","","off"),
("378","jp_sync_last_success_sync","1754247291.2431","off"),
("381","recovery_keys","a:0:{}","off"),
("382","monitor_receive_notifications","1","auto"),
("385","post_by_email_address263052659","NULL","auto"),
("387","jetpack_updates_sync_checksum","a:2:{s:14:\"update_plugins\";i:3750803703;s:13:\"update_themes\";i:1894151987;}","auto"),
("390","jetpack_next_sync_time_sync","1754247301","on"),
("391","carousel_display_exif","1","auto"),
("393","carousel_display_comments","1","auto"),
("395","carousel_background_color","","auto"),
("397","tiled_galleries","","auto"),
("399","gravatar_disable_hovercards","0","auto"),
("401","disabled_likes","0","auto"),
("403","verification_services_codes","0","auto"),
("405","crowdsignal_api_key","7aa102be-f13d-f3e8-bb83-00007783f050","auto"),
("407","widget_jetpack_simple_payments_widget","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("411","jetpack_active_plan","a:11:{s:10:\"product_id\";i:1008;s:12:\"product_slug\";s:15:\"business-bundle\";s:12:\"product_name\";s:22:\"WordPress.com Business\";s:18:\"product_name_short\";s:8:\"Business\";s:7:\"expired\";b:0;s:14:\"billing_period\";s:6:\"Yearly\";s:13:\"user_is_owner\";b:0;s:7:\"is_free\";b:0;s:11:\"license_key\";s:0:\"\";s:15:\"subscribed_date\";s:19:\"2025-03-22 14:28:58\";s:8:\"features\";a:2:{s:6:\"active\";a:95:{i:0;s:12:\"ai-assistant\";i:1;s:15:\"ai-seo-enhancer\";i:2;s:9:\"ad-credit\";i:3;s:12:\"advanced-seo\";i:4;s:7:\"akismet\";i:5;s:8:\"antispam\";i:6;s:6:\"atomic\";i:7;s:7:\"backups\";i:8;s:7:\"restore\";i:9;s:7:\"big-sky\";i:10;s:8:\"calendly\";i:11;s:3:\"cdn\";i:12;s:6:\"search\";i:13;s:20:\"cloudflare-analytics\";i:14;s:14:\"cloudflare-cdn\";i:15;s:9:\"concierge\";i:16;s:18:\"concierge-business\";i:17;s:9:\"copy-site\";i:18;s:10:\"core/audio\";i:19;s:10:\"core/cover\";i:20;s:10:\"core/video\";i:21;s:15:\"credit-vouchers\";i:22;s:13:\"custom-design\";i:23;s:13:\"custom-domain\";i:24;s:14:\"domain-mapping\";i:25;s:9:\"donations\";i:26;s:12:\"edit-plugins\";i:27;s:11:\"edit-themes\";i:28;s:29:\"email-forwards-extended-limit\";i:29;s:10:\"field-file\";i:30;s:14:\"multistep-form\";i:31;s:9:\"free-blog\";i:32;s:17:\"full-activity-log\";i:33;s:13:\"global-styles\";i:34;s:16:\"google-analytics\";i:35;s:18:\"google-my-business\";i:36;s:15:\"install-plugins\";i:37;s:25:\"install-purchased-plugins\";i:38;s:14:\"install-themes\";i:39;s:17:\"jetpack-dashboard\";i:40;s:22:\"list-installed-plugins\";i:41;s:12:\"live_support\";i:42;s:14:\"manage-plugins\";i:43;s:25:\"no-adverts/no-adverts.php\";i:44;s:17:\"no-wpcom-branding\";i:45;s:9:\"opentable\";i:46;s:17:\"options-permalink\";i:47;s:8:\"payments\";i:48;s:25:\"premium-content/container\";i:49;s:15:\"personal-themes\";i:50;s:14:\"premium-themes\";i:51;s:16:\"priority_support\";i:52;s:13:\"private_whois\";i:53;s:17:\"real-time-backups\";i:54;s:18:\"recurring-payments\";i:55;s:11:\"republicize\";i:56;s:4:\"scan\";i:57;s:12:\"scan-managed\";i:58;s:17:\"scheduled-updates\";i:59;s:17:\"security-settings\";i:60;s:17:\"seo-preview-tools\";i:61;s:14:\"send-a-message\";i:62;s:25:\"set-primary-custom-domain\";i:63;s:4:\"sftp\";i:64;s:3:\"ssh\";i:65;s:15:\"simple-payments\";i:66;s:18:\"site-preview-links\";i:67;s:26:\"social-enhanced-publishing\";i:68;s:22:\"social-image-generator\";i:69;s:17:\"social-admin-page\";i:70;s:29:\"social-connections-management\";i:71;s:21:\"social-editor-preview\";i:72;s:19:\"social-share-status\";i:73;s:25:\"social-image-auto-convert\";i:74;s:5:\"space\";i:75;s:22:\"space-upgraded-storage\";i:76;s:13:\"staging-sites\";i:77;s:10:\"stats-paid\";i:78;s:16:\"stats-commercial\";i:79;s:11:\"studio-sync\";i:80;s:28:\"subscriber-unlimited-imports\";i:81;s:20:\"subscription-gifting\";i:82;s:7:\"support\";i:83;s:25:\"upgraded_upload_filetypes\";i:84;s:18:\"upload-audio-files\";i:85;s:14:\"upload-plugins\";i:86;s:13:\"upload-themes\";i:87;s:18:\"upload-video-files\";i:88;s:13:\"video-hosting\";i:89;s:10:\"videopress\";i:90;s:16:\"videopress/video\";i:91;s:15:\"whatsapp-button\";i:92;s:4:\"woop\";i:93;s:7:\"wordads\";i:94;s:15:\"wordads-jetpack\";}s:9:\"available\";a:96:{s:12:\"ai-assistant\";a:27:{i:0;s:15:\"personal-bundle\";i:1;s:12:\"value_bundle\";i:2;s:16:\"ecommerce-bundle\";i:3;s:18:\"personal-bundle-2y\";i:4;s:18:\"personal-bundle-3y\";i:5;s:15:\"value_bundle-2y\";i:6;s:15:\"value_bundle-3y\";i:7;s:18:\"business-bundle-2y\";i:8;s:18:\"business-bundle-3y\";i:9;s:19:\"ecommerce-bundle-2y\";i:10;s:19:\"ecommerce-bundle-3y\";i:11;s:23:\"personal-bundle-monthly\";i:12;s:20:\"value_bundle_monthly\";i:13;s:23:\"business-bundle-monthly\";i:14;s:33:\"wp_bundle_migration_trial_monthly\";i:15;s:31:\"wp_bundle_hosting_trial_monthly\";i:16;s:24:\"ecommerce-bundle-monthly\";i:17;s:30:\"ecommerce-trial-bundle-monthly\";i:18;s:32:\"wooexpress-medium-bundle-monthly\";i:19;s:31:\"wooexpress-small-bundle-monthly\";i:20;s:31:\"wooexpress-medium-bundle-yearly\";i:21;s:30:\"wooexpress-small-bundle-yearly\";i:22;s:16:\"pro-plan-monthly\";i:23;s:11:\"pro-plan-2y\";i:24;s:39:\"wp_com_hundred_year_bundle_centennially\";i:25;s:12:\"starter-plan\";i:26;s:8:\"pro-plan\";}s:10:\"core/audio\";a:27:{i:0;s:15:\"personal-bundle\";i:1;s:12:\"value_bundle\";i:2;s:16:\"ecommerce-bundle\";i:3;s:18:\"personal-bundle-2y\";i:4;s:18:\"personal-bundle-3y\";i:5;s:15:\"value_bundle-2y\";i:6;s:15:\"value_bundle-3y\";i:7;s:18:\"business-bundle-2y\";i:8;s:18:\"business-bundle-3y\";i:9;s:19:\"ecommerce-bundle-2y\";i:10;s:19:\"ecommerce-bundle-3y\";i:11;s:23:\"personal-bundle-monthly\";i:12;s:20:\"value_bundle_monthly\";i:13;s:23:\"business-bundle-monthly\";i:14;s:33:\"wp_bundle_migration_trial_monthly\";i:15;s:31:\"wp_bundle_hosting_trial_monthly\";i:16;s:24:\"ecommerce-bundle-monthly\";i:17;s:30:\"ecommerce-trial-bundle-monthly\";i:18;s:32:\"wooexpress-medium-bundle-monthly\";i:19;s:31:\"wooexpress-small-bundle-monthly\";i:20;s:31:\"wooexpress-medium-bundle-yearly\";i:21;s:30:\"wooexpress-small-bundle-yearly\";i:22;s:16:\"pro-plan-monthly\";i:23;s:11:\"pro-plan-2y\";i:24;s:39:\"wp_com_hundred_year_bundle_centennially\";i:25;s:12:\"starter-plan\";i:26;s:8:\"pro-plan\";}s:13:\"custom-domain\";a:29:{i:0;s:15:\"personal-bundle\";i:1;s:12:\"value_bundle\";i:2;s:16:\"ecommerce-bundle\";i:3;s:18:\"personal-bundle-2y\";i:4;s:18:\"personal-bundle-3y\";i:5;s:15:\"value_bundle-2y\";i:6;s:15:\"value_bundle-3y\";i:7;s:18:\"business-bundle-2y\";i:8;s:18:\"business-bundle-3y\";i:9;s:14:\"blogger-bundle\";i:10;s:17:\"blogger-bundle-2y\";i:11;s:19:\"ecommerce-bundle-2y\";i:12;s:19:\"ecommerce-bundle-3y\";i:13;s:23:\"personal-bundle-monthly\";i:14;s:20:\"value_bundle_monthly\";i:15;s:23:\"business-bundle-monthly\";i:16;s:33:\"wp_bundle_migration_trial_monthly\";i:17;s:31:\"wp_bundle_hosting_trial_monthly\";i:18;s:24:\"ecommerce-bundle-monthly\";i:19;s:30:\"ecommerce-trial-bundle-monthly\";i:20;s:32:\"wooexpress-medium-bundle-monthly\";i:21;s:31:\"wooexpress-small-bundle-monthly\";i:22;s:31:\"wooexpress-medium-bundle-yearly\";i:23;s:30:\"wooexpress-small-bundle-yearly\";i:24;s:16:\"pro-plan-monthly\";i:25;s:11:\"pro-plan-2y\";i:26;s:39:\"wp_com_hundred_year_bundle_centennially\";i:27;s:12:\"starter-plan\";i:28;s:8:\"pro-plan\";}s:14:\"domain-mapping\";a:29:{i:0;s:15:\"personal-bundle\";i:1;s:12:\"value_bundle\";i:2;s:16:\"ecommerce-bundle\";i:3;s:18:\"personal-bundle-2y\";i:4;s:18:\"personal-bundle-3y\";i:5;s:15:\"value_bundle-2y\";i:6;s:15:\"value_bundle-3y\";i:7;s:18:\"business-bundle-2y\";i:8;s:18:\"business-bundle-3y\";i:9;s:14:\"blogger-bundle\";i:10;s:17:\"blogger-bundle-2y\";i:11;s:19:\"ecommerce-bundle-2y\";i:12;s:19:\"ecommerce-bundle-3y\";i:13;s:23:\"personal-bundle-monthly\";i:14;s:20:\"value_bundle_monthly\";i:15;s:23:\"business-bundle-monthly\";i:16;s:33:\"wp_bundle_migration_trial_monthly\";i:17;s:31:\"wp_bundle_hosting_trial_monthly\";i:18;s:24:\"ecommerce-bundle-monthly\";i:19;s:30:\"ecommerce-trial-bundle-monthly\";i:20;s:32:\"wooexpress-medium-bundle-monthly\";i:21;s:31:\"wooexpress-small-bundle-monthly\";i:22;s:31:\"wooexpress-medium-bundle-yearly\";i:23;s:30:\"wooexpress-small-bundle-yearly\";i:24;s:16:\"pro-plan-monthly\";i:25;s:11:\"pro-plan-2y\";i:26;s:39:\"wp_com_hundred_year_bundle_centennially\";i:27;s:12:\"starter-plan\";i:28;s:8:\"pro-plan\";}s:10:\"field-file\";a:27:{i:0;s:15:\"personal-bundle\";i:1;s:12:\"value_bundle\";i:2;s:16:\"ecommerce-bundle\";i:3;s:18:\"personal-bundle-2y\";i:4;s:18:\"personal-bundle-3y\";i:5;s:15:\"value_bundle-2y\";i:6;s:15:\"value_bundle-3y\";i:7;s:18:\"business-bundle-2y\";i:8;s:18:\"business-bundle-3y\";i:9;s:19:\"ecommerce-bundle-2y\";i:10;s:19:\"ecommerce-bundle-3y\";i:11;s:23:\"personal-bundle-monthly\";i:12;s:20:\"value_bundle_monthly\";i:13;s:23:\"business-bundle-monthly\";i:14;s:33:\"wp_bundle_migration_trial_monthly\";i:15;s:31:\"wp_bundle_hosting_trial_monthly\";i:16;s:24:\"ecommerce-bundle-monthly\";i:17;s:30:\"ecommerce-trial-bundle-monthly\";i:18;s:32:\"wooexpress-medium-bundle-monthly\";i:19;s:31:\"wooexpress-small-bundle-monthly\";i:20;s:31:\"wooexpress-medium-bundle-yearly\";i:21;s:30:\"wooexpress-small-bundle-yearly\";i:22;s:16:\"pro-plan-monthly\";i:23;s:11:\"pro-plan-2y\";i:24;s:39:\"wp_com_hundred_year_bundle_centennially\";i:25;s:12:\"starter-plan\";i:26;s:8:\"pro-plan\";}s:14:\"multistep-form\";a:27:{i:0;s:15:\"personal-bundle\";i:1;s:12:\"value_bundle\";i:2;s:16:\"ecommerce-bundle\";i:3;s:18:\"personal-bundle-2y\";i:4;s:18:\"personal-bundle-3y\";i:5;s:15:\"value_bundle-2y\";i:6;s:15:\"value_bundle-3y\";i:7;s:18:\"business-bundle-2y\";i:8;s:18:\"business-bundle-3y\";i:9;s:19:\"ecommerce-bundle-2y\";i:10;s:19:\"ecommerce-bundle-3y\";i:11;s:23:\"personal-bundle-monthly\";i:12;s:20:\"value_bundle_monthly\";i:13;s:23:\"business-bundle-monthly\";i:14;s:33:\"wp_bundle_migration_trial_monthly\";i:15;s:31:\"wp_bundle_hosting_trial_monthly\";i:16;s:24:\"ecommerce-bundle-monthly\";i:17;s:30:\"ecommerce-trial-bundle-monthly\";i:18;s:32:\"wooexpress-medium-bundle-monthly\";i:19;s:31:\"wooexpress-small-bundle-monthly\";i:20;s:31:\"wooexpress-medium-bundle-yearly\";i:21;s:30:\"wooexpress-small-bundle-yearly\";i:22;s:16:\"pro-plan-monthly\";i:23;s:11:\"pro-plan-2y\";i:24;s:39:\"wp_com_hundred_year_bundle_centennially\";i:25;s:12:\"starter-plan\";i:26;s:8:\"pro-plan\";}s:17:\"full-activity-log\";a:29:{i:0;s:15:\"personal-bundle\";i:1;s:12:\"value_bundle\";i:2;s:16:\"ecommerce-bundle\";i:3;s:18:\"personal-bundle-2y\";i:4;s:18:\"personal-bundle-3y\";i:5;s:15:\"value_bundle-2y\";i:6;s:15:\"value_bundle-3y\";i:7;s:18:\"business-bundle-2y\";i:8;s:18:\"business-bundle-3y\";i:9;s:14:\"blogger-bundle\";i:10;s:17:\"blogger-bundle-2y\";i:11;s:19:\"ecommerce-bundle-2y\";i:12;s:19:\"ecommerce-bundle-3y\";i:13;s:23:\"personal-bundle-monthly\";i:14;s:20:\"value_bundle_monthly\";i:15;s:23:\"business-bundle-monthly\";i:16;s:33:\"wp_bundle_migration_trial_monthly\";i:17;s:31:\"wp_bundle_hosting_trial_monthly\";i:18;s:24:\"ecommerce-bundle-monthly\";i:19;s:30:\"ecommerce-trial-bundle-monthly\";i:20;s:32:\"wooexpress-medium-bundle-monthly\";i:21;s:31:\"wooexpress-small-bundle-monthly\";i:22;s:31:\"wooexpress-medium-bundle-yearly\";i:23;s:30:\"wooexpress-small-bundle-yearly\";i:24;s:16:\"pro-plan-monthly\";i:25;s:11:\"pro-plan-2y\";i:26;s:39:\"wp_com_hundred_year_bundle_centennially\";i:27;s:12:\"starter-plan\";i:28;s:8:\"pro-plan\";}s:25:\"no-adverts/no-adverts.php\";a:28:{i:0;s:15:\"personal-bundle\";i:1;s:12:\"value_bundle\";i:2;s:16:\"ecommerce-bundle\";i:3;s:18:\"personal-bundle-2y\";i:4;s:18:\"personal-bundle-3y\";i:5;s:15:\"value_bundle-2y\";i:6;s:15:\"value_bundle-3y\";i:7;s:18:\"business-bundle-2y\";i:8;s:18:\"business-bundle-3y\";i:9;s:14:\"blogger-bundle\";i:10;s:17:\"blogger-bundle-2y\";i:11;s:19:\"ecommerce-bundle-2y\";i:12;s:19:\"ecommerce-bundle-3y\";i:13;s:23:\"personal-bundle-monthly\";i:14;s:20:\"value_bundle_monthly\";i:15;s:23:\"business-bundle-monthly\";i:16;s:33:\"wp_bundle_migration_trial_monthly\";i:17;s:31:\"wp_bundle_hosting_trial_monthly\";i:18;s:24:\"ecommerce-bundle-monthly\";i:19;s:30:\"ecommerce-trial-bundle-monthly\";i:20;s:32:\"wooexpress-medium-bundle-monthly\";i:21;s:31:\"wooexpress-small-bundle-monthly\";i:22;s:31:\"wooexpress-medium-bundle-yearly\";i:23;s:30:\"wooexpress-small-bundle-yearly\";i:24;s:16:\"pro-plan-monthly\";i:25;s:11:\"pro-plan-2y\";i:26;s:39:\"wp_com_hundred_year_bundle_centennially\";i:27;s:8:\"pro-plan\";}s:8:\"payments\";a:27:{i:0;s:15:\"personal-bundle\";i:1;s:12:\"value_bundle\";i:2;s:16:\"ecommerce-bundle\";i:3;s:18:\"personal-bundle-2y\";i:4;s:18:\"personal-bundle-3y\";i:5;s:15:\"value_bundle-2y\";i:6;s:15:\"value_bundle-3y\";i:7;s:18:\"business-bundle-2y\";i:8;s:18:\"business-bundle-3y\";i:9;s:19:\"ecommerce-bundle-2y\";i:10;s:19:\"ecommerce-bundle-3y\";i:11;s:23:\"personal-bundle-monthly\";i:12;s:20:\"value_bundle_monthly\";i:13;s:23:\"business-bundle-monthly\";i:14;s:33:\"wp_bundle_migration_trial_monthly\";i:15;s:31:\"wp_bundle_hosting_trial_monthly\";i:16;s:24:\"ecommerce-bundle-monthly\";i:17;s:30:\"ecommerce-trial-bundle-monthly\";i:18;s:32:\"wooexpress-medium-bundle-monthly\";i:19;s:31:\"wooexpress-small-bundle-monthly\";i:20;s:31:\"wooexpress-medium-bundle-yearly\";i:21;s:30:\"wooexpress-small-bundle-yearly\";i:22;s:16:\"pro-plan-monthly\";i:23;s:11:\"pro-plan-2y\";i:24;s:39:\"wp_com_hundred_year_bundle_centennially\";i:25;s:12:\"starter-plan\";i:26;s:8:\"pro-plan\";}s:25:\"premium-content/container\";a:27:{i:0;s:15:\"personal-bundle\";i:1;s:12:\"value_bundle\";i:2;s:16:\"ecommerce-bundle\";i:3;s:18:\"personal-bundle-2y\";i:4;s:18:\"personal-bundle-3y\";i:5;s:15:\"value_bundle-2y\";i:6;s:15:\"value_bundle-3y\";i:7;s:18:\"business-bundle-2y\";i:8;s:18:\"business-bundle-3y\";i:9;s:19:\"ecommerce-bundle-2y\";i:10;s:19:\"ecommerce-bundle-3y\";i:11;s:23:\"personal-bundle-monthly\";i:12;s:20:\"value_bundle_monthly\";i:13;s:23:\"business-bundle-monthly\";i:14;s:33:\"wp_bundle_migration_trial_monthly\";i:15;s:31:\"wp_bundle_hosting_trial_monthly\";i:16;s:24:\"ecommerce-bundle-monthly\";i:17;s:30:\"ecommerce-trial-bundle-monthly\";i:18;s:32:\"wooexpress-medium-bundle-monthly\";i:19;s:31:\"wooexpress-small-bundle-monthly\";i:20;s:31:\"wooexpress-medium-bundle-yearly\";i:21;s:30:\"wooexpress-small-bundle-yearly\";i:22;s:16:\"pro-plan-monthly\";i:23;s:11:\"pro-plan-2y\";i:24;s:39:\"wp_com_hundred_year_bundle_centennially\";i:25;s:12:\"starter-plan\";i:26;s:8:\"pro-plan\";}s:15:\"personal-themes\";a:27:{i:0;s:15:\"personal-bundle\";i:1;s:12:\"value_bundle\";i:2;s:16:\"ecommerce-bundle\";i:3;s:18:\"personal-bundle-2y\";i:4;s:18:\"personal-bundle-3y\";i:5;s:15:\"value_bundle-2y\";i:6;s:15:\"value_bundle-3y\";i:7;s:18:\"business-bundle-2y\";i:8;s:18:\"business-bundle-3y\";i:9;s:19:\"ecommerce-bundle-2y\";i:10;s:19:\"ecommerce-bundle-3y\";i:11;s:23:\"personal-bundle-monthly\";i:12;s:20:\"value_bundle_monthly\";i:13;s:23:\"business-bundle-monthly\";i:14;s:33:\"wp_bundle_migration_trial_monthly\";i:15;s:31:\"wp_bundle_hosting_trial_monthly\";i:16;s:24:\"ecommerce-bundle-monthly\";i:17;s:30:\"ecommerce-trial-bundle-monthly\";i:18;s:32:\"wooexpress-medium-bundle-monthly\";i:19;s:31:\"wooexpress-small-bundle-monthly\";i:20;s:31:\"wooexpress-medium-bundle-yearly\";i:21;s:30:\"wooexpress-small-bundle-yearly\";i:22;s:16:\"pro-plan-monthly\";i:23;s:11:\"pro-plan-2y\";i:24;s:39:\"wp_com_hundred_year_bundle_centennially\";i:25;s:12:\"starter-plan\";i:26;s:8:\"pro-plan\";}s:25:\"set-primary-custom-domain\";a:29:{i:0;s:15:\"personal-bundle\";i:1;s:12:\"value_bundle\";i:2;s:16:\"ecommerce-bundle\";i:3;s:18:\"personal-bundle-2y\";i:4;s:18:\"personal-bundle-3y\";i:5;s:15:\"value_bundle-2y\";i:6;s:15:\"value_bundle-3y\";i:7;s:18:\"business-bundle-2y\";i:8;s:18:\"business-bundle-3y\";i:9;s:14:\"blogger-bundle\";i:10;s:17:\"blogger-bundle-2y\";i:11;s:19:\"ecommerce-bundle-2y\";i:12;s:19:\"ecommerce-bundle-3y\";i:13;s:23:\"personal-bundle-monthly\";i:14;s:20:\"value_bundle_monthly\";i:15;s:23:\"business-bundle-monthly\";i:16;s:33:\"wp_bundle_migration_trial_monthly\";i:17;s:31:\"wp_bundle_hosting_trial_monthly\";i:18;s:24:\"ecommerce-bundle-monthly\";i:19;s:30:\"ecommerce-trial-bundle-monthly\";i:20;s:32:\"wooexpress-medium-bundle-monthly\";i:21;s:31:\"wooexpress-small-bundle-monthly\";i:22;s:31:\"wooexpress-medium-bundle-yearly\";i:23;s:30:\"wooexpress-small-bundle-yearly\";i:24;s:16:\"pro-plan-monthly\";i:25;s:11:\"pro-plan-2y\";i:26;s:39:\"wp_com_hundred_year_bundle_centennially\";i:27;s:12:\"starter-plan\";i:28;s:8:\"pro-plan\";}s:22:\"space-upgraded-storage\";a:28:{i:0;s:15:\"personal-bundle\";i:1;s:12:\"value_bundle\";i:2;s:16:\"ecommerce-bundle\";i:3;s:18:\"personal-bundle-2y\";i:4;s:18:\"personal-bundle-3y\";i:5;s:15:\"value_bundle-2y\";i:6;s:15:\"value_bundle-3y\";i:7;s:18:\"business-bundle-2y\";i:8;s:18:\"business-bundle-3y\";i:9;s:14:\"blogger-bundle\";i:10;s:17:\"blogger-bundle-2y\";i:11;s:19:\"ecommerce-bundle-2y\";i:12;s:19:\"ecommerce-bundle-3y\";i:13;s:23:\"personal-bundle-monthly\";i:14;s:20:\"value_bundle_monthly\";i:15;s:23:\"business-bundle-monthly\";i:16;s:33:\"wp_bundle_migration_trial_monthly\";i:17;s:24:\"ecommerce-bundle-monthly\";i:18;s:30:\"ecommerce-trial-bundle-monthly\";i:19;s:32:\"wooexpress-medium-bundle-monthly\";i:20;s:31:\"wooexpress-small-bundle-monthly\";i:21;s:31:\"wooexpress-medium-bundle-yearly\";i:22;s:30:\"wooexpress-small-bundle-yearly\";i:23;s:16:\"pro-plan-monthly\";i:24;s:11:\"pro-plan-2y\";i:25;s:39:\"wp_com_hundred_year_bundle_centennially\";i:26;s:12:\"starter-plan\";i:27;s:8:\"pro-plan\";}s:10:\"stats-paid\";a:27:{i:0;s:15:\"personal-bundle\";i:1;s:12:\"value_bundle\";i:2;s:16:\"ecommerce-bundle\";i:3;s:18:\"personal-bundle-2y\";i:4;s:18:\"personal-bundle-3y\";i:5;s:15:\"value_bundle-2y\";i:6;s:15:\"value_bundle-3y\";i:7;s:18:\"business-bundle-2y\";i:8;s:18:\"business-bundle-3y\";i:9;s:19:\"ecommerce-bundle-2y\";i:10;s:19:\"ecommerce-bundle-3y\";i:11;s:23:\"personal-bundle-monthly\";i:12;s:20:\"value_bundle_monthly\";i:13;s:23:\"business-bundle-monthly\";i:14;s:33:\"wp_bundle_migration_trial_monthly\";i:15;s:31:\"wp_bundle_hosting_trial_monthly\";i:16;s:24:\"ecommerce-bundle-monthly\";i:17;s:30:\"ecommerce-trial-bundle-monthly\";i:18;s:32:\"wooexpress-medium-bundle-monthly\";i:19;s:31:\"wooexpress-small-bundle-monthly\";i:20;s:31:\"wooexpress-medium-bundle-yearly\";i:21;s:30:\"wooexpress-small-bundle-yearly\";i:22;s:16:\"pro-plan-monthly\";i:23;s:11:\"pro-plan-2y\";i:24;s:39:\"wp_com_hundred_year_bundle_centennially\";i:25;s:12:\"starter-plan\";i:26;s:8:\"pro-plan\";}s:28:\"subscriber-unlimited-imports\";a:25:{i:0;s:15:\"personal-bundle\";i:1;s:12:\"value_bundle\";i:2;s:16:\"ecommerce-bundle\";i:3;s:18:\"personal-bundle-2y\";i:4;s:18:\"personal-bundle-3y\";i:5;s:15:\"value_bundle-2y\";i:6;s:15:\"value_bundle-3y\";i:7;s:18:\"business-bundle-2y\";i:8;s:18:\"business-bundle-3y\";i:9;s:19:\"ecommerce-bundle-2y\";i:10;s:19:\"ecommerce-bundle-3y\";i:11;s:23:\"personal-bundle-monthly\";i:12;s:20:\"value_bundle_monthly\";i:13;s:23:\"business-bundle-monthly\";i:14;s:24:\"ecommerce-bundle-monthly\";i:15;s:30:\"ecommerce-trial-bundle-monthly\";i:16;s:32:\"wooexpress-medium-bundle-monthly\";i:17;s:31:\"wooexpress-small-bundle-monthly\";i:18;s:31:\"wooexpress-medium-bundle-yearly\";i:19;s:30:\"wooexpress-small-bundle-yearly\";i:20;s:16:\"pro-plan-monthly\";i:21;s:11:\"pro-plan-2y\";i:22;s:39:\"wp_com_hundred_year_bundle_centennially\";i:23;s:12:\"starter-plan\";i:24;s:8:\"pro-plan\";}s:20:\"subscription-gifting\";a:24:{i:0;s:15:\"personal-bundle\";i:1;s:12:\"value_bundle\";i:2;s:16:\"ecommerce-bundle\";i:3;s:18:\"personal-bundle-2y\";i:4;s:18:\"personal-bundle-3y\";i:5;s:15:\"value_bundle-2y\";i:6;s:15:\"value_bundle-3y\";i:7;s:18:\"business-bundle-2y\";i:8;s:18:\"business-bundle-3y\";i:9;s:19:\"ecommerce-bundle-2y\";i:10;s:19:\"ecommerce-bundle-3y\";i:11;s:23:\"personal-bundle-monthly\";i:12;s:20:\"value_bundle_monthly\";i:13;s:23:\"business-bundle-monthly\";i:14;s:24:\"ecommerce-bundle-monthly\";i:15;s:32:\"wooexpress-medium-bundle-monthly\";i:16;s:31:\"wooexpress-small-bundle-monthly\";i:17;s:31:\"wooexpress-medium-bundle-yearly\";i:18;s:30:\"wooexpress-small-bundle-yearly\";i:19;s:16:\"pro-plan-monthly\";i:20;s:11:\"pro-plan-2y\";i:21;s:39:\"wp_com_hundred_year_bundle_centennially\";i:22;s:12:\"starter-plan\";i:23;s:8:\"pro-plan\";}s:25:\"upgraded_upload_filetypes\";a:29:{i:0;s:15:\"personal-bundle\";i:1;s:12:\"value_bundle\";i:2;s:16:\"ecommerce-bundle\";i:3;s:18:\"personal-bundle-2y\";i:4;s:18:\"personal-bundle-3y\";i:5;s:15:\"value_bundle-2y\";i:6;s:15:\"value_bundle-3y\";i:7;s:18:\"business-bundle-2y\";i:8;s:18:\"business-bundle-3y\";i:9;s:14:\"blogger-bundle\";i:10;s:17:\"blogger-bundle-2y\";i:11;s:19:\"ecommerce-bundle-2y\";i:12;s:19:\"ecommerce-bundle-3y\";i:13;s:23:\"personal-bundle-monthly\";i:14;s:20:\"value_bundle_monthly\";i:15;s:23:\"business-bundle-monthly\";i:16;s:33:\"wp_bundle_migration_trial_monthly\";i:17;s:31:\"wp_bundle_hosting_trial_monthly\";i:18;s:24:\"ecommerce-bundle-monthly\";i:19;s:30:\"ecommerce-trial-bundle-monthly\";i:20;s:32:\"wooexpress-medium-bundle-monthly\";i:21;s:31:\"wooexpress-small-bundle-monthly\";i:22;s:31:\"wooexpress-medium-bundle-yearly\";i:23;s:30:\"wooexpress-small-bundle-yearly\";i:24;s:16:\"pro-plan-monthly\";i:25;s:11:\"pro-plan-2y\";i:26;s:39:\"wp_com_hundred_year_bundle_centennially\";i:27;s:12:\"starter-plan\";i:28;s:8:\"pro-plan\";}s:7:\"big-sky\";a:10:{i:0;s:12:\"value_bundle\";i:1;s:15:\"value_bundle-2y\";i:2;s:15:\"value_bundle-3y\";i:3;s:18:\"business-bundle-2y\";i:4;s:18:\"business-bundle-3y\";i:5;s:20:\"value_bundle_monthly\";i:6;s:23:\"business-bundle-monthly\";i:7;s:33:\"wp_bundle_migration_trial_monthly\";i:8;s:31:\"wp_bundle_hosting_trial_monthly\";i:9;s:39:\"wp_com_hundred_year_bundle_centennially\";}s:8:\"calendly\";a:22:{i:0;s:12:\"value_bundle\";i:1;s:16:\"ecommerce-bundle\";i:2;s:15:\"value_bundle-2y\";i:3;s:15:\"value_bundle-3y\";i:4;s:18:\"business-bundle-2y\";i:5;s:18:\"business-bundle-3y\";i:6;s:19:\"ecommerce-bundle-2y\";i:7;s:19:\"ecommerce-bundle-3y\";i:8;s:20:\"value_bundle_monthly\";i:9;s:23:\"business-bundle-monthly\";i:10;s:33:\"wp_bundle_migration_trial_monthly\";i:11;s:31:\"wp_bundle_hosting_trial_monthly\";i:12;s:24:\"ecommerce-bundle-monthly\";i:13;s:30:\"ecommerce-trial-bundle-monthly\";i:14;s:32:\"wooexpress-medium-bundle-monthly\";i:15;s:31:\"wooexpress-small-bundle-monthly\";i:16;s:31:\"wooexpress-medium-bundle-yearly\";i:17;s:30:\"wooexpress-small-bundle-yearly\";i:18;s:16:\"pro-plan-monthly\";i:19;s:11:\"pro-plan-2y\";i:20;s:39:\"wp_com_hundred_year_bundle_centennially\";i:21;s:8:\"pro-plan\";}s:20:\"cloudflare-analytics\";a:22:{i:0;s:12:\"value_bundle\";i:1;s:16:\"ecommerce-bundle\";i:2;s:15:\"value_bundle-2y\";i:3;s:15:\"value_bundle-3y\";i:4;s:18:\"business-bundle-2y\";i:5;s:18:\"business-bundle-3y\";i:6;s:19:\"ecommerce-bundle-2y\";i:7;s:19:\"ecommerce-bundle-3y\";i:8;s:20:\"value_bundle_monthly\";i:9;s:23:\"business-bundle-monthly\";i:10;s:33:\"wp_bundle_migration_trial_monthly\";i:11;s:31:\"wp_bundle_hosting_trial_monthly\";i:12;s:24:\"ecommerce-bundle-monthly\";i:13;s:30:\"ecommerce-trial-bundle-monthly\";i:14;s:32:\"wooexpress-medium-bundle-monthly\";i:15;s:31:\"wooexpress-small-bundle-monthly\";i:16;s:31:\"wooexpress-medium-bundle-yearly\";i:17;s:30:\"wooexpress-small-bundle-yearly\";i:18;s:16:\"pro-plan-monthly\";i:19;s:11:\"pro-plan-2y\";i:20;s:39:\"wp_com_hundred_year_bundle_centennially\";i:21;s:8:\"pro-plan\";}s:14:\"cloudflare-cdn\";a:22:{i:0;s:12:\"value_bundle\";i:1;s:16:\"ecommerce-bundle\";i:2;s:15:\"value_bundle-2y\";i:3;s:15:\"value_bundle-3y\";i:4;s:18:\"business-bundle-2y\";i:5;s:18:\"business-bundle-3y\";i:6;s:19:\"ecommerce-bundle-2y\";i:7;s:19:\"ecommerce-bundle-3y\";i:8;s:20:\"value_bundle_monthly\";i:9;s:23:\"business-bundle-monthly\";i:10;s:33:\"wp_bundle_migration_trial_monthly\";i:11;s:31:\"wp_bundle_hosting_trial_monthly\";i:12;s:24:\"ecommerce-bundle-monthly\";i:13;s:30:\"ecommerce-trial-bundle-monthly\";i:14;s:32:\"wooexpress-medium-bundle-monthly\";i:15;s:31:\"wooexpress-small-bundle-monthly\";i:16;s:31:\"wooexpress-medium-bundle-yearly\";i:17;s:30:\"wooexpress-small-bundle-yearly\";i:18;s:16:\"pro-plan-monthly\";i:19;s:11:\"pro-plan-2y\";i:20;s:39:\"wp_com_hundred_year_bundle_centennially\";i:21;s:8:\"pro-plan\";}s:10:\"core/cover\";a:22:{i:0;s:12:\"value_bundle\";i:1;s:16:\"ecommerce-bundle\";i:2;s:15:\"value_bundle-2y\";i:3;s:15:\"value_bundle-3y\";i:4;s:18:\"business-bundle-2y\";i:5;s:18:\"business-bundle-3y\";i:6;s:19:\"ecommerce-bundle-2y\";i:7;s:19:\"ecommerce-bundle-3y\";i:8;s:20:\"value_bundle_monthly\";i:9;s:23:\"business-bundle-monthly\";i:10;s:33:\"wp_bundle_migration_trial_monthly\";i:11;s:31:\"wp_bundle_hosting_trial_monthly\";i:12;s:24:\"ecommerce-bundle-monthly\";i:13;s:30:\"ecommerce-trial-bundle-monthly\";i:14;s:32:\"wooexpress-medium-bundle-monthly\";i:15;s:31:\"wooexpress-small-bundle-monthly\";i:16;s:31:\"wooexpress-medium-bundle-yearly\";i:17;s:30:\"wooexpress-small-bundle-yearly\";i:18;s:16:\"pro-plan-monthly\";i:19;s:11:\"pro-plan-2y\";i:20;s:39:\"wp_com_hundred_year_bundle_centennially\";i:21;s:8:\"pro-plan\";}s:10:\"core/video\";a:22:{i:0;s:12:\"value_bundle\";i:1;s:16:\"ecommerce-bundle\";i:2;s:15:\"value_bundle-2y\";i:3;s:15:\"value_bundle-3y\";i:4;s:18:\"business-bundle-2y\";i:5;s:18:\"business-bundle-3y\";i:6;s:19:\"ecommerce-bundle-2y\";i:7;s:19:\"ecommerce-bundle-3y\";i:8;s:20:\"value_bundle_monthly\";i:9;s:23:\"business-bundle-monthly\";i:10;s:33:\"wp_bundle_migration_trial_monthly\";i:11;s:31:\"wp_bundle_hosting_trial_monthly\";i:12;s:24:\"ecommerce-bundle-monthly\";i:13;s:30:\"ecommerce-trial-bundle-monthly\";i:14;s:32:\"wooexpress-medium-bundle-monthly\";i:15;s:31:\"wooexpress-small-bundle-monthly\";i:16;s:31:\"wooexpress-medium-bundle-yearly\";i:17;s:30:\"wooexpress-small-bundle-yearly\";i:18;s:16:\"pro-plan-monthly\";i:19;s:11:\"pro-plan-2y\";i:20;s:39:\"wp_com_hundred_year_bundle_centennially\";i:21;s:8:\"pro-plan\";}s:15:\"credit-vouchers\";a:22:{i:0;s:12:\"value_bundle\";i:1;s:16:\"ecommerce-bundle\";i:2;s:15:\"value_bundle-2y\";i:3;s:15:\"value_bundle-3y\";i:4;s:18:\"business-bundle-2y\";i:5;s:18:\"business-bundle-3y\";i:6;s:19:\"ecommerce-bundle-2y\";i:7;s:19:\"ecommerce-bundle-3y\";i:8;s:20:\"value_bundle_monthly\";i:9;s:23:\"business-bundle-monthly\";i:10;s:33:\"wp_bundle_migration_trial_monthly\";i:11;s:31:\"wp_bundle_hosting_trial_monthly\";i:12;s:24:\"ecommerce-bundle-monthly\";i:13;s:30:\"ecommerce-trial-bundle-monthly\";i:14;s:32:\"wooexpress-medium-bundle-monthly\";i:15;s:31:\"wooexpress-small-bundle-monthly\";i:16;s:31:\"wooexpress-medium-bundle-yearly\";i:17;s:30:\"wooexpress-small-bundle-yearly\";i:18;s:16:\"pro-plan-monthly\";i:19;s:11:\"pro-plan-2y\";i:20;s:39:\"wp_com_hundred_year_bundle_centennially\";i:21;s:8:\"pro-plan\";}s:13:\"custom-design\";a:22:{i:0;s:12:\"value_bundle\";i:1;s:16:\"ecommerce-bundle\";i:2;s:15:\"value_bundle-2y\";i:3;s:15:\"value_bundle-3y\";i:4;s:18:\"business-bundle-2y\";i:5;s:18:\"business-bundle-3y\";i:6;s:19:\"ecommerce-bundle-2y\";i:7;s:19:\"ecommerce-bundle-3y\";i:8;s:20:\"value_bundle_monthly\";i:9;s:23:\"business-bundle-monthly\";i:10;s:33:\"wp_bundle_migration_trial_monthly\";i:11;s:31:\"wp_bundle_hosting_trial_monthly\";i:12;s:24:\"ecommerce-bundle-monthly\";i:13;s:30:\"ecommerce-trial-bundle-monthly\";i:14;s:32:\"wooexpress-medium-bundle-monthly\";i:15;s:31:\"wooexpress-small-bundle-monthly\";i:16;s:31:\"wooexpress-medium-bundle-yearly\";i:17;s:30:\"wooexpress-small-bundle-yearly\";i:18;s:16:\"pro-plan-monthly\";i:19;s:11:\"pro-plan-2y\";i:20;s:39:\"wp_com_hundred_year_bundle_centennially\";i:21;s:8:\"pro-plan\";}s:13:\"global-styles\";a:22:{i:0;s:12:\"value_bundle\";i:1;s:16:\"ecommerce-bundle\";i:2;s:15:\"value_bundle-2y\";i:3;s:15:\"value_bundle-3y\";i:4;s:18:\"business-bundle-2y\";i:5;s:18:\"business-bundle-3y\";i:6;s:19:\"ecommerce-bundle-2y\";i:7;s:19:\"ecommerce-bundle-3y\";i:8;s:20:\"value_bundle_monthly\";i:9;s:23:\"business-bundle-monthly\";i:10;s:33:\"wp_bundle_migration_trial_monthly\";i:11;s:31:\"wp_bundle_hosting_trial_monthly\";i:12;s:24:\"ecommerce-bundle-monthly\";i:13;s:30:\"ecommerce-trial-bundle-monthly\";i:14;s:32:\"wooexpress-medium-bundle-monthly\";i:15;s:31:\"wooexpress-small-bundle-monthly\";i:16;s:31:\"wooexpress-medium-bundle-yearly\";i:17;s:30:\"wooexpress-small-bundle-yearly\";i:18;s:16:\"pro-plan-monthly\";i:19;s:11:\"pro-plan-2y\";i:20;s:39:\"wp_com_hundred_year_bundle_centennially\";i:21;s:8:\"pro-plan\";}s:16:\"google-analytics\";a:23:{i:0;s:12:\"value_bundle\";i:1;s:16:\"ecommerce-bundle\";i:2;s:15:\"value_bundle-2y\";i:3;s:15:\"value_bundle-3y\";i:4;s:18:\"business-bundle-2y\";i:5;s:18:\"business-bundle-3y\";i:6;s:19:\"ecommerce-bundle-2y\";i:7;s:19:\"ecommerce-bundle-3y\";i:8;s:20:\"value_bundle_monthly\";i:9;s:23:\"business-bundle-monthly\";i:10;s:33:\"wp_bundle_migration_trial_monthly\";i:11;s:31:\"wp_bundle_hosting_trial_monthly\";i:12;s:24:\"ecommerce-bundle-monthly\";i:13;s:30:\"ecommerce-trial-bundle-monthly\";i:14;s:32:\"wooexpress-medium-bundle-monthly\";i:15;s:31:\"wooexpress-small-bundle-monthly\";i:16;s:31:\"wooexpress-medium-bundle-yearly\";i:17;s:30:\"wooexpress-small-bundle-yearly\";i:18;s:16:\"pro-plan-monthly\";i:19;s:11:\"pro-plan-2y\";i:20;s:39:\"wp_com_hundred_year_bundle_centennially\";i:21;s:12:\"starter-plan\";i:22;s:8:\"pro-plan\";}s:12:\"live_support\";a:12:{i:0;s:12:\"value_bundle\";i:1;s:16:\"ecommerce-bundle\";i:2;s:15:\"value_bundle-2y\";i:3;s:15:\"value_bundle-3y\";i:4;s:18:\"business-bundle-2y\";i:5;s:18:\"business-bundle-3y\";i:6;s:19:\"ecommerce-bundle-2y\";i:7;s:19:\"ecommerce-bundle-3y\";i:8;s:31:\"wooexpress-medium-bundle-yearly\";i:9;s:30:\"wooexpress-small-bundle-yearly\";i:10;s:11:\"pro-plan-2y\";i:11;s:8:\"pro-plan\";}s:9:\"opentable\";a:22:{i:0;s:12:\"value_bundle\";i:1;s:16:\"ecommerce-bundle\";i:2;s:15:\"value_bundle-2y\";i:3;s:15:\"value_bundle-3y\";i:4;s:18:\"business-bundle-2y\";i:5;s:18:\"business-bundle-3y\";i:6;s:19:\"ecommerce-bundle-2y\";i:7;s:19:\"ecommerce-bundle-3y\";i:8;s:20:\"value_bundle_monthly\";i:9;s:23:\"business-bundle-monthly\";i:10;s:33:\"wp_bundle_migration_trial_monthly\";i:11;s:31:\"wp_bundle_hosting_trial_monthly\";i:12;s:24:\"ecommerce-bundle-monthly\";i:13;s:30:\"ecommerce-trial-bundle-monthly\";i:14;s:32:\"wooexpress-medium-bundle-monthly\";i:15;s:31:\"wooexpress-small-bundle-monthly\";i:16;s:31:\"wooexpress-medium-bundle-yearly\";i:17;s:30:\"wooexpress-small-bundle-yearly\";i:18;s:16:\"pro-plan-monthly\";i:19;s:11:\"pro-plan-2y\";i:20;s:39:\"wp_com_hundred_year_bundle_centennially\";i:21;s:8:\"pro-plan\";}s:14:\"premium-themes\";a:22:{i:0;s:12:\"value_bundle\";i:1;s:16:\"ecommerce-bundle\";i:2;s:15:\"value_bundle-2y\";i:3;s:15:\"value_bundle-3y\";i:4;s:18:\"business-bundle-2y\";i:5;s:18:\"business-bundle-3y\";i:6;s:19:\"ecommerce-bundle-2y\";i:7;s:19:\"ecommerce-bundle-3y\";i:8;s:20:\"value_bundle_monthly\";i:9;s:23:\"business-bundle-monthly\";i:10;s:33:\"wp_bundle_migration_trial_monthly\";i:11;s:31:\"wp_bundle_hosting_trial_monthly\";i:12;s:24:\"ecommerce-bundle-monthly\";i:13;s:30:\"ecommerce-trial-bundle-monthly\";i:14;s:32:\"wooexpress-medium-bundle-monthly\";i:15;s:31:\"wooexpress-small-bundle-monthly\";i:16;s:31:\"wooexpress-medium-bundle-yearly\";i:17;s:30:\"wooexpress-small-bundle-yearly\";i:18;s:16:\"pro-plan-monthly\";i:19;s:11:\"pro-plan-2y\";i:20;s:39:\"wp_com_hundred_year_bundle_centennially\";i:21;s:8:\"pro-plan\";}s:13:\"private_whois\";a:22:{i:0;s:12:\"value_bundle\";i:1;s:16:\"ecommerce-bundle\";i:2;s:15:\"value_bundle-2y\";i:3;s:15:\"value_bundle-3y\";i:4;s:18:\"business-bundle-2y\";i:5;s:18:\"business-bundle-3y\";i:6;s:19:\"ecommerce-bundle-2y\";i:7;s:19:\"ecommerce-bundle-3y\";i:8;s:20:\"value_bundle_monthly\";i:9;s:23:\"business-bundle-monthly\";i:10;s:33:\"wp_bundle_migration_trial_monthly\";i:11;s:31:\"wp_bundle_hosting_trial_monthly\";i:12;s:24:\"ecommerce-bundle-monthly\";i:13;s:30:\"ecommerce-trial-bundle-monthly\";i:14;s:32:\"wooexpress-medium-bundle-monthly\";i:15;s:31:\"wooexpress-small-bundle-monthly\";i:16;s:31:\"wooexpress-medium-bundle-yearly\";i:17;s:30:\"wooexpress-small-bundle-yearly\";i:18;s:16:\"pro-plan-monthly\";i:19;s:11:\"pro-plan-2y\";i:20;s:39:\"wp_com_hundred_year_bundle_centennially\";i:21;s:8:\"pro-plan\";}s:11:\"republicize\";a:22:{i:0;s:12:\"value_bundle\";i:1;s:16:\"ecommerce-bundle\";i:2;s:15:\"value_bundle-2y\";i:3;s:15:\"value_bundle-3y\";i:4;s:18:\"business-bundle-2y\";i:5;s:18:\"business-bundle-3y\";i:6;s:19:\"ecommerce-bundle-2y\";i:7;s:19:\"ecommerce-bundle-3y\";i:8;s:20:\"value_bundle_monthly\";i:9;s:23:\"business-bundle-monthly\";i:10;s:33:\"wp_bundle_migration_trial_monthly\";i:11;s:31:\"wp_bundle_hosting_trial_monthly\";i:12;s:24:\"ecommerce-bundle-monthly\";i:13;s:30:\"ecommerce-trial-bundle-monthly\";i:14;s:32:\"wooexpress-medium-bundle-monthly\";i:15;s:31:\"wooexpress-small-bundle-monthly\";i:16;s:31:\"wooexpress-medium-bundle-yearly\";i:17;s:30:\"wooexpress-small-bundle-yearly\";i:18;s:16:\"pro-plan-monthly\";i:19;s:11:\"pro-plan-2y\";i:20;s:39:\"wp_com_hundred_year_bundle_centennially\";i:21;s:8:\"pro-plan\";}s:14:\"send-a-message\";a:22:{i:0;s:12:\"value_bundle\";i:1;s:16:\"ecommerce-bundle\";i:2;s:15:\"value_bundle-2y\";i:3;s:15:\"value_bundle-3y\";i:4;s:18:\"business-bundle-2y\";i:5;s:18:\"business-bundle-3y\";i:6;s:19:\"ecommerce-bundle-2y\";i:7;s:19:\"ecommerce-bundle-3y\";i:8;s:20:\"value_bundle_monthly\";i:9;s:23:\"business-bundle-monthly\";i:10;s:33:\"wp_bundle_migration_trial_monthly\";i:11;s:31:\"wp_bundle_hosting_trial_monthly\";i:12;s:24:\"ecommerce-bundle-monthly\";i:13;s:30:\"ecommerce-trial-bundle-monthly\";i:14;s:32:\"wooexpress-medium-bundle-monthly\";i:15;s:31:\"wooexpress-small-bundle-monthly\";i:16;s:31:\"wooexpress-medium-bundle-yearly\";i:17;s:30:\"wooexpress-small-bundle-yearly\";i:18;s:16:\"pro-plan-monthly\";i:19;s:11:\"pro-plan-2y\";i:20;s:39:\"wp_com_hundred_year_bundle_centennially\";i:21;s:8:\"pro-plan\";}s:15:\"simple-payments\";a:22:{i:0;s:12:\"value_bundle\";i:1;s:16:\"ecommerce-bundle\";i:2;s:15:\"value_bundle-2y\";i:3;s:15:\"value_bundle-3y\";i:4;s:18:\"business-bundle-2y\";i:5;s:18:\"business-bundle-3y\";i:6;s:19:\"ecommerce-bundle-2y\";i:7;s:19:\"ecommerce-bundle-3y\";i:8;s:20:\"value_bundle_monthly\";i:9;s:23:\"business-bundle-monthly\";i:10;s:33:\"wp_bundle_migration_trial_monthly\";i:11;s:31:\"wp_bundle_hosting_trial_monthly\";i:12;s:24:\"ecommerce-bundle-monthly\";i:13;s:30:\"ecommerce-trial-bundle-monthly\";i:14;s:32:\"wooexpress-medium-bundle-monthly\";i:15;s:31:\"wooexpress-small-bundle-monthly\";i:16;s:31:\"wooexpress-medium-bundle-yearly\";i:17;s:30:\"wooexpress-small-bundle-yearly\";i:18;s:16:\"pro-plan-monthly\";i:19;s:11:\"pro-plan-2y\";i:20;s:39:\"wp_com_hundred_year_bundle_centennially\";i:21;s:8:\"pro-plan\";}s:16:\"stats-commercial\";a:22:{i:0;s:12:\"value_bundle\";i:1;s:16:\"ecommerce-bundle\";i:2;s:15:\"value_bundle-2y\";i:3;s:15:\"value_bundle-3y\";i:4;s:18:\"business-bundle-2y\";i:5;s:18:\"business-bundle-3y\";i:6;s:19:\"ecommerce-bundle-2y\";i:7;s:19:\"ecommerce-bundle-3y\";i:8;s:20:\"value_bundle_monthly\";i:9;s:23:\"business-bundle-monthly\";i:10;s:33:\"wp_bundle_migration_trial_monthly\";i:11;s:31:\"wp_bundle_hosting_trial_monthly\";i:12;s:24:\"ecommerce-bundle-monthly\";i:13;s:30:\"ecommerce-trial-bundle-monthly\";i:14;s:32:\"wooexpress-medium-bundle-monthly\";i:15;s:31:\"wooexpress-small-bundle-monthly\";i:16;s:31:\"wooexpress-medium-bundle-yearly\";i:17;s:30:\"wooexpress-small-bundle-yearly\";i:18;s:16:\"pro-plan-monthly\";i:19;s:11:\"pro-plan-2y\";i:20;s:39:\"wp_com_hundred_year_bundle_centennially\";i:21;s:8:\"pro-plan\";}s:18:\"upload-audio-files\";a:22:{i:0;s:12:\"value_bundle\";i:1;s:16:\"ecommerce-bundle\";i:2;s:15:\"value_bundle-2y\";i:3;s:15:\"value_bundle-3y\";i:4;s:18:\"business-bundle-2y\";i:5;s:18:\"business-bundle-3y\";i:6;s:19:\"ecommerce-bundle-2y\";i:7;s:19:\"ecommerce-bundle-3y\";i:8;s:20:\"value_bundle_monthly\";i:9;s:23:\"business-bundle-monthly\";i:10;s:33:\"wp_bundle_migration_trial_monthly\";i:11;s:31:\"wp_bundle_hosting_trial_monthly\";i:12;s:24:\"ecommerce-bundle-monthly\";i:13;s:30:\"ecommerce-trial-bundle-monthly\";i:14;s:32:\"wooexpress-medium-bundle-monthly\";i:15;s:31:\"wooexpress-small-bundle-monthly\";i:16;s:31:\"wooexpress-medium-bundle-yearly\";i:17;s:30:\"wooexpress-small-bundle-yearly\";i:18;s:16:\"pro-plan-monthly\";i:19;s:11:\"pro-plan-2y\";i:20;s:39:\"wp_com_hundred_year_bundle_centennially\";i:21;s:8:\"pro-plan\";}s:18:\"upload-video-files\";a:22:{i:0;s:12:\"value_bundle\";i:1;s:16:\"ecommerce-bundle\";i:2;s:15:\"value_bundle-2y\";i:3;s:15:\"value_bundle-3y\";i:4;s:18:\"business-bundle-2y\";i:5;s:18:\"business-bundle-3y\";i:6;s:19:\"ecommerce-bundle-2y\";i:7;s:19:\"ecommerce-bundle-3y\";i:8;s:20:\"value_bundle_monthly\";i:9;s:23:\"business-bundle-monthly\";i:10;s:33:\"wp_bundle_migration_trial_monthly\";i:11;s:31:\"wp_bundle_hosting_trial_monthly\";i:12;s:24:\"ecommerce-bundle-monthly\";i:13;s:30:\"ecommerce-trial-bundle-monthly\";i:14;s:32:\"wooexpress-medium-bundle-monthly\";i:15;s:31:\"wooexpress-small-bundle-monthly\";i:16;s:31:\"wooexpress-medium-bundle-yearly\";i:17;s:30:\"wooexpress-small-bundle-yearly\";i:18;s:16:\"pro-plan-monthly\";i:19;s:11:\"pro-plan-2y\";i:20;s:39:\"wp_com_hundred_year_bundle_centennially\";i:21;s:8:\"pro-plan\";}s:13:\"video-hosting\";a:21:{i:0;s:12:\"value_bundle\";i:1;s:16:\"ecommerce-bundle\";i:2;s:15:\"value_bundle-2y\";i:3;s:15:\"value_bundle-3y\";i:4;s:18:\"business-bundle-2y\";i:5;s:18:\"business-bundle-3y\";i:6;s:19:\"ecommerce-bundle-2y\";i:7;s:19:\"ecommerce-bundle-3y\";i:8;s:20:\"value_bundle_monthly\";i:9;s:23:\"business-bundle-monthly\";i:10;s:33:\"wp_bundle_migration_trial_monthly\";i:11;s:31:\"wp_bundle_hosting_trial_monthly\";i:12;s:24:\"ecommerce-bundle-monthly\";i:13;s:32:\"wooexpress-medium-bundle-monthly\";i:14;s:31:\"wooexpress-small-bundle-monthly\";i:15;s:31:\"wooexpress-medium-bundle-yearly\";i:16;s:30:\"wooexpress-small-bundle-yearly\";i:17;s:16:\"pro-plan-monthly\";i:18;s:11:\"pro-plan-2y\";i:19;s:39:\"wp_com_hundred_year_bundle_centennially\";i:20;s:8:\"pro-plan\";}s:10:\"videopress\";a:22:{i:0;s:12:\"value_bundle\";i:1;s:16:\"ecommerce-bundle\";i:2;s:15:\"value_bundle-2y\";i:3;s:15:\"value_bundle-3y\";i:4;s:18:\"business-bundle-2y\";i:5;s:18:\"business-bundle-3y\";i:6;s:19:\"ecommerce-bundle-2y\";i:7;s:19:\"ecommerce-bundle-3y\";i:8;s:20:\"value_bundle_monthly\";i:9;s:23:\"business-bundle-monthly\";i:10;s:33:\"wp_bundle_migration_trial_monthly\";i:11;s:31:\"wp_bundle_hosting_trial_monthly\";i:12;s:24:\"ecommerce-bundle-monthly\";i:13;s:30:\"ecommerce-trial-bundle-monthly\";i:14;s:32:\"wooexpress-medium-bundle-monthly\";i:15;s:31:\"wooexpress-small-bundle-monthly\";i:16;s:31:\"wooexpress-medium-bundle-yearly\";i:17;s:30:\"wooexpress-small-bundle-yearly\";i:18;s:16:\"pro-plan-monthly\";i:19;s:11:\"pro-plan-2y\";i:20;s:39:\"wp_com_hundred_year_bundle_centennially\";i:21;s:8:\"pro-plan\";}s:16:\"videopress/video\";a:21:{i:0;s:12:\"value_bundle\";i:1;s:16:\"ecommerce-bundle\";i:2;s:15:\"value_bundle-2y\";i:3;s:15:\"value_bundle-3y\";i:4;s:18:\"business-bundle-2y\";i:5;s:18:\"business-bundle-3y\";i:6;s:19:\"ecommerce-bundle-2y\";i:7;s:19:\"ecommerce-bundle-3y\";i:8;s:20:\"value_bundle_monthly\";i:9;s:23:\"business-bundle-monthly\";i:10;s:33:\"wp_bundle_migration_trial_monthly\";i:11;s:31:\"wp_bundle_hosting_trial_monthly\";i:12;s:24:\"ecommerce-bundle-monthly\";i:13;s:32:\"wooexpress-medium-bundle-monthly\";i:14;s:31:\"wooexpress-small-bundle-monthly\";i:15;s:31:\"wooexpress-medium-bundle-yearly\";i:16;s:30:\"wooexpress-small-bundle-yearly\";i:17;s:16:\"pro-plan-monthly\";i:18;s:11:\"pro-plan-2y\";i:19;s:39:\"wp_com_hundred_year_bundle_centennially\";i:20;s:8:\"pro-plan\";}s:15:\"whatsapp-button\";a:22:{i:0;s:12:\"value_bundle\";i:1;s:16:\"ecommerce-bundle\";i:2;s:15:\"value_bundle-2y\";i:3;s:15:\"value_bundle-3y\";i:4;s:18:\"business-bundle-2y\";i:5;s:18:\"business-bundle-3y\";i:6;s:19:\"ecommerce-bundle-2y\";i:7;s:19:\"ecommerce-bundle-3y\";i:8;s:20:\"value_bundle_monthly\";i:9;s:23:\"business-bundle-monthly\";i:10;s:33:\"wp_bundle_migration_trial_monthly\";i:11;s:31:\"wp_bundle_hosting_trial_monthly\";i:12;s:24:\"ecommerce-bundle-monthly\";i:13;s:30:\"ecommerce-trial-bundle-monthly\";i:14;s:32:\"wooexpress-medium-bundle-monthly\";i:15;s:31:\"wooexpress-small-bundle-monthly\";i:16;s:31:\"wooexpress-medium-bundle-yearly\";i:17;s:30:\"wooexpress-small-bundle-yearly\";i:18;s:16:\"pro-plan-monthly\";i:19;s:11:\"pro-plan-2y\";i:20;s:39:\"wp_com_hundred_year_bundle_centennially\";i:21;s:8:\"pro-plan\";}s:7:\"wordads\";a:22:{i:0;s:12:\"value_bundle\";i:1;s:16:\"ecommerce-bundle\";i:2;s:15:\"value_bundle-2y\";i:3;s:15:\"value_bundle-3y\";i:4;s:18:\"business-bundle-2y\";i:5;s:18:\"business-bundle-3y\";i:6;s:19:\"ecommerce-bundle-2y\";i:7;s:19:\"ecommerce-bundle-3y\";i:8;s:20:\"value_bundle_monthly\";i:9;s:23:\"business-bundle-monthly\";i:10;s:33:\"wp_bundle_migration_trial_monthly\";i:11;s:31:\"wp_bundle_hosting_trial_monthly\";i:12;s:24:\"ecommerce-bundle-monthly\";i:13;s:30:\"ecommerce-trial-bundle-monthly\";i:14;s:32:\"wooexpress-medium-bundle-monthly\";i:15;s:31:\"wooexpress-small-bundle-monthly\";i:16;s:31:\"wooexpress-medium-bundle-yearly\";i:17;s:30:\"wooexpress-small-bundle-yearly\";i:18;s:16:\"pro-plan-monthly\";i:19;s:11:\"pro-plan-2y\";i:20;s:39:\"wp_com_hundred_year_bundle_centennially\";i:21;s:8:\"pro-plan\";}s:15:\"wordads-jetpack\";a:22:{i:0;s:12:\"value_bundle\";i:1;s:16:\"ecommerce-bundle\";i:2;s:15:\"value_bundle-2y\";i:3;s:15:\"value_bundle-3y\";i:4;s:18:\"business-bundle-2y\";i:5;s:18:\"business-bundle-3y\";i:6;s:19:\"ecommerce-bundle-2y\";i:7;s:19:\"ecommerce-bundle-3y\";i:8;s:20:\"value_bundle_monthly\";i:9;s:23:\"business-bundle-monthly\";i:10;s:33:\"wp_bundle_migration_trial_monthly\";i:11;s:31:\"wp_bundle_hosting_trial_monthly\";i:12;s:24:\"ecommerce-bundle-monthly\";i:13;s:30:\"ecommerce-trial-bundle-monthly\";i:14;s:32:\"wooexpress-medium-bundle-monthly\";i:15;s:31:\"wooexpress-small-bundle-monthly\";i:16;s:31:\"wooexpress-medium-bundle-yearly\";i:17;s:30:\"wooexpress-small-bundle-yearly\";i:18;s:16:\"pro-plan-monthly\";i:19;s:11:\"pro-plan-2y\";i:20;s:39:\"wp_com_hundred_year_bundle_centennially\";i:21;s:8:\"pro-plan\";}s:15:\"ai-seo-enhancer\";a:15:{i:0;s:16:\"ecommerce-bundle\";i:1;s:18:\"business-bundle-2y\";i:2;s:18:\"business-bundle-3y\";i:3;s:19:\"ecommerce-bundle-2y\";i:4;s:19:\"ecommerce-bundle-3y\";i:5;s:23:\"business-bundle-monthly\";i:6;s:33:\"wp_bundle_migration_trial_monthly\";i:7;s:31:\"wp_bundle_hosting_trial_monthly\";i:8;s:24:\"ecommerce-bundle-monthly\";i:9;s:30:\"ecommerce-trial-bundle-monthly\";i:10;s:32:\"wooexpress-medium-bundle-monthly\";i:11;s:31:\"wooexpress-small-bundle-monthly\";i:12;s:31:\"wooexpress-medium-bundle-yearly\";i:13;s:30:\"wooexpress-small-bundle-yearly\";i:14;s:39:\"wp_com_hundred_year_bundle_centennially\";}s:9:\"ad-credit\";a:18:{i:0;s:16:\"ecommerce-bundle\";i:1;s:18:\"business-bundle-2y\";i:2;s:18:\"business-bundle-3y\";i:3;s:19:\"ecommerce-bundle-2y\";i:4;s:19:\"ecommerce-bundle-3y\";i:5;s:23:\"business-bundle-monthly\";i:6;s:33:\"wp_bundle_migration_trial_monthly\";i:7;s:31:\"wp_bundle_hosting_trial_monthly\";i:8;s:24:\"ecommerce-bundle-monthly\";i:9;s:30:\"ecommerce-trial-bundle-monthly\";i:10;s:32:\"wooexpress-medium-bundle-monthly\";i:11;s:31:\"wooexpress-small-bundle-monthly\";i:12;s:31:\"wooexpress-medium-bundle-yearly\";i:13;s:30:\"wooexpress-small-bundle-yearly\";i:14;s:16:\"pro-plan-monthly\";i:15;s:11:\"pro-plan-2y\";i:16;s:39:\"wp_com_hundred_year_bundle_centennially\";i:17;s:8:\"pro-plan\";}s:12:\"advanced-seo\";a:18:{i:0;s:16:\"ecommerce-bundle\";i:1;s:18:\"business-bundle-2y\";i:2;s:18:\"business-bundle-3y\";i:3;s:19:\"ecommerce-bundle-2y\";i:4;s:19:\"ecommerce-bundle-3y\";i:5;s:23:\"business-bundle-monthly\";i:6;s:33:\"wp_bundle_migration_trial_monthly\";i:7;s:31:\"wp_bundle_hosting_trial_monthly\";i:8;s:24:\"ecommerce-bundle-monthly\";i:9;s:30:\"ecommerce-trial-bundle-monthly\";i:10;s:32:\"wooexpress-medium-bundle-monthly\";i:11;s:31:\"wooexpress-small-bundle-monthly\";i:12;s:31:\"wooexpress-medium-bundle-yearly\";i:13;s:30:\"wooexpress-small-bundle-yearly\";i:14;s:16:\"pro-plan-monthly\";i:15;s:11:\"pro-plan-2y\";i:16;s:39:\"wp_com_hundred_year_bundle_centennially\";i:17;s:8:\"pro-plan\";}s:8:\"antispam\";a:18:{i:0;s:16:\"ecommerce-bundle\";i:1;s:18:\"business-bundle-2y\";i:2;s:18:\"business-bundle-3y\";i:3;s:19:\"ecommerce-bundle-2y\";i:4;s:19:\"ecommerce-bundle-3y\";i:5;s:23:\"business-bundle-monthly\";i:6;s:33:\"wp_bundle_migration_trial_monthly\";i:7;s:31:\"wp_bundle_hosting_trial_monthly\";i:8;s:24:\"ecommerce-bundle-monthly\";i:9;s:30:\"ecommerce-trial-bundle-monthly\";i:10;s:32:\"wooexpress-medium-bundle-monthly\";i:11;s:31:\"wooexpress-small-bundle-monthly\";i:12;s:31:\"wooexpress-medium-bundle-yearly\";i:13;s:30:\"wooexpress-small-bundle-yearly\";i:14;s:16:\"pro-plan-monthly\";i:15;s:11:\"pro-plan-2y\";i:16;s:39:\"wp_com_hundred_year_bundle_centennially\";i:17;s:8:\"pro-plan\";}s:6:\"atomic\";a:18:{i:0;s:16:\"ecommerce-bundle\";i:1;s:18:\"business-bundle-2y\";i:2;s:18:\"business-bundle-3y\";i:3;s:19:\"ecommerce-bundle-2y\";i:4;s:19:\"ecommerce-bundle-3y\";i:5;s:23:\"business-bundle-monthly\";i:6;s:33:\"wp_bundle_migration_trial_monthly\";i:7;s:31:\"wp_bundle_hosting_trial_monthly\";i:8;s:24:\"ecommerce-bundle-monthly\";i:9;s:30:\"ecommerce-trial-bundle-monthly\";i:10;s:32:\"wooexpress-medium-bundle-monthly\";i:11;s:31:\"wooexpress-small-bundle-monthly\";i:12;s:31:\"wooexpress-medium-bundle-yearly\";i:13;s:30:\"wooexpress-small-bundle-yearly\";i:14;s:16:\"pro-plan-monthly\";i:15;s:11:\"pro-plan-2y\";i:16;s:39:\"wp_com_hundred_year_bundle_centennially\";i:17;s:8:\"pro-plan\";}s:7:\"backups\";a:18:{i:0;s:16:\"ecommerce-bundle\";i:1;s:18:\"business-bundle-2y\";i:2;s:18:\"business-bundle-3y\";i:3;s:19:\"ecommerce-bundle-2y\";i:4;s:19:\"ecommerce-bundle-3y\";i:5;s:23:\"business-bundle-monthly\";i:6;s:33:\"wp_bundle_migration_trial_monthly\";i:7;s:31:\"wp_bundle_hosting_trial_monthly\";i:8;s:24:\"ecommerce-bundle-monthly\";i:9;s:30:\"ecommerce-trial-bundle-monthly\";i:10;s:32:\"wooexpress-medium-bundle-monthly\";i:11;s:31:\"wooexpress-small-bundle-monthly\";i:12;s:31:\"wooexpress-medium-bundle-yearly\";i:13;s:30:\"wooexpress-small-bundle-yearly\";i:14;s:16:\"pro-plan-monthly\";i:15;s:11:\"pro-plan-2y\";i:16;s:39:\"wp_com_hundred_year_bundle_centennially\";i:17;s:8:\"pro-plan\";}s:7:\"restore\";a:18:{i:0;s:16:\"ecommerce-bundle\";i:1;s:18:\"business-bundle-2y\";i:2;s:18:\"business-bundle-3y\";i:3;s:19:\"ecommerce-bundle-2y\";i:4;s:19:\"ecommerce-bundle-3y\";i:5;s:23:\"business-bundle-monthly\";i:6;s:33:\"wp_bundle_migration_trial_monthly\";i:7;s:31:\"wp_bundle_hosting_trial_monthly\";i:8;s:24:\"ecommerce-bundle-monthly\";i:9;s:30:\"ecommerce-trial-bundle-monthly\";i:10;s:32:\"wooexpress-medium-bundle-monthly\";i:11;s:31:\"wooexpress-small-bundle-monthly\";i:12;s:31:\"wooexpress-medium-bundle-yearly\";i:13;s:30:\"wooexpress-small-bundle-yearly\";i:14;s:16:\"pro-plan-monthly\";i:15;s:11:\"pro-plan-2y\";i:16;s:39:\"wp_com_hundred_year_bundle_centennially\";i:17;s:8:\"pro-plan\";}s:3:\"cdn\";a:18:{i:0;s:16:\"ecommerce-bundle\";i:1;s:18:\"business-bundle-2y\";i:2;s:18:\"business-bundle-3y\";i:3;s:19:\"ecommerce-bundle-2y\";i:4;s:19:\"ecommerce-bundle-3y\";i:5;s:23:\"business-bundle-monthly\";i:6;s:33:\"wp_bundle_migration_trial_monthly\";i:7;s:31:\"wp_bundle_hosting_trial_monthly\";i:8;s:24:\"ecommerce-bundle-monthly\";i:9;s:30:\"ecommerce-trial-bundle-monthly\";i:10;s:32:\"wooexpress-medium-bundle-monthly\";i:11;s:31:\"wooexpress-small-bundle-monthly\";i:12;s:31:\"wooexpress-medium-bundle-yearly\";i:13;s:30:\"wooexpress-small-bundle-yearly\";i:14;s:16:\"pro-plan-monthly\";i:15;s:11:\"pro-plan-2y\";i:16;s:39:\"wp_com_hundred_year_bundle_centennially\";i:17;s:8:\"pro-plan\";}s:6:\"search\";a:18:{i:0;s:16:\"ecommerce-bundle\";i:1;s:18:\"business-bundle-2y\";i:2;s:18:\"business-bundle-3y\";i:3;s:19:\"ecommerce-bundle-2y\";i:4;s:19:\"ecommerce-bundle-3y\";i:5;s:23:\"business-bundle-monthly\";i:6;s:33:\"wp_bundle_migration_trial_monthly\";i:7;s:31:\"wp_bundle_hosting_trial_monthly\";i:8;s:24:\"ecommerce-bundle-monthly\";i:9;s:30:\"ecommerce-trial-bundle-monthly\";i:10;s:32:\"wooexpress-medium-bundle-monthly\";i:11;s:31:\"wooexpress-small-bundle-monthly\";i:12;s:31:\"wooexpress-medium-bundle-yearly\";i:13;s:30:\"wooexpress-small-bundle-yearly\";i:14;s:16:\"pro-plan-monthly\";i:15;s:11:\"pro-plan-2y\";i:16;s:39:\"wp_com_hundred_year_bundle_centennially\";i:17;s:8:\"pro-plan\";}s:9:\"concierge\";a:10:{i:0;s:16:\"ecommerce-bundle\";i:1;s:18:\"business-bundle-2y\";i:2;s:18:\"business-bundle-3y\";i:3;s:19:\"ecommerce-bundle-2y\";i:4;s:19:\"ecommerce-bundle-3y\";i:5;s:23:\"business-bundle-monthly\";i:6;s:33:\"wp_bundle_migration_trial_monthly\";i:7;s:31:\"wp_bundle_hosting_trial_monthly\";i:8;s:24:\"ecommerce-bundle-monthly\";i:9;s:39:\"wp_com_hundred_year_bundle_centennially\";}s:9:\"copy-site\";a:10:{i:0;s:16:\"ecommerce-bundle\";i:1;s:18:\"business-bundle-2y\";i:2;s:18:\"business-bundle-3y\";i:3;s:19:\"ecommerce-bundle-2y\";i:4;s:19:\"ecommerce-bundle-3y\";i:5;s:23:\"business-bundle-monthly\";i:6;s:33:\"wp_bundle_migration_trial_monthly\";i:7;s:31:\"wp_bundle_hosting_trial_monthly\";i:8;s:24:\"ecommerce-bundle-monthly\";i:9;s:39:\"wp_com_hundred_year_bundle_centennially\";}s:25:\"ecommerce-managed-plugins\";a:9:{i:0;s:16:\"ecommerce-bundle\";i:1;s:19:\"ecommerce-bundle-2y\";i:2;s:19:\"ecommerce-bundle-3y\";i:3;s:24:\"ecommerce-bundle-monthly\";i:4;s:30:\"ecommerce-trial-bundle-monthly\";i:5;s:32:\"wooexpress-medium-bundle-monthly\";i:6;s:31:\"wooexpress-small-bundle-monthly\";i:7;s:31:\"wooexpress-medium-bundle-yearly\";i:8;s:30:\"wooexpress-small-bundle-yearly\";}s:32:\"ecommerce-managed-plugins-medium\";a:6:{i:0;s:16:\"ecommerce-bundle\";i:1;s:19:\"ecommerce-bundle-2y\";i:2;s:19:\"ecommerce-bundle-3y\";i:3;s:24:\"ecommerce-bundle-monthly\";i:4;s:32:\"wooexpress-medium-bundle-monthly\";i:5;s:31:\"wooexpress-medium-bundle-yearly\";}s:12:\"edit-plugins\";a:17:{i:0;s:16:\"ecommerce-bundle\";i:1;s:18:\"business-bundle-2y\";i:2;s:18:\"business-bundle-3y\";i:3;s:19:\"ecommerce-bundle-2y\";i:4;s:19:\"ecommerce-bundle-3y\";i:5;s:23:\"business-bundle-monthly\";i:6;s:33:\"wp_bundle_migration_trial_monthly\";i:7;s:31:\"wp_bundle_hosting_trial_monthly\";i:8;s:24:\"ecommerce-bundle-monthly\";i:9;s:32:\"wooexpress-medium-bundle-monthly\";i:10;s:31:\"wooexpress-small-bundle-monthly\";i:11;s:31:\"wooexpress-medium-bundle-yearly\";i:12;s:30:\"wooexpress-small-bundle-yearly\";i:13;s:16:\"pro-plan-monthly\";i:14;s:11:\"pro-plan-2y\";i:15;s:39:\"wp_com_hundred_year_bundle_centennially\";i:16;s:8:\"pro-plan\";}s:11:\"edit-themes\";a:17:{i:0;s:16:\"ecommerce-bundle\";i:1;s:18:\"business-bundle-2y\";i:2;s:18:\"business-bundle-3y\";i:3;s:19:\"ecommerce-bundle-2y\";i:4;s:19:\"ecommerce-bundle-3y\";i:5;s:23:\"business-bundle-monthly\";i:6;s:33:\"wp_bundle_migration_trial_monthly\";i:7;s:31:\"wp_bundle_hosting_trial_monthly\";i:8;s:24:\"ecommerce-bundle-monthly\";i:9;s:32:\"wooexpress-medium-bundle-monthly\";i:10;s:31:\"wooexpress-small-bundle-monthly\";i:11;s:31:\"wooexpress-medium-bundle-yearly\";i:12;s:30:\"wooexpress-small-bundle-yearly\";i:13;s:16:\"pro-plan-monthly\";i:14;s:11:\"pro-plan-2y\";i:15;s:39:\"wp_com_hundred_year_bundle_centennially\";i:16;s:8:\"pro-plan\";}s:29:\"email-forwards-extended-limit\";a:18:{i:0;s:16:\"ecommerce-bundle\";i:1;s:18:\"business-bundle-2y\";i:2;s:18:\"business-bundle-3y\";i:3;s:19:\"ecommerce-bundle-2y\";i:4;s:19:\"ecommerce-bundle-3y\";i:5;s:23:\"business-bundle-monthly\";i:6;s:33:\"wp_bundle_migration_trial_monthly\";i:7;s:31:\"wp_bundle_hosting_trial_monthly\";i:8;s:24:\"ecommerce-bundle-monthly\";i:9;s:30:\"ecommerce-trial-bundle-monthly\";i:10;s:32:\"wooexpress-medium-bundle-monthly\";i:11;s:31:\"wooexpress-small-bundle-monthly\";i:12;s:31:\"wooexpress-medium-bundle-yearly\";i:13;s:30:\"wooexpress-small-bundle-yearly\";i:14;s:16:\"pro-plan-monthly\";i:15;s:11:\"pro-plan-2y\";i:16;s:39:\"wp_com_hundred_year_bundle_centennially\";i:17;s:8:\"pro-plan\";}s:18:\"google-my-business\";a:18:{i:0;s:16:\"ecommerce-bundle\";i:1;s:18:\"business-bundle-2y\";i:2;s:18:\"business-bundle-3y\";i:3;s:19:\"ecommerce-bundle-2y\";i:4;s:19:\"ecommerce-bundle-3y\";i:5;s:23:\"business-bundle-monthly\";i:6;s:33:\"wp_bundle_migration_trial_monthly\";i:7;s:31:\"wp_bundle_hosting_trial_monthly\";i:8;s:24:\"ecommerce-bundle-monthly\";i:9;s:30:\"ecommerce-trial-bundle-monthly\";i:10;s:32:\"wooexpress-medium-bundle-monthly\";i:11;s:31:\"wooexpress-small-bundle-monthly\";i:12;s:31:\"wooexpress-medium-bundle-yearly\";i:13;s:30:\"wooexpress-small-bundle-yearly\";i:14;s:16:\"pro-plan-monthly\";i:15;s:11:\"pro-plan-2y\";i:16;s:39:\"wp_com_hundred_year_bundle_centennially\";i:17;s:8:\"pro-plan\";}s:15:\"install-plugins\";a:17:{i:0;s:16:\"ecommerce-bundle\";i:1;s:18:\"business-bundle-2y\";i:2;s:18:\"business-bundle-3y\";i:3;s:19:\"ecommerce-bundle-2y\";i:4;s:19:\"ecommerce-bundle-3y\";i:5;s:23:\"business-bundle-monthly\";i:6;s:33:\"wp_bundle_migration_trial_monthly\";i:7;s:31:\"wp_bundle_hosting_trial_monthly\";i:8;s:24:\"ecommerce-bundle-monthly\";i:9;s:32:\"wooexpress-medium-bundle-monthly\";i:10;s:31:\"wooexpress-small-bundle-monthly\";i:11;s:31:\"wooexpress-medium-bundle-yearly\";i:12;s:30:\"wooexpress-small-bundle-yearly\";i:13;s:16:\"pro-plan-monthly\";i:14;s:11:\"pro-plan-2y\";i:15;s:39:\"wp_com_hundred_year_bundle_centennially\";i:16;s:8:\"pro-plan\";}s:25:\"install-purchased-plugins\";a:18:{i:0;s:16:\"ecommerce-bundle\";i:1;s:18:\"business-bundle-2y\";i:2;s:18:\"business-bundle-3y\";i:3;s:19:\"ecommerce-bundle-2y\";i:4;s:19:\"ecommerce-bundle-3y\";i:5;s:23:\"business-bundle-monthly\";i:6;s:33:\"wp_bundle_migration_trial_monthly\";i:7;s:31:\"wp_bundle_hosting_trial_monthly\";i:8;s:24:\"ecommerce-bundle-monthly\";i:9;s:32:\"wooexpress-medium-bundle-monthly\";i:10;s:31:\"wooexpress-small-bundle-monthly\";i:11;s:31:\"wooexpress-medium-bundle-yearly\";i:12;s:30:\"wooexpress-small-bundle-yearly\";i:13;s:16:\"pro-plan-monthly\";i:14;s:11:\"pro-plan-2y\";i:15;s:39:\"wp_com_hundred_year_bundle_centennially\";i:16;s:12:\"starter-plan\";i:17;s:8:\"pro-plan\";}s:14:\"install-themes\";a:17:{i:0;s:16:\"ecommerce-bundle\";i:1;s:18:\"business-bundle-2y\";i:2;s:18:\"business-bundle-3y\";i:3;s:19:\"ecommerce-bundle-2y\";i:4;s:19:\"ecommerce-bundle-3y\";i:5;s:23:\"business-bundle-monthly\";i:6;s:33:\"wp_bundle_migration_trial_monthly\";i:7;s:31:\"wp_bundle_hosting_trial_monthly\";i:8;s:24:\"ecommerce-bundle-monthly\";i:9;s:32:\"wooexpress-medium-bundle-monthly\";i:10;s:31:\"wooexpress-small-bundle-monthly\";i:11;s:31:\"wooexpress-medium-bundle-yearly\";i:12;s:30:\"wooexpress-small-bundle-yearly\";i:13;s:16:\"pro-plan-monthly\";i:14;s:11:\"pro-plan-2y\";i:15;s:39:\"wp_com_hundred_year_bundle_centennially\";i:16;s:8:\"pro-plan\";}s:17:\"jetpack-dashboard\";a:18:{i:0;s:16:\"ecommerce-bundle\";i:1;s:18:\"business-bundle-2y\";i:2;s:18:\"business-bundle-3y\";i:3;s:19:\"ecommerce-bundle-2y\";i:4;s:19:\"ecommerce-bundle-3y\";i:5;s:23:\"business-bundle-monthly\";i:6;s:33:\"wp_bundle_migration_trial_monthly\";i:7;s:31:\"wp_bundle_hosting_trial_monthly\";i:8;s:24:\"ecommerce-bundle-monthly\";i:9;s:30:\"ecommerce-trial-bundle-monthly\";i:10;s:32:\"wooexpress-medium-bundle-monthly\";i:11;s:31:\"wooexpress-small-bundle-monthly\";i:12;s:31:\"wooexpress-medium-bundle-yearly\";i:13;s:30:\"wooexpress-small-bundle-yearly\";i:14;s:16:\"pro-plan-monthly\";i:15;s:11:\"pro-plan-2y\";i:16;s:39:\"wp_com_hundred_year_bundle_centennially\";i:17;s:8:\"pro-plan\";}s:22:\"list-installed-plugins\";a:19:{i:0;s:16:\"ecommerce-bundle\";i:1;s:18:\"business-bundle-2y\";i:2;s:18:\"business-bundle-3y\";i:3;s:19:\"ecommerce-bundle-2y\";i:4;s:19:\"ecommerce-bundle-3y\";i:5;s:23:\"business-bundle-monthly\";i:6;s:33:\"wp_bundle_migration_trial_monthly\";i:7;s:31:\"wp_bundle_hosting_trial_monthly\";i:8;s:24:\"ecommerce-bundle-monthly\";i:9;s:30:\"ecommerce-trial-bundle-monthly\";i:10;s:32:\"wooexpress-medium-bundle-monthly\";i:11;s:31:\"wooexpress-small-bundle-monthly\";i:12;s:31:\"wooexpress-medium-bundle-yearly\";i:13;s:30:\"wooexpress-small-bundle-yearly\";i:14;s:16:\"pro-plan-monthly\";i:15;s:11:\"pro-plan-2y\";i:16;s:39:\"wp_com_hundred_year_bundle_centennially\";i:17;s:12:\"starter-plan\";i:18;s:8:\"pro-plan\";}s:17:\"mailpoet-business\";a:8:{i:0;s:16:\"ecommerce-bundle\";i:1;s:19:\"ecommerce-bundle-2y\";i:2;s:19:\"ecommerce-bundle-3y\";i:3;s:24:\"ecommerce-bundle-monthly\";i:4;s:32:\"wooexpress-medium-bundle-monthly\";i:5;s:31:\"wooexpress-small-bundle-monthly\";i:6;s:31:\"wooexpress-medium-bundle-yearly\";i:7;s:30:\"wooexpress-small-bundle-yearly\";}s:14:\"manage-plugins\";a:17:{i:0;s:16:\"ecommerce-bundle\";i:1;s:18:\"business-bundle-2y\";i:2;s:18:\"business-bundle-3y\";i:3;s:19:\"ecommerce-bundle-2y\";i:4;s:19:\"ecommerce-bundle-3y\";i:5;s:23:\"business-bundle-monthly\";i:6;s:33:\"wp_bundle_migration_trial_monthly\";i:7;s:31:\"wp_bundle_hosting_trial_monthly\";i:8;s:24:\"ecommerce-bundle-monthly\";i:9;s:32:\"wooexpress-medium-bundle-monthly\";i:10;s:31:\"wooexpress-small-bundle-monthly\";i:11;s:31:\"wooexpress-medium-bundle-yearly\";i:12;s:30:\"wooexpress-small-bundle-yearly\";i:13;s:16:\"pro-plan-monthly\";i:14;s:11:\"pro-plan-2y\";i:15;s:39:\"wp_com_hundred_year_bundle_centennially\";i:16;s:8:\"pro-plan\";}s:17:\"no-wpcom-branding\";a:18:{i:0;s:16:\"ecommerce-bundle\";i:1;s:18:\"business-bundle-2y\";i:2;s:18:\"business-bundle-3y\";i:3;s:19:\"ecommerce-bundle-2y\";i:4;s:19:\"ecommerce-bundle-3y\";i:5;s:23:\"business-bundle-monthly\";i:6;s:33:\"wp_bundle_migration_trial_monthly\";i:7;s:31:\"wp_bundle_hosting_trial_monthly\";i:8;s:24:\"ecommerce-bundle-monthly\";i:9;s:30:\"ecommerce-trial-bundle-monthly\";i:10;s:32:\"wooexpress-medium-bundle-monthly\";i:11;s:31:\"wooexpress-small-bundle-monthly\";i:12;s:31:\"wooexpress-medium-bundle-yearly\";i:13;s:30:\"wooexpress-small-bundle-yearly\";i:14;s:16:\"pro-plan-monthly\";i:15;s:11:\"pro-plan-2y\";i:16;s:39:\"wp_com_hundred_year_bundle_centennially\";i:17;s:8:\"pro-plan\";}s:17:\"options-permalink\";a:18:{i:0;s:16:\"ecommerce-bundle\";i:1;s:18:\"business-bundle-2y\";i:2;s:18:\"business-bundle-3y\";i:3;s:19:\"ecommerce-bundle-2y\";i:4;s:19:\"ecommerce-bundle-3y\";i:5;s:23:\"business-bundle-monthly\";i:6;s:33:\"wp_bundle_migration_trial_monthly\";i:7;s:31:\"wp_bundle_hosting_trial_monthly\";i:8;s:24:\"ecommerce-bundle-monthly\";i:9;s:30:\"ecommerce-trial-bundle-monthly\";i:10;s:32:\"wooexpress-medium-bundle-monthly\";i:11;s:31:\"wooexpress-small-bundle-monthly\";i:12;s:31:\"wooexpress-medium-bundle-yearly\";i:13;s:30:\"wooexpress-small-bundle-yearly\";i:14;s:16:\"pro-plan-monthly\";i:15;s:11:\"pro-plan-2y\";i:16;s:39:\"wp_com_hundred_year_bundle_centennially\";i:17;s:8:\"pro-plan\";}s:16:\"priority_support\";a:18:{i:0;s:16:\"ecommerce-bundle\";i:1;s:18:\"business-bundle-2y\";i:2;s:18:\"business-bundle-3y\";i:3;s:19:\"ecommerce-bundle-2y\";i:4;s:19:\"ecommerce-bundle-3y\";i:5;s:23:\"business-bundle-monthly\";i:6;s:33:\"wp_bundle_migration_trial_monthly\";i:7;s:31:\"wp_bundle_hosting_trial_monthly\";i:8;s:24:\"ecommerce-bundle-monthly\";i:9;s:30:\"ecommerce-trial-bundle-monthly\";i:10;s:32:\"wooexpress-medium-bundle-monthly\";i:11;s:31:\"wooexpress-small-bundle-monthly\";i:12;s:31:\"wooexpress-medium-bundle-yearly\";i:13;s:30:\"wooexpress-small-bundle-yearly\";i:14;s:16:\"pro-plan-monthly\";i:15;s:11:\"pro-plan-2y\";i:16;s:39:\"wp_com_hundred_year_bundle_centennially\";i:17;s:8:\"pro-plan\";}s:17:\"real-time-backups\";a:18:{i:0;s:16:\"ecommerce-bundle\";i:1;s:18:\"business-bundle-2y\";i:2;s:18:\"business-bundle-3y\";i:3;s:19:\"ecommerce-bundle-2y\";i:4;s:19:\"ecommerce-bundle-3y\";i:5;s:23:\"business-bundle-monthly\";i:6;s:33:\"wp_bundle_migration_trial_monthly\";i:7;s:31:\"wp_bundle_hosting_trial_monthly\";i:8;s:24:\"ecommerce-bundle-monthly\";i:9;s:30:\"ecommerce-trial-bundle-monthly\";i:10;s:32:\"wooexpress-medium-bundle-monthly\";i:11;s:31:\"wooexpress-small-bundle-monthly\";i:12;s:31:\"wooexpress-medium-bundle-yearly\";i:13;s:30:\"wooexpress-small-bundle-yearly\";i:14;s:16:\"pro-plan-monthly\";i:15;s:11:\"pro-plan-2y\";i:16;s:39:\"wp_com_hundred_year_bundle_centennially\";i:17;s:8:\"pro-plan\";}s:4:\"scan\";a:18:{i:0;s:16:\"ecommerce-bundle\";i:1;s:18:\"business-bundle-2y\";i:2;s:18:\"business-bundle-3y\";i:3;s:19:\"ecommerce-bundle-2y\";i:4;s:19:\"ecommerce-bundle-3y\";i:5;s:23:\"business-bundle-monthly\";i:6;s:33:\"wp_bundle_migration_trial_monthly\";i:7;s:31:\"wp_bundle_hosting_trial_monthly\";i:8;s:24:\"ecommerce-bundle-monthly\";i:9;s:30:\"ecommerce-trial-bundle-monthly\";i:10;s:32:\"wooexpress-medium-bundle-monthly\";i:11;s:31:\"wooexpress-small-bundle-monthly\";i:12;s:31:\"wooexpress-medium-bundle-yearly\";i:13;s:30:\"wooexpress-small-bundle-yearly\";i:14;s:16:\"pro-plan-monthly\";i:15;s:11:\"pro-plan-2y\";i:16;s:39:\"wp_com_hundred_year_bundle_centennially\";i:17;s:8:\"pro-plan\";}s:12:\"scan-managed\";a:18:{i:0;s:16:\"ecommerce-bundle\";i:1;s:18:\"business-bundle-2y\";i:2;s:18:\"business-bundle-3y\";i:3;s:19:\"ecommerce-bundle-2y\";i:4;s:19:\"ecommerce-bundle-3y\";i:5;s:23:\"business-bundle-monthly\";i:6;s:33:\"wp_bundle_migration_trial_monthly\";i:7;s:31:\"wp_bundle_hosting_trial_monthly\";i:8;s:24:\"ecommerce-bundle-monthly\";i:9;s:30:\"ecommerce-trial-bundle-monthly\";i:10;s:32:\"wooexpress-medium-bundle-monthly\";i:11;s:31:\"wooexpress-small-bundle-monthly\";i:12;s:31:\"wooexpress-medium-bundle-yearly\";i:13;s:30:\"wooexpress-small-bundle-yearly\";i:14;s:16:\"pro-plan-monthly\";i:15;s:11:\"pro-plan-2y\";i:16;s:39:\"wp_com_hundred_year_bundle_centennially\";i:17;s:8:\"pro-plan\";}s:17:\"scheduled-updates\";a:15:{i:0;s:16:\"ecommerce-bundle\";i:1;s:18:\"business-bundle-2y\";i:2;s:18:\"business-bundle-3y\";i:3;s:19:\"ecommerce-bundle-2y\";i:4;s:19:\"ecommerce-bundle-3y\";i:5;s:23:\"business-bundle-monthly\";i:6;s:33:\"wp_bundle_migration_trial_monthly\";i:7;s:31:\"wp_bundle_hosting_trial_monthly\";i:8;s:24:\"ecommerce-bundle-monthly\";i:9;s:30:\"ecommerce-trial-bundle-monthly\";i:10;s:32:\"wooexpress-medium-bundle-monthly\";i:11;s:31:\"wooexpress-small-bundle-monthly\";i:12;s:31:\"wooexpress-medium-bundle-yearly\";i:13;s:30:\"wooexpress-small-bundle-yearly\";i:14;s:39:\"wp_com_hundred_year_bundle_centennially\";}s:17:\"security-settings\";a:18:{i:0;s:16:\"ecommerce-bundle\";i:1;s:18:\"business-bundle-2y\";i:2;s:18:\"business-bundle-3y\";i:3;s:19:\"ecommerce-bundle-2y\";i:4;s:19:\"ecommerce-bundle-3y\";i:5;s:23:\"business-bundle-monthly\";i:6;s:33:\"wp_bundle_migration_trial_monthly\";i:7;s:31:\"wp_bundle_hosting_trial_monthly\";i:8;s:24:\"ecommerce-bundle-monthly\";i:9;s:30:\"ecommerce-trial-bundle-monthly\";i:10;s:32:\"wooexpress-medium-bundle-monthly\";i:11;s:31:\"wooexpress-small-bundle-monthly\";i:12;s:31:\"wooexpress-medium-bundle-yearly\";i:13;s:30:\"wooexpress-small-bundle-yearly\";i:14;s:16:\"pro-plan-monthly\";i:15;s:11:\"pro-plan-2y\";i:16;s:39:\"wp_com_hundred_year_bundle_centennially\";i:17;s:8:\"pro-plan\";}s:17:\"seo-preview-tools\";a:18:{i:0;s:16:\"ecommerce-bundle\";i:1;s:18:\"business-bundle-2y\";i:2;s:18:\"business-bundle-3y\";i:3;s:19:\"ecommerce-bundle-2y\";i:4;s:19:\"ecommerce-bundle-3y\";i:5;s:23:\"business-bundle-monthly\";i:6;s:33:\"wp_bundle_migration_trial_monthly\";i:7;s:31:\"wp_bundle_hosting_trial_monthly\";i:8;s:24:\"ecommerce-bundle-monthly\";i:9;s:30:\"ecommerce-trial-bundle-monthly\";i:10;s:32:\"wooexpress-medium-bundle-monthly\";i:11;s:31:\"wooexpress-small-bundle-monthly\";i:12;s:31:\"wooexpress-medium-bundle-yearly\";i:13;s:30:\"wooexpress-small-bundle-yearly\";i:14;s:16:\"pro-plan-monthly\";i:15;s:11:\"pro-plan-2y\";i:16;s:39:\"wp_com_hundred_year_bundle_centennially\";i:17;s:8:\"pro-plan\";}s:4:\"sftp\";a:17:{i:0;s:16:\"ecommerce-bundle\";i:1;s:18:\"business-bundle-2y\";i:2;s:18:\"business-bundle-3y\";i:3;s:19:\"ecommerce-bundle-2y\";i:4;s:19:\"ecommerce-bundle-3y\";i:5;s:23:\"business-bundle-monthly\";i:6;s:33:\"wp_bundle_migration_trial_monthly\";i:7;s:31:\"wp_bundle_hosting_trial_monthly\";i:8;s:24:\"ecommerce-bundle-monthly\";i:9;s:32:\"wooexpress-medium-bundle-monthly\";i:10;s:31:\"wooexpress-small-bundle-monthly\";i:11;s:31:\"wooexpress-medium-bundle-yearly\";i:12;s:30:\"wooexpress-small-bundle-yearly\";i:13;s:16:\"pro-plan-monthly\";i:14;s:11:\"pro-plan-2y\";i:15;s:39:\"wp_com_hundred_year_bundle_centennially\";i:16;s:8:\"pro-plan\";}s:3:\"ssh\";a:14:{i:0;s:16:\"ecommerce-bundle\";i:1;s:18:\"business-bundle-2y\";i:2;s:18:\"business-bundle-3y\";i:3;s:19:\"ecommerce-bundle-2y\";i:4;s:19:\"ecommerce-bundle-3y\";i:5;s:23:\"business-bundle-monthly\";i:6;s:33:\"wp_bundle_migration_trial_monthly\";i:7;s:31:\"wp_bundle_hosting_trial_monthly\";i:8;s:24:\"ecommerce-bundle-monthly\";i:9;s:32:\"wooexpress-medium-bundle-monthly\";i:10;s:31:\"wooexpress-small-bundle-monthly\";i:11;s:31:\"wooexpress-medium-bundle-yearly\";i:12;s:30:\"wooexpress-small-bundle-yearly\";i:13;s:39:\"wp_com_hundred_year_bundle_centennially\";}s:18:\"site-preview-links\";a:15:{i:0;s:16:\"ecommerce-bundle\";i:1;s:18:\"business-bundle-2y\";i:2;s:18:\"business-bundle-3y\";i:3;s:19:\"ecommerce-bundle-2y\";i:4;s:19:\"ecommerce-bundle-3y\";i:5;s:23:\"business-bundle-monthly\";i:6;s:33:\"wp_bundle_migration_trial_monthly\";i:7;s:31:\"wp_bundle_hosting_trial_monthly\";i:8;s:24:\"ecommerce-bundle-monthly\";i:9;s:30:\"ecommerce-trial-bundle-monthly\";i:10;s:32:\"wooexpress-medium-bundle-monthly\";i:11;s:31:\"wooexpress-small-bundle-monthly\";i:12;s:31:\"wooexpress-medium-bundle-yearly\";i:13;s:30:\"wooexpress-small-bundle-yearly\";i:14;s:39:\"wp_com_hundred_year_bundle_centennially\";}s:26:\"social-enhanced-publishing\";a:15:{i:0;s:16:\"ecommerce-bundle\";i:1;s:18:\"business-bundle-2y\";i:2;s:18:\"business-bundle-3y\";i:3;s:19:\"ecommerce-bundle-2y\";i:4;s:19:\"ecommerce-bundle-3y\";i:5;s:23:\"business-bundle-monthly\";i:6;s:33:\"wp_bundle_migration_trial_monthly\";i:7;s:31:\"wp_bundle_hosting_trial_monthly\";i:8;s:24:\"ecommerce-bundle-monthly\";i:9;s:30:\"ecommerce-trial-bundle-monthly\";i:10;s:32:\"wooexpress-medium-bundle-monthly\";i:11;s:31:\"wooexpress-small-bundle-monthly\";i:12;s:31:\"wooexpress-medium-bundle-yearly\";i:13;s:30:\"wooexpress-small-bundle-yearly\";i:14;s:39:\"wp_com_hundred_year_bundle_centennially\";}s:22:\"social-image-generator\";a:15:{i:0;s:16:\"ecommerce-bundle\";i:1;s:18:\"business-bundle-2y\";i:2;s:18:\"business-bundle-3y\";i:3;s:19:\"ecommerce-bundle-2y\";i:4;s:19:\"ecommerce-bundle-3y\";i:5;s:23:\"business-bundle-monthly\";i:6;s:33:\"wp_bundle_migration_trial_monthly\";i:7;s:31:\"wp_bundle_hosting_trial_monthly\";i:8;s:24:\"ecommerce-bundle-monthly\";i:9;s:30:\"ecommerce-trial-bundle-monthly\";i:10;s:32:\"wooexpress-medium-bundle-monthly\";i:11;s:31:\"wooexpress-small-bundle-monthly\";i:12;s:31:\"wooexpress-medium-bundle-yearly\";i:13;s:30:\"wooexpress-small-bundle-yearly\";i:14;s:39:\"wp_com_hundred_year_bundle_centennially\";}s:13:\"staging-sites\";a:14:{i:0;s:16:\"ecommerce-bundle\";i:1;s:18:\"business-bundle-2y\";i:2;s:18:\"business-bundle-3y\";i:3;s:19:\"ecommerce-bundle-2y\";i:4;s:19:\"ecommerce-bundle-3y\";i:5;s:23:\"business-bundle-monthly\";i:6;s:33:\"wp_bundle_migration_trial_monthly\";i:7;s:31:\"wp_bundle_hosting_trial_monthly\";i:8;s:24:\"ecommerce-bundle-monthly\";i:9;s:32:\"wooexpress-medium-bundle-monthly\";i:10;s:31:\"wooexpress-small-bundle-monthly\";i:11;s:31:\"wooexpress-medium-bundle-yearly\";i:12;s:30:\"wooexpress-small-bundle-yearly\";i:13;s:39:\"wp_com_hundred_year_bundle_centennially\";}s:11:\"studio-sync\";a:15:{i:0;s:16:\"ecommerce-bundle\";i:1;s:18:\"business-bundle-2y\";i:2;s:18:\"business-bundle-3y\";i:3;s:19:\"ecommerce-bundle-2y\";i:4;s:19:\"ecommerce-bundle-3y\";i:5;s:23:\"business-bundle-monthly\";i:6;s:33:\"wp_bundle_migration_trial_monthly\";i:7;s:31:\"wp_bundle_hosting_trial_monthly\";i:8;s:24:\"ecommerce-bundle-monthly\";i:9;s:30:\"ecommerce-trial-bundle-monthly\";i:10;s:32:\"wooexpress-medium-bundle-monthly\";i:11;s:31:\"wooexpress-small-bundle-monthly\";i:12;s:31:\"wooexpress-medium-bundle-yearly\";i:13;s:30:\"wooexpress-small-bundle-yearly\";i:14;s:39:\"wp_com_hundred_year_bundle_centennially\";}s:14:\"upload-plugins\";a:17:{i:0;s:16:\"ecommerce-bundle\";i:1;s:18:\"business-bundle-2y\";i:2;s:18:\"business-bundle-3y\";i:3;s:19:\"ecommerce-bundle-2y\";i:4;s:19:\"ecommerce-bundle-3y\";i:5;s:23:\"business-bundle-monthly\";i:6;s:33:\"wp_bundle_migration_trial_monthly\";i:7;s:31:\"wp_bundle_hosting_trial_monthly\";i:8;s:24:\"ecommerce-bundle-monthly\";i:9;s:32:\"wooexpress-medium-bundle-monthly\";i:10;s:31:\"wooexpress-small-bundle-monthly\";i:11;s:31:\"wooexpress-medium-bundle-yearly\";i:12;s:30:\"wooexpress-small-bundle-yearly\";i:13;s:16:\"pro-plan-monthly\";i:14;s:11:\"pro-plan-2y\";i:15;s:39:\"wp_com_hundred_year_bundle_centennially\";i:16;s:8:\"pro-plan\";}s:13:\"upload-themes\";a:17:{i:0;s:16:\"ecommerce-bundle\";i:1;s:18:\"business-bundle-2y\";i:2;s:18:\"business-bundle-3y\";i:3;s:19:\"ecommerce-bundle-2y\";i:4;s:19:\"ecommerce-bundle-3y\";i:5;s:23:\"business-bundle-monthly\";i:6;s:33:\"wp_bundle_migration_trial_monthly\";i:7;s:31:\"wp_bundle_hosting_trial_monthly\";i:8;s:24:\"ecommerce-bundle-monthly\";i:9;s:32:\"wooexpress-medium-bundle-monthly\";i:10;s:31:\"wooexpress-small-bundle-monthly\";i:11;s:31:\"wooexpress-medium-bundle-yearly\";i:12;s:30:\"wooexpress-small-bundle-yearly\";i:13;s:16:\"pro-plan-monthly\";i:14;s:11:\"pro-plan-2y\";i:15;s:39:\"wp_com_hundred_year_bundle_centennially\";i:16;s:8:\"pro-plan\";}s:4:\"woop\";a:18:{i:0;s:16:\"ecommerce-bundle\";i:1;s:18:\"business-bundle-2y\";i:2;s:18:\"business-bundle-3y\";i:3;s:19:\"ecommerce-bundle-2y\";i:4;s:19:\"ecommerce-bundle-3y\";i:5;s:23:\"business-bundle-monthly\";i:6;s:33:\"wp_bundle_migration_trial_monthly\";i:7;s:31:\"wp_bundle_hosting_trial_monthly\";i:8;s:24:\"ecommerce-bundle-monthly\";i:9;s:30:\"ecommerce-trial-bundle-monthly\";i:10;s:32:\"wooexpress-medium-bundle-monthly\";i:11;s:31:\"wooexpress-small-bundle-monthly\";i:12;s:31:\"wooexpress-medium-bundle-yearly\";i:13;s:30:\"wooexpress-small-bundle-yearly\";i:14;s:16:\"pro-plan-monthly\";i:15;s:11:\"pro-plan-2y\";i:16;s:39:\"wp_com_hundred_year_bundle_centennially\";i:17;s:8:\"pro-plan\";}s:18:\"concierge-business\";a:6:{i:0;s:18:\"business-bundle-2y\";i:1;s:18:\"business-bundle-3y\";i:2;s:23:\"business-bundle-monthly\";i:3;s:33:\"wp_bundle_migration_trial_monthly\";i:4;s:31:\"wp_bundle_hosting_trial_monthly\";i:5;s:39:\"wp_com_hundred_year_bundle_centennially\";}s:16:\"blog-domain-only\";a:2:{i:0;s:14:\"blogger-bundle\";i:1;s:17:\"blogger-bundle-2y\";}s:22:\"reduced-email-priority\";a:3:{i:0;s:33:\"wp_bundle_migration_trial_monthly\";i:1;s:31:\"wp_bundle_hosting_trial_monthly\";i:2;s:30:\"ecommerce-trial-bundle-monthly\";}s:31:\"ecommerce-managed-plugins-trial\";a:1:{i:0;s:30:\"ecommerce-trial-bundle-monthly\";}s:30:\"install-woo-onboarding-plugins\";a:1:{i:0;s:30:\"ecommerce-trial-bundle-monthly\";}s:31:\"ecommerce-managed-plugins-small\";a:2:{i:0;s:31:\"wooexpress-small-bundle-monthly\";i:1;s:30:\"wooexpress-small-bundle-yearly\";}s:29:\"artificial-50gb-storage-limit\";a:3:{i:0;s:16:\"pro-plan-monthly\";i:1;s:11:\"pro-plan-2y\";i:2;s:8:\"pro-plan\";}s:15:\"archive-content\";a:1:{i:0;s:39:\"wp_com_hundred_year_bundle_centennially\";}s:14:\"legacy-contact\";a:1:{i:0;s:39:\"wp_com_hundred_year_bundle_centennially\";}s:11:\"locked-mode\";a:1:{i:0;s:39:\"wp_com_hundred_year_bundle_centennially\";}}}}","on"),
("415","crowdsignal_user_code","$P$B5p7RsJS1puVDt0aJl4pKLmBaVIpY//","auto"),
("417","recently_activated","a:0:{}","off"),
("419","jetpack_sync_full_status","a:4:{s:7:\"started\";i:1742655318;s:8:\"finished\";i:1742655326;s:8:\"progress\";a:10:{s:9:\"constants\";a:1:{s:8:\"finished\";b:1;}s:9:\"functions\";a:1:{s:8:\"finished\";b:1;}s:7:\"options\";a:1:{s:8:\"finished\";b:1;}s:5:\"terms\";a:4:{s:5:\"total\";i:5;s:4:\"sent\";i:5;s:8:\"finished\";b:1;s:9:\"last_sent\";s:1:\"1\";}s:6:\"themes\";a:1:{s:8:\"finished\";b:1;}s:5:\"users\";a:4:{s:5:\"total\";i:1;s:4:\"sent\";i:1;s:8:\"finished\";b:1;s:9:\"last_sent\";s:9:\"263052659\";}s:5:\"posts\";a:4:{s:5:\"total\";i:22;s:4:\"sent\";i:22;s:8:\"finished\";b:1;s:9:\"last_sent\";s:1:\"1\";}s:8:\"comments\";a:4:{s:5:\"total\";i:0;s:4:\"sent\";i:0;s:8:\"finished\";b:1;s:9:\"last_sent\";s:2:\"~0\";}s:7:\"updates\";a:1:{s:8:\"finished\";b:1;}s:18:\"term_relationships\";a:4:{s:5:\"total\";i:18;s:4:\"sent\";i:18;s:8:\"finished\";b:1;s:9:\"last_sent\";a:2:{s:9:\"object_id\";s:1:\"1\";s:16:\"term_taxonomy_id\";s:1:\"2\";}}}s:6:\"config\";a:10:{s:9:\"constants\";i:1;s:9:\"functions\";i:1;s:7:\"options\";i:1;s:5:\"terms\";i:1;s:6:\"themes\";i:1;s:5:\"users\";i:1;s:5:\"posts\";i:1;s:8:\"comments\";i:1;s:7:\"updates\";i:1;s:18:\"term_relationships\";i:1;}}","no"),
("420","jetpack_scheduled_plugins_update","a:0:{}","auto"),
("422","jp_sync_lock_full_sync","","off"),
("423","jp_sync_retry_after_immediate-send","1742655380.4284","off"),
("424","jp_sync_error_log_immediate-send","a:4:{s:15:\"1742655319.1736\";O:8:\"WP_Error\":3:{s:6:\"errors\";a:1:{s:27:\"concurrent_processing_error\";a:1:{i:0;s:61:\"There is another sync processing running for the same blog ID\";}}s:10:\"error_data\";a:1:{s:27:\"concurrent_processing_error\";a:5:{s:7:\"headers\";a:11:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Sat, 22 Mar 2025 14:55:19 GMT\";s:12:\"content-type\";s:23:\"text/xml; charset=UTF-8\";s:4:\"vary\";a:2:{i:0;s:15:\"Accept-Encoding\";i:1;s:20:\"accept, content-type\";}s:8:\"x-hacker\";s:62:\"Want root?  Visit join.a8c.com/hacker and mention this header.\";s:11:\"host-header\";s:13:\"WordPress.com\";s:22:\"jetpack-dedicated-sync\";s:2:\"on\";s:16:\"content-encoding\";s:2:\"br\";s:4:\"x-ac\";s:17:\"4.dfw _dfw BYPASS\";s:7:\"alt-svc\";s:19:\"h3=\":443\"; ma=86400\";s:25:\"strict-transport-security\";s:16:\"max-age=31536000\";}s:4:\"body\";s:472:\"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<methodResponse>\n  <fault>\n    <value>\n      <struct>\n        <member>\n          <name>faultCode</name>\n          <value><int>400</int></value>\n        </member>\n        <member>\n          <name>faultString</name>\n          <value><string>Jetpack: [concurrent_processing_error] There is another sync processing running for the same blog ID</string></value>\n        </member>\n      </struct>\n    </value>\n  </fault>\n</methodResponse>\n\";s:8:\"response\";a:2:{s:4:\"code\";i:200;s:7:\"message\";s:2:\"OK\";}s:7:\"cookies\";a:0:{}s:8:\"filename\";N;}}s:18:\"\0*\0additional_data\";a:1:{s:27:\"concurrent_processing_error\";a:1:{i:0;i:400;}}}s:15:\"1742655319.3545\";O:8:\"WP_Error\":3:{s:6:\"errors\";a:1:{s:27:\"concurrent_processing_error\";a:1:{i:0;s:61:\"There is another sync processing running for the same blog ID\";}}s:10:\"error_data\";a:1:{s:27:\"concurrent_processing_error\";a:5:{s:7:\"headers\";a:11:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Sat, 22 Mar 2025 14:55:19 GMT\";s:12:\"content-type\";s:23:\"text/xml; charset=UTF-8\";s:4:\"vary\";a:2:{i:0;s:15:\"Accept-Encoding\";i:1;s:20:\"accept, content-type\";}s:8:\"x-hacker\";s:62:\"Want root?  Visit join.a8c.com/hacker and mention this header.\";s:11:\"host-header\";s:13:\"WordPress.com\";s:22:\"jetpack-dedicated-sync\";s:2:\"on\";s:16:\"content-encoding\";s:2:\"br\";s:4:\"x-ac\";s:17:\"4.dfw _dfw BYPASS\";s:7:\"alt-svc\";s:19:\"h3=\":443\"; ma=86400\";s:25:\"strict-transport-security\";s:16:\"max-age=31536000\";}s:4:\"body\";s:472:\"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<methodResponse>\n  <fault>\n    <value>\n      <struct>\n        <member>\n          <name>faultCode</name>\n          <value><int>400</int></value>\n        </member>\n        <member>\n          <name>faultString</name>\n          <value><string>Jetpack: [concurrent_processing_error] There is another sync processing running for the same blog ID</string></value>\n        </member>\n      </struct>\n    </value>\n  </fault>\n</methodResponse>\n\";s:8:\"response\";a:2:{s:4:\"code\";i:200;s:7:\"message\";s:2:\"OK\";}s:7:\"cookies\";a:0:{}s:8:\"filename\";N;}}s:18:\"\0*\0additional_data\";a:1:{s:27:\"concurrent_processing_error\";a:1:{i:0;i:400;}}}s:15:\"1742655320.2827\";O:8:\"WP_Error\":3:{s:6:\"errors\";a:1:{s:51:\"jetpack_sync_send_error_concurrent_processing_error\";a:1:{i:0;s:61:\"There is another sync processing running for the same blog ID\";}}s:10:\"error_data\";a:1:{s:51:\"jetpack_sync_send_error_concurrent_processing_error\";a:1:{s:6:\"status\";i:429;}}s:18:\"\0*\0additional_data\";a:0:{}}s:15:\"1742655320.4299\";O:8:\"WP_Error\":3:{s:6:\"errors\";a:1:{s:27:\"concurrent_processing_error\";a:1:{i:0;s:61:\"There is another sync processing running for the same blog ID\";}}s:10:\"error_data\";a:1:{s:27:\"concurrent_processing_error\";a:5:{s:7:\"headers\";a:11:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Sat, 22 Mar 2025 14:55:20 GMT\";s:12:\"content-type\";s:23:\"text/xml; charset=UTF-8\";s:4:\"vary\";a:2:{i:0;s:15:\"Accept-Encoding\";i:1;s:20:\"accept, content-type\";}s:8:\"x-hacker\";s:62:\"Want root?  Visit join.a8c.com/hacker and mention this header.\";s:11:\"host-header\";s:13:\"WordPress.com\";s:22:\"jetpack-dedicated-sync\";s:2:\"on\";s:16:\"content-encoding\";s:2:\"br\";s:4:\"x-ac\";s:17:\"4.dfw _dfw BYPASS\";s:7:\"alt-svc\";s:19:\"h3=\":443\"; ma=86400\";s:25:\"strict-transport-security\";s:16:\"max-age=31536000\";}s:4:\"body\";s:472:\"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<methodResponse>\n  <fault>\n    <value>\n      <struct>\n        <member>\n          <name>faultCode</name>\n          <value><int>400</int></value>\n        </member>\n        <member>\n          <name>faultString</name>\n          <value><string>Jetpack: [concurrent_processing_error] There is another sync processing running for the same blog ID</string></value>\n        </member>\n      </struct>\n    </value>\n  </fault>\n</methodResponse>\n\";s:8:\"response\";a:2:{s:4:\"code\";i:200;s:7:\"message\";s:2:\"OK\";}s:7:\"cookies\";a:0:{}s:8:\"filename\";N;}}s:18:\"\0*\0additional_data\";a:1:{s:27:\"concurrent_processing_error\";a:1:{i:0;i:400;}}}}","auto"),
("432","jpsq_sync-1742655319.535086-15053-4","a:6:{i:0;s:14:\"updated_option\";i:1;a:3:{i:0;s:44:\"jetpack_sync_settings_wpcom_rest_api_enabled\";i:1;s:1:\"0\";i:2;i:1;}i:2;i:0;i:3;d:1742655319.534994;i:4;b:0;i:5;a:14:{s:13:\"wpcom_user_id\";N;s:16:\"external_user_id\";i:0;s:12:\"display_name\";N;s:10:\"user_email\";N;s:10:\"user_roles\";a:0:{}s:15:\"translated_role\";N;s:7:\"is_cron\";b:0;s:7:\"is_rest\";b:0;s:9:\"is_xmlrpc\";b:0;s:10:\"is_wp_rest\";b:1;s:7:\"is_ajax\";b:0;s:11:\"is_wp_admin\";b:0;s:6:\"is_cli\";b:0;s:8:\"from_url\";s:258:\"https://creakonect.com/?rest_route=%2Fjetpack%2Fv4%2Fsync%2Fsettings&_for=jetpack&token=QHf%238wvM%26XHy7P4Ch%28bsDsrbRjlafGXs%3A1%3A0&timestamp=1742655319&nonce=9d8ZDAVu0o&body-hash=OZGElXHMaDIhkaTqRdveETQciKU%3D&signature=WRC3zZ6xVfti%2BcRrXRUag2qom%2FI%3D\";}}","no"),
("433","jp_sync_last_success_immediate-send","1742700023.8765","off"),
("434","jpsq_sync-1742655319.542571-408402-2","a:6:{i:0;s:14:\"updated_option\";i:1;a:3:{i:0;s:48:\"jetpack_sync_settings_custom_queue_table_enabled\";i:1;s:1:\"0\";i:2;i:1;}i:2;i:0;i:3;d:1742655319.542464;i:4;b:0;i:5;a:14:{s:13:\"wpcom_user_id\";N;s:16:\"external_user_id\";i:0;s:12:\"display_name\";N;s:10:\"user_email\";N;s:10:\"user_roles\";a:0:{}s:15:\"translated_role\";N;s:7:\"is_cron\";b:0;s:7:\"is_rest\";b:0;s:9:\"is_xmlrpc\";b:0;s:10:\"is_wp_rest\";b:1;s:7:\"is_ajax\";b:0;s:11:\"is_wp_admin\";b:0;s:6:\"is_cli\";b:0;s:8:\"from_url\";s:254:\"https://creakonect.com/?rest_route=%2Fjetpack%2Fv4%2Fsync%2Fsettings&_for=jetpack&token=QHf%238wvM%26XHy7P4Ch%28bsDsrbRjlafGXs%3A1%3A0&timestamp=1742655319&nonce=8mBQoPMZdr&body-hash=p03riSqJgAEbjpEe4NzGVpfkolQ%3D&signature=dcUxVcZigjSnp3xfj2L3WOIEseA%3D\";}}","no");

INSERT IGNORE INTO `wp_options` VALUES 
("435","jetpack_next_sync_time_full-sync-enqueue","1742655327","on"),
("436","jpsq_sync-1742655319.550133-408402-3","a:6:{i:0;s:14:\"updated_option\";i:1;a:3:{i:0;s:44:\"jetpack_sync_settings_wpcom_rest_api_enabled\";i:1;s:1:\"1\";i:2;i:0;}i:2;i:0;i:3;d:1742655319.55004;i:4;b:0;i:5;a:14:{s:13:\"wpcom_user_id\";N;s:16:\"external_user_id\";i:0;s:12:\"display_name\";N;s:10:\"user_email\";N;s:10:\"user_roles\";a:0:{}s:15:\"translated_role\";N;s:7:\"is_cron\";b:0;s:7:\"is_rest\";b:0;s:9:\"is_xmlrpc\";b:0;s:10:\"is_wp_rest\";b:1;s:7:\"is_ajax\";b:0;s:11:\"is_wp_admin\";b:0;s:6:\"is_cli\";b:0;s:8:\"from_url\";s:254:\"https://creakonect.com/?rest_route=%2Fjetpack%2Fv4%2Fsync%2Fsettings&_for=jetpack&token=QHf%238wvM%26XHy7P4Ch%28bsDsrbRjlafGXs%3A1%3A0&timestamp=1742655319&nonce=8mBQoPMZdr&body-hash=p03riSqJgAEbjpEe4NzGVpfkolQ%3D&signature=dcUxVcZigjSnp3xfj2L3WOIEseA%3D\";}}","no"),
("437","jpsq_sync-1742655319.734302-68477-2","a:6:{i:0;s:29:\"jetpack_update_plugins_change\";i:1;a:1:{i:0;O:8:\"stdClass\":3:{s:12:\"last_checked\";i:1742655316;s:8:\"response\";a:1:{s:23:\"gutenberg/gutenberg.php\";O:8:\"stdClass\":13:{s:2:\"id\";s:23:\"w.org/plugins/gutenberg\";s:4:\"slug\";s:9:\"gutenberg\";s:6:\"plugin\";s:23:\"gutenberg/gutenberg.php\";s:11:\"new_version\";s:6:\"20.5.0\";s:3:\"url\";s:40:\"https://wordpress.org/plugins/gutenberg/\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/plugin/gutenberg.20.5.0.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:62:\"https://ps.w.org/gutenberg/assets/icon-256x256.jpg?rev=1776042\";s:2:\"1x\";s:62:\"https://ps.w.org/gutenberg/assets/icon-128x128.jpg?rev=1776042\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:65:\"https://ps.w.org/gutenberg/assets/banner-1544x500.jpg?rev=1718710\";s:2:\"1x\";s:64:\"https://ps.w.org/gutenberg/assets/banner-772x250.jpg?rev=1718710\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"6.6\";s:6:\"tested\";s:5:\"6.7.2\";s:12:\"requires_php\";s:3:\"7.2\";s:16:\"requires_plugins\";a:0:{}}}s:12:\"translations\";a:0:{}}}i:2;i:263052659;i:3;d:1742655319.734238;i:4;b:0;i:5;a:14:{s:13:\"wpcom_user_id\";N;s:16:\"external_user_id\";i:263052659;s:12:\"display_name\";s:15:\"LeBonOuvreBoite\";s:10:\"user_email\";s:25:\"lebonouvreboite@gmail.com\";s:10:\"user_roles\";a:1:{i:0;s:13:\"administrator\";}s:15:\"translated_role\";s:13:\"administrator\";s:7:\"is_cron\";b:0;s:7:\"is_rest\";b:1;s:9:\"is_xmlrpc\";b:1;s:10:\"is_wp_rest\";b:0;s:7:\"is_ajax\";b:0;s:11:\"is_wp_admin\";b:0;s:6:\"is_cli\";b:0;s:8:\"from_url\";s:238:\"https://creakonect.com/xmlrpc.php?for=jetpack&token=5%5EU%21eUtsTprpP2%21X%25G%21ytGPm%21i%26ADs%28N%3A1%3A263052659&timestamp=1742655315&nonce=HiPGkZi8uL&body-hash=fEgQNQLZQxudy%2F3FBAdr8i8XaX8%3D&signature=Sq41Qdto1KoJh8KFEmYGnH45WTM%3D\";}}","no"),
("438","jpsq_sync-1742655319.735197-68477-3","a:6:{i:0;s:28:\"jetpack_update_themes_change\";i:1;a:1:{i:0;O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1742655319;s:7:\"checked\";a:3:{s:9:\"cultivate\";s:5:\"0.0.1\";s:4:\"neve\";s:5:\"4.0.1\";s:15:\"twentytwentytwo\";s:9:\"1.9-wpcom\";}s:8:\"response\";a:1:{s:15:\"twentytwentytwo\";a:7:{s:5:\"theme\";s:15:\"twentytwentytwo\";s:11:\"new_version\";s:3:\"1.9\";s:3:\"url\";s:45:\"https://wordpress.org/themes/twentytwentytwo/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/theme/twentytwentytwo.1.9.zip\";s:8:\"requires\";s:3:\"5.9\";s:12:\"requires_php\";s:3:\"5.6\";s:4:\"name\";s:17:\"Twenty Twenty-Two\";}}s:9:\"no_update\";a:1:{s:4:\"neve\";a:6:{s:5:\"theme\";s:4:\"neve\";s:11:\"new_version\";s:5:\"4.0.1\";s:3:\"url\";s:34:\"https://wordpress.org/themes/neve/\";s:7:\"package\";s:52:\"https://downloads.wordpress.org/theme/neve.4.0.1.zip\";s:8:\"requires\";s:3:\"5.5\";s:12:\"requires_php\";s:3:\"7.0\";}}s:12:\"translations\";a:1:{i:0;a:7:{s:4:\"type\";s:5:\"theme\";s:4:\"slug\";s:4:\"neve\";s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"4.0.1\";s:7:\"updated\";s:19:\"2025-03-17 10:48:19\";s:7:\"package\";s:70:\"https://downloads.wordpress.org/translation/theme/neve/4.0.1/fr_FR.zip\";s:10:\"autoupdate\";b:1;}}}}i:2;i:263052659;i:3;d:1742655319.735155;i:4;b:0;i:5;a:14:{s:13:\"wpcom_user_id\";N;s:16:\"external_user_id\";i:263052659;s:12:\"display_name\";s:15:\"LeBonOuvreBoite\";s:10:\"user_email\";s:25:\"lebonouvreboite@gmail.com\";s:10:\"user_roles\";a:1:{i:0;s:13:\"administrator\";}s:15:\"translated_role\";s:13:\"administrator\";s:7:\"is_cron\";b:0;s:7:\"is_rest\";b:1;s:9:\"is_xmlrpc\";b:1;s:10:\"is_wp_rest\";b:0;s:7:\"is_ajax\";b:0;s:11:\"is_wp_admin\";b:0;s:6:\"is_cli\";b:0;s:8:\"from_url\";s:238:\"https://creakonect.com/xmlrpc.php?for=jetpack&token=5%5EU%21eUtsTprpP2%21X%25G%21ytGPm%21i%26ADs%28N%3A1%3A263052659&timestamp=1742655315&nonce=HiPGkZi8uL&body-hash=fEgQNQLZQxudy%2F3FBAdr8i8XaX8%3D&signature=Sq41Qdto1KoJh8KFEmYGnH45WTM%3D\";}}","no"),
("450","theme_mods_neve","a:129:{s:30:\"neve_auto_migrated_to_new_skin\";b:1;s:19:\"neve_ran_migrations\";b:1;s:22:\"neve_migrated_builders\";b:1;s:13:\"neve_new_skin\";s:3:\"new\";s:18:\"nav_menu_locations\";a:2:{s:7:\"primary\";i:0;s:6:\"footer\";i:16085;}s:13:\"ti_prev_theme\";s:9:\"cultivate\";s:24:\"neve_migrated_hfg_colors\";b:1;s:18:\"custom_css_post_id\";i:-1;s:17:\"logo_show_tagline\";i:0;s:26:\"nav-icon_button_appearance\";a:13:{s:12:\"borderRadius\";a:4:{s:3:\"top\";s:1:\"3\";s:4:\"left\";s:1:\"3\";s:6:\"bottom\";s:1:\"3\";s:5:\"right\";s:1:\"3\";}s:11:\"borderWidth\";a:4:{s:3:\"top\";i:1;s:5:\"right\";i:1;s:6:\"bottom\";i:1;s:4:\"left\";i:1;}s:9:\"useShadow\";b:0;s:11:\"shadowColor\";s:15:\"rgba(0,0,0,0.5)\";s:16:\"shadowProperties\";a:3:{s:4:\"blur\";i:5;s:5:\"width\";i:0;s:6:\"height\";i:0;}s:14:\"useShadowHover\";b:0;s:16:\"shadowColorHover\";s:15:\"rgba(0,0,0,0.5)\";s:21:\"shadowPropertiesHover\";a:3:{s:4:\"blur\";i:5;s:5:\"width\";i:0;s:6:\"height\";i:0;}s:4:\"type\";s:7:\"outline\";s:10:\"background\";s:0:\"\";s:15:\"backgroundHover\";s:0:\"\";s:4:\"text\";s:0:\"\";s:9:\"textHover\";s:0:\"\";}s:32:\"hfg_header_layout_top_background\";a:8:{s:4:\"type\";s:5:\"color\";s:10:\"colorValue\";s:7:\"#f0f0f0\";s:8:\"imageUrl\";s:0:\"\";s:10:\"focusPoint\";a:2:{s:1:\"x\";d:0.5;s:1:\"y\";d:0.5;}s:17:\"overlayColorValue\";s:0:\"\";s:14:\"overlayOpacity\";i:50;s:5:\"fixed\";b:0;s:11:\"useFeatured\";b:0;}s:33:\"hfg_header_layout_main_background\";a:8:{s:4:\"type\";s:5:\"color\";s:8:\"imageUrl\";s:0:\"\";s:10:\"focusPoint\";a:2:{s:1:\"x\";d:0.5;s:1:\"y\";d:0.5;}s:10:\"colorValue\";s:26:\"var(--nv-secondary-accent)\";s:17:\"overlayColorValue\";s:0:\"\";s:14:\"overlayOpacity\";i:50;s:5:\"fixed\";b:0;s:11:\"useFeatured\";b:0;}s:35:\"hfg_header_layout_bottom_background\";a:8:{s:4:\"type\";s:5:\"color\";s:10:\"colorValue\";s:7:\"#ffffff\";s:8:\"imageUrl\";s:0:\"\";s:10:\"focusPoint\";a:2:{s:1:\"x\";d:0.5;s:1:\"y\";d:0.5;}s:17:\"overlayColorValue\";s:0:\"\";s:14:\"overlayOpacity\";i:50;s:5:\"fixed\";b:0;s:11:\"useFeatured\";b:0;}s:36:\"hfg_header_layout_sidebar_background\";a:8:{s:4:\"type\";s:5:\"color\";s:8:\"imageUrl\";s:0:\"\";s:10:\"focusPoint\";a:2:{s:1:\"x\";d:0.5;s:1:\"y\";d:0.5;}s:10:\"colorValue\";s:17:\"var(--nv-site-bg)\";s:17:\"overlayColorValue\";s:0:\"\";s:14:\"overlayOpacity\";i:50;s:5:\"fixed\";b:0;s:11:\"useFeatured\";b:0;}s:32:\"hfg_footer_layout_top_background\";a:8:{s:4:\"type\";s:5:\"color\";s:8:\"imageUrl\";s:0:\"\";s:10:\"focusPoint\";a:2:{s:1:\"x\";s:4:\"0.89\";s:1:\"y\";s:4:\"0.36\";}s:10:\"colorValue\";s:7:\"#004080\";s:17:\"overlayColorValue\";s:7:\"#8b7de6\";s:14:\"overlayOpacity\";i:50;s:5:\"fixed\";b:0;s:11:\"useFeatured\";b:1;}s:35:\"hfg_footer_layout_bottom_background\";a:8:{s:4:\"type\";s:5:\"color\";s:8:\"imageUrl\";s:0:\"\";s:10:\"focusPoint\";a:2:{s:1:\"x\";d:0.5;s:1:\"y\";d:0.5;}s:10:\"colorValue\";s:16:\"rgba(51,51,51,0)\";s:17:\"overlayColorValue\";s:0:\"\";s:14:\"overlayOpacity\";i:50;s:5:\"fixed\";b:0;s:11:\"useFeatured\";b:0;}s:24:\"neve_blog_archive_layout\";s:4:\"grid\";s:32:\"neve_blog_archive_sidebar_layout\";s:10:\"full-width\";s:31:\"neve_blog_archive_content_width\";i:100;s:21:\"neve_body_font_family\";s:10:\"Montserrat\";s:25:\"neve_headings_font_family\";s:0:\"\";s:22:\"neve_button_appearance\";a:13:{s:12:\"borderRadius\";a:4:{s:3:\"top\";s:1:\"4\";s:5:\"right\";s:1:\"4\";s:6:\"bottom\";s:1:\"4\";s:4:\"left\";s:1:\"4\";}s:11:\"borderWidth\";a:4:{s:3:\"top\";i:1;s:5:\"right\";i:1;s:6:\"bottom\";i:1;s:4:\"left\";i:1;}s:9:\"useShadow\";b:0;s:11:\"shadowColor\";s:15:\"rgba(0,0,0,0.5)\";s:16:\"shadowProperties\";a:3:{s:4:\"blur\";i:5;s:5:\"width\";i:0;s:6:\"height\";i:0;}s:14:\"useShadowHover\";b:0;s:16:\"shadowColorHover\";s:15:\"rgba(0,0,0,0.5)\";s:21:\"shadowPropertiesHover\";a:3:{s:4:\"blur\";i:5;s:5:\"width\";i:0;s:6:\"height\";i:0;}s:4:\"type\";s:4:\"fill\";s:10:\"background\";s:24:\"var(--nv-primary-accent)\";s:15:\"backgroundHover\";s:26:\"var(--nv-secondary-accent)\";s:4:\"text\";s:7:\"#fefefe\";s:9:\"textHover\";s:7:\"#ffffff\";}s:24:\"neve_h1_typeface_general\";a:6:{s:10:\"fontWeight\";s:3:\"600\";s:13:\"textTransform\";s:4:\"none\";s:13:\"letterSpacing\";a:3:{s:6:\"mobile\";i:0;s:6:\"tablet\";i:0;s:7:\"desktop\";i:0;}s:10:\"lineHeight\";a:4:{s:6:\"mobile\";s:3:\"1.2\";s:6:\"tablet\";s:3:\"1.3\";s:7:\"desktop\";s:3:\"1.3\";s:6:\"suffix\";a:3:{s:6:\"mobile\";s:2:\"em\";s:6:\"tablet\";s:2:\"em\";s:7:\"desktop\";s:2:\"em\";}}s:8:\"fontSize\";a:4:{s:6:\"mobile\";s:2:\"39\";s:6:\"tablet\";s:2:\"55\";s:7:\"desktop\";i:70;s:6:\"suffix\";a:3:{s:6:\"mobile\";s:2:\"px\";s:6:\"tablet\";s:2:\"px\";s:7:\"desktop\";s:2:\"px\";}}s:4:\"flag\";b:1;}s:20:\"neve_container_width\";s:42:\"{\"mobile\":748,\"tablet\":992,\"desktop\":1127}\";s:28:\"neve_default_container_style\";s:9:\"contained\";s:24:\"neve_h3_typeface_general\";a:6:{s:10:\"fontWeight\";s:3:\"600\";s:13:\"textTransform\";s:4:\"none\";s:13:\"letterSpacing\";a:3:{s:6:\"mobile\";i:0;s:6:\"tablet\";i:0;s:7:\"desktop\";i:0;}s:10:\"lineHeight\";a:4:{s:6:\"mobile\";s:3:\"1.3\";s:6:\"tablet\";s:3:\"1.3\";s:7:\"desktop\";s:3:\"1.3\";s:6:\"suffix\";a:3:{s:6:\"mobile\";s:2:\"em\";s:6:\"tablet\";s:2:\"em\";s:7:\"desktop\";s:2:\"em\";}}s:8:\"fontSize\";a:4:{s:6:\"mobile\";s:2:\"20\";s:6:\"tablet\";s:2:\"20\";s:7:\"desktop\";s:2:\"24\";s:6:\"suffix\";a:3:{s:6:\"mobile\";s:2:\"px\";s:6:\"tablet\";s:2:\"px\";s:7:\"desktop\";s:2:\"px\";}}s:4:\"flag\";b:0;}s:31:\"neve_other_pages_sidebar_layout\";s:10:\"full-width\";s:30:\"neve_single_post_content_width\";i:70;s:30:\"neve_other_pages_content_width\";i:100;s:18:\"primary-menu_color\";s:22:\"rgba(242,236,236,0.95)\";s:25:\"primary-menu_active_color\";s:22:\"rgba(220,102,255,0.89)\";s:24:\"primary-menu_hover_color\";s:7:\"#751271\";s:31:\"primary-menu_component_typeface\";a:5:{s:8:\"fontSize\";a:4:{s:6:\"suffix\";a:3:{s:6:\"mobile\";s:2:\"em\";s:6:\"tablet\";s:2:\"em\";s:7:\"desktop\";s:2:\"em\";}s:6:\"mobile\";i:1;s:6:\"tablet\";i:1;s:7:\"desktop\";d:0.8;}s:10:\"lineHeight\";a:4:{s:6:\"mobile\";d:1.6;s:6:\"tablet\";d:1.6;s:7:\"desktop\";d:1.6;s:6:\"suffix\";a:3:{s:6:\"mobile\";s:2:\"em\";s:6:\"tablet\";s:2:\"em\";s:7:\"desktop\";s:2:\"em\";}}s:13:\"letterSpacing\";a:3:{s:6:\"mobile\";i:0;s:6:\"tablet\";i:0;s:7:\"desktop\";i:0;}s:10:\"fontWeight\";s:3:\"600\";s:13:\"textTransform\";s:9:\"uppercase\";}s:32:\"neve_secondary_button_appearance\";a:13:{s:12:\"borderRadius\";a:4:{s:3:\"top\";s:1:\"4\";s:5:\"right\";s:1:\"4\";s:6:\"bottom\";s:1:\"4\";s:4:\"left\";s:1:\"4\";}s:11:\"borderWidth\";a:4:{s:3:\"top\";s:1:\"2\";s:5:\"right\";s:1:\"2\";s:6:\"bottom\";s:1:\"2\";s:4:\"left\";s:1:\"2\";}s:9:\"useShadow\";b:0;s:11:\"shadowColor\";s:15:\"rgba(0,0,0,0.5)\";s:16:\"shadowProperties\";a:3:{s:4:\"blur\";i:5;s:5:\"width\";i:0;s:6:\"height\";i:0;}s:14:\"useShadowHover\";b:0;s:16:\"shadowColorHover\";s:15:\"rgba(0,0,0,0.5)\";s:21:\"shadowPropertiesHover\";a:3:{s:4:\"blur\";i:5;s:5:\"width\";i:0;s:6:\"height\";i:0;}s:4:\"type\";s:7:\"outline\";s:10:\"background\";s:16:\"rgba(0, 0, 0, 0)\";s:15:\"backgroundHover\";s:26:\"var(--nv-secondary-accent)\";s:4:\"text\";s:24:\"var(--nv-primary-accent)\";s:9:\"textHover\";s:22:\"var(--nv-text-dark-bg)\";}s:14:\"logo_max_width\";s:65:\"{\"mobile\":32,\"tablet\":32,\"desktop\":350,\"suffix\":{\"desktop\":\"px\"}}\";s:19:\"neve_button_padding\";a:6:{s:6:\"mobile\";a:4:{s:3:\"top\";s:2:\"12\";s:5:\"right\";s:2:\"24\";s:6:\"bottom\";s:2:\"12\";s:4:\"left\";s:2:\"24\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:2:\"12\";s:5:\"right\";s:2:\"24\";s:6:\"bottom\";s:2:\"12\";s:4:\"left\";s:2:\"24\";}s:7:\"desktop\";a:4:{s:3:\"top\";s:2:\"12\";s:5:\"right\";s:2:\"24\";s:6:\"bottom\";s:2:\"12\";s:4:\"left\";s:2:\"24\";}s:11:\"mobile-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:12:\"desktop-unit\";s:2:\"px\";}s:24:\"neve_h4_typeface_general\";a:6:{s:10:\"fontWeight\";s:3:\"600\";s:13:\"textTransform\";s:4:\"none\";s:13:\"letterSpacing\";a:3:{s:6:\"mobile\";i:0;s:6:\"tablet\";i:0;s:7:\"desktop\";i:0;}s:10:\"lineHeight\";a:4:{s:6:\"mobile\";s:3:\"1.3\";s:6:\"tablet\";s:3:\"1.3\";s:7:\"desktop\";s:3:\"1.3\";s:6:\"suffix\";a:3:{s:6:\"mobile\";s:2:\"em\";s:6:\"tablet\";s:2:\"em\";s:7:\"desktop\";s:2:\"em\";}}s:8:\"fontSize\";a:4:{s:6:\"mobile\";s:2:\"16\";s:6:\"tablet\";s:2:\"16\";s:7:\"desktop\";s:2:\"20\";s:6:\"suffix\";a:3:{s:6:\"mobile\";s:2:\"px\";s:6:\"tablet\";s:2:\"px\";s:7:\"desktop\";s:2:\"px\";}}s:4:\"flag\";b:0;}s:24:\"neve_h5_typeface_general\";a:6:{s:10:\"fontWeight\";s:3:\"600\";s:13:\"textTransform\";s:4:\"none\";s:13:\"letterSpacing\";a:3:{s:6:\"mobile\";i:0;s:6:\"tablet\";i:0;s:7:\"desktop\";i:0;}s:10:\"lineHeight\";a:4:{s:6:\"mobile\";s:3:\"1.3\";s:6:\"tablet\";s:3:\"1.3\";s:7:\"desktop\";s:3:\"1.3\";s:6:\"suffix\";a:3:{s:6:\"mobile\";s:2:\"em\";s:6:\"tablet\";s:2:\"em\";s:7:\"desktop\";s:2:\"em\";}}s:8:\"fontSize\";a:4:{s:6:\"mobile\";s:2:\"14\";s:6:\"tablet\";s:2:\"14\";s:7:\"desktop\";s:2:\"16\";s:6:\"suffix\";a:3:{s:6:\"mobile\";s:2:\"px\";s:6:\"tablet\";s:2:\"px\";s:7:\"desktop\";s:2:\"px\";}}s:4:\"flag\";b:0;}s:24:\"neve_h6_typeface_general\";a:6:{s:10:\"fontWeight\";s:3:\"600\";s:13:\"textTransform\";s:4:\"none\";s:13:\"letterSpacing\";a:3:{s:6:\"mobile\";i:0;s:6:\"tablet\";i:0;s:7:\"desktop\";i:0;}s:10:\"lineHeight\";a:4:{s:6:\"mobile\";s:3:\"1.3\";s:6:\"tablet\";s:3:\"1.3\";s:7:\"desktop\";s:3:\"1.3\";s:6:\"suffix\";a:3:{s:6:\"mobile\";s:2:\"em\";s:6:\"tablet\";s:2:\"em\";s:7:\"desktop\";s:2:\"em\";}}s:8:\"fontSize\";a:4:{s:6:\"mobile\";s:2:\"14\";s:6:\"tablet\";s:2:\"14\";s:7:\"desktop\";s:2:\"16\";s:6:\"suffix\";a:3:{s:6:\"mobile\";s:2:\"px\";s:6:\"tablet\";s:2:\"px\";s:7:\"desktop\";s:2:\"px\";}}s:4:\"flag\";b:0;}s:18:\"neve_global_colors\";a:2:{s:13:\"activePalette\";s:4:\"base\";s:8:\"palettes\";a:4:{s:4:\"base\";a:3:{s:4:\"name\";s:4:\"Base\";s:13:\"allowDeletion\";b:0;s:6:\"colors\";a:9:{s:17:\"nv-primary-accent\";s:7:\"#5e82a6\";s:19:\"nv-secondary-accent\";s:7:\"#0057ad\";s:10:\"nv-site-bg\";s:7:\"#ffffff\";s:11:\"nv-light-bg\";s:7:\"#f8f8f8\";s:10:\"nv-dark-bg\";s:7:\"#0d1821\";s:13:\"nv-text-color\";s:7:\"#2c2c2c\";s:15:\"nv-text-dark-bg\";s:7:\"#ffffff\";s:6:\"nv-c-1\";s:7:\"#77b978\";s:6:\"nv-c-2\";s:7:\"#f37262\";}}s:8:\"darkMode\";a:3:{s:4:\"name\";s:11:\"Mode sombre\";s:13:\"allowDeletion\";b:0;s:6:\"colors\";a:9:{s:17:\"nv-primary-accent\";s:7:\"#0065cb\";s:19:\"nv-secondary-accent\";s:7:\"#0057ad\";s:10:\"nv-site-bg\";s:7:\"#0d1821\";s:11:\"nv-light-bg\";s:7:\"#14232f\";s:10:\"nv-dark-bg\";s:7:\"#070e13\";s:13:\"nv-text-color\";s:7:\"#ffffff\";s:15:\"nv-text-dark-bg\";s:7:\"#ffffff\";s:6:\"nv-c-1\";s:7:\"#77b978\";s:6:\"nv-c-2\";s:7:\"#f37262\";}}s:7:\"eastBay\";a:3:{s:4:\"name\";s:14:\"Baie orientale\";s:13:\"allowDeletion\";b:1;s:6:\"colors\";a:9:{s:17:\"nv-primary-accent\";s:7:\"#4b547d\";s:19:\"nv-secondary-accent\";s:7:\"#3f4669\";s:10:\"nv-site-bg\";s:7:\"#ffffff\";s:11:\"nv-light-bg\";s:7:\"#c6caed\";s:10:\"nv-dark-bg\";s:7:\"#000500\";s:13:\"nv-text-color\";s:7:\"#121212\";s:15:\"nv-text-dark-bg\";s:7:\"#ffffff\";s:6:\"nv-c-1\";s:7:\"#77b978\";s:6:\"nv-c-2\";s:7:\"#f37262\";}}s:5:\"green\";a:3:{s:4:\"name\";s:4:\"Vert\";s:13:\"allowDeletion\";b:1;s:6:\"colors\";a:9:{s:17:\"nv-primary-accent\";s:7:\"#04724d\";s:19:\"nv-secondary-accent\";s:7:\"#04583c\";s:10:\"nv-site-bg\";s:7:\"#ffffff\";s:11:\"nv-light-bg\";s:7:\"#f1f0ea\";s:10:\"nv-dark-bg\";s:7:\"#0d1821\";s:13:\"nv-text-color\";s:7:\"#2c2c2c\";s:15:\"nv-text-dark-bg\";s:7:\"#ffffff\";s:6:\"nv-c-1\";s:7:\"#77b978\";s:6:\"nv-c-2\";s:7:\"#f37262\";}}}}s:39:\"hfg_footer_layout_bottom_new_text_color\";s:22:\"var(--nv-text-dark-bg)\";s:12:\"logo_display\";s:12:\"logoTopTitle\";s:20:\"neve_button_typeface\";a:4:{s:8:\"fontSize\";a:4:{s:6:\"suffix\";a:3:{s:6:\"mobile\";s:2:\"px\";s:6:\"tablet\";s:2:\"px\";s:7:\"desktop\";s:2:\"px\";}s:6:\"mobile\";s:2:\"14\";s:6:\"tablet\";s:2:\"14\";s:7:\"desktop\";s:2:\"18\";}s:4:\"flag\";b:0;s:10:\"lineHeight\";a:4:{s:6:\"suffix\";a:3:{s:6:\"mobile\";s:2:\"em\";s:6:\"tablet\";s:2:\"em\";s:7:\"desktop\";s:2:\"em\";}s:6:\"mobile\";d:1.6;s:6:\"tablet\";d:1.6;s:7:\"desktop\";d:1.6;}s:13:\"textTransform\";s:10:\"capitalize\";}s:25:\"neve_fallback_font_family\";s:28:\"Arial, Helvetica, sans-serif\";s:24:\"neve_form_fields_padding\";a:5:{s:3:\"top\";s:2:\"10\";s:6:\"bottom\";i:10;s:4:\"left\";i:12;s:5:\"right\";i:12;s:4:\"unit\";s:2:\"px\";}s:21:\"neve_form_button_type\";s:7:\"primary\";s:30:\"neve_form_fields_border_radius\";a:5:{s:3:\"top\";s:1:\"0\";s:5:\"right\";s:1:\"0\";s:4:\"left\";s:1:\"0\";s:6:\"bottom\";s:1:\"0\";s:4:\"unit\";s:2:\"px\";}s:38:\"neve_single_post_typography_post_title\";a:3:{s:8:\"fontSize\";a:4:{s:6:\"suffix\";a:3:{s:6:\"mobile\";s:2:\"px\";s:6:\"tablet\";s:2:\"px\";s:7:\"desktop\";s:2:\"px\";}s:6:\"mobile\";s:2:\"28\";s:6:\"tablet\";s:2:\"40\";s:7:\"desktop\";s:2:\"65\";}s:4:\"flag\";b:1;s:10:\"lineHeight\";a:4:{s:6:\"suffix\";a:3:{s:6:\"mobile\";s:2:\"em\";s:6:\"tablet\";s:2:\"em\";s:7:\"desktop\";s:2:\"em\";}s:6:\"mobile\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:7:\"desktop\";s:0:\"\";}}s:20:\"hfg_footer_layout_v2\";s:503:\"{\"desktop\":{\"top\":{\"left\":[{\"id\":\"footer-three-widgets\"}],\"c-left\":[],\"center\":[],\"c-right\":[],\"right\":[]},\"main\":{\"left\":[],\"c-left\":[],\"center\":[],\"c-right\":[],\"right\":[]},\"bottom\":{\"left\":[],\"c-left\":[],\"center\":[],\"c-right\":[],\"right\":[]}},\"mobile\":{\"top\":{\"left\":[],\"c-left\":[],\"center\":[],\"c-right\":[],\"right\":[]},\"main\":{\"left\":[],\"c-left\":[],\"center\":[],\"c-right\":[],\"right\":[]},\"bottom\":{\"left\":[],\"c-left\":[{\"id\":\"footer_copyright\"},{\"id\":\"footer-menu\"}],\"center\":[],\"c-right\":[],\"right\":[]}}}\";s:33:\"neve_form_fields_background_color\";s:17:\"var(--nv-site-bg)\";s:22:\"neve_post_cover_height\";s:93:\"{\"mobile\":250,\"tablet\":30,\"desktop\":50,\"suffix\":{\"tablet\":\"vh\",\"desktop\":\"vh\",\"mobile\":\"px\"}}\";s:25:\"neve_post_title_alignment\";a:3:{s:6:\"mobile\";s:4:\"left\";s:6:\"tablet\";s:4:\"left\";s:7:\"desktop\";s:4:\"left\";}s:26:\"neve_post_cover_text_color\";s:22:\"var(--nv-text-dark-bg)\";s:34:\"neve_post_cover_title_boxed_layout\";b:0;s:44:\"neve_post_cover_title_boxed_background_color\";s:17:\"var(--nv-dark-bg)\";s:19:\"neve_enable_masonry\";b:0;s:18:\"primary-menu_style\";s:11:\"style-plain\";s:32:\"neve_post_cover_background_color\";s:26:\"var(--nv-secondary-accent)\";s:23:\"neve_post_cover_padding\";a:6:{s:6:\"mobile\";a:4:{s:3:\"top\";i:40;s:5:\"right\";i:15;s:6:\"bottom\";i:40;s:4:\"left\";i:15;}s:6:\"tablet\";a:4:{s:3:\"top\";i:60;s:5:\"right\";i:30;s:6:\"bottom\";i:60;s:4:\"left\";i:30;}s:7:\"desktop\";a:4:{s:3:\"top\";i:60;s:5:\"right\";i:40;s:6:\"bottom\";s:2:\"60\";s:4:\"left\";i:40;}s:11:\"mobile-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:12:\"desktop-unit\";s:2:\"px\";}s:31:\"neve_post_cover_overlay_opacity\";d:80;s:25:\"neve_post_cover_container\";s:9:\"contained\";s:35:\"neve_post_cover_title_boxed_padding\";a:6:{s:6:\"mobile\";a:4:{s:3:\"top\";i:40;s:5:\"right\";i:15;s:6:\"bottom\";i:40;s:4:\"left\";i:15;}s:6:\"tablet\";a:4:{s:3:\"top\";i:60;s:5:\"right\";i:30;s:6:\"bottom\";i:60;s:4:\"left\";i:30;}s:7:\"desktop\";a:4:{s:3:\"top\";i:60;s:5:\"right\";i:40;s:6:\"bottom\";s:2:\"60\";s:4:\"left\";i:40;}s:11:\"mobile-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:12:\"desktop-unit\";s:2:\"px\";}s:29:\"neve_form_fields_border_width\";a:5:{s:3:\"top\";s:1:\"2\";s:5:\"right\";s:1:\"2\";s:4:\"left\";s:1:\"2\";s:6:\"bottom\";s:1:\"2\";s:4:\"unit\";s:2:\"px\";}s:29:\"neve_form_fields_border_color\";s:18:\"var(--nv-light-bg)\";s:21:\"neve_input_text_color\";s:20:\"var(--nv-text-color)\";s:27:\"footer-menu_component_align\";a:3:{s:7:\"desktop\";s:5:\"right\";s:6:\"tablet\";s:4:\"left\";s:6:\"mobile\";s:4:\"left\";}s:39:\"hfg_footer_layout_bottom_columns_number\";i:1;s:10:\"logo_color\";s:7:\"#f2efef\";s:26:\"neve_blog_post_meta_fields\";s:383:\"[{\"slug\":\"author\",\"title\":\"Auteur\\/autrice\",\"visibility\":\"yes\",\"hide_on_mobile\":\"\",\"blocked\":\"yes\"},{\"slug\":\"comments\",\"title\":\"Commentaires\",\"visibility\":\"yes\",\"hide_on_mobile\":\"\",\"blocked\":\"yes\"},{\"slug\":\"category\",\"title\":\"Cat\\u00e9gorie\",\"visibility\":\"yes\",\"hide_on_mobile\":\"\",\"blocked\":\"yes\"},{\"slug\":\"date\",\"title\":\"Date\",\"visibility\":\"no\",\"hide_on_mobile\":\"\",\"blocked\":\"yes\"}]\";s:29:\"neve_blog_items_border_radius\";d:8;s:25:\"neve_blog_content_padding\";a:6:{s:6:\"mobile\";a:4:{s:3:\"top\";i:25;s:5:\"right\";i:25;s:6:\"bottom\";i:25;s:4:\"left\";i:25;}s:6:\"tablet\";a:4:{s:3:\"top\";i:25;s:5:\"right\";i:25;s:6:\"bottom\";i:25;s:4:\"left\";i:25;}s:7:\"desktop\";a:4:{s:3:\"top\";i:25;s:5:\"right\";i:25;s:6:\"bottom\";i:25;s:4:\"left\";i:25;}s:11:\"mobile-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:12:\"desktop-unit\";s:2:\"px\";}s:22:\"neve_enable_card_style\";b:1;s:28:\"neve_blog_grid_card_bg_color\";s:17:\"var(--nv-site-bg)\";s:25:\"neve_blog_grid_text_color\";s:20:\"var(--nv-text-color)\";s:21:\"neve_blog_card_shadow\";d:0.5;s:30:\"neve_blog_archive_aspect_ratio\";s:3:\"4-3\";s:24:\"neve_post_excerpt_length\";i:35;s:38:\"neve_layout_single_post_elements_order\";s:42:\"[\"title-meta\",\"content\",\"tags\",\"comments\"]\";s:31:\"neve_single_post_sidebar_layout\";s:10:\"full-width\";s:23:\"neve_archive_hide_title\";b:1;s:29:\"hfg_header_layout_main_layout\";s:16:\"layout-fullwidth\";s:29:\"hfg_header_layout_main_height\";s:37:\"{\"mobile\":0,\"tablet\":0,\"desktop\":262}\";s:36:\"hfg_header_layout_main_bottom_border\";s:35:\"{\"mobile\":0,\"tablet\":0,\"desktop\":1}\";s:20:\"neve_page_hide_title\";b:0;s:39:\"hfg_footer_layout_bottom_columns_layout\";s:5:\"equal\";s:39:\"hfg_footer_layout_bottom_vertical_align\";s:6:\"center\";s:36:\"hfg_footer_layout_top_columns_layout\";s:10:\"right-half\";s:36:\"footer-three-widgets_component_align\";a:3:{s:7:\"desktop\";s:4:\"left\";s:6:\"tablet\";s:4:\"left\";s:6:\"mobile\";s:4:\"left\";}s:34:\"hfg_footer_layout_top_border_color\";s:7:\"#655f94\";s:36:\"hfg_footer_layout_top_new_text_color\";s:17:\"var(--nv-site-bg)\";s:28:\"hfg_header_layout_top_layout\";s:16:\"layout-contained\";s:25:\"neve_page_title_alignment\";a:3:{s:6:\"mobile\";s:4:\"left\";s:6:\"tablet\";s:4:\"left\";s:7:\"desktop\";s:6:\"center\";}s:20:\"logo_component_align\";a:3:{s:6:\"mobile\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:7:\"desktop\";s:6:\"center\";}s:20:\"hfg_header_layout_v2\";s:609:\"{\"desktop\":{\"top\":{\"left\":[],\"c-left\":[],\"center\":[],\"c-right\":[],\"right\":[]},\"main\":{\"left\":[{\"id\":\"logo\"}],\"c-left\":[],\"center\":[{\"id\":\"primary-menu\"}],\"c-right\":[],\"right\":[{\"id\":\"button_base\"}]},\"bottom\":{\"left\":[{\"id\":\"header_search\"}],\"c-left\":[],\"center\":[{\"id\":\"custom_html\"}],\"c-right\":[],\"right\":[]}},\"mobile\":{\"top\":{\"left\":[],\"c-left\":[],\"center\":[],\"c-right\":[],\"right\":[]},\"main\":{\"left\":[{\"id\":\"logo\"}],\"c-left\":[],\"center\":[],\"c-right\":[],\"right\":[{\"id\":\"nav-icon\"}]},\"bottom\":{\"left\":[],\"c-left\":[],\"center\":[],\"c-right\":[],\"right\":[]},\"sidebar\":[{\"id\":\"primary-menu\"},{\"id\":\"button_base\"}]}}\";s:36:\"header_search_responsive_placeholder\";s:6:\"bouton\";s:23:\"neve_page_header_layout\";s:6:\"normal\";s:24:\"button_base_text_setting\";s:12:\"Se connecter\";s:19:\"button_base_new_tab\";i:1;s:25:\"button_base_style_setting\";a:10:{s:12:\"borderRadius\";a:4:{s:3:\"top\";i:3;s:5:\"right\";i:3;s:6:\"bottom\";i:3;s:4:\"left\";i:3;}s:11:\"borderWidth\";a:4:{s:3:\"top\";i:1;s:5:\"right\";i:1;s:6:\"bottom\";i:1;s:4:\"left\";i:1;}s:9:\"useShadow\";b:0;s:11:\"shadowColor\";s:22:\"rgba(92, 66, 66, 0.21)\";s:16:\"shadowProperties\";a:3:{s:4:\"blur\";i:0;s:5:\"width\";i:0;s:6:\"height\";i:0;}s:14:\"useShadowHover\";b:0;s:16:\"shadowColorHover\";s:15:\"rgba(0,0,0,0.5)\";s:21:\"shadowPropertiesHover\";a:3:{s:4:\"blur\";i:5;s:5:\"width\";i:0;s:6:\"height\";i:0;}s:4:\"type\";s:4:\"fill\";s:10:\"background\";s:7:\"#ed7428\";}s:34:\"header_search_responsive_open_type\";s:6:\"canvas\";s:34:\"header_search_responsive_icon_size\";i:20;s:37:\"header_search_responsive_field_height\";s:38:\"{\"mobile\":40,\"tablet\":40,\"desktop\":56}\";s:40:\"header_search_responsive_field_text_size\";s:38:\"{\"mobile\":14,\"tablet\":14,\"desktop\":28}\";s:43:\"header_search_responsive_field_border_width\";a:6:{s:6:\"mobile\";a:4:{s:3:\"top\";i:2;s:5:\"right\";i:2;s:6:\"bottom\";i:2;s:4:\"left\";i:2;}s:6:\"tablet\";a:4:{s:3:\"top\";i:2;s:5:\"right\";i:2;s:6:\"bottom\";i:2;s:4:\"left\";i:2;}s:7:\"desktop\";a:4:{s:3:\"top\";s:1:\"4\";s:5:\"right\";s:1:\"4\";s:6:\"bottom\";s:1:\"4\";s:4:\"left\";s:1:\"4\";}s:11:\"mobile-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:12:\"desktop-unit\";s:2:\"px\";}s:41:\"header_search_responsive_field_background\";s:7:\"#191717\";s:34:\"header_search_responsive_icon_type\";s:17:\"hfgs-icon-style-3\";s:44:\"header_search_responsive_field_border_radius\";a:6:{s:6:\"mobile\";a:4:{s:3:\"top\";i:2;s:5:\"right\";i:2;s:6:\"bottom\";i:2;s:4:\"left\";i:2;}s:6:\"tablet\";a:4:{s:3:\"top\";i:2;s:5:\"right\";i:2;s:6:\"bottom\";i:2;s:4:\"left\";i:2;}s:7:\"desktop\";a:4:{s:3:\"top\";s:1:\"0\";s:5:\"right\";s:1:\"0\";s:6:\"bottom\";s:1:\"0\";s:4:\"left\";s:1:\"0\";}s:11:\"mobile-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:12:\"desktop-unit\";s:2:\"px\";}s:29:\"button_base_component_padding\";a:6:{s:6:\"mobile\";a:4:{s:3:\"top\";i:8;s:5:\"right\";i:12;s:6:\"bottom\";i:8;s:4:\"left\";i:12;}s:6:\"tablet\";a:4:{s:3:\"top\";i:8;s:5:\"right\";i:12;s:6:\"bottom\";i:8;s:4:\"left\";i:12;}s:7:\"desktop\";a:4:{s:3:\"top\";s:1:\"0\";s:5:\"right\";s:1:\"7\";s:6:\"bottom\";s:1:\"0\";s:4:\"left\";s:1:\"4\";}s:11:\"mobile-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:12:\"desktop-unit\";s:2:\"px\";}s:19:\"custom_html_content\";s:0:\"\";s:28:\"hfg_footer_layout_top_layout\";s:21:\"layout-full-contained\";s:38:\"footer-three-widgets_component_padding\";a:6:{s:6:\"mobile\";a:4:{s:3:\"top\";i:0;s:5:\"right\";i:0;s:6:\"bottom\";i:0;s:4:\"left\";i:0;}s:6:\"tablet\";a:4:{s:3:\"top\";i:0;s:5:\"right\";i:0;s:6:\"bottom\";i:0;s:4:\"left\";i:0;}s:7:\"desktop\";a:4:{s:3:\"top\";s:1:\"9\";s:5:\"right\";s:1:\"9\";s:6:\"bottom\";s:1:\"9\";s:4:\"left\";s:1:\"9\";}s:11:\"mobile-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:12:\"desktop-unit\";s:2:\"px\";}s:37:\"footer-three-widgets_component_margin\";a:6:{s:6:\"mobile\";a:4:{s:3:\"top\";i:0;s:5:\"right\";i:0;s:6:\"bottom\";i:0;s:4:\"left\";i:0;}s:6:\"tablet\";a:4:{s:3:\"top\";i:0;s:5:\"right\";i:0;s:6:\"bottom\";i:0;s:4:\"left\";i:0;}s:7:\"desktop\";a:4:{s:3:\"top\";s:2:\"-6\";s:5:\"right\";s:2:\"-6\";s:6:\"bottom\";s:2:\"-6\";s:4:\"left\";s:2:\"-6\";}s:11:\"mobile-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:12:\"desktop-unit\";s:2:\"px\";}s:28:\"hfg_footer_layout_top_height\";s:37:\"{\"mobile\":0,\"tablet\":0,\"desktop\":223}\";s:35:\"hfg_footer_layout_top_bottom_border\";s:35:\"{\"mobile\":0,\"tablet\":0,\"desktop\":0}\";s:33:\"hfg_footer_layout_main_background\";a:8:{s:4:\"type\";s:5:\"color\";s:8:\"imageUrl\";s:0:\"\";s:10:\"focusPoint\";a:2:{s:1:\"x\";d:0.5;s:1:\"y\";d:0.5;}s:10:\"colorValue\";s:7:\"#007bff\";s:17:\"overlayColorValue\";s:0:\"\";s:14:\"overlayOpacity\";i:50;s:5:\"fixed\";b:0;s:11:\"useFeatured\";b:0;}s:9:\"logo_logo\";s:36:\"{\"light\":603,\"dark\":603,\"same\":true}\";s:20:\"primary-menu_spacing\";s:38:\"{\"mobile\":20,\"tablet\":20,\"desktop\":10}\";s:30:\"primary-menu_component_padding\";a:6:{s:6:\"mobile\";a:4:{s:3:\"top\";i:0;s:5:\"right\";i:0;s:6:\"bottom\";i:0;s:4:\"left\";i:0;}s:6:\"tablet\";a:4:{s:3:\"top\";i:0;s:5:\"right\";i:0;s:6:\"bottom\";i:0;s:4:\"left\";i:0;}s:7:\"desktop\";a:4:{s:3:\"top\";s:2:\"27\";s:5:\"right\";s:2:\"27\";s:6:\"bottom\";s:2:\"27\";s:4:\"left\";s:2:\"27\";}s:11:\"mobile-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:12:\"desktop-unit\";s:2:\"px\";}s:29:\"primary-menu_component_margin\";a:6:{s:6:\"mobile\";a:4:{s:3:\"top\";i:0;s:5:\"right\";i:0;s:6:\"bottom\";i:0;s:4:\"left\";i:0;}s:6:\"tablet\";a:4:{s:3:\"top\";i:0;s:5:\"right\";i:0;s:6:\"bottom\";i:0;s:4:\"left\";i:0;}s:7:\"desktop\";a:4:{s:3:\"top\";s:1:\"0\";s:5:\"right\";s:1:\"0\";s:6:\"bottom\";s:1:\"0\";s:4:\"left\";s:1:\"0\";}s:11:\"mobile-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:12:\"desktop-unit\";s:2:\"px\";}s:24:\"primary-menu_item_height\";s:38:\"{\"mobile\":25,\"tablet\":25,\"desktop\":10}\";s:26:\"header_search_field_height\";s:38:\"{\"mobile\":40,\"tablet\":40,\"desktop\":49}\";s:29:\"header_search_field_text_size\";s:38:\"{\"mobile\":14,\"tablet\":14,\"desktop\":20}\";s:32:\"header_search_field_border_width\";a:6:{s:6:\"mobile\";a:4:{s:3:\"top\";i:2;s:5:\"right\";i:2;s:6:\"bottom\";i:2;s:4:\"left\";i:2;}s:6:\"tablet\";a:4:{s:3:\"top\";i:2;s:5:\"right\";i:2;s:6:\"bottom\";i:2;s:4:\"left\";i:2;}s:7:\"desktop\";a:4:{s:3:\"top\";s:1:\"3\";s:5:\"right\";s:1:\"3\";s:6:\"bottom\";s:1:\"3\";s:4:\"left\";s:1:\"3\";}s:11:\"mobile-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:12:\"desktop-unit\";s:2:\"px\";}s:30:\"header_search_field_text_color\";s:17:\"var(--nv-site-bg)\";s:30:\"header_search_field_background\";s:7:\"#f1610e\";s:23:\"header_search_icon_type\";s:17:\"hfgs-icon-style-4\";s:31:\"header_search_button_appearance\";s:11:\"icon_button\";s:11:\"custom_logo\";i:156;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1746297818;s:4:\"data\";a:7:{s:19:\"wp_inactive_widgets\";a:8:{i:0;s:7:\"block-9\";i:1;s:8:\"block-13\";i:2;s:8:\"block-14\";i:3;s:7:\"block-2\";i:4;s:7:\"block-3\";i:5;s:7:\"block-4\";i:6;s:7:\"block-5\";i:7;s:7:\"block-6\";}s:12:\"blog-sidebar\";a:0:{}s:12:\"shop-sidebar\";a:0:{}s:18:\"footer-one-widgets\";a:0:{}s:18:\"footer-two-widgets\";a:0:{}s:20:\"footer-three-widgets\";a:3:{i:0;s:7:\"block-8\";i:1;s:8:\"block-11\";i:2;s:8:\"block-16\";}s:19:\"footer-four-widgets\";a:0:{}}}}","off"),
("453","neve_user_since","unknown","auto"),
("454","neve_install","1742655321","auto"),
("456","neve_user_check_time","1742655321","auto"),
("457","neve_new_user","yes","auto"),
("459","jpsq_sync-1742655322.707525-907324-3","a:6:{i:0;s:29:\"jetpack_update_plugins_change\";i:1;a:1:{i:0;O:8:\"stdClass\":4:{s:12:\"last_checked\";i:1742655313;s:8:\"response\";a:1:{s:23:\"gutenberg/gutenberg.php\";O:8:\"stdClass\":13:{s:2:\"id\";s:23:\"w.org/plugins/gutenberg\";s:4:\"slug\";s:9:\"gutenberg\";s:6:\"plugin\";s:23:\"gutenberg/gutenberg.php\";s:11:\"new_version\";s:6:\"20.5.0\";s:3:\"url\";s:40:\"https://wordpress.org/plugins/gutenberg/\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/plugin/gutenberg.20.5.0.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:62:\"https://ps.w.org/gutenberg/assets/icon-256x256.jpg?rev=1776042\";s:2:\"1x\";s:62:\"https://ps.w.org/gutenberg/assets/icon-128x128.jpg?rev=1776042\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:65:\"https://ps.w.org/gutenberg/assets/banner-1544x500.jpg?rev=1718710\";s:2:\"1x\";s:64:\"https://ps.w.org/gutenberg/assets/banner-772x250.jpg?rev=1718710\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"6.6\";s:6:\"tested\";s:5:\"6.7.2\";s:12:\"requires_php\";s:3:\"7.2\";s:16:\"requires_plugins\";a:0:{}}}s:12:\"translations\";a:0:{}s:7:\"checked\";a:8:{s:19:\"akismet/akismet.php\";s:5:\"5.3.7\";s:33:\"classic-editor/classic-editor.php\";s:5:\"1.6.7\";s:39:\"crowdsignal-forms/crowdsignal-forms.php\";s:5:\"1.7.2\";s:23:\"polldaddy/polldaddy.php\";s:5:\"3.1.2\";s:23:\"gutenberg/gutenberg.php\";s:6:\"20.0.4\";s:19:\"jetpack/jetpack.php\";s:8:\"14.5-a.6\";s:21:\"layout-grid/index.php\";s:5:\"1.8.4\";s:31:\"page-optimize/page-optimize.php\";s:5:\"0.5.6\";}}}i:2;i:0;i:3;d:1742655322.707407;i:4;b:0;i:5;a:14:{s:13:\"wpcom_user_id\";N;s:16:\"external_user_id\";i:0;s:12:\"display_name\";N;s:10:\"user_email\";N;s:10:\"user_roles\";a:0:{}s:15:\"translated_role\";N;s:7:\"is_cron\";b:1;s:7:\"is_rest\";b:0;s:9:\"is_xmlrpc\";b:0;s:10:\"is_wp_rest\";b:0;s:7:\"is_ajax\";b:0;s:11:\"is_wp_admin\";b:0;s:6:\"is_cli\";b:0;s:8:\"from_url\";s:82:\"https://creakonect.com/wp-cron.php?doing_wp_cron=1742655306.6238820552825927734375\";}}","no"),
("460","jpsq_sync-1742655322.708387-907324-4","a:6:{i:0;s:28:\"jetpack_update_themes_change\";i:1;a:1:{i:0;O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1742655313;s:7:\"checked\";a:2:{s:9:\"cultivate\";s:5:\"0.0.1\";s:15:\"twentytwentytwo\";s:9:\"1.9-wpcom\";}s:8:\"response\";a:1:{s:15:\"twentytwentytwo\";a:7:{s:5:\"theme\";s:15:\"twentytwentytwo\";s:11:\"new_version\";s:3:\"1.9\";s:3:\"url\";s:45:\"https://wordpress.org/themes/twentytwentytwo/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/theme/twentytwentytwo.1.9.zip\";s:8:\"requires\";s:3:\"5.9\";s:12:\"requires_php\";s:3:\"5.6\";s:4:\"name\";s:17:\"Twenty Twenty-Two\";}}s:9:\"no_update\";a:0:{}s:12:\"translations\";a:0:{}}}i:2;i:0;i:3;d:1742655322.708313;i:4;b:0;i:5;a:14:{s:13:\"wpcom_user_id\";N;s:16:\"external_user_id\";i:0;s:12:\"display_name\";N;s:10:\"user_email\";N;s:10:\"user_roles\";a:0:{}s:15:\"translated_role\";N;s:7:\"is_cron\";b:1;s:7:\"is_rest\";b:0;s:9:\"is_xmlrpc\";b:0;s:10:\"is_wp_rest\";b:0;s:7:\"is_ajax\";b:0;s:11:\"is_wp_admin\";b:0;s:6:\"is_cli\";b:0;s:8:\"from_url\";s:82:\"https://creakonect.com/wp-cron.php?doing_wp_cron=1742655306.6238820552825927734375\";}}","no"),
("462","wpcomsh_plugins_considered_for_auto_update","a:24:{i:0;s:23:\"ai-engine/ai-engine.php\";i:1;s:19:\"akismet/akismet.php\";i:2;s:24:\"buddypress/bp-loader.php\";i:3;s:33:\"classic-editor/classic-editor.php\";i:4;s:31:\"cookie-notice/cookie-notice.php\";i:5;s:39:\"crowdsignal-forms/crowdsignal-forms.php\";i:6;s:23:\"polldaddy/polldaddy.php\";i:7;s:25:\"duplicator/duplicator.php\";i:8;s:33:\"duplicator-pro/duplicator-pro.php\";i:9;s:23:\"elementor/elementor.php\";i:10;s:25:\"formidable/formidable.php\";i:11;s:23:\"gutenberg/gutenberg.php\";i:12;s:27:\"optimole-wp/optimole-wp.php\";i:13;s:19:\"jetpack/jetpack.php\";i:14;s:21:\"layout-grid/index.php\";i:15;s:38:\"easy-login-woocommerce/xoo-el-main.php\";i:16;s:31:\"page-optimize/page-optimize.php\";i:17;s:51:\"header-footer-elementor/header-footer-elementor.php\";i:18;s:27:\"updraftplus/updraftplus.php\";i:19;s:35:\"wp-fastest-cache/wpFastestCache.php\";i:20;s:31:\"wp-google-maps/wpGoogleMaps.php\";i:21;s:37:\"wp-store-locator/wp-store-locator.php\";i:22;s:35:\"wp-user-manager/wp-user-manager.php\";i:23;s:24:\"wordpress-seo/wp-seo.php\";}","off"),
("465","jetpack_sync_health_status","a:2:{s:6:\"status\";s:7:\"in_sync\";s:9:\"timestamp\";d:1742655324.459017;}","auto"),
("474","jetpack_protect_error","API Key Required","off"),
("478","do_activate","0","auto"),
("479","jetpack_waf_needs_update","","auto"),
("480","trusted_ip_header","","off"),
("522","wpcomsh_at_managed_plugins","a:8:{i:1;s:19:\"akismet/akismet.php\";i:3;s:33:\"classic-editor/classic-editor.php\";i:5;s:39:\"crowdsignal-forms/crowdsignal-forms.php\";i:6;s:23:\"polldaddy/polldaddy.php\";i:11;s:23:\"gutenberg/gutenberg.php\";i:13;s:19:\"jetpack/jetpack.php\";i:14;s:21:\"layout-grid/index.php\";i:16;s:31:\"page-optimize/page-optimize.php\";}","auto"),
("523","auto_update_plugins","a:16:{i:0;s:23:\"elementor/elementor.php\";i:1;s:27:\"updraftplus/updraftplus.php\";i:2;s:24:\"wordpress-seo/wp-seo.php\";i:3;s:35:\"wp-fastest-cache/wpFastestCache.php\";i:4;s:31:\"cookie-notice/cookie-notice.php\";i:5;s:25:\"formidable/formidable.php\";i:6;s:24:\"buddypress/bp-loader.php\";i:7;s:38:\"easy-login-woocommerce/xoo-el-main.php\";i:8;s:37:\"wp-store-locator/wp-store-locator.php\";i:9;s:31:\"wp-google-maps/wpGoogleMaps.php\";i:10;s:35:\"wp-user-manager/wp-user-manager.php\";i:11;s:51:\"header-footer-elementor/header-footer-elementor.php\";i:12;s:27:\"optimole-wp/optimole-wp.php\";i:13;s:23:\"ai-engine/ai-engine.php\";i:14;s:25:\"duplicator/duplicator.php\";i:15;s:33:\"duplicator-pro/duplicator-pro.php\";}","auto"),
("527","elementor_active_kit","32","auto"),
("528","elementor_font_display","swap","auto"),
("530","elementor_landing_pages_activation","0","auto"),
("531","elementor_version","3.30.4","auto"),
("532","elementor_install_history","a:13:{s:6:\"3.28.0\";i:1742655645;s:6:\"3.28.1\";i:1742745533;s:6:\"3.28.2\";i:1743353089;s:6:\"3.28.3\";i:1743519395;s:6:\"3.28.4\";i:1745333704;s:6:\"3.29.0\";i:1748186668;s:6:\"3.29.1\";i:1748446467;s:6:\"3.29.2\";i:1749050051;s:6:\"3.30.0\";i:1751383831;s:6:\"3.30.1\";i:1751911614;s:6:\"3.30.2\";i:1752074604;s:6:\"3.30.3\";i:1753196106;s:6:\"3.30.4\";i:1753890858;}","auto"),
("534","elementor_checklist","{\"last_opened_timestamp\":1742655728,\"first_closed_checklist_in_editor\":false,\"is_popup_minimized\":false,\"steps\":{\"add_logo\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"set_fonts_and_colors\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"create_pages\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"setup_header\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"assign_homepage\":{\"is_marked_completed\":false,\"is_immutable_completed\":false}},\"should_open_in_editor\":true}","auto"),
("535","elementor_events_db_version","1.0.0","off"),
("536","jetpack_connection_active_plugins","a:1:{s:7:\"jetpack\";a:1:{s:4:\"name\";s:7:\"Jetpack\";}}","auto"),
("537","elementor_onboarded","1","auto"),
("540","_elementor_onboarding_features","a:2:{s:9:\"essential\";a:2:{i:0;s:29:\"Templates &amp; Theme Builder\";i:1;s:34:\"Lead Collection &amp; Form Builder\";}s:8:\"advanced\";a:0:{}}","auto"),
("542","e_editor_counter","317","auto"),
("543","_elementor_installed_time","1742655713","auto"),
("544","_elementor_free_to_pro_upsell","a:2:{s:7:\"timeout\";i:1750013291;s:5:\"value\";s:593:\"[{\"id\":\"animated_headline\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/free-to-pro-upsell\\/v1\\/images\\/animated_headline.jpg\"},{\"id\":\"video_playlist\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/free-to-pro-upsell\\/v1\\/images\\/video_playlist.jpg\"},{\"id\":\"cta\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/free-to-pro-upsell\\/v1\\/images\\/cta.jpg\"},{\"id\":\"testimonial_widget\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/free-to-pro-upsell\\/v1\\/images\\/testimonial_widget.jpg\"},{\"id\":\"image_carousel\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/free-to-pro-upsell\\/v1\\/images\\/image_carousel.jpg\"}]\";}","off"),
("545","_elementor_notifications_data","a:2:{s:7:\"timeout\";i:1750013291;s:5:\"value\";s:12875:\"[{\"id\":\"bd-sale-9\",\"title\":\"Elementor Turns 9 \\u2013 Get Up to 25% Off Pro\",\"description\":\"Need more control, features, and flexibility? Now\\u2019s the best time to upgrade. For a limited time, get Elementor Pro at up to 25% off.\",\"topic\":\"Birthday Sale\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/bd-sale-9.png\",\"chipTags\":[\"Pro\"],\"cta\":\"View Birthday Deals\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-bd-sale-9\\/\",\"conditions\":[[{\"type\":\"plugin\",\"operator\":\"!=\",\"plugin\":\"elementor-pro\\/elementor-pro.php\"}]]},{\"id\":\"cloud-templates-3.29\",\"title\":\"Your Templates, available everywhere\",\"description\":\"Store sections, containers, and full pages in the cloud\\u2014making them accessible across all your Pro-connected sites. Style once, reuse anywhere!\",\"topic\":\"Elementor Pro 3.29\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/cloud-templates.png\",\"chipPlan\":\"Pro\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.29-cloud-templates-blog\\/\",\"readMoreText\":\"Learn More\",\"conditions\":[[{\"type\":\"plugin\",\"plugin\":\"elementor-pro\\/elementor-pro.php\"}]]},{\"id\":\"cloud-templates-3.29\",\"title\":\"Your Templates, available everywhere\",\"description\":\"Store sections, containers, and full pages in the cloud\\u2014making them accessible across all your Pro-connected sites. Style once, reuse anywhere!\",\"topic\":\"Elementor Pro 3.29\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/cloud-templates.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Upgrade\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.29-cloud-templates\\/\"},{\"id\":\"classes-3.29\",\"title\":\"Classes: Style Once, Apply Everywhere\",\"description\":\"Create Classes to define styling patterns once and apply them across your entire site with a single click. Add States for stunning hover and focus effects\\u2014no coding needed!\",\"topic\":\"Editor V4 Alpha\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/v4-classes.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.29-editor-v4\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"send-connect\",\"title\":\"More Integrations, More Impact\",\"description\":\"Discover Send\\u2019s new features: Behavior-based triggers, win-back email campaigns, expanded form integrations, and more! Explore how marketing automation features can boost your store.\",\"topic\":\"Send: Email & SMS built for WooCommerce\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/send-connect.png\",\"chipTags\":[\"New Features\"],\"cta\":\"Check Out\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/newmay\",\"conditions\":[[{\"type\":\"plugin\",\"operator\":\"!=\",\"plugin\":\"send-app\\/send-app.php\"}]]},{\"id\":\"style-tab-3.29\",\"title\":\"Consistent Styling Everywhere\",\"description\":\"Every V4 element shares the same styling capabilities in the same logical order and location. Plus, we\'ve streamlined from 3 tabs to just 2\\u2014content in one, styling in the other!\",\"topic\":\"Editor V4 Alpha\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/v4-style-tab.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.29-editor-v4\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"responsive-3.29\",\"title\":\"Fully Responsive Design\",\"description\":\"With Editor V4, every single style property can be customized per device. Complete creative control for desktop, tablet, and mobile!\",\"topic\":\"Editor V4 Alpha\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/v4-responsive.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.29-editor-v4\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"performance-3.29\",\"title\":\"Blazing fast performance\",\"description\":\"In Editor V4, each element uses one clean div instead of multiple nested divs like in the current version\\u2014your sites will load lightning-fast with cleaner code!\",\"topic\":\"Editor V4 Alpha\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/v4-performance.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.29-editor-v4\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"migration-host\",\"title\":\"Move to Better Cloud Hosting, Painlessly\",\"description\":\"Migrate your Elementor website for free to a home that\\u2019s perfect for it, in minutes, with a combination of\\u2028advanced automation and free expert support\",\"topic\":\"Host\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/migration-host.png\",\"chipTags\":[\"Cloud Hosting\"],\"link\":\"https:\\/\\/go.elementor.com\\/hosting-free-migration\",\"readMoreText\":\"Learn More\",\"cta\":\"Migrate for free\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/hosting-free-migration\"},{\"id\":\"ai-isolate-object\",\"title\":\"Sharper product images, instantly\",\"description\":\"Remove distractions and reframe your shots with the new Isolate Object tool powered by Elementor AI \\u2014 perfect for a polished, uniform Woo storefront.\",\"topic\":\"Elementor AI\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/isolate-object-ai.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/Isolateobjectblog\",\"readMoreText\":\"Learn More\",\"conditions\":[[{\"type\":\"introduction_meta\",\"meta\":\"ai_get_started\"}]],\"cta\":\"Start Free Trial\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/Isolateobjectblog\"},{\"id\":\"ai-isolate-object\",\"title\":\"Sharper product images, instantly\",\"description\":\"Remove distractions and reframe your shots with the new Isolate Object tool powered by Elementor AI \\u2014 perfect for a polished, uniform Woo storefront.\",\"topic\":\"Elementor AI\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/isolate-object-ai.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Start Free Trial\",\"link\":\"https:\\/\\/go.elementor.com\\/Isolateobjectblog\",\"readMoreText\":\"Learn More\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/Isolateobjectblog\"},{\"id\":\"hello-biz-contact\",\"title\":\"New Contact Widget, Visual Layout Presets & more\",\"description\":\"Hello Biz just got an update! Explore the new Contact Widget, Visual Layout Presets, Form Submissions integration, and fresh new kits.\",\"topic\":\"Hello Biz\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/hello-biz-contact.png\",\"chipTags\":[\"New Features\"],\"link\":\"https:\\/\\/go.elementor.com\\/hello-biz-updates\",\"readMoreText\":\"Learn More\"},{\"id\":\"ai-site-planner-colors\",\"title\":\"Style Your Wireframe, Speed Up Your Store Build\",\"description\":\"Site Planner now lets you style your wireframe with fonts and colors - instantly visualizing your site\\u2019s look and feel. Plus, it predesigns pages for WooCommerce like Cart and Checkout, so you can dive straight into customizations\",\"topic\":\"Elementor AI\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/site-planner-colors.png\",\"chipTags\":[\"New Feature\"],\"link\":\"http:\\/\\/www.elementor.com\\/ai-site-planner\",\"readMoreText\":\"Learn More\"},{\"id\":\"ally-notification\",\"title\":\"Just released! Ally - a new plugin for web accessibility & usability\",\"description\":\"Ally simplifies the complexities of making your website more accessible. With new regulations here and coming, making your website more usable and inclusive is no longer just an option, but a must.\",\"topic\":\"Ally by Elementor\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/ally-notification.png\",\"chipTags\":[\"New plugin\"],\"cta\":\"Get it free\",\"ctaLink\":\"https:\\/\\/wordpress.org\\/plugins\\/pojo-accessibility\\/\",\"conditions\":[[{\"type\":\"plugin\",\"operator\":\"!=\",\"plugin\":\"pojo-accessibility\\/pojo-accessibility.php\"}]]},{\"id\":\"send-notification\",\"title\":\"Grow your business with Send: an intuitive platform for Email & SMS, natively built for WooCommerce.\",\"description\":\"Deliver powerful, automated email & SMS campaigns with Send\\u2014built for WooCommerce to help you boost conversions, drive growth, and go beyond just building websites.\",\"topic\":\"Send by Elementor\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/send-notification.png\",\"chipTags\":[\"New plugin\"],\"cta\":\"Explore Send\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/AHSfdh\",\"conditions\":[[{\"type\":\"plugin\",\"operator\":\"!=\",\"plugin\":\"send-app\\/send-app.php\"}]]},{\"id\":\"ai-site-planner\",\"title\":\"Instant Sitemaps & Wireframes\",\"description\":\"Get your website plan in minutes with AI Site Planner. Describe your desired site and AI will generate a sitemap, brief and wireframe populated with initial content, ready for you to customize.\",\"topic\":\"Elementor AI\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/aI-site-planner.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/ai-notification-site-planner\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"grid-span-3.27\",\"title\":\"Design Grid layouts that fit your exact vision\",\"description\":\"Advanced column and row span controls give you the power to design Grid Container layouts that fit your exact vision.\",\"topic\":\"Elementor 3.27\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/grid-span-3.27.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.27-grid-span-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"local-fonts-3.27\",\"title\":\"Load Google Fonts safer and faster\",\"description\":\"Once enabled, Google Fonts are served directly from your server, streamlining the loading process and enhancing security.\",\"topic\":\"Elementor 3.27\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/local-google-fonts-3.27.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.27-local-fonts-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"video-shorts-3.27\",\"title\":\"Showcase short-form, vertical videos\",\"description\":\"The Video widget now supports YouTube Shorts in a vertical 9:16 ratio, the go-to format for engaging audiences.\",\"topic\":\"Elementor 3.27\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/video-shorts-3.27.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.27-video-shorts-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"dynamic-off-canvas-3.26\",\"title\":\"Dynamic Off-Canvas for Loop Grids\",\"description\":\"Create richer, more interactive designs by linking Dynamic Content to the Off Canvas widget, delivering seamless user experiences.\",\"topic\":\"Elementor Pro 3.26\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/off-canvas-loop-grids.png\",\"chipPlan\":\"Pro\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.26-blog\\/\",\"readMoreText\":\"Learn More\",\"conditions\":[[{\"type\":\"plugin\",\"plugin\":\"elementor-pro\\/elementor-pro.php\"}]]},{\"id\":\"dynamic-off-canvas-3.26\",\"title\":\"Dynamic Off-Canvas for Loop Grids\",\"description\":\"Create richer, more interactive designs by linking Dynamic Content to the Off Canvas widget, delivering seamless user experiences.\",\"topic\":\"Elementor Pro 3.26\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/off-canvas-loop-grids.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Upgrade\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.26-loop-off-canvas\\/\"},{\"id\":\"image-optimizer-3.19\",\"title\":\"Effortlessly optimize images for a stunning, high-speed website with the Image Optimizer plugin.\",\"description\":\"Image Optimizer perfectly balances between image quality and performance to boost your website.  Resize, compress, and convert images to WebP, for faster loading times and and better user experience.\",\"topic\":\"Image Optimizer Plugin by Elementor\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/image-optimizer-3.19.png\",\"chipTags\":[\"New plugin\"],\"cta\":\"Get the Image Optimizer\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/io-notification-wp-dash-learn-more\\/\",\"conditions\":[[{\"type\":\"plugin\",\"operator\":\"!=\",\"plugin\":\"image-optimization\\/image-optimization.php\"}]]},{\"id\":\"5-star-rating-prompt\",\"title\":\"Love the New Features? Let Us Know with 5 Stars!\",\"description\":\"Help spread the word by telling the world what you love about Elementor.\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/5-star-rating-prompt.png\",\"cta\":\"Leave a Review\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/wp-dash-notification-five-stars\\/\"},{\"id\":\"site-mailer-introducing\",\"title\":\"Introducing Site Mailer\",\"description\":\"Keep your WordPress emails out of the spam folder with improved deliverability and an easy setup\\u2014no need for an SMTP plugin or complicated configurations.\",\"topic\":\"Site Mailer Plugin by Elementor\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/Site-mailer.png\",\"chipTags\":[\"New plugin\"],\"cta\":\"Start Free Trial\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/sm-wp-dash-whatsnew\\/\",\"conditions\":[[{\"type\":\"plugin\",\"operator\":\"!=\",\"plugin\":\"site-mailer\\/site-mailer.php\"}]]}]\";}","off"),
("546","elementor_connect_site_key","b5a39508ecec0138e39f294d05b1e2db","auto"),
("548","elementor_remote_info_library","a:3:{s:10:\"types_data\";a:4:{s:5:\"block\";a:2:{s:10:\"categories\";a:30:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:8:\"Benefits\";i:4;s:14:\"call to action\";i:5;s:7:\"clients\";i:6;s:7:\"contact\";i:7;s:4:\"Data\";i:8;s:10:\"ehp-footer\";i:9;s:10:\"ehp-header\";i:10;s:3:\"faq\";i:11;s:8:\"features\";i:12;s:6:\"footer\";i:13;s:7:\"Gallery\";i:14;s:6:\"header\";i:15;s:4:\"hero\";i:16;s:11:\"Link in Bio\";i:17;s:9:\"portfolio\";i:18;s:7:\"pricing\";i:19;s:15:\"product archive\";i:20;s:5:\"Quote\";i:21;s:15:\"Service Details\";i:22;s:8:\"services\";i:23;s:11:\"single page\";i:24;s:11:\"single post\";i:25;s:14:\"single product\";i:26;s:5:\"stats\";i:27;s:9:\"subscribe\";i:28;s:4:\"team\";i:29;s:12:\"testimonials\";}s:4:\"sets\";a:5:{i:0;s:11:\"Boxing Club\";i:1;s:19:\"Business Consultant\";i:2;s:16:\"Marketing Agency\";i:3;s:9:\"Wireframe\";i:4;s:15:\"Workshop Center\";}}s:5:\"popup\";a:1:{s:10:\"categories\";a:6:{i:0;s:10:\"bottom bar\";i:1;s:7:\"classic\";i:2;s:6:\"fly-in\";i:3;s:11:\"full screen\";i:4;s:9:\"hello bar\";i:5;s:8:\"slide-in\";}}s:2:\"lp\";a:1:{s:10:\"categories\";a:15:{i:0;s:8:\"Business\";i:1;s:16:\"Coming Soon Page\";i:2;s:9:\"eCommerce\";i:3;s:9:\"Education\";i:4;s:6:\"Events\";i:5;s:18:\"Health and Fitness\";i:6;s:3:\"NFT\";i:7;s:14:\"Online Service\";i:8;s:7:\"Product\";i:9;s:11:\"Real Estate\";i:10;s:18:\"Social Involvement\";i:11;s:14:\"Thank You Page\";i:12;s:6:\"Travel\";i:13;s:18:\"Under Construction\";i:14;s:9:\"Wireframe\";}}s:2:\"lb\";a:1:{s:10:\"categories\";a:2:{i:0;s:4:\"post\";i:1;s:7:\"product\";}}}s:10:\"categories\";a:30:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:8:\"Benefits\";i:4;s:14:\"call to action\";i:5;s:7:\"clients\";i:6;s:7:\"contact\";i:7;s:4:\"Data\";i:8;s:10:\"ehp-footer\";i:9;s:10:\"ehp-header\";i:10;s:3:\"faq\";i:11;s:8:\"features\";i:12;s:6:\"footer\";i:13;s:7:\"Gallery\";i:14;s:6:\"header\";i:15;s:4:\"hero\";i:16;s:11:\"Link in Bio\";i:17;s:9:\"portfolio\";i:18;s:7:\"pricing\";i:19;s:15:\"product archive\";i:20;s:5:\"Quote\";i:21;s:15:\"Service Details\";i:22;s:8:\"services\";i:23;s:11:\"single page\";i:24;s:11:\"single post\";i:25;s:14:\"single product\";i:26;s:5:\"stats\";i:27;s:9:\"subscribe\";i:28;s:4:\"team\";i:29;s:12:\"testimonials\";}s:9:\"templates\";a:4:{i:0;a:20:{s:4:\"tmpl\";i:1254;s:2:\"id\";i:20472;s:5:\"title\";s:10:\"test ido f\";s:9:\"thumbnail\";s:153:\"https://library.stg.elementor.red/wp-content/uploads/2025/01/png-clipart-logo-harry-potter-literary-series-lord-voldemort-film-harry-potter-thumbnail.png\";s:12:\"tmpl_created\";i:1751356263;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.stg.elementor.red/blocks/test-ido-f/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:1;a:20:{s:4:\"tmpl\";i:1227;s:2:\"id\";i:19968;s:5:\"title\";s:12:\"Zeyad Test 1\";s:9:\"thumbnail\";s:83:\"https://library.stg.elementor.red/wp-content/uploads/2022/09/boxking_hero_img_2.jpg\";s:12:\"tmpl_created\";i:1670765723;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.stg.elementor.red/blocks/zeyad-test-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:2;a:20:{s:4:\"tmpl\";i:1231;s:2:\"id\";i:19494;s:5:\"title\";s:5:\"test2\";s:9:\"thumbnail\";s:83:\"https://library.stg.elementor.red/wp-content/uploads/2022/09/boxking_hero_img_4.jpg\";s:12:\"tmpl_created\";i:1672308146;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.stg.elementor.red/blocks/test2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:2;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:3;a:20:{s:4:\"tmpl\";i:1209;s:2:\"id\";i:9631;s:5:\"title\";s:38:\"Slide-in | Sale | Register | Subscribe\";s:9:\"thumbnail\";s:87:\"https://library.stg.elementor.red/wp-content/uploads/2019/01/Slide-in_Sale_small_01.png\";s:12:\"tmpl_created\";i:1660034300;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.stg.elementor.red/popups/slide-in-sale-01/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:142;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}}}","off"),
("549","elementor_remote_info_feed_data","a:3:{i:0;a:5:{s:5:\"title\";s:100:\"Introducing Elementor 3.30: new Editor V4 capabilities, full Website Templates in the cloud, & more!\";s:7:\"excerpt\";s:361:\"Elementor 3.30 is here and it includes upgrades that accelerate your workflow, bring you a step closer to the full power of Editor V4, and help you deliver beautiful, accessible websites faster than ever. From advanced styling tools and smarter editing to full Website Templates in the cloud, this release enhances both the way you design and the way you scale.\";s:7:\"created\";i:1751974442;s:5:\"badge\";s:3:\"NEW\";s:3:\"url\";s:140:\"https://elementor.com/blog/elementor-330-v4-alpha-website-templates/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:1;a:5:{s:5:\"title\";s:57:\"Introducing Cloud Templates: your personal design library\";s:7:\"excerpt\";s:153:\"Transform your workflow with Elementor\'s new Cloud Templates – create, save, and access your templates across all your websites with just a few clicks.\";s:7:\"created\";i:1749048239;s:5:\"badge\";s:3:\"NEW\";s:3:\"url\";s:127:\"https://elementor.com/blog/introducing-cloud-templates/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:2;a:5:{s:5:\"title\";s:74:\"Introducing Editor V4 Alpha: The Future of Website Building with Elementor\";s:7:\"excerpt\";s:242:\"Editor V4 Alpha introduces a CSS-first framework with reusable Classes and States, improved performance, a unified styling system, and fully responsive style controls—all designed to make your website building more efficient and consistent.\";s:7:\"created\";i:1748357309;s:5:\"badge\";s:4:\" NEW\";s:3:\"url\";s:119:\"https://elementor.com/blog/editor-v4-1st-alpha/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}}","off"),
("553","_elementor_local_google_fonts","a:7:{s:6:\"roboto\";a:2:{s:3:\"url\";s:79:\"https://creakonect.com/wp-content/uploads/elementor/google-fonts/css/roboto.css\";s:7:\"version\";i:1742655723;}s:10:\"robotoslab\";a:2:{s:3:\"url\";s:83:\"https://creakonect.com/wp-content/uploads/elementor/google-fonts/css/robotoslab.css\";s:7:\"version\";i:1742655726;}s:6:\"montez\";a:2:{s:3:\"url\";s:79:\"https://creakonect.com/wp-content/uploads/elementor/google-fonts/css/montez.css\";s:7:\"version\";i:1743110563;}s:10:\"montserrat\";a:2:{s:3:\"url\";s:83:\"https://creakonect.com/wp-content/uploads/elementor/google-fonts/css/montserrat.css\";s:7:\"version\";i:1743110602;}s:7:\"poppins\";a:2:{s:3:\"url\";s:80:\"https://creakonect.com/wp-content/uploads/elementor/google-fonts/css/poppins.css\";s:7:\"version\";i:1745916491;}s:7:\"figtree\";a:2:{s:3:\"url\";s:80:\"https://creakonect.com/wp-content/uploads/elementor/google-fonts/css/figtree.css\";s:7:\"version\";i:1745916492;}s:8:\"opensans\";a:2:{s:3:\"url\";s:81:\"https://creakonect.com/wp-content/uploads/elementor/google-fonts/css/opensans.css\";s:7:\"version\";i:1748020004;}}","auto"),
("560","jetpack_relatedposts","a:8:{s:7:\"enabled\";b:1;s:13:\"show_headline\";b:1;s:15:\"show_thumbnails\";b:0;s:9:\"show_date\";b:1;s:12:\"show_context\";b:1;s:6:\"layout\";s:4:\"grid\";s:8:\"headline\";s:9:\"Similaire\";s:4:\"size\";N;}","auto"),
("719","nav_menu_options","a:1:{s:8:\"auto_add\";a:1:{i:0;i:16109;}}","off"),
("732","_elementor_home_screen_data","a:2:{s:7:\"timeout\";i:1750014937;s:5:\"value\";s:10879:\"{\"top_with_licences\":[{\"license\":[\"free\"],\"title_small\":\"Hi!\",\"title\":\"Unleash your imagination with Elementor\",\"description\":\"Start building your website with Elementor\'s no code drag & drop editor.\",\"button_create_page_title\":\"Create a Page\",\"button_watch_title\":\"Watch a guide\",\"button_watch_url\":\"https:\\/\\/www.youtube.com\\/watch?v=le72grP_Q6k&t=1s\",\"youtube_embed_id\":\"le72grP_Q6k?si=g2akyWNODL6usu6u\"},{\"license\":[\"pro\"],\"title_small\":\"Hi!\",\"title\":\"Unleash your imagination with Elementor\",\"description\":\"Now you\'ve got all the tools to start creating professional, high-performing websites - and that journey begins by creating your first page.\",\"button_create_page_title\":\"Create a Page\",\"button_watch_title\":\"Watch a guide\",\"button_watch_url\":\"https:\\/\\/www.youtube.com\\/watch?v=QdkDGrS8ZZs\",\"youtube_embed_id\":\"QdkDGrS8ZZs?si=s_VjZCQR6Fh1jgB5\"}],\"get_started\":[{\"license\":[\"free\"],\"header\":{\"title\":\"Jumpstart your web-creation\",\"description\":\"These quick actions will get your site airborne with a customized design.\"},\"repeater\":[{\"title\":\"Site Settings\",\"title_small\":\"Customize\",\"url\":\"\",\"is_relative_url\":false,\"title_small_color\":\"text.tertiary\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/site-settings.svg\"},{\"title\":\"Site Logo\",\"title_small\":\"Customize\",\"url\":\"\",\"is_relative_url\":false,\"title_small_color\":\"text.tertiary\",\"tab_id\":\"settings-site-identity\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/site-logo.svg\"},{\"title\":\"Global Colors\",\"title_small\":\"Customize\",\"url\":\"\",\"is_relative_url\":false,\"title_small_color\":\"text.tertiary\",\"tab_id\":\"global-colors\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/global-colors.svg\"},{\"title\":\"Global Fonts\",\"title_small\":\"Customize\",\"url\":\"\",\"is_relative_url\":false,\"title_small_color\":\"text.tertiary\",\"tab_id\":\"global-typography\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/global-fonts.svg\"},{\"title\":\"Theme Builder\",\"title_small\":\"Customize\",\"url\":\"admin.php?page=elementor-app\",\"is_relative_url\":false,\"title_small_color\":\"text.tertiary\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/theme-builder.svg\"},{\"title\":\"Popups\",\"title_small\":\"Customize\",\"url\":\"edit.php?post_type=elementor_library&page=popup_templates\",\"is_relative_url\":true,\"title_small_color\":\"text.tertiary\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/popups.svg\"},{\"title\":\"Custom Icons\",\"title_small\":\"Customize\",\"url\":\"admin.php?page=elementor_custom_icons\",\"is_relative_url\":false,\"title_small_color\":\"text.tertiary\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/custom-icons.svg\"},{\"title\":\"Custom Fonts\",\"title_small\":\"Customize\",\"url\":\"admin.php?page=elementor_custom_fonts\",\"is_relative_url\":true,\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/custom-fonts.svg\",\"title_small_color\":\"text.tertiary\"}]},{\"license\":[\"pro\"],\"header\":{\"title\":\"Jumpstart your web-creation\",\"description\":\"These quick actions will get your site airborne with a customized design.\"},\"repeater\":[{\"title\":\"Site Settings\",\"title_small\":\"Customize\",\"url\":\"\",\"is_relative_url\":false,\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/site-settings.svg\"},{\"title\":\"Site Logo\",\"title_small\":\"Customize\",\"url\":\"\",\"is_relative_url\":false,\"tab_id\":\"settings-site-identity\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/site-logo.svg\"},{\"title\":\"Global Colors\",\"title_small\":\"Customize\",\"url\":\"\",\"is_relative_url\":false,\"tab_id\":\"global-colors\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/global-colors.svg\"},{\"title\":\"Global Fonts\",\"title_small\":\"Customize\",\"url\":\"\",\"is_relative_url\":false,\"tab_id\":\"global-typography\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/global-fonts.svg\"},{\"title\":\"Theme Builder\",\"title_small\":\"Customize\",\"url\":\"admin.php?page=elementor-app\",\"is_relative_url\":false,\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/theme-builder.svg\"},{\"title\":\"Popups\",\"title_small\":\"Customize\",\"url\":\"edit.php?post_type=elementor_library&tabs_group=popup&elementor_library_type=popup\",\"is_relative_url\":true,\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/popups.svg\"},{\"title\":\"Custom Icons\",\"title_small\":\"Customize\",\"url\":\"admin.php?page=elementor_custom_icons\",\"is_relative_url\":false,\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/custom-icons.svg\"},{\"title\":\"Custom Fonts\",\"title_small\":\"Customize\",\"url\":\"admin.php?page=elementor_custom_fonts\",\"is_relative_url\":true,\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/custom-fonts.svg\"}]}],\"add_ons\":{\"header\":{\"title\":\"Expand your design toolkit\",\"description\":\"These plugins, add-ons, and tools, have been selected to streamline your workflow and maximize your creativity.\"},\"repeater\":[{\"file_path\":\"send-app\\/send-app.php\",\"title\":\"Send \\u2013 Marketing Automation\",\"url\":\"\",\"description\":\"Supercharge your WooCommerce store with Send\\u2014an all-in-one toolkit for emails, popups & more. Built for WordPress. No plugins, no hassle.\",\"button_label\":\"Install\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/send-logo.svg\",\"type\":\"wporg\"},{\"file_path\":\"site-mailer\\/site-mailer.php\",\"title\":\"Site Mailer\",\"url\":\"\",\"description\":\"Keep your WordPress emails out of the spam folder with improved deliverability and an easy setup\\u2014no need for an SMTP plugin or complicated configurations.\",\"button_label\":\"Install\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/site-mailer.svg\",\"type\":\"wporg\"},{\"file_path\":\"image-optimization\\/image-optimization.php\",\"title\":\"Image Optimizer\",\"url\":\"https:\\/\\/go.elementor.com\\/wp-dash-apps-author-uri-elementor-io\\/\",\"description\":\"Check out this incredibly useful plugin that will compress and optimize your images, giving you leaner, faster websites.\",\"button_label\":\"Install\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/image-optimizer.svg\",\"type\":\"wporg\"},{\"title\":\"Elementor AI\",\"url\":\"https:\\/\\/go.elementor.com\\/wp-dash-apps-author-uri-elementor-ai\\/\",\"description\":\"Boost creativity with Elementor AI. Craft & enhance copy, create custom CSS & Code, and generate images to elevate your website.\",\"button_label\":\"Let\'s go\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/elementor.svg\",\"type\":\"link\",\"condition\":{\"key\":\"introduction_meta\",\"value\":\"ai_get_started\"}}],\"footer\":{\"label\":\"Explore more add-ons\",\"file_path\":\"wp-admin\\/admin.php?page=elementor-apps\"}},\"sidebar_upgrade\":[{\"license\":[\"free\"],\"show\":\"true\",\"header\":{\"title\":\"Bring your vision to life\",\"description\":\"Get complete design flexibility for your website with Elementor Pro\\u2019s advanced tools and premium features.\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-crown.svg\"},\"cta\":{\"label\":\"Upgrade Now\",\"url\":\"https:\\/\\/go.elementor.com\\/go-pro-home-sidebar-upgrade\\/\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-crown.svg\"},\"repeater\":[{\"title\":\"Popup Builder\"},{\"title\":\"Custom Code & CSS\"},{\"title\":\"E-commerce Features\"},{\"title\":\"Collaborative Notes\"},{\"title\":\"Form Submission\"},{\"title\":\"Form Integrations\"},{\"title\":\"Custom Attributes\"},{\"title\":\"Role Manager\"}]},{\"license\":[\"pro\"],\"show\":\"false\",\"header\":{\"title\":\"Bring your vision to life\",\"description\":\"Get complete design flexibility for your website with Elementor Pro\\u2019s advanced tools and premium features.\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-crown.svg\"},\"cta\":{\"label\":\"Upgrade Now\",\"url\":\"https:\\/\\/go.elementor.com\\/go-pro-home-sidebar-upgrade\\/\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-crown.svg\"},\"repeater\":[{\"title\":\"Popup Builder\"},{\"title\":\"Custom Code & CSS\"},{\"title\":\"E-commerce Features\"},{\"title\":\"Collaborative Notes\"},{\"title\":\"Form Submission\"},{\"title\":\"Form Integrations\"},{\"title\":\"Custom Attributes\"},{\"title\":\"Role Manager\"}]}],\"sidebar_promotion_variants\":[{\"license\":[\"essential\"],\"is_enabled\":\"true\",\"type\":\"banner\",\"data\":{\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/bd-sale-advanced.svg\",\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-advanced-home-sidebar-bd-sale\\/\"}},{\"license\":[\"free\"],\"is_enabled\":\"true\",\"type\":\"banner\",\"data\":{\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/bd-sale.svg\",\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-home-sidebar-bd-sale\\/\"}},{\"license\":[\"expired\"],\"is_enabled\":\"true\",\"type\":\"banner\",\"data\":{\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/upgrade-free.svg\",\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-home-sidebar-expired\\/\"}},{\"license\":[\"free\"],\"is_enabled\":\"false\",\"type\":\"default\",\"data\":{\"header\":{\"title\":\"Bring your vision to life\",\"description\":\"Get complete design flexibility for your website with Elementor Pro\\u2019s advanced tools and premium features.\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/update-sidebar.svg\"},\"cta\":{\"label\":\"Upgrade Now\",\"url\":\"https:\\/\\/go.elementor.com\\/go-pro-home-sidebar-upgrade\\/\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-crown.svg\"},\"repeater\":[{\"title\":\"Popup Builder\"},{\"title\":\"Custom Code & CSS\"},{\"title\":\"E-commerce Features\"},{\"title\":\"Collaborative Notes\"},{\"title\":\"Form Submission\"},{\"title\":\"Form Integrations\"},{\"title\":\"Custom Attributes\"},{\"title\":\"Role Manager\"}]}},{\"license\":[\"pro\"],\"is_enabled\":\"false\",\"type\":\"default\",\"data\":{\"header\":{\"title\":\"Bring your vision to life\",\"description\":\"Get complete design flexibility for your website with Elementor Pro\\u2019s advanced tools and premium features.\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/update-sidebar.svg\"},\"cta\":{\"label\":\"Upgrade Now\",\"url\":\"https:\\/\\/go.elementor.com\\/go-pro-home-sidebar-upgrade\\/\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-crown.svg\"},\"repeater\":[{\"title\":\"Popup Builder\"},{\"title\":\"Custom Code & CSS\"},{\"title\":\"E-commerce Features\"},{\"title\":\"Collaborative Notes\"},{\"title\":\"Form Submission\"},{\"title\":\"Form Integrations\"},{\"title\":\"Custom Attributes\"},{\"title\":\"Role Manager\"}]}}],\"external_links\":[{\"label\":\"Help Center\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-question-mark.svg\",\"url\":\"https:\\/\\/elementor.com\\/help\\/\"},{\"label\":\"Youtube\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-youtube.svg\",\"url\":\"https:\\/\\/www.youtube.com\\/@Elementor\"},{\"label\":\"Facebook Community\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-community.svg\",\"url\":\"https:\\/\\/www.facebook.com\\/groups\\/Elementors\"},{\"label\":\"Blog\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-academic-hat.svg\",\"url\":\"https:\\/\\/elementor.com\\/blog\\/\"}]}\";}","off"),
("864","category_children","a:0:{}","auto"),
("879","elementor_log","a:43:{s:32:\"d53501bd385b1cce2c35af4b88603a79\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:7:\"\0*\0date\";s:19:\"2025-05-24 13:54:28\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:42:\"Cannot convert undefined or null to object\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:2;s:14:\"\0*\0times_dates\";a:2:{i:0;s:19:\"2025-05-24 13:54:28\";i:1;s:19:\"2025-05-24 13:54:31\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1748094868\";s:7:\"message\";s:42:\"Cannot convert undefined or null to object\";s:3:\"url\";s:86:\"https://creakonect.com/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.29.0\";s:4:\"line\";s:1:\"3\";s:6:\"column\";s:6:\"921054\";}s:7:\"\0*\0file\";s:86:\"https://creakonect.com/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.29.0\";s:7:\"\0*\0line\";s:1:\"3\";s:9:\"\0*\0column\";s:6:\"921054\";}s:32:\"b8623bc5f8c295630ed5d120f5985c6a\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-05-25 17:24:28\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-05-25 17:24:28\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"4420c297c21f961193b7b2785c01e219\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-05-25 17:24:28\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-05-25 17:24:28\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"562ac0a48a29cb392946b68a27aa0b10\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-05-25 17:24:28\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-05-25 17:24:28\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"3b3a1f268343137a74be301ed11132e5\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-05-25 17:24:28\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.28.4\";s:2:\"to\";s:6:\"3.29.0\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-05-25 17:24:28\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.28.4\";s:2:\"to\";s:6:\"3.29.0\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"f0f5477d886fcfe7b0f84841675d96f7\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-05-28 17:34:17\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.29.0\";s:2:\"to\";s:6:\"3.29.1\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-05-28 17:34:17\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.29.0\";s:2:\"to\";s:6:\"3.29.1\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"d14835be6c461aab2e27496c83986267\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-05-28 17:34:26\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-05-28 17:34:26\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"e45517f32daeffefa671db0741237593\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-05-28 17:34:26\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-05-28 17:34:26\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"a1f67246b5f997c87eb57d594301f5c1\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-05-28 17:34:27\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-05-28 17:34:27\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"31344e0a69af24e2d5482a617ae96758\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-05-28 17:34:27\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.29.0\";s:2:\"to\";s:6:\"3.29.1\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-05-28 17:34:27\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.29.0\";s:2:\"to\";s:6:\"3.29.1\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"e6e076c9d7c1040e07469a28b2906569\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:7:\"\0*\0date\";s:19:\"2025-05-30 17:35:54\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:55:\"Cannot read properties of null (reading &#039;id&#039;)\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:3;s:14:\"\0*\0times_dates\";a:3:{i:0;s:19:\"2025-05-30 17:35:54\";i:1;s:19:\"2025-06-08 15:49:55\";i:2;s:19:\"2025-06-08 16:14:42\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1748626554\";s:7:\"message\";s:45:\"Cannot read properties of null (reading \'id\')\";s:3:\"url\";s:86:\"https://creakonect.com/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.29.1\";s:4:\"line\";s:1:\"3\";s:6:\"column\";s:6:\"667908\";}s:7:\"\0*\0file\";s:86:\"https://creakonect.com/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.29.1\";s:7:\"\0*\0line\";s:1:\"3\";s:9:\"\0*\0column\";s:6:\"667908\";}s:32:\"9dbd6671a2391ff3d882e7d7a2fcd621\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-06-04 17:13:57\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.29.1\";s:2:\"to\";s:6:\"3.29.2\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-06-04 17:13:57\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.29.1\";s:2:\"to\";s:6:\"3.29.2\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"870fbc0a25c080ca3ea21cdd7a4e4aac\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-06-04 17:14:10\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-06-04 17:14:10\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"ee8a5d7c89f6d6896da8ff0de40473e9\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-06-04 17:14:10\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-06-04 17:14:10\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"3ac0655359b0b63cb3c85c2ccf818a7a\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-06-04 17:14:11\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-06-04 17:14:11\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"a71a19cd64de0bb42289b9449b774d6c\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-06-04 17:14:11\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.29.1\";s:2:\"to\";s:6:\"3.29.2\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-06-04 17:14:11\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.29.1\";s:2:\"to\";s:6:\"3.29.2\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"216bb8f7ebb2810780af4cac9ce1d9d6\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:7:\"\0*\0date\";s:19:\"2025-06-15 15:59:49\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:51:\"elementor_new_template_form_controls is not defined\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-06-15 15:59:49\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1750003189\";s:7:\"message\";s:51:\"elementor_new_template_form_controls is not defined\";s:3:\"url\";s:68:\"https://creakonect.com/wp-includes/js/jquery/jquery.min.js?ver=3.7.1\";s:4:\"line\";s:1:\"2\";s:6:\"column\";s:5:\"28760\";}s:7:\"\0*\0file\";s:68:\"https://creakonect.com/wp-includes/js/jquery/jquery.min.js?ver=3.7.1\";s:7:\"\0*\0line\";s:1:\"2\";s:9:\"\0*\0column\";s:5:\"28760\";}s:32:\"7429493758b3bdf000438aac4d3c9b49\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:7:\"\0*\0date\";s:19:\"2025-06-15 16:00:10\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:24:\"elementor is not defined\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:4;s:14:\"\0*\0times_dates\";a:4:{i:0;s:19:\"2025-06-15 16:00:10\";i:1;s:19:\"2025-06-15 16:00:12\";i:2;s:19:\"2025-06-15 16:00:15\";i:3;s:19:\"2025-06-15 16:00:19\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1750003210\";s:7:\"message\";s:24:\"elementor is not defined\";s:3:\"url\";s:94:\"https://creakonect.com/wp-content/plugins/elementor/assets/js/common-modules.min.js?ver=3.29.2\";s:4:\"line\";s:1:\"2\";s:6:\"column\";s:5:\"63978\";}s:7:\"\0*\0file\";s:94:\"https://creakonect.com/wp-content/plugins/elementor/assets/js/common-modules.min.js?ver=3.29.2\";s:7:\"\0*\0line\";s:1:\"2\";s:9:\"\0*\0column\";s:5:\"63978\";}s:32:\"b7946a3e7d62040c9af4217feac48f9d\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-07-01 17:30:12\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.29.2\";s:2:\"to\";s:6:\"3.30.0\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-07-01 17:30:12\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.29.2\";s:2:\"to\";s:6:\"3.30.0\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"d6ba2f754fa485a961375bcfab49a46b\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-07-01 17:30:30\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-07-01 17:30:30\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"80cdd8ac38b0dc7a6ce31b897c3a95da\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-07-01 17:30:30\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-07-01 17:30:30\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"9152e27274855f62892dfbc63a8fc8a9\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-07-01 17:30:31\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-07-01 17:30:31\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"1081eff6438e0b8535bf49ada451cbba\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-07-01 17:30:31\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.29.2\";s:2:\"to\";s:6:\"3.30.0\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-07-01 17:30:31\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.29.2\";s:2:\"to\";s:6:\"3.30.0\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"94e9ad8cf03ae04a35e3b7b217a8021c\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-07-07 19:51:41\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.30.0\";s:2:\"to\";s:6:\"3.30.1\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-07-07 19:51:41\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.30.0\";s:2:\"to\";s:6:\"3.30.1\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"2d890aed657e1c9a293438cb4c1a1640\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-07-07 20:06:53\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-07-07 20:06:53\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"c26cf44b98a3ceb935c1ee2daaab6a5a\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-07-07 20:06:53\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-07-07 20:06:53\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"f7f3c4c961b1b7463f93bda8b076690d\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-07-07 20:06:54\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-07-07 20:06:54\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"e4a919cff77edf1b9445a8d51fe0dfa2\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-07-07 20:06:54\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.30.0\";s:2:\"to\";s:6:\"3.30.1\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-07-07 20:06:54\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.30.0\";s:2:\"to\";s:6:\"3.30.1\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"c8c06c361dcd67dc96abb8687720d3f7\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-07-09 17:23:13\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.30.1\";s:2:\"to\";s:6:\"3.30.2\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-07-09 17:23:13\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.30.1\";s:2:\"to\";s:6:\"3.30.2\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"89806b483045746f0692197580eccc91\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-07-09 17:23:23\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-07-09 17:23:23\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"cf60abec6a45cd0af4924ceca42aa97f\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-07-09 17:23:23\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-07-09 17:23:23\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"8f3d23f9c3b59d69908cb13eb794239a\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-07-09 17:23:24\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-07-09 17:23:24\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"99ad221a1e3a906d35f2b4e880442083\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-07-09 17:23:24\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.30.1\";s:2:\"to\";s:6:\"3.30.2\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-07-09 17:23:24\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.30.1\";s:2:\"to\";s:6:\"3.30.2\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"d47c74aa5201961113fb72aa607b33d2\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-07-22 16:54:56\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.30.2\";s:2:\"to\";s:6:\"3.30.3\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-07-22 16:54:56\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.30.2\";s:2:\"to\";s:6:\"3.30.3\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"1f3be63ce92bafe1b331a988cf171913\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-07-22 16:55:06\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-07-22 16:55:06\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"50f47fd714638cbf9ce7ff2deba7138b\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-07-22 16:55:06\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-07-22 16:55:06\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"47d8bc5cea4cf5ec3e2e74c8191bf209\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-07-22 16:55:06\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-07-22 16:55:06\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"c7ff5e68cac25045ac60f85856b04f8a\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-07-22 16:55:06\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.30.2\";s:2:\"to\";s:6:\"3.30.3\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-07-22 16:55:06\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.30.2\";s:2:\"to\";s:6:\"3.30.3\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"6766d7116f04214fa2646610a1b47c68\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-07-30 17:54:16\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.30.3\";s:2:\"to\";s:6:\"3.30.4\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-07-30 17:54:16\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.30.3\";s:2:\"to\";s:6:\"3.30.4\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"681754ac4271f37b0944c4253e2b45ec\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-07-30 17:54:17\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-07-30 17:54:17\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"66ea9f1a9299dd0a95fe105660822620\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-07-30 17:54:17\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-07-30 17:54:17\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"5e8c421eee5c5a0fd4086fe736d78119\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-07-30 17:54:18\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-07-30 17:54:18\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"32063cbb84bad1d50241f9b86623026e\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-07-30 17:54:18\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.30.3\";s:2:\"to\";s:6:\"3.30.4\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-07-30 17:54:18\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.30.3\";s:2:\"to\";s:6:\"3.30.4\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}}","off"),
("930","wp_calendar_block_has_published_posts","1","auto"),
("1545","wpcom_publish_posts_with_markdown","1","auto"),
("1737","_elementor_editor_upgrade_notice_dismissed","1750002490","auto"),
("1743","elementor_allow_tracking","yes","auto"),
("1744","elementor_tracker_notice","1","auto"),
("1917","themeisle_sdk_notifications","a:2:{s:17:\"last_notification\";a:2:{s:2:\"id\";s:23:\"optimole_wp_logger_flag\";s:10:\"display_at\";i:1749141795;}s:24:\"last_notification_active\";i:1750002478;}","auto"),
("1964","nonce_key","/$=F%^s SIu2-B9XF4Y*2bcFwY-K<=s^!Q@G-Md))DZJod?x84rU[k/Fnz&rn>nz","off"),
("1965","nonce_salt","%z>JeQ!N4r59EYRtZ`91( 2H4g:vb*NR:ja3o| 8{pzml?3q@qlQdg?nU#6$(: S","off"),
("2007","updraftplus_version","1.25.6","on"),
("2009","updraft_lastmessage","Binary zip: error (code: 127) (Mar 28 16:55:53)","on"),
("2010","updraft_updraftvault","a:2:{s:7:\"version\";i:1;s:8:\"settings\";a:1:{s:34:\"s-dc00983b6af6524437fe0e583de1d642\";a:3:{s:5:\"token\";s:0:\"\";s:5:\"email\";s:0:\"\";s:5:\"quota\";i:-1;}}}","on"),
("2011","updraft_dropbox","a:2:{s:7:\"version\";i:1;s:8:\"settings\";a:1:{s:34:\"s-f919a12122da06b914bfe9e32d05b308\";a:4:{s:6:\"appkey\";s:0:\"\";s:6:\"secret\";s:0:\"\";s:6:\"folder\";s:0:\"\";s:15:\"tk_access_token\";s:0:\"\";}}}","on"),
("2012","updraft_s3","a:2:{s:7:\"version\";i:1;s:8:\"settings\";a:1:{s:34:\"s-0ea3ddaaeabf0bbf48240b178baad20d\";a:5:{s:9:\"accesskey\";s:0:\"\";s:9:\"secretkey\";s:0:\"\";s:4:\"path\";s:0:\"\";s:3:\"rrs\";s:0:\"\";s:22:\"server_side_encryption\";s:0:\"\";}}}","on"),
("2013","updraft_cloudfiles","a:2:{s:7:\"version\";i:1;s:8:\"settings\";a:1:{s:34:\"s-5d091e5cd7567bb3cc9d0a11b09bf146\";a:5:{s:4:\"user\";s:0:\"\";s:7:\"authurl\";s:35:\"https://auth.api.rackspacecloud.com\";s:6:\"apikey\";s:0:\"\";s:4:\"path\";s:0:\"\";s:6:\"region\";N;}}}","on"),
("2014","updraft_googledrive","a:2:{s:7:\"version\";i:1;s:8:\"settings\";a:1:{s:34:\"s-0add3850a90bd15936b4092617e403dd\";a:3:{s:8:\"clientid\";s:0:\"\";s:6:\"secret\";s:0:\"\";s:5:\"token\";s:0:\"\";}}}","on"),
("2015","updraft_onedrive","a:2:{s:7:\"version\";i:1;s:8:\"settings\";a:1:{s:34:\"s-30668ac4bb660a0e92ac5e6b2beba334\";a:0:{}}}","on"),
("2016","updraft_ftp","a:2:{s:7:\"version\";i:1;s:8:\"settings\";a:1:{s:34:\"s-450a7aae28932f4e2e40210a4e73f285\";a:5:{s:4:\"host\";s:0:\"\";s:4:\"user\";s:0:\"\";s:4:\"pass\";s:0:\"\";s:4:\"path\";s:0:\"\";s:7:\"passive\";i:1;}}}","on"),
("2017","updraft_azure","a:2:{s:7:\"version\";i:1;s:8:\"settings\";a:1:{s:34:\"s-2b8ba65df82a6786417284fd397e1375\";a:0:{}}}","on"),
("2018","updraft_sftp","a:2:{s:7:\"version\";i:1;s:8:\"settings\";a:1:{s:34:\"s-df8aff4cd237a9a6ea1cd2eb748236b6\";a:0:{}}}","on"),
("2019","updraft_googlecloud","a:2:{s:7:\"version\";i:1;s:8:\"settings\";a:1:{s:34:\"s-e5fd6de18ba4a49ff98033a1f0c4c752\";a:0:{}}}","on"),
("2020","updraft_backblaze","a:2:{s:7:\"version\";i:1;s:8:\"settings\";a:1:{s:34:\"s-aeaf0e028e786d4cb2a11555e023d9d3\";a:0:{}}}","on"),
("2021","updraft_webdav","a:2:{s:7:\"version\";i:1;s:8:\"settings\";a:1:{s:34:\"s-a5956d0106dfa584f38bf5465b4d5a82\";a:0:{}}}","on"),
("2022","updraft_s3generic","a:2:{s:7:\"version\";i:1;s:8:\"settings\";a:1:{s:34:\"s-370a96b34e9f87edf03a6f5f9c8df4a4\";a:4:{s:9:\"accesskey\";s:0:\"\";s:9:\"secretkey\";s:0:\"\";s:4:\"path\";s:0:\"\";s:8:\"endpoint\";s:0:\"\";}}}","on"),
("2023","updraft_pcloud","a:2:{s:7:\"version\";i:1;s:8:\"settings\";a:1:{s:34:\"s-6a307487130ee24a147d9ffda24d5313\";a:0:{}}}","on"),
("2024","updraft_openstack","a:2:{s:7:\"version\";i:1;s:8:\"settings\";a:1:{s:34:\"s-80f11dd6ca12f85f537a3c1d16c85426\";a:6:{s:4:\"user\";s:0:\"\";s:7:\"authurl\";s:0:\"\";s:8:\"password\";s:0:\"\";s:6:\"tenant\";s:0:\"\";s:4:\"path\";s:0:\"\";s:6:\"region\";s:0:\"\";}}}","on"),
("2025","updraft_dreamobjects","a:2:{s:7:\"version\";i:1;s:8:\"settings\";a:1:{s:34:\"s-215378828ff0eb6f1c8d8824dc0d5285\";a:3:{s:9:\"accesskey\";s:0:\"\";s:9:\"secretkey\";s:0:\"\";s:4:\"path\";s:0:\"\";}}}","on"),
("2026","updraftplus-addons_siteid","1491e63caf3ad46d3c4ad84bf39b41a2","off"),
("2027","updraftplus_tour_cancelled_on","backup_now","on"),
("2043","yoast_migrations_free","a:1:{s:7:\"version\";s:4:\"25.6\";}","auto"),
("2044","wpseo","a:115:{s:8:\"tracking\";b:0;s:16:\"toggled_tracking\";b:0;s:22:\"license_server_version\";b:0;s:15:\"ms_defaults_set\";b:0;s:40:\"ignore_search_engines_discouraged_notice\";b:1;s:19:\"indexing_first_time\";b:1;s:16:\"indexing_started\";b:0;s:15:\"indexing_reason\";s:21:\"post_type_made_public\";s:29:\"indexables_indexing_completed\";b:1;s:13:\"index_now_key\";s:0:\"\";s:7:\"version\";s:4:\"25.6\";s:16:\"previous_version\";s:4:\"25.5\";s:20:\"disableadvanced_meta\";b:1;s:30:\"enable_headless_rest_endpoints\";b:1;s:17:\"ryte_indexability\";b:0;s:11:\"baiduverify\";s:0:\"\";s:12:\"googleverify\";s:0:\"\";s:8:\"msverify\";s:0:\"\";s:12:\"yandexverify\";s:0:\"\";s:9:\"site_type\";s:0:\"\";s:20:\"has_multiple_authors\";s:0:\"\";s:16:\"environment_type\";s:0:\"\";s:23:\"content_analysis_active\";b:1;s:23:\"keyword_analysis_active\";b:1;s:34:\"inclusive_language_analysis_active\";b:0;s:21:\"enable_admin_bar_menu\";b:1;s:26:\"enable_cornerstone_content\";b:1;s:18:\"enable_xml_sitemap\";b:1;s:24:\"enable_text_link_counter\";b:1;s:16:\"enable_index_now\";b:1;s:19:\"enable_ai_generator\";b:1;s:22:\"ai_enabled_pre_default\";b:0;s:22:\"show_onboarding_notice\";b:1;s:18:\"first_activated_on\";i:1743176780;s:13:\"myyoast-oauth\";b:0;s:26:\"semrush_integration_active\";b:1;s:14:\"semrush_tokens\";a:0:{}s:20:\"semrush_country_code\";s:2:\"us\";s:19:\"permalink_structure\";s:36:\"/%year%/%monthnum%/%day%/%postname%/\";s:8:\"home_url\";s:22:\"https://creakonect.com\";s:18:\"dynamic_permalinks\";b:0;s:17:\"category_base_url\";s:0:\"\";s:12:\"tag_base_url\";s:0:\"\";s:21:\"custom_taxonomy_slugs\";a:6:{s:22:\"elementor_library_type\";s:22:\"elementor_library_type\";s:26:\"elementor_library_category\";s:26:\"elementor_library_category\";s:14:\"bp_member_type\";s:14:\"bp_member_type\";s:13:\"bp-email-type\";s:13:\"bp-email-type\";s:13:\"bp_group_type\";s:13:\"bp_group_type\";s:19:\"wpsl_store_category\";s:19:\"wpsl_store_category\";}s:29:\"enable_enhanced_slack_sharing\";b:1;s:23:\"enable_metabox_insights\";b:1;s:23:\"enable_link_suggestions\";b:1;s:26:\"algolia_integration_active\";b:0;s:14:\"import_cursors\";a:0:{}s:13:\"workouts_data\";a:1:{s:13:\"configuration\";a:1:{s:13:\"finishedSteps\";a:0:{}}}s:28:\"configuration_finished_steps\";a:0:{}s:36:\"dismiss_configuration_workout_notice\";b:0;s:34:\"dismiss_premium_deactivated_notice\";b:0;s:19:\"importing_completed\";a:5:{s:30:\"aioseo_custom_archive_settings\";b:1;s:31:\"aioseo_default_archive_settings\";b:1;s:23:\"aioseo_general_settings\";b:1;s:32:\"aioseo_posttype_default_settings\";b:1;s:24:\"aioseo_taxonomy_settings\";b:1;}s:26:\"wincher_integration_active\";b:1;s:14:\"wincher_tokens\";a:0:{}s:36:\"wincher_automatically_add_keyphrases\";b:0;s:18:\"wincher_website_id\";s:0:\"\";s:18:\"first_time_install\";b:1;s:34:\"should_redirect_after_install_free\";b:0;s:34:\"activation_redirect_timestamp_free\";i:1743176782;s:18:\"remove_feed_global\";b:0;s:27:\"remove_feed_global_comments\";b:0;s:25:\"remove_feed_post_comments\";b:0;s:19:\"remove_feed_authors\";b:0;s:22:\"remove_feed_categories\";b:0;s:16:\"remove_feed_tags\";b:0;s:29:\"remove_feed_custom_taxonomies\";b:0;s:22:\"remove_feed_post_types\";b:0;s:18:\"remove_feed_search\";b:0;s:21:\"remove_atom_rdf_feeds\";b:0;s:17:\"remove_shortlinks\";b:0;s:21:\"remove_rest_api_links\";b:0;s:20:\"remove_rsd_wlw_links\";b:0;s:19:\"remove_oembed_links\";b:0;s:16:\"remove_generator\";b:0;s:20:\"remove_emoji_scripts\";b:0;s:24:\"remove_powered_by_header\";b:0;s:22:\"remove_pingback_header\";b:0;s:28:\"clean_campaign_tracking_urls\";b:0;s:16:\"clean_permalinks\";b:0;s:32:\"clean_permalinks_extra_variables\";s:0:\"\";s:14:\"search_cleanup\";b:0;s:20:\"search_cleanup_emoji\";b:0;s:23:\"search_cleanup_patterns\";b:0;s:22:\"search_character_limit\";i:50;s:20:\"deny_search_crawling\";b:0;s:21:\"deny_wp_json_crawling\";b:0;s:20:\"deny_adsbot_crawling\";b:0;s:19:\"deny_ccbot_crawling\";b:0;s:29:\"deny_google_extended_crawling\";b:0;s:20:\"deny_gptbot_crawling\";b:0;s:27:\"redirect_search_pretty_urls\";b:0;s:29:\"least_readability_ignore_list\";a:0:{}s:27:\"least_seo_score_ignore_list\";a:0:{}s:23:\"most_linked_ignore_list\";a:0:{}s:24:\"least_linked_ignore_list\";a:0:{}s:28:\"indexables_page_reading_list\";a:5:{i:0;b:0;i:1;b:0;i:2;b:0;i:3;b:0;i:4;b:0;}s:25:\"indexables_overview_state\";s:21:\"dashboard-not-visited\";s:28:\"last_known_public_post_types\";a:6:{i:0;s:4:\"post\";i:1;s:4:\"page\";i:2;s:18:\"e-floating-buttons\";i:3;s:14:\"wpum_directory\";i:4;s:10:\"buddypress\";i:5;s:12:\"elementor-hf\";}s:28:\"last_known_public_taxonomies\";a:3:{i:0;s:8:\"category\";i:1;s:8:\"post_tag\";i:2;s:11:\"post_format\";}s:23:\"last_known_no_unindexed\";a:6:{s:31:\"wpseo_unindexed_term_link_count\";i:1754244679;s:27:\"wpseo_total_unindexed_posts\";i:1750596270;s:31:\"wpseo_unindexed_post_link_count\";i:1754244679;s:40:\"wpseo_total_unindexed_post_type_archives\";i:1754244679;s:35:\"wpseo_total_unindexed_general_items\";i:1754244679;s:27:\"wpseo_total_unindexed_terms\";i:1750596270;}s:14:\"new_post_types\";a:1:{i:5;s:12:\"elementor-hf\";}s:14:\"new_taxonomies\";a:0:{}s:34:\"show_new_content_type_notification\";b:1;s:44:\"site_kit_configuration_permanently_dismissed\";b:0;s:18:\"site_kit_connected\";b:0;s:37:\"site_kit_tracking_setup_widget_loaded\";s:2:\"no\";s:41:\"site_kit_tracking_first_interaction_stage\";s:0:\"\";s:40:\"site_kit_tracking_last_interaction_stage\";s:0:\"\";s:52:\"site_kit_tracking_setup_widget_temporarily_dismissed\";s:2:\"no\";s:52:\"site_kit_tracking_setup_widget_permanently_dismissed\";s:2:\"no\";s:31:\"google_site_kit_feature_enabled\";b:0;s:25:\"ai_free_sparks_started_on\";N;s:15:\"enable_llms_txt\";b:0;}","auto"),
("2045","wpseo_titles","a:151:{s:17:\"forcerewritetitle\";b:0;s:9:\"separator\";s:7:\"sc-dash\";s:16:\"title-home-wpseo\";s:42:\"%%sitename%% %%page%% %%sep%% %%sitedesc%%\";s:18:\"title-author-wpseo\";s:50:\"%%name%%, auteur/autrice sur %%sitename%% %%page%%\";s:19:\"title-archive-wpseo\";s:38:\"%%date%% %%page%% %%sep%% %%sitename%%\";s:18:\"title-search-wpseo\";s:65:\"Vous avez cherché %%searchphrase%% %%page%% %%sep%% %%sitename%%\";s:15:\"title-404-wpseo\";s:38:\"Page non trouvée %%sep%% %%sitename%%\";s:25:\"social-title-author-wpseo\";s:8:\"%%name%%\";s:26:\"social-title-archive-wpseo\";s:8:\"%%date%%\";s:31:\"social-description-author-wpseo\";s:0:\"\";s:32:\"social-description-archive-wpseo\";s:0:\"\";s:29:\"social-image-url-author-wpseo\";s:0:\"\";s:30:\"social-image-url-archive-wpseo\";s:0:\"\";s:28:\"social-image-id-author-wpseo\";i:0;s:29:\"social-image-id-archive-wpseo\";i:0;s:19:\"metadesc-home-wpseo\";s:0:\"\";s:21:\"metadesc-author-wpseo\";s:0:\"\";s:22:\"metadesc-archive-wpseo\";s:0:\"\";s:9:\"rssbefore\";s:0:\"\";s:8:\"rssafter\";s:64:\"L’article %%POSTLINK%% est apparu en premier sur %%BLOGLINK%%.\";s:20:\"noindex-author-wpseo\";b:0;s:28:\"noindex-author-noposts-wpseo\";b:1;s:21:\"noindex-archive-wpseo\";b:1;s:14:\"disable-author\";b:0;s:12:\"disable-date\";b:0;s:19:\"disable-post_format\";b:0;s:18:\"disable-attachment\";b:1;s:20:\"breadcrumbs-404crumb\";s:30:\"Erreur 404 : Page introuvable\";s:29:\"breadcrumbs-display-blog-page\";b:1;s:20:\"breadcrumbs-boldlast\";b:0;s:25:\"breadcrumbs-archiveprefix\";s:13:\"Archives pour\";s:18:\"breadcrumbs-enable\";b:1;s:16:\"breadcrumbs-home\";s:7:\"Accueil\";s:18:\"breadcrumbs-prefix\";s:0:\"\";s:24:\"breadcrumbs-searchprefix\";s:18:\"Vous avez cherché\";s:15:\"breadcrumbs-sep\";s:2:\"»\";s:12:\"website_name\";s:0:\"\";s:11:\"person_name\";s:0:\"\";s:11:\"person_logo\";s:0:\"\";s:22:\"alternate_website_name\";s:0:\"\";s:12:\"company_logo\";s:0:\"\";s:12:\"company_name\";s:0:\"\";s:22:\"company_alternate_name\";s:0:\"\";s:17:\"company_or_person\";s:7:\"company\";s:25:\"company_or_person_user_id\";b:0;s:17:\"stripcategorybase\";b:0;s:26:\"open_graph_frontpage_title\";s:12:\"%%sitename%%\";s:25:\"open_graph_frontpage_desc\";s:0:\"\";s:26:\"open_graph_frontpage_image\";s:0:\"\";s:24:\"publishing_principles_id\";i:0;s:25:\"ownership_funding_info_id\";i:0;s:29:\"actionable_feedback_policy_id\";i:0;s:21:\"corrections_policy_id\";i:0;s:16:\"ethics_policy_id\";i:0;s:19:\"diversity_policy_id\";i:0;s:28:\"diversity_staffing_report_id\";i:0;s:15:\"org-description\";s:0:\"\";s:9:\"org-email\";s:0:\"\";s:9:\"org-phone\";s:0:\"\";s:14:\"org-legal-name\";s:0:\"\";s:17:\"org-founding-date\";s:0:\"\";s:20:\"org-number-employees\";s:0:\"\";s:10:\"org-vat-id\";s:0:\"\";s:10:\"org-tax-id\";s:0:\"\";s:7:\"org-iso\";s:0:\"\";s:8:\"org-duns\";s:0:\"\";s:11:\"org-leicode\";s:0:\"\";s:9:\"org-naics\";s:0:\"\";s:10:\"title-post\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-post\";s:0:\"\";s:12:\"noindex-post\";b:0;s:23:\"display-metabox-pt-post\";b:1;s:23:\"post_types-post-maintax\";i:0;s:21:\"schema-page-type-post\";s:7:\"WebPage\";s:24:\"schema-article-type-post\";s:7:\"Article\";s:17:\"social-title-post\";s:9:\"%%title%%\";s:23:\"social-description-post\";s:0:\"\";s:21:\"social-image-url-post\";s:0:\"\";s:20:\"social-image-id-post\";i:0;s:10:\"title-page\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-page\";s:0:\"\";s:12:\"noindex-page\";b:0;s:23:\"display-metabox-pt-page\";b:1;s:23:\"post_types-page-maintax\";i:0;s:21:\"schema-page-type-page\";s:7:\"WebPage\";s:24:\"schema-article-type-page\";s:4:\"None\";s:17:\"social-title-page\";s:9:\"%%title%%\";s:23:\"social-description-page\";s:0:\"\";s:21:\"social-image-url-page\";s:0:\"\";s:20:\"social-image-id-page\";i:0;s:16:\"title-attachment\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:19:\"metadesc-attachment\";s:0:\"\";s:18:\"noindex-attachment\";b:0;s:29:\"display-metabox-pt-attachment\";b:1;s:29:\"post_types-attachment-maintax\";i:0;s:27:\"schema-page-type-attachment\";s:7:\"WebPage\";s:30:\"schema-article-type-attachment\";s:4:\"None\";s:24:\"title-e-floating-buttons\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:27:\"metadesc-e-floating-buttons\";s:0:\"\";s:26:\"noindex-e-floating-buttons\";b:0;s:37:\"display-metabox-pt-e-floating-buttons\";b:1;s:37:\"post_types-e-floating-buttons-maintax\";i:0;s:35:\"schema-page-type-e-floating-buttons\";s:7:\"WebPage\";s:38:\"schema-article-type-e-floating-buttons\";s:4:\"None\";s:31:\"social-title-e-floating-buttons\";s:9:\"%%title%%\";s:37:\"social-description-e-floating-buttons\";s:0:\"\";s:35:\"social-image-url-e-floating-buttons\";s:0:\"\";s:34:\"social-image-id-e-floating-buttons\";i:0;s:23:\"title-elementor_library\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:26:\"metadesc-elementor_library\";s:0:\"\";s:25:\"noindex-elementor_library\";b:0;s:36:\"display-metabox-pt-elementor_library\";b:1;s:36:\"post_types-elementor_library-maintax\";i:0;s:34:\"schema-page-type-elementor_library\";s:7:\"WebPage\";s:37:\"schema-article-type-elementor_library\";s:4:\"None\";s:30:\"social-title-elementor_library\";s:9:\"%%title%%\";s:36:\"social-description-elementor_library\";s:0:\"\";s:34:\"social-image-url-elementor_library\";s:0:\"\";s:33:\"social-image-id-elementor_library\";i:0;s:18:\"title-tax-category\";s:57:\"Archives des %%term_title%% %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-category\";s:0:\"\";s:28:\"display-metabox-tax-category\";b:1;s:20:\"noindex-tax-category\";b:0;s:25:\"social-title-tax-category\";s:27:\"Archives des %%term_title%%\";s:31:\"social-description-tax-category\";s:0:\"\";s:29:\"social-image-url-tax-category\";s:0:\"\";s:28:\"social-image-id-tax-category\";i:0;s:26:\"taxonomy-category-ptparent\";i:0;s:18:\"title-tax-post_tag\";s:57:\"Archives des %%term_title%% %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-post_tag\";s:0:\"\";s:28:\"display-metabox-tax-post_tag\";b:1;s:20:\"noindex-tax-post_tag\";b:0;s:25:\"social-title-tax-post_tag\";s:27:\"Archives des %%term_title%%\";s:31:\"social-description-tax-post_tag\";s:0:\"\";s:29:\"social-image-url-tax-post_tag\";s:0:\"\";s:28:\"social-image-id-tax-post_tag\";i:0;s:26:\"taxonomy-post_tag-ptparent\";i:0;s:21:\"title-tax-post_format\";s:57:\"Archives des %%term_title%% %%page%% %%sep%% %%sitename%%\";s:24:\"metadesc-tax-post_format\";s:0:\"\";s:31:\"display-metabox-tax-post_format\";b:1;s:23:\"noindex-tax-post_format\";b:1;s:28:\"social-title-tax-post_format\";s:27:\"Archives des %%term_title%%\";s:34:\"social-description-tax-post_format\";s:0:\"\";s:32:\"social-image-url-tax-post_format\";s:0:\"\";s:31:\"social-image-id-tax-post_format\";i:0;s:29:\"taxonomy-post_format-ptparent\";i:0;s:14:\"person_logo_id\";i:0;s:15:\"company_logo_id\";i:0;s:17:\"company_logo_meta\";b:0;s:16:\"person_logo_meta\";b:0;s:29:\"open_graph_frontpage_image_id\";i:0;}","auto"),
("2046","wpseo_social","a:20:{s:13:\"facebook_site\";s:0:\"\";s:13:\"instagram_url\";s:0:\"\";s:12:\"linkedin_url\";s:0:\"\";s:11:\"myspace_url\";s:0:\"\";s:16:\"og_default_image\";s:0:\"\";s:19:\"og_default_image_id\";s:0:\"\";s:18:\"og_frontpage_title\";s:0:\"\";s:17:\"og_frontpage_desc\";s:0:\"\";s:18:\"og_frontpage_image\";s:0:\"\";s:21:\"og_frontpage_image_id\";s:0:\"\";s:9:\"opengraph\";b:1;s:13:\"pinterest_url\";s:0:\"\";s:15:\"pinterestverify\";s:0:\"\";s:7:\"twitter\";b:1;s:12:\"twitter_site\";s:0:\"\";s:17:\"twitter_card_type\";s:19:\"summary_large_image\";s:11:\"youtube_url\";s:0:\"\";s:13:\"wikipedia_url\";s:0:\"\";s:17:\"other_social_urls\";a:0:{}s:12:\"mastodon_url\";s:0:\"\";}","auto"),
("2105","cookie_notice_options","a:47:{s:15:\"global_override\";b:0;s:13:\"global_cookie\";b:0;s:6:\"app_id\";s:0:\"\";s:7:\"app_key\";s:0:\"\";s:12:\"app_blocking\";b:1;s:18:\"conditional_active\";b:0;s:19:\"conditional_display\";s:4:\"hide\";s:17:\"conditional_rules\";a:0:{}s:11:\"amp_support\";b:0;s:13:\"bot_detection\";b:1;s:21:\"caching_compatibility\";b:1;s:10:\"debug_mode\";b:0;s:8:\"position\";s:6:\"bottom\";s:12:\"message_text\";s:175:\"Nous utilisons des cookies pour vous garantir la meilleure expérience sur notre site web. Si vous continuez à utiliser ce site, nous supposerons que vous en êtes satisfait.\";s:9:\"css_class\";s:0:\"\";s:11:\"accept_text\";s:2:\"OK\";s:11:\"refuse_text\";s:3:\"Non\";s:10:\"refuse_opt\";b:0;s:11:\"refuse_code\";s:0:\"\";s:16:\"refuse_code_head\";s:0:\"\";s:14:\"revoke_cookies\";b:0;s:18:\"revoke_cookies_opt\";s:9:\"automatic\";s:19:\"revoke_message_text\";s:113:\"Vous pouvez révoquer votre consentement à tout moment en utilisant le bouton « Révoquer le consentement ».\";s:11:\"revoke_text\";s:25:\"Révoquer le consentement\";s:11:\"redirection\";b:0;s:8:\"see_more\";b:0;s:11:\"link_target\";s:6:\"_blank\";s:13:\"link_position\";s:6:\"banner\";s:4:\"time\";s:5:\"month\";s:13:\"time_rejected\";s:5:\"month\";s:11:\"hide_effect\";s:4:\"fade\";s:9:\"on_scroll\";b:0;s:16:\"on_scroll_offset\";i:100;s:8:\"on_click\";b:0;s:6:\"colors\";a:4:{s:4:\"text\";s:4:\"#fff\";s:6:\"button\";s:7:\"#00a99d\";s:3:\"bar\";s:7:\"#32323a\";s:11:\"bar_opacity\";i:100;}s:12:\"see_more_opt\";a:5:{s:4:\"text\";s:29:\"Politique de confidentialité\";s:9:\"link_type\";s:4:\"page\";s:2:\"id\";i:0;s:4:\"link\";s:0:\"\";s:4:\"sync\";b:0;}s:16:\"script_placement\";s:6:\"header\";s:9:\"translate\";b:0;s:19:\"deactivation_delete\";b:0;s:13:\"review_notice\";b:1;s:19:\"review_notice_delay\";i:0;s:14:\"update_version\";i:13;s:13:\"update_notice\";b:1;s:18:\"update_notice_diss\";b:0;s:17:\"update_delay_date\";i:0;s:21:\"update_threshold_date\";i:0;s:10:\"csp_notice\";b:0;}","off"),
("2106","cookie_notice_privacy_consent","a:10:{s:16:\"wordpress_active\";b:1;s:21:\"wordpress_active_type\";s:3:\"all\";s:19:\"contactform7_active\";b:0;s:24:\"contactform7_active_type\";s:3:\"all\";s:16:\"mailchimp_active\";b:0;s:21:\"mailchimp_active_type\";s:3:\"all\";s:14:\"wpforms_active\";b:0;s:19:\"wpforms_active_type\";s:3:\"all\";s:18:\"woocommerce_active\";b:0;s:23:\"woocommerce_active_type\";s:3:\"all\";}","off"),
("2107","cookie_notice_status","a:4:{s:6:\"status\";s:0:\"\";s:12:\"subscription\";s:5:\"basic\";s:18:\"threshold_exceeded\";b:0;s:19:\"activation_datetime\";i:0;}","off"),
("2108","cookie_notice_version","2.5.7","off"),
("2126","frm_strp_options","O:8:\"stdClass\":2:{s:9:\"test_mode\";i:1;s:18:\"processing_message\";s:58:\"Le traitement de ce paiement peut prendre plusieurs jours.\";}","auto"),
("2128","widget_frm_show_form","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("2129","frm_options","O:11:\"FrmSettings\":38:{s:11:\"option_name\";s:11:\"frm_options\";s:4:\"menu\";N;s:7:\"mu_menu\";N;s:9:\"fade_form\";N;s:9:\"admin_bar\";N;s:11:\"success_msg\";N;s:9:\"blank_msg\";N;s:10:\"unique_msg\";N;s:11:\"invalid_msg\";N;s:10:\"failed_msg\";N;s:12:\"submit_value\";N;s:9:\"login_msg\";N;s:16:\"admin_permission\";N;s:8:\"email_to\";N;s:10:\"load_style\";N;s:12:\"custom_style\";N;s:14:\"active_captcha\";N;s:6:\"pubkey\";N;s:7:\"privkey\";N;s:7:\"re_lang\";N;s:7:\"re_type\";N;s:6:\"re_msg\";N;s:8:\"re_multi\";N;s:12:\"re_threshold\";N;s:15:\"hcaptcha_pubkey\";N;s:16:\"hcaptcha_privkey\";N;s:16:\"turnstile_pubkey\";N;s:17:\"turnstile_privkey\";N;s:6:\"no_ips\";N;s:16:\"custom_header_ip\";N;s:12:\"current_form\";i:0;s:8:\"tracking\";N;s:14:\"summary_emails\";N;s:25:\"summary_emails_recipients\";N;s:13:\"default_email\";N;s:10:\"from_email\";N;s:8:\"currency\";N;s:10:\"custom_css\";N;}","on"),
("2130","frm_inbox_cache","a:3:{s:7:\"timeout\";i:1754266276;s:5:\"value\";s:3276:\"{\"0\":{\"key\":\"videos\",\"subject\":\"Did you know?\",\"message\":\"There\'s a growing collection of great video tutorials ready for you! Have a request? Let us know! Don\'t forget to subscribe so you\'ll hear about new videos too.\",\"cta\":\"<a href=\\\"https:\\/\\/formidableforms.com\\/knowledgebase\\/latest-videos\\/?utm_source=WordPress&utm_medium=inbox&utm_campaign=liteplugin&utm_content=videos\\\" class=\\\"button-primary frm-button-primary\\\" target=\\\"_blank\\\" rel=\\\"noopener noreferrer\\\">Learn More<\\/a> <a href=\\\"#\\\" class=\\\"button-secondary frm-button-secondary frm_inbox_dismiss\\\">Dismiss<\\/a>\",\"icon\":\"frm_support_icon\",\"starts\":\"\",\"type\":\"news\",\"who\":[\"all\"]},\"1\":{\"key\":\"free-welcome60-d1-v3\",\"subject\":\"Welcome to Formidable Forms!\",\"message\":\"Thank you for using Formidable Forms. To show our appreciation, we\'d love to give you a welcome offer of 60% Formidable Forms Pro! Get access to our powerful application builder, conditional logic, conversational forms and more!\",\"cta\":\"<a href=\\\"https:\\/\\/formidableforms.com\\/go\\/zj7r?utm_source=WordPress&utm_medium=inbox&utm_campaign=liteplugin&utm_content=free-welcome60-d1-v3\\\" class=\\\"button-primary frm-button-primary\\\" target=\\\"_blank\\\" rel=\\\"noopener noreferrer\\\">Save 60%<\\/a> <a href=\\\"#\\\" class=\\\"button-secondary frm-button-secondary frm_inbox_dismiss\\\">Dismiss<\\/a>\",\"icon\":\"frm_price_tags_icon\",\"starts\":1752624000,\"expires\":1906502400,\"type\":\"promo\",\"who\":[\"free_first_30\"],\"slidein\":\"Try Pro for 60% off\"},\"2\":{\"key\":\"email-graphs-pro\",\"subject\":\"&#91;New] Graphs in Emails!\",\"message\":\"Place graphs of your data on more than just websites! With our new \\\"image\\\" format option, you can now put charts and graphs inside emails and PDFs. And don\'t worry, you can still customize graph types, change colors, and more! Just choose \\\"image\\\" on the new \\\"format\\\" dropdown and let our plugin do the rest!\",\"cta\":\"<a href=\\\"https:\\/\\/formidableforms.com\\/add-charts-and-graphs-in-emails-pdfs-with-formidable-forms\\/?utm_source=WordPress&utm_medium=inbox&utm_campaign=liteplugin&utm_content=email-graphs-pro\\\" class=\\\"button-primary frm-button-primary\\\" target=\\\"_blank\\\" rel=\\\"noopener noreferrer\\\">Read more<\\/a> <a href=\\\"#\\\" class=\\\"button-secondary frm-button-secondary frm_inbox_dismiss\\\">Dismiss<\\/a>\",\"icon\":\"frm_tooltip_icon\",\"starts\":1752451200,\"expires\":1754870400,\"type\":\"news\",\"who\":[\"business\",\"elite\"]},\"3\":{\"key\":\"email-graphs\",\"subject\":\"&#91;New] Graphs in Emails!\",\"message\":\"Place graphs of your data on more than just websites! With our new \\\"image\\\" format option, you can now put charts and graphs inside emails and PDFs. And don\'t worry, you can still customize graph types, change colors, and more!\\r\",\"\\r\":null,\"Upgrade to Business and try it out today!\":null,\"cta\":\"<a href=\\\"https:\\/\\/formidableforms.com\\/add-charts-and-graphs-in-emails-pdfs-with-formidable-forms\\/?utm_source=WordPress&utm_medium=inbox&utm_campaign=liteplugin&utm_content=email-graphs\\\" class=\\\"button-primary frm-button-primary\\\" target=\\\"_blank\\\" rel=\\\"noopener noreferrer\\\">Read more<\\/a> <a href=\\\"#\\\" class=\\\"button-secondary frm-button-secondary frm_inbox_dismiss\\\">Dismiss<\\/a>\",\"icon\":\"frm_tooltip_icon\",\"starts\":1752451200,\"expires\":1754870400,\"type\":\"news\",\"who\":[\"free\",\"basic\",\"personal\",\"expired\"]},\"response_code\":200}\";s:7:\"version\";s:6:\"6.22.3\";}","off"),
("2131","frm_inbox","a:15:{s:6:\"videos\";a:10:{s:7:\"message\";s:160:\"There\'s a growing collection of great video tutorials ready for you! Have a request? Let us know! Don\'t forget to subscribe so you\'ll hear about new videos too.\";s:7:\"subject\";s:13:\"Did you know?\";s:4:\"icon\";s:16:\"frm_support_icon\";s:3:\"cta\";s:334:\"<a href=\"https://formidableforms.com/knowledgebase/latest-videos/?utm_source=WordPress&utm_medium=inbox&utm_campaign=liteplugin&utm_content=videos\" class=\"button-primary frm-button-primary\" target=\"_blank\" rel=\"noopener noreferrer\">Learn More</a> <a href=\"#\" class=\"button-secondary frm-button-secondary frm_inbox_dismiss\">Dismiss</a>\";s:7:\"expires\";b:0;s:3:\"who\";a:1:{i:0;s:3:\"all\";}s:4:\"type\";s:4:\"news\";s:3:\"key\";s:6:\"videos\";s:6:\"starts\";s:0:\"\";s:7:\"created\";i:1743177958;}s:17:\"free-welcome60-d4\";a:11:{s:7:\"message\";s:168:\"More power, more features, more form conversions! Get payment integrations, automation, and priority support with 60% off Pro. Limited-time new user deal—grab it now!\";s:7:\"subject\";s:24:\"3 Reasons to Upgrade Now\";s:4:\"icon\";s:19:\"frm_price_tags_icon\";s:3:\"cta\";s:329:\"<a href=\"https://formidableforms.com/go/xjk2?utm_source=WordPress&utm_medium=inbox&utm_campaign=liteplugin&utm_content=free-welcome60-d4\" class=\"button-primary frm-button-primary\" target=\"_blank\" rel=\"noopener noreferrer\">Claim My Offer!</a> <a href=\"#\" class=\"button-secondary frm-button-secondary frm_inbox_dismiss\">Dismiss</a>\";s:7:\"expires\";i:1896134400;s:3:\"who\";a:1:{i:0;s:14:\"free_first_4_7\";}s:4:\"type\";s:5:\"promo\";s:3:\"key\";s:17:\"free-welcome60-d4\";s:6:\"starts\";i:1739836800;s:7:\"slidein\";s:23:\"Don\'t Miss 60% Off Pro!\";s:7:\"created\";i:1743177958;}s:17:\"free-welcome60-d2\";a:11:{s:7:\"message\";s:163:\"Formidable Forms Pro gives you advanced features to save time and build better forms. As a new user, you can upgrade now with 60% off, but this offer won’t last.\";s:7:\"subject\";s:27:\"Build Forms Faster with Pro\";s:4:\"icon\";s:19:\"frm_price_tags_icon\";s:3:\"cta\";s:329:\"<a href=\"https://formidableforms.com/go/vylq?utm_source=WordPress&utm_medium=inbox&utm_campaign=liteplugin&utm_content=free-welcome60-d2\" class=\"button-primary frm-button-primary\" target=\"_blank\" rel=\"noopener noreferrer\">Claim My Offer!</a> <a href=\"#\" class=\"button-secondary frm-button-secondary frm_inbox_dismiss\">Dismiss</a>\";s:7:\"expires\";i:1896134400;s:3:\"who\";a:1:{i:0;s:14:\"free_first_2_3\";}s:4:\"type\";s:5:\"promo\";s:3:\"key\";s:17:\"free-welcome60-d2\";s:6:\"starts\";i:1739836800;s:7:\"slidein\";s:33:\"New Users Only: 60% Off Ends Soon\";s:7:\"created\";i:1743177958;}s:17:\"free-welcome60-d8\";a:11:{s:7:\"message\";s:205:\"Only new users get this 60% off Pro deal, and it won’t be around for long. Upgrade now to unlock hundreds of professional form templates, calculators, surveys &amp; polls, premium support, and much more.\";s:7:\"subject\";s:33:\"Your Exclusive 60% Off Ends Soon!\";s:4:\"icon\";s:19:\"frm_price_tags_icon\";s:3:\"cta\";s:329:\"<a href=\"https://formidableforms.com/go/ixix?utm_source=WordPress&utm_medium=inbox&utm_campaign=liteplugin&utm_content=free-welcome60-d8\" class=\"button-primary frm-button-primary\" target=\"_blank\" rel=\"noopener noreferrer\">Claim My Offer!</a> <a href=\"#\" class=\"button-secondary frm-button-secondary frm_inbox_dismiss\">Dismiss</a>\";s:7:\"expires\";i:1896134400;s:3:\"who\";a:1:{i:0;s:15:\"free_first_8_11\";}s:4:\"type\";s:5:\"promo\";s:3:\"key\";s:17:\"free-welcome60-d8\";s:6:\"starts\";i:1739836800;s:7:\"slidein\";s:38:\"Don\'t Miss Out on Formidable Forms Pro\";s:7:\"created\";i:1743177958;}s:18:\"free-welcome60-d12\";a:10:{s:7:\"message\";s:153:\"High-converting forms = more leads, more sales, more success. Get 60% off Formidable Forms Pro and turn visitors into customers! Last chance to save big!\";s:7:\"subject\";s:36:\"Forms That Convert – Upgrade Today\";s:4:\"icon\";s:19:\"frm_price_tags_icon\";s:3:\"cta\";s:330:\"<a href=\"https://formidableforms.com/go/kp8y?utm_source=WordPress&utm_medium=inbox&utm_campaign=liteplugin&utm_content=free-welcome60-d12\" class=\"button-primary frm-button-primary\" target=\"_blank\" rel=\"noopener noreferrer\">Claim My Offer!</a> <a href=\"#\" class=\"button-secondary frm-button-secondary frm_inbox_dismiss\">Dismiss</a>\";s:7:\"expires\";i:1896134400;s:3:\"who\";a:1:{i:0;s:16:\"free_first_12_19\";}s:4:\"type\";s:5:\"promo\";s:3:\"key\";s:18:\"free-welcome60-d12\";s:6:\"starts\";i:1739836800;s:7:\"created\";i:1743177958;}s:18:\"free-welcome60-d20\";a:11:{s:7:\"message\";s:161:\"Don\'t miss the last chance to claim 60% off Formidable Forms Pro. Upgrade now for advanced form features, automation, and premium support before it’s too late!\";s:7:\"subject\";s:37:\"Last Chance – 60% Off for New Users\";s:4:\"icon\";s:19:\"frm_price_tags_icon\";s:3:\"cta\";s:330:\"<a href=\"https://formidableforms.com/go/j4ks?utm_source=WordPress&utm_medium=inbox&utm_campaign=liteplugin&utm_content=free-welcome60-d20\" class=\"button-primary frm-button-primary\" target=\"_blank\" rel=\"noopener noreferrer\">Claim My Offer!</a> <a href=\"#\" class=\"button-secondary frm-button-secondary frm_inbox_dismiss\">Dismiss</a>\";s:7:\"expires\";i:1896134400;s:3:\"who\";a:1:{i:0;s:16:\"free_first_20_30\";}s:4:\"type\";s:5:\"promo\";s:3:\"key\";s:18:\"free-welcome60-d20\";s:6:\"starts\";i:1739836800;s:7:\"slidein\";s:36:\"Final Call for Formidable Forms Pro!\";s:7:\"created\";i:1743177958;}s:5:\"usage\";a:9:{s:7:\"message\";s:544:\"Gathering usage data allows us to improve Formidable. Your forms will be considered as we evaluate new features, judge the quality of an update, or determine if an improvement makes sense. You can always visit the <a href=\"https://creakonect.com/wp-admin/admin.php?page=formidable-settings&#038;t=misc_settings\">Global Settings</a> and choose to stop sharing data. <a href=\"https://formidableforms.com/knowledgebase/global-settings-overview/#kb-usage-tracking\" target=\"_blank\" rel=\"noopener noreferrer\">Read more about what data we collect</a>.\";s:7:\"subject\";s:67:\"Aidez Formidable à s’améliorer avec le suivi de l’utilisation\";s:4:\"icon\";s:16:\"frm_tooltip_icon\";s:3:\"cta\";s:256:\"<a href=\"#\" class=\"frm-button-secondary frm_inbox_dismiss\">Dismiss</a> <a href=\"https://creakonect.com/wp-admin/admin.php?page=formidable-settings&#038;t=misc_settings\" class=\"button-primary frm-button-primary frm_inbox_dismiss\">Activate usage tracking</a>\";s:7:\"expires\";b:0;s:3:\"who\";s:3:\"all\";s:4:\"type\";s:8:\"feedback\";s:3:\"key\";s:5:\"usage\";s:7:\"created\";i:1743184675;}s:14:\"free-welcome60\";a:11:{s:7:\"message\";s:228:\"Thank you for using Formidable Forms. To show our appreciation, we\'d love to give you a welcome offer of 60% Formidable Forms Pro! Get access to our powerful application builder, conditional logic, conversational forms and more!\";s:7:\"subject\";s:30:\"Welcome Offer — 60% off Pro!\";s:4:\"icon\";s:19:\"frm_price_tags_icon\";s:3:\"cta\";s:326:\"<a href=\"https://formidableforms.com/go/zj7r?utm_source=WordPress&utm_medium=inbox&utm_campaign=liteplugin&utm_content=free-welcome60\" class=\"button-primary frm-button-primary\" target=\"_blank\" rel=\"noopener noreferrer\">Claim My Offer!</a> <a href=\"#\" class=\"button-secondary frm-button-secondary frm_inbox_dismiss\">Dismiss</a>\";s:7:\"expires\";i:1801440000;s:3:\"who\";a:1:{i:0;s:13:\"free_first_30\";}s:4:\"type\";s:5:\"promo\";s:3:\"key\";s:14:\"free-welcome60\";s:6:\"starts\";i:1739145600;s:7:\"slidein\";s:20:\"Get 60% Off Pro Now!\";s:7:\"created\";i:1745062822;}s:17:\"free-welcome60-d1\";a:11:{s:7:\"message\";s:159:\"Thanks for installing Formidable Forms! As a new user, you get 60% off Pro for a limited time. This special offer ends soon — upgrade now before it’s gone.\";s:7:\"subject\";s:35:\"Exclusive 60% Off Pro for New Users\";s:4:\"icon\";s:19:\"frm_price_tags_icon\";s:3:\"cta\";s:329:\"<a href=\"https://formidableforms.com/go/zj7r?utm_source=WordPress&utm_medium=inbox&utm_campaign=liteplugin&utm_content=free-welcome60-d1\" class=\"button-primary frm-button-primary\" target=\"_blank\" rel=\"noopener noreferrer\">Claim My Offer!</a> <a href=\"#\" class=\"button-secondary frm-button-secondary frm_inbox_dismiss\">Dismiss</a>\";s:7:\"expires\";i:1772236800;s:3:\"who\";a:1:{i:0;s:12:\"free_first_1\";}s:4:\"type\";s:5:\"promo\";s:3:\"key\";s:17:\"free-welcome60-d1\";s:6:\"starts\";i:1739577600;s:7:\"slidein\";s:30:\"Welcome Offer — 60% off Pro!\";s:7:\"created\";i:1745333703;}s:16:\"email-graphs-pro\";a:10:{s:7:\"message\";s:307:\"Place graphs of your data on more than just websites! With our new \"image\" format option, you can now put charts and graphs inside emails and PDFs. And don\'t worry, you can still customize graph types, change colors, and more! Just choose \"image\" on the new \"format\" dropdown and let our plugin do the rest!\";s:7:\"subject\";s:27:\"&#91;New] Graphs in Emails!\";s:4:\"icon\";s:16:\"frm_tooltip_icon\";s:3:\"cta\";s:374:\"<a href=\"https://formidableforms.com/add-charts-and-graphs-in-emails-pdfs-with-formidable-forms/?utm_source=WordPress&utm_medium=inbox&utm_campaign=liteplugin&utm_content=email-graphs-pro\" class=\"button-primary frm-button-primary\" target=\"_blank\" rel=\"noopener noreferrer\">Read more</a> <a href=\"#\" class=\"button-secondary frm-button-secondary frm_inbox_dismiss\">Dismiss</a>\";s:7:\"expires\";i:1754870400;s:3:\"who\";a:2:{i:0;s:8:\"business\";i:1;s:5:\"elite\";}s:4:\"type\";s:4:\"news\";s:3:\"key\";s:16:\"email-graphs-pro\";s:6:\"starts\";i:1752451200;s:7:\"created\";i:1752544861;}s:12:\"email-graphs\";a:12:{s:7:\"message\";s:227:\"Place graphs of your data on more than just websites! With our new \"image\" format option, you can now put charts and graphs inside emails and PDFs. And don\'t worry, you can still customize graph types, change colors, and more!\r\";s:7:\"subject\";s:27:\"&#91;New] Graphs in Emails!\";s:4:\"icon\";s:16:\"frm_tooltip_icon\";s:3:\"cta\";s:370:\"<a href=\"https://formidableforms.com/add-charts-and-graphs-in-emails-pdfs-with-formidable-forms/?utm_source=WordPress&utm_medium=inbox&utm_campaign=liteplugin&utm_content=email-graphs\" class=\"button-primary frm-button-primary\" target=\"_blank\" rel=\"noopener noreferrer\">Read more</a> <a href=\"#\" class=\"button-secondary frm-button-secondary frm_inbox_dismiss\">Dismiss</a>\";s:7:\"expires\";i:1754870400;s:3:\"who\";a:4:{i:0;s:4:\"free\";i:1;s:5:\"basic\";i:2;s:8:\"personal\";i:3;s:7:\"expired\";}s:4:\"type\";s:4:\"news\";s:3:\"key\";s:12:\"email-graphs\";s:1:\"\r\";N;s:41:\"Upgrade to Business and try it out today!\";N;s:6:\"starts\";i:1752451200;s:7:\"created\";i:1752544861;}s:20:\"free-welcome60-d1-v2\";a:11:{s:7:\"message\";s:228:\"Thank you for using Formidable Forms. To show our appreciation, we\'d love to give you a welcome offer of 60% Formidable Forms Pro! Get access to our powerful application builder, conditional logic, conversational forms and more!\";s:7:\"subject\";s:28:\"Welcome to Formidable Forms!\";s:4:\"icon\";s:19:\"frm_price_tags_icon\";s:3:\"cta\";s:325:\"<a href=\"https://formidableforms.com/go/zj7r?utm_source=WordPress&utm_medium=inbox&utm_campaign=liteplugin&utm_content=free-welcome60-d1-v2\" class=\"button-primary frm-button-primary\" target=\"_blank\" rel=\"noopener noreferrer\">Save 60%</a> <a href=\"#\" class=\"button-secondary frm-button-secondary frm_inbox_dismiss\">Dismiss</a>\";s:7:\"expires\";i:1906502400;s:3:\"who\";a:1:{i:0;s:12:\"free_first_1\";}s:4:\"type\";s:5:\"promo\";s:3:\"key\";s:20:\"free-welcome60-d1-v2\";s:6:\"starts\";i:1752624000;s:7:\"slidein\";s:19:\"Try Pro for 60% off\";s:7:\"created\";i:1752712775;}s:22:\"free-welcome60-d2-3-v3\";a:11:{s:7:\"message\";s:138:\"Build quizzes, calculators, and advanced workflows that Lite can’t touch. Upgrade now and get 60% off your first year of Formidable Pro.\";s:7:\"subject\";s:37:\"Go Beyond Basic Forms — Now 60% Off\";s:4:\"icon\";s:0:\"\";s:3:\"cta\";s:341:\"<a href=\"https://formidableforms.com/go/vylq?utm_source=WordPress&utm_medium=inbox&utm_campaign=liteplugin&utm_content=free-welcome60-d2-3-v3\" class=\"button-primary frm-button-primary\" target=\"_blank\" rel=\"noopener noreferrer\">Upgrade &amp; Save 60%</a> <a href=\"#\" class=\"button-secondary frm-button-secondary frm_inbox_dismiss\">Dismiss</a>\";s:7:\"expires\";i:1910476800;s:3:\"who\";a:1:{i:0;s:14:\"free_first_2_3\";}s:4:\"type\";s:5:\"promo\";s:3:\"key\";s:22:\"free-welcome60-d2-3-v3\";s:6:\"starts\";i:1752624000;s:7:\"slidein\";s:35:\"Don\'t miss this limited time offer!\";s:7:\"created\";i:1752712775;}s:20:\"free-welcome60-d4-v2\";a:10:{s:7:\"message\";s:239:\"You’ve had a few days to explore Formidable — ready to level up? Pro unlocks powerful features like conditional logic, file uploads, and integrations that save you time and impress your visitors. Right now, you can upgrade for 60% off.\";s:7:\"subject\";s:38:\"Building Something Great? We Can Help.\";s:4:\"icon\";s:19:\"frm_price_tags_icon\";s:3:\"cta\";s:328:\"<a href=\"https://formidableforms.com/go/xjk2?utm_source=WordPress&utm_medium=inbox&utm_campaign=liteplugin&utm_content=free-welcome60-d4-v2\" class=\"button-primary frm-button-primary\" target=\"_blank\" rel=\"noopener noreferrer\">Get 60% Off</a> <a href=\"#\" class=\"button-secondary frm-button-secondary frm_inbox_dismiss\">Dismiss</a>\";s:7:\"expires\";i:1910476800;s:3:\"who\";a:1:{i:0;s:14:\"free_first_4_7\";}s:4:\"type\";s:5:\"promo\";s:3:\"key\";s:20:\"free-welcome60-d4-v2\";s:6:\"starts\";i:1752624000;s:7:\"created\";i:1752712775;}s:20:\"free-welcome60-d1-v3\";a:11:{s:7:\"message\";s:228:\"Thank you for using Formidable Forms. To show our appreciation, we\'d love to give you a welcome offer of 60% Formidable Forms Pro! Get access to our powerful application builder, conditional logic, conversational forms and more!\";s:7:\"subject\";s:28:\"Welcome to Formidable Forms!\";s:4:\"icon\";s:19:\"frm_price_tags_icon\";s:3:\"cta\";s:325:\"<a href=\"https://formidableforms.com/go/zj7r?utm_source=WordPress&utm_medium=inbox&utm_campaign=liteplugin&utm_content=free-welcome60-d1-v3\" class=\"button-primary frm-button-primary\" target=\"_blank\" rel=\"noopener noreferrer\">Save 60%</a> <a href=\"#\" class=\"button-secondary frm-button-secondary frm_inbox_dismiss\">Dismiss</a>\";s:7:\"expires\";i:1906502400;s:3:\"who\";a:1:{i:0;s:13:\"free_first_30\";}s:4:\"type\";s:5:\"promo\";s:3:\"key\";s:20:\"free-welcome60-d1-v3\";s:6:\"starts\";i:1752624000;s:7:\"slidein\";s:19:\"Try Pro for 60% off\";s:7:\"created\";i:1753026794;}}","off");

INSERT IGNORE INTO `wp_options` VALUES 
("2132","frm_sales_cache","a:3:{s:7:\"timeout\";i:1754266277;s:5:\"value\";s:4012:\"{\"0\":{\"key\":\"menu-link-fix\",\"starts\":1740096000,\"expires\":1745971200,\"who\":[\"all\"],\"discount_percent\":50,\"test_group\":\"\",\"lite_banner_cta_link\":\"\",\"lite_banner_cta_text\":\"\",\"menu_cta_link\":\"https:\\/\\/formidableforms.com\\/lite-upgrade\\/?utm_source=WordPress&utm_medium=upgrade&utm_campaign=liteplugin&utm_content=submenu-upgrade\",\"menu_cta_text\":\"\",\"dashboard_license_cta_link\":\"\",\"dashboard_license_cta_text\":\"\",\"global_settings_license_cta_link\":\"\",\"global_settings_license_cta_text\":\"\",\"global_settings_unlock_more_cta_link\":\"\",\"global_settings_unlock_more_cta_text\":\"\",\"global_settings_upgrade_cta_link\":\"\",\"footer_cta_link\":\"\",\"footer_cta_text\":\"\",\"plugin_page_cta_link\":\"\",\"plugin_page_cta_text\":\"\",\"pro_tip_cta_link\":\"\",\"pro_tip_cta_text\":\"\",\"banner_title\":\"\",\"banner_icon\":\"\",\"banner_body\":\"\",\"banner_text_color\":\"\",\"banner_bg_color\":\"\",\"banner_cta_link\":\"\",\"banner_cta_text\":\"\",\"banner_cta_text_color\":\"\",\"banner_cta_bg_color\":\"\"},\"1\":{\"key\":\"spring-sale-2025\",\"starts\":1745884800,\"expires\":1746748800,\"who\":[\"free\",\"basic\",\"personal\",\"business\"],\"discount_percent\":60,\"test_group\":\"\",\"lite_banner_cta_link\":\"https:\\/\\/formidableforms.com\\/lite-upgrade\\/\",\"lite_banner_cta_text\":\"upgrading for 60% off during our Spring Sale!\",\"menu_cta_link\":\"https:\\/\\/formidableforms.com\\/lite-upgrade\\/\",\"menu_cta_text\":\"Spring Sale!\",\"dashboard_license_cta_link\":\"https:\\/\\/formidableforms.com\\/lite-upgrade\\/\",\"dashboard_license_cta_text\":\"Get 60% Off Pro\",\"global_settings_license_cta_link\":\"https:\\/\\/formidableforms.com\\/lite-upgrade\\/\",\"global_settings_license_cta_text\":\"Get 60% Off Pro\",\"global_settings_unlock_more_cta_link\":\"https:\\/\\/formidableforms.com\\/lite-upgrade\\/\",\"global_settings_unlock_more_cta_text\":\"upgrading for 60% off during our Spring Sale!\",\"global_settings_upgrade_cta_link\":\"https:\\/\\/formidableforms.com\\/lite-upgrade\\/\",\"footer_cta_link\":\"https:\\/\\/formidableforms.com\\/lite-upgrade\\/\",\"footer_cta_text\":\"Get 60% Off Pro\",\"plugin_page_cta_link\":\"https:\\/\\/formidableforms.com\\/lite-upgrade\\/\",\"plugin_page_cta_text\":\"60% Off Sale\",\"pro_tip_cta_link\":\"\",\"pro_tip_cta_text\":\"\",\"banner_title\":\"Formidable Forms Spring Sale \\u2013 Save 60% Now\",\"banner_icon\":\"\",\"banner_body\":\"Spring promotion: claim 60% off the most powerful WordPress form plugin available.\",\"banner_text_color\":\"\",\"banner_bg_color\":\"\",\"banner_cta_link\":\"https:\\/\\/formidableforms.com\\/lite-upgrade\\/\",\"banner_cta_text\":\"\",\"banner_cta_text_color\":\"\",\"banner_cta_bg_color\":\"\"},\"2\":{\"key\":\"summer-silent-2025\",\"starts\":1750550400,\"expires\":1751155200,\"who\":[\"free\",\"basic\",\"personal\",\"business\",\"expired\"],\"discount_percent\":60,\"test_group\":\"\",\"lite_banner_cta_link\":\"https:\\/\\/formidableforms.com\\/go\\/j2v6\",\"lite_banner_cta_text\":\"upgrading (this week only) for 60% off!\",\"menu_cta_link\":\"https:\\/\\/formidableforms.com\\/go\\/j2v6\",\"menu_cta_text\":\"60% Off Sale!\",\"dashboard_license_cta_link\":\"https:\\/\\/formidableforms.com\\/go\\/j2v6\",\"dashboard_license_cta_text\":\"Get 60% Off Pro\",\"global_settings_license_cta_link\":\"https:\\/\\/formidableforms.com\\/go\\/j2v6\",\"global_settings_license_cta_text\":\"Get 60% Off Pro\",\"global_settings_unlock_more_cta_link\":\"https:\\/\\/formidableforms.com\\/go\\/j2v6\",\"global_settings_unlock_more_cta_text\":\"upgrading (this week only) for 60% off!\",\"global_settings_upgrade_cta_link\":\"https:\\/\\/formidableforms.com\\/go\\/j2v6\",\"footer_cta_link\":\"https:\\/\\/formidableforms.com\\/go\\/j2v6\",\"footer_cta_text\":\"Get 60% Off\",\"plugin_page_cta_link\":\"https:\\/\\/formidableforms.com\\/go\\/j2v6\",\"plugin_page_cta_text\":\"60% Off Sale!\",\"pro_tip_cta_link\":\"https:\\/\\/formidableforms.com\\/go\\/j2v6\",\"pro_tip_cta_text\":\"Get 60% Off Pro!\",\"banner_title\":\"Summer Sale!\",\"banner_icon\":\"summer\",\"banner_body\":\"This week only \\u2014\\u00a0get 60% Elite, Business, and Plus licenses!\",\"banner_text_color\":\"\",\"banner_bg_color\":\"rgba(190, 227, 227, 1)\",\"banner_cta_link\":\"https:\\/\\/formidableforms.com\\/go\\/j2v6\",\"banner_cta_text\":\"Get 60% Off Pro!\",\"banner_cta_text_color\":\"\",\"banner_cta_bg_color\":\"\"},\"response_code\":200}\";s:7:\"version\";s:6:\"6.22.3\";}","off"),
("2133","frm_welcome_redirect","6.19","off"),
("2136","frm_db_version","6.22.3-103","auto"),
("2137","frm_first_activation","1743177959","off"),
("2138","frm_last_style_update","717039","auto"),
("2139","frm_honeypot_class","frm__67e6c8e807bcf","auto"),
("2140","frmpro_css","/* AVERTISSEMENT : Toutes modifications apportées à ce fichier seront perdues lorsque vos réglages de Formidable seront mis à jour. */\n.with_frm_style{--form-width:100%;--form-align:left;--direction:ltr;--fieldset:0px;--fieldset-color:#000000;--fieldset-padding:0px 0px 15px 0px;--fieldset-bg-color:transparent;--title-size:40px;--title-color:#444444;--title-margin-top:10px;--title-margin-bottom:60px;--form-desc-size:14px;--form-desc-color:#98A2B3;--form-desc-margin-top:10px;--form-desc-margin-bottom:25px;--form-desc-padding:0px;--font-size:15px;--label-color:#344054;--weight:normal;--position:none;--align:left;--width:150px;--required-color:#F04438;--required-weight:bold;--label-padding:0px 0px 5px 0px;--description-font-size:12px;--description-color:#667085;--description-weight:normal;--description-style:normal;--description-align:left;--description-margin:0px;--field-font-size:14px;--field-height:36px;--line-height:36px;--field-width:100%;--auto-width:100%;--field-pad:8px 12px;--field-margin:20px;--field-weight:normal;--text-color:#1D2939;--border-color:#D0D5DD;--field-border-width:1px;--field-border-style:solid;--bg-color:#ffffff;--bg-color-active:#ffffff;--border-color-active:#4199FD;--text-color-error:#444444;--bg-color-error:#ffffff;--border-color-error:#F04438;--border-width-error:1px;--border-style-error:solid;--bg-color-disabled:#F9FAFB;--border-color-disabled:#D0D5DD;--text-color-disabled:#667085;--radio-align:block;--check-align:block;--check-font-size:14px;--check-label-color:#1D2939;--check-weight:normal;--section-font-size:18px;--section-color:#344054;--section-weight:bold;--section-pad:32px 0px 3px 0px;--section-mar-top:30px;--section-mar-bottom:30px;--section-bg-color:transparent;--section-border-color:#EAECF0;--section-border-width:1px;--section-border-style:solid;--section-border-loc:-top;--collapse-pos:after;--repeat-icon-color:#ffffff;--submit-font-size:14px;--submit-width:auto;--submit-height:auto;--submit-bg-color:#4199FD;--submit-border-color:#4199FD;--submit-border-width:1px;--submit-text-color:#ffffff;--submit-weight:normal;--submit-border-radius:8px;--submit-margin:10px;--submit-padding:8px 16px;--submit-shadow-color:#eeeeee;--submit-hover-bg-color:#3680D3;--submit-hover-color:#ffffff;--submit-hover-border-color:#3680D3;--submit-active-bg-color:#3680D3;--submit-active-color:#ffffff;--submit-active-border-color:#3680D3;--border-radius:8px;--error-bg:#FEE4E2;--error-border:#F5B8AA;--error-text:#F04438;--error-font-size:14px;--success-bg-color:#DFF0D8;--success-border-color:#D6E9C6;--success-text-color:#468847;--success-font-size:14px;--progress-bg-color:#EAECF0;--progress-color:#1D2939;--progress-active-bg-color:#4199FD;--progress-active-color:#ffffff;--progress-border-color:#EAECF0;--progress-border-size:1px;--progress-size:30px;--base-font-size:15px;--box-shadow:0 1px 2px 0 rgba(18, 18, 23, 0.05);}.frm_hidden,.frm_add_form_row.frm_hidden,.frm_remove_form_row.frm_hidden,.with_frm_style .frm_button.frm_hidden{display:none;}.with_frm_style,.with_frm_style form,.with_frm_style .frm-show-form div.frm_description p{text-align: var(--form-align);}input:-webkit-autofill {-webkit-box-shadow: 0 0 0 30px white inset;}.with_frm_style .frm-show-form div.frm_description p{font-size: var(--form-desc-size);color: var(--form-desc-color);margin-top: var(--form-desc-margin-top);margin-bottom: var(--form-desc-margin-bottom);padding: var(--form-desc-padding);}.with_frm_style fieldset{min-width:0;display: block; }.with_frm_style fieldset fieldset{border:none;margin:0;padding:0;background-color:transparent;}.with_frm_style .frm_form_fields > fieldset{border-width: var(--fieldset);border-style:solid;border-color: var(--fieldset-color);margin:0;padding: var(--fieldset-padding);background-color: var(--fieldset-bg-color);}legend.frm_hidden{display:none !important;}.with_frm_style .frm_form_fields{opacity:1;transition: opacity 0.1s linear;}.with_frm_style .frm_doing_ajax{opacity:.5;}.frm_transparent{color:transparent;}.with_frm_style legend + h3,.with_frm_style h3.frm_form_title{font-size: var(--title-size);color: var(--title-color);margin-top: var(--title-margin-top);margin-bottom: var(--title-margin-bottom);}.with_frm_style .frm_form_field.frm_html_container,.with_frm_style .frm_form_field .frm_show_it{color: var(--form-desc-color);}.with_frm_style .frm_form_field.frm_html_container{font-size: var(--form-desc-size);}.with_frm_style .frm_form_field .frm_show_it{font-size: var(--field-font-size);font-weight: var(--field-weight);}.with_frm_style .frm_required {color: var(--required-color);font-weight: var(--required-weight);}.with_frm_style input[type=text],.with_frm_style input[type=password],.with_frm_style input[type=email],.with_frm_style input[type=number],.with_frm_style input[type=url],.with_frm_style input[type=tel],.with_frm_style input[type=search],.with_frm_style select,.with_frm_style textarea,.with_frm_style .frm-card-element.StripeElement {font-family:var(--font);font-size: var(--field-font-size);margin-bottom:0;}.with_frm_style textarea{vertical-align:top;height:auto;}.with_frm_style input[type=text],.with_frm_style input[type=password],.with_frm_style input[type=email],.with_frm_style input[type=number],.with_frm_style input[type=url],.with_frm_style input[type=tel],.with_frm_style input[type=phone],.with_frm_style input[type=search],.with_frm_style select,.with_frm_style textarea,.frm_form_fields_style,.with_frm_style .frm_scroll_box .frm_opt_container,.frm_form_fields_active_style,.frm_form_fields_error_style,.with_frm_style .frm-card-element.StripeElement,.with_frm_style .frm_slimselect.ss-main {color: var(--text-color);background-color: var(--bg-color);border-color: var(--border-color);border-width: var(--field-border-width);border-style: var(--field-border-style);border-radius: var(--border-radius);width: var(--field-width);max-width: 100%;font-size: var(--field-font-size);padding: var(--field-pad);box-sizing: border-box;outline: none;font-weight: var(--field-weight);}.with_frm_style select option {color: var(--text-color);}.with_frm_style select option.frm-select-placeholder {color: var(--text-color-disabled);}.with_frm_style input[type=radio],.with_frm_style input[type=checkbox]{border-color: var(--border-color);box-shadow: var(--box-shadow);float: none;}.with_frm_style input[type=radio]:after,.with_frm_style input[type=checkbox]:after {display: none; }.with_frm_style input[type=radio]:not(:checked):focus,.with_frm_style input[type=checkbox]:not(:checked):focus {border-color: var(--border-color) !important;}.with_frm_style input[type=radio]:focus,.with_frm_style input[type=checkbox]:focus {box-shadow:0px 0px 0px 3px rgba(65,153,253, 0.4) !important;}.with_frm_style input[type=text],.with_frm_style input[type=password],.with_frm_style input[type=email],.with_frm_style input[type=number],.with_frm_style input[type=url],.with_frm_style input[type=tel],.with_frm_style input[type=file],.with_frm_style input[type=search],.with_frm_style select,.with_frm_style .frm-card-element.StripeElement{min-height: var(--field-height);line-height:1.3;}.with_frm_style select[multiple=multiple]{height:auto;}.input[type=file].frm_transparent:focus,.with_frm_style input[type=file]{background-color:transparent;border:none;outline:none;box-shadow:none;}.with_frm_style input[type=file]{color: var(--text-color);padding: 0px;font-size: var(--field-font-size);display: initial;}.with_frm_style input[type=file].frm_transparent{color:transparent;}.with_frm_style .wp-editor-wrap{width: var(--field-width);max-width:100%;}.with_frm_style .wp-editor-container textarea{border:none;box-shadow:none !important;}.with_frm_style .mceIframeContainer{background-color: var(--bg-color);}.with_frm_style select{width: var(--auto-width);max-width:100%;background-position-y: calc(50% + 3px);}.with_frm_style input[disabled],.with_frm_style select[disabled],.with_frm_style textarea[disabled],.with_frm_style input[readonly],.with_frm_style select[readonly],.with_frm_style textarea[readonly] {background-color: var(--bg-color-disabled);color: var(--text-color-disabled);border-color: var(--border-color-disabled);}.frm_preview_page:before{content:normal !important;}.frm_preview_page{padding:25px;}.with_frm_style .frm_primary_label{max-width:100%;font-size: var(--font-size);color: var(--label-color);font-weight: var(--weight);text-align: var(--align);padding: var(--label-padding);margin:0;width:auto;display:block;}.with_frm_style .frm_top_container .frm_primary_label,.with_frm_style .frm_hidden_container .frm_primary_label,.with_frm_style .frm_pos_top{display:block;float:none;width:auto;}.with_frm_style .frm_inline_container .frm_primary_label{margin-right:10px;}.with_frm_style .frm_right_container .frm_primary_label,.with_frm_style .frm_pos_right{display:inline;float:right;margin-left:10px;}.with_frm_style .frm_pos_center {text-align: center;}.with_frm_style .frm_none_container .frm_primary_label,.with_frm_style .frm_pos_none,.frm_pos_none,.frm_none_container .frm_primary_label{display:none;}.with_frm_style .frm_section_heading.frm_hide_section{margin-top:0 !important;}.with_frm_style .frm_hidden_container .frm_primary_label,.with_frm_style .frm_pos_hidden,.frm_hidden_container .frm_primary_label{visibility:hidden;white-space:nowrap;}.frm_visible{opacity:1;}.with_frm_style .frm_inside_container {position: relative;padding-top: 18px;padding-top: calc(0.5 * var(--field-height));}.with_frm_style .frm_inside_container > input,.with_frm_style .frm_inside_container > select,.with_frm_style .frm_inside_container > textarea {display: block;}.with_frm_style input::placeholder,.with_frm_style textarea::placeholder {font-size: var(--field-font-size);}.with_frm_style .frm_inside_container > input::-moz-placeholder,.with_frm_style .frm_inside_container > textarea::-moz-placeholder {opacity: 0 !important;transition: opacity 0.3s ease-in;}.with_frm_style .frm_inside_container > input:-ms-input-placeholder,.with_frm_style .frm_inside_container > textarea:-ms-input-placeholder {opacity: 0;transition: opacity 0.3s ease-in;}.with_frm_style .frm_inside_container > input::placeholder,.with_frm_style .frm_inside_container > textarea::placeholder {opacity: 0;transition: opacity 0.3s ease-in;}.with_frm_style .frm_inside_container > label {transition: all 0.3s ease-in;position: absolute;top: 19px;top: calc(1px + .5 * var(--field-height));left: 3px;width: 100%;line-height: 1.3;text-overflow: ellipsis;overflow: hidden;white-space: nowrap;padding: 8px 12px;padding: var(--field-pad);font-size: 14px;font-size: var(--field-font-size);font-weight: normal;font-weight: var(--field-weight);pointer-events: none;}.with_frm_style.frm_style_lines-no-boxes .frm_inside_container > label {line-height: 1;}.with_frm_style .frm_inside_container.frm_label_float_top > label {top: 0;left: 0;padding: 0;font-size: 12px;font-size: calc(0.85 * var(--field-font-size));}.with_frm_style .frm_inside_container.frm_label_float_top > input::-moz-placeholder,.with_frm_style .frm_inside_container.frm_label_float_top > textarea::-moz-placeholder {opacity: 1 !important;transition: opacity 0.3s ease-in;}.with_frm_style .frm_inside_container.frm_label_float_top > input:-ms-input-placeholder,.with_frm_style .frm_inside_container.frm_label_float_top > textarea:-ms-input-placeholder {opacity: 1;transition: opacity 0.3s ease-in;}.with_frm_style .frm_inside_container.frm_label_float_top > input::placeholder,.with_frm_style .frm_inside_container.frm_label_float_top > textarea::placeholder {opacity: 1;transition: opacity 0.3s ease-in;}.with_frm_style .frm_description,.with_frm_style .frm_pro_max_limit_desc{clear:both;}.with_frm_style input[type=number][readonly]{-moz-appearance: textfield;}.with_frm_style select[multiple=\"multiple\"]{height:auto;line-height:normal;}.with_frm_style .frm_catlevel_2,.with_frm_style .frm_catlevel_3,.with_frm_style .frm_catlevel_4,.with_frm_style .frm_catlevel_5{margin-left:18px;}.with_frm_style .wp-editor-container{border:1px solid #e5e5e5;}.with_frm_style .quicktags-toolbar input{font-size:12px !important;}.with_frm_style .wp-editor-container textarea{border:none;}.with_frm_style .auto_width #loginform input,.with_frm_style .auto_width input,.with_frm_style input.auto_width,.with_frm_style select.auto_width,.with_frm_style textarea.auto_width{width:auto;}.with_frm_style .frm_repeat_buttons{white-space:nowrap;}.with_frm_style .frm_button{text-decoration:none !important;;border:1px solid #eee;display:inline-block;padding: var(--submit-padding);border-radius:8px;border-radius:var(--border-radius);font-size: var(--submit-font-size);font-weight: var(--submit-weight);color: var(--submit-text-color);background: var(--submit-bg-color);border-width: var(--submit-border-width);border-color: var(--submit-border-color);height: var(--submit-height);}.with_frm_style .frm_button.frm_inverse{color:var(--submit-bg-color);background:var(--submit-text-color);}.with_frm_style .frm_submit{clear:both;}.frm_inline_form .frm_form_field,.frm_inline_form .frm_submit{grid-column: span 1 / span 1;}.frm_inline_form .frm_submit{margin:0;}.frm_submit.frm_inline_submit input[type=submit],.frm_submit.frm_inline_submit button,.frm_inline_form .frm_submit input[type=submit],.frm_inline_form .frm_submit button{margin-top:0;}.with_frm_style.frm_center_submit .frm_submit{text-align:center;}.with_frm_style.frm_center_submit .frm_flex.frm_submit {justify-content: center;}.with_frm_style .frm_inline_success .frm_submit{display: flex;flex-direction: row;align-items: center;margin: 0;}.with_frm_style .frm_inline_success .frm_submit .frm_message{flex: 1;margin: 0;padding-left: 10px;}.with_frm_style .frm_inline_success.frm_alignright_success .frm_submit .frm_message{text-align: right;}.with_frm_style.frm_center_submit .frm_submit input[type=submit],.with_frm_style.frm_center_submit .frm_submit input[type=button],.with_frm_style.frm_center_submit .frm_submit button{margin-bottom:8px !important;}.with_frm_style .frm-edit-page-btn,.with_frm_style .frm_submit input[type=submit],.with_frm_style .frm_submit input[type=button],.with_frm_style .frm_submit button{-webkit-appearance: none;cursor: pointer;}.with_frm_style.frm_center_submit .frm_submit .frm_ajax_loading{display: block;margin: 0 auto;}.with_frm_style .frm_loading_prev .frm_ajax_loading,.with_frm_style .frm_loading_form .frm_ajax_loading{visibility:visible !important;}.with_frm_style .frm_loading_prev .frm_prev_page,.with_frm_style .frm_loading_form .frm_button_submit {position: relative;color: transparent !important;text-shadow: none !important;}.with_frm_style .frm_loading_prev .frm_prev_page:hover,.with_frm_style .frm_loading_prev .frm_prev_page:active,.with_frm_style .frm_loading_prev .frm_prev_page:focus,.with_frm_style .frm_loading_form .frm_button_submit:hover,.with_frm_style .frm_loading_form .frm_button_submit:active,.with_frm_style .frm_loading_form .frm_button_submit:focus {cursor: not-allowed;color: transparent;outline: none !important;box-shadow: none;}.with_frm_style .frm_loading_prev .frm_prev_page::before,.with_frm_style .frm_loading_form .frm_button_submit:before {content: \'\';display: inline-block;position: absolute;background: transparent;border: 1px solid #fff;border-top-color: transparent;border-left-color: transparent;border-radius: 50%;box-sizing: border-box;top: 50%;left: 50%;margin-top: -6px;margin-left: -6px;width: 12px;height: 12px;animation: spin 2s linear infinite;}.with_frm_style .frm_submit.frm_flex {align-items: center;gap: 2%;}.with_frm_style .frm_submit.frm_flex button.frm_button_submit ~ .frm_prev_page {order: -1;}.frm_style_style-formidable.with_frm_style{}.frm_forms.frm_style_style-formidable.with_frm_style{max-width:100%;direction:ltr;}.frm_style_style-formidable.with_frm_style .form-field{margin-bottom:20px;}.frm_style_style-formidable.with_frm_style .form-field.frm_section_heading{margin-bottom:0;}.frm_style_style-formidable.with_frm_style p.description,.frm_style_style-formidable.with_frm_style div.description,.frm_style_style-formidable.with_frm_style div.frm_description,.frm_style_style-formidable.with_frm_style .frm-show-form > div.frm_description,.frm_style_style-formidable.with_frm_style .frm_error,.frm_style_style-formidable.with_frm_style .frm_pro_max_limit_desc{margin:0px;padding:0;font-size:12px;color:#667085;font-weight:normal;text-align:left;font-style:normal;max-width:100%;}.frm_style_style-formidable.with_frm_style .frm_form_field.frm_left_container{grid-template-columns: 150px auto;}.frm_style_style-formidable.with_frm_style .frm_form_field.frm_right_container{grid-template-columns: auto 150px;}.frm_form_field.frm_right_container{grid-template-columns: auto 25%;}.frm_style_style-formidable.with_frm_style .frm_inline_container.frm_dynamic_select_container .frm_data_container,.frm_style_style-formidable.with_frm_style .frm_inline_container.frm_dynamic_select_container .frm_opt_container{display:inline;}.frm_style_style-formidable.with_frm_style .frm_pos_right{display:inline;width:150px;}.frm_style_style-formidable.with_frm_style .frm_none_container .frm_primary_label,.frm_style_style-formidable.with_frm_style .frm_pos_none{display:none;}.frm_style_style-formidable.with_frm_style input::placeholder,.frm_style_style-formidable.with_frm_style textarea::placeholder{color: #667085;}.frm_style_style-formidable.with_frm_style .frm_default,.frm_style_style-formidable.with_frm_style input.frm_default,.frm_style_style-formidable.with_frm_style textarea.frm_default,.frm_style_style-formidable.with_frm_style select.frm_default,.frm_style_style-formidable.with_frm_style .placeholder {color: #667085;}.frm_style_style-formidable.with_frm_style .form-field input:not([type=file]):not([type=range]):not([readonly]):focus,.frm_style_style-formidable.with_frm_style select:focus,.frm_style_style-formidable.with_frm_style .form-field textarea:focus,.frm_style_style-formidable.with_frm_style .frm_focus_field input[type=text],.frm_style_style-formidable.with_frm_style .frm_focus_field input[type=password],.frm_style_style-formidable.with_frm_style .frm_focus_field input[type=email],.frm_style_style-formidable.with_frm_style .frm_focus_field input[type=number],.frm_style_style-formidable.with_frm_style .frm_focus_field input[type=url],.frm_style_style-formidable.with_frm_style .frm_focus_field input[type=tel],.frm_style_style-formidable.with_frm_style .frm_focus_field input[type=search],.frm_form_fields_active_style,.frm_style_style-formidable.with_frm_style .frm_focus_field .frm-card-element.StripeElement {background-color:#ffffff;border-color:#4199FD;color: var(--text-color);box-shadow:0px 0px 5px 0px rgba(65,153,253, 0.6);}.frm_style_style-formidable.with_frm_style .frm_compact .frm_dropzone.dz-clickable .dz-message,.frm_style_style-formidable.with_frm_style input[type=submit],.frm_style_style-formidable.with_frm_style .frm_submit input[type=button],.frm_style_style-formidable.with_frm_style .frm_submit button,.frm_form_submit_style,.frm_style_style-formidable.with_frm_style .frm-edit-page-btn {width:auto;font-size:14px;height:auto;line-height:normal;text-align:center;background:#4199FD;border-width:1px;border-color: #4199FD;border-style:solid;color:#ffffff;cursor:pointer;font-weight:normal;border-radius:8px;text-shadow:none;padding:8px 16px;box-sizing:border-box;box-shadow:0 1px 1px #eeeeee;margin:10px;margin-left:0;margin-right:0;vertical-align:middle;}.frm_style_style-formidable.with_frm_style .frm_compact .frm_dropzone.dz-clickable .dz-message{margin:0;}.frm_style_style-formidable.with_frm_style .frm-edit-page-btn:hover,.frm_style_style-formidable.with_frm_style input[type=submit]:hover,.frm_style_style-formidable.with_frm_style .frm_submit input[type=button]:hover,.frm_style_style-formidable.with_frm_style .frm_submit button:hover{background: #3680D3;border-color: #3680D3;color: #ffffff;}.frm_style_style-formidable.with_frm_style.frm_center_submit .frm_submit .frm_ajax_loading{margin-bottom:10px;}.frm_style_style-formidable.with_frm_style .frm-edit-page-btn:focus,.frm_style_style-formidable.with_frm_style input[type=submit]:focus,.frm_style_style-formidable.with_frm_style .frm_submit input[type=button]:focus,.frm_style_style-formidable.with_frm_style .frm_submit button:focus,.frm_style_style-formidable.with_frm_style input[type=submit]:active,.frm_style_style-formidable.with_frm_style .frm_submit input[type=button]:active,.frm_style_style-formidable.with_frm_style .frm_submit button:active{background: #3680D3;border-color: #3680D3;color: #ffffff;outline: none;}.frm_style_style-formidable.with_frm_style .frm_loading_prev .frm_prev_page,.frm_style_style-formidable.with_frm_style .frm_loading_prev .frm_prev_page:hover,.frm_style_style-formidable.with_frm_style .frm_loading_prev .frm_prev_page:active,.frm_style_style-formidable.with_frm_style .frm_loading_prev .frm_prev_page:focus,.frm_style_style-formidable.with_frm_style .frm_loading_form .frm_button_submit,.frm_style_style-formidable.with_frm_style .frm_loading_form .frm_button_submit:hover,.frm_style_style-formidable.with_frm_style .frm_loading_form .frm_button_submit:active,.frm_style_style-formidable.with_frm_style .frm_loading_form .frm_button_submit:focus{color: transparent ;background: #4199FD;border-color: #4199FD;}.frm_style_style-formidable.with_frm_style .frm_loading_prev .frm_prev_page:before,.frm_style_style-formidable.with_frm_style .frm_loading_form .frm_button_submit:before {border-bottom-color: #ffffff;border-right-color: #ffffff;}.frm_style_style-formidable.with_frm_style.frm_inline_top .frm_submit::before,.frm_style_style-formidable.with_frm_style .frm_submit.frm_inline_submit::before {content:\"before\";font-size:15px;color:#344054;font-weight:normal;margin:0;padding:0px 0px 5px 0px;width:auto;display:block;visibility:hidden;}.frm_style_style-formidable.with_frm_style.frm_inline_form .frm_submit input,.frm_style_style-formidable.with_frm_style.frm_inline_form .frm_submit button,.frm_style_style-formidable.with_frm_style .frm_submit.frm_inline_submit input,.frm_style_style-formidable.with_frm_style .frm_submit.frm_inline_submit button {margin: 0 !important;}.frm_style_style-formidable.with_frm_style #frm_field_cptch_number_container{font-size:15px;color:#344054;font-weight:normal;clear:both;}.frm_style_style-formidable.with_frm_style .frm_blank_field input[type=text],.frm_style_style-formidable.with_frm_style .frm_blank_field input[type=password],.frm_style_style-formidable.with_frm_style .frm_blank_field input[type=url],.frm_style_style-formidable.with_frm_style .frm_blank_field input[type=tel],.frm_style_style-formidable.with_frm_style .frm_blank_field input[type=number],.frm_style_style-formidable.with_frm_style .frm_blank_field input[type=email],.frm_style_style-formidable.with_frm_style .frm_blank_field input[type=checkbox],.frm_style_style-formidable.with_frm_style .frm_blank_field input[type=radio],.frm_style_style-formidable.with_frm_style .frm_blank_field textarea,.frm_style_style-formidable.with_frm_style .frm_blank_field .mce-edit-area iframe,.frm_style_style-formidable.with_frm_style .frm_blank_field select:not(.ui-datepicker-month):not(.ui-datepicker-year),.frm_form_fields_error_style,.frm_style_style-formidable.with_frm_style .frm_blank_field .frm-g-recaptcha iframe,.frm_style_style-formidable.with_frm_style .frm_blank_field .g-recaptcha iframe,.frm_style_style-formidable.with_frm_style .frm_blank_field .frm-card-element.StripeElement,.frm_style_style-formidable.with_frm_style .frm_form_field :invalid {color:#444444;background-color:#ffffff;border-color:#F04438;border-width:var(--border-width-error) ;border-style:solid;}.frm_style_style-formidable.with_frm_style .frm_blank_field .sigWrapper{border-color:#F04438 !important;}.frm_style_style-formidable.with_frm_style .frm_error,.frm_style_style-formidable.with_frm_style .frm_limit_error{font-weight:normal;color:#444444;}.frm_style_style-formidable.with_frm_style .frm_error_style{background-color:#FEE4E2;border:1px solid #F5B8AA;border-radius:8px;color: #F04438;font-size:14px;margin:0;margin-bottom:20px;}.frm_style_style-formidable.with_frm_style #frm_loading .progress-striped .progress-bar{background-image:linear-gradient(45deg, #D0D5DD 25%, rgba(0, 0, 0, 0) 25%, rgba(0, 0, 0, 0) 50%, #D0D5DD 50%, #D0D5DD 75%, rgba(0, 0, 0, 0) 75%, rgba(0, 0, 0, 0));}.frm_style_style-formidable.with_frm_style #frm_loading .progress-bar{background-color:#ffffff;}.frm_style_style-formidable.with_frm_style .frm_form_field.frm_total_big input,.frm_style_style-formidable.with_frm_style .frm_form_field.frm_total_big textarea,.frm_style_style-formidable.with_frm_style .frm_form_field.frm_total input,.frm_style_style-formidable.with_frm_style .frm_form_field.frm_total textarea{color: #1D2939;background-color:transparent;border:none;display:inline;width:auto;padding:0;}.frm_ajax_loading{visibility:hidden;width:auto;}.frm_form_submit_style{height:auto;}a.frm_save_draft{cursor:pointer;}.with_frm_style a.frm_save_draft,.with_frm_style a.frm_start_over{font-size: var(--submit-font-size);font-weight: var(--submit-weight);}.horizontal_radio .frm_radio{margin:0 5px 0 0;}.horizontal_radio .frm_checkbox{margin:0;margin-right:12px;}.vertical_radio .frm_checkbox,.vertical_radio .frm_radio,.vertical_radio .frm_catlevel_1{display:block;}.horizontal_radio .frm_checkbox,.horizontal_radio .frm_radio,.horizontal_radio .frm_catlevel_1{display:inline-block;padding-left: 0;}.with_frm_style .frm_radio{display: var(--radio-align);}.with_frm_style .frm_checkbox{display: var(--check-align);}.with_frm_style .vertical_radio .frm_checkbox,.with_frm_style .vertical_radio .frm_radio,.vertical_radio .frm_catlevel_1{display:block;margin-bottom: 10px;}.with_frm_style .horizontal_radio .frm_checkbox,.with_frm_style .horizontal_radio .frm_radio,.horizontal_radio .frm_catlevel_1{display:inline-block;}.with_frm_style .frm_checkbox label,.with_frm_style .frm_radio label {display: inline-block;vertical-align: middle;white-space:normal;}.with_frm_style .frm_checkbox label input[type=checkbox],.with_frm_style .frm_radio label input[type=radio] {margin-right: 4px;}.with_frm_style .frm_checkbox label:not(.frm-label-disabled),.with_frm_style .frm_radio label:not(.frm-label-disabled) {cursor: pointer;}.with_frm_style .vertical_radio .frm_checkbox label,.with_frm_style .vertical_radio .frm_radio label{display: block;width: 100%;}.with_frm_style .frm_radio label,.with_frm_style .frm_checkbox label {font-size: var(--check-font-size);color: var(--check-label-color);font-weight: var(--check-weight);line-height: 1.3;}.with_frm_style .frm_radio input[type=radio],.with_frm_style .frm_checkbox input[type=checkbox] {font-size: var(--check-font-size);position: static;}.frm_file_container .frm_file_link,.with_frm_style .frm_radio label .frm_file_container,.with_frm_style .frm_checkbox label .frm_file_container{display:inline-block;margin:5px;vertical-align:middle;}.with_frm_style .frm_radio input[type=radio]{border-radius:50%;}.with_frm_style .frm_checkbox input[type=checkbox] {border-radius: calc(var(--border-radius) / 2) !important;}.with_frm_style .frm_radio input[type=radio],.with_frm_style .frm_checkbox input[type=checkbox]{appearance: none;background-color: var(--bg-color);flex: none;display:inline-block !important;width: 16px !important;min-width: 16px !important;height: 16px !important;color: var(--border-color);border: 1px solid currentColor;border-color: var(--border-color);vertical-align: middle;position: initial; padding: 0;margin: 0;}.frm_forms.with_frm_style .frm_fields_container .frm_radio input[type=radio]:not([disabled]):checked,.frm_forms.with_frm_style .frm_fields_container .frm_checkbox input[type=checkbox]:not([disabled]):checked {border-color: var(--border-color-active) !important;}.frm_forms.with_frm_style .frm_fields_container .frm_checkbox input[type=checkbox]:not([disabled]):checked {background-color: var(--border-color-active) !important;}.with_frm_style .frm_radio input[type=radio][disabled]:checked,.with_frm_style .frm_checkbox input[type=checkbox][disabled]:checked {border-color: var(--border-color) !important; }.with_frm_style .frm_checkbox input[type=checkbox][disabled]:checked {background-color: var(--border-color) !important;}.with_frm_style .frm_radio input[type=radio]:checked:before,.with_frm_style .frm_checkbox input[type=checkbox]:checked:before {position: static !important; content: \'\';display: block;}.frm_forms.with_frm_style .frm_checkbox input[type=checkbox]:before {width: 100% !important;height: 100% !important;background-image: url(\"data:image/svg+xml,%3Csvg width=\'12\' height=\'9\' viewBox=\'0 0 12 9\' fill=\'none\' xmlns=\'http://www.w3.org/2000/svg\'%3E%3Cpath d=\'M10.6667 1.5L4.25001 7.91667L1.33334 5\' stroke=\'white\' stroke-width=\'2\' stroke-linecap=\'round\' stroke-linejoin=\'round\'/%3E%3C/svg%3E%0A\") !important;background-size: 9px !important;background-repeat: no-repeat !important;background-position: center !important;margin: 0;}.with_frm_style .frm_radio input[type=radio]:before {width: 8px;height: 8px;border-radius: 50%;background-color: var(--border-color-active);margin: 3px;}.with_frm_style .frm_radio input[type=radio][disabled]:before {background-color: var(--border-color);}.with_frm_style :invalid,.with_frm_style :-moz-ui-invalid{box-shadow:none;}.with_frm_style .frm_error_style img{padding-right:10px;vertical-align:middle;border:none;}.with_frm_style .frm_trigger{cursor:pointer;}.with_frm_style .frm_error_style,.with_frm_style .frm_message,.frm_success_style{border-radius:4px;padding:15px;}.with_frm_style .frm_message p {margin-bottom: 5px;color: var(--success-text-color);}.with_frm_style .frm_message,.frm_success_style {margin: 5px 0 15px;border: 1px solid var(--success-border-color);background-color: var(--success-bg-color);color: var(--success-text-color);border-radius: var(--border-radius);font-size: var(--success-font-size);}.with_frm_style .frm_plain_success .frm_message {background-color: transparent;padding:0;border:none;font-size:inherit;color:inherit;}.with_frm_style .frm_plain_success .frm_message p {color:inherit;}.frm_form_fields_style,.frm_form_fields_active_style,.frm_form_fields_error_style,.frm_form_submit_style{width:auto;}.with_frm_style .frm_trigger span{float:left;}.with_frm_style table.frm-grid,#content .with_frm_style table.frm-grid{border-collapse:collapse;border:none;}.frm-grid td,.frm-grid th{padding:5px;border-width:1px;border-style:solid;border-color: var(--border-color);border-top:none;border-left:none;border-right:none;}.frm-alt-table {width:100%;border-collapse:separate;margin-top:0.5em;font-size:15px;border-width:1px;}.with_frm_style .frm-alt-table{border-color: var(--border-color);}.frm-alt-table th {width:200px;}.frm-alt-table tr {background-color:transparent;}.frm-alt-table th,.frm-alt-table td {background-color:transparent;vertical-align:top;text-align:left;padding:20px;border-color:transparent;}.frm-alt-table tr:nth-child(even) {background-color:#fdffff;}table.form_results.with_frm_style{border-style: solid;border-width: var(--field-border-width);border-color: var(--border-color);}table.form_results.with_frm_style tr td{text-align:left;padding:7px 9px;color: var(--text-color);border-top-style: solid;border-top-width: var(--field-border-width);border-top-color: var(--border-color);}table.form_results.with_frm_style tr.frm_even,.frm-grid .frm_even{background-color:#fff;background-color:var(--bg-color);}table.form_results.with_frm_style tr.frm_odd,.frm-grid .frm_odd {background-color: var(--bg-color);}.frm_color_block {background-color:#fdffff;padding: 40px;}.with_frm_style .frm-show-form .frm_color_block.frm_section_heading h3,.frm_color_block.frm_section_heading h3 {border-width: 0 !important;}.frm_collapse .ui-icon{display:inline-block;}.frm_toggle_container{border:1px solid transparent;}.frm_toggle_container ul{margin:5px 0;padding-left:0;list-style-type:none;}.frm_toggle_container .frm_month_heading{text-indent:15px;}.frm_toggle_container .frm_month_listing{margin-left:40px;}#frm_loading{display:none;position:fixed;top:0;left:0;width:100%;height:100%;z-index:99999;}#frm_loading h3{font-weight:500;padding-bottom:15px;color:#fff;font-size:24px;}#frm_loading_content{position:fixed;top:20%;left:33%;width:33%;text-align:center;padding-top:30px;font-weight:bold;z-index:9999999;}#frm_loading img{max-width:100%;}#frm_loading .progress{border-radius:4px;box-shadow:0 1px 2px rgba(0, 0, 0, 0.1) inset;height:20px;margin-bottom:20px;overflow:hidden;}#frm_loading .progress.active .progress-bar{animation:2s linear 0s normal none infinite progress-bar-stripes;}#frm_loading .progress-striped .progress-bar {background-image: linear-gradient(45deg, var(--border-color) 25%, rgba(0, 0, 0, 0) 25%, rgba(0, 0, 0, 0) 50%, var(--border-color) 50%, var(--border-color) 75%, rgba(0, 0, 0, 0) 75%, rgba(0, 0, 0, 0));background-size:40px 40px;}#frm_loading .progress-bar {background-color: var(--bg-color);box-shadow: 0 -1px 0 rgba(0, 0, 0, 0.15) inset;float: left;height: 100%;line-height: 20px;text-align: center;transition: width 0.6s ease 0s;width: 100%;}.frm_image_from_url{height:50px;}.frm-loading-img{background:url(https://creakonect.com/wp-content/plugins/formidable/images/ajax_loader.gif) no-repeat center center;padding:6px 12px;}select.frm_loading_lookup{background-image: url(https://creakonect.com/wp-content/plugins/formidable/images/ajax_loader.gif) !important;background-position: 10px;background-repeat: no-repeat;color: transparent !important;}.frm_screen_reader {border: 0;clip-path: inset(50%);height: 1px;margin: -1px;overflow: hidden;padding: 0;position: absolute;width: 1px;word-wrap: normal !important; }.frm_screen_reader.frm_hidden{display:initial;}.frm_clear_none{clear:none;}.frm_clear{clear:both;}.frm_form_field.frm_alignright{float:right !important;}.with_frm_style .frm_form_field{clear:both;}.frm_combo_inputs_container,.frm_grid_container,.frm_form_fields .frm_section_heading,.frm_form_fields .frm_fields_container{display:grid;grid-template-columns: repeat(12, 1fr);grid-auto-rows: max-content;grid-gap: 0 2%;}.frm_combo_inputs_container > *,.frm_grid_container > *,.frm_section_heading > *,.frm_fields_container .frm_form_field,.frm_fields_container > *{grid-column: span 12 / span 12;}.frm_inline,.frm_form_field.frm_left_inline,.frm_form_field.frm_first_inline,.frm_form_field.frm_inline,.frm_submit.frm_inline,.frm_form_field.frm_right_inline,.frm_form_field.frm_last_inline{width:auto;grid-column: span 2 / span 2;}.frm6,.frm_half,.frm_form_field.frm_three_fifths, .frm_form_field.frm6,.frm_submit.frm6,.frm_form_field.frm_left_half,.frm_form_field.frm_right_half,.frm_form_field.frm_first_half,.frm_form_field.frm_last_half,.frm_form_field.frm_half,.frm_submit.frm_half{grid-column:span 6 / span 6;}.frm4,.frm_third,.frm_form_field.frm_two_fifths, .frm_form_field.frm4,.frm_submit.frm4,.frm_form_field.frm_left_third,.frm_form_field.frm_third,.frm_submit.frm_third,.frm_form_field.frm_right_third,.frm_form_field.frm_first_third,.frm_form_field.frm_last_third{grid-column:span 4 / span 4;}.frm8,.frm_two_thirds,.frm_form_field.frm8,.frm_submit.frm8,.frm_form_field.frm_left_two_thirds,.frm_form_field.frm_right_two_thirds,.frm_form_field.frm_first_two_thirds,.frm_form_field.frm_last_two_thirds,.frm_form_field.frm_two_thirds{grid-column: span 8/span 8;}.frm3,.frm_fourth,.frm_form_field.frm3,.frm_submit.frm3,.frm_form_field.frm_left_fourth,.frm_form_field.frm_fourth,.frm_submit.frm_fourth,.frm_form_field.frm_right_fourth,.frm_form_field.frm_first_fourth,.frm_form_field.frm_last_fourth{grid-column: span 3/span 3;}.frm9,.frm_three_fourths,.frm_form_field.frm_four_fifths, .frm_form_field.frm9,.frm_submit.frm9,.frm_form_field.frm_three_fourths{grid-column: span 9/span 9;}.frm_form_field.frm_left_fifth,.frm_form_field.frm_fifth,.frm_submit.frm_fifth,.frm_form_field.frm_right_fifth,.frm_form_field.frm_first_fifth,.frm_form_field.frm_last_fifth{grid-column: span 2/span 2;}.frm2,.frm_sixth,.frm_form_field.frm2,.frm_submit.frm2,.frm_form_field.frm_sixth,.frm_submit.frm_sixth,.frm_form_field.frm_first_sixth,.frm_form_field.frm_last_sixth{grid-column: span 2/span 2;}.frm10,.frm_form_field.frm10,.frm_submit.frm10{grid-column: span 10/span 10;}.frm1,.frm_form_field.frm1,.frm_submit.frm1,.frm_form_field.frm_seventh,.frm_submit.frm_seventh,.frm_form_field.frm_first_seventh,.frm_form_field.frm_last_seventh.frm_form_field.frm_eighth,.frm_submit.frm_eighth,.frm_form_field.frm_first_eighth,.frm_form_field.frm_last_eighth{grid-column: span 1/span 1;}.frm5,.frm_form_field.frm5,.frm_submit.frm5{grid-column: span 5/span 5;}.frm7,.frm_form_field.frm7,.frm_submit.frm7{grid-column: span 7/span 7;}.frm11,.frm_form_field.frm11,.frm_submit.frm11{grid-column: span 11/span 11;}.frm12,.frm_full,.frm_full .wp-editor-wrap,.frm_full > input:not([type=\'checkbox\']):not([type=\'radio\']):not([type=\'button\']),.frm_full select,.frm_full textarea{width:100% !important;grid-column: span 12/span 12;box-sizing: border-box;}.frm_full .wp-editor-wrap input{width:auto !important;}.frm_first,.frm_form_field.frm_left_half,.frm_form_field.frm_left_third,.frm_form_field.frm_left_two_thirds,.frm_form_field.frm_left_fourth,.frm_form_field.frm_left_fifth,.frm_form_field.frm_left_inline,.frm_form_field.frm_first_half,.frm_form_field.frm_first_third,.frm_form_field.frm_first_two_thirds,.frm_form_field.frm_first_fourth,.frm_form_field.frm_first_fifth,.frm_form_field.frm_first_sixth,.frm_form_field.frm_first_seventh,.frm_form_field.frm_first_eighth,.frm_form_field.frm_first_inline,.frm_form_field.frm_first{grid-column-start:1;}.frm_last,.frm_form_field.frm_last,.frm_form_field.frm_alignright{grid-column-end:-1;justify-content: end;}.with_frm_style.frm_rtl .frm_form_fields .star-rating{float:right;}.with_frm_style.frm_rtl .frm_grid .frm_primary_label,.with_frm_style.frm_rtl .frm_grid_first .frm_primary_label,.with_frm_style.frm_rtl .frm_grid_odd .frm_primary_label,.with_frm_style.frm_rtl .frm_grid .frm_radio,.with_frm_style.frm_rtl .frm_grid_first .frm_radio,.with_frm_style.frm_rtl .frm_grid_odd .frm_radio,.with_frm_style.frm_rtl .frm_grid .frm_checkbox,.with_frm_style.frm_rtl .frm_grid_first .frm_checkbox,.with_frm_style.frm_rtl .frm_grid_odd .frm_checkbox{float:right !important;margin-right:0 !important;}.with_frm_style.frm_rtl .frm_grid_first .frm_radio label input,.with_frm_style.frm_rtl .frm_grid .frm_radio label input,.with_frm_style.frm_rtl .frm_grid_odd .frm_radio label input,.with_frm_style.frm_rtl .frm_grid_first .frm_checkbox label input,.with_frm_style.frm_rtl .frm_grid .frm_checkbox label input,.with_frm_style.frm_rtl .frm_grid_odd .frm_checkbox label input{float:left;}.with_frm_style.frm_rtl .frm_catlevel_2,.with_frm_style.frm_rtl .frm_catlevel_3,.with_frm_style.frm_rtl .frm_catlevel_4,.with_frm_style.frm_rtl .frm_catlevel_5{margin-right:18px;}.with_frm_style.frm_rtl div > .frm_time_select{margin-right:5px;}.frm_form_field.frm_inline_container,.frm_form_field.frm_right_container,.frm_form_field.frm_left_container{display: grid;grid-template-columns: 25% auto;width:100%;grid-auto-rows: min-content;}.frm_form_field.frm_right_container{grid-template-columns: auto 25%;}.frm_form_field.frm_inline_container{grid-template-columns: repeat(2, minmax(auto, max-content) );}.frm_form_field.frm_inline_container .frm_primary_label,.frm_form_field.frm_right_container .frm_primary_label,.frm_form_field.frm_left_container .frm_primary_label{margin-right:10px;grid-row:span 2/span 2;padding-top:4px;}.frm_form_field.frm_left_container .frm_primary_label{grid-column:1;grid-row:span 2/span 2; }.frm_form_field.frm_right_container .frm_primary_label{grid-column:2;grid-row:1;margin-right:0;margin-left:10px;}.frm_form_field.frm_inline_container .frm_description,.frm_form_field.frm_left_container .frm_description{grid-column:2;}.frm_form_field.frm_right_container .frm_description{grid-column:1;}.frm_conf_field.frm_left_container{grid-template-columns: 67%;}.frm_conf_field.frm_left_container .frm_description{grid-column:1;}.frm-fade-in {animation-name: fadeIn;animation-duration: 1s;animation-fill-mode: both;}@keyframes spin {0% { transform: rotate(0deg); }100% { transform: rotate(360deg); }}@keyframes fadeIn {   0% {opacity: 0;}   100% {opacity: 1;}}@media only screen and (max-width: 750px) {.frm_grid_container.frm_no_grid_750 > div{grid-column: span 12/span 12;}}@media only screen and (max-width: 600px) {.frm_section_heading > .frm_form_field,.frm_fields_container > .frm_submit,.frm_grid_container > .frm_form_field,.frm_fields_container > .frm_form_field{grid-column: 1 / span 12 !important;}.frm_grid_container.frm_no_grid_600,.frm_form_field.frm_inline_container,.frm_form_field.frm_right_container,.frm_form_field.frm_left_container{display:block;}}.frm_conf_field.frm_left_container .frm_primary_label{display:none;}.wp-editor-wrap *,.wp-editor-wrap *:after,.wp-editor-wrap *:before{box-sizing:content-box;}.with_frm_style .frm_grid,.with_frm_style .frm_grid_first,.with_frm_style .frm_grid_odd{clear:both;margin-bottom:0 !important;padding:5px;border-width:1px;border-style:solid;border-color: var(--border-color);border-left:none;border-right:none;}.with_frm_style .frm_grid,.with_frm_style .frm_grid_odd{border-top:none;}.frm_grid .frm_error,.frm_grid_first .frm_error,.frm_grid_odd .frm_error,.frm_grid .frm_limit_error,.frm_grid_first .frm_limit_error,.frm_grid_odd .frm_limit_error{display:none;}.frm_grid:after,.frm_grid_first:after,.frm_grid_odd:after{visibility:hidden;display:block;font-size:0;content:\" \";clear:both;height:0;}.frm_grid_first{margin-top:20px;}.frm_grid_first,.frm_grid_odd {background-color: var(--bg-color);}.frm_grid {background-color: var(--bg-color-active);}.with_frm_style .frm_grid.frm_blank_field,.with_frm_style .frm_grid_first.frm_blank_field,.with_frm_style .frm_grid_odd.frm_blank_field{background-color:var(--error-bg);border-color: var(--error-border);}.frm_grid .frm_primary_label,.frm_grid_first .frm_primary_label,.frm_grid_odd .frm_primary_label,.frm_grid .frm_radio,.frm_grid_first .frm_radio,.frm_grid_odd .frm_radio,.frm_grid .frm_checkbox,.frm_grid_first .frm_checkbox,.frm_grid_odd .frm_checkbox{float:left !important;display:block;margin-top:0;margin-left:0 !important;}.frm_grid_first .frm_radio label,.frm_grid .frm_radio label,.frm_grid_odd .frm_radio label,.frm_grid_first .frm_checkbox label,.frm_grid .frm_checkbox label,.frm_grid_odd .frm_checkbox label{color:transparent;text-indent: -9999px;white-space:nowrap;text-align:left;}.frm_grid_first .frm_radio label input,.frm_grid .frm_radio label input,.frm_grid_odd .frm_radio label input,.frm_grid_first .frm_checkbox label input,.frm_grid .frm_checkbox label input,.frm_grid_odd .frm_checkbox label input{visibility:visible;margin:2px 0 0;float:right;}.frm_grid .frm_radio,.frm_grid_first .frm_radio,.frm_grid_odd .frm_radio,.frm_grid .frm_checkbox,.frm_grid_first .frm_checkbox,.frm_grid_odd .frm_checkbox{display:inline;}.frm_grid_2 .frm_radio,.frm_grid_2 .frm_checkbox,.frm_grid_2 .frm_primary_label{width:48% !important;}.frm_grid_2 .frm_radio,.frm_grid_2 .frm_checkbox{margin-right:4%;}.frm_grid_3 .frm_radio,.frm_grid_3 .frm_checkbox,.frm_grid_3 .frm_primary_label{width:30% !important;}.frm_grid_3 .frm_radio,.frm_grid_3 .frm_checkbox{margin-right:3%;}.frm_grid_4 .frm_radio,.frm_grid_4 .frm_checkbox{width:20% !important;}.frm_grid_4 .frm_primary_label{width:28% !important;}.frm_grid_4 .frm_radio,.frm_grid_4 .frm_checkbox{margin-right:4%;}.frm_grid_5 .frm_primary_label,.frm_grid_7 .frm_primary_label{width:24% !important;}.frm_grid_5 .frm_radio,.frm_grid_5 .frm_checkbox{width:17% !important;margin-right:2%;}.frm_grid_6 .frm_primary_label{width:25% !important;}.frm_grid_6 .frm_radio,.frm_grid_6 .frm_checkbox{width:14% !important;margin-right:1%;}.frm_grid_7 .frm_primary_label{width:22% !important;}.frm_grid_7 .frm_radio,.frm_grid_7 .frm_checkbox{width:12% !important;margin-right:1%;}.frm_grid_8 .frm_primary_label{width:23% !important;}.frm_grid_8 .frm_radio,.frm_grid_8 .frm_checkbox{width:10% !important;margin-right:1%;}.frm_grid_9 .frm_primary_label{width:20% !important;}.frm_grid_9 .frm_radio,.frm_grid_9 .frm_checkbox{width:9% !important;margin-right:1%;}.frm_grid_10 .frm_primary_label{width:19% !important;}.frm_grid_10 .frm_radio,.frm_grid_10 .frm_checkbox{width:8% !important;margin-right:1%;}.frm_form_field.frm_inline_container .frm_opt_container,.frm_form_field.frm_right_container .frm_opt_container,.frm_form_field.frm_left_container .frm_opt_container{padding-top:4px;}.with_frm_style .frm_left_container > select.auto_width,.with_frm_style .frm_right_container > select.auto_width {width: max-content;}.with_frm_style .frm_right_container > .frm_primary_label,.with_frm_style .frm_right_container > select.auto_width {margin-left: auto;}.with_frm_style .frm_inline_container.frm_grid_first .frm_primary_label,.with_frm_style .frm_inline_container.frm_grid .frm_primary_label,.with_frm_style .frm_inline_container.frm_grid_odd .frm_primary_label,.with_frm_style .frm_inline_container.frm_grid_first .frm_opt_container,.with_frm_style .frm_inline_container.frm_grid .frm_opt_container,.with_frm_style .frm_inline_container.frm_grid_odd .frm_opt_container{margin-right:0;}.frm_form_field.frm_two_col .frm_opt_container,.frm_form_field.frm_three_col .frm_opt_container,.frm_form_field.frm_four_col .frm_opt_container{display: grid;grid-template-columns: repeat(2, 1fr);grid-auto-rows: max-content;grid-gap: 0 2.5%;}.frm_form_field.frm_three_col .frm_opt_container{grid-template-columns: repeat(3, 1fr);}.frm_form_field.frm_four_col .frm_opt_container{grid-template-columns: repeat(4, 1fr);}.frm_form_field.frm_two_col .frm_radio,.frm_form_field.frm_two_col .frm_checkbox,.frm_form_field.frm_three_col .frm_radio,.frm_form_field.frm_three_col .frm_checkbox,.frm_form_field.frm_four_col .frm_radio,.frm_form_field.frm_four_col .frm_checkbox{grid-column-end: span 1;}.frm_form_field .frm_checkbox,.frm_form_field .frm_radio {margin-top: 0;margin-bottom: 0;}.frm_form_field.frm_scroll_box .frm_opt_container{height:100px;overflow:auto;}.frm_html_container.frm_scroll_box,.frm_form_field.frm_html_scroll_box {height: 100px;overflow: auto;background-color: var(--bg-color);border-color: var(--border-color);border-width: var(--field-border-width);border-style: var(--field-border-style);border-radius: var(--border-radius);width: var(--field-width);max-width: 100%;font-size: var(--field-font-size);padding: var(--field-pad);box-sizing: border-box;outline: none;font-weight: normal;box-shadow: var(--box-shadow);}.frm_form_field.frm_total_big input,.frm_form_field.frm_total_big textarea,.frm_form_field.frm_total input,.frm_form_field.frm_total textarea{opacity:1;background-color:transparent !important;border:none !important;font-weight:bold;width:auto !important;height:auto !important;box-shadow:none !important;display:inline;-moz-appearance:textfield;padding:0;}.frm_form_field.frm_total_big input::-webkit-outer-spin-button,.frm_form_field.frm_total_big input::-webkit-inner-spin-button,.frm_form_field.frm_total input::-webkit-outer-spin-button,.frm_form_field.frm_total input::-webkit-inner-spin-button {-webkit-appearance: none;}.frm_form_field.frm_total_big input:focus,.frm_form_field.frm_total_big textarea:focus,.frm_form_field.frm_total input:focus,.frm_form_field.frm_total textarea:focus{background-color:transparent;border:none;box-shadow:none;}.frm_form_field.frm_label_justify .frm_primary_label{text-align:justify !important;}.frm_form_field.frm_capitalize input,.frm_form_field.frm_capitalize select,.frm_form_field.frm_capitalize .frm_opt_container label{text-transform:capitalize;}.frm_clearfix:after{content:\".\";display:block;clear:both;visibility:hidden;line-height:0;height:0;}.frm_clearfix{display:block;}.with_frm_style .frm_combo_inputs_container > .frm_form_subfield-first,.with_frm_style .frm_combo_inputs_container > .frm_form_subfield-middle,.with_frm_style .frm_combo_inputs_container > .frm_form_subfield-last {margin-bottom: 0 !important;}@media only screen and (max-width: 900px) {.frm_form_field .frm_repeat_grid .frm_form_field.frm_sixth .frm_primary_label,.frm_form_field .frm_repeat_grid .frm_form_field.frm_seventh .frm_primary_label,.frm_form_field .frm_repeat_grid .frm_form_field.frm_eighth .frm_primary_label{display: block !important;}}@media only screen and (max-width: 600px) {.frm_form_field.frm_four_col .frm_opt_container{grid-template-columns: repeat(2, 1fr);}.with_frm_style .frm_repeat_inline,.with_frm_style .frm_repeat_grid{margin: 20px 0;}}@media only screen and (max-width: 500px) {.frm_form_field.frm_two_col .frm_radio,.frm_form_field.frm_two_col .frm_checkbox,.frm_form_field.frm_three_col .frm_radio,.frm_form_field.frm_three_col .frm_checkbox{width: auto;margin-right: 0;float: none;display:block;}.frm_form_field input[type=file] {max-width:220px;}.with_frm_style .frm-g-recaptcha > div > div,.with_frm_style .g-recaptcha > div > div{width:inherit !important;display:block;overflow:hidden;max-width:302px;border-right:1px solid #d3d3d3;border-radius:4px;box-shadow:2px 0px 4px -1px rgba(0,0,0,.08);}.with_frm_style .g-recaptcha iframe,.with_frm_style .frm-g-recaptcha iframe{width:100%;}}.frm-card-element .sq-card-wrapper .sq-card-message {margin-bottom: 0;}.frm-card-errors:empty {margin: 0;}","off"),
("2141","frm_summary_emails_options","a:3:{s:12:\"last_monthly\";s:10:\"2025-07-11\";s:11:\"last_yearly\";s:0:\"\";s:12:\"renewal_date\";s:10:\"2026-03-28\";}","auto"),
("2148","neve_review_flag","no","auto"),
("2149","frm_addons_l","a:3:{s:7:\"timeout\";i:1752272252;s:5:\"value\";s:117936:\"{\"93790\":{\"title\":\"Formidable Pro\",\"name\":\"Formidable Pro\",\"display_name\":\"Formidable Pro\",\"slug\":\"formidable-pro\",\"version\":\"6.22\",\"new_version\":\"6.22\",\"location\":[\"fp.strategy11.com\\/releases\\/formidable-pro-6.22.zip\"],\"excerpt\":\"\",\"id\":93790,\"released\":\"2010-02-01 16:27:26\",\"categories\":[\"Basic\",\"Strategy11\"],\"docs\":\"\",\"link\":\"https:\\/\\/formidableforms.com\\/downloads\\/formidable-pro\\/\",\"changelog\":\"<h4>v6.22 - June 12, 2025<\\/h4>\\n<ul>\\n<li>Fix: Summary fields would display summaries for the wrong entry in some cases.<\\/li>\\n<li>Fix: International phone field dropdowns would incorrectly close when first opened if the browser also triggered a scroll event after focusing.<\\/li>\\n<li>Fix: Option validation would fail when using a star rating or scale field that was previously another field type, like a radio button, and later changed.<\\/li>\\n<li>Fix: Minimum repeater row validation will no longer fail form validation when the repeater is conditionally hidden.<\\/li>\\n<li>Fix: Repeater entry data would not appear as expected when using &#091;default-message] in an email that sends when an entry is deleted.<\\/li>\\n<li>Fix: Conditionally displayed readonly radio buttons would incorrectly change the value to an \\\"undefined\\\" string.<\\/li>\\n<li>Fix: Invalid date values with null byte characters would trigger a fatal error.<\\/li>\\n<li>Fix: Look up field dropdowns would incorrectly show nothing instead of the placeholder in some cases.<\\/li>\\n<\\/ul>\\n<h4>v6.21.1 - May 22, 2025<\\/h4>\\n<ul>\\n<li>Fix: A check has been added to help prevent issues where fields populated with taxonomies used in post actions would show an error message that the value submitted was invalid.<\\/li>\\n<li>Fix: Empty date values would appear as today when exported as CSV.<\\/li>\\n<li>Fix: &#091;auto_id] shortcodes would show an incorrect value when used in combination with &#091;user_id] shortcodes, like &#091;auto_id]_&#091;user_id].<\\/li>\\n<li>Fix: A str_replace(): Passing null to parameter 2 ($replace) deprecated message has been fixed.<\\/li>\\n<li>The logic for the new frm_force_calculation_on_validate hook has been updated to improve how calculations handle decimals.<\\/li>\\n<\\/ul>\\n<h4>v6.21 - May 12, 2025<\\/h4>\\n<ul>\\n<li>New: Lookup fields now include new Displayed Value and Saved Value settings. Note that these settings will only appear when the source field includes options with separate values, or the source field is a dynamic field.<\\/li>\\n<li>New: Date field values can now be compared in conditional logic.<\\/li>\\n<li>New: A new frm_force_calculation_on_validate filter has been added to help enforce calculations while validating server-side. Note that this feature is still experimental and does not support all calculations. This is currently off by default and will continue to improve.<\\/li>\\n<li>New: Support for a new frm_no_border_top layout class has been added. This can be added to a section or repeater field to remove the section border styling.<\\/li>\\n<li>New: New keywords have been added to the filename spam check to help prevent spam uploads.<\\/li>\\n<li>Fix: International phone field dropdowns would appear in the incorrect position when a parent element used position: relative styling.<\\/li>\\n<li>Fix: Symbol padding would get added to currency fields on display even when there was no symbol set.<\\/li>\\n<li>Fix: Unlocked application templates would incorrectly appear as locked.<\\/li>\\n<li>Fix: Applications would get unassigned from forms incorrectly after the form was updated on the builder page.<\\/li>\\n<li>Dynamic field dropdowns will now show an empty placeholder options when there are no options instead of showing no input at all.<\\/li>\\n<\\/ul>\\n\",\"plugin\":\"formidable-pro\\/formidable-pro.php\",\"icons\":{\"1x\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png\"},\"banners\":{\"high\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\",\"low\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-772x250.png\"},\"search_terms\":\"\",\"is_new\":false},\"163248\":{\"title\":\"Signature\",\"name\":\"Signature\",\"display_name\":\"Digital Signatures\",\"slug\":\"signature\",\"version\":\"3.0.5\",\"new_version\":\"3.0.5\",\"location\":[\"fp.strategy11.com\\/releases\\/formidable-signature\\/formidable-signature-3.0.5.zip\"],\"excerpt\":\"Add an electronic signature to your WordPress form. The visitor may write their signature with a trackpad\\/mouse or type it.\",\"id\":163248,\"released\":\"2013-03-04 00:00:00\",\"categories\":[\"Business\",\"Form Functionality\",\"Strategy11\"],\"docs\":\"\\/knowledgebase\\/formidable-signature\\/\",\"link\":\"https:\\/\\/formidableforms.com\\/downloads\\/signature\\/\",\"changelog\":\"<h4>v3.0.5 - August 19, 2024<\\/h4>\\n<ul>\\n<li>New: This plugin now includes translations for French, Spanish, Italian, German, Japanese and Brazilian Portuguese.<\\/li>\\n<li>Fix: A Use of \\\"parent\\\" in callables deprecated message would get logged when loading translations for signature fields.<\\/li>\\n<li>Fix: In some cases old cached signature images would appear after being updated.<\\/li>\\n<li>Old polyfill code for supporting Internet Explorer has been removed.<\\/li>\\n<\\/ul>\\n<h4>v3.0.4 - March 28, 2024<\\/h4>\\n<ul>\\n<li>New: The way CSS is added has been updated for better compatibility with the Snuffleupagus security module.<\\/li>\\n<li>Fix: Scripts were not properly initializing when editing a form with a signature field in-place using the &#091;editlink] shortcode.<\\/li>\\n<li>Fix: Form validation would trigger on signature draw events, causing error messages to appear on other fields early.<\\/li>\\n<li>Fix: An Uncaught Error: Call to undefined method FrmProFieldDefault::get_signature_image_dimension fatal error has been fixed.<\\/li>\\n<li>Front end signature field icons have been updated to no longer use font icons.<\\/li>\\n<\\/ul>\\n<h4>v3.0.3 - June 15, 2023<\\/h4>\\n<ul>\\n<li>New: Added support for a new show=url shortcode option for signature fields.<\\/li>\\n<li>Fix: Icons were not aligning properly for some button size style settings.<\\/li>\\n<li>Fix: Signature fields would overflow when some field size style settings were applied.<\\/li>\\n<\\/ul>\\n\",\"plugin\":\"formidable-signature\\/signature.php\",\"icons\":{\"1x\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png\"},\"banners\":{\"high\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\",\"low\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\"},\"search_terms\":\"\",\"is_new\":false},\"163255\":{\"title\":\"Math Captcha\",\"name\":\"Math Captcha\",\"display_name\":\"Math Captcha\",\"slug\":\"math-captcha\",\"version\":\"1.15\",\"new_version\":\"1.15\",\"location\":[\"fp.strategy11.com\\/releases\\/formidable-math-captcha\\/formidable-math-captcha-1.15.zip\"],\"excerpt\":\"\",\"id\":163255,\"released\":\"2015-10-12 14:00:35\",\"categories\":[],\"docs\":\"\",\"link\":\"https:\\/\\/formidableforms.com\\/downloads\\/math-captcha\\/\",\"changelog\":\"\",\"plugin\":\"math-captcha\\/math-captcha.php\",\"icons\":{\"1x\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png\"},\"banners\":{\"high\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\",\"low\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\"},\"search_terms\":\"\",\"is_new\":false},\"163257\":{\"title\":\"PayPal Standard\",\"name\":\"PayPal Standard\",\"display_name\":\"PayPal Standard\",\"slug\":\"paypal-standard\",\"version\":\"3.09\",\"new_version\":\"3.09\",\"location\":[\"fp.strategy11.com\\/releases\\/formidable-paypal\\/formidable-paypal-3.09.zip\"],\"excerpt\":\"Collect instant payments and recurring payments to automate your online business. Calculate a total and send customers on to PayPal.\",\"id\":163257,\"released\":\"2012-09-04 00:00:00\",\"categories\":[\"Business\",\"Ecommerce\",\"Strategy11\"],\"docs\":\"\\/knowledgebase\\/formidable-paypal\\/\",\"link\":\"https:\\/\\/formidableforms.com\\/downloads\\/paypal-standard\\/\",\"changelog\":\"<h4>v3.10 - December 31, 2024<\\/h4>\\n<ul>\\n<li>Fix: An Undefined array key \\\"expire_date\\\" PHP Warning has been fixed.<\\/li>\\n<li>Fix: An Uncaught TypeError: strtotime PHP Fatal error has been fixed.<\\/li>\\n<\\/ul>\\n<h4>v3.09 - July 30, 2019<\\/h4>\\n<ul>\\n<li>New: Account for tax when comparing amounts with the IPN<\\/li>\\n<li>Update form action icon and color<\\/li>\\n<li>Replace call to deprecated function with FrmFieldsHelper::get_user_display_name<\\/li>\\n<li>Requires Formidable v3.0+<\\/li>\\n<\\/ul>\\n<h4>v3.08 - November 18, 2017<\\/h4>\\n<ul>\\n<li>Allow field shortcodes in more payments settings so values can be set from the form: PayPal email, trial amount, repeat period, trial length. This also allows payments to go to other members on your site.<\\/li>\\n<li>Allow regular WordPress shortcodes and Formidable dynamic values (ie [email]) in addition to basic field shortcodes<\\/li>\\n<\\/ul>\\n\",\"plugin\":\"formidable-paypal\\/formidable-paypal.php\",\"icons\":{\"1x\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png\"},\"banners\":{\"high\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\",\"low\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\"},\"search_terms\":\"paypal\",\"is_new\":false},\"168072\":{\"title\":\"Formidable API\",\"name\":\"Formidable API\",\"display_name\":\"Formidable API\",\"slug\":\"formidable-api\",\"version\":\"1.18\",\"new_version\":\"1.18\",\"location\":[\"fp.strategy11.com\\/releases\\/formidable-api\\/formidable-api-1.18.zip\"],\"excerpt\":\"Add a full forms API for forms, form fields, views, and entries. Then send submissions to other sites with REST APIs.\",\"id\":168072,\"released\":\"2016-06-08 00:00:00\",\"categories\":[\"Automation\",\"Business\",\"Strategy11\"],\"docs\":\"\\/knowledgebase\\/formidable-api\\/\",\"link\":\"https:\\/\\/formidableforms.com\\/downloads\\/formidable-api\\/\",\"changelog\":\"<h4>v1.18 - December 11, 2024<\\/h4>\\n<ul>\\n<li>New: Testing API connections has been improved. Previously messages like OK would appear in red even though the connection was valid.<\\/li>\\n<li>Fix: Icons to add or remove data rows in API actions were missing after a recent v6.16.3 Formidable Forms update.<\\/li>\\n<li>Fix: The hook used to load translations has been updated to improve compatibility with WordPress 6.7+.<\\/li>\\n<li>Fix: Files would not properly save when creating entries using the rest API when file protection was enabled.<\\/li>\\n<\\/ul>\\n<h4>v1.17 - October 15, 2024<\\/h4>\\n<ul>\\n<li>New: API keys can now be refreshed. This will disallow all uses of your previous API key, allowing you to pick another in case your API key may have been compromised.<\\/li>\\n<li>Fix: Using API actions to send GET requests could result in a fatal error.<\\/li>\\n<li>Fix: Trying to use an &#091;frm-api] shortcode without Formidable Forms active would result in a fatal error.<\\/li>\\n<li>Fix: Trying to update an entry with a required name field in a repeater would result in an unexpected 409 error.<\\/li>\\n<li><span class=\\\"blob-code-inner blob-code-marker js-code-nav-pass \\\" data-code-marker=\\\"+\\\"><span class=\\\"pl-s\\\">The entry object is now passed as a parameter when the frm_before_destroy_entry hook is triggered to match parameters in other locations where the hook is triggered.<br \\/>\\n<\\/span><\\/span><\\/li>\\n<\\/ul>\\n<h4>v1.16 - August 21, 2024<\\/h4>\\n<ul>\\n<li>New: This plugin now includes translations for French, Spanish, Italian, German, Japanese and Brazilian Portuguese.<\\/li>\\n<li>New: A new frm_api_allow_create_entry filter has been added to override errors permission errors when creating an entry using the REST API.<\\/li>\\n<li>New: The frm_api_request_args filter is now applied when testing a connection to make testing a connection more consistent with real requests that get sent.<\\/li>\\n<\\/ul>\\n\",\"plugin\":\"formidable-api\\/formidable-api.php\",\"icons\":{\"1x\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png\"},\"banners\":{\"high\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\",\"low\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\"},\"search_terms\":\"\",\"is_new\":false},\"168456\":{\"title\":\"Upload Importer\",\"name\":\"Upload Importer\",\"display_name\":\"Upload Importer\",\"slug\":\"upload-importer\",\"version\":\"1.0.01\",\"new_version\":\"1.0.01\",\"location\":[\"fp.strategy11.com\\/releases\\/formidable-upload-importer\\/formidable-upload-importer-1.0.01.zip\"],\"excerpt\":\"\",\"id\":168456,\"released\":\"2015-10-16 17:05:47\",\"categories\":[\"Strategy11\"],\"docs\":\"\",\"link\":\"https:\\/\\/formidableforms.com\\/downloads\\/upload-importer\\/\",\"changelog\":\"<h4>v1.0.01<\\/h4>\\n<ul>\\n<li>Get updates from FormidablePro.com<\\/li>\\n<\\/ul>\\n<h4>v1.0<\\/h4>\\n<ul>\\n<li>Allow importing of multiple file uploads<\\/li>\\n<li>Replace deprecated mime_content_type with fileinfo<\\/li>\\n<li>Update auto-updating<\\/li>\\n<\\/ul>\\n\",\"plugin\":\"upload-importer\\/upload-importer.php\",\"icons\":{\"1x\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png\"},\"banners\":{\"high\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\",\"low\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\"},\"search_terms\":\"\",\"is_new\":false},\"168460\":{\"title\":\"Twilio\",\"name\":\"Twilio\",\"display_name\":\"Twilio WordPress SMS\",\"slug\":\"twilio\",\"version\":\"1.09\",\"new_version\":\"1.09\",\"location\":[\"fp.strategy11.com\\/releases\\/formidable-twilio\\/formidable-twilio-1.09.zip\"],\"excerpt\":\"Allow users to text their votes for polls created by Formidable Forms, or send SMS notifications when entries are submitted or updated.\",\"id\":168460,\"released\":\"2014-03-10 00:00:00\",\"categories\":[\"Business\",\"Email &amp; SMS Marketing\",\"Strategy11\"],\"docs\":\"\\/knowledgebase\\/twilio-add-on\\/\",\"link\":\"https:\\/\\/formidableforms.com\\/downloads\\/twilio\\/\",\"changelog\":\"<h4>v1.10 - August 26, 2024<\\/h4>\\n<ul>\\n<li>New: This plugin now includes translations for French, Spanish, Italian, German, Japanese and Brazilian Portuguese.<\\/li>\\n<li>New: Twilio requests are now logged using the logging add-on when the plugin is available.<\\/li>\\n<li>New: Twilio actions now include the option to trigger on import.<\\/li>\\n<\\/ul>\\n<h4>v1.09 - November 2, 2020<\\/h4>\\n<ul>\\n<li>New: Include sending numbers from the linked Twilio account in a dropdown. This makes it much easier to send messages successfully.<\\/li>\\n<li>New: Process the [default-message] when sending in an SMS message.<\\/li>\\n<li>Add more guidance to connect to the Twilio API and show messages in the form action when connecting fails.<\\/li>\\n<li>Fix: Some responses were not getting saved correctly into radio and checkbox fields.<\\/li>\\n<li>Clean up and update the code including removing support for Formidable &lt;2.0.<\\/li>\\n<\\/ul>\\n<h4>v1.08 - January 16, 2017<\\/h4>\\n<ul>\\n<li>Improved: Removed deprecated instructions and screenshot.<\\/li>\\n<li>Improved: Removed deprecated valign attribute from table HTML.<\\/li>\\n<\\/ul>\\n\",\"plugin\":\"formidable-twilio\\/formidable-twilio.php\",\"icons\":{\"1x\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png\"},\"banners\":{\"high\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\",\"low\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\"},\"search_terms\":\"\",\"is_new\":false},\"168463\":{\"title\":\"Bootstrap\",\"name\":\"Bootstrap\",\"display_name\":\"Bootstrap\",\"slug\":\"bootstrap\",\"version\":\"2.0.1\",\"new_version\":\"2.0.1\",\"location\":[\"fp.strategy11.com\\/releases\\/formidable-bootstrap\\/formidable-bootstrap-2.0.1.zip\"],\"excerpt\":\"Instantly add Bootstrap styling to all your Formidable forms.\",\"id\":168463,\"released\":\"2014-08-05 00:00:00\",\"categories\":[\"Creator\",\"Form Design &amp; Display\",\"Strategy11\"],\"docs\":\"\\/knowledgebase\\/formidable-bootstrap\\/\",\"link\":\"https:\\/\\/formidableforms.com\\/downloads\\/bootstrap\\/\",\"changelog\":\"<h4>v2.0.1 - August 13, 2024<\\/h4>\\n<ul>\\n<li>New: This plugin now includes translations for French, Spanish, Italian, German, Japanese and Brazilian Portuguese.<\\/li>\\n<\\/ul>\\n<h4>v2.0 - November 30, 2023<\\/h4>\\n<ul>\\n<li>New: This add on now uses Bootstrap 5 (instead of Bootstrap 3). If moving to Bootstrap 5 is causing issues, the option to change back to Bootstrap 3 is available as a dropdown option in Global Settings.<\\/li>\\n<li>New: Admin page labels for Bootstrap settings have been updated for better accessibility.<\\/li>\\n<li>Fix: Radio button options displayed as buttons had too much left padding when using Bootstrap 3.<\\/li>\\n<li>Fix: Too many migration queries were being made when there was no Bootstrap data to migrate.<\\/li>\\n<li>Fix: The ellipses used in pagination containers was appearing as text outside of the pagination when using the Bootstrap add on.<\\/li>\\n<\\/ul>\\n<h4>vv1.03 - January 18, 2021<\\/h4>\\n<ul>\\n<li>This update requires action. After updating, click the link to migrate the old settings.<strong> If you save a form with Bootstrap field options before running this migration, you risk losing those settings.<\\/strong><\\/li>\\n<li>New: Moved Prepend and Append Bootstrap field options to Before Input and After Input.<\\/li>\\n<li>New: Errors are now shown by default and can no longer be turned off<\\/li>\\n<li>New: Improved plugin security<\\/li>\\n<li>New: Added bootstrap CSS file directly into plugin for GDPR compliance<\\/li>\\n<\\/ul>\\n\",\"plugin\":\"formidable-bootstrap\\/formidable-bootstrap.php\",\"icons\":{\"1x\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png\"},\"banners\":{\"high\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\",\"low\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\"},\"search_terms\":\"\",\"is_new\":false},\"168468\":{\"title\":\"AWeber\",\"name\":\"AWeber\",\"display_name\":\"AWeber\",\"slug\":\"aweber\",\"version\":\"2.05\",\"new_version\":\"2.05\",\"location\":[\"fp.strategy11.com\\/releases\\/formidable-aweber\\/formidable-aweber-2.05.zip\"],\"excerpt\":\"AWeber is a powerful email marketing service. Subscribe contacts to an AWeber mailing list when they submit your WordPress contact forms.\",\"id\":168468,\"released\":\"2013-11-26 00:00:00\",\"categories\":[\"Creator\",\"Email &amp; SMS Marketing\",\"Strategy11\"],\"docs\":\"\\/knowledgebase\\/formidable-aweber\\/\",\"link\":\"https:\\/\\/formidableforms.com\\/downloads\\/aweber\\/\",\"changelog\":\"<h4>v2.05 - August 20, 2024<\\/h4>\\n<ul>\\n<li>New: This plugin now includes translations for French, Spanish, Italian, German, Japanese and Brazilian Portuguese.<\\/li>\\n<li>Fix: Undefined array key \\\"ad_tracking\\\" and Undefined array key \\\"tags\\\" PHP warnings have been fixed when adding a new AWeber action.<\\/li>\\n<li>The deprecated <span class=\\\"blob-code-inner blob-code-marker js-code-nav-pass js-skip-tagsearch\\\" data-code-marker=\\\"-\\\"><span class=\\\"pl-en x x-first\\\">utf8_encode<\\/span><\\/span> PHP function is no longer referenced.<\\/li>\\n<\\/ul>\\n<h4>v2.04 - June 11, 2024<\\/h4>\\n<ul>\\n<li>New: Field dropdowns have been updated to enable support for repeater actions.<\\/li>\\n<li>Fix: Name fields will now properly concatenate the first and last name when sending data to AWeber.<\\/li>\\n<li>Fix: An Uncaught TypeError: preg_match(): Argument 2 must be of type string fatal error has been fixed when trying to remove accents from array data.<\\/li>\\n<\\/ul>\\n<h4>v2.03 - March 3, 2022<\\/h4>\\n<ul>\\n<li>New: Subscription errors and successful subscriptions will now be logged if the Formidable Logs add on is available.<\\/li>\\n<li>Fix: Accents will now be removed from characters when subscribing to avoid issues with special accented characters breaking in names in AWeber.<\\/li>\\n<\\/ul>\\n\",\"plugin\":\"formidable-aweber\\/formidable-aweber.php\",\"icons\":{\"1x\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png\"},\"banners\":{\"high\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\",\"low\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\"},\"search_terms\":\"\",\"is_new\":false},\"169998\":{\"title\":\"WP Multilingual\",\"name\":\"WP Multilingual\",\"display_name\":\"WP Multilingual\",\"slug\":\"wp-multilingual\",\"version\":\"1.13\",\"new_version\":\"1.13\",\"location\":[\"fp.strategy11.com\\/releases\\/formidable-wpml\\/formidable-wpml-1.13.zip\"],\"excerpt\":\"Translate your forms into multiple languages using the Formidable-integrated WPML plugin.\",\"id\":169998,\"released\":\"2013-04-29 00:00:00\",\"categories\":[\"Business\",\"Multilingual\",\"Strategy11\"],\"docs\":\"\\/knowledgebase\\/formidable-multi-language\\/\",\"link\":\"https:\\/\\/formidableforms.com\\/downloads\\/wp-multilingual\\/\",\"changelog\":\"<h4>v1.13 - December 9, 2024<\\/h4>\\n<ul>\\n<li>New: Translation settings are now broken into multiple pages when the number of strings to translate exceeds the page size. Translation settings now also include a search input.<\\/li>\\n<li>New: Lookup field options can now be translated.<\\/li>\\n<li>New: Old removed options are now removed from translation settings when a form is updated.<\\/li>\\n<li>Fix: A foreach() argument must be of type array|object, null given PHP warning triggered when duplicating fields has been fixed.<\\/li>\\n<li>Fix: A database error would occur when viewing translation settings for a form with no fields.<\\/li>\\n<li>Fix: A translation issue with product field default values that would cause total field validation to fail for single products inside of conditional sections has been fixed.<\\/li>\\n<li>Fix: Fatal errors would occur when Polylang was active.<\\/li>\\n<li>Fix: An attempt to read property \\\"id\\\" on null PHP warning has been fixed.<\\/li>\\n<li>Fix: Error messages were not properly translating in some cases.<\\/li>\\n<\\/ul>\\n<h4>v1.12 - August 8, 2022<\\/h4>\\n<ul>\\n<li>New: Translations are now copied when a field or form is duplicated.<\\/li>\\n<li>New: Confirmation field validation messages can now be translated.<\\/li>\\n<li>Fix: Placeholders for Lookup dropdowns were not translating.<\\/li>\\n<li>Fix: Updated translations were not properly updating.<\\/li>\\n<\\/ul>\\n<h4>v1.11 - March 25, 2022<\\/h4>\\n<ul>\\n<li>Fix: Likert column headings were not translating properly.<\\/li>\\n<li>Fix: Incorrect and occasionally duplicate field translation options were appearing on translation pages.<\\/li>\\n<li>Fix: Formidable was appearing as an option in the WPML item dropdown, and has been removed.<\\/li>\\n<\\/ul>\\n<h4>v1.04 - October 25th, 2016<\\/h4>\\n<ul>\\n<li>Allow translation of Add\\/Remove buttons<\\/li>\\n<li>Replace some deprecated WPML function calls and constants<\\/li>\\n<li>Make sure wpml strings are updated when form is updated<\\/li>\\n<li>Do not translate default value for all field types<\\/li>\\n<li>Make sure incorrect field message is translated with ajax submit<\\/li>\\n<\\/ul>\\n<h4>v1.03.03 - March 28, 2016<\\/h4>\\n<ul>\\n<li>Send the language in the ajax url differently to prevent 404s during ajax calls. This should help with duplicate submissions.<\\/li>\\n<li>Prevent a license key from being saved for another plugin<\\/li>\\n<\\/ul>\\n<h4>v1.03.02<\\/h4>\\n<ul>\\n<li>Get updates from FormidablePro.com<\\/li>\\n<li>Make it compatible with the free version of Formidable<\\/li>\\n<li>Fix errors when Formidable or WPML are deactivated<\\/li>\\n<li>Include the current language during ajax calls<\\/li>\\n<li>Force an English start language for strings for v2.2.6 of the WPML strings plugin<\\/li>\\n<li>Fix the issue with the default language in WPML being set different than the string language<\\/li>\\n<li>If values in the form settings page changed, update them when going to the translation settings<\\/li>\\n<li>Make sure the \\\"previous\\\" label is translatable when drafts are not enabled<\\/li>\\n<li>Don\'t show strings for inactive languages<\\/li>\\n<li>Translate fields in repeating sections<\\/li>\\n<\\/ul>\\n\",\"plugin\":\"formidable-wpml\\/formidable-wpml.php\",\"icons\":{\"1x\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png\"},\"banners\":{\"high\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\",\"low\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\"},\"search_terms\":\"\",\"is_new\":false},\"170641\":{\"title\":\"Locations\",\"name\":\"Locations\",\"display_name\":\"Locations\",\"slug\":\"locations\",\"version\":\"2.03\",\"new_version\":\"2.03\",\"location\":[\"fp.strategy11.com\\/releases\\/formidable-locations\\/formidable-locations-2.03.zip\"],\"excerpt\":\"Populate fields with Countries, States\\/Provinces, U.S. Counties, and U.S. Cities. This data can then be used in dependent Data from Entries fields.\",\"id\":170641,\"released\":\"2014-06-21 00:00:00\",\"categories\":[\"Creator\",\"Data Collection\",\"Form Functionality\",\"Strategy11\"],\"docs\":\"\\/knowledgebase\\/formidable-locations\\/\",\"link\":\"https:\\/\\/formidableforms.com\\/downloads\\/locations\\/\",\"changelog\":\"<h4>v2.03 - April 20, 2023<\\/h4>\\n<ul>\\n<li>Fix: Importing cities would stop at \\\"8 remaining\\\" and never stop making requests to import additional cities.<\\/li>\\n<li>Fix: Form ids are are no longer retrieved using a deprecated function.<\\/li>\\n<li>Fix: Some city values were importing incorrectly, displaying \\\"1920\\\" as the state.<\\/li>\\n<\\/ul>\\n<h4>v2.02 - September 11, 2017<\\/h4>\\n<ul>\\n<li>Fix: Remove invalid city data.<\\/li>\\n<\\/ul>\\n<h4>v2.01 - May 10, 2016<\\/h4>\\n<ul>\\n<li>Switch to using Lookup fields<\\/li>\\n<li>Add a link to reset the locations data<\\/li>\\n<\\/ul>\\n\",\"plugin\":\"formidable-locations\\/us_locations.php\",\"icons\":{\"1x\":\"https:\\/\\/formidableforms.com\\/wp-content\\/uploads\\/2013\\/04\\/locations.png\"},\"banners\":{\"high\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\",\"low\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\"},\"search_terms\":\"\",\"is_new\":false},\"170645\":{\"title\":\"Zapier\",\"name\":\"Zapier\",\"display_name\":\"Zapier\",\"slug\":\"zapier\",\"version\":\"2.04\",\"new_version\":\"2.04\",\"location\":[\"fp.strategy11.com\\/releases\\/formidable-zapier\\/formidable-zapier-2.04.zip\"],\"excerpt\":\"Connect with hundreds of applications through Zapier. Automatically insert a Google spreadsheet row, tweet, or upload to Dropbox.\",\"id\":170645,\"released\":\"2014-06-04 00:00:00\",\"categories\":[\"Automation\",\"Business\",\"Strategy11\"],\"docs\":\"\\/knowledgebase\\/formidable-zapier\\/\",\"link\":\"https:\\/\\/formidableforms.com\\/downloads\\/zapier\\/\",\"changelog\":\"<h4>v2.04 - August 19, 2024<\\/h4>\\n<ul>\\n<li>New: This plugin now includes translations for French, Spanish, Italian, German, Japanese and Brazilian Portuguese.<\\/li>\\n<\\/ul>\\n<h4>v2.03 - March 11, 2024<\\/h4>\\n<ul>\\n<li>Fix: When polling for entries, the first entry would always get returned. Now the newest entry is returned as expected.<\\/li>\\n<\\/ul>\\n<h4>v2.02 - March 21, 2023<\\/h4>\\n<ul>\\n<li>New: Referrer checks for protected files are now allowed for Zapier requests so a protected file can be uploaded to Google Drive using a Zapier action. Protected files also need to be available to everyone or Zapier still will not have access.<\\/li>\\n<li>New: Added translation support.<\\/li>\\n<li>Fix: The \\/form API endpoint was calling a deprecated function.<\\/li>\\n<li>Fix: Prevent a fatal error when Formidable lite is inactive.<\\/li>\\n<li>Fix: The link to edit a zap would lead to a 404 page.<\\/li>\\n<li>Additional validation has been added to prevent notices for an incomplete API URL.<\\/li>\\n<li>The message to migrate will no longer be shown when no legacy Zapier posts exist.<\\/li>\\n<li>A warning will now be displayed on any temporary Zapier actions that get created for testing before publishing a zap.<\\/li>\\n<\\/ul>\\n\",\"plugin\":\"formidable-zapier\\/formidable-zapier.php\",\"icons\":{\"1x\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png\"},\"banners\":{\"high\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\",\"low\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\"},\"search_terms\":\"\",\"is_new\":false},\"170649\":{\"title\":\"User Tracking\",\"name\":\"User Tracking\",\"display_name\":\"User Flow\",\"slug\":\"user-tracking\",\"version\":\"2.0.3\",\"new_version\":\"2.0.3\",\"location\":[\"s3.amazonaws.com\\/fp.strategy11.com\\/releases\\/formidable-user-tracking\\/formidable-user-tracking-2.0.3.zip\"],\"excerpt\":\"Track the pages a user visits and the time spent on each page prior to submitting a form.\",\"id\":170649,\"released\":\"2015-10-19 00:00:00\",\"categories\":[\"Creator\",\"Strategy11\",\"Utilities\"],\"docs\":\"\\/knowledgebase\\/formidable-user-tracking\\/\",\"link\":\"https:\\/\\/formidableforms.com\\/downloads\\/user-tracking\\/\",\"changelog\":\"<h4>v2.0.3 - December 2, 2024<\\/h4>\\n<ul>\\n<li>Fix: Duplicate entry checks would usually fail with this add-on active because of the way that user journey data is stored. When performing duplicate checks with this add-on active, entry descriptions is no longer included in the query to allow for duplicate entry checks to work.<\\/li>\\n<li>Support for translations have been improved, including translated dates when viewing user flow data.<\\/li>\\n<\\/ul>\\n<h4>v2.0.2 - July 25, 2024<\\/h4>\\n<ul>\\n<li>New: This add-on is now translated in German, Spanish, French, Italian, and Brazilian Portuguese.<\\/li>\\n<li>Fix: Additional checks have been added to fix issues with user sessions starting during REST API requests. This includes an error that would appear on the Site Health page.<\\/li>\\n<li>Fix: More checks have been added to avoid starting sessions when running CLI commands.<\\/li>\\n<\\/ul>\\n<h4>v2.0.1 - June 6, 2024<\\/h4>\\n<ul>\\n<li>New: User flow summaries can now be collapsed and opened by date.<\\/li>\\n<li>New: Forms with no title will now display as (no title) in the user flow summary.<\\/li>\\n<li>Fix: Session start logic has been moved to help avoid a headers already sent PHP warning on admin pages.<\\/li>\\n<li>Fix: A bug has been fixed that would cause incorrect user flow duration values.<\\/li>\\n<\\/ul>\\n\",\"plugin\":\"formidable-user-tracking\\/formidable-user-tracking.php\",\"icons\":{\"1x\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png\"},\"banners\":{\"high\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\",\"low\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\"},\"search_terms\":\"\",\"is_new\":false},\"170655\":{\"title\":\"Mailchimp\",\"name\":\"Mailchimp\",\"display_name\":\"Mailchimp\",\"slug\":\"mailchimp\",\"version\":\"2.10\",\"new_version\":\"2.10\",\"location\":[\"fp.strategy11.com\\/releases\\/formidable-mailchimp\\/formidable-mailchimp-2.10.zip\"],\"excerpt\":\"Get on the path to more leads in minutes. Add and update leads in a Mailchimp mailing list when a form is submitted.\",\"id\":170655,\"released\":\"2013-10-17 00:00:00\",\"categories\":[\"Creator\",\"Email &amp; SMS Marketing\",\"Strategy11\"],\"docs\":\"\\/knowledgebase\\/formidable-mailchimp\\/\",\"link\":\"https:\\/\\/formidableforms.com\\/downloads\\/mailchimp\\/\",\"changelog\":\"<h4>v2.10 - June 18, 2025<\\/h4>\\n<ul>\\n<li>New: Mailchimp actions can now be delayed using form action automation.<\\/li>\\n<li>Fix: When a subscriber re-subscribes and double opt-in was enabled, the subscriber status would not update to subscribed.<\\/li>\\n<\\/ul>\\n<h4>v2.09 - November 5, 2024<\\/h4>\\n<ul>\\n<li>New: Mailchimp field data is now stored and re-used in the database to optimize Mailchimp actions. Previously two requests were required when subscribing, causing performance issues.<\\/li>\\n<li>New: When a Name field is mapped to a Mailchimp action, the (First) and (Last) descriptions are now included in the dropdown option label to make it more clear how the values are mapped.<\\/li>\\n<\\/ul>\\n<h4>v2.08 - September 3, 2024<\\/h4>\\n<ul>\\n<li>New: This plugin now includes translations for French, Spanish, Italian, German, Japanese and Brazilian Portuguese. This does not include dynamic fields loaded from Mailchimp\'s API.<\\/li>\\n<li>New: The field limit retrieved from the Mailchimp API has been increased from 30 to 100.<\\/li>\\n<\\/ul>\\n\",\"plugin\":\"formidable-mailchimp\\/formidable-mailchimp.php\",\"icons\":{\"1x\":\"https:\\/\\/formidableforms.com\\/wp-content\\/uploads\\/2013\\/04\\/mailchimp.png\"},\"banners\":{\"high\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\",\"low\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\"},\"search_terms\":\"\",\"is_new\":false},\"172715\":{\"title\":\"PayPal Basic\",\"name\":\"PayPal Basic\",\"display_name\":\"PayPal Basic\",\"slug\":\"paypal-standard-single-payments\",\"version\":\"3.08\",\"new_version\":\"3.08\",\"location\":[\"fp.strategy11.com\\/releases\\/formidable-paypal\\/formidable-paypal-3.08.zip\"],\"excerpt\":\"\",\"id\":172715,\"released\":\"2015-10-21 12:20:35\",\"categories\":[\"Ecommerce\",\"Strategy11\"],\"docs\":\"\",\"link\":\"https:\\/\\/formidableforms.com\\/downloads\\/paypal-standard-single-payments\\/\",\"changelog\":\"<h4>v3.02 - September 14, 2018<\\/h4>\\n<ul>\\n<li>Merge the older grandfathered PayPal addon with the updated version.<\\/li>\\n<\\/ul>\\n<h4>v2.04.07 - January 25, 2015<\\/h4>\\n<ul>\\n<li>Allow amounts with . for thousands and , for decimal. If a . is used in the decimal place for the amount when the currency uses a , make it work anyway<\\/li>\\n<li>Redirect to PayPal correctly without Pro<\\/li>\\n<li>Make sure email setting is trimmed before comparing<\\/li>\\n<li>Add download ID to make sure correct license is used<\\/li>\\n<\\/ul>\\n<h4>v2.04.06 - November 17, 2015<\\/h4>\\n<ul>\\n<li>Prevent errors when updating Formidable<\\/li>\\n<\\/ul>\\n<h4>v2.04.05<\\/h4>\\n<ul>\\n<li>Format decimals with . to allow float to work correctly<\\/li>\\n<li>Get updates from FormidablePro.com<\\/li>\\n<\\/ul>\\n<h4>v2.04.04<\\/h4>\\n<ul>\\n<li>Allow the amount to be included in the \\\"other\\\" option<\\/li>\\n<li>Modify the user-agent in the IPN verification to prevent errors from PayPal<\\/li>\\n<\\/ul>\\n<h4>v2.04.03<\\/h4>\\n<ul>\\n<li>Save the IPN parameters with the payment in the format that allows for multiple IPN notifications<\\/li>\\n<li>Fix sending users to Paypal when 2.x is installed, but the old settings haven\'t been moved to a form action<\\/li>\\n<li>Increased security related to XSS add_query_arg vulnerability<\\/li>\\n<\\/ul>\\n\",\"plugin\":\"paypal-standard-single-payments\\/paypal-standard-single-payments.php\",\"icons\":{\"1x\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png\"},\"banners\":{\"high\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\",\"low\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\"},\"search_terms\":\"\",\"is_new\":false},\"173984\":{\"title\":\"User Registration\",\"name\":\"User Registration\",\"display_name\":\"User Registration\",\"slug\":\"user-registration\",\"version\":\"3.0.1\",\"new_version\":\"3.0.1\",\"location\":[\"s3.amazonaws.com\\/fp.strategy11.com\\/releases\\/formidable-registration\\/formidable-registration-3.0.1.zip\"],\"excerpt\":\"Give new users access to your site quickly and painlessly. Plus edit profiles and login from the front end.\",\"id\":173984,\"released\":\"2011-12-21 00:00:00\",\"categories\":[\"Business\",\"Data Collection\",\"Form Functionality\",\"Strategy11\"],\"docs\":\"\\/knowledgebase\\/user-registration\\/\",\"link\":\"https:\\/\\/formidableforms.com\\/downloads\\/user-registration\\/\",\"changelog\":\"<h4>v3.0.1 - January 27, 2025<\\/h4>\\n<ul>\\n<li>New: Login forms will now use the label position setting used in the applied Formidable style added using the class shortcode option.<\\/li>\\n<li>New: An appropriate error message will now be shown the reset password email fails to send because of an email deliverability issue.<\\/li>\\n<li>New: Some changes have been made to support the SiteGround Security Optimizer plugin\'s custom login URL functionality. A new frmreg_supports_alternative_login_url filter has been added to enable an alternative URL for cases when wp-login is blocked by another plugin.<\\/li>\\n<li>Fix: Fields used in registration actions would fail required validation checks when inside of a conditionally hidden section.<\\/li>\\n<li>Fix: A fatal error would occur when unexpected array redirect data was submitted to the login form.<\\/li>\\n<li>Fix: The hook used to load translations has been updated to improve compatibility with WordPress 6.7+.<\\/li>\\n<li>The setting to automatically log in users who submit this form was been removed from repeated registration actions.<\\/li>\\n<\\/ul>\\n<h4>v3.0 - October 8, 2024<\\/h4>\\n<ul>\\n<li>New: Registration actions now include the option to run a registration action for each entry of a repeater. This allows you to create multiple users with a single form.<\\/li>\\n<li>New: When a Name field is mapped to a User Registration action, the (First) and (Last) descriptions are now included in the dropdown option label to make it more clear how the values are mapped.<\\/li>\\n<li>New: Missing for attributes have been added to user meta inputs to help improve accessibility.<\\/li>\\n<li>Fix: In some cases, multiple activation success messages would appear. A check has been added to limit the number of related success messages to one.<\\/li>\\n<li>Additional validation has been added when saving registration page settings to help prevent issues where shortcodes are later removed from previously valid login pages.<\\/li>\\n<li>Some references to old deprecated Pro functions have been updated.<\\/li>\\n<\\/ul>\\n<h4>v2.13 - April 4, 2024<\\/h4>\\n<ul>\\n<li>New: User moderation redirects now support a new option to Redirect to a URL.<\\/li>\\n<li>New: Links and forms have been updated to use the site URL for logging in instead of the network site URL.<\\/li>\\n<li>New: The &#091;frm-login] shortcode now support several new options including register_link, label_register, class_register for adding registration links to login forms.<\\/li>\\n<li>New: The logout_redirect option used in &#091;frm-login] shortcodes now supports numeric page ID values.<\\/li>\\n<li>New: &#091;frm-reset-password] shortcodes now support new password_strength=\\\"1\\\" and password_visibility_toggle=\\\"1\\\" options.<\\/li>\\n<li>Fix: Errors messages will now show on page load when using the slide=1 option with a &#091;frm-login] shortcode.<\\/li>\\n<li>Several old deprecated functions have been removed.<\\/li>\\n<\\/ul>\\n\",\"plugin\":\"formidable-registration\\/formidable-registration.php\",\"icons\":{\"1x\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png\"},\"banners\":{\"high\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\",\"low\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\"},\"search_terms\":\"registration, user registration, register\",\"is_new\":false},\"174006\":{\"title\":\"WooCommerce\",\"name\":\"WooCommerce\",\"display_name\":\"WooCommerce\",\"slug\":\"woocommerce\",\"version\":\"1.13\",\"new_version\":\"1.13\",\"location\":[\"fp.strategy11.com\\/releases\\/formidable-woocommerce\\/formidable-woocommerce-1.13.zip\"],\"excerpt\":\"Are your WooCommerce product forms too basic? Add custom fields to a product form and collect more data when it is added to the cart.\",\"id\":174006,\"released\":\"2016-01-19 00:00:00\",\"categories\":[\"Ecommerce\",\"Elite\",\"Strategy11\"],\"docs\":\"\\/knowledgebase\\/formidable-woocommerce\\/\",\"link\":\"https:\\/\\/formidableforms.com\\/downloads\\/woocommerce\\/\",\"changelog\":\"\",\"plugin\":\"formidable-woocommerce\\/formidable-woocommerce.php\",\"icons\":{\"1x\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png\"},\"banners\":{\"high\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\",\"low\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\"},\"search_terms\":\"\",\"is_new\":false},\"180495\":{\"title\":\"Highrise\",\"name\":\"Highrise\",\"display_name\":\"Highrise\",\"slug\":\"highrise\",\"version\":\"1.06\",\"new_version\":\"1.06\",\"location\":[\"fp.strategy11.com\\/releases\\/formidable-highrise\\/formidable-highrise-1.06.zip\"],\"excerpt\":\"Capture leads in your WordPress contact forms, and save them in your Highrise CRM account too.\",\"id\":180495,\"released\":\"2013-12-12 00:00:00\",\"categories\":[\"Creator\",\"CRM\",\"Strategy11\"],\"docs\":\"\\/knowledgebase\\/formidable-highrise\\/\",\"link\":\"https:\\/\\/formidableforms.com\\/downloads\\/highrise\\/\",\"changelog\":\"<h4>v1.06 - February 29, 2016<\\/h4>\\n<ul>\\n<li>Send the custom fields correctly to Highrise<\\/li>\\n<\\/ul>\\n<h4>v1.05 - February 23, 2016<\\/h4>\\n<ul>\\n<li>Fix email field settings in the Highrise action<\\/li>\\n<li>Make sure the license key is a Highrise license<\\/li>\\n<\\/ul>\\n<h4>v1.04 - February 9, 2016<\\/h4>\\n<ul>\\n<li>Added options to separate out address fields. City, State, Zip, and Country can now be mapped separately.<\\/li>\\n<li>Fixed PHP7 warnings<\\/li>\\n<\\/ul>\\n\",\"plugin\":\"formidable-highrise\\/formidable-highrise.php\",\"icons\":{\"1x\":\"https:\\/\\/formidableforms.com\\/wp-content\\/uploads\\/2012\\/01\\/highrise.png\"},\"banners\":{\"high\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\",\"low\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\"},\"search_terms\":\"\",\"is_new\":false},\"185013\":{\"title\":\"Bootstrap Modal\",\"name\":\"Bootstrap Modal\",\"display_name\":\"Bootstrap Modal\",\"slug\":\"bootstrap-modal\",\"version\":\"3.0.3\",\"new_version\":\"3.0.3\",\"location\":[\"fp.strategy11.com\\/releases\\/formidable-modal\\/formidable-modal-3.0.3.zip\"],\"excerpt\":\"Open forms, views, other shortcodes, or sections of content in a Bootstrap popup.\",\"id\":185013,\"released\":\"2015-08-26 00:00:00\",\"categories\":[\"Creator\",\"Form Design &amp; Display\",\"Form Functionality\",\"Strategy11\"],\"docs\":\"https:\\/\\/formidableforms.com\\/knowledgebase\\/bootstrap-modal\\/\",\"link\":\"https:\\/\\/formidableforms.com\\/downloads\\/bootstrap-modal\\/\",\"changelog\":\"<h4>v3.0.3 - April 30, 2025<\\/h4>\\n<ul>\\n<li>New: An info message shows in the modal if a form is used there without AJAX submission enabled.<\\/li>\\n<li>Fix: JS error when Formidable Forms isn\'t activated.<\\/li>\\n<li>Fix: A duplicated background color setting is removed.<\\/li>\\n<\\/ul>\\n<h4>v3.0.2 - December 11, 2023<\\/h4>\\n<ul>\\n<li>New: The modal block button will now have a default \\\"Click here\\\" text instead of an empty input to make quick testing easier.<\\/li>\\n<li>New: The modal close button will now longer appear in the block preview as it was getting in the way and served no purpose.<\\/li>\\n<li>New: The modal block has been updated to work better with white label settings.<\\/li>\\n<li>Fix: The autocomplete popup from the Formidable Geolocation add on would not appear inside of a Bootstrap modal because of a z-index issue.<\\/li>\\n<\\/ul>\\n<h4>v3.0.1 - June 26, 2023<\\/h4>\\n<ul>\\n<li>Fix: Modals were hidden when the Formidable Bootstrap add on was also active.<\\/li>\\n<li>Fix: Modals made with the [[frmmodal-content]] shortcode were missing a backdrop.<\\/li>\\n<\\/ul>\\n\",\"plugin\":\"formidable-modal\\/formidable-modal.php\",\"icons\":{\"1x\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png\"},\"banners\":{\"high\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\",\"low\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\"},\"search_terms\":\"modal, popup\",\"is_new\":false},\"209561\":{\"title\":\"Polylang\",\"name\":\"Polylang\",\"display_name\":\"Polylang\",\"slug\":\"polylang\",\"version\":\"1.14\",\"new_version\":\"1.14\",\"location\":[\"fp.strategy11.com\\/releases\\/formidable-polylang\\/formidable-polylang-1.14.zip\"],\"excerpt\":\"Create bilingual or multilingual forms with help from Polylang.\",\"id\":209561,\"released\":\"2016-01-22 00:00:00\",\"categories\":[\"Business\",\"Multilingual\",\"Strategy11\"],\"docs\":\"\\/knowledgebase\\/formidable-polylang\\/\",\"link\":\"https:\\/\\/formidableforms.com\\/downloads\\/polylang\\/\",\"changelog\":\"<h4>v1.14 - June 2, 2025<\\/h4>\\n<ul>\\n<li>Fix: Saving Polylang translations would trigger a fatal error when using the newest version of Polylang.<\\/li>\\n<li>Fix: Checkbox fields would fail option validation when the checkbox options were translated and the checkbox field was on a page other than the last page.<\\/li>\\n<\\/ul>\\n<h4>v1.13 - October 29, 2024<\\/h4>\\n<ul>\\n<li>New: The text for previous buttons used in multiple page forms is now translatable.<\\/li>\\n<li>New: The text for the start and continue buttons used in conversational forms are now translatable.<\\/li>\\n<\\/ul>\\n<h4>v1.12 - August 19, 2024<\\/h4>\\n<ul>\\n<li>New: This plugin now includes translations for French, Spanish, Italian, German, Japanese and Brazilian Portuguese.<\\/li>\\n<li>Fix: A trim(): Passing null to parameter deprecated message when viewing a form has been fixed.<\\/li>\\n<\\/ul>\\n\",\"plugin\":\"formidable-polylang\\/frm-poly.php\",\"icons\":{\"1x\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png\"},\"banners\":{\"high\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\",\"low\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\"},\"search_terms\":\"\",\"is_new\":false},\"310430\":{\"title\":\"Stripe\",\"name\":\"Stripe\",\"display_name\":\"Stripe\",\"slug\":\"stripe\",\"version\":\"3.1.8\",\"new_version\":\"3.1.8\",\"location\":[\"fp.strategy11.com\\/releases\\/formidable-stripe\\/formidable-stripe-3.1.8.zip\"],\"excerpt\":\"Any Formidable forms on your site can accept credit card payments without users ever leaving your site.\",\"id\":310430,\"released\":\"2016-04-26 00:00:00\",\"categories\":[\"Business\",\"Ecommerce\",\"Strategy11\"],\"docs\":\"\\/knowledgebase\\/stripe\\/\",\"link\":\"https:\\/\\/formidableforms.com\\/downloads\\/stripe\\/\",\"changelog\":\"<h4>v3.1.8 - June 11, 2025<\\/h4>\\n<ul>\\n<li>Fix: A fatal error would occur when using both Authorize.Net v2.0.4 and this Stripe add-on.<\\/li>\\n<li>Fix: Stripe scripts would incorrectly load in cases where the Stripe gateway was not selected.<\\/li>\\n<li>Fix: The Stripe link toggle would appear in cases where the Stripe gateway was not selected.<\\/li>\\n<\\/ul>\\n<h4>v3.1.7 - May 6, 2025<\\/h4>\\n<ul>\\n<li>New: Stripe payment fields will now apply border radius styles to match styling better.<\\/li>\\n<li>New: Stripe payment field label styling has been updated to better reflect label padding style settings.<\\/li>\\n<li>New: Stripe payment fields will now use the input weight style setting to look more consistent with other fields.<\\/li>\\n<li>New: Stripe payment fields now support the font family style setting.<\\/li>\\n<li>New: A new layout setting has been added to Stripe settings that adds support for the accordion layout.<\\/li>\\n<li>New: A new frm_stripe_appearance_rules filter has been added to make it possible to match a Stripe link field to a theme.<\\/li>\\n<li>Fix: The PayPal gateway option wouldn\'t appear on the edit payment page.<\\/li>\\n<li>Fix: A dynamic trial period based on a shortcode would fallback to a 1 day trial when it should be 0.<\\/li>\\n<li>Fix: An in-progress form entry created using the Form Abandonment add-on would not properly submit when using a Stripe action.<\\/li>\\n<\\/ul>\\n<h4>v3.1.6 - January 27, 2025<\\/h4>\\n<ul>\\n<li>New: This plugin now includes translations for French, Spanish, Italian, German, Japanese, and Brazilian Portuguese.<\\/li>\\n<li>New: The required email field used for Stripe Link payments will now display a required asterisk like other required fields.<\\/li>\\n<li>New: When a Name field is mapped to a Stripe payment action, the (First) and (Last) descriptions are now included in the dropdown option label to make it more clear how the values are mapped.<\\/li>\\n<li>New: Screen reader text has been updated to the payments admin page to improve accessibility.<\\/li>\\n<li>Fix: Conditional confirmation actions would not work as expected when using Stripe Link.<\\/li>\\n<li>Fix: Several additional checks have been added to help prevent issues with duplicate email notifications getting sent when a Stripe Link payment has been completed in some cases.<\\/li>\\n<li>Fix: Stripe payments would fail to initialize when using shortcode amount values for many currency types including Mexican Pesos.<\\/li>\\n<li>Fix: Additional checks have been added to prevent an Undefined array key \\u201ccapture\\u201d PHP warning.<\\/li>\\n<li>Fix: A conversational form with Stripe disabled would not submit normally.<\\/li>\\n<li>Fix: The hook used to load translations has been updated to improve compatibility with WordPress 6.7+.<\\/li>\\n<li>Fix: The test mode column wasn\'t getting set up properly for Stripe Link payments.<\\/li>\\n<li>A reference to an old function, frmFrontForm.savingDraft, that no longer exists has been removed.<\\/li>\\n<li>Checks have been added to avoid trying to extend the time limit when the set_time_limit function does not exist to improve compatibility.<\\/li>\\n<\\/ul>\\n\",\"plugin\":\"formidable-stripe\\/formidable-stripe.php\",\"icons\":{\"1x\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png\"},\"banners\":{\"high\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\",\"low\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\"},\"search_terms\":\"\",\"is_new\":false},\"326042\":{\"title\":\"Form Action Automation\",\"name\":\"Form Action Automation\",\"display_name\":\"Form Action Automation\",\"slug\":\"autoresponder\",\"version\":\"2.09\",\"new_version\":\"2.09\",\"location\":[\"fp.strategy11.com\\/releases\\/autoresponder\\/formidable-autoresponder-2.09.zip\"],\"excerpt\":\"Schedule email notifications, SMS messages, and API actions.\",\"id\":326042,\"released\":\"2016-09-21 00:00:00\",\"categories\":[\"Automation\",\"Elite\",\"Marketing\",\"Strategy11\"],\"docs\":\"\\/knowledgebase\\/schedule-autoresponder\\/\",\"link\":\"https:\\/\\/formidableforms.com\\/downloads\\/autoresponder\\/\",\"changelog\":\"<h4>v2.09 - June 18, 2025<\\/h4>\\n<ul>\\n<li>New: Added support for automating more types of form actions.<\\/li>\\n<\\/ul>\\n<h4>v2.08 - August 13, 2024<\\/h4>\\n<ul>\\n<li>New: This plugin now includes translations for French, Spanish, Italian, German, Japanese and Brazilian Portuguese.<\\/li>\\n<\\/ul>\\n<h4>v2.07 - April 29, 2024<\\/h4>\\n<ul>\\n<li>New: The frm_autoresponder_time filter is now always applied. Previously this filter was only used when date or time fields were defined as the send date setting.<\\/li>\\n<li>New: Strings used in this plugin can now be translated.<\\/li>\\n<li>Fix: A bug has been fixed that would strip &#091;] shortcode characters after duplicating a form action with dashes in the value like a date format.<\\/li>\\n<\\/ul>\\n\",\"plugin\":\"formidable-autoresponder\\/formidable-autoresponder.php\",\"icons\":{\"1x\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png\"},\"banners\":{\"high\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\",\"low\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\"},\"search_terms\":\"automate, automation\",\"is_new\":false},\"337527\":{\"title\":\"Authorize.net AIM\",\"name\":\"Authorize.net AIM\",\"display_name\":\"Authorize.net AIM\",\"slug\":\"authorize-net-aim\",\"version\":\"2.04\",\"new_version\":\"2.04\",\"location\":[\"fp.strategy11.com\\/releases\\/authorize-net\\/formidable-authorize-net-2.04.zip\"],\"excerpt\":\"Accept one-time payments directly on your site, using Authorize.net AIM.\",\"id\":337527,\"released\":\"2016-04-29 00:00:00\",\"categories\":[\"Ecommerce\",\"Elite\",\"Strategy11\"],\"docs\":\"\\/knowledgebase\\/authorize-net-aim\\/\",\"link\":\"https:\\/\\/formidableforms.com\\/downloads\\/authorize-net-aim\\/\",\"changelog\":\"<h4>v2.04 - June 5, 2025<\\/h4>\\n<ul>\\n<li>New: A new &#091;frm-payment] shortcode has been added. This can be used to display quick details about a payment for a given entry ID. For example, &#091;frm-payment entry=&#091;id] show=amount] can be used in a view to get the payment amount.<\\/li>\\n<li>New: Screen reader text has been updated to the payments admin page to improve accessibility.<\\/li>\\n<li>Fix: Repeated fields would disappear after reloading a form as the result of a failed payment.<\\/li>\\n<li>Fix: Shipping information would not appear on load unless shipping was already enabled.<\\/li>\\n<li>Fix: An autoload issue would result in fatal errors on some sites.<\\/li>\\n<li>Fix: A Creation of dynamic property FrmAuthNetApi::$endpoint is deprecated PHP deprecation message that happens in PHP 8.2+ has been fixed.<\\/li>\\n<li>Fix: The PayPal gateway option wouldn\'t appear on the edit payment page.<\\/li>\\n<li>When a Name field is mapped to a payment action, the (First) and (Last) descriptions are now included in the dropdown option label to make it more clear how the values are mapped.<\\/li>\\n<\\/ul>\\n<h4>v2.03 - April 24, 2024<\\/h4>\\n<ul>\\n<li>Fix: A FrmTransActionsController not found fatal error related to autoloading occuring on some server configurations has been fixed.<\\/li>\\n<\\/ul>\\n<h4>v2.02 - March 7, 2022<\\/h4>\\n<ul>\\n<li>New: Name fields will now automatically map the proper first and last name values when sending to Authorize.net.<\\/li>\\n<li>New: Set the default currency to the one selected in global settings.<\\/li>\\n<li>New: Added additional currencies from Pro.<\\/li>\\n<li>Fix: Payments would not work if the amount specified was formatted as currency.<\\/li>\\n<li>Fix: Prevent a fatal error that happens in PHP8 when filling payment information.<\\/li>\\n<li>Fix: Expire dates were not properly calculating.<\\/li>\\n<li>Fix: Some echecks were not getting approved.<\\/li>\\n<li>Fix: Updated incorrect text domains.<\\/li>\\n<\\/ul>\\n\",\"plugin\":\"formidable-authorize-net\\/formidable-authorize-net.php\",\"icons\":{\"1x\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png\"},\"banners\":{\"high\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\",\"low\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\"},\"search_terms\":\"Authorize.net\",\"is_new\":false},\"11927748\":{\"title\":\"Logs\",\"name\":\"Logs\",\"display_name\":\"Logs\",\"slug\":\"logs\",\"version\":\"1.0.4\",\"new_version\":\"1.0.4\",\"location\":[\"fp.strategy11.com\\/releases\\/logs\\/formidable-logs-1.0.4.zip\"],\"excerpt\":\"See your API requests along with their responses from add-ons including Zapier, Formidable API Webhooks, Salesforce and more.\",\"id\":11927748,\"released\":\"2016-12-19 00:00:00\",\"categories\":[\"Basic\",\"Strategy11\",\"Utilities\"],\"docs\":\"https:\\/\\/formidableforms.com\\/knowledgebase\\/logging\\/\",\"link\":\"https:\\/\\/formidableforms.com\\/downloads\\/logs\\/\",\"changelog\":\"\",\"plugin\":\"formidable-logs\\/formidable-logs.php\",\"icons\":{\"1x\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png\"},\"banners\":{\"high\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\",\"low\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\"},\"search_terms\":\"\",\"is_new\":false},\"19366992\":{\"title\":\"Formidable Pro Elite Package\",\"name\":\"Formidable Pro Elite Package\",\"display_name\":\"Formidable Pro Elite Package\",\"slug\":\"formidable-pro-enterprise-package\",\"version\":\"\",\"new_version\":\"\",\"location\":[],\"excerpt\":\"\",\"id\":19366992,\"released\":\"2017-09-01 12:09:38\",\"categories\":[\"Strategy11\"],\"docs\":\"\",\"link\":\"https:\\/\\/formidableforms.com\\/downloads\\/formidable-pro-enterprise-package\\/\",\"changelog\":\"\",\"plugin\":\"formidable-pro-enterprise-package\\/formidable-pro-enterprise-package.php\",\"icons\":{\"1x\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png\"},\"banners\":{\"high\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\",\"low\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\"},\"search_terms\":\"\",\"is_new\":false},\"19366995\":{\"title\":\"Formidable Pro Business Package\",\"name\":\"Formidable Pro Business Package\",\"display_name\":\"Formidable Pro Business Package\",\"slug\":\"formidable-pro-small-business-package\",\"version\":\"\",\"new_version\":\"\",\"location\":[],\"excerpt\":\"\",\"id\":19366995,\"released\":\"2017-09-01 12:09:09\",\"categories\":[\"Strategy11\"],\"docs\":\"\",\"link\":\"https:\\/\\/formidableforms.com\\/downloads\\/formidable-pro-small-business-package\\/\",\"changelog\":\"\",\"plugin\":\"formidable-pro-small-business-package\\/formidable-pro-small-business-package.php\",\"icons\":{\"1x\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png\"},\"banners\":{\"high\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\",\"low\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\"},\"search_terms\":\"\",\"is_new\":false},\"19367001\":{\"title\":\"Formidable Pro Creator Package\",\"name\":\"Formidable Pro Creator Package\",\"display_name\":\"Formidable Pro Creator Package\",\"slug\":\"formidable-pro-professional-package\",\"version\":\"\",\"new_version\":\"\",\"location\":[],\"excerpt\":\"\",\"id\":19367001,\"released\":\"2017-09-01 12:10:24\",\"categories\":[\"Strategy11\"],\"docs\":\"\",\"link\":\"https:\\/\\/formidableforms.com\\/downloads\\/formidable-pro-professional-package\\/\",\"changelog\":\"\",\"plugin\":\"formidable-pro-professional-package\\/formidable-pro-professional-package.php\",\"icons\":{\"1x\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png\"},\"banners\":{\"high\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\",\"low\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\"},\"search_terms\":\"\",\"is_new\":false},\"19367654\":{\"title\":\"Formidable Pro Single Site\",\"name\":\"Formidable Pro Single Site\",\"display_name\":\"Formidable Pro Single Site\",\"slug\":\"formidable-pro-single-site\",\"version\":\"\",\"new_version\":\"\",\"location\":[],\"excerpt\":\"\",\"id\":19367654,\"released\":\"2017-09-01 13:36:16\",\"categories\":[\"Strategy11\"],\"docs\":\"\",\"link\":\"https:\\/\\/formidableforms.com\\/downloads\\/formidable-pro-single-site\\/\",\"changelog\":\"\",\"plugin\":\"formidable-pro-single-site\\/formidable-pro-single-site.php\",\"icons\":{\"1x\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png\"},\"banners\":{\"high\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\",\"low\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\"},\"search_terms\":\"\",\"is_new\":false},\"20247260\":{\"title\":\"Datepicker Options\",\"name\":\"Datepicker Options\",\"display_name\":\"Datepicker Options\",\"slug\":\"datepicker-options\",\"version\":\"2.1\",\"new_version\":\"2.1\",\"location\":[\"fp.strategy11.com\\/releases\\/dates\\/formidable-dates-2.1.zip\"],\"excerpt\":\"Add more options to date fields in your forms for so only the dates you choose can be chosen.\",\"id\":20247260,\"released\":\"2018-07-30 00:00:00\",\"categories\":[\"Business\",\"Form Functionality\",\"Strategy11\"],\"docs\":\"\\/knowledgebase\\/datepicker-options\\/\",\"link\":\"https:\\/\\/formidableforms.com\\/downloads\\/datepicker-options\\/\",\"changelog\":\"<h4>v2.1 - February 24, 2025<\\/h4>\\n<ul>\\n<li>New: This plugin now includes translations for French, Spanish, Italian, German, Japanese and Brazilian Portuguese.<\\/li>\\n<li>Fix: Inline date fields would not initialize properly in new forms that appears after a form is completed when submitting with AJAX.<\\/li>\\n<li>Fix: The hook used to load translations has been updated to improve compatibility with WordPress 6.7+.<\\/li>\\n<\\/ul>\\n<h4>v2.0.4 - March 28, 2024<\\/h4>\\n<ul>\\n<li>New: Blocked dates are no longer counted in &#091;date_calc] shortcode calculations by default when using the format=\\\"days\\\" option. In order to count blocked out dates, you must now include a new count_blackout_dates=\\\"1\\\" option.<\\/li>\\n<li>New: The strings used in this add-on can now be translated.<\\/li>\\n<li>Fix: Date calculations would trigger an error pop up on the edit entry admin page.<\\/li>\\n<li>Fix: Some date field validation checks would fail when sending a date value in Y-m-d format instead of the global date format setting.<\\/li>\\n<li>Fix: When validating if a date value is greater than or less than today, the value for today was based on the UTC timezone instead of the server timezone.<\\/li>\\n<\\/ul>\\n<h4>v2.0.3 - November 6, 2023<\\/h4>\\n<ul>\\n<li>Fix: Some inline datepickers were breaking because of a <span class=\\\"message-body-wrapper\\\"><span class=\\\"message-flex-body\\\"><span class=\\\"message-body devtools-monospace\\\"><span class=\\\"objectBox-stackTrace reps-custom-format\\\" data-link-actor-id=\\\"server0.conn0.windowGlobal450971566097\\/obj74\\\"><span class=\\\"objectBox objectBox-string\\\">settings is undefined<\\/span><\\/span><\\/span><\\/span><\\/span> JavaScript error.<\\/li>\\n<\\/ul>\\n\",\"plugin\":\"formidable-dates\\/formidable-dates.php\",\"icons\":{\"1x\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png\"},\"banners\":{\"high\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\",\"low\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\"},\"search_terms\":\"datepicker\",\"is_new\":false},\"20266559\":{\"title\":\"Salesforce\",\"name\":\"Salesforce\",\"display_name\":\"Salesforce\",\"slug\":\"salesforce\",\"version\":\"2.05\",\"new_version\":\"2.05\",\"location\":[\"fp.strategy11.com\\/releases\\/salesforce\\/formidable-salesforce-2.05.zip\"],\"excerpt\":\"Add new contacts and leads into your Salesforce CRM directly from the WordPress forms on your site.\",\"id\":20266559,\"released\":\"2018-05-31 00:00:00\",\"categories\":[\"CRM\",\"Elite\"],\"docs\":\"https:\\/\\/formidableforms.com\\/knowledgebase\\/salesforce-forms\\/\",\"link\":\"https:\\/\\/formidableforms.com\\/downloads\\/salesforce\\/\",\"changelog\":\"<h4>v2.06 - November 1, 2024<\\/h4>\\n<ul>\\n<li>New: This plugin now includes translations for French, Spanish, Italian, German, Japanese and Brazilian Portuguese.<\\/li>\\n<li>New: Users are no longer required to replace the %3D%3D text copied from the end of their Authentication code when authenticating, making it easier to get set-up.<\\/li>\\n<\\/ul>\\n<h4>v2.05 - June 11, 2024<\\/h4>\\n<ul>\\n<li>New: Field dropdowns have been updated to enable support for repeater actions.<\\/li>\\n<li>Fix: Authentication errors would not visibly appear, making it difficult to troubleshoot authentication issues.<\\/li>\\n<li>Fix: A Trying to access array offset on value of type bool PHP Warning has been fixed.<\\/li>\\n<li>Fix: An Implicit conversion from float to int loses precision PHP Deprecated message has been fixed.<\\/li>\\n<li>Fix: An Automatic conversion of false to array is deprecated PHP Deprecated message has been fixed.<\\/li>\\n<\\/ul>\\n<h4>v2.04 - December 10, 2019<\\/h4>\\n<ul>\\n<li>New: Show Salesforce Authentication errors on the global settings page<\\/li>\\n<li>Add icon in global settings<\\/li>\\n<li>Use font icon instead of image in form action<\\/li>\\n<li>Remove debug mode in favor of logging<\\/li>\\n<li>Tweak: Clear the settings cache with a link instead of ajax for more reliable cache clearing<\\/li>\\n<li>Fix: Updating data in Salesforce wasn\'t working correctly<\\/li>\\n<li>Fix: There was an error when Formidable was disabled<\\/li>\\n<\\/ul>\\n\",\"plugin\":\"formidable-salesforce\\/formidable-salesforce.php\",\"icons\":{\"1x\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png\"},\"banners\":{\"high\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\",\"low\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\"},\"search_terms\":\"\",\"is_new\":false},\"20781560\":{\"title\":\"MailPoet Newsletters\",\"name\":\"MailPoet Newsletters\",\"display_name\":\"MailPoet Newsletters\",\"slug\":\"mailpoet-newsletters\",\"version\":\"1.04\",\"new_version\":\"1.04\",\"location\":[\"fp.strategy11.com\\/releases\\/mailpoet\\/formidable-mailpoet-1.04.zip\"],\"excerpt\":\"Send WordPress newsletters from your own site with MailPoet. And use Formidable to for your newsletter signup forms.\",\"id\":20781560,\"released\":\"2018-06-05 00:00:00\",\"categories\":[\"Creator\",\"Email &amp; SMS Marketing\"],\"docs\":\"https:\\/\\/formidableforms.com\\/knowledgebase\\/mailpoet-newsletter-signup-forms\\/\",\"link\":\"https:\\/\\/formidableforms.com\\/downloads\\/mailpoet-newsletters\\/\",\"changelog\":\"<h4>v1.04 - August 20, 2024<\\/h4>\\n<ul>\\n<li>New: This plugin now includes translations for French, Spanish, Italian, German, Japanese and Brazilian Portuguese.<\\/li>\\n<\\/ul>\\n<h4>v1.03 - June 11, 2024<\\/h4>\\n<ul>\\n<li>New: Field dropdowns have been updated to enable support for repeater actions.<\\/li>\\n<\\/ul>\\n<h4>v1.02 - July 12, 2022<\\/h4>\\n<ul>\\n<li>New: Added support for logging MailPoet subscriptions when the Logs add on is active.<\\/li>\\n<li>New: Name fields will now automatically map the proper first and last name values when sending to MailPoet.<\\/li>\\n<li>Fix: Users could not subscribe to multiple lists when the active language was not in English because the error check was specific to language.<\\/li>\\n<li>Fix: Prevent a warning when sending data with MailPoet action.<\\/li>\\n<li>Fix: Nothing would get sent when a user id field was set to something other than a name or email option.<\\/li>\\n<\\/ul>\\n\",\"plugin\":\"formidable-mailpoet\\/formidable-mailpoet.php\",\"icons\":{\"1x\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png\"},\"banners\":{\"high\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\",\"low\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\"},\"search_terms\":\"\",\"is_new\":false},\"20790298\":{\"title\":\"Active Campaign\",\"name\":\"Active Campaign\",\"display_name\":\"ActiveCampaign\",\"slug\":\"activecampaign-wordpress-plugin\",\"version\":\"1.10\",\"new_version\":\"1.10\",\"location\":[\"fp.strategy11.com\\/releases\\/activecampaign\\/formidable-activecampaign-1.10.zip\"],\"excerpt\":\"Add contacts to any ActiveCampaign list from your WordPress forms.\",\"id\":20790298,\"released\":\"2018-07-05 00:00:00\",\"categories\":[\"Elite\",\"Email &amp; SMS Marketing\"],\"docs\":\"https:\\/\\/formidableforms.com\\/knowledgebase\\/activecampaign-forms\\/\",\"link\":\"https:\\/\\/formidableforms.com\\/downloads\\/activecampaign-wordpress-plugin\\/\",\"changelog\":\"<h4>v1.10 - June 11, 2024<\\/h4>\\n<ul>\\n<li>New: Field dropdowns have been updated to enable support for repeater actions.<\\/li>\\n<\\/ul>\\n<h4>v1.09 - March 25, 2024<\\/h4>\\n<ul>\\n<li>New: The strings used in this add-on can now be translated.<\\/li>\\n<li>Fix: An Uncaught Error: Class \\\"FrmFormAction\\\" not found fatal error has been fixed that happens on WPEngine hosted servers using PHP 8.2.<\\/li>\\n<\\/ul>\\n<h4>v1.08 - June 16, 2021<\\/h4>\\n<ul>\\n<li>New: Name fields will now automatically map the proper first and last name values when sending to ActiveCampaign.<\\/li>\\n<li>Fix: Errors messages were not displaying properly in settings when an ActiveCampaign trial had expired.<\\/li>\\n<li>Fix: Nothing would get sent when a user id field was set to something other than a name or email option.<\\/li>\\n<\\/ul>\\n\",\"plugin\":\"formidable-activecampaign\\/formidable-activecampaign.php\",\"icons\":{\"1x\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png\"},\"banners\":{\"high\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\",\"low\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\"},\"search_terms\":\"ActiveCampaign\",\"is_new\":false},\"20811871\":{\"title\":\"HubSpot\",\"name\":\"HubSpot\",\"display_name\":\"HubSpot\",\"slug\":\"hubspot-wordpress\",\"version\":\"2.0.2\",\"new_version\":\"2.0.2\",\"location\":[\"fp.strategy11.com\\/releases\\/hubspot\\/formidable-hubspot-2.0.2.zip\"],\"excerpt\":\"HubSpot is a complete CRM platform with tools for increased leads, accelerated sales, or streamlined customer service.\",\"id\":20811871,\"released\":\"2018-09-04 00:00:00\",\"categories\":[\"CRM\",\"Elite\"],\"docs\":\"https:\\/\\/formidableforms.com\\/knowledgebase\\/hubspot-forms\\/\",\"link\":\"https:\\/\\/formidableforms.com\\/downloads\\/hubspot-wordpress\\/\",\"changelog\":\"<h4>v2.0.2 - September 23, 2024<\\/h4>\\n<ul>\\n<li>New: This plugin now includes translations for French, Spanish, Italian, German, Japanese and Brazilian Portuguese.<\\/li>\\n<li>New: When a Name field is mapped to a HubSpot action, the (First) and (Last) descriptions are now included in the dropdown option label to make it more clear how the values are mapped.<\\/li>\\n<\\/ul>\\n<h4>v2.0.1 - June 11, 2024<\\/h4>\\n<ul>\\n<li>New: Field dropdowns have been updated to enable support for repeater actions.<\\/li>\\n<li>New: The request sent to get lists from Hubspot will now only query for static lists, allowing each request to get more lists without hitting page limits.<\\/li>\\n<li>New: If there are more than 250 static contact lists, multiple requests will be made to get the full list of static Hubspot contact lists.<\\/li>\\n<li>Fix: European private app access tokens would fail to validate.<\\/li>\\n<\\/ul>\\n<h4>v2.0 - March 27, 2023<\\/h4>\\n<ul class=\\\"p-rich_text_list p-rich_text_list__bullet\\\" data-stringify-type=\\\"unordered-list\\\" data-indent=\\\"0\\\" data-border=\\\"0\\\">\\n<li data-stringify-indent=\\\"0\\\" data-stringify-border=\\\"0\\\">New: Added a new OAuth2 authentication method.<\\/li>\\n<li data-stringify-indent=\\\"0\\\" data-stringify-border=\\\"0\\\">New: While using the new OAuth2 authentication, contacts will now get deleted with a webhook after they are removed from HubSpot for GDPR compliance.<\\/li>\\n<li data-stringify-indent=\\\"0\\\" data-stringify-border=\\\"0\\\">New: Added translation support.<\\/li>\\n<li data-stringify-indent=\\\"0\\\" data-stringify-border=\\\"0\\\">New: Improved error handling when inputting an invalid Private App Access token.<\\/li>\\n<li data-stringify-indent=\\\"0\\\" data-stringify-border=\\\"0\\\">Fix: List data would display as an error after successfully authenticating HubSpot and after successfully clearing the cache.<\\/li>\\n<li data-stringify-indent=\\\"0\\\" data-stringify-border=\\\"0\\\">Fix: HubSpot access tokens would fail to save while the Geolocation add on was also active.<\\/li>\\n<li data-stringify-indent=\\\"0\\\" data-stringify-border=\\\"0\\\">Deprecated HubSpot API Keys are no longer supported.<\\/li>\\n<\\/ul>\\n\",\"plugin\":\"formidable-hubspot\\/formidable-hubspot.php\",\"icons\":{\"1x\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png\"},\"banners\":{\"high\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\",\"low\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\"},\"search_terms\":\"\",\"is_new\":false},\"20813244\":{\"title\":\"GetResponse\",\"name\":\"GetResponse\",\"display_name\":\"GetResponse\",\"slug\":\"getresponse-wordpress-plugin\",\"version\":\"1.06\",\"new_version\":\"1.06\",\"location\":[\"fp.strategy11.com\\/releases\\/getresponse\\/formidable-getresponse-1.06.zip\"],\"excerpt\":\"Collect leads in WordPress forms and automatically add them in GetResponse. Then trigger automatic emails and other GetResponse marketing automations.\",\"id\":20813244,\"released\":\"2018-09-06 00:00:00\",\"categories\":[\"Business\",\"Email &amp; SMS Marketing\"],\"docs\":\"https:\\/\\/formidableforms.com\\/knowledgebase\\/getresponse-forms\\/\",\"link\":\"https:\\/\\/formidableforms.com\\/downloads\\/getresponse-wordpress-plugin\\/\",\"changelog\":\"<h4>v1.06 - June 11, 2024<\\/h4>\\n<ul>\\n<li>New: Field dropdowns have been updated to enable support for repeater actions.<\\/li>\\n<li>New: Strings used in this plugin can now be translated.<\\/li>\\n<\\/ul>\\n<h4>v1.05 - June 21, 2021<\\/h4>\\n<ul>\\n<li>New: Name fields will now automatically map the proper first and last name values when sending to GetResponse.<\\/li>\\n<li>Fix: Nothing would get sent when a user id field was set to something other than a name or email option.<\\/li>\\n<\\/ul>\\n<h4>v1.04 - October 2, 2019<\\/h4>\\n<ul>\\n<li>Allow 0 for the cycle start day<\\/li>\\n<li>Show more helpful messages in the form action if the GetResponse lists cannot be fetched<\\/li>\\n<li>Update the form action icon for 4.0<\\/li>\\n<li>Remove the debug mode option and use the Logging plugin instead<\\/li>\\n<li>Load all custom fields right away since they aren\'t different for each list. Also don\'t hide the custom fields when a list changes.<\\/li>\\n<li>Prevent error with Formidable disabled<\\/li>\\n<\\/ul>\\n\",\"plugin\":\"formidable-getresponse\\/formidable-getresponse.php\",\"icons\":{\"1x\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png\"},\"banners\":{\"high\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\",\"low\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\"},\"search_terms\":\"\",\"is_new\":false},\"20815759\":{\"title\":\"Quiz Maker\",\"name\":\"Quiz Maker\",\"display_name\":\"Quiz Maker\",\"slug\":\"quiz-maker\",\"version\":\"3.1.6\",\"new_version\":\"3.1.6\",\"location\":[\"fp.strategy11.com\\/releases\\/quiz\\/formidable-quizzes-3.1.6.zip\"],\"excerpt\":\"Turn your forms into automated quizzes. Add questions and submit the quiz key. Then all the grading is done for you.\",\"id\":20815759,\"released\":\"2018-09-13 00:00:00\",\"categories\":[\"Business\",\"Data Collection\",\"Strategy11\"],\"docs\":\"\\/knowledgebase\\/quiz-maker-forms\\/\",\"link\":\"https:\\/\\/formidableforms.com\\/downloads\\/quiz-maker\\/\",\"changelog\":\"<h4>v3.1.6 - January 30, 2025<\\/h4>\\n<p>Fix: Manual scoring doesn\'t work on the entry page.<\\/p>\\n<h4>v3.1.5 - January 20, 2025<\\/h4>\\n<ul>\\n<li>New: This plugin now includes translations for French, Spanish, Italian, German, Japanese, and Brazilian Portuguese.<\\/li>\\n<li>New: Scored quizzes now support less than and greater than options.<\\/li>\\n<li>New: Outcome quizzes now support displaying the score in percentage and fraction.<\\/li>\\n<li>Fix: Scrolling issue when setting up scored quizzes.<\\/li>\\n<li>Fix: Form submit button is in the wrong place if Randomize questions is enabled.<\\/li>\\n<li>Optimized scripts loading in the backend.<\\/li>\\n<\\/ul>\\n<h4>v3.1.4 - June 3, 2024<\\/h4>\\n<ul>\\n<li>Fix: A styling has has been applied to the + and - buttons for adding and removing quiz grade options in global settings.<\\/li>\\n<li>Fix: Forms with CAPTCHA fields would fail validation when submitting on forms using the format=\\\"quiz_correct_answers\\\" option for &#091;default-message] shortcodes used in email actions.<\\/li>\\n<li>Fix: Multiple scores would appear when using the scored quiz options to show the score after submitting a form multiple times when submitting with AJAX.<\\/li>\\n<li>Fix: An incorrect error message would appear when trying to add quiz outcomes and scored quiz actions to the same form.<\\/li>\\n<li>Confirmation action messages with scripts would always get stripped when included in a quiz score message. This is now only stripped based on site rules for handling unfiltered HTML.<\\/li>\\n<\\/ul>\\n\",\"plugin\":\"formidable-quizzes\\/formidable-quizzes.php\",\"icons\":{\"1x\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png\"},\"banners\":{\"high\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\",\"low\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\"},\"search_terms\":\"quiz, quizzes\",\"is_new\":false},\"20826884\":{\"title\":\"Constant Contact\",\"name\":\"Constant Contact\",\"display_name\":\"Constant Contact\",\"slug\":\"constant-contact\",\"version\":\"1.07\",\"new_version\":\"1.07\",\"location\":[\"fp.strategy11.com\\/releases\\/constant-contact\\/formidable-constantcontact-1.07.zip\"],\"excerpt\":\"Setup WordPress forms to create leads automatically in Constant Contact. Just select a list and match up form fields.\",\"id\":20826884,\"released\":\"2018-10-15 00:00:00\",\"categories\":[\"Business\",\"Email &amp; SMS Marketing\"],\"docs\":\"\\/knowledgebase\\/constant-contact-forms\\/\",\"link\":\"https:\\/\\/formidableforms.com\\/downloads\\/constant-contact\\/\",\"changelog\":\"<h4>v1.08 - October 1, 2024<\\/h4>\\n<ul>\\n<li>New: This plugin now includes translations for French, Spanish, Italian, German, Japanese and Brazilian Portuguese.<\\/li>\\n<\\/ul>\\n<h4>v1.07 - June 11, 2024<\\/h4>\\n<ul>\\n<li>New: Field dropdowns have been updated to enable support for repeater actions.<\\/li>\\n<\\/ul>\\n<h4>v1.06 - March 25, 2024<\\/h4>\\n<ul>\\n<li>New: The strings used in this add-on can now be translated.<\\/li>\\n<li>Fix: An Uncaught Error: Class \\\"FrmFormAction\\\" not found fatal error has been fixed that happens on WPEngine hosted servers using PHP 8.2.<\\/li>\\n<\\/ul>\\n\",\"plugin\":\"formidable-constantcontact\\/formidable-constantcontact.php\",\"icons\":{\"1x\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png\"},\"banners\":{\"high\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\",\"low\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\"},\"search_terms\":\"\",\"is_new\":false},\"20834175\":{\"title\":\"Formidable Payments\",\"name\":\"Formidable Payments\",\"display_name\":\"Formidable Payments\",\"slug\":\"formidable-payments\",\"version\":\"1.14\",\"new_version\":\"1.14\",\"location\":[\"fp.strategy11.com\\/releases\\/payments\\/formidable-payments-1.14.zip\"],\"excerpt\":\"\",\"id\":20834175,\"released\":\"2018-11-06 12:08:25\",\"categories\":[],\"docs\":\"\",\"link\":\"https:\\/\\/formidableforms.com\\/downloads\\/formidable-payments\\/\",\"changelog\":\"\",\"plugin\":\"formidable-payments\\/formidable-payments.php\",\"icons\":{\"1x\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png\"},\"banners\":{\"high\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\",\"low\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\"},\"search_terms\":\"\",\"is_new\":false},\"20891694\":{\"title\":\"Campaign Monitor\",\"name\":\"Campaign Monitor\",\"display_name\":\"Campaign Monitor\",\"slug\":\"campaign-monitor\",\"version\":\"1.06\",\"new_version\":\"1.06\",\"location\":[\"fp.strategy11.com\\/releases\\/campaign-monitor\\/formidable-campaignmonitor-1.06.zip\"],\"excerpt\":\"Save time by automatically sending leads from WordPress forms to Campaign Monitor.\",\"id\":20891694,\"released\":\"2019-06-17 00:00:00\",\"categories\":[\"Business\",\"Email &amp; SMS Marketing\"],\"docs\":\"\\/knowledgebase\\/campaign-monitor-forms\\/\",\"link\":\"https:\\/\\/formidableforms.com\\/downloads\\/campaign-monitor\\/\",\"changelog\":\"<h4>v1.06 - September 9, 2024<\\/h4>\\n<ul>\\n<li>New: This plugin now includes translations for French, Spanish, Italian, German, Japanese and Brazilian Portuguese.<\\/li>\\n<\\/ul>\\n<h4>v1.05 - June 11, 2024<\\/h4>\\n<ul>\\n<li>New: Field dropdowns have been updated to enable support for repeater actions.<\\/li>\\n<li>New: Strings used in this plugin can now be translated.<\\/li>\\n<\\/ul>\\n<h4>v1.04 - June 23, 2021<\\/h4>\\n<ul>\\n<li>New: Name fields will now automatically map the proper first and last name values when sending to Campaign Monitor.<\\/li>\\n<li>Fix: Nothing would get sent when a user id field was set to something other than a name or email option.<\\/li>\\n<li>Fix: Prevent a fatal error that happens in PHP8 after trying to save Campaign Monitor API keys.<\\/li>\\n<li>Fix: Prevent a fatal error that happens in PHP8 after trying to load the fields for a specific contact list.<\\/li>\\n<\\/ul>\\n\",\"plugin\":\"formidable-campaignmonitor\\/formidable-campaignmonitor.php\",\"icons\":{\"1x\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png\"},\"banners\":{\"high\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\",\"low\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\"},\"search_terms\":\"\",\"is_new\":false},\"20896934\":{\"title\":\"Formidable Pro Plus\",\"name\":\"Formidable Pro Plus\",\"display_name\":\"Formidable Pro Plus\",\"slug\":\"formidable-basic\",\"version\":\"\",\"new_version\":\"\",\"location\":[],\"excerpt\":\"\",\"id\":20896934,\"released\":\"2019-07-22 09:03:39\",\"categories\":[\"Strategy11\"],\"docs\":\"\",\"link\":\"https:\\/\\/formidableforms.com\\/downloads\\/formidable-basic\\/\",\"changelog\":\"\",\"plugin\":\"formidable-basic\\/formidable-basic.php\",\"icons\":{\"1x\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png\"},\"banners\":{\"high\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\",\"low\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\"},\"search_terms\":\"\",\"is_new\":false},\"20897348\":{\"title\":\"Export View to CSV\",\"name\":\"Export View to CSV\",\"display_name\":\"Export View to CSV\",\"slug\":\"export-view\",\"version\":\"1.10\",\"new_version\":\"1.10\",\"location\":[\"fp.strategy11.com\\/releases\\/export-view\\/formidable-export-view-1.10.zip\"],\"excerpt\":\"Easily create custom CSV files and allow users to export their data from the front-end of your site.\",\"id\":20897348,\"released\":\"2019-08-01 00:00:00\",\"categories\":[\"Business\",\"Data Management\",\"Strategy11\"],\"docs\":\"https:\\/\\/formidableforms.com\\/knowledgebase\\/table-view-to-csv\\/\",\"link\":\"https:\\/\\/formidableforms.com\\/downloads\\/export-view\\/\",\"changelog\":\"<h4>v1.10 - August 13, 2024<\\/h4>\\n<ul>\\n<li>New: This plugin now includes translations for French, Spanish, Italian, German, Japanese and Brazilian Portuguese.<\\/li>\\n<li>Checks have been added to avoid trying to extend the time limit when the set_time_limit function does not exist to improve compatibility.<\\/li>\\n<li>Several references to deprecated functions have been updated.<\\/li>\\n<\\/ul>\\n<h4>v1.09 - September 19, 2023<\\/h4>\\n<ul>\\n<li>New: A new UTF-8 with BOM format option has been added to the Export Views global settings section.<\\/li>\\n<\\/ul>\\n<h4>v1.08 - June 26, 2023<\\/h4>\\n<ul>\\n<li>Fix: Some admin pages, including the WooCommerce orders page, were broken because of a fatal error when Formidable Views was inactive. Now this plugin will no longer load when Formidable Views is unavailable.<\\/li>\\n<\\/ul>\\n\",\"plugin\":\"formidable-export-view\\/formidable-export-view.php\",\"icons\":{\"1x\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png\"},\"banners\":{\"high\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\",\"low\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\"},\"search_terms\":\"export table\",\"is_new\":false},\"26596685\":{\"title\":\"Directory\",\"name\":\"Directory\",\"display_name\":\"Directory\",\"slug\":\"directory\",\"version\":\"1.0.01\",\"new_version\":\"1.0.01\",\"location\":[\"fp.strategy11.com\\/releases\\/directory\\/formidable-directory-1.0.01.zip\"],\"excerpt\":\"\",\"id\":26596685,\"released\":\"2020-06-29 00:00:00\",\"categories\":[\"Business+Views\",\"Solution\"],\"docs\":\"https:\\/\\/formidableforms.com\\/knowledgebase\\/formidable-directory\\/\",\"link\":\"https:\\/\\/formidableforms.com\\/wordpress-directory-plugin\\/\",\"changelog\":\"<h4>v1.0.01 - October 4, 2021<\\/h4>\\n<ul>\\n<li>Fix: The frm-letter-filter shortcode would always filter by lname instead of using the custom param option.<\\/li>\\n<\\/ul>\\n\",\"plugin\":\"formidable-directory\\/formidable-directory.php\",\"icons\":{\"1x\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png\"},\"banners\":{\"high\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\",\"low\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\"},\"search_terms\":\"\",\"beta\":{\"version\":\"100\",\"location\":[\"fp.strategy11.com\\/form-templates\\/business-directory.xml\"]},\"is_new\":false},\"28027505\":{\"title\":\"Views\",\"name\":\"Views\",\"display_name\":\"Legacy Views\",\"slug\":\"views\",\"version\":\"4.0.05\",\"new_version\":\"4.0.05\",\"location\":[\"fp.strategy11.com\\/releases\\/views\\/formidable-views-4.0.05.zip\"],\"excerpt\":\"Add the power of views to your Formidable Forms to display your form submissions in listings, tables, calendars, and more.\",\"id\":28027505,\"released\":\"2010-10-28 00:00:00\",\"categories\":[\"Strategy11\"],\"docs\":\"https:\\/\\/formidableforms.com\\/knowledgebase-category\\/views\\/\",\"link\":\"https:\\/\\/formidableforms.com\\/downloads\\/views\\/\",\"changelog\":\"<h4>v5.7 - December 10, 2024<\\/h4>\\n<ul>\\n<li>New: Calendar views now support a new End Event Time setting and a new Pop-up Location pop-up setting.<\\/li>\\n<li>New: Calendar views now support a new &#091;<span class=\\\"blob-code-inner blob-code-marker \\\" data-code-marker=\\\"+\\\"><span class=\\\"pl-s\\\">end_event_date<\\/span><\\/span>] shortcode.<\\/li>\\n<li>Fix: Support for repeated calendar events in modern calendar views has been improved.<\\/li>\\n<li>Fix: Support for RTL in modern calendar views has been improved.<\\/li>\\n<li>Fix: The Elementor Widget and Gutenberg blocks would only display options for 99 views. These dropdowns will now include every option, and the queries have been updated to help reduce the amount of memory required.<\\/li>\\n<\\/ul>\\n<h4>v5.6.4 - November 13, 2024<\\/h4>\\n<ul>\\n<li>Fix: View blocks would fail to preview in the Gutenberg builder on WordPress 6.7.<\\/li>\\n<li>Fix: A styling conflict with the Divi theme would cause long responsive table column text to overlap over other content, and long strings will now wrap to multiple lines.<\\/li>\\n<li>Fix: Grid view layout data would get printed out when viewed when no form data source was selected.<\\/li>\\n<li>An unnecessary database query has been removed when checking if the detail page is active.<\\/li>\\n<\\/ul>\\n<h4>v5.4.2 - October 25, 2023<\\/h4>\\n<ul>\\n<li>New: A new <span class=\\\"blob-code-inner blob-code-marker js-code-nav-pass \\\" data-code-marker=\\\"+\\\"><span class=\\\"pl-s\\\">frm_filter_final_view filter has been added for modifying the final result of a view.<\\/span><\\/span><\\/li>\\n<li>New: A few UI enhancements have been made. Now sliders for grid view settings include additional input fields with matching numeric values.<\\/li>\\n<li>New: The way CSS is added has been modified for better compatibility with the Snuffleupagus security module.<\\/li>\\n<li>New: The ID column is now sortable on the views list admin page.<\\/li>\\n<li>New: Some accessibility improvements have been added for view editor labels.<\\/li>\\n<li>New: A new filter has been added to support the new entry status types introduced with the form abandonment add on.<\\/li>\\n<li>Fix: Multiple warnings would get logged when sorting a view by a deleted field.<\\/li>\\n<li>Fix: Long view content would scroll underneath the type toggle elements.<\\/li>\\n<li>Fix: The preview result for address field shortcodes was not consistent with the front end result.<\\/li>\\n<li>Fix: The views editor would break with a fatal error when using the Google Listings and Ads plugin by WooCommerce. This conflict has been resolved.<\\/li>\\n<li>Fix: A Undefined array key PHP warning would get logged when loading the view editor if only a single view exists in the database.<\\/li>\\n<li>Fix: A deprecated use of self message would get logged when using the Gutenberg block for views.<\\/li>\\n<\\/ul>\\n\",\"plugin\":\"formidable-views\\/formidable-views.php\",\"icons\":{\"1x\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png\"},\"banners\":{\"high\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\",\"low\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\"},\"search_terms\":\"\",\"is_new\":false},\"28029934\":{\"title\":\"Formidable Pro Basic\",\"name\":\"Formidable Pro Basic\",\"display_name\":\"Formidable Pro Basic\",\"slug\":\"formidable-basic2\",\"version\":\"\",\"new_version\":\"\",\"location\":[],\"excerpt\":\"\",\"id\":28029934,\"released\":\"2020-11-13 12:10:10\",\"categories\":[],\"docs\":\"\",\"link\":\"https:\\/\\/formidableforms.com\\/downloads\\/formidable-basic2\\/\",\"changelog\":\"\",\"plugin\":\"formidable-basic2\\/formidable-basic2.php\",\"icons\":{\"1x\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png\"},\"banners\":{\"high\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\",\"low\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\"},\"search_terms\":\"\",\"is_new\":false},\"28058856\":{\"title\":\"Visual Views\",\"name\":\"Visual Views\",\"display_name\":\"Visual Views\",\"slug\":\"visual-views\",\"version\":\"5.8\",\"new_version\":\"5.8\",\"location\":[\"fp.strategy11.com\\/releases\\/views\\/formidable-views-5.8.zip\"],\"excerpt\":\"Create WordPress web apps to display your form submissions in grids, tables, calendars, and more.\",\"id\":28058856,\"released\":\"2021-05-31 00:00:00\",\"categories\":[\"Creator\",\"Data Management\",\"Strategy11\"],\"docs\":\"https:\\/\\/formidableforms.com\\/knowledgebase-category\\/views\\/\",\"link\":\"https:\\/\\/formidableforms.com\\/downloads\\/visual-views\\/\",\"changelog\":\"<h4>v5.8 - June 10, 2025<\\/h4>\\n<ul>\\n<li>New: Support for Timeline views has been added.<\\/li>\\n<li>Fix: An Uncaught ReferenceError: frm_js is not defined error would appear in the Gutenberg page builder.<\\/li>\\n<li>Fix: Grid views would use an incorrect max-width style in some themes.<\\/li>\\n<li>Fix: In-progress and abandoned entries would be excluded from Views results.<\\/li>\\n<li>A limit of 1000 modals has been set when handling View pagination with AJAX to help prevent abuse. This limit can be adjusted using a new filter, frm_max_modal_offset. A check for the bootstrap modal add-on has been added as well.<\\/li>\\n<li>Many old unused Legacy Views functions have been deprecated including FrmViewsDisplaysController::get_date_field_select, FrmViewsDisplaysController::get_where_options, FrmViewsDisplaysController::get_order_row, FrmViewsDisplaysController::get_where_row, FrmViewsDisplaysController::add_meta_boxes, FrmViewsDisplaysController::mb_advanced, FrmViewsDisplaysController::mb_dyncontent, FrmViewsDisplaysController::mb_excerpt, FrmViewsDisplaysController::mb_form_disp_type, and FrmViewsDisplaysController::add_order_row.<\\/li>\\n<\\/ul>\\n<h4>v5.7.2 - March 18, 2025<\\/h4>\\n<ul>\\n<li>New: Database queries when filtering groups that use AND are now optimized to help prevent issues with queries getting killed for being too long. This should also significantly improve performance.<\\/li>\\n<li>Fix: The accordions on the views editor looked incorrect when using WordPress v6.7.2.<\\/li>\\n<li>Fix: A fatal error would prevent the visual views editor from loading when using the Bluehost plugin.<\\/li>\\n<li>Fix: Visual previews of URLs would incorrectly show auto-embedding for view types that never auto-embed. Now auto-embeds will only display in previews when the view type is set to classic.<\\/li>\\n<li>Unused functions FrmViewsDisplaysController::publish_button and FrmViewsDisplaysController::add_form_nav_edit have been deprecated.<\\/li>\\n<li>Unused asset files edit.css and edit.js have been removed.<\\/li>\\n<\\/ul>\\n<h4>v5.7.1 - January 28, 2025<\\/h4>\\n<ul>\\n<li>Fix: Calendar view previews would display incorrect date values.<\\/li>\\n<li>Fix: When a view was refreshed with AJAX, not all fields would initialize properly when the second form was shown, including date pickers and dropdowns with autocomplete enabled.<\\/li>\\n<li>Fix: The Grid view column layout setting would display a 5 for the 6 column option, and 6 for the 12 column option. The associated input field is now disabled, and the disabled input will show the proper number of columns that is actually being defined.<\\/li>\\n<li>Fix: In some cases, because of an autop issue, AJAX refreshing would only work once and then fail when refreshing the second time.<\\/li>\\n<\\/ul>\\n\",\"plugin\":\"formidable-views\\/formidable-views.php\",\"icons\":{\"1x\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png\"},\"banners\":{\"high\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\",\"low\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\"},\"search_terms\":\"\",\"is_new\":false},\"28058858\":{\"title\":\"Formidable Views + Forms Basic\",\"name\":\"Formidable Views + Forms Basic\",\"display_name\":\"Formidable Views + Forms Basic\",\"slug\":\"formidable-views-basic\",\"version\":\"\",\"new_version\":\"\",\"location\":[],\"excerpt\":\"\",\"id\":28058858,\"released\":\"2021-05-12 12:29:57\",\"categories\":[],\"docs\":\"\",\"link\":\"https:\\/\\/formidableforms.com\\/downloads\\/formidable-views-basic\\/\",\"changelog\":\"\",\"plugin\":\"formidable-views-basic\\/formidable-views-basic.php\",\"icons\":{\"1x\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png\"},\"banners\":{\"high\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\",\"low\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\"},\"search_terms\":\"\",\"is_new\":false},\"28058860\":{\"title\":\"Formidable Apps + Forms Elite\",\"name\":\"Formidable Apps + Forms Elite\",\"display_name\":\"Formidable Apps + Forms Elite\",\"slug\":\"formidable-views-elite\",\"version\":\"\",\"new_version\":\"\",\"location\":[],\"excerpt\":\"\",\"id\":28058860,\"released\":\"2021-05-12 12:22:02\",\"categories\":[],\"docs\":\"\",\"link\":\"https:\\/\\/formidableforms.com\\/downloads\\/formidable-views-elite\\/\",\"changelog\":\"\",\"plugin\":\"formidable-views-elite\\/formidable-views-elite.php\",\"icons\":{\"1x\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png\"},\"banners\":{\"high\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\",\"low\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\"},\"search_terms\":\"\",\"is_new\":false},\"28058862\":{\"title\":\"Formidable Apps + Forms Business\",\"name\":\"Formidable Apps + Forms Business\",\"display_name\":\"Formidable Apps + Forms Business\",\"slug\":\"formidable-views-business\",\"version\":\"\",\"new_version\":\"\",\"location\":[],\"excerpt\":\"\",\"id\":28058862,\"released\":\"2021-05-12 12:27:07\",\"categories\":[],\"docs\":\"\",\"link\":\"https:\\/\\/formidableforms.com\\/downloads\\/formidable-views-business\\/\",\"changelog\":\"\",\"plugin\":\"formidable-views-business\\/formidable-views-business.php\",\"icons\":{\"1x\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png\"},\"banners\":{\"high\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\",\"low\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\"},\"search_terms\":\"\",\"is_new\":false},\"28058864\":{\"title\":\"Formidable Views + Forms Plus\",\"name\":\"Formidable Views + Forms Plus\",\"display_name\":\"Formidable Views + Forms Plus\",\"slug\":\"formidable-views-plus\",\"version\":\"\",\"new_version\":\"\",\"location\":[],\"excerpt\":\"\",\"id\":28058864,\"released\":\"2021-05-12 12:28:21\",\"categories\":[],\"docs\":\"\",\"link\":\"https:\\/\\/formidableforms.com\\/downloads\\/formidable-views-plus\\/\",\"changelog\":\"\",\"plugin\":\"formidable-views-plus\\/formidable-views-plus.php\",\"icons\":{\"1x\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png\"},\"banners\":{\"high\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\",\"low\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\"},\"search_terms\":\"\",\"is_new\":false},\"28067256\":{\"title\":\"Surveys and Polls\",\"name\":\"Surveys and Polls\",\"display_name\":\"Surveys and Polls\",\"slug\":\"surveys\",\"version\":\"1.1.4\",\"new_version\":\"1.1.4\",\"location\":[\"fp.strategy11.com\\/releases\\/surveys\\/formidable-surveys-1.1.4.zip\"],\"excerpt\":\"Transform your WordPress site into a data collection machine with our user-friendly survey form builder.\",\"id\":28067256,\"released\":\"2021-09-16 00:00:00\",\"categories\":[\"Business\",\"Data Collection\",\"Strategy11\"],\"docs\":\"https:\\/\\/formidableforms.com\\/knowledgebase\\/surveys-and-polls-forms\\/\",\"link\":\"https:\\/\\/formidableforms.com\\/downloads\\/surveys\\/\",\"changelog\":\"<h4>v1.1.4 - November 25, 2024<\\/h4>\\n<ul>\\n<li>Fix: Ranking field is being sorted as string not integers in the form reports.<\\/li>\\n<li>Fix: Ranking items aren\'t aligned when dragging.<\\/li>\\n<li>Fix: Ranking field styling issue in Twenty Twenty-One theme.<\\/li>\\n<li>Improved accessibility for the Ranking field.<\\/li>\\n<\\/ul>\\n<h4>v1.1.3 - September 16, 2024<\\/h4>\\n<ul>\\n<li>Fix: Ranking field scripts would not properly load when the ranking field was on a page after the first page and the option to submit the form using AJAX was enabled.<\\/li>\\n<li>Fix: The remove icon was missing for Likert fields, preventing users from removing Likert field options.<\\/li>\\n<li>Fix: Issues have been fixed with ranking fields when editing an entry and when saving drafts.<\\/li>\\n<li>Fix: Ranking fields will now account for selection limits when displaying ranking field data in a graph.<\\/li>\\n<\\/ul>\\n<h4>v1.1.2 - August 19, 2024<\\/h4>\\n<ul>\\n<li>New: This plugin now includes translations for French, Spanish, Italian, German, Japanese and Brazilian Portuguese.<\\/li>\\n<li>Fix: The icon and text for a selected radio button option would appear blank in the form builder preview when the display format was set to buttons.<\\/li>\\n<\\/ul>\\n\",\"plugin\":\"formidable-surveys\\/formidable-surveys.php\",\"icons\":{\"1x\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png\"},\"banners\":{\"high\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\",\"low\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\"},\"search_terms\":\"\",\"is_new\":false},\"28074303\":{\"title\":\"Landing Pages\",\"name\":\"Landing Pages\",\"display_name\":\"Landing Pages\",\"slug\":\"landing-pages\",\"version\":\"1.0.02\",\"new_version\":\"1.0.02\",\"location\":[\"fp.strategy11.com\\/releases\\/landing\\/formidable-landing-1.0.02.zip\"],\"excerpt\":\"Create beautiful landing pages fast and rake in new leads.\",\"id\":28074303,\"released\":\"2022-01-06 00:00:00\",\"categories\":[\"Creator\",\"Form Design &amp; Display\",\"Strategy11\"],\"docs\":\"https:\\/\\/formidableforms.com\\/knowledgebase\\/landing-pages\\/\",\"link\":\"https:\\/\\/formidableforms.com\\/downloads\\/landing-pages\\/\",\"changelog\":\"<p>No Changes Found<\\/p>\\n\",\"plugin\":\"formidable-landing\\/formidable-landing.php\",\"icons\":{\"1x\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png\"},\"banners\":{\"high\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\",\"low\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\"},\"search_terms\":\"\",\"is_new\":false},\"28100793\":{\"title\":\"Conversational Forms\",\"name\":\"Conversational Forms\",\"display_name\":\"Conversational Forms\",\"slug\":\"conversational-forms\",\"version\":\"1.2\",\"new_version\":\"1.2\",\"location\":[\"fp.strategy11.com\\/releases\\/chat\\/formidable-chat-1.2.zip\"],\"excerpt\":\"Ask one question at a time to humanize forms and boost their conversion rates.\",\"id\":28100793,\"released\":\"2022-01-25 00:00:00\",\"categories\":[\"Business\",\"Form Design &amp; Display\"],\"docs\":\"https:\\/\\/formidableforms.com\\/knowledgebase\\/conversational-forms\\/\",\"link\":\"https:\\/\\/formidableforms.com\\/downloads\\/conversational-forms\\/\",\"changelog\":\"<h4>v1.2 - March 11, 2025<\\/h4>\\n<ul>\\n<li>New: A new transition type setting has been added. Now, in addition to the horizontal transitions, there are new Vertical and Fade options.<\\/li>\\n<li>This update adds compatibility for the new flatpickr datepicker library available in Pro v6.19.<\\/li>\\n<\\/ul>\\n<h4>v1.1.5 - December 10, 2024<\\/h4>\\n<ul>\\n<li>Fix: Form descriptions would appear twice when editing an entry.<\\/li>\\n<li>Fix: Stripe link email fields would appear even when the payment field is conditionally hidden.<\\/li>\\n<li>Fix: Fieldset padding is now reduced to 0 automatically on mobile device widths to allow more space for content.<\\/li>\\n<li>The toggle component has been updated to match other toggles used on admin pages.<\\/li>\\n<\\/ul>\\n<h4>v1.1.4 - September 23, 2024<\\/h4>\\n<ul>\\n<li>New: This plugin now includes translations for French, Spanish, Italian, German, Japanese and Brazilian Portuguese.<\\/li>\\n<li>Fix: The submit button field would get counted in the progress bar total.<\\/li>\\n<li>Fix: The event listener for the continue button is now removed before it is added to help avoid issues with duplicate events triggering form submit twice, resulting in duplicate entries.<\\/li>\\n<\\/ul>\\n\",\"plugin\":\"formidable-chat\\/formidable-chat.php\",\"icons\":{\"1x\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png\"},\"banners\":{\"high\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\",\"low\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\"},\"search_terms\":\"\",\"is_new\":false},\"28118399\":{\"title\":\"Geolocation\",\"name\":\"Geolocation\",\"display_name\":\"Geolocation\",\"slug\":\"geolocation\",\"version\":\"1.3.4\",\"new_version\":\"1.3.4\",\"location\":[\"fp.strategy11.com\\/releases\\/geo\\/formidable-geo-1.3.4.zip\"],\"excerpt\":\"Get more accurate data and make forms faster to complete with address autocomplete.\",\"id\":28118399,\"released\":\"2022-04-12 00:00:00\",\"categories\":[\"Business\",\"Data Collection\"],\"docs\":\"https:\\/\\/formidableforms.com\\/knowledgebase\\/geolocation\\/\",\"link\":\"https:\\/\\/formidableforms.com\\/downloads\\/geolocation\\/\",\"changelog\":\"<h4>v1.3.4 - February 17, 2025<\\/h4>\\n<ul>\\n<li>Fix: Geolocation information would not display correctly for some new entries created on the front end.<\\/li>\\n<li>Fix: Repeated address fields would reset to the visitor\'s location when a new repeater row was added.<\\/li>\\n<\\/ul>\\n<h4>v1.3.3 - November 26, 2024<\\/h4>\\n<ul>\\n<li>Fix: Field validation errors would get incorrectly removed, allowing forms with invalid data to get submitted. This has been been fixed. You must also update to Formidable Pro version 6.16.1 or higher, or you might experience issues with required field validation for address fields.<\\/li>\\n<li>Fix: When changing between pages in a form, the default location would appear on the map instead of the previously submitted location.<\\/li>\\n<\\/ul>\\n<h4>v1.3.2 - September 25, 2024<\\/h4>\\n<ul>\\n<li>New: This plugin now includes translations for French, Spanish, Italian, German, Japanese and Brazilian Portuguese.<\\/li>\\n<li>Fix: Address field autocomplete options are now restricted to the default country on load.<\\/li>\\n<li>Fix: An Uncaught TypeError: google.maps.Geocoder error has been fixed.<\\/li>\\n<\\/ul>\\n\",\"plugin\":\"formidable-geo\\/formidable-geo.php\",\"icons\":{\"1x\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png\"},\"banners\":{\"high\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\",\"low\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\"},\"search_terms\":\"\",\"is_new\":false},\"28123662\":{\"title\":\"FAQ\",\"name\":\"FAQ\",\"display_name\":\"FAQ\",\"slug\":\"faq\",\"version\":\"\",\"new_version\":\"\",\"location\":[],\"excerpt\":\"\",\"id\":28123662,\"released\":\"2022-05-02 13:25:45\",\"categories\":[\"Solution\",\"Strategy11\"],\"docs\":\"\",\"link\":\"https:\\/\\/formidableforms.com\\/downloads\\/faq\\/\",\"changelog\":\"\",\"plugin\":\"faq\\/faq.php\",\"icons\":{\"1x\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png\"},\"banners\":{\"high\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\",\"low\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\"},\"search_terms\":\"\",\"is_new\":false},\"28123664\":{\"title\":\"Restaurant Menu\",\"name\":\"Restaurant Menu\",\"display_name\":\"Restaurant Menu\",\"slug\":\"restaurant-menu\",\"version\":\"\",\"new_version\":\"\",\"location\":[],\"excerpt\":\"\",\"id\":28123664,\"released\":\"2022-05-02 13:25:31\",\"categories\":[\"Solution\",\"Strategy11\"],\"docs\":\"\",\"link\":\"https:\\/\\/formidableforms.com\\/downloads\\/restaurant-menu\\/\",\"changelog\":\"\",\"plugin\":\"restaurant-menu\\/restaurant-menu.php\",\"icons\":{\"1x\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png\"},\"banners\":{\"high\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\",\"low\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\"},\"search_terms\":\"\",\"is_new\":false},\"28123666\":{\"title\":\"Business Hours\",\"name\":\"Business Hours\",\"display_name\":\"Business Hours\",\"slug\":\"business-hours\",\"version\":\"\",\"new_version\":\"\",\"location\":[],\"excerpt\":\"\",\"id\":28123666,\"released\":\"2022-05-02 13:25:15\",\"categories\":[\"Solution\",\"Strategy11\"],\"docs\":\"\",\"link\":\"https:\\/\\/formidableforms.com\\/downloads\\/business-hours\\/\",\"changelog\":\"\",\"plugin\":\"business-hours\\/business-hours.php\",\"icons\":{\"1x\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png\"},\"banners\":{\"high\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\",\"low\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\"},\"search_terms\":\"\",\"is_new\":false},\"28123668\":{\"title\":\"Team Directory\",\"name\":\"Team Directory\",\"display_name\":\"Team Directory\",\"slug\":\"team-directory\",\"version\":\"\",\"new_version\":\"\",\"location\":[],\"excerpt\":\"\",\"id\":28123668,\"released\":\"2022-05-02 13:24:48\",\"categories\":[\"Solution\",\"Strategy11\"],\"docs\":\"\",\"link\":\"https:\\/\\/formidableforms.com\\/downloads\\/team-directory\\/\",\"changelog\":\"\",\"plugin\":\"team-directory\\/team-directory.php\",\"icons\":{\"1x\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png\"},\"banners\":{\"high\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\",\"low\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\"},\"search_terms\":\"\",\"is_new\":false},\"28123670\":{\"title\":\"Application Shortcuts\",\"name\":\"Application Shortcuts\",\"display_name\":\"Application Shortcuts\",\"slug\":\"application-shortcuts\",\"version\":\"\",\"new_version\":\"\",\"location\":[],\"excerpt\":\"\",\"id\":28123670,\"released\":\"2022-05-02 13:38:05\",\"categories\":[\"Solution\",\"Strategy11\"],\"docs\":\"\",\"link\":\"https:\\/\\/formidableforms.com\\/downloads\\/application-shortcuts\\/\",\"changelog\":\"\",\"plugin\":\"application-shortcuts\\/application-shortcuts.php\",\"icons\":{\"1x\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png\"},\"banners\":{\"high\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\",\"low\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\"},\"search_terms\":\"\",\"is_new\":false},\"28124331\":{\"title\":\"Real Estate Listings\",\"name\":\"Real Estate Listings\",\"display_name\":\"Real Estate Listings\",\"slug\":\"real-estate-listings\",\"version\":\"\",\"new_version\":\"\",\"location\":[],\"excerpt\":\"\",\"id\":28124331,\"released\":\"2022-05-05 13:53:10\",\"categories\":[\"Solution\",\"Strategy11\"],\"docs\":\"\",\"link\":\"https:\\/\\/formidableforms.com\\/downloads\\/real-estate-listings\\/\",\"changelog\":\"\",\"plugin\":\"real-estate-listings\\/real-estate-listings.php\",\"icons\":{\"1x\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png\"},\"banners\":{\"high\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\",\"low\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\"},\"search_terms\":\"\",\"is_new\":false},\"28124372\":{\"title\":\"Product Reviews\",\"name\":\"Product Reviews\",\"display_name\":\"Product Reviews\",\"slug\":\"product-reviews\",\"version\":\"\",\"new_version\":\"\",\"location\":[],\"excerpt\":\"\",\"id\":28124372,\"released\":\"2022-05-05 16:39:04\",\"categories\":[\"Solution\",\"Strategy11\"],\"docs\":\"\",\"link\":\"https:\\/\\/formidableforms.com\\/downloads\\/product-reviews\\/\",\"changelog\":\"\",\"plugin\":\"product-reviews\\/product-reviews.php\",\"icons\":{\"1x\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png\"},\"banners\":{\"high\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\",\"low\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\"},\"search_terms\":\"\",\"is_new\":false},\"28127946\":{\"title\":\"Link in Bio Instagram Grid\",\"name\":\"Link in Bio Instagram Grid\",\"display_name\":\"Link in Bio Instagram Grid\",\"slug\":\"link-in-bio-instagram-grid\",\"version\":\"\",\"new_version\":\"\",\"location\":[],\"excerpt\":\"\",\"id\":28127946,\"released\":\"2022-05-25 14:13:43\",\"categories\":[\"Solution\",\"Strategy11\"],\"docs\":\"\",\"link\":\"https:\\/\\/formidableforms.com\\/downloads\\/link-in-bio-instagram-grid\\/\",\"changelog\":\"\",\"plugin\":\"link-in-bio-instagram-grid\\/link-in-bio-instagram-grid.php\",\"icons\":{\"1x\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png\"},\"banners\":{\"high\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\",\"low\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\"},\"search_terms\":\"\",\"is_new\":false},\"28136428\":{\"title\":\"PDFs\",\"name\":\"PDFs\",\"display_name\":\"PDFs\",\"slug\":\"pdfs\",\"version\":\"2.0.6\",\"new_version\":\"2.0.6\",\"location\":[\"fp.strategy11.com\\/releases\\/pdfs\\/formidable-pdfs-2.0.6.zip\"],\"excerpt\":\"Create PDFs from form entries automatically. Email them or let visitors download PDFs from your site.\",\"id\":28136428,\"released\":\"2022-08-09 00:00:00\",\"categories\":[\"Business\",\"Data Management\",\"Utilities\"],\"docs\":\"https:\\/\\/formidableforms.com\\/knowledgebase\\/pdfs\\/\",\"link\":\"https:\\/\\/formidableforms.com\\/downloads\\/pdfs\\/\",\"changelog\":\"<h4>v2.0.6 - May 28, 2025<\\/h4>\\n<ul>\\n<li>Fix: translation notice in the backend.<\\/li>\\n<li>Fix: the styling issue of file upload icons in PDF file.<\\/li>\\n<li>Fix: the styling issue of image buttons in PDF file.<\\/li>\\n<\\/ul>\\n<h4>v2.0.5 - April 17, 2025<\\/h4>\\n<ul>\\n<li>Fix: Pagination in PDF file is missing the total pages.<\\/li>\\n<li>Fix: Images are not working when they contain a space or URL-encoded characters.<\\/li>\\n<li>Fix: Long likert field doesn\'t show correctly in PDF file.<\\/li>\\n<\\/ul>\\n<h4>v2.0.4 - June 6, 2024<\\/h4>\\n<ul>\\n<li>New: PDFs can now load images without requiring the allow_url_fopen PHP directive.<\\/li>\\n<li>New: Additional shortcode attribute data is now passed to the frm_pdfs_css filter as additional $args data.<\\/li>\\n<li>Fix: Checks have been added to avoid fatal errors when trying to extend the time limit when the function is disabled.<\\/li>\\n<li>An update has been made to improve compatibility with QR code created using https:\\/\\/api.qrserver.com\\/. A new frm_pdfs_dompdf_should_encode_uri filter has been added to allow additional exceptions.<\\/li>\\n<\\/ul>\\n\",\"plugin\":\"formidable-pdfs\\/formidable-pdfs.php\",\"icons\":{\"1x\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png\"},\"banners\":{\"high\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\",\"low\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\"},\"search_terms\":\"\",\"is_new\":false},\"28144027\":{\"title\":\"Member Directory\",\"name\":\"Member Directory\",\"display_name\":\"Member Directory\",\"slug\":\"member-directory\",\"version\":\"\",\"new_version\":\"\",\"location\":[],\"excerpt\":\"\",\"id\":28144027,\"released\":\"2022-08-24 15:18:56\",\"categories\":[\"Solution\",\"Strategy11\"],\"docs\":\"\",\"link\":\"https:\\/\\/formidableforms.com\\/downloads\\/member-directory\\/\",\"changelog\":\"\",\"plugin\":\"member-directory\\/member-directory.php\",\"icons\":{\"1x\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png\"},\"banners\":{\"high\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\",\"low\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\"},\"search_terms\":\"\",\"is_new\":false},\"28144089\":{\"title\":\"Business Directory\",\"name\":\"Business Directory\",\"display_name\":\"Business Directory\",\"slug\":\"business-directory\",\"version\":\"\",\"new_version\":\"\",\"location\":[],\"excerpt\":\"\",\"id\":28144089,\"released\":\"2022-08-24 16:41:02\",\"categories\":[\"Solution\",\"Strategy11\"],\"docs\":\"\",\"link\":\"https:\\/\\/formidableforms.com\\/downloads\\/business-directory\\/\",\"changelog\":\"\",\"plugin\":\"business-directory\\/business-directory.php\",\"icons\":{\"1x\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png\"},\"banners\":{\"high\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\",\"low\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\"},\"search_terms\":\"\",\"is_new\":false},\"28149579\":{\"title\":\"Google Sheets\",\"name\":\"Google Sheets\",\"display_name\":\"Google Sheets\",\"slug\":\"google-sheets\",\"version\":\"1.0.5\",\"new_version\":\"1.0.5\",\"location\":[\"fp.strategy11.com\\/releases\\/google-sheets\\/formidable-googlespreadsheet-1.0.5.zip\"],\"excerpt\":\"Send form entries to a Google spreadsheet as a backup or for extra processing.\",\"id\":28149579,\"released\":\"2022-10-18 00:00:00\",\"categories\":[\"Business\",\"Data Management\"],\"docs\":\"https:\\/\\/formidableforms.com\\/knowledgebase\\/google-spreadsheet-forms\\/\",\"link\":\"https:\\/\\/formidableforms.com\\/downloads\\/google-sheets\\/\",\"changelog\":\"<h4>v1.0.5 - June 18, 2025<\\/h4>\\n<ul>\\n<li>New: You can now send form data to sheets in shared Google drives.<\\/li>\\n<li>New: Google sheet actions now support form action automation.<\\/li>\\n<li>New: Google Sheet options will now use autocomplete when there are over 50 options, and the sheet names are sorted alphabetically to make it easier to find the right sheet.<\\/li>\\n<li>Fix: Pagination checks have been added to help prevent issues where not all sheets were available as options.<\\/li>\\n<li>Fix: A column value will no longer be escaped by default when the action setting starts with an equals (=) sign. A new filter, frm_googlespreadsheet_escape_value, has also been added.<\\/li>\\n<li>Checks have been updated when handling redirects to help fix issues that would prevent successful authentication when setting up Google Sheets.<\\/li>\\n<\\/ul>\\n<h4>v1.0.4 - September 25, 2024<\\/h4>\\n<ul>\\n<li>Fix: When inserting to Google Sheets, data would get inserted into the wrong column in cases where cells are empty. A GET request is now made to properly determine the last row to more accurately determine the insert position to improve accuracy. This may have performance costs. To opt out of this, a new frm_googlespreadsheet_should_check_for_first_empty_row filter has been added.<\\/li>\\n<\\/ul>\\n<h4>v1.0.3 - September 3, 2024<\\/h4>\\n<ul>\\n<li>New: This plugin now includes translations for French, Spanish, Italian, German, Japanese and Brazilian Portuguese.<\\/li>\\n<li>New: A fallback solution has been added to enable authentication on some sites where pop ups are disallowed.<\\/li>\\n<li>Extra spaces will be trimmed when adding Client ID and Client Secret values to help prevent errors related to copying extra whitespace.<\\/li>\\n<\\/ul>\\n\",\"plugin\":\"formidable-googlespreadsheet\\/formidable-googlespreadsheet.php\",\"icons\":{\"1x\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png\"},\"banners\":{\"high\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\",\"low\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\"},\"search_terms\":\"\",\"is_new\":false},\"28158728\":{\"title\":\"ACF Forms\",\"name\":\"ACF Forms\",\"display_name\":\"ACF Forms\",\"slug\":\"acf-forms\",\"version\":\"1.0.2\",\"new_version\":\"1.0.2\",\"location\":[\"fp.strategy11.com\\/releases\\/acf\\/formidable-acf-1.0.2.zip\"],\"excerpt\":\"Sync custom fields between Formidable and Advanced Custom Fields or ACF Pro.\",\"id\":28158728,\"released\":\"2022-12-13 00:00:00\",\"categories\":[\"Business\",\"Data Management\"],\"docs\":\"https:\\/\\/formidableforms.com\\/knowledgebase\\/acf-form\\/\",\"link\":\"https:\\/\\/formidableforms.com\\/downloads\\/acf-forms\\/\",\"changelog\":\"<h4>v1.0.2 - August 13, 2024<\\/h4>\\n<ul>\\n<li>New: This plugin now includes translations for French, Spanish, Italian, German, Japanese and Brazilian Portuguese.<\\/li>\\n<li>Fix: Values were not getting added to an ACF repeater when the setting to store Formidable entries is disabled.<\\/li>\\n<\\/ul>\\n<h4>v1.0.1 - July 6, 2023<\\/h4>\\n<ul>\\n<li>Fix: Repeater values were not appearing for posts until the post was manually updated.<\\/li>\\n<\\/ul>\\n\",\"plugin\":\"formidable-acf\\/formidable-acf.php\",\"icons\":{\"1x\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png\"},\"banners\":{\"high\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\",\"low\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\"},\"search_terms\":\"advanced, custom fields\",\"is_new\":false},\"28189169\":{\"title\":\"AI\",\"name\":\"AI\",\"display_name\":\"AI Forms\",\"slug\":\"ai\",\"version\":\"2.0.2\",\"new_version\":\"2.0.2\",\"location\":[\"fp.strategy11.com\\/releases\\/ai\\/formidable-ai-2.0.2.zip\"],\"excerpt\":\"Get back your time by autogenerating a response from ChatGPT and inserting it into a field.\",\"id\":28189169,\"released\":\"2023-04-11 00:00:00\",\"categories\":[\"Automation\",\"Business\"],\"docs\":\"https:\\/\\/formidableforms.com\\/knowledgebase\\/form-ai\\/\",\"link\":\"https:\\/\\/formidableforms.com\\/downloads\\/ai\\/\",\"changelog\":\"<h4>v2.0.2 - May 7, 2025<\\/h4>\\n<ul>\\n<li>Fix: The AI Prompt setting would get ignored after the previous release.<\\/li>\\n<\\/ul>\\n<h4>v2.0.1 - March 4, 2025<\\/h4>\\n<ul>\\n<li>Fix: The submit button on the edit entry admin page would not work for forms with an AI field without updating the AI response.<\\/li>\\n<li>Fix: AI fields would not properly watch for changes in name fields.<\\/li>\\n<li>Fix: Shortcodes were not properly detected when no spaces were left in-between.<\\/li>\\n<li>Fix: A class FrmAIAppController not found fatal error has been fixed that would trigger when activating the AI add-on when Formidable Lite was not available.<\\/li>\\n<\\/ul>\\n<h4>v2.0 - August 13, 2024<\\/h4>\\n<ul>\\n<li>New: A new Create with AI button has been added to the form templates page, located beside the Create a blank form button. This button will prompt a new modal that will generate a basic form based on user input.<\\/li>\\n<li>New: AI fields now include a new GPT Model setting. This setting supports gpt-3.5-turbo and gpt-4o-mini model options. gpt-3.5-turbo is typically faster and more succinct, and gpt-4o-mini has higher quality responses.<\\/li>\\n<li>New: The watched fields setting has been replaced with a new AI Question text area setting. This update makes it easier to build questions with multiple fields and static text. This setting accepts field shortcodes that update in real time that will re-trigger the AI prompt when updated.<\\/li>\\n<li>New: The Guide Prompt setting now accepts field shortcodes that work with live form values.<\\/li>\\n<li>New: AI fields will not reset when the start over button is clicked.<\\/li>\\n<li>Fix: AI fields inside of embedded fields were not working.<\\/li>\\n<li>Fix: AI fields now properly accept layout classes and work when dragged into groups with other fields.<\\/li>\\n<li>Fix: AI field requests would fail when the WPML add-on was active.<\\/li>\\n<li>Fix: AI fields requests were not happening after changing a watched date field value.<\\/li>\\n<\\/ul>\\n\",\"plugin\":\"formidable-ai\\/formidable-ai.php\",\"icons\":{\"1x\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png\"},\"banners\":{\"high\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\",\"low\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\"},\"search_terms\":\"chatgpt, openai, automate\",\"is_new\":false},\"28217763\":{\"title\":\"Abandonment\",\"name\":\"Abandonment\",\"display_name\":\"Form Abandonment\",\"slug\":\"abandonment\",\"version\":\"1.1.6\",\"new_version\":\"1.1.6\",\"location\":[\"fp.strategy11.com\\/releases\\/abandonment\\/formidable-abandonment-1.1.6.zip\"],\"excerpt\":\"Capture form data before it\'s submitted to save more leads and optimize forms. Plus, auto save drafts and allow logged out editing.\",\"id\":28217763,\"released\":\"2023-10-24 00:00:00\",\"categories\":[\"Business\",\"Data Collection\"],\"docs\":\"https:\\/\\/formidableforms.com\\/knowledgebase\\/form-abandonment\\/\",\"link\":\"https:\\/\\/formidableforms.com\\/downloads\\/abandonment\\/\",\"changelog\":\"<h4>v1.1.6 - March 26, 2025<\\/h4>\\n<ul>\\n<li>Fix: Auto-saving would not work properly after changing pages when submitting with AJAX.<\\/li>\\n<li>Fix: No link would output when using the &#091;frm-signed-edit-link] shortcodes in some cases, like editing an entry after submitting.<\\/li>\\n<li>Fix: When the Require an email address or phone number before saving setting was enabled, changes would only get sent after the required field was changed. Now data will sync after other fields are changed as well, after the required fields have been filled.<\\/li>\\n<li>Fix: When clicking a link in Gmail, a Google cache bot would follow the link and submit the form. This could cause issues with empty form entries and \\\"You do not have permission to view this form\\\" errors for users who are not logged in. Google bots are now blocked by doing a reverse DNS lookup based on IP. To opt out of this, a new frm_abandonment_block_google_cache filter has been added.<\\/li>\\n<\\/ul>\\n<h4>v1.1.5 - March 11, 2025<\\/h4>\\n<ul>\\n<li>New: In-progress entries will no longer get saved to the database for forms with GDPR fields when consent has not yet been granted.<\\/li>\\n<\\/ul>\\n<h4>v1.1.4 - December 18, 2024<\\/h4>\\n<ul>\\n<li>New: Abandonment links will now automatically use a form\'s landing page when one is active.<\\/li>\\n<li>New: This plugin now includes translations for French, Spanish, Italian, German, Japanese and Brazilian Portuguese.<\\/li>\\n<li>Fix: The way &#091;auto_id] shortcode values is retrieved has been updated to improve compatibility with in-progress and abandoned entries. Auto IDs will now update when an in-progress or abandoned entry is submitted.<\\/li>\\n<\\/ul>\\n\",\"plugin\":\"formidable-abandonment\\/formidable-abandonment.php\",\"icons\":{\"1x\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png\"},\"banners\":{\"high\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\",\"low\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\"},\"search_terms\":\"partial, save, continue\",\"is_new\":false},\"28248560\":{\"title\":\"Charts\",\"name\":\"Charts\",\"display_name\":\"Charts\",\"slug\":\"charts\",\"version\":\"1.0.5\",\"new_version\":\"1.0.5\",\"location\":[\"fp.strategy11.com\\/releases\\/charts\\/formidable-charts-1.0.5.zip\"],\"excerpt\":\"Transform form data into insightful graphs with ease.\",\"id\":28248560,\"released\":\"2024-01-09 00:00:00\",\"categories\":[\"Creator\",\"Data Management\"],\"docs\":\"https:\\/\\/formidableforms.com\\/knowledgebase\\/graphs\\/\",\"link\":\"https:\\/\\/formidableforms.com\\/downloads\\/charts\\/\",\"changelog\":\"<h4>v1.0.5 - April 29, 2025<\\/h4>\\n<ul>\\n<li>New: Add animation settings to the graph block.<\\/li>\\n<\\/ul>\\n<h4>v1.0.4 - February 5, 2025<\\/h4>\\n<ul>\\n<li>Fix: Javascript error when changing the block title style.<\\/li>\\n<\\/ul>\\n<h4>v1.0.3 - September 23, 2024<\\/h4>\\n<ul>\\n<li>Fix: The copy shortcode button would copy undefined instead of the expected shortcode string.<\\/li>\\n<li>Fix: Charts would break and display no data after adding additional CSS classes.<\\/li>\\n<\\/ul>\\n\",\"plugin\":\"formidable-charts\\/formidable-charts.php\",\"icons\":{\"1x\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/icon-256x256.png\"},\"banners\":{\"high\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\",\"low\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\"},\"search_terms\":\"graph\",\"is_new\":false},\"28286367\":{\"title\":\"ConvertKit\",\"name\":\"ConvertKit\",\"display_name\":\"ConvertKit\",\"slug\":\"convertkit\",\"version\":\"1.0\",\"new_version\":\"1.0\",\"location\":[\"fp.strategy11.com\\/releases\\/convertkit\\/formidable-convertkit-1.0.zip\"],\"excerpt\":\"Bring automation into your email marketing plan for the power to say \\\"welcome\\\" to your subscribers the moment they opt-in to your list.\",\"id\":28286367,\"released\":\"2024-07-09 00:00:00\",\"categories\":[\"Creator\",\"Email &amp; SMS Marketing\",\"Strategy11\"],\"docs\":\"\\/knowledgebase\\/convertkit-forms\\/\",\"link\":\"https:\\/\\/formidableforms.com\\/downloads\\/convertkit\\/\",\"changelog\":\"<p>No Changes Found<\\/p>\\n\",\"plugin\":\"formidable-convertkit\\/formidable-convertkit.php\",\"icons\":{\"1x\":\"https:\\/\\/formidableforms.com\\/wp-content\\/uploads\\/2013\\/04\\/mailchimp.png\"},\"banners\":{\"high\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\",\"low\":\"https:\\/\\/ps.w.org\\/formidable\\/assets\\/banner-1544x500.png\"},\"search_terms\":\"\",\"is_new\":false},\"response_code\":200}\";s:7:\"version\";s:6:\"6.22.3\";}","off");

INSERT IGNORE INTO `wp_options` VALUES 
("2222","bp-deactivated-components","a:0:{}","auto"),
("2223","bp-xprofile-base-group-name","Base","auto"),
("2224","bp-xprofile-fullname-field-name","Name","auto"),
("2225","bp-blogs-first-install","","auto"),
("2226","bp-disable-profile-sync","","auto"),
("2227","hide-loggedout-adminbar","","auto"),
("2228","bp-disable-avatar-uploads","","auto"),
("2229","bp-disable-cover-image-uploads","","auto"),
("2230","bp-disable-group-avatar-uploads","","auto"),
("2231","bp-disable-group-cover-image-uploads","","auto"),
("2232","bp-disable-group-activity-deletions","","auto"),
("2233","bp-disable-account-deletion","","auto"),
("2234","bp-disable-blogforum-comments","1","auto"),
("2235","_bp_theme_package_id","nouveau","auto"),
("2236","bp-emails-unsubscribe-salt","azdZbD0/OHNqSV0vJDdtdll1bHlKcypsSntNbHdVQzpfS0NwOCN3T3xSTUVnPm9jSWV5fVBMJEZdSigqKXlGPg==","auto"),
("2237","_bp_community_visibility","a:1:{s:6:\"global\";s:6:\"anyone\";}","auto"),
("2238","bp_restrict_group_creation","","auto"),
("2239","_bp_enable_akismet","1","auto"),
("2240","_bp_enable_heartbeat_refresh","1","auto"),
("2241","_bp_ignore_deprecated_code","1","auto"),
("2242","_bp_initial_major_version","14.0","auto"),
("2243","bp-active-components","a:9:{s:8:\"xprofile\";s:1:\"1\";s:8:\"settings\";s:1:\"1\";s:7:\"friends\";s:1:\"1\";s:8:\"messages\";s:1:\"1\";s:8:\"activity\";s:1:\"1\";s:13:\"notifications\";s:1:\"1\";s:6:\"groups\";s:1:\"1\";s:5:\"blogs\";s:1:\"1\";s:7:\"members\";s:1:\"1\";}","auto"),
("2244","bp-pages","a:5:{s:8:\"activity\";i:220;s:7:\"members\";i:221;s:6:\"groups\";i:422;s:8:\"activate\";i:510;s:8:\"register\";i:511;}","auto"),
("2245","_bp_db_version","13906","auto"),
("2308","frm_yt_videos","a:3:{s:7:\"timeout\";i:1750632697;s:5:\"value\";s:649:\"{\"welcome\":{\"video-id\":\"7X2BqhRsXcg\"},\"latest\":[{\"video-id\":\"VBHzPkrMOX8\",\"thumbnails\":{\"default\":{\"url\":\"https:\\/\\/i.ytimg.com\\/vi\\/VBHzPkrMOX8\\/default.jpg\",\"width\":120,\"height\":90},\"medium\":{\"url\":\"https:\\/\\/i.ytimg.com\\/vi\\/VBHzPkrMOX8\\/mqdefault.jpg\",\"width\":320,\"height\":180},\"high\":{\"url\":\"https:\\/\\/i.ytimg.com\\/vi\\/VBHzPkrMOX8\\/hqdefault.jpg\",\"width\":480,\"height\":360}},\"title\":\"Accept Payments on WordPress Fast (No Code Needed)\",\"description\":\"Sign up for our newsletter for the best WordPress Tips & Tricks: https:\\/\\/formidableforms.com\\/go\\/newsletter Here\'s how to add ...\"}],\"featured\":{\"video-id\":\"rchADVTUH0E\"},\"response_code\":200}\";s:7:\"version\";s:4:\"6.22\";}","off"),
("2309","frm_form_templates_l","a:3:{s:7:\"timeout\";i:1743325859;s:5:\"value\";s:187465:\"{\"20882522\":{\"name\":\"Create WordPress Post Form Template\",\"slug\":\"create-wordpress-post-form\",\"description\":\"Allow users to create WordPress posts from the front-end of your site with the Create WordPress Post form template.\",\"id\":20882522,\"released\":\"2019-03-26 15:05:14\",\"categories\":[\"Basic\",\"Post\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/create-wordpress-post-form\\/\",\"icon\":false,\"key\":\"create-wordpress-post\",\"used_addons\":[],\"is_new\":false},\"20874733\":{\"name\":\"Car Payment Calculator Template\",\"slug\":\"automobile-payment-calculator-form\",\"description\":\"Calculate monthly payments with an easy auto loan calculator.\",\"id\":20874733,\"released\":\"2019-01-01 13:22:05\",\"categories\":[\"Business\",\"Calculator\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/automobile-payment-calculator-form\\/\",\"icon\":false,\"key\":\"automobile-payment-calculator\",\"used_addons\":[],\"is_new\":false},\"20874747\":{\"name\":\"Create WooCommerce Product Template\",\"slug\":\"create-woocommerce-product-form\",\"description\":\"Easily create WooCommerce products with front-end creation, auto-populated fields, manual or automatic approval.\",\"id\":20874747,\"released\":\"2019-01-29 13:20:10\",\"categories\":[\"Elite\",\"WooCommerce\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/create-woocommerce-product-form\\/\",\"icon\":false,\"key\":\"create-woocommerce-product\",\"used_addons\":[\"WooCommerce\"],\"is_new\":false},\"20874739\":{\"name\":\"Credit Card Payment Template\",\"slug\":\"credit-card-payment-form\",\"description\":\"Use with either the Stripe or Authorize.net add-ons to securely run payments while keeping users on your site.\",\"id\":20874739,\"released\":\"2019-01-01 12:29:14\",\"categories\":[\"Business\",\"Payment\",\"Stripe\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/credit-card-payment-form\\/\",\"icon\":false,\"key\":\"credit-card-payment\",\"used_addons\":[],\"is_new\":false},\"20873706\":{\"name\":\"User Information Form Template\",\"slug\":\"user-information-form\",\"description\":\"Get a WordPress contact form with more user information including website and address.\",\"id\":20873706,\"released\":\"2017-01-23 19:08:49\",\"categories\":[\"Basic\",\"Contact\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/user-information-form\\/\",\"icon\":false,\"key\":\"user-information\",\"used_addons\":[],\"is_new\":false},\"20873677\":{\"name\":\"Real Estate Listings Form Template\",\"slug\":\"real-estate-listings-form\",\"description\":\"Show Real Estate listings on your site. First add listings in a form, then create a view to display them.\",\"id\":20873677,\"released\":\"2017-01-23 18:56:44\",\"categories\":[\"Personal\",\"Real Estate\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/real-estate-listings-form\\/\",\"icon\":false,\"key\":\"real-estate-listings\",\"used_addons\":[],\"is_new\":false},\"20874045\":{\"name\":\"Job Application Form Template\",\"slug\":\"job-application-form\",\"description\":\"Streamline your hiring process by collecting employment applications online and get more applications.\",\"id\":20874045,\"released\":\"2017-01-25 15:33:33\",\"categories\":[\"Application\",\"Personal\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/job-application-form\\/\",\"icon\":false,\"key\":\"job-application\",\"used_addons\":[],\"is_new\":false},\"20874049\":{\"name\":\"Emergency Contact Form Template\",\"slug\":\"emergency-contact-form\",\"description\":\"Protect your clients and be prepared for any situation by collecting emergency contact and basic medical information.\",\"id\":20874049,\"released\":\"2019-01-01 15:50:21\",\"categories\":[\"Business\",\"Contact\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/emergency-contact-form\\/\",\"icon\":false,\"key\":\"emergency-contact\",\"used_addons\":[],\"is_new\":false},\"28080527\":{\"name\":\"Sample Size Calculator Template\",\"slug\":\"sample-size-calculator-form\",\"description\":\"Find out how many people need to respond to a survey to produce statistically significant results.\",\"id\":28080527,\"released\":\"2021-09-20 12:49:06\",\"categories\":[\"Business\",\"Business Operations\",\"Calculator\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/sample-size-calculator-form\\/\",\"icon\":false,\"key\":\"sample-size-calculator\",\"used_addons\":[],\"is_new\":false},\"20873681\":{\"name\":\"SMS Get Quote Form Template\",\"slug\":\"sms-get-quote-form\",\"description\":\"The most streamlined quote form. When the form is submitted, get an instant SMS notification to let you know of a quote request.\",\"id\":20873681,\"released\":\"2019-01-01 19:15:29\",\"categories\":[\"Business\",\"Business Operations\",\"Twilio\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/sms-get-quote-form\\/\",\"icon\":false,\"key\":\"sms-get-quote\",\"used_addons\":[],\"is_new\":false},\"20872681\":{\"name\":\"Contact Form to SMS Template\",\"slug\":\"contact-form-to-sms-template\",\"description\":\"Perfect for a simple contact form. Visitors ask a question and receive an instant SMS text message confirmation.\",\"id\":20872681,\"released\":\"2019-01-01 16:11:52\",\"categories\":[\"Business\",\"Contact\",\"Twilio\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/contact-form-to-sms-template\\/\",\"icon\":false,\"key\":\"contact-form-to-sms\",\"used_addons\":[],\"is_new\":false},\"28036517\":{\"name\":\"Employee Referral Form Template\",\"slug\":\"employee-referral-form\",\"description\":\"Let your current staff refer their friends and family to work for you with this employee referral template\",\"id\":28036517,\"released\":\"2020-12-18 14:07:13\",\"categories\":[\"Business Operations\",\"free\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/employee-referral-form\\/\",\"icon\":false,\"key\":\"employee-referral\",\"used_addons\":[],\"is_new\":false},\"28036180\":{\"name\":\"Call for Proposals Form Template\",\"slug\":\"call-for-proposals-form\",\"description\":\"Putting out a call for proposals? Enhance your RFP process with a call for proposals form template! Now you can request proposals the easy way.\",\"id\":28036180,\"released\":\"2020-12-18 13:00:06\",\"categories\":[\"Business Operations\",\"free\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/call-for-proposals-form\\/\",\"icon\":false,\"key\":\"call-for-proposals\",\"used_addons\":[],\"is_new\":false},\"20905853\":{\"name\":\"Contest Entry Form Template\",\"slug\":\"contest-entry-form\",\"description\":\"Easily collect entries by promoting participation in a contest.\",\"id\":20905853,\"released\":\"2019-11-24 23:00:23\",\"categories\":[\"Basic\",\"Marketing\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/contest-entry-form\\/\",\"icon\":false,\"key\":\"contest-entry\",\"used_addons\":[],\"is_new\":false},\"20905877\":{\"name\":\"Cancellation Survey Form Template\",\"slug\":\"cancellation-survey-form\",\"description\":\"Ask clients why they are canceling and how you can improve.\",\"id\":20905877,\"released\":\"2019-11-24 23:00:34\",\"categories\":[\"Business\",\"Business Operations\",\"Survey\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/cancellation-survey-form\\/\",\"icon\":[\"https:\\/\\/formidableforms.com\\/wp-content\\/uploads\\/2019\\/11\\/cancellation-survey-form-template.jpg\",650,288,false],\"key\":\"cancellation-survey\",\"used_addons\":[],\"is_new\":false},\"20905879\":{\"name\":\"Conference Registration Form Template\",\"slug\":\"conference-registration-form\",\"description\":\"Easily register attendees for a conference.\",\"id\":20905879,\"released\":\"2019-11-24 23:00:27\",\"categories\":[\"Business\",\"Event Planning\",\"Payment\",\"Registration and Signup\",\"Stripe\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/conference-registration-form\\/\",\"icon\":false,\"key\":\"conference-registration\",\"used_addons\":[],\"is_new\":false},\"28036515\":{\"name\":\"Content Download Form Template\",\"slug\":\"content-download-form\",\"description\":\"Use this simple form to capture leads for your business.\",\"id\":28036515,\"released\":\"2020-12-18 13:30:20\",\"categories\":[\"Customer Service\",\"free\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/content-download-form\\/\",\"icon\":false,\"key\":\"content-download\",\"used_addons\":[],\"is_new\":false},\"20908991\":{\"name\":\"Accident Report Form Template\",\"slug\":\"accident-report-form\",\"description\":\"An easy way to document accidents that happen at the office or on job sites\",\"id\":20908991,\"released\":\"2019-11-24 23:00:38\",\"categories\":[\"Basic\",\"Business Operations\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/accident-report-form\\/\",\"icon\":false,\"key\":\"accident-report\",\"used_addons\":[],\"is_new\":false},\"20908993\":{\"name\":\"Change Request Form Template\",\"slug\":\"change-request-form\",\"description\":\"Looking for a change request form template? Take your project management to a whole new level! Manage project details effectively with this easy to use form.\",\"id\":20908993,\"released\":\"2019-11-24 23:00:07\",\"categories\":[\"Basic\",\"Business Operations\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/change-request-form\\/\",\"icon\":false,\"key\":\"change-request\",\"used_addons\":[],\"is_new\":false},\"20874734\":{\"name\":\"B2B Leads Form Template\",\"slug\":\"b2b-leads-form\",\"description\":\"Expand your clientele and increase revenue by bridging the gap between you and your customers.\",\"id\":20874734,\"released\":\"2019-01-01 13:09:59\",\"categories\":[\"Business\",\"Contact\",\"Lead\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/b2b-leads-form\\/\",\"icon\":false,\"key\":\"b2b-leads\",\"used_addons\":[],\"is_new\":false},\"20909557\":{\"name\":\"Baseball League Registration Form\",\"slug\":\"baseball-league-registration-form\",\"description\":\"A simple form for registering players for a baseball league including positions, team, and more.\",\"id\":20909557,\"released\":\"2019-11-24 23:00:05\",\"categories\":[\"Basic\",\"Registration and Signup\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/baseball-league-registration-form\\/\",\"icon\":false,\"key\":\"baseball-league-registration\",\"used_addons\":[],\"is_new\":false},\"28109851\":{\"name\":\"Quiz\",\"slug\":\"quiz-form\",\"description\":\"This multiple-choice quiz template is a great example of basic quiz scoring.\",\"id\":28109851,\"released\":\"2022-02-28 12:00:04\",\"categories\":[\"Business\",\"Education\",\"Quiz\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/quiz-form\\/\",\"icon\":false,\"key\":\"quiz\",\"used_addons\":[\"Conversational Forms\",\"Quiz Maker\"],\"is_new\":false},\"28148784\":{\"name\":\"Harry Potter House Quiz Template\",\"slug\":\"harry-potter-house-quiz-form\",\"description\":\"Find out which Hogwarts house you truly belong in with this quiz form template.\",\"id\":28148784,\"released\":\"2022-09-20 10:47:37\",\"categories\":[\"Business\",\"Conversational Forms\",\"Entertainment\",\"Quiz\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/harry-potter-house-quiz-form\\/\",\"icon\":false,\"key\":\"harry-potter-house-quiz\",\"used_addons\":[\"Conversational Forms\",\"Quiz Maker\"],\"is_new\":false},\"22214080\":{\"name\":\"Employee Satisfaction Survey Template\",\"slug\":\"employee-satisfaction-survey-form\",\"description\":\"Job satisfaction matters - get data with a user-friendly survey!\",\"id\":22214080,\"released\":\"2020-05-27 10:55:52\",\"categories\":[\"Business\",\"Survey\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/employee-satisfaction-survey-form\\/\",\"icon\":[\"https:\\/\\/formidableforms.com\\/wp-content\\/uploads\\/2020\\/05\\/employee-engagement-survey-template.jpg\",650,288,false],\"key\":\"employee-satisfaction-survey\",\"used_addons\":[],\"is_new\":false},\"28028195\":{\"name\":\"Change of Address Form Template\",\"slug\":\"change-of-address-form\",\"description\":\"Need a change of address form template? This form allows any business or government organization to offer an easy way for users to change addresses online.\",\"id\":28028195,\"released\":\"2020-11-23 00:06:21\",\"categories\":[\"Basic\",\"Business Operations\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/change-of-address-form\\/\",\"icon\":false,\"key\":\"change-of-address\",\"used_addons\":[],\"is_new\":false},\"20909235\":{\"name\":\"Amortization Calculator Template\",\"slug\":\"amortization-calculator-form\",\"description\":\"Estimate monthly mortgage payment principal and interest amounts.\",\"id\":20909235,\"released\":\"2019-11-24 23:00:38\",\"categories\":[\"Business\",\"Calculator\",\"Finance\",\"Real Estate\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/amortization-calculator-form\\/\",\"icon\":false,\"key\":\"amortization-calculator\",\"used_addons\":[],\"is_new\":false},\"28028149\":{\"name\":\"Customer Referral Form Template\",\"slug\":\"customer-referral-form\",\"description\":\"Let your customers introduce you to potential new clients.\",\"id\":28028149,\"released\":\"2020-11-23 00:01:44\",\"categories\":[\"Basic\",\"Customer Service\",\"Marketing\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/customer-referral-form\\/\",\"icon\":false,\"key\":\"customer-referral\",\"used_addons\":[],\"is_new\":false},\"20907786\":{\"name\":\"BMI Calculator Form Template\",\"slug\":\"bmi-calculator-form\",\"description\":\"Calculate BMI (body mass index) to help clients improve health & fitness.\",\"id\":20907786,\"released\":\"2019-11-24 23:00:06\",\"categories\":[\"Business\",\"Calculator\",\"Health and Wellness\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/bmi-calculator-form\\/\",\"icon\":false,\"key\":\"bmi-calculator\",\"used_addons\":[],\"is_new\":false},\"28315136\":{\"name\":\"5k Run Registration Form Template\",\"slug\":\"5k-run-registration-form\",\"description\":\"Streamline participant sign-ups and collect essential details for your 5K run event with this registration form.\",\"id\":28315136,\"released\":\"2025-03-10 15:41:07\",\"categories\":[\"Business\",\"Event Planning\",\"Registration and Signup\",\"Signature\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/5k-run-registration-form\\/\",\"icon\":false,\"key\":\"5k-run-registration\",\"used_addons\":[\"Digital Signatures\"],\"is_new\":true},\"28147968\":{\"name\":\"Product Recommendation Quiz Template\",\"slug\":\"product-recommendation-quiz-form\",\"description\":\"Discover your skin type and the ideal recommended product with this quiz template.\",\"id\":28147968,\"released\":\"2022-09-20 12:05:48\",\"categories\":[\"Business\",\"Conversational Forms\",\"Quiz\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/product-recommendation-quiz-form\\/\",\"icon\":false,\"key\":\"product-recommendation-quiz\",\"used_addons\":[\"Conversational Forms\",\"Quiz Maker\"],\"is_new\":false},\"20874752\":{\"name\":\"Simple Mortgage Calculator Template\",\"slug\":\"simple-mortgage-calculator-form\",\"description\":\"Optimize any real estate website with this responsive mortgage calculator!\",\"id\":20874752,\"released\":\"2019-01-01 12:55:25\",\"categories\":[\"Business\",\"Calculator\",\"Finance\",\"Real Estate\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/simple-mortgage-calculator-form\\/\",\"icon\":false,\"key\":\"simple-mortgage-calculator\",\"used_addons\":[],\"is_new\":false},\"20874753\":{\"name\":\"Edit User Profile Form Template\",\"slug\":\"edit-user-profile-form\",\"description\":\"The basics from the regular WordPress profile page including first and last name, password and email, avatar, website, and bio.\",\"id\":20874753,\"released\":\"2019-01-01 13:25:02\",\"categories\":[\"Business\",\"User Registration\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/edit-user-profile-form\\/\",\"icon\":false,\"key\":\"edit-user-profile\",\"used_addons\":[],\"is_new\":false},\"28019201\":{\"name\":\"Charitable Donation Form Template\",\"slug\":\"charitable-donation-form\",\"description\":\"A quick and easy form for collecting and keeping track of charitable donations.\",\"id\":28019201,\"released\":\"2020-09-11 14:40:07\",\"categories\":[\"free\",\"Nonprofit\",\"Payment\",\"Stripe\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/charitable-donation-form\\/\",\"icon\":false,\"key\":\"charitable-donation\",\"used_addons\":[],\"is_new\":false},\"28028161\":{\"name\":\"Direct Deposit ACH Authorization Form Template\",\"slug\":\"direct-deposit-ach-authorization-form\",\"description\":\"Simplify employee onboarding with a direct deposit ACH authorization form.\",\"id\":28028161,\"released\":\"2020-11-23 00:02:48\",\"categories\":[\"Business\",\"Business Operations\",\"Signature\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/direct-deposit-ach-authorization-form\\/\",\"icon\":false,\"key\":\"direct-deposit-ach-authorization\",\"used_addons\":[],\"is_new\":false},\"28297985\":{\"name\":\"Book Club Registration Form Template\",\"slug\":\"book-club-registration-form\",\"description\":\"Allow users to easily register their children for your book club.\",\"id\":28297985,\"released\":\"2024-10-08 13:06:13\",\"categories\":[\"Business\",\"Business Operations\",\"File Upload\",\"Registration and Signup\",\"Repeater Field\",\"User Registration\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/book-club-registration-form\\/\",\"icon\":false,\"key\":\"book-club-registration\",\"used_addons\":[\"User Registration\"],\"is_new\":false},\"28173825\":{\"name\":\"Signup Sheet Form Template\",\"slug\":\"signup-sheet-form\",\"description\":\"Generate signups and easily collect information with the signup form template.\",\"id\":28173825,\"released\":\"2023-01-26 16:03:51\",\"categories\":[\"Business\",\"Conversational Forms\",\"Education\",\"Lead\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/signup-sheet-form\\/\",\"icon\":false,\"key\":\"signup-sheet\",\"used_addons\":[],\"is_new\":false},\"20874754\":{\"name\":\"Customer Feedback Form Template\",\"slug\":\"customer-feedback-form\",\"description\":\"Get suggestions and valuable feedback from your customers.\",\"id\":20874754,\"released\":\"2019-01-29 13:23:40\",\"categories\":[\"Business\",\"Feedback\",\"Survey\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/customer-feedback-form\\/\",\"icon\":false,\"key\":\"customer-feedback\",\"used_addons\":[],\"is_new\":false},\"28019202\":{\"name\":\"Sponsorship Form Template\",\"slug\":\"sponsorship-form\",\"description\":\"A simple form for use in managing business sponsorships.\",\"id\":28019202,\"released\":\"2020-10-01 08:18:17\",\"categories\":[\"Basic\",\"Business Operations\",\"Nonprofit\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/sponsorship-form\\/\",\"icon\":false,\"key\":\"sponsorship\",\"used_addons\":[],\"is_new\":false},\"28314884\":{\"name\":\"Electronic Fund Transfer Form Template\",\"slug\":\"electronic-fund-transfer-form\",\"description\":\"Securely collect and process electronic fund transfer requests with this streamlined form.\",\"id\":28314884,\"released\":\"2025-03-07 13:21:43\",\"categories\":[\"Business\",\"Business Operations\",\"Multi-Page\",\"Signature\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/electronic-fund-transfer-form\\/\",\"icon\":false,\"key\":\"electronic-fund-transfer\",\"used_addons\":[\"Digital Signatures\"],\"is_new\":true},\"28054276\":{\"name\":\"Pay Raise Percent Calculator Template\",\"slug\":\"pay-raise-percent-calculator-form\",\"description\":\"Enter a wage before and after a raise to find out how large your raise was.\",\"id\":28054276,\"released\":\"2021-04-14 11:59:56\",\"categories\":[\"Business\",\"Business Operations\",\"Calculator\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/pay-raise-percent-calculator-form\\/\",\"icon\":false,\"key\":\"pay-raise-percent-calculator\",\"used_addons\":[],\"is_new\":false},\"28028164\":{\"name\":\"Referral Form Template\",\"slug\":\"referral-form\",\"description\":\"Get referrals from people easily with this short and effective referral form.\",\"id\":28028164,\"released\":\"2020-11-23 00:02:17\",\"categories\":[\"Basic\",\"Customer Service\",\"Feedback\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/referral-form\\/\",\"icon\":false,\"key\":\"referral\",\"used_addons\":[],\"is_new\":false},\"28030724\":{\"name\":\"Car Donation Form Template\",\"slug\":\"car-donation-form\",\"description\":\"Collecting vehicle donations? Get all the details you need in this simple online form.\",\"id\":28030724,\"released\":\"2020-12-01 00:01:50\",\"categories\":[\"Nonprofit\",\"Personal\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/car-donation-form\\/\",\"icon\":false,\"key\":\"car-donation\",\"used_addons\":[],\"is_new\":false},\"20874757\":{\"name\":\"Small Business Loan Application Form\",\"slug\":\"small-business-loan-application-form\",\"description\":\"A complete loan application for small businesses and startups. Allow business owners to easily apply for loans on your site.\",\"id\":20874757,\"released\":\"2019-01-01 13:17:02\",\"categories\":[\"Application\",\"Business\",\"File Upload\",\"Finance\",\"Multi-Page\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/small-business-loan-application-form\\/\",\"icon\":false,\"key\":\"small-business-loan-application\",\"used_addons\":[],\"is_new\":false},\"28030725\":{\"name\":\"Credit Card Donation Form Template\",\"slug\":\"credit-card-donation-form\",\"description\":\"Credit card donations are the easiest way to donate, and this form template will make it quick for your organization.\",\"id\":28030725,\"released\":\"2020-12-01 00:01:42\",\"categories\":[\"Business\",\"Nonprofit\",\"Payment\",\"Stripe\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/credit-card-donation-form\\/\",\"icon\":false,\"key\":\"credit-card-donation\",\"used_addons\":[],\"is_new\":false},\"28315142\":{\"name\":\"Recording Studio Booking Form Template\",\"slug\":\"recording-studio-booking-form\",\"description\":\"Easily schedule studio sessions, collect client details, and process payments with this recording studio booking form.\",\"id\":28315142,\"released\":\"2025-03-10 15:48:25\",\"categories\":[\"Business\",\"Business Operations\",\"Multi-Page\",\"Payment\",\"PayPal\",\"Stripe\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/recording-studio-booking-form\\/\",\"icon\":false,\"key\":\"recording-studio-booking\",\"used_addons\":[\"PayPal Standard\",\"Stripe\"],\"is_new\":true},\"20874759\":{\"name\":\"Extended Contact Details Template\",\"slug\":\"extended-contact-details-form\",\"description\":\"Looking for a contact form template that packs a little more punch? This contact form template is complete with social media contact info.\",\"id\":20874759,\"released\":\"2019-01-01 13:15:45\",\"categories\":[\"Basic\",\"Contact\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/extended-contact-details-form\\/\",\"icon\":false,\"key\":\"extended-contact-details\",\"used_addons\":[],\"is_new\":false},\"28237576\":{\"name\":\"Volume Calculator Template\",\"slug\":\"volume-calculator-form\",\"description\":\"Input the dimensions of your object into the calculator to easily determine its volume.\",\"id\":28237576,\"released\":\"2023-11-10 16:09:37\",\"categories\":[\"Business\",\"Calculator\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/volume-calculator-form\\/\",\"icon\":false,\"key\":\"volume-calculator\",\"used_addons\":[],\"is_new\":false},\"20907785\":{\"name\":\"Age Calculator Form Template\",\"slug\":\"age-calculator-form\",\"description\":\"Get an age calculator that tells you your age down to the day!\",\"id\":20907785,\"released\":\"2019-11-24 23:00:10\",\"categories\":[\"Calculator\",\"Datepicker\",\"Personal\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/age-calculator-form\\/\",\"icon\":false,\"key\":\"age-calculator\",\"used_addons\":[\"Datepicker Options\"],\"is_new\":false},\"28028170\":{\"name\":\"Counseling Informed Consent Template\",\"slug\":\"professional-counseling-informed-consent-form\",\"description\":\"Acquire informed consent from clients for mental health treatment.\",\"id\":28028170,\"released\":\"2020-11-23 00:01:26\",\"categories\":[\"Business\",\"Health and Wellness\",\"Signature\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/professional-counseling-informed-consent-form\\/\",\"icon\":false,\"key\":\"professional-counseling-informed-consent\",\"used_addons\":[],\"is_new\":false},\"20907787\":{\"name\":\"Compound Interest Calculator Template\",\"slug\":\"compound-interest-calculator-form\",\"description\":\"Calculate total compound interest on an investment or loan.\",\"id\":20907787,\"released\":\"2019-11-24 23:00:57\",\"categories\":[\"Business\",\"Calculator\",\"Finance\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/compound-interest-calculator-form\\/\",\"icon\":false,\"key\":\"compound-interest-calculator\",\"used_addons\":[],\"is_new\":false},\"28315147\":{\"name\":\"Arts and Crafts Fair Application Form Template\",\"slug\":\"arts-and-craft-fair-application-form\",\"description\":\"Efficiently gather vendor applications for your arts and crafts fair.\",\"id\":28315147,\"released\":\"2025-03-10 16:19:08\",\"categories\":[\"Application\",\"Basic\",\"Business Operations\",\"File Upload\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/arts-and-craft-fair-application-form\\/\",\"icon\":false,\"key\":\"arts-and-craft-fair-application\",\"used_addons\":[],\"is_new\":true},\"20907788\":{\"name\":\"Final Grade Calculator Template\",\"slug\":\"final-grade-calculator-form\",\"description\":\"Calculate the grade needed on an exam to get the desired final score.\",\"id\":20907788,\"released\":\"2019-11-24 23:00:53\",\"categories\":[\"Business\",\"Calculator\",\"Education\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/final-grade-calculator-form\\/\",\"icon\":false,\"key\":\"final-grade-calculator\",\"used_addons\":[],\"is_new\":false},\"20907789\":{\"name\":\"Pregnancy Due Date Calculator Form Template\",\"slug\":\"pregnancy-due-date-calculator-form\",\"description\":\"Calculate the number of days until the baby due date.\",\"id\":20907789,\"released\":\"2019-11-24 23:00:32\",\"categories\":[\"Business\",\"Calculator\",\"Health and Wellness\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/pregnancy-due-date-calculator-form\\/\",\"icon\":false,\"key\":\"pregnancy-due-date-calculator\",\"used_addons\":[],\"is_new\":false},\"28028174\":{\"name\":\"Basketball League Registration Form Template\",\"slug\":\"basketball-league-registration-form\",\"description\":\"Need a basketball registration form template? Take your basketball team to the next level with a form that simplifies the registration process.\",\"id\":28028174,\"released\":\"2020-11-23 00:05:47\",\"categories\":[\"Business\",\"Registration and Signup\",\"Signature\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/basketball-league-registration-form\\/\",\"icon\":false,\"key\":\"basketball-league-registration\",\"used_addons\":[\"Digital Signatures\"],\"is_new\":false},\"28315151\":{\"name\":\"Employee Attestation Form Template\",\"slug\":\"employee-attestation-form\",\"description\":\"Ensure employees formally acknowledge policies, training, and compliance requirements with this employee attestation form.\",\"id\":28315151,\"released\":\"2025-03-10 16:38:02\",\"categories\":[\"Basic\",\"Business Operations\",\"Consent\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/employee-attestation-form\\/\",\"icon\":false,\"key\":\"employee-attestation\",\"used_addons\":[],\"is_new\":true},\"28313873\":{\"name\":\"Lost Dog Form Template\",\"slug\":\"lost-dog-form\",\"description\":\"Help reunite lost dogs with their owners by collecting key details about the missing pet and contact information.\",\"id\":28313873,\"released\":\"2025-02-27 14:02:30\",\"categories\":[\"Basic\",\"File Upload\",\"Nonprofit\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/lost-dog-form\\/\",\"icon\":false,\"key\":\"lost-dog\",\"used_addons\":[],\"is_new\":false},\"28056081\":{\"name\":\"Pizza Takeout Order Form Template\",\"slug\":\"pizza-takeout-order-form\",\"description\":\"This quick and easy form is the best way to submit your pizza takeout order.\",\"id\":28056081,\"released\":\"2021-07-05 16:37:27\",\"categories\":[\"Business\",\"Business Operations\",\"Order Form\",\"Payment\",\"Stripe\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/pizza-takeout-order-form\\/\",\"icon\":false,\"key\":\"pizza-takeout-order\",\"used_addons\":[\"Stripe\"],\"is_new\":false},\"28314898\":{\"name\":\"Workout Tracker Form Template\",\"slug\":\"workout-tracker-form\",\"description\":\"Efficiently track and collect workout data from clients or employees to monitor progress and performance.\",\"id\":28314898,\"released\":\"2025-03-07 16:20:58\",\"categories\":[\"Basic\",\"Health and Wellness\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/workout-tracker-form\\/\",\"icon\":false,\"key\":\"workout-tracker\",\"used_addons\":[],\"is_new\":true},\"28205842\":{\"name\":\"Science Quiz Template\",\"slug\":\"science-quiz-form\",\"description\":\"Take our science quiz to discover how much you know about certain topics.\",\"id\":28205842,\"released\":\"2023-06-27 16:17:31\",\"categories\":[\"Business\",\"Education\",\"Quiz\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/science-quiz-form\\/\",\"icon\":false,\"key\":\"science-quiz\",\"used_addons\":[\"Quiz Maker\"],\"is_new\":false},\"28028178\":{\"name\":\"Incident Report Form Template\",\"slug\":\"incident-report-form\",\"description\":\"Use this template to report various types of workplace incidents\",\"id\":28028178,\"released\":\"2020-11-23 00:01:03\",\"categories\":[\"Business\",\"Business Operations\",\"Signature\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/incident-report-form\\/\",\"icon\":false,\"key\":\"incident-report\",\"used_addons\":[\"Digital Signatures\"],\"is_new\":false},\"28030996\":{\"name\":\"GiveWP Donation Form Template\",\"slug\":\"givewp-donation-form\",\"description\":\"Using GiveWP? This form will help you create a peer-to-peer campaign submission form for GiveWP.\",\"id\":28030996,\"released\":\"2020-12-01 00:01:39\",\"categories\":[\"Nonprofit\",\"Personal\",\"Post\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/givewp-donation-form\\/\",\"icon\":false,\"key\":\"givewp-donation\",\"used_addons\":[],\"is_new\":false},\"28056088\":{\"name\":\"Brand Awareness Survey Template\",\"slug\":\"brand-awareness-survey-form\",\"description\":\"Treat your brand like a celebrity. Stay famous by tracking what people like the most.\",\"id\":28056088,\"released\":\"2021-07-08 09:10:20\",\"categories\":[\"Business\",\"Feedback\",\"Survey\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/brand-awareness-survey-form\\/\",\"icon\":false,\"key\":\"brand-awareness-survey\",\"used_addons\":[],\"is_new\":false},\"20874778\":{\"name\":\"WooCommerce Product Configurator\",\"slug\":\"sample-woocommerce-product-configurator-form\",\"description\":\"Calculate the total value of a WooCommerce product with add-ons and style options.\",\"id\":20874778,\"released\":\"2019-01-29 14:29:25\",\"categories\":[\"Calculator\",\"Elite\",\"WooCommerce\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/sample-woocommerce-product-configurator-form\\/\",\"icon\":false,\"key\":\"sample-woocommerce-product-configurator\",\"used_addons\":[\"WooCommerce\"],\"is_new\":false},\"28220186\":{\"name\":\"Shipping Date Calculator Template\",\"slug\":\"shipping-date-calculator-form\",\"description\":\"Calculate the estimated delivery date for a package using transit time and processing time.\",\"id\":28220186,\"released\":\"2023-08-28 16:20:33\",\"categories\":[\"Business\",\"Calculator\",\"Datepicker\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/shipping-date-calculator-form\\/\",\"icon\":false,\"key\":\"shipping-date-calculator\",\"used_addons\":[\"Datepicker Options\"],\"is_new\":false},\"28297242\":{\"name\":\"Candidate Ranking Survey Template\",\"slug\":\"candidate-ranking-survey-form\",\"description\":\"Easily and efficiently rank candidates in order of preference.\",\"id\":28297242,\"released\":\"2024-10-03 12:11:28\",\"categories\":[\"Basic\",\"Business Operations\",\"Survey\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/candidate-ranking-survey-form\\/\",\"icon\":false,\"key\":\"candidate-ranking-survey\",\"used_addons\":[],\"is_new\":false},\"28200476\":{\"name\":\"Interactive Fiction Form Template\",\"slug\":\"interactive-fiction-form\",\"description\":\"Use our Interactive Fiction Form to go on an exciting adventure based on your choices.\",\"id\":28200476,\"released\":\"2023-06-27 16:38:04\",\"categories\":[\"Business\",\"Conversational Forms\",\"Entertainment\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/interactive-fiction-form\\/\",\"icon\":false,\"key\":\"interactive-fiction\",\"used_addons\":[\"Conversational Forms\"],\"is_new\":false},\"28150044\":{\"name\":\"Employee Write Up Form Template\",\"slug\":\"write-up-form\",\"description\":\"Report an incident and collect information that you need to implement disciplinary action with the Employee Write Up form template.\",\"id\":28150044,\"released\":\"2022-11-06 16:37:00\",\"categories\":[\"Business\",\"Business Operations\",\"Signature\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/write-up-form\\/\",\"icon\":false,\"key\":\"write-up\",\"used_addons\":[],\"is_new\":false},\"28067101\":{\"name\":\"Fuel Cost Calculator Template\",\"slug\":\"fuel-cost-calculator-form\",\"description\":\"When going on a trip it is nice to know how much fuel will cost. This calculator is very helpful in budgeting for a road trip.\",\"id\":28067101,\"released\":\"2021-07-23 15:30:00\",\"categories\":[\"Business\",\"Calculator\",\"Event Planning\",\"Finance\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/fuel-cost-calculator-form\\/\",\"icon\":false,\"key\":\"fuel-cost-calculator\",\"used_addons\":[],\"is_new\":false},\"20872734\":{\"name\":\"Contact Us Form Template\",\"slug\":\"contact-us-form\",\"description\":\"A basic contact form that for any WordPress website.\",\"id\":20872734,\"released\":\"2017-01-17 16:31:35\",\"categories\":[\"Contact\",\"free\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/contact-us-form\\/\",\"icon\":false,\"key\":\"contact-us\",\"used_addons\":[],\"is_new\":false},\"28067104\":{\"name\":\"Gas Buddy Trip Calculator Form Template\",\"slug\":\"gas-buddy-trip-calculator-form\",\"description\":\"When going on a trip with a buddy, it is nice to know how high the cost will be when splitting it between multiple people.\",\"id\":28067104,\"released\":\"2021-07-23 15:23:25\",\"categories\":[\"Business\",\"Calculator\",\"Event Planning\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/gas-buddy-trip-calculator-form\\/\",\"icon\":false,\"key\":\"gas-buddy-trip-calculator\",\"used_addons\":[],\"is_new\":false},\"28205856\":{\"name\":\"Math Quiz Template\",\"slug\":\"math-quiz-form\",\"description\":\"Take our quick and easy math quiz to determine how much you know when it comes to basic math.\",\"id\":28205856,\"released\":\"2023-06-27 16:46:31\",\"categories\":[\"Business\",\"Education\",\"Quiz\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/math-quiz-form\\/\",\"icon\":false,\"key\":\"math-quiz\",\"used_addons\":[],\"is_new\":false},\"28221984\":{\"name\":\"New Hire Form Template\",\"slug\":\"new-hire-form\",\"description\":\"Gather essential information from new hires to ensure a smooth onboarding process.\",\"id\":28221984,\"released\":\"2023-11-18 03:52:00\",\"categories\":[\"Business\",\"Business Operations\",\"Contact\",\"Signature\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/new-hire-form\\/\",\"icon\":false,\"key\":\"new-hire\",\"used_addons\":[],\"is_new\":false},\"28220193\":{\"name\":\"Clothing Order Form Template\",\"slug\":\"clothing-order-form\",\"description\":\"Select a clothing item, quantity and price, then complete payment and shipping details with this clothing order form template.\",\"id\":28220193,\"released\":\"2023-11-18 03:24:00\",\"categories\":[\"Business\",\"Business Operations\",\"Order Form\",\"Payment\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/clothing-order-form\\/\",\"icon\":false,\"key\":\"clothing-order\",\"used_addons\":[],\"is_new\":false},\"28232481\":{\"name\":\"Business Inquiry Form Template\",\"slug\":\"business-inquiry-form\",\"description\":\"Obtain contact information from potential clients interested in your business.\",\"id\":28232481,\"released\":\"2023-11-11 05:17:00\",\"categories\":[\"Basic\",\"Business Operations\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/business-inquiry-form\\/\",\"icon\":false,\"key\":\"business-inquiry\",\"used_addons\":[],\"is_new\":false},\"28194594\":{\"name\":\"Lesson Idea Generator Form Template\",\"slug\":\"lesson-idea-generator-form\",\"description\":\"Generate engaging lesson plans with the Lesson Idea Generator template by inputting the subject, lesson topic, sub-topic, and any notes about the audience.\",\"id\":28194594,\"released\":\"2023-04-29 23:12:07\",\"categories\":[\"AI\",\"Business\",\"Education\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/lesson-idea-generator-form\\/\",\"icon\":false,\"key\":\"lesson-idea-generator\",\"used_addons\":[\"AI Forms\"],\"is_new\":false},\"28220196\":{\"name\":\"Payment Form Template\",\"slug\":\"payment-form\",\"description\":\"Use this payment form to for quick and easy purchases.\",\"id\":28220196,\"released\":\"2023-11-18 03:37:00\",\"categories\":[\"Business\",\"Payment\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/payment-form\\/\",\"icon\":false,\"key\":\"payment\",\"used_addons\":[],\"is_new\":false},\"28028196\":{\"name\":\"Audition Form Template\",\"slug\":\"audition-form\",\"description\":\"Looking for an audition form template to streamline auditions to your project? Make auditioning easier for everyone involved by creating an online form based on this template. No coding required!\",\"id\":28028196,\"released\":\"2020-11-23 00:09:59\",\"categories\":[\"Basic\",\"Business Operations\",\"Registration and Signup\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/audition-form\\/\",\"icon\":false,\"key\":\"audition\",\"used_addons\":[],\"is_new\":false},\"28195109\":{\"name\":\"Leave of Absence Form Template\",\"slug\":\"leave-of-absence-form\",\"description\":\"This leave of absence request form is used to formally request time off from work for a specific period of time.\",\"id\":28195109,\"released\":\"2023-05-02 18:05:28\",\"categories\":[\"Business\",\"Business Operations\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/leave-of-absence-form\\/\",\"icon\":false,\"key\":\"leave-of-absence\",\"used_addons\":[],\"is_new\":false},\"20909862\":{\"name\":\"Wedding Party RSVP Form\",\"slug\":\"wedding-party-rsvp-form\",\"description\":\"Keep track of the number of guests for any wedding.\",\"id\":20909862,\"released\":\"2019-11-24 23:00:02\",\"categories\":[\"Basic\",\"Event Planning\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/wedding-party-rsvp-form\\/\",\"icon\":false,\"key\":\"wedding-party-rsvp\",\"used_addons\":[],\"is_new\":false},\"28274470\":{\"name\":\"Coffee Preference Survey Template\",\"slug\":\"coffee-preference-survey-form\",\"description\":\"Understand preferences and trends in coffee consumption with this coffee preference survey template.\",\"id\":28274470,\"released\":\"2024-04-17 14:54:18\",\"categories\":[\"Basic\",\"Business Operations\",\"Feedback\",\"Survey\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/coffee-preference-survey-form\\/\",\"icon\":false,\"key\":\"coffee-preference-survey\",\"used_addons\":[\"Surveys and Polls\"],\"is_new\":false},\"20909863\":{\"name\":\"Simple RSVP Form\",\"slug\":\"simple-rsvp-form\",\"description\":\"A general RSVP form that can be used for any occasion.\",\"id\":20909863,\"released\":\"2019-11-24 23:00:57\",\"categories\":[\"Event Planning\",\"free\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/simple-rsvp-form\\/\",\"icon\":false,\"key\":\"simple-rsvp\",\"used_addons\":[],\"is_new\":false},\"28028199\":{\"name\":\"Vacation Request Form Template\",\"slug\":\"vacation-request-form\",\"description\":\"Let employees request vacation time with this online vacation request form template.\",\"id\":28028199,\"released\":\"2020-11-23 00:03:20\",\"categories\":[\"Business\",\"Business Operations\",\"Calculator\",\"Datepicker\",\"Request\",\"Signature\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/vacation-request-form\\/\",\"icon\":false,\"key\":\"vacation-request\",\"used_addons\":[\"Datepicker Options\",\"Digital Signatures\"],\"is_new\":false},\"20909864\":{\"name\":\"Potluck Invitation RSVP Form\",\"slug\":\"potluck-invitation-rsvp-form\",\"description\":\"Keep track of who is coming and what they will bring to the next potluck.\",\"id\":20909864,\"released\":\"2019-11-24 23:00:43\",\"categories\":[\"Basic\",\"Event Planning\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/potluck-invitation-rsvp-form\\/\",\"icon\":false,\"key\":\"potluck-invitation-rsvp\",\"used_addons\":[],\"is_new\":false},\"28200744\":{\"name\":\"History Quiz Template\",\"slug\":\"history-quiz-form\",\"description\":\"Test your knowledge of world history through our history quiz.\",\"id\":28200744,\"released\":\"2023-06-27 16:30:50\",\"categories\":[\"Business\",\"Education\",\"Quiz\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/history-quiz-form\\/\",\"icon\":false,\"key\":\"history-quiz\",\"used_addons\":[],\"is_new\":false},\"20909865\":{\"name\":\"Party Invitation RSVP Form\",\"slug\":\"party-invitation-rsvp-form\",\"description\":\"A simple form used for keeping track of party guests.\",\"id\":20909865,\"released\":\"2019-11-24 23:00:37\",\"categories\":[\"Event Planning\",\"free\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/party-invitation-rsvp-form\\/\",\"icon\":false,\"key\":\"party-invitation-rsvp\",\"used_addons\":[],\"is_new\":false},\"28220458\":{\"name\":\"Supply Order Form Template\",\"slug\":\"supply-order-form\",\"description\":\"Use this form to place an order for office supplies.\",\"id\":28220458,\"released\":\"2023-11-11 02:46:00\",\"categories\":[\"Business\",\"Business Operations\",\"Order Form\",\"Payment\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/supply-order-form\\/\",\"icon\":false,\"key\":\"supply-order\",\"used_addons\":[],\"is_new\":false},\"28028203\":{\"name\":\"Video Release Form Template\",\"slug\":\"video-release-form\",\"description\":\"Get consent to share videos in your business marketing.\",\"id\":28028203,\"released\":\"2020-11-23 00:01:26\",\"categories\":[\"Business\",\"Business Operations\",\"Consent\",\"Marketing\",\"Multi-Page\",\"Signature\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/video-release-form\\/\",\"icon\":false,\"key\":\"video-release\",\"used_addons\":[\"Digital Signatures\"],\"is_new\":false},\"28200493\":{\"name\":\"Harry Potter Character Quiz Form Template\",\"slug\":\"harry-potter-character-quiz-form\",\"description\":\"Take this quick and easy quiz to find out which Harry Potter character you are.\",\"id\":28200493,\"released\":\"2023-05-31 13:38:51\",\"categories\":[\"Business\",\"Conversational Forms\",\"Personal\",\"Quiz\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/harry-potter-character-quiz-form\\/\",\"icon\":false,\"key\":\"harry-potter-character-quiz\",\"used_addons\":[],\"is_new\":false},\"28054574\":{\"name\":\"Conversion Rate Calculator\",\"slug\":\"conversion-rate-calculator-form\",\"description\":\"Find out the percentage of people are making purchases with this quick and easy lead magnet conversion rate calculator.\",\"id\":28054574,\"released\":\"2021-07-12 08:16:52\",\"categories\":[\"Business\",\"Business Operations\",\"Calculator\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/conversion-rate-calculator-form\\/\",\"icon\":false,\"key\":\"conversion-rate-calculator\",\"used_addons\":[],\"is_new\":false},\"28225326\":{\"name\":\"Return Merchandise Authorization Form\",\"slug\":\"return-merchandise-authorization-form\",\"description\":\"Collect necessary details from customers seeking to initiate returns or exchanges, ensuring a smooth and efficient process for handling merchandise-related inquiries.\",\"id\":28225326,\"released\":\"2023-11-18 10:24:44\",\"categories\":[\"Basic\",\"Business Operations\",\"Repeater Field\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/return-merchandise-authorization-form\\/\",\"icon\":false,\"key\":\"return-merchandise-authorization\",\"used_addons\":[],\"is_new\":false},\"28310318\":{\"name\":\"Mileage Reimbursement Form Template\",\"slug\":\"mileage-reimbursement-form\",\"description\":\"Easily submit receipts and request mileage reimbursement with a simple, streamlined process.\",\"id\":28310318,\"released\":\"2025-01-30 12:41:46\",\"categories\":[\"Business\",\"File Upload\",\"Finance\",\"Repeater Field\",\"Request\",\"Signature\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/mileage-reimbursement-form\\/\",\"icon\":false,\"key\":\"mileage-reimbursement\",\"used_addons\":[\"Digital Signatures\"],\"is_new\":false},\"28054576\":{\"name\":\"Credit Card Repayment Calculator\",\"slug\":\"credit-card-repayment-calculator-form\",\"description\":\"Let visitors know how long it would take to get out of debt. This quick and easy credit card repayment calculator is a great way to generate leads.\",\"id\":28054576,\"released\":\"2021-08-06 16:15:23\",\"categories\":[\"Business\",\"Calculator\",\"Finance\",\"Lead\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/credit-card-repayment-calculator-form\\/\",\"icon\":false,\"key\":\"credit-card-repayment-calculator\",\"used_addons\":[],\"is_new\":false},\"28097584\":{\"name\":\"Request a Callback Form Template\",\"slug\":\"request-a-callback-form\",\"description\":\"There are many different ways to get in touch with customers, but sometimes the most effective is a call back.\",\"id\":28097584,\"released\":\"2021-12-20 11:25:07\",\"categories\":[\"Basic\",\"Customer Service\",\"Lead\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/request-a-callback-form\\/\",\"icon\":false,\"key\":\"request-a-callback\",\"used_addons\":[],\"is_new\":false},\"28220465\":{\"name\":\"Nomination Form Template\",\"slug\":\"nomination-form\",\"description\":\"Use this form to nominate employees for an award.\",\"id\":28220465,\"released\":\"2023-11-11 02:42:00\",\"categories\":[\"Basic\",\"Business Operations\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/nomination-form\\/\",\"icon\":false,\"key\":\"nomination\",\"used_addons\":[],\"is_new\":false},\"28200754\":{\"name\":\"Career Quiz Template\",\"slug\":\"career-quiz-form\",\"description\":\"Take this short quiz and discover your ideal career based on your responses.\",\"id\":28200754,\"released\":\"2023-06-27 16:22:04\",\"categories\":[\"Business\",\"Conversational Forms\",\"Entertainment\",\"Quiz\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/career-quiz-form\\/\",\"icon\":false,\"key\":\"career-quiz\",\"used_addons\":[\"Conversational Forms\"],\"is_new\":false},\"28145458\":{\"name\":\"Medical History Form Template\",\"slug\":\"medical-history-form\",\"description\":\"Make new patient registration faster by collecting information about a patient\\u2019s past conditions with the medical history form.\",\"id\":28145458,\"released\":\"2022-11-06 22:00:00\",\"categories\":[\"Basic\",\"Health and Wellness\",\"Registration and Signup\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/medical-history-form\\/\",\"icon\":false,\"key\":\"medical-history\",\"used_addons\":[],\"is_new\":false},\"28031026\":{\"name\":\"Rental Application Form Template\",\"slug\":\"rental-application-form\",\"description\":\"A comprehensive rental application form that takes all the relevant details from the applicant, including contact details, rental history, references, employment details, and next of kin.\",\"id\":28031026,\"released\":\"2020-11-25 13:30:08\",\"categories\":[\"Application\",\"Business\",\"Real Estate\",\"Signature\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/rental-application-form\\/\",\"icon\":false,\"key\":\"rental-application\",\"used_addons\":[\"Digital Signatures\"],\"is_new\":false},\"28215091\":{\"name\":\"Personality Quiz Template\",\"slug\":\"personality-quiz-form\",\"description\":\"Discover your personality with our short quiz.\",\"id\":28215091,\"released\":\"2023-09-01 15:18:13\",\"categories\":[\"Business\",\"Conversational Forms\",\"Quiz\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/personality-quiz-form\\/\",\"icon\":false,\"key\":\"personality-quiz\",\"used_addons\":[],\"is_new\":false},\"28225588\":{\"name\":\"Acknowledgement Form Template\",\"slug\":\"acknowledgement-form\",\"description\":\"Obtain acknowledgments and confirmations from individuals.\",\"id\":28225588,\"released\":\"2023-11-18 10:30:22\",\"categories\":[\"Business\",\"Business Operations\",\"Consent\",\"Signature\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/acknowledgement-form\\/\",\"icon\":false,\"key\":\"acknowledgement\",\"used_addons\":[\"Digital Signatures\"],\"is_new\":false},\"28236084\":{\"name\":\"Celsius to Fahrenheit Calculator Template\",\"slug\":\"celsius-to-fahrenheit-calculator-form\",\"description\":\"Easily switch between Celsius and Fahrenheit with our versatile temperature converter.\",\"id\":28236084,\"released\":\"2023-11-02 13:06:35\",\"categories\":[\"Business\",\"Calculator\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/celsius-to-fahrenheit-calculator-form\\/\",\"icon\":false,\"key\":\"celsius-to-fahrenheit-calculator\",\"used_addons\":[],\"is_new\":false},\"28222006\":{\"name\":\"W2 Form Template\",\"slug\":\"w2-form\",\"description\":\"Provide your tax-related information for accurate W-2 reporting.\",\"id\":28222006,\"released\":\"2023-11-11 03:57:00\",\"categories\":[\"Basic\",\"Business Operations\",\"Finance\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/w2-form\\/\",\"icon\":false,\"key\":\"w2\",\"used_addons\":[],\"is_new\":false},\"28145463\":{\"name\":\"Doctor Visit Form Template\",\"slug\":\"doctor-visit-form\",\"description\":\"Manage patient appointments and keep track of their follow ups with this doctor visit form template.\",\"id\":28145463,\"released\":\"2022-11-06 22:00:00\",\"categories\":[\"Business\",\"Business Operations\",\"Health and Wellness\",\"Registration and Signup\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/doctor-visit-form\\/\",\"icon\":false,\"key\":\"doctor-visit\",\"used_addons\":[],\"is_new\":false},\"28225591\":{\"name\":\"Wedding Date Application Form Template\",\"slug\":\"wedding-date-application-form\",\"description\":\"Collect information from guests attending a wedding who are seeking the ideal date to join in the celebration.\",\"id\":28225591,\"released\":\"2023-11-18 10:32:39\",\"categories\":[\"Application\",\"Event Planning\",\"free\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/wedding-date-application-form\\/\",\"icon\":false,\"key\":\"wedding-date-application\",\"used_addons\":[],\"is_new\":false},\"28031031\":{\"name\":\"Project Request Form Template\",\"slug\":\"project-request-form\",\"description\":\"This project request form template is designed to be the first point of contact between a potential customer and a creative service provider.\",\"id\":28031031,\"released\":\"2020-11-26 07:00:09\",\"categories\":[\"Customer Service\",\"Marketing\",\"Personal\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/project-request-form\\/\",\"icon\":false,\"key\":\"project-request\",\"used_addons\":[],\"is_new\":false},\"28238648\":{\"name\":\"Trip Price Calculator Template\",\"slug\":\"trip-price-calculator-form\",\"description\":\"Gather necessary details from users to calculate trip costs swiftly and accurately.\",\"id\":28238648,\"released\":\"2023-11-14 13:39:32\",\"categories\":[\"Business\",\"Business Operations\",\"Calculator\",\"Event Planning\",\"Finance\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/trip-price-calculator-form\\/\",\"icon\":false,\"key\":\"trip-price-calculator\",\"used_addons\":[],\"is_new\":false},\"28196153\":{\"name\":\"Catering Order Form Template\",\"slug\":\"catering-order-form\",\"description\":\"Use this quick and easy catering order form to effectively organize catering services for an event.\",\"id\":28196153,\"released\":\"2023-05-30 17:58:25\",\"categories\":[\"Business\",\"Event Planning\",\"Order Form\",\"Signature\",\"Stripe\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/catering-order-form\\/\",\"icon\":false,\"key\":\"catering-order\",\"used_addons\":[\"Digital Signatures\",\"Stripe\"],\"is_new\":false},\"28200505\":{\"name\":\"Spirit Animal Quiz Template\",\"slug\":\"spirit-animal-quiz-form\",\"description\":\"Discover your spirit animal through a quick and intriguing quiz.\",\"id\":28200505,\"released\":\"2023-06-27 16:34:58\",\"categories\":[\"Business\",\"Conversational Forms\",\"Entertainment\",\"Quiz\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/spirit-animal-quiz-form\\/\",\"icon\":false,\"key\":\"spirit-animal-quiz\",\"used_addons\":[\"Conversational Forms\",\"Quiz Maker\"],\"is_new\":false},\"28215099\":{\"name\":\"Patient Satisfaction Survey Template\",\"slug\":\"patient-satisfaction-survey-form\",\"description\":\"Help us improve your experience! Take a moment to share your thoughts in our brief patient satisfaction survey.\",\"id\":28215099,\"released\":\"2023-09-01 15:22:19\",\"categories\":[\"Business\",\"Feedback\",\"Survey\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/patient-satisfaction-survey-form\\/\",\"icon\":false,\"key\":\"patient-satisfaction-survey\",\"used_addons\":[],\"is_new\":false},\"28056636\":{\"name\":\"Neighborhood Feedback Form Template\",\"slug\":\"neighborhood-feedback-form\",\"description\":\"Get input in order to better understand how the community feels about a neighborhood! All responses are compiled into an easy-to-read report.\",\"id\":28056636,\"released\":\"2021-07-28 15:49:09\",\"categories\":[\"Event Planning\",\"Feedback\",\"Personal\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/neighborhood-feedback-form\\/\",\"icon\":false,\"key\":\"neighborhood-feedback\",\"used_addons\":[],\"is_new\":false},\"28225599\":{\"name\":\"Vendor Setup Form Template\",\"slug\":\"vendor-setup-form\",\"description\":\"Gather essential details from potential vendors interested in partnering with you.\",\"id\":28225599,\"released\":\"2023-11-18 10:33:57\",\"categories\":[\"Application\",\"Basic\",\"Business Operations\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/vendor-setup-form\\/\",\"icon\":false,\"key\":\"vendor-setup\",\"used_addons\":[],\"is_new\":false},\"28200514\":{\"name\":\"Vocabulary Quiz Form Template\",\"slug\":\"vocabulary-quiz-form\",\"description\":\"Take this vocabulary quiz to expand your vocabulary and discover how much you know.\",\"id\":28200514,\"released\":\"2023-06-27 16:51:37\",\"categories\":[\"Business\",\"Education\",\"Quiz\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/vocabulary-quiz-form\\/\",\"icon\":false,\"key\":\"vocabulary-quiz\",\"used_addons\":[\"Quiz Maker\"],\"is_new\":false},\"28305219\":{\"name\":\"Telemental Health Consent Form Template\",\"slug\":\"telemental-health-consent-form\",\"description\":\"A teletherapy consent form collects online consent for teletherapy services, securing patient rights and e-signatures for mental health professionals.\",\"id\":28305219,\"released\":\"2024-12-05 17:14:04\",\"categories\":[\"Business\",\"Consent\",\"Datepicker\",\"Health and Wellness\",\"Lifestyle\",\"Marketing\",\"Signature\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/telemental-health-consent-form\\/\",\"icon\":false,\"key\":\"telemental-health-consent\",\"used_addons\":[\"Digital Signatures\"],\"is_new\":false},\"28317252\":{\"name\":\"Return Request Form Template\",\"slug\":\"return-request-form\",\"description\":\"Efficiently process product return requests by collecting order details, reasons for return, and customer information.\",\"id\":28317252,\"released\":\"2025-03-28 13:46:14\",\"categories\":[\"Basic\",\"Business Operations\",\"Request\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/return-request-form\\/\",\"icon\":false,\"key\":\"return-request\",\"used_addons\":[],\"is_new\":true},\"28236868\":{\"name\":\"Senior Superlatives Nomination Form Template\",\"slug\":\"senior-superlatives-nomination-form\",\"description\":\"Gather nominations and details from students to nominate their peers for senior superlatives.\",\"id\":28236868,\"released\":\"2023-11-07 15:23:39\",\"categories\":[\"Basic\",\"Education\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/senior-superlatives-nomination-form\\/\",\"icon\":false,\"key\":\"senior-superlatives-nomination\",\"used_addons\":[],\"is_new\":false},\"20906055\":{\"name\":\"Prayer Request Form Template\",\"slug\":\"prayer-request-form\",\"description\":\"Help your remote congregation and shut-ins to connect with your church.\",\"id\":20906055,\"released\":\"2019-11-24 23:00:42\",\"categories\":[\"Basic\",\"Nonprofit\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/prayer-request-form\\/\",\"icon\":false,\"key\":\"prayer-request\",\"used_addons\":[],\"is_new\":false},\"28028231\":{\"name\":\"Fundraiser Order Form Template\",\"slug\":\"fundraiser-order-form\",\"description\":\"Make online fundraising a breeze and help volunteers raise money for your nonprofit.\",\"id\":28028231,\"released\":\"2020-12-01 00:01:23\",\"categories\":[\"Business\",\"Calculator\",\"Nonprofit\",\"Order Form\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/fundraiser-order-form\\/\",\"icon\":false,\"key\":\"fundraiser-order\",\"used_addons\":[],\"is_new\":false},\"28305225\":{\"name\":\"Medication Tracking List Form Template\",\"slug\":\"medication-tracking-list-form\",\"description\":\"A medication list template helps medical professionals track patient medications, including descriptions and last taken dates, with options for online completion or printing.\",\"id\":28305225,\"released\":\"2024-12-05 17:24:55\",\"categories\":[\"Basic\",\"Customer Service\",\"Health and Wellness\",\"Lifestyle\",\"Repeater Field\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/medication-tracking-list-form\\/\",\"icon\":false,\"key\":\"medication-tracking-list\",\"used_addons\":[],\"is_new\":false},\"20906058\":{\"name\":\"Travel Request Form Template\",\"slug\":\"travel-request-form\",\"description\":\"Provide a way for your employees to easily request travel arrangements for work.\",\"id\":20906058,\"released\":\"2019-11-24 23:00:06\",\"categories\":[\"Basic\",\"Business Operations\",\"Request\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/travel-request-form\\/\",\"icon\":false,\"key\":\"travel-request\",\"used_addons\":[],\"is_new\":false},\"28057162\":{\"name\":\"Employee Termination Form Template\",\"slug\":\"employee-termination-form\",\"description\":\"This form is a quick and easy way to log employee terminations.\",\"id\":28057162,\"released\":\"2021-07-26 15:41:53\",\"categories\":[\"Basic\",\"Business Operations\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/employee-termination-form\\/\",\"icon\":false,\"key\":\"employee-termination\",\"used_addons\":[],\"is_new\":false},\"28031306\":{\"name\":\"Bakery Order Form Template\",\"slug\":\"bakery-order-form\",\"description\":\"Boost sales and eliminate paperwork with this simple bakery order form.\",\"id\":28031306,\"released\":\"2020-11-27 00:01:08\",\"categories\":[\"Business Operations\",\"Calculator\",\"Elite\",\"Order Form\",\"Payment\",\"Stripe\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/bakery-order-form\\/\",\"icon\":false,\"key\":\"bakery-order\",\"used_addons\":[],\"is_new\":false},\"28121163\":{\"name\":\"Google Autofill Address Form Template\",\"slug\":\"google-address-autofill-form\",\"description\":\"Fill out forms faster and get more accurate data by integrating a Google Map into your web forms to autofill addresses.\",\"id\":28121163,\"released\":\"2022-08-09 16:39:34\",\"categories\":[\"Business\",\"Geolocation\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/google-address-autofill-form\\/\",\"icon\":false,\"key\":\"google-address-autofill\",\"used_addons\":[],\"is_new\":false},\"28147531\":{\"name\":\"Agreement Form Template\",\"slug\":\"agreement-form\",\"description\":\"Create a legal agreement between two parties with the agreement form template.\",\"id\":28147531,\"released\":\"2022-11-06 13:14:00\",\"categories\":[\"Business\",\"Business Operations\",\"Signature\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/agreement-form\\/\",\"icon\":false,\"key\":\"agreement\",\"used_addons\":[\"Digital Signatures\"],\"is_new\":false},\"28238668\":{\"name\":\"GKI Calculator Template\",\"slug\":\"gki-calculator-form\",\"description\":\"Collect relevant data from users to calculate the GKI, aiding in the assessment of glucose and ketone levels.\",\"id\":28238668,\"released\":\"2023-11-14 14:40:20\",\"categories\":[\"Business\",\"Calculator\",\"Health and Wellness\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/gki-calculator-form\\/\",\"icon\":false,\"key\":\"gki-calculator\",\"used_addons\":[],\"is_new\":false},\"28317261\":{\"name\":\"Pizza Survey Form Template\",\"slug\":\"pizza-survey-form-2\",\"description\":\"Gather customer feedback on pizza flavors, quality, and service to improve your offerings with this survey form.\",\"id\":28317261,\"released\":\"2025-03-28 14:07:22\",\"categories\":[\"Business\",\"Business Operations\",\"Conversational Forms\",\"Feedback\",\"Survey\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/pizza-survey-form-2\\/\",\"icon\":false,\"key\":\"pizza-survey-form-2\",\"used_addons\":[\"Conversational Forms\"],\"is_new\":true},\"20906062\":{\"name\":\"Gym Registration Form Template\",\"slug\":\"gym-registration-form\",\"description\":\"Get clients signed up and registered for a gym membership.\",\"id\":20906062,\"released\":\"2019-11-24 23:00:45\",\"categories\":[\"Basic\",\"Health and Wellness\",\"Registration and Signup\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/gym-registration-form\\/\",\"icon\":false,\"key\":\"gym-registration\",\"used_addons\":[],\"is_new\":false},\"28236110\":{\"name\":\"Price Quote Calculator Template\",\"slug\":\"price-quote-calculator-form\",\"description\":\"Gather necessary data from clients to calculate and provide accurate price quotes for your services.\",\"id\":28236110,\"released\":\"2023-11-02 15:13:02\",\"categories\":[\"Business\",\"Calculator\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/price-quote-calculator-form\\/\",\"icon\":false,\"key\":\"price-quote-calculator\",\"used_addons\":[],\"is_new\":false},\"20906063\":{\"name\":\"Vendor Contact Information Form Template\",\"slug\":\"vendor-contact-information-form\",\"description\":\"Track the vendors that you are working with and get their contact information.\",\"id\":20906063,\"released\":\"2019-11-24 23:00:17\",\"categories\":[\"Basic\",\"Contact\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/vendor-contact-information-form\\/\",\"icon\":false,\"key\":\"vendor-contact-information\",\"used_addons\":[],\"is_new\":false},\"28057167\":{\"name\":\"Online Race Registration Form Template\",\"slug\":\"online-race-registration-form\",\"description\":\"Save time with this simple and easy online race registration form.\",\"id\":28057167,\"released\":\"2021-08-14 16:27:54\",\"categories\":[\"Basic\",\"Event Planning\",\"Registration and Signup\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/online-race-registration-form\\/\",\"icon\":false,\"key\":\"online-race-registration\",\"used_addons\":[],\"is_new\":false},\"28031311\":{\"name\":\"Esthetician Consent Form Template\",\"slug\":\"esthetician-consent-form\",\"description\":\"Capture information about your client\'s needs and preferences in terms of cosmetic or skin treatment with this simple esthetician consent form.\",\"id\":28031311,\"released\":\"2020-11-28 00:01:55\",\"categories\":[\"Business\",\"Business Operations\",\"Customer Service\",\"Signature\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/esthetician-consent-form\\/\",\"icon\":false,\"key\":\"esthetician-consent\",\"used_addons\":[],\"is_new\":false},\"28036175\":{\"name\":\"Support Ticket Form Template\",\"slug\":\"support-ticket-form\",\"description\":\"Looking for a support ticket form template? This form helps you manage customer support requests with ease! Users submit requests & create tickets all at once.\",\"id\":28036175,\"released\":\"2020-12-18 12:56:44\",\"categories\":[\"Customer Service\",\"free\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/support-ticket-form\\/\",\"icon\":false,\"key\":\"support-ticket\",\"used_addons\":[],\"is_new\":false},\"28222545\":{\"name\":\"Audit Form Template\",\"slug\":\"audit-form\",\"description\":\"Collect valuable insights through our Audit Form to enhance your processes and drive improvements.\",\"id\":28222545,\"released\":\"2023-11-07 16:07:26\",\"categories\":[\"Business\",\"Feedback\",\"Signature\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/audit-form\\/\",\"icon\":false,\"key\":\"audit\",\"used_addons\":[],\"is_new\":false},\"28036177\":{\"name\":\"Neighborhood Events Questionnaire Form Template\",\"slug\":\"neighborhood-events-questionnaire-form\",\"description\":\"Want to survey your neighbors to find out what events they are interested in? Do it the easy way - with this neighborhood events questionnaire!\",\"id\":28036177,\"released\":\"2020-12-18 12:55:07\",\"categories\":[\"Event Planning\",\"free\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/neighborhood-events-questionnaire-form\\/\",\"icon\":false,\"key\":\"neighborhood-events-questionnaire\",\"used_addons\":[],\"is_new\":false},\"28317267\":{\"name\":\"Solar Battery Bank Calculator Template\",\"slug\":\"solar-battery-bank-calculator-form\",\"description\":\"Efficiently estimate the optimal battery bank size for your solar system based on energy usage and battery specifications.\",\"id\":28317267,\"released\":\"2025-03-28 15:30:11\",\"categories\":[\"Business\",\"Calculator\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/solar-battery-bank-calculator-form\\/\",\"icon\":false,\"key\":\"solar-battery-bank-calculator\",\"used_addons\":[],\"is_new\":true},\"28057939\":{\"name\":\"Avon Order Form Template\",\"slug\":\"avon-order-form\",\"description\":\"This Avon order form is great if you are looking to sell makeup online!\",\"id\":28057939,\"released\":\"2021-08-17 16:34:06\",\"categories\":[\"Business\",\"Business Operations\",\"Order Form\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/avon-order-form\\/\",\"icon\":false,\"key\":\"avon-order\",\"used_addons\":[],\"is_new\":false},\"28145235\":{\"name\":\"Check Request Form Template\",\"slug\":\"check-request-form\",\"description\":\"Level up business operations with the check request form! Request a check to pay bills or make purchases from your business accounts.\",\"id\":28145235,\"released\":\"2022-11-06 22:00:00\",\"categories\":[\"Business\",\"Business Operations\",\"Calculator\",\"Order Form\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/check-request-form\\/\",\"icon\":false,\"key\":\"check-request\",\"used_addons\":[],\"is_new\":false},\"20906069\":{\"name\":\"Vendor Registration Form Template\",\"slug\":\"vendor-registration-form\",\"description\":\"Gather information about new vendors that you are expecting for an event.\",\"id\":20906069,\"released\":\"2019-11-24 23:00:32\",\"categories\":[\"Basic\",\"Registration and Signup\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/vendor-registration-form\\/\",\"icon\":false,\"key\":\"vendor-registration\",\"used_addons\":[],\"is_new\":false},\"28029525\":{\"name\":\"Employment Verification Form Template\",\"slug\":\"employment-verification-form\",\"description\":\"An employment verification form allows individuals to easily apply for housing or mortgage applications by confirming their income or salary.\",\"id\":28029525,\"released\":\"2020-11-23 00:01:07\",\"categories\":[\"Application\",\"Basic\",\"Business Operations\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/employment-verification-form\\/\",\"icon\":false,\"key\":\"employment-verification\",\"used_addons\":[],\"is_new\":false},\"28236885\":{\"name\":\"Persuasive Essay Outline Form Template\",\"slug\":\"persuasive-essay-outline-form\",\"description\":\"Collect essential details to help students and writers outline persuasive essays effectively.\",\"id\":28236885,\"released\":\"2023-11-11 02:24:00\",\"categories\":[\"Basic\",\"Education\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/persuasive-essay-outline-form\\/\",\"icon\":false,\"key\":\"persuasive-essay-outline\",\"used_addons\":[],\"is_new\":false},\"28031318\":{\"name\":\"Donation Request Form Template\",\"slug\":\"donation-request-form\",\"description\":\"Request donations for your event with this form.\",\"id\":28031318,\"released\":\"2020-12-01 00:01:44\",\"categories\":[\"Event Planning\",\"Nonprofit\",\"Personal\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/donation-request-form\\/\",\"icon\":false,\"key\":\"donation-request\",\"used_addons\":[],\"is_new\":false},\"28108886\":{\"name\":\"Suggestion Box Form Template\",\"slug\":\"suggestion-box-form\",\"description\":\"A form template that allows an online suggestion box for customers.\",\"id\":28108886,\"released\":\"2022-03-01 14:01:16\",\"categories\":[\"Business\",\"Customer Service\",\"Feedback\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/suggestion-box-form\\/\",\"icon\":false,\"key\":\"suggestion-box\",\"used_addons\":[],\"is_new\":false},\"28317271\":{\"name\":\"Solar Load Calculator Template\",\"slug\":\"solar-load-calculator-form\",\"description\":\"Calculate the total energy consumption of your home or business to determine the required solar panel capacity for optimal performance.\",\"id\":28317271,\"released\":\"2025-03-28 15:38:05\",\"categories\":[\"Business\",\"Calculator\",\"Repeater Field\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/solar-load-calculator-form\\/\",\"icon\":false,\"key\":\"solar-load-calculator\",\"used_addons\":[],\"is_new\":true},\"28029527\":{\"name\":\"Release of Liability Form Template\",\"slug\":\"release-of-liability-form\",\"description\":\"Protect the individual, group, or organization from being held legally responsible in the event of an incident.\",\"id\":28029527,\"released\":\"2020-11-23 00:01:46\",\"categories\":[\"Business Operations\",\"Personal\",\"Signature\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/release-of-liability-form\\/\",\"icon\":false,\"key\":\"release-of-liability\",\"used_addons\":[\"Digital Signatures\"],\"is_new\":false},\"28145240\":{\"name\":\"Request Form Template\",\"slug\":\"request-form\",\"description\":\"Get more information from your customers and manage your requests with ease with the request form template!\",\"id\":28145240,\"released\":\"2022-11-06 22:00:00\",\"categories\":[\"Basic\",\"Customer Service\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/request-form\\/\",\"icon\":false,\"key\":\"request\",\"used_addons\":[],\"is_new\":false},\"28222552\":{\"name\":\"Receipt Form Template\",\"slug\":\"receipt-form\",\"description\":\"Capture payment details with our Receipt Form, ensuring accurate records of your financial transactions.\",\"id\":28222552,\"released\":\"2023-11-07 15:44:16\",\"categories\":[\"Basic\",\"Finance\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/receipt-form\\/\",\"icon\":false,\"key\":\"receipt\",\"used_addons\":[],\"is_new\":false},\"28225368\":{\"name\":\"Sponsor My Uniform\",\"slug\":\"sponsor-my-uniform-form\",\"description\":\"The Sponsor My Uniform Form Template by Formidable Forms allows organizations to easily collect sponsorship details.\",\"id\":28225368,\"released\":\"2023-11-18 10:27:00\",\"categories\":[\"Basic\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/sponsor-my-uniform-form\\/\",\"icon\":false,\"key\":\"sponsor-my-uniform\",\"used_addons\":[],\"is_new\":false},\"28036184\":{\"name\":\"Personal Trainer Sign-Up Form Template\",\"slug\":\"personal-trainer-sign-up-form\",\"description\":\"Looking for a personal trainer sign-up form template? Make it easy for customers to get started with this personal training registration form.\",\"id\":28036184,\"released\":\"2020-12-18 13:00:00\",\"categories\":[\"Basic\",\"Health and Wellness\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/personal-trainer-sign-up-form\\/\",\"icon\":false,\"key\":\"personal-trainer-sign-up\",\"used_addons\":[],\"is_new\":false},\"28275545\":{\"name\":\"Rule of 72 Calculator Template\",\"slug\":\"rule-of-72-calculator-form\",\"description\":\"Estimate the time it takes for an investment to double or calculate the required interest rate for doubling it.\",\"id\":28275545,\"released\":\"2024-04-23 12:47:37\",\"categories\":[\"Business\",\"Calculator\",\"Finance\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/rule-of-72-calculator-form\\/\",\"icon\":false,\"key\":\"rule-of-72-calculator\",\"used_addons\":[],\"is_new\":false},\"28235865\":{\"name\":\"Personal Financial Statement Form Template\",\"slug\":\"personal-financial-statement-form\",\"description\":\"Collect crucial financial information from individuals to create a comprehensive personal financial statement.\",\"id\":28235865,\"released\":\"2023-11-11 05:08:00\",\"categories\":[\"Business\",\"Business Operations\",\"Finance\",\"Signature\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/personal-financial-statement-form\\/\",\"icon\":false,\"key\":\"personal-financial-statement\",\"used_addons\":[],\"is_new\":false},\"22152282\":{\"name\":\"Customer Service Survey Template\",\"slug\":\"customer-service-survey-form\",\"description\":\"Transform your business with insightful customer service surveys.\",\"id\":22152282,\"released\":\"2020-05-18 13:31:13\",\"categories\":[\"Business\",\"Survey\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/customer-service-survey-form\\/\",\"icon\":[\"https:\\/\\/formidableforms.com\\/wp-content\\/uploads\\/2020\\/05\\/customer-service-survey-form-template.jpg\",650,288,false],\"key\":\"customer-service-survey\",\"used_addons\":[],\"is_new\":false},\"28145242\":{\"name\":\"Evaluation Form Template\",\"slug\":\"evaluation-form\",\"description\":\"Obtain valuable feedback on the quality of the presentation and identify areas that need improvement.\",\"id\":28145242,\"released\":\"2022-11-06 22:00:00\",\"categories\":[\"Business\",\"Business Operations\",\"Feedback\",\"Signature\",\"Survey\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/evaluation-form\\/\",\"icon\":false,\"key\":\"evaluation\",\"used_addons\":[],\"is_new\":false},\"28029530\":{\"name\":\"Training Acknowledgement Form Template\",\"slug\":\"training-acknowledgement-form\",\"description\":\"Get proof that an individual has attended and completed a training program.\",\"id\":28029530,\"released\":\"2020-11-23 00:01:23\",\"categories\":[\"Business\",\"Business Operations\",\"Signature\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/training-acknowledgement-form\\/\",\"icon\":false,\"key\":\"training-acknowledgement\",\"used_addons\":[\"Digital Signatures\"],\"is_new\":false},\"28031322\":{\"name\":\"Raffle Donation Form Template\",\"slug\":\"raffle-donation-form\",\"description\":\"Collect and track donated items for a raffle or auction in this easy online form.\",\"id\":28031322,\"released\":\"2020-12-01 00:01:48\",\"categories\":[\"Nonprofit\",\"Personal\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/raffle-donation-form\\/\",\"icon\":false,\"key\":\"raffle-donation\",\"used_addons\":[],\"is_new\":false},\"20882523\":{\"name\":\"Net Promoter Score (NPS) Survey Form Template\",\"slug\":\"nps-survey-form\",\"description\":\"Collect valuable feedback to increase customer satisfaction.\",\"id\":20882523,\"released\":\"2019-03-26 15:01:03\",\"categories\":[\"Business\",\"Calculator\",\"Survey\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/nps-survey-form\\/\",\"icon\":[\"https:\\/\\/formidableforms.com\\/wp-content\\/uploads\\/2019\\/03\\/net-promoter-score-nps-survey.jpg\",650,288,false],\"key\":\"nps-survey\",\"used_addons\":[],\"is_new\":false},\"28221020\":{\"name\":\"How Did You Hear About Us Survey Template\",\"slug\":\"how-did-you-hear-about-us-survey-form\",\"description\":\"Collect feedback on how your customers discovered you. Use the information to target your advertising and grow your business.\",\"id\":28221020,\"released\":\"2023-08-31 12:28:50\",\"categories\":[\"Business\",\"Feedback\",\"Survey\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/how-did-you-hear-about-us-survey-form\\/\",\"icon\":false,\"key\":\"how-did-you-hear-about-us-survey\",\"used_addons\":[],\"is_new\":false},\"28031324\":{\"name\":\"Sponsor Donation Form Template\",\"slug\":\"sponsor-donation-form\",\"description\":\"Use this online form to handle your event sponsorship and donation applications.\",\"id\":28031324,\"released\":\"2020-12-01 00:01:19\",\"categories\":[\"Application\",\"Business Operations\",\"File Upload\",\"Nonprofit\",\"Personal\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/sponsor-donation-form\\/\",\"icon\":false,\"key\":\"sponsor-donation\",\"used_addons\":[],\"is_new\":false},\"28145245\":{\"name\":\"Lab Supply Order Form Template\",\"slug\":\"lab-supply-order-form\",\"description\":\"Select laboratory products and process orders online with the Lab supply order form.\",\"id\":28145245,\"released\":\"2022-11-06 00:00:00\",\"categories\":[\"Business\",\"Health and Wellness\",\"Order Form\",\"PayPal\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/lab-supply-order-form\\/\",\"icon\":false,\"key\":\"lab-supply-order\",\"used_addons\":[],\"is_new\":false},\"28236382\":{\"name\":\"Recruiting Intake Form Template\",\"slug\":\"recruiting-intake-form\",\"description\":\"Obtain essential data from businesses seeking the expertise of your recruiting firm to identify and connect with top-tier talent.\",\"id\":28236382,\"released\":\"2023-11-11 05:06:00\",\"categories\":[\"Basic\",\"Business Operations\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/recruiting-intake-form\\/\",\"icon\":false,\"key\":\"recruiting-intake\",\"used_addons\":[],\"is_new\":false},\"28306270\":{\"name\":\"Request For Medical Records Template\",\"slug\":\"request-for-medical-records-form\",\"description\":\"Our Request for Medical Records Form allows individuals to obtain their health information efficiently.\",\"id\":28306270,\"released\":\"2024-12-16 11:51:31\",\"categories\":[\"Business\",\"Business Operations\",\"Consent\",\"Datepicker\",\"Health and Wellness\",\"Personal\",\"Request\",\"Signature\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/request-for-medical-records-form\\/\",\"icon\":false,\"key\":\"request-for-medical-records\",\"used_addons\":[\"Digital Signatures\"],\"is_new\":false},\"28238943\":{\"name\":\"Board and Batten Wall Calculator Template\",\"slug\":\"board-and-batten-wall-calculator-form\",\"description\":\"Gather project-specific details from users to calculate board and batten wall requirements.\",\"id\":28238943,\"released\":\"2023-11-15 14:05:03\",\"categories\":[\"Business\",\"Calculator\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/board-and-batten-wall-calculator-form\\/\",\"icon\":false,\"key\":\"board-and-batten-wall-calculator\",\"used_addons\":[],\"is_new\":false},\"28056672\":{\"name\":\"General Event Feedback Template\",\"slug\":\"general-event-feedback-form\",\"description\":\"Collect valuable event feedback from your event attendees.\",\"id\":28056672,\"released\":\"2021-04-27 17:27:18\",\"categories\":[\"Business\",\"Event Planning\",\"Feedback\",\"Survey\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/general-event-feedback-form\\/\",\"icon\":false,\"key\":\"general-event-feedback\",\"used_addons\":[\"Surveys and Polls\"],\"is_new\":false},\"28226400\":{\"name\":\"Job Requisition Form Template\",\"slug\":\"job-requisition-form\",\"description\":\"Collect necessary information from hiring managers to initiate and streamline the process of requesting new personnel to fill job vacancies.\",\"id\":28226400,\"released\":\"2023-11-18 10:36:01\",\"categories\":[\"Basic\",\"Business Operations\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/job-requisition-form\\/\",\"icon\":false,\"key\":\"job-requisition\",\"used_addons\":[],\"is_new\":false},\"28311905\":{\"name\":\"Corrective Action Form Template\",\"slug\":\"corrective-action-form\",\"description\":\"Document and address workplace issues efficiently, ensuring clear communication and compliance.\",\"id\":28311905,\"released\":\"2025-02-11 14:14:39\",\"categories\":[\"Business\",\"Business Operations\",\"Signature\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/corrective-action-form\\/\",\"icon\":false,\"key\":\"corrective-action\",\"used_addons\":[\"Digital Signatures\"],\"is_new\":false},\"28225378\":{\"name\":\"Meeting Availability Poll Template\",\"slug\":\"meeting-availability-poll-form\",\"description\":\"Gather availability information from participants to schedule meetings, ensuring efficient coordination for productive discussions.\",\"id\":28225378,\"released\":\"2023-11-18 10:28:42\",\"categories\":[\"Business Operations\",\"free\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/meeting-availability-poll-form\\/\",\"icon\":false,\"key\":\"meeting-availability-poll\",\"used_addons\":[],\"is_new\":false},\"28145251\":{\"name\":\"Media Release Form Template\",\"slug\":\"media-release-form\",\"description\":\"Grant consent or authorization to share media in various outlets and business marketing.\",\"id\":28145251,\"released\":\"2022-11-06 22:00:00\",\"categories\":[\"Business\",\"Business Operations\",\"Marketing\",\"Signature\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/media-release-form\\/\",\"icon\":false,\"key\":\"media-release\",\"used_addons\":[\"Digital Signatures\"],\"is_new\":false},\"28275556\":{\"name\":\"Sales Tax Calculator Template\",\"slug\":\"sales-tax-calculator-form\",\"description\":\"Calculate your sales tax rate, pre-tax price, and after-tax price with ease using our comprehensive sales tax calculator.\",\"id\":28275556,\"released\":\"2024-04-23 13:54:53\",\"categories\":[\"Business\",\"Calculator\",\"Finance\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/sales-tax-calculator-form\\/\",\"icon\":false,\"key\":\"sales-tax-calculator\",\"used_addons\":[],\"is_new\":false},\"28223335\":{\"name\":\"Notary Form Template\",\"slug\":\"notary-form\",\"description\":\"Collect essential details from individuals seeking notary services to assist in processing their requests efficiently.\",\"id\":28223335,\"released\":\"2023-11-07 15:33:51\",\"categories\":[\"Business\",\"Signature\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/notary-form\\/\",\"icon\":false,\"key\":\"notary\",\"used_addons\":[],\"is_new\":false},\"28305256\":{\"name\":\"Disciplinary Action Form Template\",\"slug\":\"disciplinary-action-form\",\"description\":\"Streamline disciplinary incident processing across educational, governmental, and corporate settings with a versatile Disciplinary Action Form Template, designed for immediate use and efficient documentation.\",\"id\":28305256,\"released\":\"2024-12-05 18:49:17\",\"categories\":[\"Business\",\"Business Operations\",\"Consent\",\"Datepicker\",\"Feedback\",\"File Upload\",\"Multi-Page\",\"Signature\",\"Survey\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/disciplinary-action-form\\/\",\"icon\":false,\"key\":\"disciplinary-action\",\"used_addons\":[\"Datepicker Options\",\"Digital Signatures\"],\"is_new\":false},\"28222569\":{\"name\":\"Jail Release Form Template\",\"slug\":\"jail-release-form\",\"description\":\"Collect essential details for inmate release processing.\",\"id\":28222569,\"released\":\"2023-09-07 13:01:48\",\"categories\":[\"Basic\",\"Business Operations\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/jail-release-form\\/\",\"icon\":false,\"key\":\"jail-release\",\"used_addons\":[],\"is_new\":false},\"28226665\":{\"name\":\"Warranty Form Template\",\"slug\":\"warranty-form\",\"description\":\"Gather information from customers seeking to register and activate their product warranties, ensuring a smooth process for future support and claims.\",\"id\":28226665,\"released\":\"2023-11-18 10:37:36\",\"categories\":[\"Basic\",\"Customer Service\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/warranty-form\\/\",\"icon\":false,\"key\":\"warranty\",\"used_addons\":[],\"is_new\":false},\"28221036\":{\"name\":\"Prior Authorization Form Template\",\"slug\":\"prior-authorization-form\",\"description\":\"Effortlessly gather authorization requests with our streamlined template.\",\"id\":28221036,\"released\":\"2023-11-11 02:29:00\",\"categories\":[\"Basic\",\"Contact\",\"Finance\",\"Health and Wellness\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/prior-authorization-form\\/\",\"icon\":false,\"key\":\"prior-authorization\",\"used_addons\":[],\"is_new\":false},\"28235887\":{\"name\":\"Area Calculator Template\",\"slug\":\"area-calculator-form\",\"description\":\"Find the area of a square, rectangle, circle, or a triangle with a 90\\u00b0 angle using our Area Calculator Template.\",\"id\":28235887,\"released\":\"2023-11-03 16:56:38\",\"categories\":[\"Business\",\"Calculator\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/area-calculator-form\\/\",\"icon\":false,\"key\":\"area-calculator\",\"used_addons\":[],\"is_new\":false},\"28306287\":{\"name\":\"Grievance Form Template\",\"slug\":\"grievance-form\",\"description\":\"A Grievance Form allows individuals to formally express concerns or complaints. This form provides a clear process for documentation and resolution, ensuring that issues are addressed fairly and promptly.\",\"id\":28306287,\"released\":\"2024-12-16 15:24:31\",\"categories\":[\"Business\",\"Business Operations\",\"Datepicker\",\"File Upload\",\"Multi-Page\",\"Repeater Field\",\"Request\",\"Signature\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/grievance-form\\/\",\"icon\":false,\"key\":\"grievance\",\"used_addons\":[\"Datepicker Options\",\"Digital Signatures\"],\"is_new\":false},\"28142704\":{\"name\":\"Bid Form Template\",\"slug\":\"bid-form\",\"description\":\"Save time by allowing contractors to submit their project proposals with the Bid form template.\",\"id\":28142704,\"released\":\"2022-08-17 14:27:39\",\"categories\":[\"Business\",\"Business Operations\",\"Signature\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/bid-form\\/\",\"icon\":false,\"key\":\"bid\",\"used_addons\":[],\"is_new\":false},\"28223600\":{\"name\":\"Monthly Payment Form\",\"slug\":\"monthly-payment-form\",\"description\":\"Are you hunting for a low-stress method to sort out online monthly payments? We\'ve got your back! Check out the monthly payment form template from Formidable Forms. The beauty of this thing? It hands the power over to the customers or donors to choose a monthly payment amount.\",\"id\":28223600,\"released\":\"2023-09-12 12:46:47\",\"categories\":[\"free\",\"Payment\",\"Stripe\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/monthly-payment-form\\/\",\"icon\":false,\"key\":\"monthly-payment\",\"used_addons\":[],\"is_new\":false},\"28224368\":{\"name\":\"Interest Form Template\",\"slug\":\"interest-form\",\"description\":\"Gather information from individuals interested in your offerings or activities, helping you better understand their preferences and needs.\",\"id\":28224368,\"released\":\"2023-11-18 04:03:00\",\"categories\":[\"free\",\"Survey\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/interest-form\\/\",\"icon\":false,\"key\":\"interest\",\"used_addons\":[],\"is_new\":false},\"28305264\":{\"name\":\"Fundraising Donation Form Template\",\"slug\":\"fundraising-donation-form\",\"description\":\"A Fundraising Donation Form collects contributions for charitable causes, allowing donors to provide essential support to meaningful projects.\",\"id\":28305264,\"released\":\"2024-12-05 19:30:27\",\"categories\":[\"Business\",\"Business Operations\",\"Calculator\",\"Elite\",\"Event Planning\",\"Finance\",\"Multi-Page\",\"Nonprofit\",\"Payment\",\"PayPal\",\"Request\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/fundraising-donation-form\\/\",\"icon\":false,\"key\":\"fundraising-donation\",\"used_addons\":[\"PayPal Standard\",\"Stripe\"],\"is_new\":false},\"28223857\":{\"name\":\"Boyfriend Application Form Template\",\"slug\":\"boyfriend-application-form\",\"description\":\"Collect information from prospective partners interested in building a relationship with you.\",\"id\":28223857,\"released\":\"2023-09-13 12:01:55\",\"categories\":[\"Basic\",\"Personal\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/boyfriend-application-form\\/\",\"icon\":false,\"key\":\"boyfriend-application\",\"used_addons\":[],\"is_new\":false},\"28172146\":{\"name\":\"FAQ Form Template\",\"slug\":\"faq-form\",\"description\":\"Find information quickly and easily provide answers to the most frequently asked questions.\",\"id\":28172146,\"released\":\"2023-02-07 16:18:43\",\"categories\":[\"Business\",\"Conversational Forms\",\"Customer Service\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/faq-form\\/\",\"icon\":false,\"key\":\"faq\",\"used_addons\":[],\"is_new\":false},\"28305266\":{\"name\":\"Employee Leave Request Form Template\",\"slug\":\"employee-leave-request-form\",\"description\":\"An Employee Leave Request Form allows employees to formally request time off, ensuring proper communication and documentation to maintain organizational productivity.\",\"id\":28305266,\"released\":\"2024-12-05 19:40:00\",\"categories\":[\"Application\",\"Business\",\"Business Operations\",\"Consent\",\"Datepicker\",\"Elite\",\"Request\",\"Signature\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/employee-leave-request-form\\/\",\"icon\":false,\"key\":\"employee-leave-request\",\"used_addons\":[\"Datepicker Options\",\"Digital Signatures\"],\"is_new\":false},\"28029811\":{\"name\":\"Donation Pledge Form Template\",\"slug\":\"donation-pledge-form\",\"description\":\"Don\'t be stuck on how to take pledges from donors. This template will keep everything organized.\",\"id\":28029811,\"released\":\"2020-12-01 00:01:27\",\"categories\":[\"Business\",\"Nonprofit\",\"Signature\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/donation-pledge-form\\/\",\"icon\":false,\"key\":\"donation-pledge\",\"used_addons\":[],\"is_new\":false},\"28313460\":{\"name\":\"Uninsured Contractor Waiver Form Template\",\"slug\":\"uninsured-contractor-waiver-form\",\"description\":\"Release the hiring party from liability, with the contractor acknowledging responsibility for any risks or damages incurred during their work.\",\"id\":28313460,\"released\":\"2025-02-24 16:14:21\",\"categories\":[\"Business\",\"Business Operations\",\"Contact\",\"File Upload\",\"Repeater Field\",\"Signature\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/uninsured-contractor-waiver-form\\/\",\"icon\":false,\"key\":\"uninsured-contractor-waiver\",\"used_addons\":[\"Digital Signatures\"],\"is_new\":false},\"28305268\":{\"name\":\"Office Supply Order Form Template\",\"slug\":\"office-supply-order-form\",\"description\":\"An Office Supply Order Form streamlines the process of requesting essential supplies for your workplace. This form ensures timely fulfillment and helps maintain an efficient and productive office environment.\",\"id\":28305268,\"released\":\"2024-12-05 19:52:47\",\"categories\":[\"Business\",\"Business Operations\",\"Datepicker\",\"Elite\",\"Finance\",\"Multi-Page\",\"Order Form\",\"Personal\",\"Repeater Field\",\"Request\",\"Signature\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/office-supply-order-form\\/\",\"icon\":false,\"key\":\"office-supply-order\",\"used_addons\":[\"Datepicker Options\",\"Digital Signatures\"],\"is_new\":false},\"28221301\":{\"name\":\"Personnel Action Form Template\",\"slug\":\"personnel-action-form\",\"description\":\"Gather essential information from employees seeking personnel actions. Ensure accurate and efficient processing of requests.\",\"id\":28221301,\"released\":\"2023-11-11 02:18:00\",\"categories\":[\"Business Operations\",\"free\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/personnel-action-form\\/\",\"icon\":false,\"key\":\"personnel-action\",\"used_addons\":[],\"is_new\":false},\"28223861\":{\"name\":\"Credit Card Application Form Template\",\"slug\":\"credit-card-application-form\",\"description\":\"Collect essential details from individuals applying for a credit card to help you assess their eligibility and offer your financial services.\",\"id\":28223861,\"released\":\"2023-09-15 13:53:14\",\"categories\":[\"Application\",\"Business\",\"Signature\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/credit-card-application-form\\/\",\"icon\":false,\"key\":\"credit-card-application\",\"used_addons\":[],\"is_new\":false},\"28228469\":{\"name\":\"Blog Post Pitch Form Template\",\"slug\":\"blog-post-pitch-form\",\"description\":\"Gather article pitch submissions from potential contributors who wish to share their ideas and expertise on your blog.\",\"id\":28228469,\"released\":\"2023-10-04 13:15:02\",\"categories\":[\"Basic\",\"Multi-Page\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/blog-post-pitch-form\\/\",\"icon\":false,\"key\":\"blog-post-pitch\",\"used_addons\":[],\"is_new\":false},\"28179829\":{\"name\":\"Parental Contact Form Template\",\"slug\":\"parental-contact-form\",\"description\":\"Using our short and easy parental contact form template can save you time and ensure that you have all the necessary information in one place. Our template is designed to be straightforward and user-friendly, allowing parents and guardians to provide the essential information needed to care for their child without any confusion or hassle.\",\"id\":28179829,\"released\":\"2023-02-21 12:47:16\",\"categories\":[\"Basic\",\"Contact\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/parental-contact-form\\/\",\"icon\":false,\"key\":\"parental-contact\",\"used_addons\":[],\"is_new\":false},\"28222582\":{\"name\":\"Interview Form Template\",\"slug\":\"interview-form\",\"description\":\"Gather valuable insights from candidates during the interview process to assess their qualifications and determine whether or not they are fit for the position.\",\"id\":28222582,\"released\":\"2023-09-07 13:23:01\",\"categories\":[\"Business\",\"Business Operations\",\"Signature\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/interview-form\\/\",\"icon\":false,\"key\":\"interview\",\"used_addons\":[\"Digital Signatures\"],\"is_new\":false},\"28194423\":{\"name\":\"AI Pre-Sale Assistant Form Template\",\"slug\":\"ai-pre-sale-assistant-form\",\"description\":\"Streamline your pre-sale experience with our AI-powered assistant. Simply ask a question and you will receive an answer.\",\"id\":28194423,\"released\":\"2023-04-28 16:11:47\",\"categories\":[\"AI\",\"Business\",\"Customer Service\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/ai-pre-sale-assistant-form\\/\",\"icon\":false,\"key\":\"ai-pre-sale-assistant\",\"used_addons\":[],\"is_new\":false},\"28172151\":{\"name\":\"Personal Information Form Template\",\"slug\":\"personal-information-form\",\"description\":\"Whether it is for completing documents or collecting information about a person, use the personal information form template for an easy way to gather personal data.\",\"id\":28172151,\"released\":\"2023-02-07 16:29:38\",\"categories\":[\"Business\",\"Conversational Forms\",\"Lead\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/personal-information-form\\/\",\"icon\":false,\"key\":\"personal-information\",\"used_addons\":[],\"is_new\":false},\"20908664\":{\"name\":\"Daily Calorie Intake Calculator Template\",\"slug\":\"daily-calorie-intake-calculator-form\",\"description\":\"Calculate the daily calorie intake required to reach fitness goals.\",\"id\":20908664,\"released\":\"2019-11-24 23:00:44\",\"categories\":[\"Business\",\"Calculator\",\"Health and Wellness\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/daily-calorie-intake-calculator-form\\/\",\"icon\":false,\"key\":\"daily-calorie-intake-calculator\",\"used_addons\":[],\"is_new\":false},\"28220792\":{\"name\":\"Lead Generation Form Template\",\"slug\":\"lead-generation-form\",\"description\":\"Generate new leads on your website using our lead generation form.\",\"id\":28220792,\"released\":\"2023-11-18 03:50:00\",\"categories\":[\"Basic\",\"Business Operations\",\"Conversational Forms\",\"Lead\",\"Marketing\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/lead-generation-form\\/\",\"icon\":false,\"key\":\"lead-generation\",\"used_addons\":[\"Conversational Forms\"],\"is_new\":false},\"28222328\":{\"name\":\"Sales Lead Form Template\",\"slug\":\"sales-lead-form\",\"description\":\"Connect with potential clients and gather their contact information to boost your sales.\",\"id\":28222328,\"released\":\"2023-11-11 04:01:00\",\"categories\":[\"Basic\",\"Contact\",\"Lead\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/sales-lead-form\\/\",\"icon\":false,\"key\":\"sales-lead\",\"used_addons\":[],\"is_new\":false},\"28224376\":{\"name\":\"Husband Complaint Form Template\",\"slug\":\"husband-complaint-form\",\"description\":\"Collect insights and chuckles from spouses sharing their grievances about their husbands.\",\"id\":28224376,\"released\":\"2023-11-18 04:05:00\",\"categories\":[\"Basic\",\"Feedback\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/husband-complaint-form\\/\",\"icon\":false,\"key\":\"husband-complaint\",\"used_addons\":[],\"is_new\":false},\"20908665\":{\"name\":\"Length Conversion Calculator Template\",\"slug\":\"length-conversion-calculator-form\",\"description\":\"Convert lengths across different units of measurement.\",\"id\":20908665,\"released\":\"2019-11-24 23:00:25\",\"categories\":[\"Business\",\"Calculator\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/length-conversion-calculator-form\\/\",\"icon\":false,\"key\":\"length-conversion-calculator\",\"used_addons\":[],\"is_new\":false},\"28192889\":{\"name\":\"Pay Raise Calculator Template\",\"slug\":\"pay-raise-calculator-form\",\"description\":\"Easily calculate what your salary will be after a pay raise.\",\"id\":28192889,\"released\":\"2023-04-20 17:40:33\",\"categories\":[\"Business\",\"Calculator\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/pay-raise-calculator-form\\/\",\"icon\":false,\"key\":\"pay-raise-calculator\",\"used_addons\":[],\"is_new\":false},\"28221049\":{\"name\":\"Release of Information Form Template\",\"slug\":\"release-of-information-form\",\"description\":\"Grant permission for the sharing of confidential details to assist in providing accurate service quotes.\",\"id\":28221049,\"released\":\"2023-11-11 02:21:00\",\"categories\":[\"Business\",\"Signature\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/release-of-information-form\\/\",\"icon\":false,\"key\":\"release-of-information\",\"used_addons\":[\"Digital Signatures\"],\"is_new\":false},\"28306297\":{\"name\":\"Inventory Form Template\",\"slug\":\"inventory-form\",\"description\":\"An Inventory form template streamlines the tracking of stock levels and items. This form helps maintain accurate records, optimize supply management, and ensure efficient operations in any organization.\",\"id\":28306297,\"released\":\"2024-12-17 14:06:17\",\"categories\":[\"Business\",\"Business Operations\",\"Calculator\",\"Datepicker\",\"Order Form\",\"Repeater Field\",\"Signature\",\"Survey\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/inventory-form\\/\",\"icon\":false,\"key\":\"inventory\",\"used_addons\":[\"Digital Signatures\"],\"is_new\":false},\"20908666\":{\"name\":\"Paycheck Calculator Form Template\",\"slug\":\"paycheck-calculator-form\",\"description\":\"Find your salary, daily, weekly and monthly wages based on hourly rates.\",\"id\":20908666,\"released\":\"2019-11-24 23:00:26\",\"categories\":[\"Business\",\"Calculator\",\"Finance\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/paycheck-calculator-form\\/\",\"icon\":false,\"key\":\"paycheck-calculator\",\"used_addons\":[],\"is_new\":false},\"28054906\":{\"name\":\"Square Root Calculator Template\",\"slug\":\"square-root-calculator-form\",\"description\":\"This calculator is great for solving square roots, which are notoriously difficult to calculate.\",\"id\":28054906,\"released\":\"2021-08-28 10:53:21\",\"categories\":[\"Business\",\"Calculator\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/square-root-calculator-form\\/\",\"icon\":false,\"key\":\"square-root-calculator\",\"used_addons\":[],\"is_new\":false},\"28220794\":{\"name\":\"Liability Form Template\",\"slug\":\"liability-form\",\"description\":\"Complete this form to acknowledge your understanding of potential risks and liabilities associated with our products or services\",\"id\":28220794,\"released\":\"2023-11-11 02:39:00\",\"categories\":[\"Business\",\"Business Operations\",\"Signature\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/liability-form\\/\",\"icon\":false,\"key\":\"liability\",\"used_addons\":[\"Digital Signatures\"],\"is_new\":false},\"20908667\":{\"name\":\"Percentage Calculator Template\",\"slug\":\"percentage-calculator-form\",\"description\":\"Find a specified percentage of an entered number.\",\"id\":20908667,\"released\":\"2019-11-24 23:00:25\",\"categories\":[\"Calculator\",\"Personal\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/percentage-calculator-form\\/\",\"icon\":false,\"key\":\"percentage-calculator\",\"used_addons\":[],\"is_new\":false},\"28316283\":{\"name\":\"Cleaning Services Form Template\",\"slug\":\"cleaning-services-form\",\"description\":\"Easily collect client details, service requests, and payments with this cleaning services form.\",\"id\":28316283,\"released\":\"2025-03-20 16:56:57\",\"categories\":[\"Business\",\"Business Operations\",\"Multi-Page\",\"Order Form\",\"Payment\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/cleaning-services-form\\/\",\"icon\":false,\"key\":\"cleaning-services\",\"used_addons\":[],\"is_new\":true},\"20908668\":{\"name\":\"Tip Calculator Form Template\",\"slug\":\"tip-calculator-form\",\"description\":\"Calculate a tip whether splitting the bill or paying alone.\",\"id\":20908668,\"released\":\"2019-11-24 23:00:34\",\"categories\":[\"Business\",\"Calculator\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/tip-calculator-form\\/\",\"icon\":false,\"key\":\"tip-calculator\",\"used_addons\":[],\"is_new\":false},\"28018812\":{\"name\":\"Photo Release Form Template\",\"slug\":\"photo-release-form\",\"description\":\"An easy to use template for releasing photos.\",\"id\":28018812,\"released\":\"2020-09-21 09:58:01\",\"categories\":[\"Business\",\"Business Operations\",\"Consent\",\"Signature\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/photo-release-form\\/\",\"icon\":false,\"key\":\"photo-release\",\"used_addons\":[\"Digital Signatures\"],\"is_new\":false},\"28219004\":{\"name\":\"Attachment Style Quiz Template\",\"slug\":\"attachment-style-quiz-form\",\"description\":\"Determine your attachment style with this short quiz.\",\"id\":28219004,\"released\":\"2023-09-08 16:47:21\",\"categories\":[\"Business\",\"Conversational Forms\",\"Personal\",\"Quiz\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/attachment-style-quiz-form\\/\",\"icon\":false,\"key\":\"attachment-style-quiz\",\"used_addons\":[],\"is_new\":false},\"28220796\":{\"name\":\"Purchase Request Form Template\",\"slug\":\"purchase-request-form\",\"description\":\"Submit a request for your purchase using this form.\",\"id\":28220796,\"released\":\"2023-11-18 03:41:00\",\"categories\":[\"Basic\",\"Finance\",\"Request\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/purchase-request-form\\/\",\"icon\":false,\"key\":\"purchase-request\",\"used_addons\":[],\"is_new\":false},\"28223869\":{\"name\":\"Demographic Information Form Template\",\"slug\":\"demographic-information-form\",\"description\":\"Gather important demographic data from individuals to better understand your customer base and enhance your services.\",\"id\":28223869,\"released\":\"2023-09-15 13:55:36\",\"categories\":[\"Basic\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/demographic-information-form\\/\",\"icon\":false,\"key\":\"demographic-information\",\"used_addons\":[],\"is_new\":false},\"28306302\":{\"name\":\"Employee Status Change Form Template\",\"slug\":\"employee-status-change-form\",\"description\":\"An Employee Status Change Form documents any modifications to an employee\'s role, status, or details. This form ensures accurate record-keeping and facilitates smooth transitions within the organization.\",\"id\":28306302,\"released\":\"2024-12-17 14:05:26\",\"categories\":[\"Application\",\"Business\",\"Business Operations\",\"File Upload\",\"Finance\",\"Request\",\"Signature\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/employee-status-change-form\\/\",\"icon\":false,\"key\":\"employee-status-change\",\"used_addons\":[\"Digital Signatures\"],\"is_new\":false},\"28200063\":{\"name\":\"Straw Poll Form Template\",\"slug\":\"straw-poll-form\",\"description\":\"This form is designed to collect your valuable input on various topics through a straw poll. By participating in this quick survey, you can share your preferences, opinions, or choices on specific questions.\",\"id\":28200063,\"released\":\"2023-05-30 17:53:42\",\"categories\":[\"Business\",\"Conversational Forms\",\"Feedback\",\"Poll\",\"Survey\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/straw-poll-form\\/\",\"icon\":false,\"key\":\"straw-poll\",\"used_addons\":[\"Surveys and Polls\"],\"is_new\":false},\"20905855\":{\"name\":\"Equipment Checkout Form Template\",\"slug\":\"equipment-checkout-form\",\"description\":\"Collect employee details and information about the equipment being checked out.\",\"id\":20905855,\"released\":\"2019-11-24 23:00:10\",\"categories\":[\"Basic\",\"Business Operations\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/equipment-checkout-form\\/\",\"icon\":false,\"key\":\"equipment-checkout\",\"used_addons\":[],\"is_new\":false},\"28220800\":{\"name\":\"Volunteer Hours Form Template\",\"slug\":\"volunteer-hours-form\",\"description\":\"Use this form to log your volunteer hours.\",\"id\":28220800,\"released\":\"2023-11-11 02:31:00\",\"categories\":[\"free\",\"Nonprofit\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/volunteer-hours-form\\/\",\"icon\":false,\"key\":\"volunteer-hours\",\"used_addons\":[],\"is_new\":false},\"20905857\":{\"name\":\"Online Event Registration Form Template\",\"slug\":\"online-event-registration-form\",\"description\":\"Allow users to register to attend a conference.\",\"id\":20905857,\"released\":\"2019-11-24 23:00:14\",\"categories\":[\"Basic\",\"Event Planning\",\"Registration and Signup\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/online-event-registration-form\\/\",\"icon\":false,\"key\":\"online-event-registration\",\"used_addons\":[],\"is_new\":false},\"28219010\":{\"name\":\"IT Service Request Form Template\",\"slug\":\"it-service-request-form\",\"description\":\"An easy way for employees to request assistance or changes related to their information technology (IT) needs.\",\"id\":28219010,\"released\":\"2023-09-08 16:53:35\",\"categories\":[\"Business\",\"Business Operations\",\"Contact\",\"File Upload\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/it-service-request-form\\/\",\"icon\":false,\"key\":\"it-service-request\",\"used_addons\":[],\"is_new\":false},\"28221314\":{\"name\":\"Student Enrollment Form Template\",\"slug\":\"student-enrollment-form\",\"description\":\"Collect essential information from prospective students and their families to facilitate enrollment in our educational programs.\",\"id\":28221314,\"released\":\"2023-11-07 16:15:57\",\"categories\":[\"Business\",\"Education\",\"Signature\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/student-enrollment-form\\/\",\"icon\":false,\"key\":\"student-enrollment\",\"used_addons\":[\"Digital Signatures\"],\"is_new\":false},\"28223874\":{\"name\":\"Buy Me a Coffee Form Template\",\"slug\":\"buy-me-a-coffee-form\",\"description\":\"Collect details from generous supporters who want to contribute and buy you a coffee to show their appreciation.\",\"id\":28223874,\"released\":\"2023-09-13 13:49:36\",\"categories\":[\"free\",\"Payment\",\"Stripe\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/buy-me-a-coffee-form\\/\",\"icon\":false,\"key\":\"buy-me-a-coffee\",\"used_addons\":[],\"is_new\":false},\"28222595\":{\"name\":\"Lab Requisition Form Template\",\"slug\":\"lab-requisition-form\",\"description\":\"Collect essential patient and test details for accurate and timely laboratory procedures.\",\"id\":28222595,\"released\":\"2023-11-11 08:00:00\",\"categories\":[\"Business\",\"Health and Wellness\",\"Signature\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/lab-requisition-form\\/\",\"icon\":false,\"key\":\"lab-requisition\",\"used_addons\":[],\"is_new\":false},\"28306308\":{\"name\":\"Income Verification Form Template\",\"slug\":\"income-verification-form-2\",\"description\":\"An Income Verification Form confirms an individual\'s earnings for various purposes, such as loans or rental applications. This form provides essential proof of income, ensuring transparency and trust in financial transactions.\",\"id\":28306308,\"released\":\"2024-12-16 15:18:16\",\"categories\":[\"Application\",\"Business\",\"Business Operations\",\"Datepicker\",\"Finance\",\"Request\",\"Signature\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/income-verification-form-2\\/\",\"icon\":false,\"key\":\"income-verification-form-2\",\"used_addons\":[\"Digital Signatures\"],\"is_new\":false},\"28269189\":{\"name\":\"Social Media Survey Template\",\"slug\":\"social-media-survey-form\",\"description\":\"Collect insights from participants with this social media survey template to understand user preferences and behaviors.\",\"id\":28269189,\"released\":\"2024-03-22 13:54:49\",\"categories\":[\"Basic\",\"Business Operations\",\"Marketing\",\"Survey\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/social-media-survey-form\\/\",\"icon\":false,\"key\":\"social-media-survey\",\"used_addons\":[],\"is_new\":false},\"28054406\":{\"name\":\"YouTube Money Calculator\",\"slug\":\"youtube-money-calculator-form\",\"description\":\"Use this <a href=\\\"https:\\/\\/formidableforms.com\\/how-to-generate-leads-with-a-calculator-lead-magnet\\/\\\">lead magnet<\\/a> to tell visitors how much money they can make via YouTube. This is the ad revenue calculator for you.\",\"id\":28054406,\"released\":\"2021-08-10 16:21:21\",\"categories\":[\"Business\",\"Calculator\",\"Finance\",\"Lead\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/youtube-money-calculator-form\\/\",\"icon\":false,\"key\":\"youtube-money-calculator\",\"used_addons\":[],\"is_new\":false},\"28221318\":{\"name\":\"Community Service Form Template\",\"slug\":\"community-service-form\",\"description\":\"Gather essential details from volunteers and participants who are actively engaged in community service initiatives.\",\"id\":28221318,\"released\":\"2023-09-01 13:57:17\",\"categories\":[\"free\",\"Nonprofit\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/community-service-form\\/\",\"icon\":false,\"key\":\"community-service\",\"used_addons\":[],\"is_new\":false},\"28224390\":{\"name\":\"Computer Inventory Form Template\",\"slug\":\"computer-inventory-form\",\"description\":\"Gather essential information about computer assets to maintain an organized and up-to-date inventory of your technology resources.\",\"id\":28224390,\"released\":\"2023-11-18 16:08:54\",\"categories\":[\"Basic\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/computer-inventory-form\\/\",\"icon\":false,\"key\":\"computer-inventory\",\"used_addons\":[],\"is_new\":false},\"28217735\":{\"name\":\"Recipe Request Form Template\",\"slug\":\"recipe-request-form\",\"description\":\"Easily add a form to your site to allow your visitors to request recipes.\",\"id\":28217735,\"released\":\"2023-08-17 12:14:20\",\"categories\":[\"Business\",\"Feedback\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/recipe-request-form\\/\",\"icon\":false,\"key\":\"recipe-request\",\"used_addons\":[],\"is_new\":false},\"28219016\":{\"name\":\"Dog Breed Selector Quiz Template\",\"slug\":\"dog-breed-selector-quiz-form\",\"description\":\"Determine the perfect dog breed for you with this short quiz.\",\"id\":28219016,\"released\":\"2023-11-11 03:45:50\",\"categories\":[\"Business\",\"Conversational Forms\",\"Lifestyle\",\"Quiz\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/dog-breed-selector-quiz-form\\/\",\"icon\":false,\"key\":\"dog-breed-selector-quiz\",\"used_addons\":[\"Conversational Forms\",\"Quiz Maker\"],\"is_new\":false},\"28223625\":{\"name\":\"Appeal Form Template\",\"slug\":\"appeal-form\",\"description\":\"Collect essential details from employees who are filing appeals.\",\"id\":28223625,\"released\":\"2023-11-07 15:30:48\",\"categories\":[\"Business\",\"Signature\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/appeal-form\\/\",\"icon\":false,\"key\":\"appeal\",\"used_addons\":[],\"is_new\":false},\"28223881\":{\"name\":\"Crowdfunding Form Template\",\"slug\":\"crowdfunding-form\",\"description\":\"Collect essential information from potential backers who are interested in supporting your crowdfunding campaign.\",\"id\":28223881,\"released\":\"2023-09-13 14:05:18\",\"categories\":[\"free\",\"Payment\",\"Stripe\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/crowdfunding-form\\/\",\"icon\":false,\"key\":\"crowdfunding\",\"used_addons\":[],\"is_new\":false},\"28029321\":{\"name\":\"Model Release Form Template\",\"slug\":\"model-release-form\",\"description\":\"Photographers can get permission from models to use and publish their photos.\",\"id\":28029321,\"released\":\"2020-11-23 00:02:19\",\"categories\":[\"Business\",\"Business Operations\",\"Signature\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/model-release-form\\/\",\"icon\":false,\"key\":\"model-release\",\"used_addons\":[\"Digital Signatures\"],\"is_new\":false},\"28306313\":{\"name\":\"Sponsorship Request Form Template\",\"slug\":\"sponsorship-request-form\",\"description\":\"A Sponsorship Request Form enables organizations to seek funding or support for events and initiatives. This form clearly outlines sponsorship benefits, helping to connect sponsors with meaningful opportunities.\",\"id\":28306313,\"released\":\"2024-12-16 15:25:45\",\"categories\":[\"Application\",\"Business\",\"Business Operations\",\"Datepicker\",\"Event Planning\",\"File Upload\",\"Finance\",\"Nonprofit\",\"PayPal\",\"Request\",\"Stripe\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/sponsorship-request-form\\/\",\"icon\":false,\"key\":\"sponsorship-request\",\"used_addons\":[\"PayPal Standard\",\"Stripe\"],\"is_new\":false},\"25188491\":{\"name\":\"Student Interest Survey Template\",\"slug\":\"student-interest-survey-form\",\"description\":\"Get feedback from your students using our Interest Survey Form.\",\"id\":25188491,\"released\":\"2020-06-10 22:05:36\",\"categories\":[\"Education\",\"Personal\",\"Survey\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/student-interest-survey-form\\/\",\"icon\":false,\"key\":\"student-interest-survey\",\"used_addons\":[],\"is_new\":false},\"28217739\":{\"name\":\"Exit Survey Form Template\",\"slug\":\"exit-survey-form\",\"description\":\"Our Exit Survey helps gather feedback and improve the well-being of employees.\",\"id\":28217739,\"released\":\"2023-08-17 12:45:01\",\"categories\":[\"Business\",\"Business Operations\",\"Feedback\",\"Multi-Page\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/exit-survey-form\\/\",\"icon\":false,\"key\":\"exit-survey\",\"used_addons\":[],\"is_new\":false},\"28315276\":{\"name\":\"Car Rental Application Form Template\",\"slug\":\"car-rental-application-form\",\"description\":\"Collect applicant details and rental preferences to streamline the car rental application process.\",\"id\":28315276,\"released\":\"2025-03-11 14:59:50\",\"categories\":[\"Application\",\"Basic\",\"Business Operations\",\"Multi-Page\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/car-rental-application-form\\/\",\"icon\":false,\"key\":\"car-rental-application\",\"used_addons\":[],\"is_new\":true},\"28195727\":{\"name\":\"BMI Calculator AI Form Template\",\"slug\":\"bmi-calculator-ai-form\",\"description\":\"This form allows users to input their height and weight to calculate their Body Mass Index (BMI) and receive personalized feedback from an AI coach based on their results. The coach provides insights on maintaining a healthy lifestyle and achieving weight-related goals.\",\"id\":28195727,\"released\":\"2023-05-05 19:26:23\",\"categories\":[\"AI\",\"Business\",\"Health and Wellness\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/bmi-calculator-ai-form\\/\",\"icon\":false,\"key\":\"bmi-calculator-ai\",\"used_addons\":[],\"is_new\":false},\"28226959\":{\"name\":\"Lunch Order Form Template\",\"slug\":\"lunch-order-form\",\"description\":\"Collect meal preferences and details from individuals placing lunch orders, ensuring a seamless and delicious dining experience.\",\"id\":28226959,\"released\":\"2023-11-18 10:41:14\",\"categories\":[\"Business\",\"Business Operations\",\"Order Form\",\"Payment\",\"Stripe\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/lunch-order-form\\/\",\"icon\":false,\"key\":\"lunch-order\",\"used_addons\":[\"Stripe\"],\"is_new\":false},\"28227216\":{\"name\":\"Minor Travel Consent Form Template\",\"slug\":\"minor-travel-consent-form\",\"description\":\"Gather necessary information from parents or legal guardians granting consent for a minor\'s travel.\",\"id\":28227216,\"released\":\"2023-11-18 10:47:18\",\"categories\":[\"Business\",\"Business Operations\",\"Signature\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/minor-travel-consent-form\\/\",\"icon\":false,\"key\":\"minor-travel-consent\",\"used_addons\":[],\"is_new\":false},\"28217745\":{\"name\":\"Online Pledge Form Template\",\"slug\":\"online-pledge-form\",\"description\":\"Use our online pledge form template to make a donation with very little effort.\",\"id\":28217745,\"released\":\"2023-08-17 13:13:16\",\"categories\":[\"Business\",\"Payment\",\"Signature\",\"Stripe\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/online-pledge-form\\/\",\"icon\":false,\"key\":\"online-pledge\",\"used_addons\":[\"Digital Signatures\",\"Stripe\"],\"is_new\":false},\"28228498\":{\"name\":\"Social Media Photo Release Form Template\",\"slug\":\"social-media-photo-release-form\",\"description\":\"Gather essential permissions and details from individuals granting consent for the use of their photos on social media platforms.\",\"id\":28228498,\"released\":\"2023-11-11 03:54:00\",\"categories\":[\"Basic\",\"Business Operations\",\"Consent\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/social-media-photo-release-form\\/\",\"icon\":false,\"key\":\"social-media-photo-release\",\"used_addons\":[],\"is_new\":false},\"28302738\":{\"name\":\"New Patient Registration Form Template\",\"slug\":\"new-patient-registration-form\",\"description\":\"Allow patients to efficiently provide the essential information needed for their healthcare experience.\",\"id\":28302738,\"released\":\"2024-11-18 11:04:11\",\"categories\":[\"Basic\",\"Business Operations\",\"Datepicker\",\"Health and Wellness\",\"Multi-Page\",\"Registration and Signup\",\"Repeater Field\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/new-patient-registration-form\\/\",\"icon\":false,\"key\":\"new-patient-registration\",\"used_addons\":[],\"is_new\":false},\"28104595\":{\"name\":\"Online Contact Us Form Template\",\"slug\":\"online-contact-us-form\",\"description\":\"Simple and easy way to get information from your customers.\",\"id\":28104595,\"released\":\"2022-03-07 14:07:46\",\"categories\":[\"Business\",\"Contact\",\"Customer Service\",\"Feedback\",\"Lead\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/online-contact-us-form\\/\",\"icon\":false,\"key\":\"online-contact-us\",\"used_addons\":[],\"is_new\":false},\"28219028\":{\"name\":\"Change Order Form Template\",\"slug\":\"change-order-form\",\"description\":\"Request a project change using this order form.\",\"id\":28219028,\"released\":\"2023-08-23 13:53:07\",\"categories\":[\"Basic\",\"Business Operations\",\"Order Form\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/change-order-form\\/\",\"icon\":false,\"key\":\"change-order\",\"used_addons\":[],\"is_new\":false},\"28311445\":{\"name\":\"Petition Form Template\",\"slug\":\"petition-form\",\"description\":\"Easily allow users to collect signatures, gather supporter information, and track responses efficiently.\",\"id\":28311445,\"released\":\"2025-02-06 13:48:09\",\"categories\":[\"Business\",\"File Upload\",\"Nonprofit\",\"Request\",\"Signature\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/petition-form\\/\",\"icon\":false,\"key\":\"petition\",\"used_addons\":[\"Digital Signatures\"],\"is_new\":false},\"28313750\":{\"name\":\"Employee Acknowledgement Form Template\",\"slug\":\"employee-acknowledgement-form\",\"description\":\"Ensure employees formally acknowledge that they have read and will comply with company policies and procedures.\",\"id\":28313750,\"released\":\"2025-02-26 13:35:55\",\"categories\":[\"Business\",\"Business Operations\",\"Consent\",\"Multi-Page\",\"Signature\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/employee-acknowledgement-form\\/\",\"icon\":false,\"key\":\"employee-acknowledgement\",\"used_addons\":[\"Digital Signatures\"],\"is_new\":false},\"28018839\":{\"name\":\"Medical Release Form Template\",\"slug\":\"medical-release-form\",\"description\":\"A simple medical release platform that also allows you to collect basic information as well.\",\"id\":28018839,\"released\":\"2020-09-17 10:47:21\",\"categories\":[\"Business\",\"Health and Wellness\",\"Signature\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/medical-release-form\\/\",\"icon\":false,\"key\":\"medical-release\",\"used_addons\":[\"Digital Signatures\"],\"is_new\":false},\"28221336\":{\"name\":\"Medical Referral Form Template\",\"slug\":\"medical-referral-form\",\"description\":\"Collect crucial medical details from patients requiring specialized care.\",\"id\":28221336,\"released\":\"2023-09-01 15:17:23\",\"categories\":[\"Basic\",\"Health and Wellness\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/medical-referral-form\\/\",\"icon\":false,\"key\":\"medical-referral\",\"used_addons\":[],\"is_new\":false},\"28223640\":{\"name\":\"Stripe Payment Form Template\",\"slug\":\"stripe-payment-form\",\"description\":\"Effortlessly gather payment information from customers using our secure Stripe payment form. Simplify the payment process and ensure a seamless transaction experience.\",\"id\":28223640,\"released\":\"2023-09-12 15:53:15\",\"categories\":[\"Business Operations\",\"free\",\"Payment\",\"Stripe\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/stripe-payment-form\\/\",\"icon\":false,\"key\":\"stripe-payment\",\"used_addons\":[],\"is_new\":false},\"20905880\":{\"name\":\"Family Reunion Registration Form Template\",\"slug\":\"family-reunion-registration-form\",\"description\":\"Register each family member for a reunion.\",\"id\":20905880,\"released\":\"2019-11-24 23:00:20\",\"categories\":[\"Event Planning\",\"free\",\"Registration and Signup\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/family-reunion-registration-form\\/\",\"icon\":false,\"key\":\"family-reunion-registration\",\"used_addons\":[],\"is_new\":false},\"20905881\":{\"name\":\"Church Membership Form Template\",\"slug\":\"church-membership-form\",\"description\":\"Easily allow new church members to apply for a membership with this form.\",\"id\":20905881,\"released\":\"2019-11-24 23:00:02\",\"categories\":[\"Application\",\"Basic\",\"Nonprofit\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/church-membership-form\\/\",\"icon\":false,\"key\":\"church-membership\",\"used_addons\":[],\"is_new\":false},\"28269210\":{\"name\":\"Class Feedback Survey Template\",\"slug\":\"class-feedback-survey-form\",\"description\":\"Collect valuable feedback from participants with this class feedback survey template to understand their learning experience and improve course offerings for enhanced student satisfaction.\",\"id\":28269210,\"released\":\"2024-03-22 15:24:10\",\"categories\":[\"Basic\",\"Education\",\"Feedback\",\"Survey\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/class-feedback-survey-form\\/\",\"icon\":false,\"key\":\"class-feedback-survey\",\"used_addons\":[],\"is_new\":false},\"28313755\":{\"name\":\"DJ Song Request Form Template\",\"slug\":\"dj-song-request-form\",\"description\":\"Allow guests to request their favorite songs with this DJ Song Request Form.\",\"id\":28313755,\"released\":\"2025-02-26 13:55:23\",\"categories\":[\"Basic\",\"Entertainment\",\"Request\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/dj-song-request-form\\/\",\"icon\":false,\"key\":\"dj-song-request\",\"used_addons\":[],\"is_new\":false},\"28036251\":{\"name\":\"Super Bowl Party RSVP Form Template\",\"slug\":\"super-bowl-party-rsvp-form\",\"description\":\"Planning a Super Bowl party? Make the biggest football game of the year EPIC with our Super Bowl Party RSVP form template!\",\"id\":28036251,\"released\":\"2020-12-18 12:56:26\",\"categories\":[\"Event Planning\",\"free\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/super-bowl-party-rsvp-form\\/\",\"icon\":false,\"key\":\"super-bowl-party-rsvp\",\"used_addons\":[],\"is_new\":false},\"28314012\":{\"name\":\"Discord Mod Application Form Template\",\"slug\":\"discord-mod-application-form\",\"description\":\"Screen and recruit the best moderators for your Discord server with this application form.\",\"id\":28314012,\"released\":\"2025-02-28 12:17:21\",\"categories\":[\"Application\",\"Basic\",\"Entertainment\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/discord-mod-application-form\\/\",\"icon\":false,\"key\":\"discord-mod-application\",\"used_addons\":[],\"is_new\":true},\"20909980\":{\"name\":\"Work Order Request Form\",\"slug\":\"work-order-request-form\",\"description\":\"A powerful form for keeping track of work orders and requests for maintenance from employees or tenants.\",\"id\":20909980,\"released\":\"2019-11-24 23:00:02\",\"categories\":[\"Basic\",\"Customer Service\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/work-order-request-form\\/\",\"icon\":false,\"key\":\"work-order-request\",\"used_addons\":[],\"is_new\":false},\"28194205\":{\"name\":\"AI Auto-Mate Form Template\",\"slug\":\"ai-auto-mate-form\",\"description\":\"This AI Auto-Mate Auto finder Form Template utilizes AI to help you find your perfect car.\",\"id\":28194205,\"released\":\"2023-04-27 17:48:25\",\"categories\":[\"AI\",\"Business\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/ai-auto-mate-form\\/\",\"icon\":false,\"key\":\"ai-auto-mate\",\"used_addons\":[],\"is_new\":false},\"28227997\":{\"name\":\"Drug Test Results Form Template\",\"slug\":\"drug-test-results-form\",\"description\":\"Streamline the process of receiving, processing, and securely storing drug test results for laboratories and healthcare facilities.\",\"id\":28227997,\"released\":\"2023-10-02 13:56:13\",\"categories\":[\"Business\",\"File Upload\",\"Signature\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/drug-test-results-form\\/\",\"icon\":false,\"key\":\"drug-test-results\",\"used_addons\":[\"Digital Signatures\"],\"is_new\":false},\"28226974\":{\"name\":\"Opt-Out Form Template\",\"slug\":\"opt-out-form\",\"description\":\"Provide customers with a convenient way to opt out of standard procedures.\",\"id\":28226974,\"released\":\"2023-11-18 10:44:27\",\"categories\":[\"Business\",\"Business Operations\",\"Signature\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/opt-out-form\\/\",\"icon\":false,\"key\":\"opt-out\",\"used_addons\":[\"Digital Signatures\"],\"is_new\":false},\"28227230\":{\"name\":\"Florida Living Will Form Template\",\"slug\":\"florida-living-will-form\",\"description\":\"Collect essential details from individuals creating a living will in compliance with Florida state laws.\",\"id\":28227230,\"released\":\"2023-11-18 10:50:21\",\"categories\":[\"Business\",\"Health and Wellness\",\"Signature\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/florida-living-will-form\\/\",\"icon\":false,\"key\":\"florida-living-will\",\"used_addons\":[],\"is_new\":false},\"28313759\":{\"name\":\"Christening Registration Form Template\",\"slug\":\"christening-registration-form\",\"description\":\"Streamline christening event registrations and capture essential details for a seamless ceremony.\",\"id\":28313759,\"released\":\"2025-02-26 14:30:49\",\"categories\":[\"Business\",\"Datepicker\",\"Nonprofit\",\"Registration and Signup\",\"Repeater Field\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/christening-registration-form\\/\",\"icon\":false,\"key\":\"christening-registration\",\"used_addons\":[\"Datepicker Options\"],\"is_new\":false},\"28192671\":{\"name\":\"Employee Performance Survey Template\",\"slug\":\"employee-performance-survey-form\",\"description\":\"A good way to keep track on how well each employee is doing.\",\"id\":28192671,\"released\":\"2023-04-19 18:39:59\",\"categories\":[\"Business\",\"Business Operations\",\"Survey\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/employee-performance-survey-form\\/\",\"icon\":false,\"key\":\"employee-performance-survey\",\"used_addons\":[],\"is_new\":false},\"28056480\":{\"name\":\"Retreat Registration Form Template\",\"slug\":\"retreat-registration-form\",\"description\":\"This retreat registration form is great for booking attendees for a getaway.\",\"id\":28056480,\"released\":\"2021-08-02 15:55:08\",\"categories\":[\"Event Planning\",\"Personal\",\"Registration and Signup\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/retreat-registration-form\\/\",\"icon\":false,\"key\":\"retreat-registration\",\"used_addons\":[],\"is_new\":false},\"28036512\":{\"name\":\"Online Proposal Form Template\",\"slug\":\"online-proposal-form\",\"description\":\"Use this online proposal form, to gather the information needed to make decisions regarding projects that come your way.\",\"id\":28036512,\"released\":\"2020-12-18 13:12:05\",\"categories\":[\"Business Operations\",\"free\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/online-proposal-form\\/\",\"icon\":false,\"key\":\"online-proposal\",\"used_addons\":[],\"is_new\":false},\"28036513\":{\"name\":\"Lecture Notes Form Template\",\"slug\":\"lecture-notes-form\",\"description\":\"Use the simple form to organize your lecture notes next time you come to class.\",\"id\":28036513,\"released\":\"2020-12-18 13:18:12\",\"categories\":[\"Education\",\"free\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/lecture-notes-form\\/\",\"icon\":false,\"key\":\"lecture-notes\",\"used_addons\":[],\"is_new\":false},\"28305313\":{\"name\":\"Chain of Custody Form Template\",\"slug\":\"chain-of-custody-form\",\"description\":\"A Chain of Custody Form documents the handling and transfer of evidence or materials. This form ensures accountability, maintains integrity, and provides a clear record for legal and regulatory purposes.\",\"id\":28305313,\"released\":\"2024-12-06 11:00:05\",\"categories\":[\"Business\",\"Business Operations\",\"Consent\",\"Datepicker\",\"Elite\",\"Request\",\"Signature\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/chain-of-custody-form\\/\",\"icon\":false,\"key\":\"chain-of-custody\",\"used_addons\":[\"Digital Signatures\"],\"is_new\":false},\"28311457\":{\"name\":\"New Vendor Form Template\",\"slug\":\"new-vendor-form\",\"description\":\"Streamline your vendor onboarding process with this New Vendor Form Template, designed to collect essential business details, contact information, and agreements efficiently.\",\"id\":28311457,\"released\":\"2025-02-06 14:48:07\",\"categories\":[\"Basic\",\"Business Operations\",\"Repeater Field\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/new-vendor-form\\/\",\"icon\":false,\"key\":\"new-vendor\",\"used_addons\":[],\"is_new\":false},\"28036514\":{\"name\":\"Fitness Interest Form Template\",\"slug\":\"fitness-interest-form\",\"description\":\"Collect information about your next client with this fitness interest form.\",\"id\":28036514,\"released\":\"2020-12-18 13:25:25\",\"categories\":[\"free\",\"Health and Wellness\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/fitness-interest-form\\/\",\"icon\":false,\"key\":\"fitness-interest\",\"used_addons\":[],\"is_new\":false},\"28313764\":{\"name\":\"Nursery Registration Form Template\",\"slug\":\"nursery-registration-form\",\"description\":\"Effortlessly register children for nursery by gathering important details about them and their parents.\",\"id\":28313764,\"released\":\"2025-02-26 15:47:02\",\"categories\":[\"Basic\",\"Business Operations\",\"Education\",\"Registration and Signup\",\"Repeater Field\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/nursery-registration-form\\/\",\"icon\":false,\"key\":\"nursery-registration\",\"used_addons\":[],\"is_new\":false},\"28029860\":{\"name\":\"Non Profit Donation Form Template\",\"slug\":\"non-profit-donation-form\",\"description\":\"This donation form template will help nonprofits or charities easily collect donor information & raise money.\",\"id\":28029860,\"released\":\"2020-12-01 00:00:38\",\"categories\":[\"Business\",\"Nonprofit\",\"Payment\",\"PayPal\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/non-profit-donation-form\\/\",\"icon\":false,\"key\":\"non-profit-donation\",\"used_addons\":[\"PayPal Standard\"],\"is_new\":false},\"28036516\":{\"name\":\"Suggestion Form Template\",\"slug\":\"suggestion-form\",\"description\":\"Get valuable feedback from your customers with this suggestion form.\",\"id\":28036516,\"released\":\"2020-12-18 14:00:06\",\"categories\":[\"Feedback\",\"free\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/suggestion-form\\/\",\"icon\":false,\"key\":\"suggestion\",\"used_addons\":[],\"is_new\":false},\"28305316\":{\"name\":\"Raffle Entry Form Template\",\"slug\":\"raffle-entry-form\",\"description\":\"The Raffle entry form template provides a convenient way to create and manage tickets for fundraising events. This template ensures clear identification of each ticket, helping organizers track sales and manage draws effectively.\",\"id\":28305316,\"released\":\"2024-12-06 11:48:36\",\"categories\":[\"Business\",\"Business Operations\",\"Calculator\",\"Elite\",\"Event Planning\",\"Marketing\",\"Order Form\",\"PayPal\",\"Stripe\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/raffle-entry-form\\/\",\"icon\":false,\"key\":\"raffle-entry\",\"used_addons\":[\"PayPal Standard\",\"Stripe\"],\"is_new\":false},\"28029862\":{\"name\":\"Silent Auction Donation Form Template\",\"slug\":\"auction-donation-form\",\"description\":\"Collect donated items and bids for your fundraiser.\",\"id\":28029862,\"released\":\"2020-12-01 00:01:21\",\"categories\":[\"Basic\",\"Nonprofit\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/auction-donation-form\\/\",\"icon\":false,\"key\":\"auction-donation\",\"used_addons\":[],\"is_new\":false},\"28228006\":{\"name\":\"Facial Consent Form Template\",\"slug\":\"facial-consent-form\",\"description\":\"Gather essential information from individuals granting consent for facial treatments or procedures, ensuring a safe and informed experience.\",\"id\":28228006,\"released\":\"2023-10-02 14:43:57\",\"categories\":[\"Business\",\"Customer Service\",\"Signature\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/facial-consent-form\\/\",\"icon\":false,\"key\":\"facial-consent\",\"used_addons\":[\"Digital Signatures\"],\"is_new\":false},\"28311463\":{\"name\":\"Customer Information Form Template\",\"slug\":\"customer-information-form\",\"description\":\"Streamline customer data collection with this Customer Information Form Template.\",\"id\":28311463,\"released\":\"2025-02-06 15:02:33\",\"categories\":[\"Basic\",\"Business Operations\",\"Lead\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/customer-information-form\\/\",\"icon\":false,\"key\":\"customer-information\",\"used_addons\":[],\"is_new\":false},\"28142760\":{\"name\":\"Cake Order Form Template\",\"slug\":\"cake-order-form\",\"description\":\"Want to sell more cakes online? Use the cake order form to view incoming cake orders instantly.\",\"id\":28142760,\"released\":\"2022-11-06 22:00:00\",\"categories\":[\"Business\",\"Business Operations\",\"Conversational Forms\",\"Geolocation\",\"Order Form\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/cake-order-form\\/\",\"icon\":false,\"key\":\"cake-order\",\"used_addons\":[\"Conversational Forms\",\"Geolocation\"],\"is_new\":false},\"28029609\":{\"name\":\"In-Kind Donation Form Template\",\"slug\":\"in-kind-donation-form\",\"description\":\"This simple in-kind template will make it easier to collect non-cash donations for your organization.\",\"id\":28029609,\"released\":\"2020-12-01 00:01:13\",\"categories\":[\"Nonprofit\",\"Personal\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/in-kind-donation-form\\/\",\"icon\":false,\"key\":\"in-kind-donation\",\"used_addons\":[],\"is_new\":false},\"28029611\":{\"name\":\"Donation Form Template\",\"slug\":\"donation-form\",\"description\":\"Nonprofits can collect donations the easy way. It is perfect for organizations of all types and sizes!\",\"id\":28029611,\"released\":\"2020-12-01 00:01:43\",\"categories\":[\"Nonprofit\",\"Personal\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/donation-form\\/\",\"icon\":false,\"key\":\"donation\",\"used_addons\":[],\"is_new\":false},\"28311468\":{\"name\":\"Insurance Waiver Form Template\",\"slug\":\"insurance-waiver-form\",\"description\":\"Effortlessly collect and manage insurance waiver requests ensuring a seamless user experience.\",\"id\":28311468,\"released\":\"2025-02-06 15:49:27\",\"categories\":[\"Business\",\"Business Operations\",\"Signature\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/insurance-waiver-form\\/\",\"icon\":false,\"key\":\"insurance-waiver\",\"used_addons\":[\"Digital Signatures\"],\"is_new\":false},\"28029869\":{\"name\":\"Employee Evaluation Form Template\",\"slug\":\"employee-evaluation-form\",\"description\":\"An employee evaluation form template can make human resources easy. This template will help your team fly through performance reviews!\",\"id\":28029869,\"released\":\"2021-09-20 10:35:29\",\"categories\":[\"Business\",\"Business Operations\",\"Feedback\",\"Signature\",\"Survey\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/employee-evaluation-form\\/\",\"icon\":false,\"key\":\"employee-evaluation\",\"used_addons\":[],\"is_new\":false},\"20908976\":{\"name\":\"IT Asset Form Template\",\"slug\":\"it-asset-management-form\",\"description\":\"Use this form for hardware inventory and asset management to keep track of valuable equipment.\",\"id\":20908976,\"released\":\"2020-01-06 09:33:18\",\"categories\":[\"Basic\",\"Business Operations\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/it-asset-management-form\\/\",\"icon\":false,\"key\":\"it-asset-management\",\"used_addons\":[],\"is_new\":false},\"28218801\":{\"name\":\"PTO Request Form Template\",\"slug\":\"pto-request-form\",\"description\":\"A simple form allowing team members to request paid time off\",\"id\":28218801,\"released\":\"2023-08-22 15:49:50\",\"categories\":[\"Basic\",\"Business Operations\",\"Request\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/pto-request-form\\/\",\"icon\":false,\"key\":\"pto-request\",\"used_addons\":[],\"is_new\":false},\"28307633\":{\"name\":\"Construction Loan Calculator Form\",\"slug\":\"construction-loan-calculator-form\",\"description\":\"Utilize this calculator to swiftly assess the type of loan you may be eligible for and estimate the monthly payments for an initial interest-only loan.\",\"id\":28307633,\"released\":\"2025-01-06 12:35:34\",\"categories\":[\"Business\",\"Business Operations\",\"Calculator\",\"Elite\",\"Finance\",\"Lead\",\"Real Estate\",\"Survey\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/construction-loan-calculator-form\\/\",\"icon\":false,\"key\":\"construction-loan-calculator\",\"used_addons\":[],\"is_new\":false},\"28311473\":{\"name\":\"GDPR Form Template\",\"slug\":\"gdpr-form\",\"description\":\"Ensure GDPR compliance by collecting user consent and managing data requests effortlessly.\",\"id\":28311473,\"released\":\"2025-02-06 16:01:13\",\"categories\":[\"Business Operations\",\"Consent\",\"Customer Service\",\"free\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/gdpr-form\\/\",\"icon\":false,\"key\":\"gdpr\",\"used_addons\":[],\"is_new\":false},\"20908978\":{\"name\":\"Gift Card Order Form Template\",\"slug\":\"gift-card-order-form\",\"description\":\"Sell gift cards to your customers to broaden your customer base.\",\"id\":20908978,\"released\":\"2019-11-24 23:00:42\",\"categories\":[\"Business\",\"Marketing\",\"Order Form\",\"Payment\",\"Stripe\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/gift-card-order-form\\/\",\"icon\":false,\"key\":\"gift-card-order\",\"used_addons\":[\"Stripe\"],\"is_new\":false},\"28219314\":{\"name\":\"Statistical Significance Calculator\",\"slug\":\"statistical-significance-form\",\"description\":\"Calculate the statistical significance and P-value with this calculator.\",\"id\":28219314,\"released\":\"2023-11-11 14:59:07\",\"categories\":[\"Business\",\"Calculator\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/statistical-significance-form\\/\",\"icon\":false,\"key\":\"statistical-significance\",\"used_addons\":[],\"is_new\":false},\"20908979\":{\"name\":\"Testimonial Form Template\",\"slug\":\"testimonial-form\",\"description\":\"Collect and share customer testimonials.\",\"id\":20908979,\"released\":\"2020-01-06 09:52:47\",\"categories\":[\"Marketing\",\"Personal\",\"Survey\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/testimonial-form\\/\",\"icon\":[\"https:\\/\\/formidableforms.com\\/wp-content\\/uploads\\/2020\\/01\\/testimonial-form-template.jpg\",650,288,false],\"key\":\"testimonial\",\"used_addons\":[\"Surveys and Polls\"],\"is_new\":false},\"28232115\":{\"name\":\"Are You a True Swiftie Quiz Template\",\"slug\":\"are-you-a-true-swiftie-quiz-form\",\"description\":\"Discover whether or not you\'re a true Swiftie with this quiz designed to test your understanding of Taylor Swift.\",\"id\":28232115,\"released\":\"2023-11-07 15:28:12\",\"categories\":[\"Business\",\"Quiz\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/are-you-a-true-swiftie-quiz-form\\/\",\"icon\":false,\"key\":\"are-you-a-true-swiftie-quiz\",\"used_addons\":[],\"is_new\":false},\"20908980\":{\"name\":\"Event Feedback Template\",\"slug\":\"event-feedback-form\",\"description\":\"Get the opinions of event attendees so you can grow your business.\",\"id\":20908980,\"released\":\"2019-11-24 23:00:08\",\"categories\":[\"Feedback\",\"Personal\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/event-feedback-form\\/\",\"icon\":false,\"key\":\"event-feedback\",\"used_addons\":[],\"is_new\":false},\"20909236\":{\"name\":\"Debt to Income Ratio Calculator Form Template\",\"slug\":\"debt-to-income-ratio-calculator-form\",\"description\":\"Check for a healthy debt to income ratio before starting a loan.\",\"id\":20909236,\"released\":\"2019-11-24 23:00:10\",\"categories\":[\"Calculator\",\"Finance\",\"Personal\",\"Real Estate\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/debt-to-income-ratio-calculator-form\\/\",\"icon\":false,\"key\":\"debt-to-income-ratio-calculator\",\"used_addons\":[],\"is_new\":false},\"28307636\":{\"name\":\"Home Inspection Request Form\",\"slug\":\"home-inspection-request-form\",\"description\":\"This form template is designed to streamline the process of requesting a home inspection. Ideal for real estate agents, home buyers, and sellers, this template ensures a comprehensive and organized collection of necessary information.\",\"id\":28307636,\"released\":\"2025-01-06 14:36:46\",\"categories\":[\"Application\",\"Business\",\"Business Operations\",\"Datepicker\",\"Elite\",\"Geolocation\",\"Lead\",\"Nonprofit\",\"Real Estate\",\"Signature\",\"Survey\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/home-inspection-request-form\\/\",\"icon\":false,\"key\":\"home-inspection-request\",\"used_addons\":[\"Datepicker Options\"],\"is_new\":false},\"20908981\":{\"name\":\"Survey Form Template\",\"slug\":\"survey-form\",\"description\":\"Collect feedback from your customers, employees, or other members of your community using an online survey form.\",\"id\":20908981,\"released\":\"2021-09-16 23:33:58\",\"categories\":[\"Business\",\"Feedback\",\"Survey\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/survey-form\\/\",\"icon\":false,\"key\":\"survey\",\"used_addons\":[\"Surveys and Polls\"],\"is_new\":false},\"20909237\":{\"name\":\"Life Insurance Calculator Template\",\"slug\":\"life-insurance-calculator-form\",\"description\":\"Offer accurate life insurance estimates with this calculator.\",\"id\":20909237,\"released\":\"2019-11-24 23:00:21\",\"categories\":[\"Business\",\"Calculator\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/life-insurance-calculator-form\\/\",\"icon\":false,\"key\":\"life-insurance-calculator\",\"used_addons\":[],\"is_new\":false},\"28015029\":{\"name\":\"College Application Form Template\",\"slug\":\"college-application-form\",\"description\":\"A great an easy way to collect applicant details for college admissions.\",\"id\":28015029,\"released\":\"2020-08-13 11:37:03\",\"categories\":[\"Application\",\"Business\",\"Education\",\"File Upload\",\"Multi-Page\",\"Repeater Field\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/college-application-form\\/\",\"icon\":false,\"key\":\"college-application\",\"used_addons\":[\"Locations\"],\"is_new\":false},\"20909238\":{\"name\":\"ROI Calculator Form Template\",\"slug\":\"roi-calculator-form\",\"description\":\"Estimate the profit or loss on an investment as a simple percentage.\",\"id\":20909238,\"released\":\"2019-11-24 23:00:47\",\"categories\":[\"Business\",\"Business Operations\",\"Calculator\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/roi-calculator-form\\/\",\"icon\":false,\"key\":\"roi-calculator\",\"used_addons\":[],\"is_new\":false},\"28015030\":{\"name\":\"High School Calculator Template\",\"slug\":\"high-school-calculator-form\",\"description\":\"A quick and easy form that can calculate a GPA in a matter of moments.\",\"id\":28015030,\"released\":\"2020-09-28 08:10:52\",\"categories\":[\"Business\",\"Calculator\",\"Education\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/high-school-calculator-form\\/\",\"icon\":false,\"key\":\"high-school-calculator\",\"used_addons\":[],\"is_new\":false},\"20909239\":{\"name\":\"Savings and Investment Calculator Form Template\",\"slug\":\"savings-and-investment-calculator-form\",\"description\":\"Estimate profit from an investment or savings account.\",\"id\":20909239,\"released\":\"2019-11-24 23:00:37\",\"categories\":[\"Business\",\"Calculator\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/savings-and-investment-calculator-form\\/\",\"icon\":false,\"key\":\"savings-and-investment-calculator\",\"used_addons\":[],\"is_new\":false},\"28015031\":{\"name\":\"Event Planner Form Template\",\"slug\":\"event-planner-form\",\"description\":\"A simple form used to collect data from an event. Useful for the planning and simple processing of data.\",\"id\":28015031,\"released\":\"2020-08-07 11:09:13\",\"categories\":[\"Basic\",\"Event Planning\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/event-planner-form\\/\",\"icon\":false,\"key\":\"event-planner\",\"used_addons\":[],\"is_new\":false},\"28015032\":{\"name\":\"Expense Reimbursement Form Template\",\"slug\":\"reimbursement-form\",\"description\":\"A form that can allow you to easily gather expense reimbursements in any setting.\",\"id\":28015032,\"released\":\"2020-08-07 11:20:50\",\"categories\":[\"Business\",\"Business Operations\",\"Calculator\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/reimbursement-form\\/\",\"icon\":false,\"key\":\"reimbursement\",\"used_addons\":[],\"is_new\":false},\"28228024\":{\"name\":\"Babysitter Application Form Template\",\"slug\":\"babysitter-application-form\",\"description\":\"Collect important details from prospective babysitters interested in providing childcare services, helping you find the perfect caregiver for your family.\",\"id\":28228024,\"released\":\"2023-11-18 03:46:00\",\"categories\":[\"Basic\",\"Health and Wellness\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/babysitter-application-form\\/\",\"icon\":false,\"key\":\"babysitter-application\",\"used_addons\":[],\"is_new\":false},\"20908986\":{\"name\":\"Newsletter Signup Form Template\",\"slug\":\"newsletter-signup-form\",\"description\":\"Build your email list and ramp up your email marketing efforts with a newsletter signup form.\",\"id\":20908986,\"released\":\"2019-11-24 23:00:52\",\"categories\":[\"Marketing\",\"Personal\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/newsletter-signup-form\\/\",\"icon\":false,\"key\":\"newsletter-signup\",\"used_addons\":[],\"is_new\":false},\"28224188\":{\"name\":\"Customer Acknowledgement Form Template\",\"slug\":\"customer-acknowledgement-form\",\"description\":\"Utilize our customer acknowledgement form template to capture a client\'s endorsement.\",\"id\":28224188,\"released\":\"2023-11-18 03:55:00\",\"categories\":[\"Business\",\"Signature\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/customer-acknowledgement-form\\/\",\"icon\":false,\"key\":\"customer-acknowledgement\",\"used_addons\":[\"Digital Signatures\"],\"is_new\":false},\"28232124\":{\"name\":\"Social Media Release Form Template\",\"slug\":\"social-media-release-form\",\"description\":\"Gather essential permissions and details from individuals granting consent for the use of their content on social media platforms.\",\"id\":28232124,\"released\":\"2023-10-19 12:26:28\",\"categories\":[\"Business\",\"Business Operations\",\"File Upload\",\"Signature\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/social-media-release-form\\/\",\"icon\":false,\"key\":\"social-media-release\",\"used_addons\":[\"Digital Signatures\"],\"is_new\":false},\"20908990\":{\"name\":\"Maintenance Request Form Template\",\"slug\":\"maintenance-request-form\",\"description\":\"Streamline the process of dealing with maintenance requests.\",\"id\":20908990,\"released\":\"2019-11-24 23:00:29\",\"categories\":[\"Basic\",\"Customer Service\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/maintenance-request-form\\/\",\"icon\":false,\"key\":\"maintenance-request\",\"used_addons\":[],\"is_new\":false},\"28317119\":{\"name\":\"Eviction Notice Form Template\",\"slug\":\"eviction-notice-form\",\"description\":\"Formally notify tenants of lease violations or termination and what payment is owed with this clear and professional eviction notice form.\",\"id\":28317119,\"released\":\"2025-03-27 12:12:35\",\"categories\":[\"Basic\",\"Business Operations\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/eviction-notice-form\\/\",\"icon\":false,\"key\":\"eviction-notice\",\"used_addons\":[],\"is_new\":true},\"28271295\":{\"name\":\"Skincare Product Survey Template\",\"slug\":\"skincare-product-survey-form\",\"description\":\"Gather valuable insights from participants with this skincare product survey template to understand preferences and trends in skincare routines.\",\"id\":28271295,\"released\":\"2024-04-02 13:38:01\",\"categories\":[\"Basic\",\"Feedback\",\"Survey\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/skincare-product-survey-form\\/\",\"icon\":false,\"key\":\"skincare-product-survey\",\"used_addons\":[],\"is_new\":false},\"20908992\":{\"name\":\"Summer Camp Registration Form Template\",\"slug\":\"summer-camp-registration-form\",\"description\":\"An easier way for parents to register their kids for summer camp\",\"id\":20908992,\"released\":\"2019-11-24 23:00:11\",\"categories\":[\"Application\",\"Business\",\"Business Operations\",\"Multi-Page\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/summer-camp-registration-form\\/\",\"icon\":false,\"key\":\"summer-camp-registration\",\"used_addons\":[],\"is_new\":false},\"28150464\":{\"name\":\"Informed Consent Form Template\",\"slug\":\"informed-consent-form\",\"description\":\"Get consent from an individual to participate in a study with this Informed consent form example.\",\"id\":28150464,\"released\":\"2022-11-06 16:42:00\",\"categories\":[\"Business\",\"Education\",\"Signature\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/informed-consent-form\\/\",\"icon\":false,\"key\":\"informed-consent\",\"used_addons\":[\"Digital Signatures\"],\"is_new\":false},\"28232128\":{\"name\":\"Direction of Pay Form Template\",\"slug\":\"direction-of-pay-form\",\"description\":\"Obtain vital information from individuals seeking a direction of pay to ensure swift and secure payment processing.\",\"id\":28232128,\"released\":\"2023-10-19 12:54:57\",\"categories\":[\"Business\",\"Business Operations\",\"Payment\",\"Signature\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/direction-of-pay-form\\/\",\"icon\":false,\"key\":\"direction-of-pay\",\"used_addons\":[],\"is_new\":false},\"28173761\":{\"name\":\"Player Profile Template\",\"slug\":\"player-profile-form\",\"description\":\"Collect information of players to play in your team with the Player Profile template.\",\"id\":28173761,\"released\":\"2023-01-24 15:42:33\",\"categories\":[\"Business\",\"Conversational Forms\",\"Education\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/player-profile-form\\/\",\"icon\":false,\"key\":\"player-profile\",\"used_addons\":[\"Conversational Forms\"],\"is_new\":false},\"20908995\":{\"name\":\"Time Sheet Template\",\"slug\":\"time-sheet-form\",\"description\":\"An effective way of keeping track of employee hours each week.\",\"id\":20908995,\"released\":\"2019-11-24 23:00:11\",\"categories\":[\"Business\",\"Business Operations\",\"Calculator\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/time-sheet-form\\/\",\"icon\":false,\"key\":\"time-sheet\",\"used_addons\":[],\"is_new\":false},\"28053955\":{\"name\":\"Student Budget Calculator Template\",\"slug\":\"student-budget-calculator-form\",\"description\":\"This handy student budget calculator will help students figure out expenses and income while attending a university or college.\",\"id\":28053955,\"released\":\"2021-08-20 17:16:48\",\"categories\":[\"Business\",\"Calculator\",\"Education\",\"Finance\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/student-budget-calculator-form\\/\",\"icon\":false,\"key\":\"student-budget-calculator\",\"used_addons\":[],\"is_new\":false},\"28224195\":{\"name\":\"Simple Proxy Form Template\",\"slug\":\"simple-proxy-form\",\"description\":\"Use our simple proxy form to designate someone authorized to act on your behalf.\",\"id\":28224195,\"released\":\"2023-11-18 03:57:00\",\"categories\":[\"Basic\",\"Business Operations\",\"Contact\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/simple-proxy-form\\/\",\"icon\":false,\"key\":\"simple-proxy\",\"used_addons\":[],\"is_new\":false},\"28218820\":{\"name\":\"Margin of Error Calculator Template\",\"slug\":\"margin-of-error-calculator-form\",\"description\":\"Use this calculator to find the margin of error.\",\"id\":28218820,\"released\":\"2023-11-11 03:59:00\",\"categories\":[\"Business\",\"Calculator\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/margin-of-error-calculator-form\\/\",\"icon\":false,\"key\":\"margin-of-error-calculator\",\"used_addons\":[],\"is_new\":false},\"28220100\":{\"name\":\"Shelf Life Calculator\",\"slug\":\"shelf-life-calculator-form\",\"description\":\"Calculate the shelf life of any food product with this calculator.\",\"id\":28220100,\"released\":\"2023-08-28 13:29:33\",\"categories\":[\"Business\",\"Calculator\",\"Datepicker\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/shelf-life-calculator-form\\/\",\"icon\":false,\"key\":\"shelf-life-calculator\",\"used_addons\":[\"Datepicker Options\"],\"is_new\":false},\"28032452\":{\"name\":\"Webinar Registration Form Template\",\"slug\":\"webinar-registration-form\",\"description\":\"A webinar registration form that can be connected to Zoom via Zapier.\",\"id\":28032452,\"released\":\"2020-12-01 13:20:46\",\"categories\":[\"Business\",\"Business Operations\",\"Registration and Signup\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/webinar-registration-form\\/\",\"icon\":false,\"key\":\"webinar-registration\",\"used_addons\":[],\"is_new\":false},\"20908997\":{\"name\":\"Home Buyer Feedback Form Template\",\"slug\":\"home-buyer-feedback-form\",\"description\":\"Ask recent home buyers about their experiences during the home buying process.\",\"id\":20908997,\"released\":\"2019-11-24 23:00:36\",\"categories\":[\"Basic\",\"Feedback\",\"Real Estate\",\"Survey\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/home-buyer-feedback-form\\/\",\"icon\":false,\"key\":\"home-buyer-feedback\",\"used_addons\":[],\"is_new\":false},\"28307653\":{\"name\":\"DoorDash Weekly Earnings Calculator Form\",\"slug\":\"doordash-weekly-earnings-calculator-form\",\"description\":\"This template is crafted to help DoorDash drivers efficiently track and calculate their weekly earnings. It features fields for inputting delivery details, tips received, mileage, and other relevant expenses.\",\"id\":28307653,\"released\":\"2025-01-06 15:55:34\",\"categories\":[\"Business\",\"Business Operations\",\"Calculator\",\"Elite\",\"Finance\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/doordash-weekly-earnings-calculator-form\\/\",\"icon\":false,\"key\":\"doordash-weekly-earnings-calculator\",\"used_addons\":[],\"is_new\":false},\"20908998\":{\"name\":\"Parental Consent Template\",\"slug\":\"parental-consent-form\",\"description\":\"Document parental permission before going on a field trip.\",\"id\":20908998,\"released\":\"2019-11-24 23:00:47\",\"categories\":[\"Education\",\"free\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/parental-consent-form\\/\",\"icon\":false,\"key\":\"parental-consent\",\"used_addons\":[],\"is_new\":false},\"20908999\":{\"name\":\"Exercise Log Form Template\",\"slug\":\"exercise-log-form\",\"description\":\"Organize and monitor client workouts.\",\"id\":20908999,\"released\":\"2020-01-06 09:43:02\",\"categories\":[\"Basic\",\"Health and Wellness\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/exercise-log-form\\/\",\"icon\":false,\"key\":\"exercise-log\",\"used_addons\":[],\"is_new\":false},\"28150471\":{\"name\":\"Membership Form Template\",\"slug\":\"membership-form\",\"description\":\"Gather personal information from potential members along with membership fees with this form template.\",\"id\":28150471,\"released\":\"2022-11-06 16:44:00\",\"categories\":[\"Business\",\"Geolocation\",\"PayPal\",\"Registration and Signup\",\"Signature\",\"Survey\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/membership-form\\/\",\"icon\":false,\"key\":\"membership\",\"used_addons\":[],\"is_new\":false},\"28224199\":{\"name\":\"Girlfriend Application Form Template\",\"slug\":\"girlfriend-application-form\",\"description\":\"Capture information from individuals interested in becoming your girlfriend.\",\"id\":28224199,\"released\":\"2023-11-18 04:00:00\",\"categories\":[\"Application\",\"Basic\",\"Entertainment\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/girlfriend-application-form\\/\",\"icon\":false,\"key\":\"girlfriend-application\",\"used_addons\":[],\"is_new\":false},\"28052681\":{\"name\":\"Newspaper Subscription Form Template\",\"slug\":\"newspaper-subscription-form\",\"description\":\"Get out all pertinent information for newspaper subscriptions submitted electronically through your website using PayPal.\",\"id\":28052681,\"released\":\"2021-08-03 16:06:55\",\"categories\":[\"Payment\",\"PayPal\",\"Personal\",\"Registration and Signup\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/newspaper-subscription-form\\/\",\"icon\":false,\"key\":\"newspaper-subscription\",\"used_addons\":[\"PayPal Standard\"],\"is_new\":false},\"28150475\":{\"name\":\"Credit Card Authorization Form Template\",\"slug\":\"credit-card-authorization-form\",\"description\":\"Automatically arrange recurring payments between the cardholder and merchant with this credit card authorization form template.\",\"id\":28150475,\"released\":\"2022-11-06 18:47:00\",\"categories\":[\"Business\",\"Business Operations\",\"Geolocation\",\"Payment\",\"Signature\",\"Stripe\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/credit-card-authorization-form\\/\",\"icon\":false,\"key\":\"credit-card-authorization\",\"used_addons\":[],\"is_new\":false},\"28194252\":{\"name\":\"Bio Writing Assistant Form Template\",\"slug\":\"bio-writing-assistant-form\",\"description\":\"Use this writing assistant to create a unique super-hero themed bio personalized to you.\",\"id\":28194252,\"released\":\"2023-04-27 18:24:39\",\"categories\":[\"AI\",\"Business\",\"Personal\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/bio-writing-assistant-form\\/\",\"icon\":false,\"key\":\"bio-writing-assistant\",\"used_addons\":[],\"is_new\":false},\"28232140\":{\"name\":\"Pregnancy Verification Form Template\",\"slug\":\"pregnancy-verification-form\",\"description\":\"Obtain information from healthcare professionals for the purpose of pregnancy verification.\",\"id\":28232140,\"released\":\"2023-11-11 05:29:00\",\"categories\":[\"Business\",\"Health and Wellness\",\"Signature\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/pregnancy-verification-form\\/\",\"icon\":false,\"key\":\"pregnancy-verification\",\"used_addons\":[\"Digital Signatures\"],\"is_new\":false},\"28052685\":{\"name\":\"Performance Improvement Plan Form Template\",\"slug\":\"performanceimprovementplan-form\",\"description\":\"Get an easier way to review and employee performance and make a plan for improvement.\",\"id\":28052685,\"released\":\"2021-04-21 11:29:02\",\"categories\":[\"Basic\",\"Business Operations\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/performanceimprovementplan-form\\/\",\"icon\":false,\"key\":\"performanceimprovementplan\",\"used_addons\":[],\"is_new\":false},\"28058573\":{\"name\":\"Partnership Agreement Form Template\",\"slug\":\"partnership-agreement-form\",\"description\":\"This form is great for recording an agreement with a partner.\",\"id\":28058573,\"released\":\"2021-07-26 15:35:46\",\"categories\":[\"Business\",\"Business Operations\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/partnership-agreement-form\\/\",\"icon\":false,\"key\":\"partnership-agreement\",\"used_addons\":[],\"is_new\":false},\"28194254\":{\"name\":\"Product Name Generator Form Template\",\"slug\":\"product-name-generator-form\",\"description\":\"Use this form template to generate many unique and fitting product names just by giving a short and simple description of your product.\",\"id\":28194254,\"released\":\"2023-04-27 18:39:17\",\"categories\":[\"AI\",\"Business\",\"Marketing\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/product-name-generator-form\\/\",\"icon\":false,\"key\":\"product-name-generator\",\"used_addons\":[],\"is_new\":false},\"28269006\":{\"name\":\"Customer Interest Survey Template\",\"slug\":\"customer-interest-survey-form\",\"description\":\"Collect customer preferences and interests with this survey form template.\",\"id\":28269006,\"released\":\"2024-03-21 16:03:20\",\"categories\":[\"Basic\",\"Business Operations\",\"Feedback\",\"Survey\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/customer-interest-survey-form\\/\",\"icon\":false,\"key\":\"customer-interest-survey\",\"used_addons\":[\"Surveys and Polls\"],\"is_new\":false},\"28168654\":{\"name\":\"Instant Estimate Form Template\",\"slug\":\"instant-estimate-form\",\"description\":\"Provide prospective clients an instant estimate requesting your services.\",\"id\":28168654,\"released\":\"2022-12-28 08:35:27\",\"categories\":[\"Business\",\"Business Operations\",\"Calculator\",\"Lead\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/instant-estimate-form\\/\",\"icon\":false,\"key\":\"instant-estimate\",\"used_addons\":[],\"is_new\":false},\"28232143\":{\"name\":\"Insurance Cancellation Form Template\",\"slug\":\"insurance-cancellation-form\",\"description\":\"Collect necessary details from policyholders who wish to request the cancellation of their insurance.\",\"id\":28232143,\"released\":\"2023-11-11 05:28:00\",\"categories\":[\"Business\",\"Business Operations\",\"Signature\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/insurance-cancellation-form\\/\",\"icon\":false,\"key\":\"insurance-cancellation\",\"used_addons\":[\"Digital Signatures\"],\"is_new\":false},\"28194256\":{\"name\":\"Book Buddy Form Template\",\"slug\":\"book-buddy-form\",\"description\":\"Use our Book Buddy form template to receive book recommendations based on former books you\'ve read.\",\"id\":28194256,\"released\":\"2023-04-27 18:45:25\",\"categories\":[\"AI\",\"Business\",\"Personal\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/book-buddy-form\\/\",\"icon\":false,\"key\":\"book-buddy\",\"used_addons\":[],\"is_new\":false},\"28194258\":{\"name\":\"AI Travel Assistant Form Template\",\"slug\":\"ai-travel-assistant-form\",\"description\":\"Get a detailed itinerary for your vacation by simply inputting some basic information.\",\"id\":28194258,\"released\":\"2023-04-27 18:53:54\",\"categories\":[\"AI\",\"Business\",\"Event Planning\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/ai-travel-assistant-form\\/\",\"icon\":false,\"key\":\"ai-travel-assistant\",\"used_addons\":[],\"is_new\":false},\"28150482\":{\"name\":\"Authorization Form Template\",\"slug\":\"authorization-form\",\"description\":\"Get authorization from an individual to release their information with an authorization form template.\",\"id\":28150482,\"released\":\"2022-11-06 16:50:00\",\"categories\":[\"Business\",\"Business Operations\",\"Geolocation\",\"Signature\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/authorization-form\\/\",\"icon\":false,\"key\":\"authorization\",\"used_addons\":[],\"is_new\":false},\"28235220\":{\"name\":\"Tumbler Order Form Template\",\"slug\":\"tumbler-order-form\",\"description\":\"Gather essential information from customers looking to place Tumbler orders.\",\"id\":28235220,\"released\":\"2023-11-11 05:15:00\",\"categories\":[\"Business\",\"Business Operations\",\"Order Form\",\"Payment\",\"Stripe\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/tumbler-order-form\\/\",\"icon\":false,\"key\":\"tumbler-order\",\"used_addons\":[\"Stripe\"],\"is_new\":false},\"28029398\":{\"name\":\"WordPress Search Form Template\",\"slug\":\"wordpress-search-form\",\"description\":\"Search your WordPress site using this simple form.\",\"id\":28029398,\"released\":\"2020-11-23 00:05:43\",\"categories\":[\"Personal\",\"Post\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/wordpress-search-form\\/\",\"icon\":false,\"key\":\"wordpress-search\",\"used_addons\":[],\"is_new\":false},\"28269015\":{\"name\":\"Market Research Survey Template\",\"slug\":\"market-research-survey-form\",\"description\":\"Collect essential data from participants in this market research survey form template.\",\"id\":28269015,\"released\":\"2024-03-21 16:45:44\",\"categories\":[\"Basic\",\"Business Operations\",\"Marketing\",\"Survey\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/market-research-survey-form\\/\",\"icon\":false,\"key\":\"market-research-survey\",\"used_addons\":[\"Surveys and Polls\"],\"is_new\":false},\"28232151\":{\"name\":\"Video Recording Consent Form Template\",\"slug\":\"video-recording-consent-form\",\"description\":\"Gather consent and important information from individuals granting permission for video recording.\",\"id\":28232151,\"released\":\"2023-11-11 05:26:00\",\"categories\":[\"Business\",\"Business Operations\",\"Consent\",\"Signature\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/video-recording-consent-form\\/\",\"icon\":false,\"key\":\"video-recording-consent\",\"used_addons\":[\"Digital Signatures\"],\"is_new\":false},\"28303576\":{\"name\":\"Youth Sports Registration Form Template\",\"slug\":\"youth-sports-registration-form\",\"description\":\"The Youth Sports Registration Form streamlines enrollment, gathering essential information for a safe and fun experience for young athletes.\",\"id\":28303576,\"released\":\"2024-11-24 13:33:32\",\"categories\":[\"Business\",\"Calculator\",\"Datepicker\",\"Event Planning\",\"Geolocation\",\"Multi-Page\",\"Nonprofit\",\"PayPal\",\"Registration and Signup\",\"Repeater Field\",\"Signature\",\"Stripe\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/youth-sports-registration-form\\/\",\"icon\":false,\"key\":\"youth-sports-registration\",\"used_addons\":[\"Datepicker Options\",\"PayPal Standard\",\"Stripe\"],\"is_new\":false},\"28052697\":{\"name\":\"Alumni Donation Template\",\"slug\":\"alumni-donation-form\",\"description\":\"Are you hoping for donations to your school? If so, this is the form for you.\",\"id\":28052697,\"released\":\"2021-04-01 15:50:54\",\"categories\":[\"Business\",\"Nonprofit\",\"Payment\",\"PayPal\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/alumni-donation-form\\/\",\"icon\":false,\"key\":\"alumni-donation\",\"used_addons\":[],\"is_new\":false},\"28316378\":{\"name\":\"Hotel Reservation Form Template\",\"slug\":\"hotel-reservation-form\",\"description\":\"Streamline hotel bookings by collecting guest details, reservation dates, and payments with this form.\",\"id\":28316378,\"released\":\"2025-03-21 12:19:33\",\"categories\":[\"Business\",\"Business Operations\",\"Event Planning\",\"Payment\",\"Registration and Signup\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/hotel-reservation-form\\/\",\"icon\":false,\"key\":\"hotel-reservation\",\"used_addons\":[\"Authorize.net AIM\"],\"is_new\":true},\"28303579\":{\"name\":\"Online RSVP Birthday Party Form Template\",\"slug\":\"online-rsvp-birthday-party-form\",\"description\":\"The Online RSVP Birthday Party Form makes it easy for guests to confirm their attendance and share any special requests for a fun celebration!\",\"id\":28303579,\"released\":\"2024-11-24 13:44:17\",\"categories\":[\"Basic\",\"Event Planning\",\"Request\",\"Survey\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/online-rsvp-birthday-party-form\\/\",\"icon\":false,\"key\":\"online-rsvp-birthday-party\",\"used_addons\":[],\"is_new\":false},\"28307678\":{\"name\":\"Personal Training Client Intake Form\",\"slug\":\"personal-training-client-intake-form\",\"description\":\"This template is crafted to collect vital information from new clients in personal training. It features sections for personal information, fitness objectives, medical background, and current workout practices. Perfect for personal trainers and fitness coaches.\",\"id\":28307678,\"released\":\"2025-01-07 11:55:29\",\"categories\":[\"Business\",\"Business Operations\",\"Consent\",\"Datepicker\",\"Elite\",\"Health and Wellness\",\"Lifestyle\",\"Registration and Signup\",\"Signature\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/personal-training-client-intake-form\\/\",\"icon\":false,\"key\":\"personal-training-client-intake\",\"used_addons\":[\"Digital Signatures\"],\"is_new\":false},\"28310494\":{\"name\":\"General Contract Form Template\",\"slug\":\"general-contract-form\",\"description\":\"This General Contract Form serves as a legally binding agreement outlining the terms, responsibilities, and obligations between all parties involved.\",\"id\":28310494,\"released\":\"2025-01-31 14:42:12\",\"categories\":[\"Business\",\"Business Operations\",\"Signature\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/general-contract-form\\/\",\"icon\":false,\"key\":\"general-contract\",\"used_addons\":[\"Digital Signatures\"],\"is_new\":false},\"28303583\":{\"name\":\"High School Reunion Registration Form Template\",\"slug\":\"high-school-reunion-registration-form\",\"description\":\"The High School Reunion Registration Form allows alumni to easily register and stay connected for an unforgettable reunion celebration!\",\"id\":28303583,\"released\":\"2024-11-24 14:08:40\",\"categories\":[\"Business\",\"Event Planning\",\"Payment\",\"PayPal\",\"Registration and Signup\",\"Repeater Field\",\"Survey\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/high-school-reunion-registration-form\\/\",\"icon\":false,\"key\":\"high-school-reunion-registration\",\"used_addons\":[\"PayPal Standard\",\"Stripe\"],\"is_new\":false},\"28055776\":{\"name\":\"Employee Engagement Survey Template\",\"slug\":\"employee-engagement-survey-form\",\"description\":\"Use this survey to find our how employees feel about their jobs.\",\"id\":28055776,\"released\":\"2021-06-28 13:33:52\",\"categories\":[\"Business\",\"Business Operations\",\"Survey\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/employee-engagement-survey-form\\/\",\"icon\":false,\"key\":\"employee-engagement-survey\",\"used_addons\":[],\"is_new\":false},\"28057313\":{\"name\":\"Management Performance Survey Template\",\"slug\":\"management-performance-survey-form\",\"description\":\"Collect feedback on your management from employees they supervise.\",\"id\":28057313,\"released\":\"2021-05-01 13:50:24\",\"categories\":[\"Business Operations\",\"Personal\",\"Survey\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/management-performance-survey-form\\/\",\"icon\":false,\"key\":\"management-performance-survey\",\"used_addons\":[],\"is_new\":false},\"28303585\":{\"name\":\"Auction Item Registration Form Template\",\"slug\":\"auction-item-registration-form\",\"description\":\"The Auction Item Registration Form simplifies the process for participants to submit items for auction, ensuring a smooth and organized event!\",\"id\":28303585,\"released\":\"2024-11-24 14:56:11\",\"categories\":[\"Business\",\"Business Operations\",\"Event Planning\",\"File Upload\",\"Registration and Signup\",\"Signature\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/auction-item-registration-form\\/\",\"icon\":false,\"key\":\"auction-item-registration\",\"used_addons\":[],\"is_new\":false},\"28310498\":{\"name\":\"Gallery Form Template\",\"slug\":\"gallery-form\",\"description\":\"Efficiently allow artists to submit their work and grant necessary permissions for display.\",\"id\":28310498,\"released\":\"2025-01-31 14:53:27\",\"categories\":[\"Basic\",\"Business Operations\",\"Consent\",\"File Upload\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/gallery-form\\/\",\"icon\":false,\"key\":\"gallery\",\"used_addons\":[],\"is_new\":false},\"28030947\":{\"name\":\"Deadline Calculator Template\",\"slug\":\"deadline-calculator-form\",\"description\":\"Calculate deadlines in seconds. Add or subtract days from a date to calculate a new date.\",\"id\":28030947,\"released\":\"2020-11-23 00:00:29\",\"categories\":[\"Business\",\"Calculator\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/deadline-calculator-form\\/\",\"icon\":false,\"key\":\"deadline-calculator\",\"used_addons\":[],\"is_new\":false},\"28145636\":{\"name\":\"Consent Form Template\",\"slug\":\"consent-form\",\"description\":\"Capture participant\\u2019s information and signature with this consent form.\",\"id\":28145636,\"released\":\"2022-11-06 22:00:00\",\"categories\":[\"Business\",\"Business Operations\",\"Consent\",\"Signature\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/consent-form\\/\",\"icon\":false,\"key\":\"consent\",\"used_addons\":[\"Digital Signatures\"],\"is_new\":false},\"20910309\":{\"name\":\"House Inventory Form\",\"slug\":\"house-inventory-form\",\"description\":\"A simple form to keep track of household items, as well as value, condition, and make\\/model numbers.\",\"id\":20910309,\"released\":\"2019-11-24 23:00:57\",\"categories\":[\"Basic\",\"Business Operations\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/house-inventory-form\\/\",\"icon\":false,\"key\":\"house-inventory\",\"used_addons\":[],\"is_new\":false},\"28030949\":{\"name\":\"T-Shirt Order Form Template\",\"slug\":\"t-shirt-order-form\",\"description\":\"Let customers select and order multiple t-shirts in the colors and sizes the want.\",\"id\":28030949,\"released\":\"2020-11-23 00:00:49\",\"categories\":[\"Business\",\"Calculator\",\"Order Form\",\"Payment\",\"PayPal\",\"Stripe\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/t-shirt-order-form\\/\",\"icon\":false,\"key\":\"t-shirt-order\",\"used_addons\":[\"PayPal Standard\",\"Stripe\"],\"is_new\":false},\"20910310\":{\"name\":\"Dinner Reservation Form\",\"slug\":\"dinner-reservation-form\",\"description\":\"Simply take reservations at a restaurant.\",\"id\":20910310,\"released\":\"2019-11-24 23:00:43\",\"categories\":[\"Basic\",\"Business Operations\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/dinner-reservation-form\\/\",\"icon\":false,\"key\":\"dinner-reservation\",\"used_addons\":[],\"is_new\":false},\"28174310\":{\"name\":\"360 Degree Feedback Template\",\"slug\":\"360-degree-feedback-form\",\"description\":\"This short and quick survey is an easy way to acquire information from employees.\",\"id\":28174310,\"released\":\"2023-01-26 19:21:52\",\"categories\":[\"Basic\",\"Feedback\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/360-degree-feedback-form\\/\",\"icon\":false,\"key\":\"360-degree-feedback\",\"used_addons\":[],\"is_new\":false},\"28239335\":{\"name\":\"Blood Alcohol Content Calculator Template\",\"slug\":\"blood-alcohol-content-calculator-form\",\"description\":\"Collect necessary information from users to calculate Blood Alcohol Content.\",\"id\":28239335,\"released\":\"2023-11-16 14:42:32\",\"categories\":[\"Business\",\"Calculator\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/blood-alcohol-content-calculator-form\\/\",\"icon\":false,\"key\":\"blood-alcohol-content-calculator\",\"used_addons\":[],\"is_new\":false},\"28145640\":{\"name\":\"Waiver Form Template\",\"slug\":\"waiver-form\",\"description\":\"Have participants sign and agree to any unforeseen injury\\/risks involved with the activity using the waiver form.\",\"id\":28145640,\"released\":\"2022-11-06 22:00:00\",\"categories\":[\"Business\",\"Education\",\"Signature\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/waiver-form\\/\",\"icon\":false,\"key\":\"waiver\",\"used_addons\":[\"Digital Signatures\"],\"is_new\":false},\"28149480\":{\"name\":\"Employee Discipline Form Template\",\"slug\":\"employee-discipline-form\",\"description\":\"When an employee intentionally violates the rules and policies of the company they are working for, use this Employee Discipline form to submit a report.\",\"id\":28149480,\"released\":\"2022-11-06 16:24:00\",\"categories\":[\"Business\",\"Business Operations\",\"Signature\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/employee-discipline-form\\/\",\"icon\":false,\"key\":\"employee-discipline\",\"used_addons\":[],\"is_new\":false},\"28237032\":{\"name\":\"Cubic Yard Calculator Template\",\"slug\":\"cubic-yard-calculator-form\",\"description\":\"Gather input data from users to calculate cubic yardage quickly and accurately.\",\"id\":28237032,\"released\":\"2023-11-11 05:04:00\",\"categories\":[\"Business\",\"Calculator\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/cubic-yard-calculator-form\\/\",\"icon\":false,\"key\":\"cubic-yard-calculator\",\"used_addons\":[],\"is_new\":false},\"28310504\":{\"name\":\"Personal Budget Planner Form Template\",\"slug\":\"personal-budget-planner-form\",\"description\":\"Easily track income, expenses, and savings to manage your finances effectively\",\"id\":28310504,\"released\":\"2025-01-31 15:00:49\",\"categories\":[\"Business\",\"Calculator\",\"Finance\",\"Lifestyle\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/personal-budget-planner-form\\/\",\"icon\":false,\"key\":\"personal-budget-planner\",\"used_addons\":[],\"is_new\":false},\"28145641\":{\"name\":\"Deposit Form Template\",\"slug\":\"deposit-form\",\"description\":\"Issue a receipt for funds accepted through cash deposit, checks, money order, and cashier\\u2019s check.\",\"id\":28145641,\"released\":\"2022-11-06 22:00:00\",\"categories\":[\"Business\",\"Business Operations\",\"Calculator\",\"Finance\",\"Payment\",\"Signature\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/deposit-form\\/\",\"icon\":false,\"key\":\"deposit\",\"used_addons\":[\"Digital Signatures\"],\"is_new\":false},\"28149481\":{\"name\":\"Entry Form Template\",\"slug\":\"entry-form\",\"description\":\"Collect entries for contests, competitions, or events, and let users upload their entry.\",\"id\":28149481,\"released\":\"2022-11-06 16:34:00\",\"categories\":[\"Basic\",\"Marketing\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/entry-form\\/\",\"icon\":false,\"key\":\"entry\",\"used_addons\":[],\"is_new\":false},\"28145642\":{\"name\":\"Requisition Form Template\",\"slug\":\"requisition-form\",\"description\":\"Specify details about the requested items with the requisition form.\",\"id\":28145642,\"released\":\"2022-11-06 22:00:00\",\"categories\":[\"Basic\",\"Business Operations\",\"File Upload\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/requisition-form\\/\",\"icon\":false,\"key\":\"requisition\",\"used_addons\":[],\"is_new\":false},\"28315115\":{\"name\":\"LLC Resolution Form Template\",\"slug\":\"llc-resolution-form\",\"description\":\"Formalize and record important business decisions with this LLC Resolution Form for official company documentation.\",\"id\":28315115,\"released\":\"2025-03-10 13:56:31\",\"categories\":[\"Business\",\"Business Operations\",\"File Upload\",\"Repeater Field\",\"Signature\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/llc-resolution-form\\/\",\"icon\":false,\"key\":\"llc-resolution\",\"used_addons\":[\"Digital Signatures\"],\"is_new\":true},\"28315119\":{\"name\":\"Donation Receipt Form Template\",\"slug\":\"donation-receipt-form\",\"description\":\"Provide donors with a formal receipt for their contributions, ensuring proper documentation for tax and record-keeping purposes.\",\"id\":28315119,\"released\":\"2025-03-10 14:19:27\",\"categories\":[\"Basic\",\"Multi-Page\",\"Nonprofit\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/donation-receipt-form\\/\",\"icon\":false,\"key\":\"donation-receipt\",\"used_addons\":[],\"is_new\":true},\"28176880\":{\"name\":\"Branding Questionnaire Form Template\",\"slug\":\"branding-questionnaire-form\",\"description\":\"An easy questionnaire to help determine all you need to know about your client\'s business and branding choices.\",\"id\":28176880,\"released\":\"2023-02-07 17:50:28\",\"categories\":[\"Basic\",\"Business Operations\",\"Multi-Page\",\"Survey\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/branding-questionnaire-form\\/\",\"icon\":false,\"key\":\"branding-questionnaire\",\"used_addons\":[\"Surveys and Polls\"],\"is_new\":false},\"20905713\":{\"name\":\"Order\\/Billing Form Template\",\"slug\":\"order-billing-form\",\"description\":\"A simple order form to start collecting payments fast.\",\"id\":20905713,\"released\":\"2019-11-24 23:00:32\",\"categories\":[\"Business\",\"Order Form\",\"Payment\",\"PayPal\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/order-billing-form\\/\",\"icon\":false,\"key\":\"order-billing\",\"used_addons\":[\"PayPal Standard\"],\"is_new\":false},\"20909555\":{\"name\":\"New Years Party RSVP Form\",\"slug\":\"new-years-party-rsvp-form\",\"description\":\"Provides an easy way to keep tack of guests of an upcoming New Years Party.\",\"id\":20909555,\"released\":\"2019-11-24 23:00:01\",\"categories\":[\"Event Planning\",\"free\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/new-years-party-rsvp-form\\/\",\"icon\":false,\"key\":\"new-years-party-rsvp\",\"used_addons\":[],\"is_new\":false},\"28198899\":{\"name\":\"Love Language Quiz Form Template\",\"slug\":\"love-language-quiz-form\",\"description\":\"Discover your love language and enhance your connections. Take our quiz to understand how you express and receive love.\",\"id\":28198899,\"released\":\"2023-05-30 18:32:58\",\"categories\":[\"Business\",\"Conversational Forms\",\"Quiz\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/love-language-quiz-form\\/\",\"icon\":false,\"key\":\"love-language-quiz\",\"used_addons\":[\"Conversational Forms\",\"Quiz Maker\"],\"is_new\":false},\"20909556\":{\"name\":\"Birthday Party RSVP Form\",\"slug\":\"birthday-party-invitation-rsvp-form\",\"description\":\"A simple form to keep track of who\'s coming to a Birthday celebration.\",\"id\":20909556,\"released\":\"2019-11-24 23:00:40\",\"categories\":[\"Event Planning\",\"free\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/birthday-party-invitation-rsvp-form\\/\",\"icon\":false,\"key\":\"birthday-party-invitation-rsvp\",\"used_addons\":[],\"is_new\":false},\"28220148\":{\"name\":\"A\\/B Testing Calculator\",\"slug\":\"ab-testing-calculator-form\",\"description\":\"Quickly analyze A\\/B test outcomes with our calculator.\",\"id\":28220148,\"released\":\"2023-11-11 02:55:00\",\"categories\":[\"Business\",\"Business Operations\",\"Calculator\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/ab-testing-calculator-form\\/\",\"icon\":false,\"key\":\"ab-testing-calculator\",\"used_addons\":[],\"is_new\":false},\"28198901\":{\"name\":\"AI Customer Support Form Template\",\"slug\":\"ai-customer-support-form\",\"description\":\"Our Customer Support Form efficiently collects essential information and addresses inquiries. Gather personal details and select the inquiry type for efficient handling.\",\"id\":28198901,\"released\":\"2023-05-30 17:49:52\",\"categories\":[\"AI\",\"Business\",\"Customer Service\",\"Feedback\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/ai-customer-support-form\\/\",\"icon\":false,\"key\":\"ai-customer-support\",\"used_addons\":[],\"is_new\":false},\"28098549\":{\"name\":\"Spelling Quiz Template\",\"slug\":\"spelling-quiz-form\",\"description\":\"Track student progress online with the spelling quiz form template.\",\"id\":28098549,\"released\":\"2022-03-01 13:50:10\",\"categories\":[\"Business\",\"Conversational Forms\",\"Education\",\"Quiz\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/spelling-quiz-form\\/\",\"icon\":false,\"key\":\"spelling-quiz\",\"used_addons\":[\"Conversational Forms\",\"Quiz Maker\"],\"is_new\":false},\"28173813\":{\"name\":\"Free Estimate Form Template\",\"slug\":\"free-estimate-form\",\"description\":\"Whether you\'re in construction or any industry, use this template to generate the estimated cost for your customer\'s needs.\",\"id\":28173813,\"released\":\"2023-01-24 16:56:38\",\"categories\":[\"Business\",\"Business Operations\",\"Calculator\",\"Conversational Forms\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/free-estimate-form\\/\",\"icon\":false,\"key\":\"free-estimate\",\"used_addons\":[],\"is_new\":false},\"20874742\":{\"name\":\"PayPal Donation Form Template\",\"slug\":\"paypal-donation-form\",\"description\":\"Easily and securely collect PayPal donations from anyone.\",\"id\":20874742,\"released\":\"2019-01-01 13:13:24\",\"categories\":[\"Business\",\"Nonprofit\",\"Payment\",\"PayPal\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/paypal-donation-form\\/\",\"icon\":false,\"key\":\"paypal-donation\",\"used_addons\":[\"PayPal Standard\"],\"is_new\":false},\"20874743\":{\"name\":\"Simple User Registration Form Template\",\"slug\":\"simple-user-registration-form\",\"description\":\"The perfect minimalistic approach to user registration. Make the registration process as simple as possible.\",\"id\":20874743,\"released\":\"2019-01-01 13:24:20\",\"categories\":[\"Business\",\"User Registration\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/simple-user-registration-form\\/\",\"icon\":false,\"key\":\"simple-user-registration\",\"used_addons\":[\"User Registration\"],\"is_new\":false},\"28028151\":{\"name\":\"Restaurant Evaluation Survey Template\",\"slug\":\"restaurant-evaluation-survey-form\",\"description\":\"Get feedback and ratings from customers on the quality of your services.\",\"id\":28028151,\"released\":\"2020-11-23 00:01:21\",\"categories\":[\"Basic\",\"Business Operations\",\"Feedback\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/restaurant-evaluation-survey-form\\/\",\"icon\":false,\"key\":\"restaurant-evaluation-survey\",\"used_addons\":[],\"is_new\":false},\"28297975\":{\"name\":\"User Review Form Template\",\"slug\":\"user-review-form\",\"description\":\"Efficiently collect reviews from customers with this User Review Form Template.\",\"id\":28297975,\"released\":\"2024-10-08 12:28:46\",\"categories\":[\"Basic\",\"Feedback\",\"File Upload\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/user-review-form\\/\",\"icon\":false,\"key\":\"user-review\",\"used_addons\":[],\"is_new\":false},\"28237047\":{\"name\":\"Drywall Calculator Template\",\"slug\":\"drywall-calculator-form\",\"description\":\"Collect project-specific details from users to calculate drywall requirements efficiently.\",\"id\":28237047,\"released\":\"2023-11-11 04:03:00\",\"categories\":[\"Business\",\"Calculator\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/drywall-calculator-form\\/\",\"icon\":false,\"key\":\"drywall-calculator\",\"used_addons\":[],\"is_new\":false},\"20905719\":{\"name\":\"Rent Receipt Form Template\",\"slug\":\"rent-receipt-form\",\"description\":\"Track tenant payment information using the rent receipt form.\",\"id\":20905719,\"released\":\"2019-11-24 23:00:00\",\"categories\":[\"Business Operations\",\"Personal\",\"Real Estate\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/rent-receipt-form\\/\",\"icon\":false,\"key\":\"rent-receipt\",\"used_addons\":[],\"is_new\":false},\"28311800\":{\"name\":\"Patient Information Form Template\",\"slug\":\"patient-information-form\",\"description\":\"Securely collect and manage patient details with this Patient Information Form Template.\",\"id\":28311800,\"released\":\"2025-02-10 11:51:34\",\"categories\":[\"Basic\",\"Health and Wellness\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/patient-information-form\\/\",\"icon\":false,\"key\":\"patient-information\",\"used_addons\":[],\"is_new\":false},\"20909560\":{\"name\":\"Football League Registration Form Template\",\"slug\":\"football-league-registration-form\",\"description\":\"An easy form for registering players for a football league including positions, desired team, and other information.more\",\"id\":20909560,\"released\":\"2019-11-24 23:00:55\",\"categories\":[\"Basic\",\"Registration and Signup\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/football-league-registration-form\\/\",\"icon\":false,\"key\":\"football-league-registration\",\"used_addons\":[],\"is_new\":false},\"20905720\":{\"name\":\"Request A Quote Form Template\",\"slug\":\"request-a-quote-form\",\"description\":\"Get information from potential customers who are requesting for a quote on your services.\",\"id\":20905720,\"released\":\"2019-11-24 23:00:18\",\"categories\":[\"Business Operations\",\"Contact\",\"free\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/request-a-quote-form\\/\",\"icon\":false,\"key\":\"request-a-quote\",\"used_addons\":[],\"is_new\":false},\"28028153\":{\"name\":\"Counseling Intake Form Template\",\"slug\":\"counselling-client-intake-form\",\"description\":\"Automate the process of gathering information from your clients and reduce paperwork with this intake form\",\"id\":28028153,\"released\":\"2020-11-23 00:01:11\",\"categories\":[\"Business\",\"Health and Wellness\",\"Multi-Page\",\"Signature\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/counselling-client-intake-form\\/\",\"icon\":false,\"key\":\"counselling-client-intake\",\"used_addons\":[\"Digital Signatures\"],\"is_new\":false},\"20909562\":{\"name\":\"Poll Form\",\"slug\":\"poll-form\",\"description\":\"A simple way to take a poll of likes, dislikes, or favorites.\",\"id\":20909562,\"released\":\"2019-11-24 23:00:49\",\"categories\":[\"Personal\",\"Survey\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/poll-form\\/\",\"icon\":[\"https:\\/\\/formidableforms.com\\/wp-content\\/uploads\\/2019\\/11\\/poll-form-template.jpg\",650,288,false],\"key\":\"poll\",\"used_addons\":[\"Surveys and Polls\"],\"is_new\":false},\"20874746\":{\"name\":\"Mortgage Application Form Template\",\"slug\":\"mortgage-application-form\",\"description\":\"A complete and professional mortgage application form template to allow individuals to easily apply for mortgages on your site.\",\"id\":20874746,\"released\":\"2019-01-01 12:46:47\",\"categories\":[\"Application\",\"Business\",\"Real Estate\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/mortgage-application-form\\/\",\"icon\":false,\"key\":\"mortgage-application\",\"used_addons\":[],\"is_new\":false},\"20909563\":{\"name\":\"Enrollment Form Template\",\"slug\":\"enrollment-form\",\"description\":\"A form for quick and easy enrollment into a school system.\",\"id\":20909563,\"released\":\"2019-11-24 23:00:22\",\"categories\":[\"Basic\",\"Education\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/enrollment-form\\/\",\"icon\":false,\"key\":\"enrollment\",\"used_addons\":[],\"is_new\":false},\"28315131\":{\"name\":\"Thanksgiving Menu Form Template\",\"slug\":\"thanksgiving-menu-form\",\"description\":\"Plan and organize a Thanksgiving feast by collecting menu selections and dietary preferences with this convenient form.\",\"id\":28315131,\"released\":\"2025-03-10 15:38:01\",\"categories\":[\"Basic\",\"Event Planning\",\"Survey\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/thanksgiving-menu-form\\/\",\"icon\":false,\"key\":\"thanksgiving-menu\",\"used_addons\":[],\"is_new\":true},\"28196091\":{\"name\":\"Trivia Form Template\",\"slug\":\"trivia-form\",\"description\":\"The trivia form template challenges your knowledge on a variety of topics and will give you your score at the end.\",\"id\":28196091,\"released\":\"2023-05-08 11:52:40\",\"categories\":[\"Business\",\"Quiz\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/trivia-form\\/\",\"icon\":false,\"key\":\"trivia\",\"used_addons\":[\"Quiz Maker\"],\"is_new\":false},\"20909564\":{\"name\":\"Recipe Catalog Form Template\",\"slug\":\"recipe-catalog-form\",\"description\":\"Keep track of favorite recipes or create a conglomerate of those of friends and family.\",\"id\":20909564,\"released\":\"2019-11-24 23:00:24\",\"categories\":[\"free\",\"Health and Wellness\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/recipe-catalog-form\\/\",\"icon\":false,\"key\":\"recipe-catalog\",\"used_addons\":[],\"is_new\":false},\"20874748\":{\"name\":\"User Registration Form Template\",\"slug\":\"user-registration-form\",\"description\":\"Let users register on the front-end of your site and set their username, email, password, name, and avatar.\",\"id\":20874748,\"released\":\"2019-01-01 13:14:35\",\"categories\":[\"Business\",\"File Upload\",\"User Registration\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/user-registration-form\\/\",\"icon\":false,\"key\":\"user-registration\",\"used_addons\":[\"User Registration\"],\"is_new\":false},\"20874749\":{\"name\":\"Travel Booking Form Template\",\"slug\":\"travel-booking-form\",\"description\":\"Setting up a travel website? Plan-ahead ride service? Allow your users to easily reserve travel services.\",\"id\":20874749,\"released\":\"2019-01-01 12:53:00\",\"categories\":[\"Business\",\"Event Planning\",\"Multi-Page\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/travel-booking-form\\/\",\"icon\":false,\"key\":\"travel-booking\",\"used_addons\":[],\"is_new\":false},\"28028157\":{\"name\":\"Client Intake Form Template\",\"slug\":\"client-intake-form\",\"description\":\"Capture valuable information during the client intake process.\",\"id\":28028157,\"released\":\"2020-11-23 00:05:11\",\"categories\":[\"Business\",\"Business Operations\",\"Customer Service\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/client-intake-form\\/\",\"icon\":false,\"key\":\"client-intake\",\"used_addons\":[],\"is_new\":false},\"28019198\":{\"name\":\"Release Form Template\",\"slug\":\"release-form\",\"description\":\"A simple standard release form template.\",\"id\":28019198,\"released\":\"2020-09-14 10:42:09\",\"categories\":[\"Business\",\"Business Operations\",\"Signature\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/release-form\\/\",\"icon\":false,\"key\":\"release\",\"used_addons\":[\"Digital Signatures\"],\"is_new\":false},\"28215806\":{\"name\":\"Geography Quiz Template\",\"slug\":\"geography-quiz-form\",\"description\":\"Test your geography knowledge with this 15-question multiple-choice quiz.\",\"id\":28215806,\"released\":\"2023-09-08 16:48:53\",\"categories\":[\"Business\",\"Education\",\"Quiz\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/geography-quiz-form\\/\",\"icon\":false,\"key\":\"geography-quiz\",\"used_addons\":[\"Quiz Maker\"],\"is_new\":false},\"20909567\":{\"name\":\"Grade Book Form Template\",\"slug\":\"gradebook-form\",\"description\":\"Keep track of grades all in one place.\",\"id\":20909567,\"released\":\"2019-11-24 23:00:14\",\"categories\":[\"Education\",\"free\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/gradebook-form\\/\",\"icon\":false,\"key\":\"gradebook\",\"used_addons\":[],\"is_new\":false},\"28254719\":{\"name\":\"Airbnb Reservation Information Form Template\",\"slug\":\"airbnb-reservation-information-form\",\"description\":\"Collect details from guests who are booking your Airbnb property.\",\"id\":28254719,\"released\":\"2024-01-18 12:23:11\",\"categories\":[\"Basic\",\"Business Operations\",\"Real Estate\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/airbnb-reservation-information-form\\/\",\"icon\":false,\"key\":\"airbnb-reservation-information\",\"used_addons\":[],\"is_new\":false},\"20874751\":{\"name\":\"Volunteer Recruitment Application Form\",\"slug\":\"volunteer-recruitment-application-form\",\"description\":\"Collect scheduling details, contact information, and relevant experience from volunteer applicants.\",\"id\":20874751,\"released\":\"2019-01-01 13:21:01\",\"categories\":[\"Application\",\"Business\",\"Multi-Page\",\"Nonprofit\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/volunteer-recruitment-application-form\\/\",\"icon\":false,\"key\":\"volunteer-recruitment-application\",\"used_addons\":[],\"is_new\":false},\"28019199\":{\"name\":\"Time Off Request Form Template\",\"slug\":\"time-off-request-form\",\"description\":\"A form for tracking time off of employees.\",\"id\":28019199,\"released\":\"2020-09-24 08:04:22\",\"categories\":[\"Basic\",\"Business Operations\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/time-off-request-form\\/\",\"icon\":false,\"key\":\"time-off-request\",\"used_addons\":[],\"is_new\":false},\"28031313\":{\"name\":\"Church Donation Form Template\",\"slug\":\"church-donation-form\",\"description\":\"Collect donations for your church or a cause with Stripe credit card payments.\",\"id\":28031313,\"released\":\"2020-12-01 00:01:57\",\"categories\":[\"Business\",\"Nonprofit\",\"Payment\",\"Stripe\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/church-donation-form\\/\",\"icon\":false,\"key\":\"church-donation\",\"used_addons\":[\"Stripe\"],\"is_new\":false},\"28052355\":{\"name\":\"Girl Scout Cookie Order Form Template\",\"slug\":\"girl-scout-cookie-order-form\",\"description\":\"Want a better way to sell Girl Scout cookies? Collect orders without knocking on doors or sitting outside the grocery store.\",\"id\":28052355,\"released\":\"2021-03-31 17:18:05\",\"categories\":[\"Business\",\"Business Operations\",\"Order Form\",\"Payment\",\"Stripe\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/girl-scout-cookie-order-form\\/\",\"icon\":false,\"key\":\"girl-scout-cookie-order\",\"used_addons\":[\"Stripe\"],\"is_new\":false},\"20874729\":{\"name\":\"Advanced Mortgage Calculator Template\",\"slug\":\"advanced-mortgage-calculator-form\",\"description\":\"Get an advanced, in-depth financial analysis on a new mortgage.\",\"id\":20874729,\"released\":\"2019-01-01 12:11:07\",\"categories\":[\"Business\",\"Calculator\",\"Finance\",\"Real Estate\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/advanced-mortgage-calculator-form\\/\",\"icon\":false,\"key\":\"advanced-mortgage-calculator\",\"used_addons\":[],\"is_new\":false},\"20908994\":{\"name\":\"Complaint Form Template\",\"slug\":\"complaint-form\",\"description\":\"A better way to allow customers or employees to submit their complaints.\",\"id\":20908994,\"released\":\"2019-11-24 23:00:11\",\"categories\":[\"Basic\",\"Customer Service\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/complaint-form\\/\",\"icon\":false,\"key\":\"complaint\",\"used_addons\":[],\"is_new\":false},\"response_code\":200}\";s:7:\"version\";s:4:\"6.19\";}","off");

INSERT IGNORE INTO `wp_options` VALUES 
("2310","frm_connect_token","29f83b64c758a4acfbdfa07baf0dab94a71877e41c822371de58f0e6be852e1e39827c172c8bfc9cf80793097fa717d6fed06eabe15486c607867ec019f6222b","off"),
("2509","odyssey_stats_admin_asset_cache_buster","{\"cache_buster\":\"04e18f00a66\",\"cached_at\":1753561592086}","off"),
("2510","neve_notice_dismissed","yes","auto"),
("3133","jetpack_log","a:16:{i:0;a:5:{s:4:\"time\";i:1743519391;s:7:\"user_id\";i:0;s:7:\"blog_id\";s:9:\"242379716\";s:4:\"code\";s:11:\"autoupdates\";s:4:\"data\";a:3:{s:7:\"results\";a:2:{s:6:\"plugin\";a:2:{i:0;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":14:{s:2:\"id\";s:23:\"w.org/plugins/elementor\";s:4:\"slug\";s:9:\"elementor\";s:6:\"plugin\";s:23:\"elementor/elementor.php\";s:11:\"new_version\";s:6:\"3.28.3\";s:3:\"url\";s:40:\"https://wordpress.org/plugins/elementor/\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.28.3.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:62:\"https://ps.w.org/elementor/assets/icon-256x256.gif?rev=3111597\";s:2:\"1x\";s:62:\"https://ps.w.org/elementor/assets/icon-128x128.gif?rev=3111597\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:65:\"https://ps.w.org/elementor/assets/banner-1544x500.png?rev=3164133\";s:2:\"1x\";s:64:\"https://ps.w.org/elementor/assets/banner-772x250.png?rev=3164133\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"6.5\";s:6:\"tested\";s:5:\"6.7.2\";s:12:\"requires_php\";s:3:\"7.4\";s:16:\"requires_plugins\";a:0:{}s:15:\"current_version\";s:6:\"3.28.2\";}s:6:\"result\";b:1;s:4:\"name\";s:9:\"Elementor\";s:8:\"messages\";a:6:{i:0;s:42:\"Mise à jour de l’extension : Elementor\";i:1;s:105:\"Téléchargement de la mise à jour depuis https://downloads.wordpress.org/plugin/elementor.3.28.3.zip…\";i:2;s:40:\"Décompression de la mise à jour&#8230;\";i:3;s:43:\"Installation de la dernière version&#8230;\";i:4;s:55:\"Retrait de l’ancienne version de l’extension&#8230;\";i:5;s:40:\"L’extension a bien été mise à jour.\";}}i:1;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":14:{s:2:\"id\";s:27:\"w.org/plugins/wordpress-seo\";s:4:\"slug\";s:13:\"wordpress-seo\";s:6:\"plugin\";s:24:\"wordpress-seo/wp-seo.php\";s:11:\"new_version\";s:4:\"24.8\";s:3:\"url\";s:44:\"https://wordpress.org/plugins/wordpress-seo/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.24.8.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:66:\"https://ps.w.org/wordpress-seo/assets/icon-256x256.gif?rev=3112542\";s:2:\"1x\";s:66:\"https://ps.w.org/wordpress-seo/assets/icon-128x128.gif?rev=3112542\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:69:\"https://ps.w.org/wordpress-seo/assets/banner-1544x500.png?rev=3257862\";s:2:\"1x\";s:68:\"https://ps.w.org/wordpress-seo/assets/banner-772x250.png?rev=3257862\";}s:11:\"banners_rtl\";a:2:{s:2:\"2x\";s:73:\"https://ps.w.org/wordpress-seo/assets/banner-1544x500-rtl.png?rev=3257862\";s:2:\"1x\";s:72:\"https://ps.w.org/wordpress-seo/assets/banner-772x250-rtl.png?rev=3257862\";}s:8:\"requires\";s:3:\"6.6\";s:6:\"tested\";s:5:\"6.7.2\";s:12:\"requires_php\";s:5:\"7.2.5\";s:16:\"requires_plugins\";a:0:{}s:15:\"current_version\";s:4:\"24.7\";}s:6:\"result\";b:1;s:4:\"name\";s:9:\"Yoast SEO\";s:8:\"messages\";a:6:{i:0;s:42:\"Mise à jour de l’extension : Yoast SEO\";i:1;s:107:\"Téléchargement de la mise à jour depuis https://downloads.wordpress.org/plugin/wordpress-seo.24.8.zip…\";i:2;s:40:\"Décompression de la mise à jour&#8230;\";i:3;s:43:\"Installation de la dernière version&#8230;\";i:4;s:55:\"Retrait de l’ancienne version de l’extension&#8230;\";i:5;s:40:\"L’extension a bien été mise à jour.\";}}}s:11:\"translation\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":7:{s:4:\"type\";s:6:\"plugin\";s:4:\"slug\";s:13:\"wordpress-seo\";s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:4:\"24.8\";s:7:\"updated\";s:19:\"2025-04-01 08:12:23\";s:7:\"package\";s:79:\"https://downloads.wordpress.org/translation/plugin/wordpress-seo/24.8/fr_FR.zip\";s:10:\"autoupdate\";b:1;}s:6:\"result\";a:7:{s:6:\"source\";s:56:\"/srv/htdocs/wp-content/upgrade/wordpress-seo-24.8-fr_fr/\";s:12:\"source_files\";a:36:{i:0;s:57:\"wordpress-seo-fr_FR-3ab1863386cca0be6ab4aa906cacadbd.json\";i:1;s:57:\"wordpress-seo-fr_FR-4293cf3571f532bb11ff1676090ec5e7.json\";i:2;s:57:\"wordpress-seo-fr_FR-d6c61f7884baaf8a18b31ca41ef1420f.json\";i:3;s:57:\"wordpress-seo-fr_FR-826f41c23138627439d01b2b0133dbc5.json\";i:4;s:57:\"wordpress-seo-fr_FR-6ffccefef7026e678d85c6b56bd29680.json\";i:5;s:57:\"wordpress-seo-fr_FR-c1a0e4b150b113a514f162d42c0c8ab5.json\";i:6;s:57:\"wordpress-seo-fr_FR-6ade687c7936490c88bc39df19ea71a0.json\";i:7;s:57:\"wordpress-seo-fr_FR-fbf6c210cf52f9eaaf78c5f02b58c276.json\";i:8;s:57:\"wordpress-seo-fr_FR-786eeb1e9fb710b6d8885049b18564b3.json\";i:9;s:57:\"wordpress-seo-fr_FR-13c172108e3ebc2555ea54a5cffd763b.json\";i:10;s:57:\"wordpress-seo-fr_FR-9f6244fe05b49fabf96551959cf899a6.json\";i:11;s:57:\"wordpress-seo-fr_FR-d084ad2ca2d23f1331bbd1040999834e.json\";i:12;s:57:\"wordpress-seo-fr_FR-8c2f72a2c46baea606be9a7b0c1a23d8.json\";i:13;s:57:\"wordpress-seo-fr_FR-c1b15194a6181a17d3344302011bddf5.json\";i:14;s:57:\"wordpress-seo-fr_FR-3dcfea4e3934344e63996b6fa47b7b5c.json\";i:15;s:28:\"wordpress-seo-fr_FR.l10n.php\";i:16;s:57:\"wordpress-seo-fr_FR-3a6bb28b59cb140b6c372392bf5f13d3.json\";i:17;s:22:\"wordpress-seo-fr_FR.po\";i:18;s:57:\"wordpress-seo-fr_FR-9ff580649b466f65633b98bb16c34525.json\";i:19;s:57:\"wordpress-seo-fr_FR-d6bf43f32d0c3331e709fa67e6be35a2.json\";i:20;s:57:\"wordpress-seo-fr_FR-fb9a41ab0ae57dcb4b10ea3343658bcc.json\";i:21;s:57:\"wordpress-seo-fr_FR-a4aee9e8c2e39d6f81fd70b8bb9ccc09.json\";i:22;s:57:\"wordpress-seo-fr_FR-e422758335e56c41009e56217163c93a.json\";i:23;s:57:\"wordpress-seo-fr_FR-afe43fe171170bbc6083c10610a75434.json\";i:24;s:57:\"wordpress-seo-fr_FR-a4e25a0fbd268367ae0af1e06b841f78.json\";i:25;s:57:\"wordpress-seo-fr_FR-81d02401639ac0f30dc9d7738fcbf629.json\";i:26;s:57:\"wordpress-seo-fr_FR-b1439a828d6d7684a875580ccba87936.json\";i:27;s:57:\"wordpress-seo-fr_FR-b2bb3542a05d1a95a5866b83cc7b8a5f.json\";i:28;s:22:\"wordpress-seo-fr_FR.mo\";i:29;s:57:\"wordpress-seo-fr_FR-8a9083701e738b3c956ea2c9a8a84375.json\";i:30;s:57:\"wordpress-seo-fr_FR-753e370a61af6ba5ccabe91cc950cbcb.json\";i:31;s:57:\"wordpress-seo-fr_FR-9fc912fe9f73e39d5df0779b31bb1a6f.json\";i:32;s:57:\"wordpress-seo-fr_FR-1452e0d46abef67e70f842f830b10ec9.json\";i:33;s:57:\"wordpress-seo-fr_FR-606033e8cb263b032d13356d7a627ed5.json\";i:34;s:57:\"wordpress-seo-fr_FR-59a157b73a79db8a63459f9a2e1b874b.json\";i:35;s:57:\"wordpress-seo-fr_FR-a35a702af4a7fbb6d2d4db8c193dd940.json\";}s:11:\"destination\";s:40:\"/srv/htdocs/wp-content/languages/plugins\";s:16:\"destination_name\";s:0:\"\";s:17:\"local_destination\";s:40:\"/srv/htdocs/wp-content/languages/plugins\";s:18:\"remote_destination\";s:41:\"/srv/htdocs/wp-content/languages/plugins/\";s:17:\"clear_destination\";b:1;}s:4:\"name\";s:26:\"Traductions pour Yoast SEO\";s:8:\"messages\";a:6:{i:0;s:57:\"Mise à jour de la traduction de Yoast SEO (fr_FR)&#8230;\";i:1;s:122:\"Téléchargement des traductions depuis https://downloads.wordpress.org/translation/plugin/wordpress-seo/24.8/fr_FR.zip…\";i:2;s:40:\"Décompression de la mise à jour&#8230;\";i:3;s:43:\"Installation de la dernière version&#8230;\";i:4;s:51:\"Retrait de l’ancienne version de la traduction…\";i:5;s:40:\"La traduction a bien été mise à jour.\";}}}}s:6:\"failed\";a:2:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}}s:7:\"success\";a:3:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}s:11:\"translation\";a:1:{i:0;s:20:\"plugin:wordpress-seo\";}}}}i:1;a:5:{s:4:\"time\";i:1743995916;s:7:\"user_id\";i:0;s:7:\"blog_id\";s:9:\"242379716\";s:4:\"code\";s:11:\"autoupdates\";s:4:\"data\";a:3:{s:7:\"results\";a:1:{s:11:\"translation\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":7:{s:4:\"type\";s:6:\"plugin\";s:4:\"slug\";s:13:\"wordpress-seo\";s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:6:\"24.8.1\";s:7:\"updated\";s:19:\"2025-04-06 18:51:33\";s:7:\"package\";s:81:\"https://downloads.wordpress.org/translation/plugin/wordpress-seo/24.8.1/fr_FR.zip\";s:10:\"autoupdate\";b:1;}s:6:\"result\";a:7:{s:6:\"source\";s:58:\"/srv/htdocs/wp-content/upgrade/wordpress-seo-24.8.1-fr_fr/\";s:12:\"source_files\";a:36:{i:0;s:57:\"wordpress-seo-fr_FR-826f41c23138627439d01b2b0133dbc5.json\";i:1;s:57:\"wordpress-seo-fr_FR-d6c61f7884baaf8a18b31ca41ef1420f.json\";i:2;s:57:\"wordpress-seo-fr_FR-4293cf3571f532bb11ff1676090ec5e7.json\";i:3;s:57:\"wordpress-seo-fr_FR-3ab1863386cca0be6ab4aa906cacadbd.json\";i:4;s:57:\"wordpress-seo-fr_FR-fbf6c210cf52f9eaaf78c5f02b58c276.json\";i:5;s:57:\"wordpress-seo-fr_FR-6ffccefef7026e678d85c6b56bd29680.json\";i:6;s:57:\"wordpress-seo-fr_FR-c1a0e4b150b113a514f162d42c0c8ab5.json\";i:7;s:57:\"wordpress-seo-fr_FR-6ade687c7936490c88bc39df19ea71a0.json\";i:8;s:57:\"wordpress-seo-fr_FR-c1b15194a6181a17d3344302011bddf5.json\";i:9;s:57:\"wordpress-seo-fr_FR-3dcfea4e3934344e63996b6fa47b7b5c.json\";i:10;s:57:\"wordpress-seo-fr_FR-8c2f72a2c46baea606be9a7b0c1a23d8.json\";i:11;s:57:\"wordpress-seo-fr_FR-786eeb1e9fb710b6d8885049b18564b3.json\";i:12;s:57:\"wordpress-seo-fr_FR-13c172108e3ebc2555ea54a5cffd763b.json\";i:13;s:57:\"wordpress-seo-fr_FR-9f6244fe05b49fabf96551959cf899a6.json\";i:14;s:57:\"wordpress-seo-fr_FR-d084ad2ca2d23f1331bbd1040999834e.json\";i:15;s:22:\"wordpress-seo-fr_FR.mo\";i:16;s:57:\"wordpress-seo-fr_FR-9ff580649b466f65633b98bb16c34525.json\";i:17;s:57:\"wordpress-seo-fr_FR-3a6bb28b59cb140b6c372392bf5f13d3.json\";i:18;s:57:\"wordpress-seo-fr_FR-d6bf43f32d0c3331e709fa67e6be35a2.json\";i:19;s:57:\"wordpress-seo-fr_FR-a4e25a0fbd268367ae0af1e06b841f78.json\";i:20;s:57:\"wordpress-seo-fr_FR-afe43fe171170bbc6083c10610a75434.json\";i:21;s:57:\"wordpress-seo-fr_FR-fb9a41ab0ae57dcb4b10ea3343658bcc.json\";i:22;s:57:\"wordpress-seo-fr_FR-a4aee9e8c2e39d6f81fd70b8bb9ccc09.json\";i:23;s:57:\"wordpress-seo-fr_FR-e422758335e56c41009e56217163c93a.json\";i:24;s:57:\"wordpress-seo-fr_FR-753e370a61af6ba5ccabe91cc950cbcb.json\";i:25;s:22:\"wordpress-seo-fr_FR.po\";i:26;s:57:\"wordpress-seo-fr_FR-8a9083701e738b3c956ea2c9a8a84375.json\";i:27;s:28:\"wordpress-seo-fr_FR.l10n.php\";i:28;s:57:\"wordpress-seo-fr_FR-b1439a828d6d7684a875580ccba87936.json\";i:29;s:57:\"wordpress-seo-fr_FR-b2bb3542a05d1a95a5866b83cc7b8a5f.json\";i:30;s:57:\"wordpress-seo-fr_FR-81d02401639ac0f30dc9d7738fcbf629.json\";i:31;s:57:\"wordpress-seo-fr_FR-a35a702af4a7fbb6d2d4db8c193dd940.json\";i:32;s:57:\"wordpress-seo-fr_FR-59a157b73a79db8a63459f9a2e1b874b.json\";i:33;s:57:\"wordpress-seo-fr_FR-606033e8cb263b032d13356d7a627ed5.json\";i:34;s:57:\"wordpress-seo-fr_FR-9fc912fe9f73e39d5df0779b31bb1a6f.json\";i:35;s:57:\"wordpress-seo-fr_FR-1452e0d46abef67e70f842f830b10ec9.json\";}s:11:\"destination\";s:40:\"/srv/htdocs/wp-content/languages/plugins\";s:16:\"destination_name\";s:0:\"\";s:17:\"local_destination\";s:40:\"/srv/htdocs/wp-content/languages/plugins\";s:18:\"remote_destination\";s:41:\"/srv/htdocs/wp-content/languages/plugins/\";s:17:\"clear_destination\";b:1;}s:4:\"name\";s:26:\"Traductions pour Yoast SEO\";s:8:\"messages\";a:6:{i:0;s:57:\"Mise à jour de la traduction de Yoast SEO (fr_FR)&#8230;\";i:1;s:124:\"Téléchargement des traductions depuis https://downloads.wordpress.org/translation/plugin/wordpress-seo/24.8.1/fr_FR.zip…\";i:2;s:40:\"Décompression de la mise à jour&#8230;\";i:3;s:43:\"Installation de la dernière version&#8230;\";i:4;s:51:\"Retrait de l’ancienne version de la traduction…\";i:5;s:40:\"La traduction a bien été mise à jour.\";}}}}s:6:\"failed\";a:2:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}}s:7:\"success\";a:3:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}s:11:\"translation\";a:1:{i:0;s:20:\"plugin:wordpress-seo\";}}}}i:2;a:5:{s:4:\"time\";i:1745938496;s:7:\"user_id\";i:0;s:7:\"blog_id\";s:9:\"242379716\";s:4:\"code\";s:11:\"autoupdates\";s:4:\"data\";a:3:{s:7:\"results\";a:1:{s:11:\"translation\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":7:{s:4:\"type\";s:6:\"plugin\";s:4:\"slug\";s:13:\"wordpress-seo\";s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:4:\"25.0\";s:7:\"updated\";s:19:\"2025-04-29 08:13:19\";s:7:\"package\";s:79:\"https://downloads.wordpress.org/translation/plugin/wordpress-seo/25.0/fr_FR.zip\";s:10:\"autoupdate\";b:1;}s:6:\"result\";a:7:{s:6:\"source\";s:56:\"/srv/htdocs/wp-content/upgrade/wordpress-seo-25.0-fr_fr/\";s:12:\"source_files\";a:37:{i:0;s:57:\"wordpress-seo-fr_FR-826f41c23138627439d01b2b0133dbc5.json\";i:1;s:57:\"wordpress-seo-fr_FR-d6c61f7884baaf8a18b31ca41ef1420f.json\";i:2;s:57:\"wordpress-seo-fr_FR-4293cf3571f532bb11ff1676090ec5e7.json\";i:3;s:57:\"wordpress-seo-fr_FR-3ab1863386cca0be6ab4aa906cacadbd.json\";i:4;s:57:\"wordpress-seo-fr_FR-fbf6c210cf52f9eaaf78c5f02b58c276.json\";i:5;s:57:\"wordpress-seo-fr_FR-6ade687c7936490c88bc39df19ea71a0.json\";i:6;s:57:\"wordpress-seo-fr_FR-6ffccefef7026e678d85c6b56bd29680.json\";i:7;s:57:\"wordpress-seo-fr_FR-c1a0e4b150b113a514f162d42c0c8ab5.json\";i:8;s:28:\"wordpress-seo-fr_FR.l10n.php\";i:9;s:57:\"wordpress-seo-fr_FR-3dcfea4e3934344e63996b6fa47b7b5c.json\";i:10;s:57:\"wordpress-seo-fr_FR-c1b15194a6181a17d3344302011bddf5.json\";i:11;s:22:\"wordpress-seo-fr_FR.mo\";i:12;s:57:\"wordpress-seo-fr_FR-8c2f72a2c46baea606be9a7b0c1a23d8.json\";i:13;s:57:\"wordpress-seo-fr_FR-9f6244fe05b49fabf96551959cf899a6.json\";i:14;s:57:\"wordpress-seo-fr_FR-d084ad2ca2d23f1331bbd1040999834e.json\";i:15;s:57:\"wordpress-seo-fr_FR-786eeb1e9fb710b6d8885049b18564b3.json\";i:16;s:57:\"wordpress-seo-fr_FR-13c172108e3ebc2555ea54a5cffd763b.json\";i:17;s:57:\"wordpress-seo-fr_FR-9ff580649b466f65633b98bb16c34525.json\";i:18;s:57:\"wordpress-seo-fr_FR-3a6bb28b59cb140b6c372392bf5f13d3.json\";i:19;s:57:\"wordpress-seo-fr_FR-d6bf43f32d0c3331e709fa67e6be35a2.json\";i:20;s:57:\"wordpress-seo-fr_FR-be78d746a6b9ae87c3a9ccc92ed7c7ad.json\";i:21;s:57:\"wordpress-seo-fr_FR-a4e25a0fbd268367ae0af1e06b841f78.json\";i:22;s:57:\"wordpress-seo-fr_FR-afe43fe171170bbc6083c10610a75434.json\";i:23;s:57:\"wordpress-seo-fr_FR-e422758335e56c41009e56217163c93a.json\";i:24;s:57:\"wordpress-seo-fr_FR-a4aee9e8c2e39d6f81fd70b8bb9ccc09.json\";i:25;s:57:\"wordpress-seo-fr_FR-fb9a41ab0ae57dcb4b10ea3343658bcc.json\";i:26;s:57:\"wordpress-seo-fr_FR-753e370a61af6ba5ccabe91cc950cbcb.json\";i:27;s:57:\"wordpress-seo-fr_FR-8a9083701e738b3c956ea2c9a8a84375.json\";i:28;s:57:\"wordpress-seo-fr_FR-b2bb3542a05d1a95a5866b83cc7b8a5f.json\";i:29;s:57:\"wordpress-seo-fr_FR-b1439a828d6d7684a875580ccba87936.json\";i:30;s:57:\"wordpress-seo-fr_FR-81d02401639ac0f30dc9d7738fcbf629.json\";i:31;s:57:\"wordpress-seo-fr_FR-a35a702af4a7fbb6d2d4db8c193dd940.json\";i:32;s:22:\"wordpress-seo-fr_FR.po\";i:33;s:57:\"wordpress-seo-fr_FR-59a157b73a79db8a63459f9a2e1b874b.json\";i:34;s:57:\"wordpress-seo-fr_FR-606033e8cb263b032d13356d7a627ed5.json\";i:35;s:57:\"wordpress-seo-fr_FR-1452e0d46abef67e70f842f830b10ec9.json\";i:36;s:57:\"wordpress-seo-fr_FR-9fc912fe9f73e39d5df0779b31bb1a6f.json\";}s:11:\"destination\";s:40:\"/srv/htdocs/wp-content/languages/plugins\";s:16:\"destination_name\";s:0:\"\";s:17:\"local_destination\";s:40:\"/srv/htdocs/wp-content/languages/plugins\";s:18:\"remote_destination\";s:41:\"/srv/htdocs/wp-content/languages/plugins/\";s:17:\"clear_destination\";b:1;}s:4:\"name\";s:26:\"Traductions pour Yoast SEO\";s:8:\"messages\";a:6:{i:0;s:57:\"Mise à jour de la traduction de Yoast SEO (fr_FR)&#8230;\";i:1;s:122:\"Téléchargement des traductions depuis https://downloads.wordpress.org/translation/plugin/wordpress-seo/25.0/fr_FR.zip…\";i:2;s:40:\"Décompression de la mise à jour&#8230;\";i:3;s:43:\"Installation de la dernière version&#8230;\";i:4;s:51:\"Retrait de l’ancienne version de la traduction…\";i:5;s:40:\"La traduction a bien été mise à jour.\";}}}}s:6:\"failed\";a:2:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}}s:7:\"success\";a:3:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}s:11:\"translation\";a:1:{i:0;s:20:\"plugin:wordpress-seo\";}}}}i:3;a:5:{s:4:\"time\";i:1746026347;s:7:\"user_id\";i:0;s:7:\"blog_id\";s:9:\"242379716\";s:4:\"code\";s:11:\"autoupdates\";s:4:\"data\";a:3:{s:7:\"results\";a:1:{s:11:\"translation\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":7:{s:4:\"type\";s:6:\"plugin\";s:4:\"slug\";s:13:\"wordpress-seo\";s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:4:\"25.0\";s:7:\"updated\";s:19:\"2025-04-30 07:50:23\";s:7:\"package\";s:79:\"https://downloads.wordpress.org/translation/plugin/wordpress-seo/25.0/fr_FR.zip\";s:10:\"autoupdate\";b:1;}s:6:\"result\";a:7:{s:6:\"source\";s:56:\"/srv/htdocs/wp-content/upgrade/wordpress-seo-25.0-fr_fr/\";s:12:\"source_files\";a:37:{i:0;s:57:\"wordpress-seo-fr_FR-afe43fe171170bbc6083c10610a75434.json\";i:1;s:57:\"wordpress-seo-fr_FR-a4e25a0fbd268367ae0af1e06b841f78.json\";i:2;s:57:\"wordpress-seo-fr_FR-fb9a41ab0ae57dcb4b10ea3343658bcc.json\";i:3;s:57:\"wordpress-seo-fr_FR-a4aee9e8c2e39d6f81fd70b8bb9ccc09.json\";i:4;s:57:\"wordpress-seo-fr_FR-e422758335e56c41009e56217163c93a.json\";i:5;s:57:\"wordpress-seo-fr_FR-be78d746a6b9ae87c3a9ccc92ed7c7ad.json\";i:6;s:57:\"wordpress-seo-fr_FR-d6bf43f32d0c3331e709fa67e6be35a2.json\";i:7;s:57:\"wordpress-seo-fr_FR-59a157b73a79db8a63459f9a2e1b874b.json\";i:8;s:22:\"wordpress-seo-fr_FR.mo\";i:9;s:57:\"wordpress-seo-fr_FR-a35a702af4a7fbb6d2d4db8c193dd940.json\";i:10;s:57:\"wordpress-seo-fr_FR-9fc912fe9f73e39d5df0779b31bb1a6f.json\";i:11;s:57:\"wordpress-seo-fr_FR-1452e0d46abef67e70f842f830b10ec9.json\";i:12;s:57:\"wordpress-seo-fr_FR-606033e8cb263b032d13356d7a627ed5.json\";i:13;s:57:\"wordpress-seo-fr_FR-8a9083701e738b3c956ea2c9a8a84375.json\";i:14;s:57:\"wordpress-seo-fr_FR-753e370a61af6ba5ccabe91cc950cbcb.json\";i:15;s:57:\"wordpress-seo-fr_FR-81d02401639ac0f30dc9d7738fcbf629.json\";i:16;s:57:\"wordpress-seo-fr_FR-b1439a828d6d7684a875580ccba87936.json\";i:17;s:57:\"wordpress-seo-fr_FR-b2bb3542a05d1a95a5866b83cc7b8a5f.json\";i:18;s:28:\"wordpress-seo-fr_FR.l10n.php\";i:19;s:57:\"wordpress-seo-fr_FR-c1a0e4b150b113a514f162d42c0c8ab5.json\";i:20;s:57:\"wordpress-seo-fr_FR-6ffccefef7026e678d85c6b56bd29680.json\";i:21;s:57:\"wordpress-seo-fr_FR-6ade687c7936490c88bc39df19ea71a0.json\";i:22;s:57:\"wordpress-seo-fr_FR-fbf6c210cf52f9eaaf78c5f02b58c276.json\";i:23;s:57:\"wordpress-seo-fr_FR-d6c61f7884baaf8a18b31ca41ef1420f.json\";i:24;s:57:\"wordpress-seo-fr_FR-826f41c23138627439d01b2b0133dbc5.json\";i:25;s:57:\"wordpress-seo-fr_FR-3ab1863386cca0be6ab4aa906cacadbd.json\";i:26;s:57:\"wordpress-seo-fr_FR-4293cf3571f532bb11ff1676090ec5e7.json\";i:27;s:57:\"wordpress-seo-fr_FR-9ff580649b466f65633b98bb16c34525.json\";i:28;s:57:\"wordpress-seo-fr_FR-3a6bb28b59cb140b6c372392bf5f13d3.json\";i:29;s:22:\"wordpress-seo-fr_FR.po\";i:30;s:57:\"wordpress-seo-fr_FR-c1b15194a6181a17d3344302011bddf5.json\";i:31;s:57:\"wordpress-seo-fr_FR-3dcfea4e3934344e63996b6fa47b7b5c.json\";i:32;s:57:\"wordpress-seo-fr_FR-13c172108e3ebc2555ea54a5cffd763b.json\";i:33;s:57:\"wordpress-seo-fr_FR-786eeb1e9fb710b6d8885049b18564b3.json\";i:34;s:57:\"wordpress-seo-fr_FR-d084ad2ca2d23f1331bbd1040999834e.json\";i:35;s:57:\"wordpress-seo-fr_FR-9f6244fe05b49fabf96551959cf899a6.json\";i:36;s:57:\"wordpress-seo-fr_FR-8c2f72a2c46baea606be9a7b0c1a23d8.json\";}s:11:\"destination\";s:40:\"/srv/htdocs/wp-content/languages/plugins\";s:16:\"destination_name\";s:0:\"\";s:17:\"local_destination\";s:40:\"/srv/htdocs/wp-content/languages/plugins\";s:18:\"remote_destination\";s:41:\"/srv/htdocs/wp-content/languages/plugins/\";s:17:\"clear_destination\";b:1;}s:4:\"name\";s:26:\"Traductions pour Yoast SEO\";s:8:\"messages\";a:6:{i:0;s:57:\"Mise à jour de la traduction de Yoast SEO (fr_FR)&#8230;\";i:1;s:122:\"Téléchargement des traductions depuis https://downloads.wordpress.org/translation/plugin/wordpress-seo/25.0/fr_FR.zip…\";i:2;s:40:\"Décompression de la mise à jour&#8230;\";i:3;s:43:\"Installation de la dernière version&#8230;\";i:4;s:51:\"Retrait de l’ancienne version de la traduction…\";i:5;s:40:\"La traduction a bien été mise à jour.\";}}}}s:6:\"failed\";a:2:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}}s:7:\"success\";a:3:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}s:11:\"translation\";a:1:{i:0;s:20:\"plugin:wordpress-seo\";}}}}i:4;a:5:{s:4:\"time\";i:1746241281;s:7:\"user_id\";i:0;s:7:\"blog_id\";s:9:\"242379716\";s:4:\"code\";s:11:\"autoupdates\";s:4:\"data\";a:3:{s:7:\"results\";a:2:{s:6:\"plugin\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":14:{s:2:\"id\";s:36:\"w.org/plugins/easy-login-woocommerce\";s:4:\"slug\";s:22:\"easy-login-woocommerce\";s:6:\"plugin\";s:38:\"easy-login-woocommerce/xoo-el-main.php\";s:11:\"new_version\";s:5:\"2.9.2\";s:3:\"url\";s:53:\"https://wordpress.org/plugins/easy-login-woocommerce/\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/plugin/easy-login-woocommerce.2.9.2.zip\";s:5:\"icons\";a:1:{s:2:\"1x\";s:75:\"https://ps.w.org/easy-login-woocommerce/assets/icon-128x128.png?rev=1970613\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:77:\"https://ps.w.org/easy-login-woocommerce/assets/banner-772x250.jpg?rev=2583694\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:5:\"3.0.1\";s:6:\"tested\";s:5:\"6.8.1\";s:12:\"requires_php\";b:0;s:16:\"requires_plugins\";a:0:{}s:15:\"current_version\";s:5:\"2.9.1\";}s:6:\"result\";b:1;s:4:\"name\";s:33:\"Fenêtre de connexion/inscription\";s:8:\"messages\";a:6:{i:0;s:66:\"Mise à jour de l’extension : Fenêtre de connexion/inscription\";i:1;s:117:\"Téléchargement de la mise à jour depuis https://downloads.wordpress.org/plugin/easy-login-woocommerce.2.9.2.zip…\";i:2;s:40:\"Décompression de la mise à jour&#8230;\";i:3;s:43:\"Installation de la dernière version&#8230;\";i:4;s:55:\"Retrait de l’ancienne version de l’extension&#8230;\";i:5;s:40:\"L’extension a bien été mise à jour.\";}}}s:11:\"translation\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":7:{s:4:\"type\";s:6:\"plugin\";s:4:\"slug\";s:23:\"header-footer-elementor\";s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"2.3.0\";s:7:\"updated\";s:19:\"2025-05-02 20:28:04\";s:7:\"package\";s:90:\"https://downloads.wordpress.org/translation/plugin/header-footer-elementor/2.3.0/fr_FR.zip\";s:10:\"autoupdate\";b:1;}s:6:\"result\";a:7:{s:6:\"source\";s:67:\"/srv/htdocs/wp-content/upgrade/header-footer-elementor-2.3.0-fr_fr/\";s:12:\"source_files\";a:5:{i:0;s:67:\"header-footer-elementor-fr_FR-2535010758d0ef41a9fccf0ba031f8f5.json\";i:1;s:32:\"header-footer-elementor-fr_FR.po\";i:2;s:32:\"header-footer-elementor-fr_FR.mo\";i:3;s:38:\"header-footer-elementor-fr_FR.l10n.php\";i:4;s:67:\"header-footer-elementor-fr_FR-1860d6c85cf93751e0a08d732e8147f8.json\";}s:11:\"destination\";s:40:\"/srv/htdocs/wp-content/languages/plugins\";s:16:\"destination_name\";s:0:\"\";s:17:\"local_destination\";s:40:\"/srv/htdocs/wp-content/languages/plugins\";s:18:\"remote_destination\";s:41:\"/srv/htdocs/wp-content/languages/plugins/\";s:17:\"clear_destination\";b:1;}s:4:\"name\";s:51:\"Traductions pour Ultimate Addons for Elementor Lite\";s:8:\"messages\";a:6:{i:0;s:82:\"Mise à jour de la traduction de Ultimate Addons for Elementor Lite (fr_FR)&#8230;\";i:1;s:133:\"Téléchargement des traductions depuis https://downloads.wordpress.org/translation/plugin/header-footer-elementor/2.3.0/fr_FR.zip…\";i:2;s:40:\"Décompression de la mise à jour&#8230;\";i:3;s:43:\"Installation de la dernière version&#8230;\";i:4;s:51:\"Retrait de l’ancienne version de la traduction…\";i:5;s:40:\"La traduction a bien été mise à jour.\";}}}}s:6:\"failed\";a:2:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}}s:7:\"success\";a:3:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}s:11:\"translation\";a:1:{i:0;s:30:\"plugin:header-footer-elementor\";}}}}i:5;a:5:{s:4:\"time\";i:1746327747;s:7:\"user_id\";i:0;s:7:\"blog_id\";s:9:\"242379716\";s:4:\"code\";s:11:\"autoupdates\";s:4:\"data\";a:3:{s:7:\"results\";a:1:{s:11:\"translation\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":7:{s:4:\"type\";s:6:\"plugin\";s:4:\"slug\";s:13:\"wordpress-seo\";s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:4:\"25.0\";s:7:\"updated\";s:19:\"2025-05-03 16:24:58\";s:7:\"package\";s:79:\"https://downloads.wordpress.org/translation/plugin/wordpress-seo/25.0/fr_FR.zip\";s:10:\"autoupdate\";b:1;}s:6:\"result\";a:7:{s:6:\"source\";s:56:\"/srv/htdocs/wp-content/upgrade/wordpress-seo-25.0-fr_fr/\";s:12:\"source_files\";a:37:{i:0;s:57:\"wordpress-seo-fr_FR-753e370a61af6ba5ccabe91cc950cbcb.json\";i:1;s:28:\"wordpress-seo-fr_FR.l10n.php\";i:2;s:57:\"wordpress-seo-fr_FR-8a9083701e738b3c956ea2c9a8a84375.json\";i:3;s:57:\"wordpress-seo-fr_FR-b1439a828d6d7684a875580ccba87936.json\";i:4;s:57:\"wordpress-seo-fr_FR-b2bb3542a05d1a95a5866b83cc7b8a5f.json\";i:5;s:57:\"wordpress-seo-fr_FR-81d02401639ac0f30dc9d7738fcbf629.json\";i:6;s:57:\"wordpress-seo-fr_FR-a35a702af4a7fbb6d2d4db8c193dd940.json\";i:7;s:57:\"wordpress-seo-fr_FR-59a157b73a79db8a63459f9a2e1b874b.json\";i:8;s:57:\"wordpress-seo-fr_FR-606033e8cb263b032d13356d7a627ed5.json\";i:9;s:57:\"wordpress-seo-fr_FR-9fc912fe9f73e39d5df0779b31bb1a6f.json\";i:10;s:57:\"wordpress-seo-fr_FR-1452e0d46abef67e70f842f830b10ec9.json\";i:11;s:57:\"wordpress-seo-fr_FR-d6bf43f32d0c3331e709fa67e6be35a2.json\";i:12;s:57:\"wordpress-seo-fr_FR-be78d746a6b9ae87c3a9ccc92ed7c7ad.json\";i:13;s:57:\"wordpress-seo-fr_FR-a4e25a0fbd268367ae0af1e06b841f78.json\";i:14;s:57:\"wordpress-seo-fr_FR-afe43fe171170bbc6083c10610a75434.json\";i:15;s:22:\"wordpress-seo-fr_FR.mo\";i:16;s:57:\"wordpress-seo-fr_FR-fb9a41ab0ae57dcb4b10ea3343658bcc.json\";i:17;s:57:\"wordpress-seo-fr_FR-a4aee9e8c2e39d6f81fd70b8bb9ccc09.json\";i:18;s:57:\"wordpress-seo-fr_FR-e422758335e56c41009e56217163c93a.json\";i:19;s:57:\"wordpress-seo-fr_FR-c1b15194a6181a17d3344302011bddf5.json\";i:20;s:57:\"wordpress-seo-fr_FR-3dcfea4e3934344e63996b6fa47b7b5c.json\";i:21;s:57:\"wordpress-seo-fr_FR-8c2f72a2c46baea606be9a7b0c1a23d8.json\";i:22;s:57:\"wordpress-seo-fr_FR-13c172108e3ebc2555ea54a5cffd763b.json\";i:23;s:57:\"wordpress-seo-fr_FR-786eeb1e9fb710b6d8885049b18564b3.json\";i:24;s:57:\"wordpress-seo-fr_FR-d084ad2ca2d23f1331bbd1040999834e.json\";i:25;s:57:\"wordpress-seo-fr_FR-9f6244fe05b49fabf96551959cf899a6.json\";i:26;s:57:\"wordpress-seo-fr_FR-9ff580649b466f65633b98bb16c34525.json\";i:27;s:57:\"wordpress-seo-fr_FR-3a6bb28b59cb140b6c372392bf5f13d3.json\";i:28;s:57:\"wordpress-seo-fr_FR-826f41c23138627439d01b2b0133dbc5.json\";i:29;s:57:\"wordpress-seo-fr_FR-d6c61f7884baaf8a18b31ca41ef1420f.json\";i:30;s:22:\"wordpress-seo-fr_FR.po\";i:31;s:57:\"wordpress-seo-fr_FR-4293cf3571f532bb11ff1676090ec5e7.json\";i:32;s:57:\"wordpress-seo-fr_FR-3ab1863386cca0be6ab4aa906cacadbd.json\";i:33;s:57:\"wordpress-seo-fr_FR-fbf6c210cf52f9eaaf78c5f02b58c276.json\";i:34;s:57:\"wordpress-seo-fr_FR-6ffccefef7026e678d85c6b56bd29680.json\";i:35;s:57:\"wordpress-seo-fr_FR-c1a0e4b150b113a514f162d42c0c8ab5.json\";i:36;s:57:\"wordpress-seo-fr_FR-6ade687c7936490c88bc39df19ea71a0.json\";}s:11:\"destination\";s:40:\"/srv/htdocs/wp-content/languages/plugins\";s:16:\"destination_name\";s:0:\"\";s:17:\"local_destination\";s:40:\"/srv/htdocs/wp-content/languages/plugins\";s:18:\"remote_destination\";s:41:\"/srv/htdocs/wp-content/languages/plugins/\";s:17:\"clear_destination\";b:1;}s:4:\"name\";s:26:\"Traductions pour Yoast SEO\";s:8:\"messages\";a:6:{i:0;s:57:\"Mise à jour de la traduction de Yoast SEO (fr_FR)&#8230;\";i:1;s:122:\"Téléchargement des traductions depuis https://downloads.wordpress.org/translation/plugin/wordpress-seo/25.0/fr_FR.zip…\";i:2;s:40:\"Décompression de la mise à jour&#8230;\";i:3;s:43:\"Installation de la dernière version&#8230;\";i:4;s:51:\"Retrait de l’ancienne version de la traduction…\";i:5;s:40:\"La traduction a bien été mise à jour.\";}}}}s:6:\"failed\";a:2:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}}s:7:\"success\";a:3:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}s:11:\"translation\";a:1:{i:0;s:20:\"plugin:wordpress-seo\";}}}}i:6;a:5:{s:4:\"time\";i:1747149575;s:7:\"user_id\";i:0;s:7:\"blog_id\";s:9:\"242379716\";s:4:\"code\";s:11:\"autoupdates\";s:4:\"data\";a:3:{s:7:\"results\";a:2:{s:6:\"plugin\";a:2:{i:0;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":14:{s:2:\"id\";s:37:\"w.org/plugins/header-footer-elementor\";s:4:\"slug\";s:23:\"header-footer-elementor\";s:6:\"plugin\";s:51:\"header-footer-elementor/header-footer-elementor.php\";s:11:\"new_version\";s:5:\"2.3.1\";s:3:\"url\";s:54:\"https://wordpress.org/plugins/header-footer-elementor/\";s:7:\"package\";s:72:\"https://downloads.wordpress.org/plugin/header-footer-elementor.2.3.1.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:76:\"https://ps.w.org/header-footer-elementor/assets/icon-256x256.gif?rev=3278750\";s:2:\"1x\";s:76:\"https://ps.w.org/header-footer-elementor/assets/icon-128x128.gif?rev=3278750\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:79:\"https://ps.w.org/header-footer-elementor/assets/banner-1544x500.gif?rev=3278750\";s:2:\"1x\";s:78:\"https://ps.w.org/header-footer-elementor/assets/banner-772x250.gif?rev=3278750\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.0\";s:6:\"tested\";s:5:\"6.8.1\";s:12:\"requires_php\";s:3:\"7.4\";s:16:\"requires_plugins\";a:1:{i:0;s:9:\"elementor\";}s:15:\"current_version\";s:5:\"2.3.0\";}s:6:\"result\";b:1;s:4:\"name\";s:35:\"Ultimate Addons pour Elementor Lite\";s:8:\"messages\";a:6:{i:0;s:68:\"Mise à jour de l’extension : Ultimate Addons pour Elementor Lite\";i:1;s:118:\"Téléchargement de la mise à jour depuis https://downloads.wordpress.org/plugin/header-footer-elementor.2.3.1.zip…\";i:2;s:40:\"Décompression de la mise à jour&#8230;\";i:3;s:43:\"Installation de la dernière version&#8230;\";i:4;s:55:\"Retrait de l’ancienne version de l’extension&#8230;\";i:5;s:40:\"L’extension a bien été mise à jour.\";}}i:1;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":14:{s:2:\"id\";s:27:\"w.org/plugins/wordpress-seo\";s:4:\"slug\";s:13:\"wordpress-seo\";s:6:\"plugin\";s:24:\"wordpress-seo/wp-seo.php\";s:11:\"new_version\";s:4:\"25.1\";s:3:\"url\";s:44:\"https://wordpress.org/plugins/wordpress-seo/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.25.1.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:66:\"https://ps.w.org/wordpress-seo/assets/icon-256x256.gif?rev=3112542\";s:2:\"1x\";s:66:\"https://ps.w.org/wordpress-seo/assets/icon-128x128.gif?rev=3112542\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:69:\"https://ps.w.org/wordpress-seo/assets/banner-1544x500.png?rev=3257862\";s:2:\"1x\";s:68:\"https://ps.w.org/wordpress-seo/assets/banner-772x250.png?rev=3257862\";}s:11:\"banners_rtl\";a:2:{s:2:\"2x\";s:73:\"https://ps.w.org/wordpress-seo/assets/banner-1544x500-rtl.png?rev=3257862\";s:2:\"1x\";s:72:\"https://ps.w.org/wordpress-seo/assets/banner-772x250-rtl.png?rev=3257862\";}s:8:\"requires\";s:3:\"6.6\";s:6:\"tested\";s:5:\"6.8.1\";s:12:\"requires_php\";s:3:\"7.4\";s:16:\"requires_plugins\";a:0:{}s:15:\"current_version\";s:4:\"25.0\";}s:6:\"result\";b:1;s:4:\"name\";s:9:\"Yoast SEO\";s:8:\"messages\";a:6:{i:0;s:42:\"Mise à jour de l’extension : Yoast SEO\";i:1;s:107:\"Téléchargement de la mise à jour depuis https://downloads.wordpress.org/plugin/wordpress-seo.25.1.zip…\";i:2;s:40:\"Décompression de la mise à jour&#8230;\";i:3;s:43:\"Installation de la dernière version&#8230;\";i:4;s:55:\"Retrait de l’ancienne version de l’extension&#8230;\";i:5;s:40:\"L’extension a bien été mise à jour.\";}}}s:11:\"translation\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":7:{s:4:\"type\";s:6:\"plugin\";s:4:\"slug\";s:13:\"wordpress-seo\";s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:4:\"25.1\";s:7:\"updated\";s:19:\"2025-05-13 08:22:11\";s:7:\"package\";s:79:\"https://downloads.wordpress.org/translation/plugin/wordpress-seo/25.1/fr_FR.zip\";s:10:\"autoupdate\";b:1;}s:6:\"result\";a:7:{s:6:\"source\";s:56:\"/srv/htdocs/wp-content/upgrade/wordpress-seo-25.1-fr_fr/\";s:12:\"source_files\";a:37:{i:0;s:57:\"wordpress-seo-fr_FR-59a157b73a79db8a63459f9a2e1b874b.json\";i:1;s:57:\"wordpress-seo-fr_FR-a35a702af4a7fbb6d2d4db8c193dd940.json\";i:2;s:57:\"wordpress-seo-fr_FR-1452e0d46abef67e70f842f830b10ec9.json\";i:3;s:57:\"wordpress-seo-fr_FR-9fc912fe9f73e39d5df0779b31bb1a6f.json\";i:4;s:57:\"wordpress-seo-fr_FR-606033e8cb263b032d13356d7a627ed5.json\";i:5;s:57:\"wordpress-seo-fr_FR-8a9083701e738b3c956ea2c9a8a84375.json\";i:6;s:57:\"wordpress-seo-fr_FR-753e370a61af6ba5ccabe91cc950cbcb.json\";i:7;s:57:\"wordpress-seo-fr_FR-81d02401639ac0f30dc9d7738fcbf629.json\";i:8;s:57:\"wordpress-seo-fr_FR-b2bb3542a05d1a95a5866b83cc7b8a5f.json\";i:9;s:57:\"wordpress-seo-fr_FR-b1439a828d6d7684a875580ccba87936.json\";i:10;s:57:\"wordpress-seo-fr_FR-afe43fe171170bbc6083c10610a75434.json\";i:11;s:57:\"wordpress-seo-fr_FR-a4e25a0fbd268367ae0af1e06b841f78.json\";i:12;s:57:\"wordpress-seo-fr_FR-a4aee9e8c2e39d6f81fd70b8bb9ccc09.json\";i:13;s:57:\"wordpress-seo-fr_FR-e422758335e56c41009e56217163c93a.json\";i:14;s:57:\"wordpress-seo-fr_FR-fb9a41ab0ae57dcb4b10ea3343658bcc.json\";i:15;s:57:\"wordpress-seo-fr_FR-d6bf43f32d0c3331e709fa67e6be35a2.json\";i:16;s:57:\"wordpress-seo-fr_FR-be78d746a6b9ae87c3a9ccc92ed7c7ad.json\";i:17;s:22:\"wordpress-seo-fr_FR.po\";i:18;s:57:\"wordpress-seo-fr_FR-9ff580649b466f65633b98bb16c34525.json\";i:19;s:57:\"wordpress-seo-fr_FR-3a6bb28b59cb140b6c372392bf5f13d3.json\";i:20;s:57:\"wordpress-seo-fr_FR-3dcfea4e3934344e63996b6fa47b7b5c.json\";i:21;s:28:\"wordpress-seo-fr_FR.l10n.php\";i:22;s:57:\"wordpress-seo-fr_FR-c1b15194a6181a17d3344302011bddf5.json\";i:23;s:57:\"wordpress-seo-fr_FR-786eeb1e9fb710b6d8885049b18564b3.json\";i:24;s:57:\"wordpress-seo-fr_FR-13c172108e3ebc2555ea54a5cffd763b.json\";i:25;s:57:\"wordpress-seo-fr_FR-9f6244fe05b49fabf96551959cf899a6.json\";i:26;s:57:\"wordpress-seo-fr_FR-d084ad2ca2d23f1331bbd1040999834e.json\";i:27;s:57:\"wordpress-seo-fr_FR-8c2f72a2c46baea606be9a7b0c1a23d8.json\";i:28;s:57:\"wordpress-seo-fr_FR-6ade687c7936490c88bc39df19ea71a0.json\";i:29;s:57:\"wordpress-seo-fr_FR-6ffccefef7026e678d85c6b56bd29680.json\";i:30;s:57:\"wordpress-seo-fr_FR-c1a0e4b150b113a514f162d42c0c8ab5.json\";i:31;s:57:\"wordpress-seo-fr_FR-fbf6c210cf52f9eaaf78c5f02b58c276.json\";i:32;s:22:\"wordpress-seo-fr_FR.mo\";i:33;s:57:\"wordpress-seo-fr_FR-d6c61f7884baaf8a18b31ca41ef1420f.json\";i:34;s:57:\"wordpress-seo-fr_FR-826f41c23138627439d01b2b0133dbc5.json\";i:35;s:57:\"wordpress-seo-fr_FR-3ab1863386cca0be6ab4aa906cacadbd.json\";i:36;s:57:\"wordpress-seo-fr_FR-4293cf3571f532bb11ff1676090ec5e7.json\";}s:11:\"destination\";s:40:\"/srv/htdocs/wp-content/languages/plugins\";s:16:\"destination_name\";s:0:\"\";s:17:\"local_destination\";s:40:\"/srv/htdocs/wp-content/languages/plugins\";s:18:\"remote_destination\";s:41:\"/srv/htdocs/wp-content/languages/plugins/\";s:17:\"clear_destination\";b:1;}s:4:\"name\";s:26:\"Traductions pour Yoast SEO\";s:8:\"messages\";a:6:{i:0;s:57:\"Mise à jour de la traduction de Yoast SEO (fr_FR)&#8230;\";i:1;s:122:\"Téléchargement des traductions depuis https://downloads.wordpress.org/translation/plugin/wordpress-seo/25.1/fr_FR.zip…\";i:2;s:40:\"Décompression de la mise à jour&#8230;\";i:3;s:43:\"Installation de la dernière version&#8230;\";i:4;s:51:\"Retrait de l’ancienne version de la traduction…\";i:5;s:40:\"La traduction a bien été mise à jour.\";}}}}s:6:\"failed\";a:2:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}}s:7:\"success\";a:3:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}s:11:\"translation\";a:1:{i:0;s:20:\"plugin:wordpress-seo\";}}}}i:7;a:5:{s:4:\"time\";i:1747192734;s:7:\"user_id\";i:0;s:7:\"blog_id\";s:9:\"242379716\";s:4:\"code\";s:11:\"autoupdates\";s:4:\"data\";a:3:{s:7:\"results\";a:1:{s:11:\"translation\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":7:{s:4:\"type\";s:6:\"plugin\";s:4:\"slug\";s:9:\"elementor\";s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:6:\"3.28.4\";s:7:\"updated\";s:19:\"2025-05-13 22:11:11\";s:7:\"package\";s:77:\"https://downloads.wordpress.org/translation/plugin/elementor/3.28.4/fr_FR.zip\";s:10:\"autoupdate\";b:1;}s:6:\"result\";a:7:{s:6:\"source\";s:54:\"/srv/htdocs/wp-content/upgrade/elementor-3.28.4-fr_fr/\";s:12:\"source_files\";a:52:{i:0;s:53:\"elementor-fr_FR-087056f498f9670c54c0511c8654cc0f.json\";i:1;s:53:\"elementor-fr_FR-edafd6bb20f92c5a76f673e753e9b748.json\";i:2;s:53:\"elementor-fr_FR-91751ab1f6434be40ed42c6f2430685d.json\";i:3;s:53:\"elementor-fr_FR-066ef1cdf21d1b40c6de8f6422ec24e0.json\";i:4;s:53:\"elementor-fr_FR-bd7df0741aeddc2bbbb08d20c11e4ddc.json\";i:5;s:53:\"elementor-fr_FR-c124088d3e99b69538d5d578decbde23.json\";i:6;s:18:\"elementor-fr_FR.mo\";i:7;s:53:\"elementor-fr_FR-a4027a255848e5a7096a4cbe99cd18da.json\";i:8;s:53:\"elementor-fr_FR-8b95a20e21550730e7b5557f56908c73.json\";i:9;s:53:\"elementor-fr_FR-64add0440d2f0613154569a24f427bfc.json\";i:10;s:53:\"elementor-fr_FR-6af6ba3e9884f98375cb3c84358312d9.json\";i:11;s:53:\"elementor-fr_FR-c020ae2e43afd0fa97037af8da976f80.json\";i:12;s:53:\"elementor-fr_FR-50f7bdee322f202b88cb992c0ace0ac3.json\";i:13;s:53:\"elementor-fr_FR-e52a375612c89bdb379603f005c15db1.json\";i:14;s:53:\"elementor-fr_FR-6f2d71de6e487593b133a34107c809b5.json\";i:15;s:53:\"elementor-fr_FR-ac76f1d75eb777f747e6708b19d31b78.json\";i:16;s:53:\"elementor-fr_FR-abe7facb531349e3b9bd791c4c0f183e.json\";i:17;s:53:\"elementor-fr_FR-d08674c3209a5d002cdfd3b2d0c5c54d.json\";i:18;s:53:\"elementor-fr_FR-9f5db7e8d855ceba32677d1311e699c4.json\";i:19;s:53:\"elementor-fr_FR-dde11340ced68bea09c9fd29c9ed4534.json\";i:20;s:53:\"elementor-fr_FR-cd2ba996a5d83b29f5cf83e8ddc05032.json\";i:21;s:53:\"elementor-fr_FR-026e05eaa88cf2068ad476f7c5d5d51e.json\";i:22;s:53:\"elementor-fr_FR-4a9aafdf461c74b88a1c7041526ae1d6.json\";i:23;s:53:\"elementor-fr_FR-da0b17c386fffc9274e4479e9cf894f1.json\";i:24;s:53:\"elementor-fr_FR-79962d687013e1cf1388440cb23aaf23.json\";i:25;s:53:\"elementor-fr_FR-14e992284ae6eea67773c5861e3cb8ff.json\";i:26;s:53:\"elementor-fr_FR-b696c3db2aaaac24356ebbf698b78291.json\";i:27;s:53:\"elementor-fr_FR-dbb6fa5340de5e9ec7a4187e2d5dc096.json\";i:28;s:53:\"elementor-fr_FR-a3bac97752b365511e337f750b1e7508.json\";i:29;s:53:\"elementor-fr_FR-9c739050cf2f73944f5e6511cc8a11fc.json\";i:30;s:53:\"elementor-fr_FR-8871b489e8d974572ae4c7578f939de5.json\";i:31;s:53:\"elementor-fr_FR-086a15d65feef08c889aa027d9ea9e9e.json\";i:32;s:18:\"elementor-fr_FR.po\";i:33;s:53:\"elementor-fr_FR-c036d442062da77cd42b189e9b8b6ed4.json\";i:34;s:53:\"elementor-fr_FR-23f8a12bf11e8b1bbfc99cf0797d6856.json\";i:35;s:53:\"elementor-fr_FR-498ef4b5c136d8ffb9492430cfcb556c.json\";i:36;s:53:\"elementor-fr_FR-875641fa8e2acb7d96b56de0fac67935.json\";i:37;s:53:\"elementor-fr_FR-a356d84da643b35ca48f18200424fa68.json\";i:38;s:53:\"elementor-fr_FR-257a4d622678f15a3f060256de53794c.json\";i:39;s:53:\"elementor-fr_FR-f98be19bec7bc848ce3ed383c60037c1.json\";i:40;s:53:\"elementor-fr_FR-2b2970bbb1103e5d8c04e94bda0580b5.json\";i:41;s:53:\"elementor-fr_FR-8ef6d4918e93bfaaef913c65efeec347.json\";i:42;s:53:\"elementor-fr_FR-21b2026463ef175722764b7eaf9022f0.json\";i:43;s:53:\"elementor-fr_FR-e16f2427ce816c4dc38ad0b36edc3ef2.json\";i:44;s:53:\"elementor-fr_FR-7b11194e20cdeeed80bffc166272edd8.json\";i:45;s:53:\"elementor-fr_FR-9de15ead6aa7b3bb8a1ea30a49991974.json\";i:46;s:53:\"elementor-fr_FR-447a0216bbfde7c07c43b4340afd4cac.json\";i:47;s:24:\"elementor-fr_FR.l10n.php\";i:48;s:53:\"elementor-fr_FR-d3edc9236498fc3ec14d61ab5d722dcf.json\";i:49;s:53:\"elementor-fr_FR-7bd3d6cb6889e0684fb5850e5de15987.json\";i:50;s:53:\"elementor-fr_FR-1dbb8b6c1e3d0a728637a838a81040c6.json\";i:51;s:53:\"elementor-fr_FR-e9bd92fcd3a153fa19faf0be5f3e21b4.json\";}s:11:\"destination\";s:40:\"/srv/htdocs/wp-content/languages/plugins\";s:16:\"destination_name\";s:0:\"\";s:17:\"local_destination\";s:40:\"/srv/htdocs/wp-content/languages/plugins\";s:18:\"remote_destination\";s:41:\"/srv/htdocs/wp-content/languages/plugins/\";s:17:\"clear_destination\";b:1;}s:4:\"name\";s:26:\"Traductions pour Elementor\";s:8:\"messages\";a:6:{i:0;s:57:\"Mise à jour de la traduction de Elementor (fr_FR)&#8230;\";i:1;s:120:\"Téléchargement des traductions depuis https://downloads.wordpress.org/translation/plugin/elementor/3.28.4/fr_FR.zip…\";i:2;s:40:\"Décompression de la mise à jour&#8230;\";i:3;s:43:\"Installation de la dernière version&#8230;\";i:4;s:51:\"Retrait de l’ancienne version de la traduction…\";i:5;s:40:\"La traduction a bien été mise à jour.\";}}}}s:6:\"failed\";a:2:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}}s:7:\"success\";a:3:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}s:11:\"translation\";a:1:{i:0;s:16:\"plugin:elementor\";}}}}i:8;a:5:{s:4:\"time\";i:1747236924;s:7:\"user_id\";i:0;s:7:\"blog_id\";s:9:\"242379716\";s:4:\"code\";s:11:\"autoupdates\";s:4:\"data\";a:3:{s:7:\"results\";a:1:{s:11:\"translation\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":7:{s:4:\"type\";s:6:\"plugin\";s:4:\"slug\";s:13:\"wordpress-seo\";s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:4:\"25.1\";s:7:\"updated\";s:19:\"2025-05-14 06:34:35\";s:7:\"package\";s:79:\"https://downloads.wordpress.org/translation/plugin/wordpress-seo/25.1/fr_FR.zip\";s:10:\"autoupdate\";b:1;}s:6:\"result\";a:7:{s:6:\"source\";s:56:\"/srv/htdocs/wp-content/upgrade/wordpress-seo-25.1-fr_fr/\";s:12:\"source_files\";a:37:{i:0;s:57:\"wordpress-seo-fr_FR-c1b15194a6181a17d3344302011bddf5.json\";i:1;s:57:\"wordpress-seo-fr_FR-3dcfea4e3934344e63996b6fa47b7b5c.json\";i:2;s:57:\"wordpress-seo-fr_FR-8c2f72a2c46baea606be9a7b0c1a23d8.json\";i:3;s:57:\"wordpress-seo-fr_FR-786eeb1e9fb710b6d8885049b18564b3.json\";i:4;s:57:\"wordpress-seo-fr_FR-13c172108e3ebc2555ea54a5cffd763b.json\";i:5;s:57:\"wordpress-seo-fr_FR-9f6244fe05b49fabf96551959cf899a6.json\";i:6;s:57:\"wordpress-seo-fr_FR-d084ad2ca2d23f1331bbd1040999834e.json\";i:7;s:57:\"wordpress-seo-fr_FR-9ff580649b466f65633b98bb16c34525.json\";i:8;s:22:\"wordpress-seo-fr_FR.mo\";i:9;s:57:\"wordpress-seo-fr_FR-3a6bb28b59cb140b6c372392bf5f13d3.json\";i:10;s:57:\"wordpress-seo-fr_FR-826f41c23138627439d01b2b0133dbc5.json\";i:11;s:57:\"wordpress-seo-fr_FR-d6c61f7884baaf8a18b31ca41ef1420f.json\";i:12;s:57:\"wordpress-seo-fr_FR-4293cf3571f532bb11ff1676090ec5e7.json\";i:13;s:57:\"wordpress-seo-fr_FR-3ab1863386cca0be6ab4aa906cacadbd.json\";i:14;s:57:\"wordpress-seo-fr_FR-fbf6c210cf52f9eaaf78c5f02b58c276.json\";i:15;s:57:\"wordpress-seo-fr_FR-6ffccefef7026e678d85c6b56bd29680.json\";i:16;s:57:\"wordpress-seo-fr_FR-c1a0e4b150b113a514f162d42c0c8ab5.json\";i:17;s:57:\"wordpress-seo-fr_FR-6ade687c7936490c88bc39df19ea71a0.json\";i:18;s:57:\"wordpress-seo-fr_FR-753e370a61af6ba5ccabe91cc950cbcb.json\";i:19;s:28:\"wordpress-seo-fr_FR.l10n.php\";i:20;s:57:\"wordpress-seo-fr_FR-8a9083701e738b3c956ea2c9a8a84375.json\";i:21;s:57:\"wordpress-seo-fr_FR-b1439a828d6d7684a875580ccba87936.json\";i:22;s:22:\"wordpress-seo-fr_FR.po\";i:23;s:57:\"wordpress-seo-fr_FR-b2bb3542a05d1a95a5866b83cc7b8a5f.json\";i:24;s:57:\"wordpress-seo-fr_FR-81d02401639ac0f30dc9d7738fcbf629.json\";i:25;s:57:\"wordpress-seo-fr_FR-a35a702af4a7fbb6d2d4db8c193dd940.json\";i:26;s:57:\"wordpress-seo-fr_FR-59a157b73a79db8a63459f9a2e1b874b.json\";i:27;s:57:\"wordpress-seo-fr_FR-606033e8cb263b032d13356d7a627ed5.json\";i:28;s:57:\"wordpress-seo-fr_FR-9fc912fe9f73e39d5df0779b31bb1a6f.json\";i:29;s:57:\"wordpress-seo-fr_FR-1452e0d46abef67e70f842f830b10ec9.json\";i:30;s:57:\"wordpress-seo-fr_FR-d6bf43f32d0c3331e709fa67e6be35a2.json\";i:31;s:57:\"wordpress-seo-fr_FR-be78d746a6b9ae87c3a9ccc92ed7c7ad.json\";i:32;s:57:\"wordpress-seo-fr_FR-a4e25a0fbd268367ae0af1e06b841f78.json\";i:33;s:57:\"wordpress-seo-fr_FR-afe43fe171170bbc6083c10610a75434.json\";i:34;s:57:\"wordpress-seo-fr_FR-fb9a41ab0ae57dcb4b10ea3343658bcc.json\";i:35;s:57:\"wordpress-seo-fr_FR-a4aee9e8c2e39d6f81fd70b8bb9ccc09.json\";i:36;s:57:\"wordpress-seo-fr_FR-e422758335e56c41009e56217163c93a.json\";}s:11:\"destination\";s:40:\"/srv/htdocs/wp-content/languages/plugins\";s:16:\"destination_name\";s:0:\"\";s:17:\"local_destination\";s:40:\"/srv/htdocs/wp-content/languages/plugins\";s:18:\"remote_destination\";s:41:\"/srv/htdocs/wp-content/languages/plugins/\";s:17:\"clear_destination\";b:1;}s:4:\"name\";s:26:\"Traductions pour Yoast SEO\";s:8:\"messages\";a:6:{i:0;s:57:\"Mise à jour de la traduction de Yoast SEO (fr_FR)&#8230;\";i:1;s:122:\"Téléchargement des traductions depuis https://downloads.wordpress.org/translation/plugin/wordpress-seo/25.1/fr_FR.zip…\";i:2;s:40:\"Décompression de la mise à jour&#8230;\";i:3;s:43:\"Installation de la dernière version&#8230;\";i:4;s:51:\"Retrait de l’ancienne version de la traduction…\";i:5;s:40:\"La traduction a bien été mise à jour.\";}}}}s:6:\"failed\";a:2:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}}s:7:\"success\";a:3:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}s:11:\"translation\";a:1:{i:0;s:20:\"plugin:wordpress-seo\";}}}}i:9;a:5:{s:4:\"time\";i:1747670413;s:7:\"user_id\";i:0;s:7:\"blog_id\";s:9:\"242379716\";s:4:\"code\";s:11:\"autoupdates\";s:4:\"data\";a:3:{s:7:\"results\";a:2:{s:6:\"plugin\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":14:{s:2:\"id\";s:23:\"w.org/plugins/elementor\";s:4:\"slug\";s:9:\"elementor\";s:6:\"plugin\";s:23:\"elementor/elementor.php\";s:11:\"new_version\";s:6:\"3.29.0\";s:3:\"url\";s:40:\"https://wordpress.org/plugins/elementor/\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.29.0.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:62:\"https://ps.w.org/elementor/assets/icon-256x256.gif?rev=3111597\";s:2:\"1x\";s:62:\"https://ps.w.org/elementor/assets/icon-128x128.gif?rev=3111597\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:65:\"https://ps.w.org/elementor/assets/banner-1544x500.png?rev=3164133\";s:2:\"1x\";s:64:\"https://ps.w.org/elementor/assets/banner-772x250.png?rev=3164133\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"6.5\";s:6:\"tested\";s:5:\"6.7.2\";s:12:\"requires_php\";s:3:\"7.4\";s:16:\"requires_plugins\";a:0:{}s:15:\"current_version\";s:6:\"3.28.4\";}s:6:\"result\";b:1;s:4:\"name\";s:9:\"Elementor\";s:8:\"messages\";a:6:{i:0;s:42:\"Mise à jour de l’extension : Elementor\";i:1;s:105:\"Téléchargement de la mise à jour depuis https://downloads.wordpress.org/plugin/elementor.3.29.0.zip…\";i:2;s:40:\"Décompression de la mise à jour&#8230;\";i:3;s:43:\"Installation de la dernière version&#8230;\";i:4;s:55:\"Retrait de l’ancienne version de l’extension&#8230;\";i:5;s:40:\"L’extension a bien été mise à jour.\";}}}s:11:\"translation\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":7:{s:4:\"type\";s:6:\"plugin\";s:4:\"slug\";s:9:\"elementor\";s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:6:\"3.29.0\";s:7:\"updated\";s:19:\"2025-05-19 08:58:08\";s:7:\"package\";s:77:\"https://downloads.wordpress.org/translation/plugin/elementor/3.29.0/fr_FR.zip\";s:10:\"autoupdate\";b:1;}s:6:\"result\";a:7:{s:6:\"source\";s:54:\"/srv/htdocs/wp-content/upgrade/elementor-3.29.0-fr_fr/\";s:12:\"source_files\";a:61:{i:0;s:53:\"elementor-fr_FR-9c739050cf2f73944f5e6511cc8a11fc.json\";i:1;s:53:\"elementor-fr_FR-086a15d65feef08c889aa027d9ea9e9e.json\";i:2;s:53:\"elementor-fr_FR-8871b489e8d974572ae4c7578f939de5.json\";i:3;s:53:\"elementor-fr_FR-dbb6fa5340de5e9ec7a4187e2d5dc096.json\";i:4;s:53:\"elementor-fr_FR-a3bac97752b365511e337f750b1e7508.json\";i:5;s:53:\"elementor-fr_FR-23f8a12bf11e8b1bbfc99cf0797d6856.json\";i:6;s:53:\"elementor-fr_FR-c036d442062da77cd42b189e9b8b6ed4.json\";i:7;s:53:\"elementor-fr_FR-498ef4b5c136d8ffb9492430cfcb556c.json\";i:8;s:53:\"elementor-fr_FR-875641fa8e2acb7d96b56de0fac67935.json\";i:9;s:53:\"elementor-fr_FR-a356d84da643b35ca48f18200424fa68.json\";i:10;s:53:\"elementor-fr_FR-f98be19bec7bc848ce3ed383c60037c1.json\";i:11;s:53:\"elementor-fr_FR-257a4d622678f15a3f060256de53794c.json\";i:12;s:53:\"elementor-fr_FR-e16f2427ce816c4dc38ad0b36edc3ef2.json\";i:13;s:53:\"elementor-fr_FR-a37a3c226bf678cab681cd9909081cd7.json\";i:14;s:53:\"elementor-fr_FR-7b11194e20cdeeed80bffc166272edd8.json\";i:15;s:53:\"elementor-fr_FR-8ef6d4918e93bfaaef913c65efeec347.json\";i:16;s:53:\"elementor-fr_FR-2b2970bbb1103e5d8c04e94bda0580b5.json\";i:17;s:53:\"elementor-fr_FR-21b2026463ef175722764b7eaf9022f0.json\";i:18;s:53:\"elementor-fr_FR-d3d5654beb3dd946bfe30c646a6e6f7a.json\";i:19;s:53:\"elementor-fr_FR-447a0216bbfde7c07c43b4340afd4cac.json\";i:20;s:53:\"elementor-fr_FR-9de15ead6aa7b3bb8a1ea30a49991974.json\";i:21;s:24:\"elementor-fr_FR.l10n.php\";i:22;s:53:\"elementor-fr_FR-d3edc9236498fc3ec14d61ab5d722dcf.json\";i:23;s:53:\"elementor-fr_FR-7bd3d6cb6889e0684fb5850e5de15987.json\";i:24;s:53:\"elementor-fr_FR-1eaa4805b1377c0417b4db33d9356e55.json\";i:25;s:18:\"elementor-fr_FR.po\";i:26;s:53:\"elementor-fr_FR-e9bd92fcd3a153fa19faf0be5f3e21b4.json\";i:27;s:53:\"elementor-fr_FR-1dbb8b6c1e3d0a728637a838a81040c6.json\";i:28;s:53:\"elementor-fr_FR-91751ab1f6434be40ed42c6f2430685d.json\";i:29;s:53:\"elementor-fr_FR-edafd6bb20f92c5a76f673e753e9b748.json\";i:30;s:53:\"elementor-fr_FR-38ad0bddf7be1ae89a964f0a38111ec4.json\";i:31;s:53:\"elementor-fr_FR-087056f498f9670c54c0511c8654cc0f.json\";i:32;s:53:\"elementor-fr_FR-c124088d3e99b69538d5d578decbde23.json\";i:33;s:53:\"elementor-fr_FR-9c8a47e6937ddf015aae420bc5ff5535.json\";i:34;s:53:\"elementor-fr_FR-066ef1cdf21d1b40c6de8f6422ec24e0.json\";i:35;s:53:\"elementor-fr_FR-bd7df0741aeddc2bbbb08d20c11e4ddc.json\";i:36;s:53:\"elementor-fr_FR-f96d126220db38434af261622076bd10.json\";i:37;s:53:\"elementor-fr_FR-a4027a255848e5a7096a4cbe99cd18da.json\";i:38;s:53:\"elementor-fr_FR-c020ae2e43afd0fa97037af8da976f80.json\";i:39;s:53:\"elementor-fr_FR-29cddf451a089e9aaa23fdb1427339bc.json\";i:40;s:53:\"elementor-fr_FR-50f7bdee322f202b88cb992c0ace0ac3.json\";i:41;s:53:\"elementor-fr_FR-8b95a20e21550730e7b5557f56908c73.json\";i:42;s:53:\"elementor-fr_FR-6af6ba3e9884f98375cb3c84358312d9.json\";i:43;s:53:\"elementor-fr_FR-64add0440d2f0613154569a24f427bfc.json\";i:44;s:53:\"elementor-fr_FR-4c6899a942ab98bd21d114780770d265.json\";i:45;s:53:\"elementor-fr_FR-e52a375612c89bdb379603f005c15db1.json\";i:46;s:53:\"elementor-fr_FR-ac76f1d75eb777f747e6708b19d31b78.json\";i:47;s:53:\"elementor-fr_FR-abe7facb531349e3b9bd791c4c0f183e.json\";i:48;s:53:\"elementor-fr_FR-74a792e9e112e1699f80fb8b03af77af.json\";i:49;s:53:\"elementor-fr_FR-6f2d71de6e487593b133a34107c809b5.json\";i:50;s:53:\"elementor-fr_FR-dde11340ced68bea09c9fd29c9ed4534.json\";i:51;s:18:\"elementor-fr_FR.mo\";i:52;s:53:\"elementor-fr_FR-9f5db7e8d855ceba32677d1311e699c4.json\";i:53;s:53:\"elementor-fr_FR-d08674c3209a5d002cdfd3b2d0c5c54d.json\";i:54;s:53:\"elementor-fr_FR-cd2ba996a5d83b29f5cf83e8ddc05032.json\";i:55;s:53:\"elementor-fr_FR-4a9aafdf461c74b88a1c7041526ae1d6.json\";i:56;s:53:\"elementor-fr_FR-026e05eaa88cf2068ad476f7c5d5d51e.json\";i:57;s:53:\"elementor-fr_FR-a35d93a248609173aa2bde17fd555a15.json\";i:58;s:53:\"elementor-fr_FR-da0b17c386fffc9274e4479e9cf894f1.json\";i:59;s:53:\"elementor-fr_FR-79962d687013e1cf1388440cb23aaf23.json\";i:60;s:53:\"elementor-fr_FR-14e992284ae6eea67773c5861e3cb8ff.json\";}s:11:\"destination\";s:40:\"/srv/htdocs/wp-content/languages/plugins\";s:16:\"destination_name\";s:0:\"\";s:17:\"local_destination\";s:40:\"/srv/htdocs/wp-content/languages/plugins\";s:18:\"remote_destination\";s:41:\"/srv/htdocs/wp-content/languages/plugins/\";s:17:\"clear_destination\";b:1;}s:4:\"name\";s:26:\"Traductions pour Elementor\";s:8:\"messages\";a:6:{i:0;s:57:\"Mise à jour de la traduction de Elementor (fr_FR)&#8230;\";i:1;s:120:\"Téléchargement des traductions depuis https://downloads.wordpress.org/translation/plugin/elementor/3.29.0/fr_FR.zip…\";i:2;s:40:\"Décompression de la mise à jour&#8230;\";i:3;s:43:\"Installation de la dernière version&#8230;\";i:4;s:51:\"Retrait de l’ancienne version de la traduction…\";i:5;s:40:\"La traduction a bien été mise à jour.\";}}}}s:6:\"failed\";a:2:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}}s:7:\"success\";a:3:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}s:11:\"translation\";a:1:{i:0;s:16:\"plugin:elementor\";}}}}i:10;a:5:{s:4:\"time\";i:1749570310;s:7:\"user_id\";i:0;s:7:\"blog_id\";s:9:\"242379716\";s:4:\"code\";s:11:\"autoupdates\";s:4:\"data\";a:3:{s:7:\"results\";a:2:{s:6:\"plugin\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":14:{s:2:\"id\";s:27:\"w.org/plugins/wordpress-seo\";s:4:\"slug\";s:13:\"wordpress-seo\";s:6:\"plugin\";s:24:\"wordpress-seo/wp-seo.php\";s:11:\"new_version\";s:4:\"25.3\";s:3:\"url\";s:44:\"https://wordpress.org/plugins/wordpress-seo/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.25.3.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:66:\"https://ps.w.org/wordpress-seo/assets/icon-256x256.gif?rev=3112542\";s:2:\"1x\";s:66:\"https://ps.w.org/wordpress-seo/assets/icon-128x128.gif?rev=3112542\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:69:\"https://ps.w.org/wordpress-seo/assets/banner-1544x500.png?rev=3257862\";s:2:\"1x\";s:68:\"https://ps.w.org/wordpress-seo/assets/banner-772x250.png?rev=3257862\";}s:11:\"banners_rtl\";a:2:{s:2:\"2x\";s:73:\"https://ps.w.org/wordpress-seo/assets/banner-1544x500-rtl.png?rev=3257862\";s:2:\"1x\";s:72:\"https://ps.w.org/wordpress-seo/assets/banner-772x250-rtl.png?rev=3257862\";}s:8:\"requires\";s:3:\"6.6\";s:6:\"tested\";s:5:\"6.8.1\";s:12:\"requires_php\";s:3:\"7.4\";s:16:\"requires_plugins\";a:0:{}s:15:\"current_version\";s:4:\"25.2\";}s:6:\"result\";b:1;s:4:\"name\";s:9:\"Yoast SEO\";s:8:\"messages\";a:6:{i:0;s:42:\"Mise à jour de l’extension : Yoast SEO\";i:1;s:107:\"Téléchargement de la mise à jour depuis https://downloads.wordpress.org/plugin/wordpress-seo.25.3.zip…\";i:2;s:40:\"Décompression de la mise à jour&#8230;\";i:3;s:43:\"Installation de la dernière version&#8230;\";i:4;s:55:\"Retrait de l’ancienne version de l’extension&#8230;\";i:5;s:40:\"L’extension a bien été mise à jour.\";}}}s:11:\"translation\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":7:{s:4:\"type\";s:6:\"plugin\";s:4:\"slug\";s:13:\"wordpress-seo\";s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:4:\"25.3\";s:7:\"updated\";s:19:\"2025-06-10 08:19:09\";s:7:\"package\";s:79:\"https://downloads.wordpress.org/translation/plugin/wordpress-seo/25.3/fr_FR.zip\";s:10:\"autoupdate\";b:1;}s:6:\"result\";a:7:{s:6:\"source\";s:56:\"/srv/htdocs/wp-content/upgrade/wordpress-seo-25.3-fr_fr/\";s:12:\"source_files\";a:37:{i:0;s:57:\"wordpress-seo-fr_FR-afe43fe171170bbc6083c10610a75434.json\";i:1;s:57:\"wordpress-seo-fr_FR-a4e25a0fbd268367ae0af1e06b841f78.json\";i:2;s:57:\"wordpress-seo-fr_FR-fb9a41ab0ae57dcb4b10ea3343658bcc.json\";i:3;s:57:\"wordpress-seo-fr_FR-e422758335e56c41009e56217163c93a.json\";i:4;s:57:\"wordpress-seo-fr_FR-a4aee9e8c2e39d6f81fd70b8bb9ccc09.json\";i:5;s:57:\"wordpress-seo-fr_FR-d6bf43f32d0c3331e709fa67e6be35a2.json\";i:6;s:57:\"wordpress-seo-fr_FR-be78d746a6b9ae87c3a9ccc92ed7c7ad.json\";i:7;s:28:\"wordpress-seo-fr_FR.l10n.php\";i:8;s:22:\"wordpress-seo-fr_FR.mo\";i:9;s:57:\"wordpress-seo-fr_FR-59a157b73a79db8a63459f9a2e1b874b.json\";i:10;s:57:\"wordpress-seo-fr_FR-a35a702af4a7fbb6d2d4db8c193dd940.json\";i:11;s:57:\"wordpress-seo-fr_FR-9fc912fe9f73e39d5df0779b31bb1a6f.json\";i:12;s:57:\"wordpress-seo-fr_FR-1452e0d46abef67e70f842f830b10ec9.json\";i:13;s:57:\"wordpress-seo-fr_FR-606033e8cb263b032d13356d7a627ed5.json\";i:14;s:57:\"wordpress-seo-fr_FR-8a9083701e738b3c956ea2c9a8a84375.json\";i:15;s:57:\"wordpress-seo-fr_FR-753e370a61af6ba5ccabe91cc950cbcb.json\";i:16;s:57:\"wordpress-seo-fr_FR-81d02401639ac0f30dc9d7738fcbf629.json\";i:17;s:57:\"wordpress-seo-fr_FR-b1439a828d6d7684a875580ccba87936.json\";i:18;s:57:\"wordpress-seo-fr_FR-b2bb3542a05d1a95a5866b83cc7b8a5f.json\";i:19;s:57:\"wordpress-seo-fr_FR-6ffccefef7026e678d85c6b56bd29680.json\";i:20;s:57:\"wordpress-seo-fr_FR-c1a0e4b150b113a514f162d42c0c8ab5.json\";i:21;s:57:\"wordpress-seo-fr_FR-6ade687c7936490c88bc39df19ea71a0.json\";i:22;s:57:\"wordpress-seo-fr_FR-fbf6c210cf52f9eaaf78c5f02b58c276.json\";i:23;s:22:\"wordpress-seo-fr_FR.po\";i:24;s:57:\"wordpress-seo-fr_FR-d6c61f7884baaf8a18b31ca41ef1420f.json\";i:25;s:57:\"wordpress-seo-fr_FR-826f41c23138627439d01b2b0133dbc5.json\";i:26;s:57:\"wordpress-seo-fr_FR-3ab1863386cca0be6ab4aa906cacadbd.json\";i:27;s:57:\"wordpress-seo-fr_FR-4293cf3571f532bb11ff1676090ec5e7.json\";i:28;s:57:\"wordpress-seo-fr_FR-9ff580649b466f65633b98bb16c34525.json\";i:29;s:57:\"wordpress-seo-fr_FR-3a6bb28b59cb140b6c372392bf5f13d3.json\";i:30;s:57:\"wordpress-seo-fr_FR-c1b15194a6181a17d3344302011bddf5.json\";i:31;s:57:\"wordpress-seo-fr_FR-3dcfea4e3934344e63996b6fa47b7b5c.json\";i:32;s:57:\"wordpress-seo-fr_FR-d084ad2ca2d23f1331bbd1040999834e.json\";i:33;s:57:\"wordpress-seo-fr_FR-9f6244fe05b49fabf96551959cf899a6.json\";i:34;s:57:\"wordpress-seo-fr_FR-13c172108e3ebc2555ea54a5cffd763b.json\";i:35;s:57:\"wordpress-seo-fr_FR-786eeb1e9fb710b6d8885049b18564b3.json\";i:36;s:57:\"wordpress-seo-fr_FR-8c2f72a2c46baea606be9a7b0c1a23d8.json\";}s:11:\"destination\";s:40:\"/srv/htdocs/wp-content/languages/plugins\";s:16:\"destination_name\";s:0:\"\";s:17:\"local_destination\";s:40:\"/srv/htdocs/wp-content/languages/plugins\";s:18:\"remote_destination\";s:41:\"/srv/htdocs/wp-content/languages/plugins/\";s:17:\"clear_destination\";b:1;}s:4:\"name\";s:26:\"Traductions pour Yoast SEO\";s:8:\"messages\";a:6:{i:0;s:57:\"Mise à jour de la traduction de Yoast SEO (fr_FR)&#8230;\";i:1;s:122:\"Téléchargement des traductions depuis https://downloads.wordpress.org/translation/plugin/wordpress-seo/25.3/fr_FR.zip…\";i:2;s:40:\"Décompression de la mise à jour&#8230;\";i:3;s:43:\"Installation de la dernière version&#8230;\";i:4;s:51:\"Retrait de l’ancienne version de la traduction…\";i:5;s:40:\"La traduction a bien été mise à jour.\";}}}}s:6:\"failed\";a:2:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}}s:7:\"success\";a:3:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}s:11:\"translation\";a:1:{i:0;s:20:\"plugin:wordpress-seo\";}}}}i:11;a:5:{s:4:\"time\";i:1749916268;s:7:\"user_id\";i:0;s:7:\"blog_id\";s:9:\"242379716\";s:4:\"code\";s:11:\"autoupdates\";s:4:\"data\";a:3:{s:7:\"results\";a:2:{s:6:\"plugin\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":14:{s:2:\"id\";s:36:\"w.org/plugins/easy-login-woocommerce\";s:4:\"slug\";s:22:\"easy-login-woocommerce\";s:6:\"plugin\";s:38:\"easy-login-woocommerce/xoo-el-main.php\";s:11:\"new_version\";s:5:\"2.9.3\";s:3:\"url\";s:53:\"https://wordpress.org/plugins/easy-login-woocommerce/\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/plugin/easy-login-woocommerce.2.9.3.zip\";s:5:\"icons\";a:1:{s:2:\"1x\";s:75:\"https://ps.w.org/easy-login-woocommerce/assets/icon-128x128.png?rev=1970613\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:77:\"https://ps.w.org/easy-login-woocommerce/assets/banner-772x250.jpg?rev=2583694\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:5:\"3.0.1\";s:6:\"tested\";s:5:\"6.8.1\";s:12:\"requires_php\";b:0;s:16:\"requires_plugins\";a:0:{}s:15:\"current_version\";s:5:\"2.9.2\";}s:6:\"result\";b:1;s:4:\"name\";s:33:\"Fenêtre de connexion/inscription\";s:8:\"messages\";a:6:{i:0;s:66:\"Mise à jour de l’extension : Fenêtre de connexion/inscription\";i:1;s:117:\"Téléchargement de la mise à jour depuis https://downloads.wordpress.org/plugin/easy-login-woocommerce.2.9.3.zip…\";i:2;s:40:\"Décompression de la mise à jour&#8230;\";i:3;s:43:\"Installation de la dernière version&#8230;\";i:4;s:55:\"Retrait de l’ancienne version de l’extension&#8230;\";i:5;s:40:\"L’extension a bien été mise à jour.\";}}}s:11:\"translation\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":7:{s:4:\"type\";s:6:\"plugin\";s:4:\"slug\";s:13:\"wordpress-seo\";s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:4:\"25.3\";s:7:\"updated\";s:19:\"2025-06-14 15:06:56\";s:7:\"package\";s:79:\"https://downloads.wordpress.org/translation/plugin/wordpress-seo/25.3/fr_FR.zip\";s:10:\"autoupdate\";b:1;}s:6:\"result\";a:7:{s:6:\"source\";s:56:\"/srv/htdocs/wp-content/upgrade/wordpress-seo-25.3-fr_fr/\";s:12:\"source_files\";a:37:{i:0;s:57:\"wordpress-seo-fr_FR-be78d746a6b9ae87c3a9ccc92ed7c7ad.json\";i:1;s:57:\"wordpress-seo-fr_FR-d6bf43f32d0c3331e709fa67e6be35a2.json\";i:2;s:57:\"wordpress-seo-fr_FR-e422758335e56c41009e56217163c93a.json\";i:3;s:57:\"wordpress-seo-fr_FR-a4aee9e8c2e39d6f81fd70b8bb9ccc09.json\";i:4;s:57:\"wordpress-seo-fr_FR-fb9a41ab0ae57dcb4b10ea3343658bcc.json\";i:5;s:57:\"wordpress-seo-fr_FR-a4e25a0fbd268367ae0af1e06b841f78.json\";i:6;s:57:\"wordpress-seo-fr_FR-afe43fe171170bbc6083c10610a75434.json\";i:7;s:57:\"wordpress-seo-fr_FR-b2bb3542a05d1a95a5866b83cc7b8a5f.json\";i:8;s:57:\"wordpress-seo-fr_FR-b1439a828d6d7684a875580ccba87936.json\";i:9;s:57:\"wordpress-seo-fr_FR-81d02401639ac0f30dc9d7738fcbf629.json\";i:10;s:57:\"wordpress-seo-fr_FR-753e370a61af6ba5ccabe91cc950cbcb.json\";i:11;s:57:\"wordpress-seo-fr_FR-8a9083701e738b3c956ea2c9a8a84375.json\";i:12;s:57:\"wordpress-seo-fr_FR-606033e8cb263b032d13356d7a627ed5.json\";i:13;s:57:\"wordpress-seo-fr_FR-1452e0d46abef67e70f842f830b10ec9.json\";i:14;s:57:\"wordpress-seo-fr_FR-9fc912fe9f73e39d5df0779b31bb1a6f.json\";i:15;s:57:\"wordpress-seo-fr_FR-a35a702af4a7fbb6d2d4db8c193dd940.json\";i:16;s:22:\"wordpress-seo-fr_FR.po\";i:17;s:57:\"wordpress-seo-fr_FR-59a157b73a79db8a63459f9a2e1b874b.json\";i:18;s:57:\"wordpress-seo-fr_FR-4293cf3571f532bb11ff1676090ec5e7.json\";i:19;s:57:\"wordpress-seo-fr_FR-3ab1863386cca0be6ab4aa906cacadbd.json\";i:20;s:57:\"wordpress-seo-fr_FR-826f41c23138627439d01b2b0133dbc5.json\";i:21;s:57:\"wordpress-seo-fr_FR-d6c61f7884baaf8a18b31ca41ef1420f.json\";i:22;s:57:\"wordpress-seo-fr_FR-fbf6c210cf52f9eaaf78c5f02b58c276.json\";i:23;s:57:\"wordpress-seo-fr_FR-6ade687c7936490c88bc39df19ea71a0.json\";i:24;s:57:\"wordpress-seo-fr_FR-c1a0e4b150b113a514f162d42c0c8ab5.json\";i:25;s:57:\"wordpress-seo-fr_FR-6ffccefef7026e678d85c6b56bd29680.json\";i:26;s:57:\"wordpress-seo-fr_FR-8c2f72a2c46baea606be9a7b0c1a23d8.json\";i:27;s:57:\"wordpress-seo-fr_FR-d084ad2ca2d23f1331bbd1040999834e.json\";i:28;s:57:\"wordpress-seo-fr_FR-9f6244fe05b49fabf96551959cf899a6.json\";i:29;s:57:\"wordpress-seo-fr_FR-13c172108e3ebc2555ea54a5cffd763b.json\";i:30;s:57:\"wordpress-seo-fr_FR-786eeb1e9fb710b6d8885049b18564b3.json\";i:31;s:57:\"wordpress-seo-fr_FR-3dcfea4e3934344e63996b6fa47b7b5c.json\";i:32;s:57:\"wordpress-seo-fr_FR-c1b15194a6181a17d3344302011bddf5.json\";i:33;s:22:\"wordpress-seo-fr_FR.mo\";i:34;s:28:\"wordpress-seo-fr_FR.l10n.php\";i:35;s:57:\"wordpress-seo-fr_FR-3a6bb28b59cb140b6c372392bf5f13d3.json\";i:36;s:57:\"wordpress-seo-fr_FR-9ff580649b466f65633b98bb16c34525.json\";}s:11:\"destination\";s:40:\"/srv/htdocs/wp-content/languages/plugins\";s:16:\"destination_name\";s:0:\"\";s:17:\"local_destination\";s:40:\"/srv/htdocs/wp-content/languages/plugins\";s:18:\"remote_destination\";s:41:\"/srv/htdocs/wp-content/languages/plugins/\";s:17:\"clear_destination\";b:1;}s:4:\"name\";s:26:\"Traductions pour Yoast SEO\";s:8:\"messages\";a:6:{i:0;s:57:\"Mise à jour de la traduction de Yoast SEO (fr_FR)&#8230;\";i:1;s:122:\"Téléchargement des traductions depuis https://downloads.wordpress.org/translation/plugin/wordpress-seo/25.3/fr_FR.zip…\";i:2;s:40:\"Décompression de la mise à jour&#8230;\";i:3;s:43:\"Installation de la dernière version&#8230;\";i:4;s:51:\"Retrait de l’ancienne version de la traduction…\";i:5;s:40:\"La traduction a bien été mise à jour.\";}}}}s:6:\"failed\";a:2:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}}s:7:\"success\";a:3:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}s:11:\"translation\";a:1:{i:0;s:20:\"plugin:wordpress-seo\";}}}}i:12;a:5:{s:4:\"time\";i:1750260934;s:7:\"user_id\";i:0;s:7:\"blog_id\";s:9:\"242379716\";s:4:\"code\";s:11:\"autoupdates\";s:4:\"data\";a:3:{s:7:\"results\";a:1:{s:11:\"translation\";a:2:{i:0;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":7:{s:4:\"type\";s:6:\"plugin\";s:4:\"slug\";s:9:\"elementor\";s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:6:\"3.29.2\";s:7:\"updated\";s:19:\"2025-06-18 13:40:09\";s:7:\"package\";s:77:\"https://downloads.wordpress.org/translation/plugin/elementor/3.29.2/fr_FR.zip\";s:10:\"autoupdate\";b:1;}s:6:\"result\";a:7:{s:6:\"source\";s:54:\"/srv/htdocs/wp-content/upgrade/elementor-3.29.2-fr_fr/\";s:12:\"source_files\";a:63:{i:0;s:53:\"elementor-fr_FR-14e992284ae6eea67773c5861e3cb8ff.json\";i:1;s:53:\"elementor-fr_FR-79962d687013e1cf1388440cb23aaf23.json\";i:2;s:53:\"elementor-fr_FR-da0b17c386fffc9274e4479e9cf894f1.json\";i:3;s:53:\"elementor-fr_FR-4a9aafdf461c74b88a1c7041526ae1d6.json\";i:4;s:53:\"elementor-fr_FR-026e05eaa88cf2068ad476f7c5d5d51e.json\";i:5;s:53:\"elementor-fr_FR-cd2ba996a5d83b29f5cf83e8ddc05032.json\";i:6;s:53:\"elementor-fr_FR-a35d93a248609173aa2bde17fd555a15.json\";i:7;s:53:\"elementor-fr_FR-dde11340ced68bea09c9fd29c9ed4534.json\";i:8;s:53:\"elementor-fr_FR-d08674c3209a5d002cdfd3b2d0c5c54d.json\";i:9;s:53:\"elementor-fr_FR-9f5db7e8d855ceba32677d1311e699c4.json\";i:10;s:53:\"elementor-fr_FR-4c6899a942ab98bd21d114780770d265.json\";i:11;s:53:\"elementor-fr_FR-74a792e9e112e1699f80fb8b03af77af.json\";i:12;s:53:\"elementor-fr_FR-abe7facb531349e3b9bd791c4c0f183e.json\";i:13;s:53:\"elementor-fr_FR-ac76f1d75eb777f747e6708b19d31b78.json\";i:14;s:53:\"elementor-fr_FR-6f2d71de6e487593b133a34107c809b5.json\";i:15;s:53:\"elementor-fr_FR-159ea97b1fe3eac1cdc248d42c6c4425.json\";i:16;s:53:\"elementor-fr_FR-e52a375612c89bdb379603f005c15db1.json\";i:17;s:53:\"elementor-fr_FR-50f7bdee322f202b88cb992c0ace0ac3.json\";i:18;s:53:\"elementor-fr_FR-c020ae2e43afd0fa97037af8da976f80.json\";i:19;s:53:\"elementor-fr_FR-29cddf451a089e9aaa23fdb1427339bc.json\";i:20;s:53:\"elementor-fr_FR-6af6ba3e9884f98375cb3c84358312d9.json\";i:21;s:53:\"elementor-fr_FR-64add0440d2f0613154569a24f427bfc.json\";i:22;s:53:\"elementor-fr_FR-8b95a20e21550730e7b5557f56908c73.json\";i:23;s:53:\"elementor-fr_FR-f96d126220db38434af261622076bd10.json\";i:24;s:53:\"elementor-fr_FR-a4027a255848e5a7096a4cbe99cd18da.json\";i:25;s:53:\"elementor-fr_FR-01da1c82f490f2329f3f6fea4aacca2a.json\";i:26;s:53:\"elementor-fr_FR-9c8a47e6937ddf015aae420bc5ff5535.json\";i:27;s:53:\"elementor-fr_FR-c124088d3e99b69538d5d578decbde23.json\";i:28;s:53:\"elementor-fr_FR-bd7df0741aeddc2bbbb08d20c11e4ddc.json\";i:29;s:53:\"elementor-fr_FR-066ef1cdf21d1b40c6de8f6422ec24e0.json\";i:30;s:53:\"elementor-fr_FR-91751ab1f6434be40ed42c6f2430685d.json\";i:31;s:53:\"elementor-fr_FR-edafd6bb20f92c5a76f673e753e9b748.json\";i:32;s:53:\"elementor-fr_FR-38ad0bddf7be1ae89a964f0a38111ec4.json\";i:33;s:53:\"elementor-fr_FR-087056f498f9670c54c0511c8654cc0f.json\";i:34;s:18:\"elementor-fr_FR.po\";i:35;s:53:\"elementor-fr_FR-e9bd92fcd3a153fa19faf0be5f3e21b4.json\";i:36;s:53:\"elementor-fr_FR-1dbb8b6c1e3d0a728637a838a81040c6.json\";i:37;s:53:\"elementor-fr_FR-7bd3d6cb6889e0684fb5850e5de15987.json\";i:38;s:53:\"elementor-fr_FR-d3edc9236498fc3ec14d61ab5d722dcf.json\";i:39;s:53:\"elementor-fr_FR-1eaa4805b1377c0417b4db33d9356e55.json\";i:40;s:53:\"elementor-fr_FR-447a0216bbfde7c07c43b4340afd4cac.json\";i:41;s:53:\"elementor-fr_FR-d3d5654beb3dd946bfe30c646a6e6f7a.json\";i:42;s:53:\"elementor-fr_FR-9de15ead6aa7b3bb8a1ea30a49991974.json\";i:43;s:53:\"elementor-fr_FR-7b11194e20cdeeed80bffc166272edd8.json\";i:44;s:53:\"elementor-fr_FR-e16f2427ce816c4dc38ad0b36edc3ef2.json\";i:45;s:53:\"elementor-fr_FR-a37a3c226bf678cab681cd9909081cd7.json\";i:46;s:53:\"elementor-fr_FR-21b2026463ef175722764b7eaf9022f0.json\";i:47;s:53:\"elementor-fr_FR-8ef6d4918e93bfaaef913c65efeec347.json\";i:48;s:53:\"elementor-fr_FR-2b2970bbb1103e5d8c04e94bda0580b5.json\";i:49;s:53:\"elementor-fr_FR-f98be19bec7bc848ce3ed383c60037c1.json\";i:50;s:53:\"elementor-fr_FR-257a4d622678f15a3f060256de53794c.json\";i:51;s:18:\"elementor-fr_FR.mo\";i:52;s:53:\"elementor-fr_FR-875641fa8e2acb7d96b56de0fac67935.json\";i:53;s:53:\"elementor-fr_FR-a356d84da643b35ca48f18200424fa68.json\";i:54;s:53:\"elementor-fr_FR-498ef4b5c136d8ffb9492430cfcb556c.json\";i:55;s:53:\"elementor-fr_FR-23f8a12bf11e8b1bbfc99cf0797d6856.json\";i:56;s:53:\"elementor-fr_FR-c036d442062da77cd42b189e9b8b6ed4.json\";i:57;s:53:\"elementor-fr_FR-086a15d65feef08c889aa027d9ea9e9e.json\";i:58;s:53:\"elementor-fr_FR-8871b489e8d974572ae4c7578f939de5.json\";i:59;s:53:\"elementor-fr_FR-9c739050cf2f73944f5e6511cc8a11fc.json\";i:60;s:24:\"elementor-fr_FR.l10n.php\";i:61;s:53:\"elementor-fr_FR-dbb6fa5340de5e9ec7a4187e2d5dc096.json\";i:62;s:53:\"elementor-fr_FR-a3bac97752b365511e337f750b1e7508.json\";}s:11:\"destination\";s:40:\"/srv/htdocs/wp-content/languages/plugins\";s:16:\"destination_name\";s:0:\"\";s:17:\"local_destination\";s:40:\"/srv/htdocs/wp-content/languages/plugins\";s:18:\"remote_destination\";s:41:\"/srv/htdocs/wp-content/languages/plugins/\";s:17:\"clear_destination\";b:1;}s:4:\"name\";s:26:\"Traductions pour Elementor\";s:8:\"messages\";a:6:{i:0;s:57:\"Mise à jour de la traduction de Elementor (fr_FR)&#8230;\";i:1;s:120:\"Téléchargement des traductions depuis https://downloads.wordpress.org/translation/plugin/elementor/3.29.2/fr_FR.zip…\";i:2;s:40:\"Décompression de la mise à jour&#8230;\";i:3;s:43:\"Installation de la dernière version&#8230;\";i:4;s:51:\"Retrait de l’ancienne version de la traduction…\";i:5;s:40:\"La traduction a bien été mise à jour.\";}}i:1;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":7:{s:4:\"type\";s:6:\"plugin\";s:4:\"slug\";s:11:\"updraftplus\";s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:6:\"1.25.6\";s:7:\"updated\";s:19:\"2025-06-18 14:43:36\";s:7:\"package\";s:79:\"https://downloads.wordpress.org/translation/plugin/updraftplus/1.25.6/fr_FR.zip\";s:10:\"autoupdate\";b:1;}s:6:\"result\";a:7:{s:6:\"source\";s:56:\"/srv/htdocs/wp-content/upgrade/updraftplus-1.25.6-fr_fr/\";s:12:\"source_files\";a:3:{i:0;s:20:\"updraftplus-fr_FR.po\";i:1;s:26:\"updraftplus-fr_FR.l10n.php\";i:2;s:20:\"updraftplus-fr_FR.mo\";}s:11:\"destination\";s:40:\"/srv/htdocs/wp-content/languages/plugins\";s:16:\"destination_name\";s:0:\"\";s:17:\"local_destination\";s:40:\"/srv/htdocs/wp-content/languages/plugins\";s:18:\"remote_destination\";s:41:\"/srv/htdocs/wp-content/languages/plugins/\";s:17:\"clear_destination\";b:1;}s:4:\"name\";s:45:\"Traductions pour UpdraftPlus - Backup/Restore\";s:8:\"messages\";a:6:{i:0;s:76:\"Mise à jour de la traduction de UpdraftPlus - Backup/Restore (fr_FR)&#8230;\";i:1;s:122:\"Téléchargement des traductions depuis https://downloads.wordpress.org/translation/plugin/updraftplus/1.25.6/fr_FR.zip…\";i:2;s:40:\"Décompression de la mise à jour&#8230;\";i:3;s:43:\"Installation de la dernière version&#8230;\";i:4;s:51:\"Retrait de l’ancienne version de la traduction…\";i:5;s:40:\"La traduction a bien été mise à jour.\";}}}}s:6:\"failed\";a:2:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}}s:7:\"success\";a:3:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}s:11:\"translation\";a:2:{i:0;s:16:\"plugin:elementor\";i:1;s:18:\"plugin:updraftplus\";}}}}i:13;a:5:{s:4:\"time\";i:1750345289;s:7:\"user_id\";i:0;s:7:\"blog_id\";s:9:\"242379716\";s:4:\"code\";s:11:\"autoupdates\";s:4:\"data\";a:3:{s:7:\"results\";a:1:{s:11:\"translation\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":7:{s:4:\"type\";s:6:\"plugin\";s:4:\"slug\";s:11:\"updraftplus\";s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:6:\"1.25.6\";s:7:\"updated\";s:19:\"2025-06-19 05:10:12\";s:7:\"package\";s:79:\"https://downloads.wordpress.org/translation/plugin/updraftplus/1.25.6/fr_FR.zip\";s:10:\"autoupdate\";b:1;}s:6:\"result\";a:7:{s:6:\"source\";s:56:\"/srv/htdocs/wp-content/upgrade/updraftplus-1.25.6-fr_fr/\";s:12:\"source_files\";a:3:{i:0;s:20:\"updraftplus-fr_FR.mo\";i:1;s:26:\"updraftplus-fr_FR.l10n.php\";i:2;s:20:\"updraftplus-fr_FR.po\";}s:11:\"destination\";s:40:\"/srv/htdocs/wp-content/languages/plugins\";s:16:\"destination_name\";s:0:\"\";s:17:\"local_destination\";s:40:\"/srv/htdocs/wp-content/languages/plugins\";s:18:\"remote_destination\";s:41:\"/srv/htdocs/wp-content/languages/plugins/\";s:17:\"clear_destination\";b:1;}s:4:\"name\";s:45:\"Traductions pour UpdraftPlus - Backup/Restore\";s:8:\"messages\";a:6:{i:0;s:76:\"Mise à jour de la traduction de UpdraftPlus - Backup/Restore (fr_FR)&#8230;\";i:1;s:122:\"Téléchargement des traductions depuis https://downloads.wordpress.org/translation/plugin/updraftplus/1.25.6/fr_FR.zip…\";i:2;s:40:\"Décompression de la mise à jour&#8230;\";i:3;s:43:\"Installation de la dernière version&#8230;\";i:4;s:51:\"Retrait de l’ancienne version de la traduction…\";i:5;s:40:\"La traduction a bien été mise à jour.\";}}}}s:6:\"failed\";a:2:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}}s:7:\"success\";a:3:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}s:11:\"translation\";a:1:{i:0;s:18:\"plugin:updraftplus\";}}}}i:14;a:5:{s:4:\"time\";i:1751383811;s:7:\"user_id\";i:0;s:7:\"blog_id\";s:9:\"242379716\";s:4:\"code\";s:11:\"autoupdates\";s:4:\"data\";a:3:{s:7:\"results\";a:2:{s:6:\"plugin\";a:2:{i:0;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":14:{s:2:\"id\";s:23:\"w.org/plugins/elementor\";s:4:\"slug\";s:9:\"elementor\";s:6:\"plugin\";s:23:\"elementor/elementor.php\";s:11:\"new_version\";s:6:\"3.30.0\";s:3:\"url\";s:40:\"https://wordpress.org/plugins/elementor/\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.30.0.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:62:\"https://ps.w.org/elementor/assets/icon-256x256.gif?rev=3111597\";s:2:\"1x\";s:62:\"https://ps.w.org/elementor/assets/icon-128x128.gif?rev=3111597\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:65:\"https://ps.w.org/elementor/assets/banner-1544x500.png?rev=3164133\";s:2:\"1x\";s:64:\"https://ps.w.org/elementor/assets/banner-772x250.png?rev=3164133\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"6.6\";s:6:\"tested\";s:5:\"6.8.1\";s:12:\"requires_php\";s:3:\"7.4\";s:16:\"requires_plugins\";a:0:{}s:15:\"current_version\";s:6:\"3.29.2\";}s:6:\"result\";b:1;s:4:\"name\";s:9:\"Elementor\";s:8:\"messages\";a:6:{i:0;s:42:\"Mise à jour de l’extension : Elementor\";i:1;s:105:\"Téléchargement de la mise à jour depuis https://downloads.wordpress.org/plugin/elementor.3.30.0.zip…\";i:2;s:40:\"Décompression de la mise à jour&#8230;\";i:3;s:43:\"Installation de la dernière version&#8230;\";i:4;s:55:\"Retrait de l’ancienne version de l’extension&#8230;\";i:5;s:40:\"L’extension a bien été mise à jour.\";}}i:1;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":14:{s:2:\"id\";s:27:\"w.org/plugins/wordpress-seo\";s:4:\"slug\";s:13:\"wordpress-seo\";s:6:\"plugin\";s:24:\"wordpress-seo/wp-seo.php\";s:11:\"new_version\";s:4:\"25.4\";s:3:\"url\";s:44:\"https://wordpress.org/plugins/wordpress-seo/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.25.4.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:66:\"https://ps.w.org/wordpress-seo/assets/icon-256x256.gif?rev=3112542\";s:2:\"1x\";s:66:\"https://ps.w.org/wordpress-seo/assets/icon-128x128.gif?rev=3112542\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:69:\"https://ps.w.org/wordpress-seo/assets/banner-1544x500.png?rev=3257862\";s:2:\"1x\";s:68:\"https://ps.w.org/wordpress-seo/assets/banner-772x250.png?rev=3257862\";}s:11:\"banners_rtl\";a:2:{s:2:\"2x\";s:73:\"https://ps.w.org/wordpress-seo/assets/banner-1544x500-rtl.png?rev=3257862\";s:2:\"1x\";s:72:\"https://ps.w.org/wordpress-seo/assets/banner-772x250-rtl.png?rev=3257862\";}s:8:\"requires\";s:3:\"6.6\";s:6:\"tested\";s:5:\"6.8.1\";s:12:\"requires_php\";s:3:\"7.4\";s:16:\"requires_plugins\";a:0:{}s:15:\"current_version\";s:6:\"25.3.1\";}s:6:\"result\";b:1;s:4:\"name\";s:9:\"Yoast SEO\";s:8:\"messages\";a:6:{i:0;s:42:\"Mise à jour de l’extension : Yoast SEO\";i:1;s:107:\"Téléchargement de la mise à jour depuis https://downloads.wordpress.org/plugin/wordpress-seo.25.4.zip…\";i:2;s:40:\"Décompression de la mise à jour&#8230;\";i:3;s:43:\"Installation de la dernière version&#8230;\";i:4;s:55:\"Retrait de l’ancienne version de l’extension&#8230;\";i:5;s:40:\"L’extension a bien été mise à jour.\";}}}s:11:\"translation\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":7:{s:4:\"type\";s:6:\"plugin\";s:4:\"slug\";s:13:\"wordpress-seo\";s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:4:\"25.4\";s:7:\"updated\";s:19:\"2025-07-01 09:22:00\";s:7:\"package\";s:79:\"https://downloads.wordpress.org/translation/plugin/wordpress-seo/25.4/fr_FR.zip\";s:10:\"autoupdate\";b:1;}s:6:\"result\";a:7:{s:6:\"source\";s:56:\"/srv/htdocs/wp-content/upgrade/wordpress-seo-25.4-fr_fr/\";s:12:\"source_files\";a:37:{i:0;s:57:\"wordpress-seo-fr_FR-8a9083701e738b3c956ea2c9a8a84375.json\";i:1;s:22:\"wordpress-seo-fr_FR.po\";i:2;s:57:\"wordpress-seo-fr_FR-753e370a61af6ba5ccabe91cc950cbcb.json\";i:3;s:57:\"wordpress-seo-fr_FR-81d02401639ac0f30dc9d7738fcbf629.json\";i:4;s:57:\"wordpress-seo-fr_FR-b1439a828d6d7684a875580ccba87936.json\";i:5;s:57:\"wordpress-seo-fr_FR-b2bb3542a05d1a95a5866b83cc7b8a5f.json\";i:6;s:57:\"wordpress-seo-fr_FR-59a157b73a79db8a63459f9a2e1b874b.json\";i:7;s:57:\"wordpress-seo-fr_FR-a35a702af4a7fbb6d2d4db8c193dd940.json\";i:8;s:57:\"wordpress-seo-fr_FR-9fc912fe9f73e39d5df0779b31bb1a6f.json\";i:9;s:57:\"wordpress-seo-fr_FR-1452e0d46abef67e70f842f830b10ec9.json\";i:10;s:57:\"wordpress-seo-fr_FR-606033e8cb263b032d13356d7a627ed5.json\";i:11;s:57:\"wordpress-seo-fr_FR-be78d746a6b9ae87c3a9ccc92ed7c7ad.json\";i:12;s:57:\"wordpress-seo-fr_FR-d6bf43f32d0c3331e709fa67e6be35a2.json\";i:13;s:57:\"wordpress-seo-fr_FR-afe43fe171170bbc6083c10610a75434.json\";i:14;s:57:\"wordpress-seo-fr_FR-a4e25a0fbd268367ae0af1e06b841f78.json\";i:15;s:57:\"wordpress-seo-fr_FR-fb9a41ab0ae57dcb4b10ea3343658bcc.json\";i:16;s:57:\"wordpress-seo-fr_FR-e422758335e56c41009e56217163c93a.json\";i:17;s:57:\"wordpress-seo-fr_FR-a4aee9e8c2e39d6f81fd70b8bb9ccc09.json\";i:18;s:57:\"wordpress-seo-fr_FR-c1b15194a6181a17d3344302011bddf5.json\";i:19;s:57:\"wordpress-seo-fr_FR-3dcfea4e3934344e63996b6fa47b7b5c.json\";i:20;s:57:\"wordpress-seo-fr_FR-9f6244fe05b49fabf96551959cf899a6.json\";i:21;s:57:\"wordpress-seo-fr_FR-d084ad2ca2d23f1331bbd1040999834e.json\";i:22;s:57:\"wordpress-seo-fr_FR-786eeb1e9fb710b6d8885049b18564b3.json\";i:23;s:57:\"wordpress-seo-fr_FR-13c172108e3ebc2555ea54a5cffd763b.json\";i:24;s:57:\"wordpress-seo-fr_FR-8c2f72a2c46baea606be9a7b0c1a23d8.json\";i:25;s:57:\"wordpress-seo-fr_FR-9ff580649b466f65633b98bb16c34525.json\";i:26;s:22:\"wordpress-seo-fr_FR.mo\";i:27;s:57:\"wordpress-seo-fr_FR-3a6bb28b59cb140b6c372392bf5f13d3.json\";i:28;s:57:\"wordpress-seo-fr_FR-d6c61f7884baaf8a18b31ca41ef1420f.json\";i:29;s:57:\"wordpress-seo-fr_FR-826f41c23138627439d01b2b0133dbc5.json\";i:30;s:28:\"wordpress-seo-fr_FR.l10n.php\";i:31;s:57:\"wordpress-seo-fr_FR-3ab1863386cca0be6ab4aa906cacadbd.json\";i:32;s:57:\"wordpress-seo-fr_FR-4293cf3571f532bb11ff1676090ec5e7.json\";i:33;s:57:\"wordpress-seo-fr_FR-c1a0e4b150b113a514f162d42c0c8ab5.json\";i:34;s:57:\"wordpress-seo-fr_FR-6ffccefef7026e678d85c6b56bd29680.json\";i:35;s:57:\"wordpress-seo-fr_FR-6ade687c7936490c88bc39df19ea71a0.json\";i:36;s:57:\"wordpress-seo-fr_FR-fbf6c210cf52f9eaaf78c5f02b58c276.json\";}s:11:\"destination\";s:40:\"/srv/htdocs/wp-content/languages/plugins\";s:16:\"destination_name\";s:0:\"\";s:17:\"local_destination\";s:40:\"/srv/htdocs/wp-content/languages/plugins\";s:18:\"remote_destination\";s:41:\"/srv/htdocs/wp-content/languages/plugins/\";s:17:\"clear_destination\";b:1;}s:4:\"name\";s:26:\"Traductions pour Yoast SEO\";s:8:\"messages\";a:6:{i:0;s:57:\"Mise à jour de la traduction de Yoast SEO (fr_FR)&#8230;\";i:1;s:122:\"Téléchargement des traductions depuis https://downloads.wordpress.org/translation/plugin/wordpress-seo/25.4/fr_FR.zip…\";i:2;s:40:\"Décompression de la mise à jour&#8230;\";i:3;s:43:\"Installation de la dernière version&#8230;\";i:4;s:51:\"Retrait de l’ancienne version de la traduction…\";i:5;s:40:\"La traduction a bien été mise à jour.\";}}}}s:6:\"failed\";a:2:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}}s:7:\"success\";a:3:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}s:11:\"translation\";a:1:{i:0;s:20:\"plugin:wordpress-seo\";}}}}i:15;a:5:{s:4:\"time\";i:1752592291;s:7:\"user_id\";i:0;s:7:\"blog_id\";s:9:\"242379716\";s:4:\"code\";s:11:\"autoupdates\";s:4:\"data\";a:3:{s:7:\"results\";a:2:{s:6:\"plugin\";a:2:{i:0;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":14:{s:2:\"id\";s:24:\"w.org/plugins/duplicator\";s:4:\"slug\";s:10:\"duplicator\";s:6:\"plugin\";s:25:\"duplicator/duplicator.php\";s:11:\"new_version\";s:6:\"1.5.13\";s:3:\"url\";s:41:\"https://wordpress.org/plugins/duplicator/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/plugin/duplicator.1.5.13.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:63:\"https://ps.w.org/duplicator/assets/icon-256x256.png?rev=2906985\";s:2:\"1x\";s:63:\"https://ps.w.org/duplicator/assets/icon-128x128.png?rev=2906985\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:66:\"https://ps.w.org/duplicator/assets/banner-1544x500.png?rev=2906985\";s:2:\"1x\";s:65:\"https://ps.w.org/duplicator/assets/banner-772x250.png?rev=2906985\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.3\";s:6:\"tested\";s:5:\"6.8.1\";s:12:\"requires_php\";s:3:\"7.4\";s:16:\"requires_plugins\";a:0:{}s:15:\"current_version\";s:6:\"1.5.12\";}s:6:\"result\";b:1;s:4:\"name\";s:10:\"Duplicator\";s:8:\"messages\";a:6:{i:0;s:43:\"Mise à jour de l’extension : Duplicator\";i:1;s:106:\"Téléchargement de la mise à jour depuis https://downloads.wordpress.org/plugin/duplicator.1.5.13.zip…\";i:2;s:40:\"Décompression de la mise à jour&#8230;\";i:3;s:43:\"Installation de la dernière version&#8230;\";i:4;s:55:\"Retrait de l’ancienne version de l’extension&#8230;\";i:5;s:40:\"L’extension a bien été mise à jour.\";}}i:1;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":14:{s:2:\"id\";s:27:\"w.org/plugins/wordpress-seo\";s:4:\"slug\";s:13:\"wordpress-seo\";s:6:\"plugin\";s:24:\"wordpress-seo/wp-seo.php\";s:11:\"new_version\";s:4:\"25.5\";s:3:\"url\";s:44:\"https://wordpress.org/plugins/wordpress-seo/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.25.5.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:66:\"https://ps.w.org/wordpress-seo/assets/icon-256x256.gif?rev=3112542\";s:2:\"1x\";s:66:\"https://ps.w.org/wordpress-seo/assets/icon-128x128.gif?rev=3112542\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:69:\"https://ps.w.org/wordpress-seo/assets/banner-1544x500.png?rev=3257862\";s:2:\"1x\";s:68:\"https://ps.w.org/wordpress-seo/assets/banner-772x250.png?rev=3257862\";}s:11:\"banners_rtl\";a:2:{s:2:\"2x\";s:73:\"https://ps.w.org/wordpress-seo/assets/banner-1544x500-rtl.png?rev=3257862\";s:2:\"1x\";s:72:\"https://ps.w.org/wordpress-seo/assets/banner-772x250-rtl.png?rev=3257862\";}s:8:\"requires\";s:3:\"6.6\";s:6:\"tested\";s:5:\"6.8.1\";s:12:\"requires_php\";s:3:\"7.4\";s:16:\"requires_plugins\";a:0:{}s:15:\"current_version\";s:4:\"25.4\";}s:6:\"result\";b:1;s:4:\"name\";s:9:\"Yoast SEO\";s:8:\"messages\";a:6:{i:0;s:42:\"Mise à jour de l’extension : Yoast SEO\";i:1;s:107:\"Téléchargement de la mise à jour depuis https://downloads.wordpress.org/plugin/wordpress-seo.25.5.zip…\";i:2;s:40:\"Décompression de la mise à jour&#8230;\";i:3;s:43:\"Installation de la dernière version&#8230;\";i:4;s:55:\"Retrait de l’ancienne version de l’extension&#8230;\";i:5;s:40:\"L’extension a bien été mise à jour.\";}}}s:11:\"translation\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":7:{s:4:\"type\";s:6:\"plugin\";s:4:\"slug\";s:13:\"wordpress-seo\";s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:4:\"25.5\";s:7:\"updated\";s:19:\"2025-07-15 09:50:39\";s:7:\"package\";s:79:\"https://downloads.wordpress.org/translation/plugin/wordpress-seo/25.5/fr_FR.zip\";s:10:\"autoupdate\";b:1;}s:6:\"result\";a:7:{s:6:\"source\";s:56:\"/srv/htdocs/wp-content/upgrade/wordpress-seo-25.5-fr_fr/\";s:12:\"source_files\";a:38:{i:0;s:57:\"wordpress-seo-fr_FR-13c172108e3ebc2555ea54a5cffd763b.json\";i:1;s:57:\"wordpress-seo-fr_FR-786eeb1e9fb710b6d8885049b18564b3.json\";i:2;s:57:\"wordpress-seo-fr_FR-d084ad2ca2d23f1331bbd1040999834e.json\";i:3;s:57:\"wordpress-seo-fr_FR-9f6244fe05b49fabf96551959cf899a6.json\";i:4;s:57:\"wordpress-seo-fr_FR-8c2f72a2c46baea606be9a7b0c1a23d8.json\";i:5;s:28:\"wordpress-seo-fr_FR.l10n.php\";i:6;s:57:\"wordpress-seo-fr_FR-c1b15194a6181a17d3344302011bddf5.json\";i:7;s:57:\"wordpress-seo-fr_FR-3dcfea4e3934344e63996b6fa47b7b5c.json\";i:8;s:57:\"wordpress-seo-fr_FR-3a6bb28b59cb140b6c372392bf5f13d3.json\";i:9;s:57:\"wordpress-seo-fr_FR-9ff580649b466f65633b98bb16c34525.json\";i:10;s:57:\"wordpress-seo-fr_FR-3ab1863386cca0be6ab4aa906cacadbd.json\";i:11;s:57:\"wordpress-seo-fr_FR-4293cf3571f532bb11ff1676090ec5e7.json\";i:12;s:57:\"wordpress-seo-fr_FR-d6c61f7884baaf8a18b31ca41ef1420f.json\";i:13;s:57:\"wordpress-seo-fr_FR-826f41c23138627439d01b2b0133dbc5.json\";i:14;s:57:\"wordpress-seo-fr_FR-6ffccefef7026e678d85c6b56bd29680.json\";i:15;s:57:\"wordpress-seo-fr_FR-c1a0e4b150b113a514f162d42c0c8ab5.json\";i:16;s:57:\"wordpress-seo-fr_FR-9ccc8602bb31bf60d31d4b9ecb9a0659.json\";i:17;s:22:\"wordpress-seo-fr_FR.mo\";i:18;s:57:\"wordpress-seo-fr_FR-6ade687c7936490c88bc39df19ea71a0.json\";i:19;s:57:\"wordpress-seo-fr_FR-fbf6c210cf52f9eaaf78c5f02b58c276.json\";i:20;s:57:\"wordpress-seo-fr_FR-81d02401639ac0f30dc9d7738fcbf629.json\";i:21;s:57:\"wordpress-seo-fr_FR-b1439a828d6d7684a875580ccba87936.json\";i:22;s:57:\"wordpress-seo-fr_FR-b2bb3542a05d1a95a5866b83cc7b8a5f.json\";i:23;s:57:\"wordpress-seo-fr_FR-8a9083701e738b3c956ea2c9a8a84375.json\";i:24;s:57:\"wordpress-seo-fr_FR-753e370a61af6ba5ccabe91cc950cbcb.json\";i:25;s:57:\"wordpress-seo-fr_FR-9fc912fe9f73e39d5df0779b31bb1a6f.json\";i:26;s:57:\"wordpress-seo-fr_FR-1452e0d46abef67e70f842f830b10ec9.json\";i:27;s:57:\"wordpress-seo-fr_FR-606033e8cb263b032d13356d7a627ed5.json\";i:28;s:57:\"wordpress-seo-fr_FR-59a157b73a79db8a63459f9a2e1b874b.json\";i:29;s:57:\"wordpress-seo-fr_FR-a35a702af4a7fbb6d2d4db8c193dd940.json\";i:30;s:22:\"wordpress-seo-fr_FR.po\";i:31;s:57:\"wordpress-seo-fr_FR-d6bf43f32d0c3331e709fa67e6be35a2.json\";i:32;s:57:\"wordpress-seo-fr_FR-be78d746a6b9ae87c3a9ccc92ed7c7ad.json\";i:33;s:57:\"wordpress-seo-fr_FR-fb9a41ab0ae57dcb4b10ea3343658bcc.json\";i:34;s:57:\"wordpress-seo-fr_FR-a4aee9e8c2e39d6f81fd70b8bb9ccc09.json\";i:35;s:57:\"wordpress-seo-fr_FR-e422758335e56c41009e56217163c93a.json\";i:36;s:57:\"wordpress-seo-fr_FR-afe43fe171170bbc6083c10610a75434.json\";i:37;s:57:\"wordpress-seo-fr_FR-a4e25a0fbd268367ae0af1e06b841f78.json\";}s:11:\"destination\";s:40:\"/srv/htdocs/wp-content/languages/plugins\";s:16:\"destination_name\";s:0:\"\";s:17:\"local_destination\";s:40:\"/srv/htdocs/wp-content/languages/plugins\";s:18:\"remote_destination\";s:41:\"/srv/htdocs/wp-content/languages/plugins/\";s:17:\"clear_destination\";b:1;}s:4:\"name\";s:26:\"Traductions pour Yoast SEO\";s:8:\"messages\";a:6:{i:0;s:57:\"Mise à jour de la traduction de Yoast SEO (fr_FR)&#8230;\";i:1;s:122:\"Téléchargement des traductions depuis https://downloads.wordpress.org/translation/plugin/wordpress-seo/25.5/fr_FR.zip…\";i:2;s:40:\"Décompression de la mise à jour&#8230;\";i:3;s:43:\"Installation de la dernière version&#8230;\";i:4;s:51:\"Retrait de l’ancienne version de la traduction…\";i:5;s:40:\"La traduction a bien été mise à jour.\";}}}}s:6:\"failed\";a:2:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}}s:7:\"success\";a:3:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}s:11:\"translation\";a:1:{i:0;s:20:\"plugin:wordpress-seo\";}}}}}","off"),
("3172","xoo_aff_easy_login_woocommerce_fields","{\"xoo_el_reg_username\":{\"field_type\":\"xoo_el_reg_username\",\"input_type\":\"text\",\"settings\":{\"unique_id\":\"xoo_el_reg_username\",\"required\":\"yes\",\"active\":\"no\",\"label\":\"\",\"cols\":\"one\",\"icon\":\"fas fa-user-plus\",\"placeholder\":\"Username\",\"minlength\":3,\"maxlength\":20,\"class\":\"\"},\"priority\":20},\"xoo_el_reg_userrole\":{\"field_type\":\"xoo_el_reg_userrole\",\"input_type\":\"select_list\",\"settings\":{\"unique_id\":\"xoo_el_reg_userrole\",\"required\":\"yes\",\"active\":\"no\",\"label\":\"\",\"cols\":\"one\",\"icon\":\"far fa-user\",\"use_select2\":\"no\",\"placeholder\":\"User Role\",\"select_list\":{\"editor\":{\"label\":\"Editor\",\"value\":\"editor\",\"checked\":\"\"},\"author\":{\"label\":\"Author\",\"value\":\"author\",\"checked\":\"\"},\"contributor\":{\"label\":\"Contributor\",\"value\":\"contributor\",\"checked\":\"\"},\"subscriber\":{\"label\":\"Subscriber\",\"value\":\"subscriber\",\"checked\":\"\"},\"wpseo_manager\":{\"label\":\"SEO Manager\",\"value\":\"wpseo_manager\",\"checked\":\"\"},\"wpseo_editor\":{\"label\":\"SEO Editor\",\"value\":\"wpseo_editor\",\"checked\":\"\"}},\"class\":\"\"},\"priority\":30},\"xoo_el_reg_email\":{\"field_type\":\"xoo_el_reg_email\",\"input_type\":\"email\",\"settings\":{\"unique_id\":\"xoo_el_reg_email\",\"active\":\"yes\",\"required\":\"yes\",\"label\":\"\",\"cols\":\"one\",\"icon\":\"fas fa-at\",\"placeholder\":\"Email\",\"class\":\"\"},\"priority\":40},\"xoo_el_reg_fname\":{\"field_type\":\"xoo_el_reg_fname\",\"input_type\":\"text\",\"settings\":{\"unique_id\":\"xoo_el_reg_fname\",\"active\":\"yes\",\"required\":\"yes\",\"label\":\"\",\"cols\":\"onehalf\",\"icon\":\"far fa-user\",\"placeholder\":\"First Name\",\"minlength\":\"\",\"maxlength\":\"\",\"class\":\"\"},\"priority\":50},\"xoo_el_reg_lname\":{\"field_type\":\"xoo_el_reg_lname\",\"input_type\":\"text\",\"settings\":{\"unique_id\":\"xoo_el_reg_lname\",\"active\":\"yes\",\"required\":\"yes\",\"label\":\"\",\"cols\":\"onehalf\",\"icon\":\"far fa-user\",\"placeholder\":\"Last Name\",\"minlength\":\"\",\"maxlength\":\"\",\"class\":\"\"},\"priority\":60},\"xoo_el_reg_pass\":{\"field_type\":\"xoo_el_reg_pass\",\"input_type\":\"password\",\"settings\":{\"required\":\"yes\",\"unique_id\":\"xoo_el_reg_pass\",\"active\":\"yes\",\"label\":\"\",\"cols\":\"one\",\"icon\":\"fas fa-key\",\"placeholder\":\"Password\",\"minlength\":6,\"maxlength\":20,\"password_visibility\":\"yes\",\"class\":\"\"},\"priority\":70},\"xoo_el_reg_pass_again\":{\"field_type\":\"xoo_el_reg_pass_again\",\"input_type\":\"password\",\"settings\":{\"required\":\"yes\",\"unique_id\":\"xoo_el_reg_pass_again\",\"active\":\"yes\",\"label\":\"\",\"cols\":\"one\",\"icon\":\"fas fa-key\",\"placeholder\":\"Confirm Password\",\"password_visibility\":\"yes\",\"class\":\"\"},\"priority\":80},\"xoo_el_reg_terms\":{\"field_type\":\"xoo_el_reg_terms\",\"input_type\":\"checkbox_single\",\"settings\":{\"unique_id\":\"xoo_el_reg_terms\",\"active\":\"yes\",\"required\":\"yes\",\"label\":\"\",\"placeholder\":\"The Terms and Conditions\",\"cols\":\"one\",\"checkbox_single\":{\"yes\":{\"value\":\"yes\",\"label\":\"I accept the <a href=\\\"privacy-policy\\\" target=\\\"_blank\\\"> Terms of Service and Privacy Policy <\\/a>\",\"checked\":false}},\"class\":\"\"},\"priority\":90},\"xoo-el-sing-user\":{\"field_type\":\"xoo-el-sing-user\",\"input_type\":\"text\",\"settings\":{\"unique_id\":\"xoo-el-sing-user\",\"required\":\"yes\",\"active\":\"yes\",\"elType\":\"single\",\"autocomplete\":\"username\",\"xoo_el_username\":\"yes\",\"label\":\"\",\"cols\":\"one\",\"icon\":\"fas fa-user-plus\",\"placeholder\":\"Identifiant\\/e-mail\",\"class\":\"\"},\"priority\":990},\"xoo-el-username\":{\"field_type\":\"xoo-el-username\",\"input_type\":\"text\",\"settings\":{\"unique_id\":\"xoo-el-username\",\"required\":\"yes\",\"active\":\"yes\",\"elType\":\"login\",\"autocomplete\":\"username\",\"label\":\"\",\"cols\":\"one\",\"icon\":\"fas fa-user-plus\",\"placeholder\":\"Identifiant\\/e-mail\",\"class\":\"\"},\"priority\":1000},\"xoo-el-password\":{\"field_type\":\"xoo-el-password\",\"input_type\":\"password\",\"settings\":{\"required\":\"yes\",\"unique_id\":\"xoo-el-password\",\"elType\":\"login\",\"autocomplete\":\"current-password\",\"label\":\"\",\"cols\":\"one\",\"icon\":\"fas fa-key\",\"placeholder\":\"Mot de passe\",\"password_visibility\":\"yes\",\"class\":\"\"},\"priority\":1010},\"xoo-el-rp-pass\":{\"field_type\":\"xoo-el-rp-pass\",\"input_type\":\"password\",\"settings\":{\"required\":\"yes\",\"unique_id\":\"xoo-el-rp-pass\",\"elType\":\"resetpw\",\"label\":\"\",\"cols\":\"one\",\"icon\":\"fas fa-key\",\"placeholder\":\"Nouveau mot de passe\",\"minlength\":6,\"maxlength\":20,\"password_visibility\":\"yes\",\"class\":\"\"},\"priority\":1020},\"xoo-el-rp-pass-again\":{\"field_type\":\"xoo-el-rp-pass-again\",\"input_type\":\"password\",\"settings\":{\"required\":\"yes\",\"unique_id\":\"xoo-el-rp-pass-again\",\"elType\":\"resetpw\",\"label\":\"\",\"cols\":\"one\",\"icon\":\"fas fa-key\",\"placeholder\":\"Confirmer le mot de passe\",\"password_visibility\":\"yes\",\"class\":\"\"},\"priority\":1030},\"user_login\":{\"field_type\":\"user_login\",\"input_type\":\"text\",\"settings\":{\"unique_id\":\"user_login\",\"required\":\"yes\",\"active\":\"yes\",\"elType\":\"lostpw\",\"label\":\"\",\"cols\":\"one\",\"icon\":\"fas fa-user-plus\",\"placeholder\":\"Identifiant\\/e-mail\",\"class\":\"\"},\"priority\":1040}}","auto"),
("3173","xoo-el-version","2.9.6","auto"),
("3174","xoo_easy-login-woocommerce_theme_templates_data","a:3:{s:12:\"has_outdated\";s:2:\"no\";s:9:\"templates\";a:0:{}s:12:\"last_scanned\";i:1754244677;}","auto"),
("3175","xoo_aff_easy-login-woocommerce_version","2.0.6","auto"),
("3176","xoo-aff-easy-login-woocommerce-general-options","a:17:{i:0;b:0;s:14:\"s-show-reqicon\";s:2:\"no\";s:12:\"s-show-icons\";s:3:\"yes\";s:11:\"s-icon-size\";s:2:\"14\";s:12:\"s-icon-width\";s:2:\"40\";s:14:\"s-icon-bgcolor\";s:5:\" #eee\";s:12:\"s-icon-color\";s:4:\"#555\";s:15:\"s-icon-borcolor\";s:7:\"#cccccc\";s:15:\"s-icon-borwidth\";s:1:\"1\";s:15:\"s-field-bmargin\";s:2:\"30\";s:14:\"s-input-height\";s:2:\"50\";s:15:\"s-input-bgcolor\";s:4:\"#fff\";s:16:\"s-input-txtcolor\";s:4:\"#777\";s:16:\"s-input-borcolor\";s:7:\"#cccccc\";s:16:\"s-input-borwidth\";s:1:\"1\";s:20:\"s-input-focusbgcolor\";s:7:\"#ededed\";s:21:\"s-input-focustxtcolor\";s:4:\"#000\";}","auto"),
("3177","xoo-el-av-options","a:4:{s:12:\"m-custom-css\";s:0:\"\";s:11:\"m-error-log\";s:2:\"no\";s:13:\"m-login-class\";s:0:\"\";s:16:\"m-register-class\";s:0:\"\";}","auto"),
("3178","xoo-el-gl-options","a:27:{s:8:\"m-en-reg\";s:3:\"yes\";s:11:\"m-user-role\";s:10:\"subscriber\";s:12:\"m-auto-login\";s:3:\"yes\";s:10:\"m-reset-pw\";s:3:\"yes\";s:14:\"m-form-pattern\";s:8:\"separate\";s:13:\"m-nav-pattern\";s:4:\"tabs\";s:11:\"m-red-login\";s:0:\"\";s:14:\"m-red-register\";s:0:\"\";s:12:\"m-red-logout\";s:0:\"\";s:12:\"m-ep-success\";s:3:\"yes\";s:11:\"popup-forms\";a:3:{i:0;s:0:\"\";i:1;s:5:\"login\";i:2;s:8:\"register\";}s:11:\"popup-force\";s:3:\"yes\";s:9:\"ao-enable\";s:3:\"yes\";s:15:\"ao-default-form\";s:5:\"login\";s:7:\"ao-once\";s:2:\"no\";s:8:\"ao-pages\";s:0:\"\";s:8:\"ao-delay\";s:3:\"500\";s:13:\"txt-tab-login\";s:5:\"Login\";s:11:\"txt-tab-reg\";s:7:\"Sign Up\";s:13:\"txt-btn-login\";s:7:\"Sign in\";s:11:\"txt-btn-reg\";s:7:\"Sign Up\";s:13:\"txt-btn-respw\";s:16:\"Email Reset Link\";s:13:\"txt-sing-head\";s:0:\"\";s:15:\"txt-sing-subtxt\";s:34:\"Log in or sign up with your email.\";s:14:\"txt-btn-single\";s:8:\"Continue\";s:4:\"fake\";s:0:\"\";s:13:\"m-myacclpw-sc\";s:0:\"\";}","auto"),
("3179","xoo-el-sy-options","a:26:{s:11:\"sy-head-img\";s:0:\"\";s:13:\"sy-btns-theme\";s:5:\"theme\";s:14:\"sy-btn-bgcolor\";s:7:\"#8224e3\";s:15:\"sy-btn-txtcolor\";s:7:\"#ffffff\";s:13:\"sy-btn-border\";s:17:\"2px solid #000000\";s:13:\"sy-btn-height\";s:2:\"40\";s:14:\"sy-popup-style\";s:6:\"slider\";s:12:\"sy-popup-pos\";s:3:\"top\";s:14:\"sy-popup-width\";s:3:\"800\";s:20:\"sy-popup-height-type\";s:6:\"custom\";s:15:\"sy-popup-height\";s:3:\"650\";s:16:\"sy-popup-padding\";s:9:\"40px 30px\";s:16:\"sy-popup-bgcolor\";s:7:\"#ffffff\";s:17:\"sy-popup-txtcolor\";s:7:\"#000000\";s:14:\"sy-sidebar-img\";s:96:\"https://creakonect.com/wp-content/plugins/easy-login-woocommerce/assets/images/popup-sidebar.jpg\";s:14:\"sy-sidebar-pos\";s:4:\"left\";s:16:\"sy-sidebar-width\";s:2:\"40\";s:16:\"sy-overlay-color\";s:7:\"#000000\";s:15:\"sy-overlay-opac\";s:3:\"0.7\";s:14:\"sy-tab-bgcolor\";s:7:\"#eeeeee\";s:15:\"sy-tab-txtcolor\";s:7:\"#3a3a3a\";s:15:\"sy-taba-bgcolor\";s:7:\"#000000\";s:16:\"sy-taba-txtcolor\";s:7:\"#ffffff\";s:12:\"sy-tab-fsize\";s:3:\"-25\";s:14:\"sy-tab-padding\";s:9:\"12px 20px\";s:4:\"fake\";s:0:\"\";}","auto"),
("3501","neve_welcome_upsell_flag","no","auto"),
("4226","wpsl_settings","a:95:{s:15:\"api_browser_key\";s:0:\"\";s:14:\"api_server_key\";s:0:\"\";s:12:\"api_language\";s:2:\"en\";s:10:\"api_region\";s:0:\"\";s:21:\"api_geocode_component\";i:0;s:12:\"api_versions\";a:1:{s:12:\"autocomplete\";s:6:\"latest\";}s:13:\"distance_unit\";s:2:\"km\";s:11:\"max_results\";s:14:\"[25],50,75,100\";s:13:\"search_radius\";s:22:\"10,25,[50],100,200,500\";s:16:\"force_postalcode\";i:0;s:13:\"marker_effect\";s:6:\"bounce\";s:14:\"address_format\";s:14:\"city_state_zip\";s:13:\"hide_distance\";i:0;s:12:\"hide_country\";i:0;s:20:\"show_contact_details\";i:0;s:25:\"clickable_contact_details\";i:0;s:11:\"auto_locate\";i:1;s:12:\"autocomplete\";i:0;s:8:\"autoload\";i:1;s:14:\"autoload_limit\";i:50;s:13:\"run_fitbounds\";i:1;s:10:\"zoom_level\";i:3;s:15:\"auto_zoom_level\";i:15;s:10:\"start_name\";s:0:\"\";s:12:\"start_latlng\";s:0:\"\";s:6:\"height\";i:350;s:8:\"map_type\";s:7:\"roadmap\";s:9:\"map_style\";s:0:\"\";s:12:\"type_control\";i:0;s:10:\"streetview\";i:0;s:16:\"results_dropdown\";i:1;s:15:\"radius_dropdown\";i:1;s:15:\"category_filter\";i:0;s:20:\"category_filter_type\";s:8:\"dropdown\";s:16:\"infowindow_width\";i:225;s:12:\"search_width\";i:179;s:11:\"label_width\";i:95;s:16:\"control_position\";s:4:\"left\";s:11:\"scrollwheel\";i:1;s:15:\"marker_clusters\";i:0;s:12:\"cluster_zoom\";i:0;s:12:\"cluster_size\";i:0;s:10:\"new_window\";i:0;s:9:\"reset_map\";i:0;s:11:\"template_id\";s:7:\"default\";s:23:\"listing_below_no_scroll\";i:0;s:18:\"direction_redirect\";i:0;s:9:\"more_info\";i:0;s:9:\"store_url\";i:0;s:9:\"phone_url\";i:0;s:17:\"marker_streetview\";i:0;s:14:\"marker_zoom_to\";i:0;s:18:\"more_info_location\";s:11:\"info window\";s:11:\"mouse_focus\";i:0;s:12:\"start_marker\";s:7:\"red.png\";s:12:\"store_marker\";s:8:\"blue.png\";s:14:\"editor_country\";s:0:\"\";s:12:\"editor_hours\";a:2:{s:8:\"dropdown\";a:7:{s:6:\"monday\";a:1:{i:0;s:15:\"9:00 AM,5:00 PM\";}s:7:\"tuesday\";a:1:{i:0;s:15:\"9:00 AM,5:00 PM\";}s:9:\"wednesday\";a:1:{i:0;s:15:\"9:00 AM,5:00 PM\";}s:8:\"thursday\";a:1:{i:0;s:15:\"9:00 AM,5:00 PM\";}s:6:\"friday\";a:1:{i:0;s:15:\"9:00 AM,5:00 PM\";}s:8:\"saturday\";s:0:\"\";s:6:\"sunday\";s:0:\"\";}s:8:\"textarea\";s:132:\"Mon 9:00 AM - 5:00 PM\nTue 9:00 AM - 5:00 PM\nWed 9:00 AM - 5:00 PM\nThu 9:00 AM - 5:00 PM\nFri 9:00 AM - 5:00 PM\nSat Closed \nSun Closed\";}s:17:\"editor_hour_input\";s:8:\"dropdown\";s:18:\"editor_hour_format\";i:12;s:15:\"editor_map_type\";s:7:\"roadmap\";s:10:\"hide_hours\";i:0;s:10:\"permalinks\";i:0;s:22:\"permalink_remove_front\";i:0;s:14:\"permalink_slug\";s:6:\"stores\";s:13:\"category_slug\";s:14:\"store-category\";s:16:\"infowindow_style\";s:7:\"default\";s:12:\"show_credits\";i:0;s:5:\"debug\";i:0;s:16:\"deregister_gmaps\";i:0;s:13:\"delay_loading\";i:0;s:11:\"start_label\";s:14:\"Start location\";s:12:\"search_label\";s:13:\"Your location\";s:16:\"search_btn_label\";s:6:\"Search\";s:15:\"preloader_label\";s:12:\"Searching...\";s:12:\"radius_label\";s:13:\"Search radius\";s:16:\"no_results_label\";s:16:\"No results found\";s:13:\"results_label\";s:7:\"Results\";s:10:\"more_label\";s:9:\"More info\";s:16:\"directions_label\";s:10:\"Directions\";s:19:\"no_directions_label\";s:58:\"No route could be found between the origin and destination\";s:10:\"back_label\";s:4:\"Back\";s:17:\"street_view_label\";s:11:\"Street view\";s:15:\"zoom_here_label\";s:9:\"Zoom here\";s:11:\"error_label\";s:39:\"Something went wrong, please try again!\";s:11:\"limit_label\";s:23:\"API usage limit reached\";s:11:\"phone_label\";s:5:\"Phone\";s:9:\"fax_label\";s:3:\"Fax\";s:11:\"email_label\";s:5:\"Email\";s:9:\"url_label\";s:3:\"Url\";s:11:\"hours_label\";s:5:\"Hours\";s:14:\"category_label\";s:15:\"Category filter\";s:22:\"category_default_label\";s:3:\"Any\";s:13:\"zoom_controls\";i:0;s:10:\"fullscreen\";i:0;}","auto"),
("4227","wpsl_version","2.2.260","auto"),
("4264","wpgmza_db_version","9.0.46","auto"),
("4265","wpgmza_global_settings","{\"engine\":\"google-maps\",\"internal_engine\":\"legacy\",\"google_maps_api_key\":false,\"default_marker_icon\":\"https:\\/\\/creakonect.com\\/wp-content\\/plugins\\/wp-google-maps\\/images\\/spotlight-poi3.png\",\"developer_mode\":false,\"user_interface_style\":\"default\",\"wpgmza_gdpr_enabled\":1,\"wpgmza_gdpr_default_notice\":\"<p>\\r\\n\\tI agree for my personal data to be processed by <span name=\\\"wpgmza_gdpr_company_name\\\"><\\/span>, for the purpose(s) of <span name=\\\"wpgmza_gdpr_retention_purpose\\\"><\\/span>.\\r\\n<\\/p>\\r\\n\\r\\n<p>\\t\\r\\n\\tI agree for my personal data, provided via map API calls, to be processed by the API provider, for the purposes of geocoding (converting addresses to coordinates), reverse geocoding and\\tgenerating directions.\\r\\n<\\/p>\\r\\n<p>\\r\\n\\tSome visual components of WP Go Maps use 3rd party libraries which are loaded over the network. At present the libraries are Google Maps, Open Street Map, jQuery DataTables and FontAwesome. When loading resources over a network, the 3rd party server will receive your IP address and User Agent string amongst other details. Please refer to the Privacy Policy of the respective libraries for details on how they use data and the process to exercise your rights under the GDPR regulations.\\r\\n<\\/p>\\r\\n<p>\\r\\n\\tWP Go Maps uses jQuery DataTables to display sortable, searchable tables, such as that seen in the Advanced Marker Listing and on the Map Edit Page. jQuery DataTables in certain circumstances uses a cookie to save and later recall the \\\"state\\\" of a given table - that is, the search term, sort column and order and current page. This data is held in local storage and retained until this is cleared manually. No libraries used by WP Go Maps transmit this information.\\r\\n<\\/p>\\r\\n<p>\\r\\n\\tPlease <a href=\\\"https:\\/\\/developers.google.com\\/maps\\/terms\\\">see here<\\/a> and <a href=\\\"https:\\/\\/maps.google.com\\/help\\/terms_maps.html\\\">here<\\/a> for Google\'s terms. Please also see <a href=\\\"https:\\/\\/policies.google.com\\/privacy?hl=en-GB&amp;gl=uk\\\">Google\'s Privacy Policy<\\/a>. We do not send the API provider any personally identifying information, or information that could uniquely identify your device.\\r\\n<\\/p>\\r\\n<p>\\r\\n\\tWhere this notice is displayed in place of a map, agreeing to this notice will store a cookie recording your agreement so you are not prompted again.\\r\\n<\\/p>\",\"wpgmza_gdpr_company_name\":\"Cr\\u00e9a Konect\",\"wpgmza_gdpr_retention_purpose\":\"displaying map tiles, geocoding addresses and calculating and display directions.\",\"wpgmza_gdpr_button_label\":\"I agree\",\"wpgmza_marker_xml_location\":\"\\/srv\\/htdocs\\/wp-content\\/uploads\\/wp-google-maps\\/\",\"wpgmza_marker_xml_url\":\"https:\\/\\/creakonect.com\\/wp-content\\/uploads\\/wp-google-maps\\/\",\"action\":\"wpgmza_save_settings\",\"wpgmza_maps_engine\":\"google-maps\",\"wpgmza_settings_map_full_screen_control\":false,\"wpgmza_settings_map_streetview\":false,\"wpgmza_settings_map_zoom\":false,\"wpgmza_settings_map_pan\":false,\"wpgmza_settings_map_type\":false,\"wpgmza_settings_map_tilt_controls\":false,\"wpgmza_settings_map_scroll\":false,\"wpgmza_settings_map_draggable\":false,\"wpgmza_settings_map_clickzoom\":false,\"wpgmza_settings_cat_logic\":\"0\",\"wpgmza_settings_filterbycat_type\":\"1\",\"use_fontawesome\":\"4.*\",\"marker_field_query_mode\":null,\"acf_product_description_type\":null,\"tile_server_url\":\"https:\\/\\/{a-c}.tile.openstreetmap.org\\/{z}\\/{x}\\/{y}.png\",\"tile_server_url_override\":\"\",\"wpgmza_load_engine_api_condition\":\"always\",\"wpgmza_always_include_engine_api_on_pages\":\"\",\"wpgmza_always_exclude_engine_api_on_pages\":\"\",\"enable_google_api_async_param\":true,\"wpgmza_prevent_other_plugins_and_theme_loading_api\":true,\"wpgmza_settings_access_level\":\"read\",\"wpgmza_force_greedy_gestures\":false,\"disable_lightbox_images\":false,\"gallery_item_source_size\":null,\"googleMarkerMode\":\"marker\",\"olMarkerMode\":\"element\",\"wpgmza_settings_retina_width\":\"\",\"wpgmza_settings_retina_height\":\"\",\"wpgmza_settings_marker_pull\":\"0\",\"wpgmza_settings_image_resizing\":false,\"wpgmza_settings_image_width\":\"\",\"wpgmza_settings_image_height\":\"\",\"wpgmza_settings_infowindow_width\":\"\",\"wpgmza_settings_infowindow_links\":false,\"wpgmza_settings_infowindow_address\":false,\"infowindow_hide_category\":false,\"wpgmza_settings_infowindow_link_text\":\"\",\"wpgmza_settings_map_open_marker_by\":\"1\",\"wpgmza_settings_disable_infowindows\":false,\"wpgmza_default_items\":null,\"disable_scroll_on_marker_listing_click\":false,\"wpgmza_settings_markerlist_icon\":false,\"wpgmza_settings_markerlist_link\":false,\"wpgmza_settings_markerlist_title\":false,\"wpgmza_settings_markerlist_address\":false,\"wpgmza_settings_markerlist_category\":false,\"wpgmza_settings_markerlist_description\":false,\"wpgmza_do_not_enqueue_datatables\":false,\"enable_datatables_enter_search\":false,\"enable_datatables_performance_mode\":false,\"wpgmza_settings_carousel_markerlist_theme\":null,\"wpgmza_settings_carousel_markerlist_image\":false,\"wpgmza_settings_carousel_markerlist_title\":false,\"wpgmza_settings_carousel_markerlist_icon\":false,\"wpgmza_settings_carousel_markerlist_address\":false,\"wpgmza_settings_carousel_markerlist_description\":false,\"wpgmza_settings_carousel_markerlist_marker_link\":false,\"wpgmza_settings_carousel_markerlist_directions\":false,\"wpgmza_settings_carousel_markerlist_resize_image\":false,\"carousel_lazyload\":false,\"carousel_autoheight\":false,\"carousel_pagination\":false,\"carousel_navigation\":false,\"carousel_disable_autoplay\":false,\"wpgmza_do_not_enqueue_owl_carousel\":false,\"wpgmza_do_not_enqueue_owl_carousel_themes\":false,\"carousel_items\":\"5\",\"carousel_items_tablet\":\"3\",\"carousel_items_mobile\":\"1\",\"carousel_autoplay\":\"5000\",\"wpgmza_store_locator_radii\":\"\",\"wpgmza_google_maps_api_key\":\"\",\"importer_google_maps_api_key\":\"\",\"open_layers_api_key\":\"\",\"open_route_service_key\":\"\",\"wpgmza_custom_css\":\"\",\"wpgmza_custom_js\":\"\",\"disable_compressed_path_variables\":false,\"disable_autoptimize_compatibility_fix\":false,\"disable_wp_engine_governor\":false,\"enable_dynamic_sql_refac_filter\":false,\"disable_automatic_backups\":false,\"disable_google_fonts\":false,\"enable_google_csp_headers\":false,\"force_ajax_only_mode\":false,\"wpgmza_developer_mode\":false,\"wpgmza_gdpr_require_consent_before_load\":false,\"wpgmza_gdpr_override_notice\":false,\"wpgmza_gdpr_notice_override_text\":\"\"}","auto"),
("4266","WPGMZA_OTHER_SETTINGS","a:105:{s:6:\"engine\";s:11:\"google-maps\";s:15:\"internal_engine\";s:6:\"legacy\";s:19:\"google_maps_api_key\";b:0;s:19:\"default_marker_icon\";s:82:\"https://creakonect.com/wp-content/plugins/wp-google-maps/images/spotlight-poi3.png\";s:14:\"developer_mode\";b:0;s:20:\"user_interface_style\";s:7:\"default\";s:19:\"wpgmza_gdpr_enabled\";i:1;s:26:\"wpgmza_gdpr_default_notice\";s:1960:\"<p>\r\n	I agree for my personal data to be processed by <span name=\"wpgmza_gdpr_company_name\"></span>, for the purpose(s) of <span name=\"wpgmza_gdpr_retention_purpose\"></span>.\r\n</p>\r\n\r\n<p>	\r\n	I agree for my personal data, provided via map API calls, to be processed by the API provider, for the purposes of geocoding (converting addresses to coordinates), reverse geocoding and	generating directions.\r\n</p>\r\n<p>\r\n	Some visual components of WP Go Maps use 3rd party libraries which are loaded over the network. At present the libraries are Google Maps, Open Street Map, jQuery DataTables and FontAwesome. When loading resources over a network, the 3rd party server will receive your IP address and User Agent string amongst other details. Please refer to the Privacy Policy of the respective libraries for details on how they use data and the process to exercise your rights under the GDPR regulations.\r\n</p>\r\n<p>\r\n	WP Go Maps uses jQuery DataTables to display sortable, searchable tables, such as that seen in the Advanced Marker Listing and on the Map Edit Page. jQuery DataTables in certain circumstances uses a cookie to save and later recall the \"state\" of a given table - that is, the search term, sort column and order and current page. This data is held in local storage and retained until this is cleared manually. No libraries used by WP Go Maps transmit this information.\r\n</p>\r\n<p>\r\n	Please <a href=\"https://developers.google.com/maps/terms\">see here</a> and <a href=\"https://maps.google.com/help/terms_maps.html\">here</a> for Google\'s terms. Please also see <a href=\"https://policies.google.com/privacy?hl=en-GB&amp;gl=uk\">Google\'s Privacy Policy</a>. We do not send the API provider any personally identifying information, or information that could uniquely identify your device.\r\n</p>\r\n<p>\r\n	Where this notice is displayed in place of a map, agreeing to this notice will store a cookie recording your agreement so you are not prompted again.\r\n</p>\";s:24:\"wpgmza_gdpr_company_name\";s:12:\"Créa Konect\";s:29:\"wpgmza_gdpr_retention_purpose\";s:81:\"displaying map tiles, geocoding addresses and calculating and display directions.\";s:24:\"wpgmza_gdpr_button_label\";s:7:\"I agree\";s:26:\"wpgmza_marker_xml_location\";s:46:\"/srv/htdocs/wp-content/uploads/wp-google-maps/\";s:21:\"wpgmza_marker_xml_url\";s:57:\"https://creakonect.com/wp-content/uploads/wp-google-maps/\";s:6:\"action\";s:20:\"wpgmza_save_settings\";s:18:\"wpgmza_maps_engine\";s:11:\"google-maps\";s:39:\"wpgmza_settings_map_full_screen_control\";b:0;s:30:\"wpgmza_settings_map_streetview\";b:0;s:24:\"wpgmza_settings_map_zoom\";b:0;s:23:\"wpgmza_settings_map_pan\";b:0;s:24:\"wpgmza_settings_map_type\";b:0;s:33:\"wpgmza_settings_map_tilt_controls\";b:0;s:26:\"wpgmza_settings_map_scroll\";b:0;s:29:\"wpgmza_settings_map_draggable\";b:0;s:29:\"wpgmza_settings_map_clickzoom\";b:0;s:25:\"wpgmza_settings_cat_logic\";s:1:\"0\";s:32:\"wpgmza_settings_filterbycat_type\";s:1:\"1\";s:15:\"use_fontawesome\";s:3:\"4.*\";s:23:\"marker_field_query_mode\";N;s:28:\"acf_product_description_type\";N;s:15:\"tile_server_url\";s:52:\"https://{a-c}.tile.openstreetmap.org/{z}/{x}/{y}.png\";s:24:\"tile_server_url_override\";s:0:\"\";s:32:\"wpgmza_load_engine_api_condition\";s:6:\"always\";s:41:\"wpgmza_always_include_engine_api_on_pages\";s:0:\"\";s:41:\"wpgmza_always_exclude_engine_api_on_pages\";s:0:\"\";s:29:\"enable_google_api_async_param\";b:1;s:50:\"wpgmza_prevent_other_plugins_and_theme_loading_api\";b:1;s:28:\"wpgmza_settings_access_level\";s:4:\"read\";s:28:\"wpgmza_force_greedy_gestures\";b:0;s:23:\"disable_lightbox_images\";b:0;s:24:\"gallery_item_source_size\";N;s:16:\"googleMarkerMode\";s:6:\"marker\";s:12:\"olMarkerMode\";s:7:\"element\";s:28:\"wpgmza_settings_retina_width\";s:0:\"\";s:29:\"wpgmza_settings_retina_height\";s:0:\"\";s:27:\"wpgmza_settings_marker_pull\";s:1:\"0\";s:30:\"wpgmza_settings_image_resizing\";b:0;s:27:\"wpgmza_settings_image_width\";s:0:\"\";s:28:\"wpgmza_settings_image_height\";s:0:\"\";s:32:\"wpgmza_settings_infowindow_width\";s:0:\"\";s:32:\"wpgmza_settings_infowindow_links\";b:0;s:34:\"wpgmza_settings_infowindow_address\";b:0;s:24:\"infowindow_hide_category\";b:0;s:36:\"wpgmza_settings_infowindow_link_text\";s:0:\"\";s:34:\"wpgmza_settings_map_open_marker_by\";s:1:\"1\";s:35:\"wpgmza_settings_disable_infowindows\";b:0;s:20:\"wpgmza_default_items\";N;s:38:\"disable_scroll_on_marker_listing_click\";b:0;s:31:\"wpgmza_settings_markerlist_icon\";b:0;s:31:\"wpgmza_settings_markerlist_link\";b:0;s:32:\"wpgmza_settings_markerlist_title\";b:0;s:34:\"wpgmza_settings_markerlist_address\";b:0;s:35:\"wpgmza_settings_markerlist_category\";b:0;s:38:\"wpgmza_settings_markerlist_description\";b:0;s:32:\"wpgmza_do_not_enqueue_datatables\";b:0;s:30:\"enable_datatables_enter_search\";b:0;s:34:\"enable_datatables_performance_mode\";b:0;s:41:\"wpgmza_settings_carousel_markerlist_theme\";N;s:41:\"wpgmza_settings_carousel_markerlist_image\";b:0;s:41:\"wpgmza_settings_carousel_markerlist_title\";b:0;s:40:\"wpgmza_settings_carousel_markerlist_icon\";b:0;s:43:\"wpgmza_settings_carousel_markerlist_address\";b:0;s:47:\"wpgmza_settings_carousel_markerlist_description\";b:0;s:47:\"wpgmza_settings_carousel_markerlist_marker_link\";b:0;s:46:\"wpgmza_settings_carousel_markerlist_directions\";b:0;s:48:\"wpgmza_settings_carousel_markerlist_resize_image\";b:0;s:17:\"carousel_lazyload\";b:0;s:19:\"carousel_autoheight\";b:0;s:19:\"carousel_pagination\";b:0;s:19:\"carousel_navigation\";b:0;s:25:\"carousel_disable_autoplay\";b:0;s:34:\"wpgmza_do_not_enqueue_owl_carousel\";b:0;s:41:\"wpgmza_do_not_enqueue_owl_carousel_themes\";b:0;s:14:\"carousel_items\";s:1:\"5\";s:21:\"carousel_items_tablet\";s:1:\"3\";s:21:\"carousel_items_mobile\";s:1:\"1\";s:17:\"carousel_autoplay\";s:4:\"5000\";s:26:\"wpgmza_store_locator_radii\";s:0:\"\";s:26:\"wpgmza_google_maps_api_key\";s:0:\"\";s:28:\"importer_google_maps_api_key\";s:0:\"\";s:19:\"open_layers_api_key\";s:0:\"\";s:22:\"open_route_service_key\";s:0:\"\";s:17:\"wpgmza_custom_css\";s:0:\"\";s:16:\"wpgmza_custom_js\";s:0:\"\";s:33:\"disable_compressed_path_variables\";b:0;s:37:\"disable_autoptimize_compatibility_fix\";b:0;s:26:\"disable_wp_engine_governor\";b:0;s:31:\"enable_dynamic_sql_refac_filter\";b:0;s:25:\"disable_automatic_backups\";b:0;s:20:\"disable_google_fonts\";b:0;s:25:\"enable_google_csp_headers\";b:0;s:20:\"force_ajax_only_mode\";b:0;s:21:\"wpgmza_developer_mode\";b:0;s:39:\"wpgmza_gdpr_require_consent_before_load\";b:0;s:27:\"wpgmza_gdpr_override_notice\";b:0;s:32:\"wpgmza_gdpr_notice_override_text\";s:0:\"\";}","auto"),
("4267","wpgmza_xml_location","/srv/htdocs/wp-content/uploads/wp-google-maps/","auto"),
("4268","wpgmza_xml_url","https://creakonect.com/wp-content/uploads/wp-google-maps/","auto"),
("4269","wpgmza_temp_api","AIzaSyCbeu4Jum_F9YU5CV6Cjs-hS26xsyoNWVI","auto"),
("4270","wpgmza-first-run","2025-04-03T20:55:18+0000","auto"),
("4271","wpgmza_welcome_screen_done","1","auto"),
("4273","widget_wpgmza_map_widget","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("4357","wpgmza_google_maps_api_key","","auto"),
("4604","widget_i_voted","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("4656","neve_logger_flag","no","auto"),
("5335","frm_form_templates_l01fd72122f4a90f15684915c729d4368","a:3:{s:7:\"timeout\";i:1750654298;s:5:\"value\";s:215071:\"{\"20882522\":{\"name\":\"Create WordPress Post Form Template\",\"slug\":\"create-wordpress-post-form\",\"description\":\"Allow users to create WordPress posts from the front-end of your site with the Create WordPress Post form template.\",\"id\":20882522,\"released\":\"2019-03-26 15:05:14\",\"categories\":[\"Basic\",\"Post\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/create-wordpress-post-form\\/\",\"icon\":false,\"key\":\"create-wordpress-post\",\"used_addons\":[],\"expires\":\"\",\"code\":\"\",\"date\":\"\",\"type\":\"free\",\"is_new\":false},\"20874733\":{\"name\":\"Car Payment Calculator Template\",\"slug\":\"automobile-payment-calculator-form\",\"description\":\"Calculate monthly payments with an easy auto loan calculator.\",\"id\":20874733,\"released\":\"2019-01-01 13:22:05\",\"categories\":[\"Business\",\"Calculator\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/automobile-payment-calculator-form\\/\",\"icon\":false,\"key\":\"automobile-payment-calculator\",\"used_addons\":[],\"expires\":\"\",\"code\":\"\",\"date\":\"\",\"type\":\"free\",\"is_new\":false},\"20874739\":{\"name\":\"Credit Card Payment Template\",\"slug\":\"credit-card-payment-form\",\"description\":\"Use with either the Stripe or Authorize.net add-ons to securely run payments while keeping users on your site.\",\"id\":20874739,\"released\":\"2019-01-01 12:29:14\",\"categories\":[\"Business\",\"Payment\",\"Stripe\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/credit-card-payment-form\\/\",\"icon\":false,\"key\":\"credit-card-payment\",\"used_addons\":[\"Stripe\"],\"expires\":\"\",\"code\":\"\",\"date\":\"\",\"type\":\"free\",\"is_new\":false},\"20874747\":{\"name\":\"Create WooCommerce Product Template\",\"slug\":\"create-woocommerce-product-form\",\"description\":\"Easily create WooCommerce products with front-end creation, auto-populated fields, manual or automatic approval.\",\"id\":20874747,\"released\":\"2019-01-29 13:20:10\",\"categories\":[\"Elite\",\"WooCommerce\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/create-woocommerce-product-form\\/\",\"icon\":false,\"key\":\"create-woocommerce-product\",\"used_addons\":[\"WooCommerce\"],\"expires\":\"\",\"code\":\"\",\"date\":\"\",\"type\":\"free\",\"is_new\":false},\"20873706\":{\"name\":\"User Information Form Template\",\"slug\":\"user-information-form\",\"description\":\"Get a WordPress contact form with more user information including website and address.\",\"id\":20873706,\"released\":\"2017-01-23 19:08:49\",\"categories\":[\"Basic\",\"Contact\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/user-information-form\\/\",\"icon\":false,\"key\":\"user-information\",\"used_addons\":[],\"expires\":\"\",\"code\":\"\",\"date\":\"\",\"type\":\"free\",\"is_new\":false},\"20873677\":{\"name\":\"Real Estate Listings Form Template\",\"slug\":\"real-estate-listings-form\",\"description\":\"Show Real Estate listings on your site. First add listings in a form, then create a view to display them.\",\"id\":20873677,\"released\":\"2017-01-23 18:56:44\",\"categories\":[\"Personal\",\"Real Estate\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/real-estate-listings-form\\/\",\"icon\":false,\"key\":\"real-estate-listings\",\"used_addons\":[],\"expires\":\"\",\"code\":\"\",\"date\":\"\",\"type\":\"free\",\"is_new\":false},\"20874045\":{\"name\":\"Job Application Form Template\",\"slug\":\"job-application-form\",\"description\":\"Streamline your hiring process by collecting employment applications online and get more applications.\",\"id\":20874045,\"released\":\"2017-01-25 15:33:33\",\"categories\":[\"Application\",\"Personal\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/job-application-form\\/\",\"icon\":false,\"key\":\"job-application\",\"used_addons\":[],\"expires\":\"\",\"code\":\"\",\"date\":\"\",\"type\":\"free\",\"is_new\":false},\"20874049\":{\"name\":\"Emergency Contact Form Template\",\"slug\":\"emergency-contact-form\",\"description\":\"Protect your clients and be prepared for any situation by collecting emergency contact and basic medical information.\",\"id\":20874049,\"released\":\"2019-01-01 15:50:21\",\"categories\":[\"Business\",\"Contact\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/emergency-contact-form\\/\",\"icon\":false,\"key\":\"emergency-contact\",\"used_addons\":[],\"expires\":\"\",\"code\":\"\",\"date\":\"\",\"type\":\"free\",\"is_new\":false},\"28080527\":{\"name\":\"Sample Size Calculator Template\",\"slug\":\"sample-size-calculator-form\",\"description\":\"Find out how many people need to respond to a survey to produce statistically significant results.\",\"id\":28080527,\"released\":\"2021-09-20 12:49:06\",\"categories\":[\"Business\",\"Business Operations\",\"Calculator\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/sample-size-calculator-form\\/\",\"icon\":false,\"key\":\"sample-size-calculator\",\"used_addons\":[],\"expires\":\"\",\"code\":\"\",\"date\":\"\",\"type\":\"free\",\"is_new\":false},\"20873681\":{\"name\":\"SMS Get Quote Form Template\",\"slug\":\"sms-get-quote-form\",\"description\":\"The most streamlined quote form. When the form is submitted, get an instant SMS notification to let you know of a quote request.\",\"id\":20873681,\"released\":\"2019-01-01 19:15:29\",\"categories\":[\"Business\",\"Business Operations\",\"Twilio\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/sms-get-quote-form\\/\",\"icon\":false,\"key\":\"sms-get-quote\",\"used_addons\":[],\"expires\":\"\",\"code\":\"\",\"date\":\"\",\"type\":\"free\",\"is_new\":false},\"20872681\":{\"name\":\"Contact Form to SMS Template\",\"slug\":\"contact-form-to-sms-template\",\"description\":\"Perfect for a simple contact form. Visitors ask a question and receive an instant SMS text message confirmation.\",\"id\":20872681,\"released\":\"2019-01-01 16:11:52\",\"categories\":[\"Business\",\"Contact\",\"Twilio\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/contact-form-to-sms-template\\/\",\"icon\":false,\"key\":\"contact-form-to-sms\",\"used_addons\":[],\"expires\":\"\",\"code\":\"\",\"date\":\"\",\"type\":\"free\",\"is_new\":false},\"28036517\":{\"name\":\"Employee Referral Form Template\",\"slug\":\"employee-referral-form\",\"description\":\"Let your current staff refer their friends and family to work for you with this employee referral template\",\"id\":28036517,\"released\":\"2020-12-18 14:07:13\",\"categories\":[\"Business Operations\",\"free\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/employee-referral-form\\/\",\"icon\":false,\"key\":\"employee-referral\",\"used_addons\":[],\"expires\":\"\",\"code\":\"\",\"date\":\"\",\"type\":\"free\",\"url\":\"https:\\/\\/s3.amazonaws.com\\/fp.strategy11.com\\/form-templates\\/employee-referral-form.xml?AWSAccessKeyId=AKIAJ3QHAN4BJMSYZ3ZQ&Expires=1750675898&Signature=n3vxukrV%2FHojp9KsQGXaGuPPOJ0%3D\",\"is_new\":false},\"28036180\":{\"name\":\"Call for Proposals Form Template\",\"slug\":\"call-for-proposals-form\",\"description\":\"Putting out a call for proposals? Enhance your RFP process with a call for proposals form template! Now you can request proposals the easy way.\",\"id\":28036180,\"released\":\"2020-12-18 13:00:06\",\"categories\":[\"Business Operations\",\"free\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/call-for-proposals-form\\/\",\"icon\":false,\"key\":\"call-for-proposals\",\"used_addons\":[],\"expires\":\"\",\"code\":\"\",\"date\":\"\",\"type\":\"free\",\"url\":\"https:\\/\\/s3.amazonaws.com\\/fp.strategy11.com\\/form-templates\\/call-for-proposals-form.xml?AWSAccessKeyId=AKIAJ3QHAN4BJMSYZ3ZQ&Expires=1750675898&Signature=2N%2Bb8Gyiej%2FnC7SE9tNJC3MByWk%3D\",\"is_new\":false},\"20905853\":{\"name\":\"Contest Entry Form Template\",\"slug\":\"contest-entry-form\",\"description\":\"Easily collect entries by promoting participation in a contest.\",\"id\":20905853,\"released\":\"2019-11-24 23:00:23\",\"categories\":[\"Basic\",\"Marketing\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/contest-entry-form\\/\",\"icon\":false,\"key\":\"contest-entry\",\"used_addons\":[],\"expires\":\"\",\"code\":\"\",\"date\":\"\",\"type\":\"free\",\"is_new\":false},\"20905877\":{\"name\":\"Cancellation Survey Form Template\",\"slug\":\"cancellation-survey-form\",\"description\":\"Ask clients why they are canceling and how you can improve.\",\"id\":20905877,\"released\":\"2019-11-24 23:00:34\",\"categories\":[\"Business\",\"Business Operations\",\"Survey\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/cancellation-survey-form\\/\",\"icon\":[\"https:\\/\\/formidableforms.com\\/wp-content\\/uploads\\/2019\\/11\\/cancellation-survey-form-template.jpg\",650,288,false],\"key\":\"cancellation-survey\",\"used_addons\":[],\"expires\":\"\",\"code\":\"\",\"date\":\"\",\"type\":\"free\",\"is_new\":false},\"20905879\":{\"name\":\"Conference Registration Form Template\",\"slug\":\"conference-registration-form\",\"description\":\"Easily register attendees for a conference.\",\"id\":20905879,\"released\":\"2019-11-24 23:00:27\",\"categories\":[\"Business\",\"Event Planning\",\"Payment\",\"Registration and Signup\",\"Stripe\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/conference-registration-form\\/\",\"icon\":false,\"key\":\"conference-registration\",\"used_addons\":[],\"expires\":\"\",\"code\":\"\",\"date\":\"\",\"type\":\"free\",\"is_new\":false},\"28036515\":{\"name\":\"Content Download Form Template\",\"slug\":\"content-download-form\",\"description\":\"Use this simple form to capture leads for your business.\",\"id\":28036515,\"released\":\"2020-12-18 13:30:20\",\"categories\":[\"Customer Service\",\"free\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/content-download-form\\/\",\"icon\":false,\"key\":\"content-download\",\"used_addons\":[],\"expires\":\"\",\"code\":\"\",\"date\":\"\",\"type\":\"free\",\"url\":\"https:\\/\\/s3.amazonaws.com\\/fp.strategy11.com\\/form-templates\\/content-download-form.xml?AWSAccessKeyId=AKIAJ3QHAN4BJMSYZ3ZQ&Expires=1750675898&Signature=1pthJyGL3Pi4hE8n3kEQ5X9bZbo%3D\",\"is_new\":false},\"20908991\":{\"name\":\"Accident Report Form Template\",\"slug\":\"accident-report-form\",\"description\":\"An easy way to document accidents that happen at the office or on job sites\",\"id\":20908991,\"released\":\"2019-11-24 23:00:38\",\"categories\":[\"Basic\",\"Business Operations\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/accident-report-form\\/\",\"icon\":false,\"key\":\"accident-report\",\"used_addons\":[],\"expires\":\"\",\"code\":\"\",\"date\":\"\",\"type\":\"free\",\"is_new\":false},\"20908993\":{\"name\":\"Change Request Form Template\",\"slug\":\"change-request-form\",\"description\":\"Looking for a change request form template? Take your project management to a whole new level! Manage project details effectively with this easy to use form.\",\"id\":20908993,\"released\":\"2019-11-24 23:00:07\",\"categories\":[\"Basic\",\"Business Operations\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/change-request-form\\/\",\"icon\":false,\"key\":\"change-request\",\"used_addons\":[],\"expires\":\"\",\"code\":\"\",\"date\":\"\",\"type\":\"free\",\"is_new\":false},\"20874734\":{\"name\":\"B2B Leads Form Template\",\"slug\":\"b2b-leads-form\",\"description\":\"Expand your clientele and increase revenue by bridging the gap between you and your customers.\",\"id\":20874734,\"released\":\"2019-01-01 13:09:59\",\"categories\":[\"Business\",\"Contact\",\"Lead\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/b2b-leads-form\\/\",\"icon\":false,\"key\":\"b2b-leads\",\"used_addons\":[],\"expires\":\"\",\"code\":\"\",\"date\":\"\",\"type\":\"free\",\"is_new\":false},\"20909557\":{\"name\":\"Baseball League Registration Form\",\"slug\":\"baseball-league-registration-form\",\"description\":\"A simple form for registering players for a baseball league including positions, team, and more.\",\"id\":20909557,\"released\":\"2019-11-24 23:00:05\",\"categories\":[\"Basic\",\"Registration and Signup\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/baseball-league-registration-form\\/\",\"icon\":false,\"key\":\"baseball-league-registration\",\"used_addons\":[],\"expires\":\"\",\"code\":\"\",\"date\":\"\",\"type\":\"free\",\"is_new\":false},\"28109851\":{\"name\":\"Quiz\",\"slug\":\"quiz-form\",\"description\":\"This multiple-choice quiz template is a great example of basic quiz scoring.\",\"id\":28109851,\"released\":\"2022-02-28 12:00:04\",\"categories\":[\"Business\",\"Education\",\"Quiz\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/quiz-form\\/\",\"icon\":false,\"key\":\"quiz\",\"used_addons\":[\"Conversational Forms\",\"Quiz Maker\"],\"expires\":\"\",\"code\":\"\",\"date\":\"\",\"type\":\"free\",\"is_new\":false},\"28148784\":{\"name\":\"Harry Potter House Quiz Template\",\"slug\":\"harry-potter-house-quiz-form\",\"description\":\"Find out which Hogwarts house you truly belong in with this quiz form template.\",\"id\":28148784,\"released\":\"2022-09-20 10:47:37\",\"categories\":[\"Business\",\"Conversational Forms\",\"Entertainment\",\"Quiz\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/harry-potter-house-quiz-form\\/\",\"icon\":false,\"key\":\"harry-potter-house-quiz\",\"used_addons\":[\"Conversational Forms\",\"Quiz Maker\"],\"expires\":\"\",\"code\":\"\",\"date\":\"\",\"type\":\"free\",\"is_new\":false},\"22214080\":{\"name\":\"Employee Satisfaction Survey Template\",\"slug\":\"employee-satisfaction-survey-form\",\"description\":\"Job satisfaction matters - get data with a user-friendly survey!\",\"id\":22214080,\"released\":\"2020-05-27 10:55:52\",\"categories\":[\"Business\",\"Survey\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/employee-satisfaction-survey-form\\/\",\"icon\":[\"https:\\/\\/formidableforms.com\\/wp-content\\/uploads\\/2020\\/05\\/employee-engagement-survey-template.jpg\",650,288,false],\"key\":\"employee-satisfaction-survey\",\"used_addons\":[],\"expires\":\"\",\"code\":\"\",\"date\":\"\",\"type\":\"free\",\"is_new\":false},\"28028195\":{\"name\":\"Change of Address Form Template\",\"slug\":\"change-of-address-form\",\"description\":\"Need a change of address form template? This form allows any business or government organization to offer an easy way for users to change addresses online.\",\"id\":28028195,\"released\":\"2020-11-23 00:06:21\",\"categories\":[\"Basic\",\"Business Operations\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/change-of-address-form\\/\",\"icon\":false,\"key\":\"change-of-address\",\"used_addons\":[],\"expires\":\"\",\"code\":\"\",\"date\":\"\",\"type\":\"free\",\"is_new\":false},\"20909235\":{\"name\":\"Amortization Calculator Template\",\"slug\":\"amortization-calculator-form\",\"description\":\"Estimate monthly mortgage payment principal and interest amounts.\",\"id\":20909235,\"released\":\"2019-11-24 23:00:38\",\"categories\":[\"Business\",\"Calculator\",\"Finance\",\"Real Estate\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/amortization-calculator-form\\/\",\"icon\":false,\"key\":\"amortization-calculator\",\"used_addons\":[],\"expires\":\"\",\"code\":\"\",\"date\":\"\",\"type\":\"free\",\"is_new\":false},\"28028149\":{\"name\":\"Customer Referral Form Template\",\"slug\":\"customer-referral-form\",\"description\":\"Let your customers introduce you to potential new clients.\",\"id\":28028149,\"released\":\"2020-11-23 00:01:44\",\"categories\":[\"Basic\",\"Customer Service\",\"Marketing\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/customer-referral-form\\/\",\"icon\":false,\"key\":\"customer-referral\",\"used_addons\":[],\"expires\":\"\",\"code\":\"\",\"date\":\"\",\"type\":\"free\",\"is_new\":false},\"20907786\":{\"name\":\"BMI Calculator Form Template\",\"slug\":\"bmi-calculator-form\",\"description\":\"Calculate BMI (body mass index) to help clients improve health & fitness.\",\"id\":20907786,\"released\":\"2019-11-24 23:00:06\",\"categories\":[\"Business\",\"Calculator\",\"Health and Wellness\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/bmi-calculator-form\\/\",\"icon\":false,\"key\":\"bmi-calculator\",\"used_addons\":[],\"expires\":\"\",\"code\":\"\",\"date\":\"\",\"type\":\"free\",\"is_new\":false},\"28315136\":{\"name\":\"5k Run Registration Form Template\",\"slug\":\"5k-run-registration-form\",\"description\":\"Streamline participant sign-ups and collect essential details for your 5K run event with this registration form.\",\"id\":28315136,\"released\":\"2025-03-10 15:41:07\",\"categories\":[\"Business\",\"Event Planning\",\"Registration and Signup\",\"Signature\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/5k-run-registration-form\\/\",\"icon\":false,\"key\":\"5k-run-registration\",\"used_addons\":[\"Digital Signatures\"],\"expires\":\"\",\"code\":\"\",\"date\":\"\",\"type\":\"free\",\"is_new\":false},\"28147968\":{\"name\":\"Product Recommendation Quiz Template\",\"slug\":\"product-recommendation-quiz-form\",\"description\":\"Discover your skin type and the ideal recommended product with this quiz template.\",\"id\":28147968,\"released\":\"2022-09-20 12:05:48\",\"categories\":[\"Business\",\"Conversational Forms\",\"Quiz\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/product-recommendation-quiz-form\\/\",\"icon\":false,\"key\":\"product-recommendation-quiz\",\"used_addons\":[\"Conversational Forms\",\"Quiz Maker\"],\"expires\":\"\",\"code\":\"\",\"date\":\"\",\"type\":\"free\",\"is_new\":false},\"20874752\":{\"name\":\"Simple Mortgage Calculator Template\",\"slug\":\"simple-mortgage-calculator-form\",\"description\":\"Optimize any real estate website with this responsive mortgage calculator!\",\"id\":20874752,\"released\":\"2019-01-01 12:55:25\",\"categories\":[\"Business\",\"Calculator\",\"Finance\",\"Real Estate\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/simple-mortgage-calculator-form\\/\",\"icon\":false,\"key\":\"simple-mortgage-calculator\",\"used_addons\":[],\"expires\":\"\",\"code\":\"\",\"date\":\"\",\"type\":\"free\",\"is_new\":false},\"20874753\":{\"name\":\"Edit User Profile Form Template\",\"slug\":\"edit-user-profile-form\",\"description\":\"The basics from the regular WordPress profile page including first and last name, password and email, avatar, website, and bio.\",\"id\":20874753,\"released\":\"2019-01-01 13:25:02\",\"categories\":[\"Business\",\"User Registration\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/edit-user-profile-form\\/\",\"icon\":false,\"key\":\"edit-user-profile\",\"used_addons\":[],\"expires\":\"\",\"code\":\"\",\"date\":\"\",\"type\":\"free\",\"is_new\":false},\"28019201\":{\"name\":\"Charitable Donation Form Template\",\"slug\":\"charitable-donation-form\",\"description\":\"A quick and easy form for collecting and keeping track of charitable donations.\",\"id\":28019201,\"released\":\"2020-09-11 14:40:07\",\"categories\":[\"free\",\"Nonprofit\",\"Payment\",\"Stripe\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/charitable-donation-form\\/\",\"icon\":false,\"key\":\"charitable-donation\",\"used_addons\":[],\"expires\":\"\",\"code\":\"\",\"date\":\"\",\"type\":\"free\",\"url\":\"https:\\/\\/s3.amazonaws.com\\/fp.strategy11.com\\/form-templates\\/charitable-donation-form.xml?AWSAccessKeyId=AKIAJ3QHAN4BJMSYZ3ZQ&Expires=1750675898&Signature=178uj7NifZP7h7CjAYDxvMj7%2Fgo%3D\",\"is_new\":false},\"28028161\":{\"name\":\"Direct Deposit ACH Authorization Form Template\",\"slug\":\"direct-deposit-ach-authorization-form\",\"description\":\"Simplify employee onboarding with a direct deposit ACH authorization form.\",\"id\":28028161,\"released\":\"2020-11-23 00:02:48\",\"categories\":[\"Business\",\"Business Operations\",\"Signature\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/direct-deposit-ach-authorization-form\\/\",\"icon\":false,\"key\":\"direct-deposit-ach-authorization\",\"used_addons\":[],\"expires\":\"\",\"code\":\"\",\"date\":\"\",\"type\":\"free\",\"is_new\":false},\"28297985\":{\"name\":\"Book Club Registration Form Template\",\"slug\":\"book-club-registration-form\",\"description\":\"Allow users to easily register their children for your book club.\",\"id\":28297985,\"released\":\"2024-10-08 13:06:13\",\"categories\":[\"Business\",\"Business Operations\",\"File Upload\",\"Registration and Signup\",\"Repeater Field\",\"User Registration\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/book-club-registration-form\\/\",\"icon\":false,\"key\":\"book-club-registration\",\"used_addons\":[\"User Registration\"],\"expires\":\"\",\"code\":\"\",\"date\":\"\",\"type\":\"free\",\"is_new\":false},\"28173825\":{\"name\":\"Signup Sheet Form Template\",\"slug\":\"signup-sheet-form\",\"description\":\"Generate signups and easily collect information with the signup form template.\",\"id\":28173825,\"released\":\"2023-01-26 16:03:51\",\"categories\":[\"Business\",\"Conversational Forms\",\"Education\",\"Lead\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/signup-sheet-form\\/\",\"icon\":false,\"key\":\"signup-sheet\",\"used_addons\":[],\"expires\":\"\",\"code\":\"\",\"date\":\"\",\"type\":\"free\",\"is_new\":false},\"28323074\":{\"name\":\"Needs Assessment Form Template\",\"slug\":\"needs-assessment-form\",\"description\":\"Gather essential insights to identify gaps between current conditions and future goals, enabling informed decision-making and strategic planning.\",\"id\":28323074,\"released\":\"2025-05-29 17:13:38\",\"categories\":[\"Basic\",\"Business Operations\",\"Request\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/needs-assessment-form\\/\",\"icon\":false,\"key\":\"needs-assessment\",\"used_addons\":[],\"expires\":\"\",\"code\":\"\",\"date\":\"\",\"type\":\"free\",\"is_new\":true},\"20874754\":{\"name\":\"Customer Feedback Form Template\",\"slug\":\"customer-feedback-form\",\"description\":\"Get suggestions and valuable feedback from your customers.\",\"id\":20874754,\"released\":\"2019-01-29 13:23:40\",\"categories\":[\"Business\",\"Feedback\",\"Survey\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/customer-feedback-form\\/\",\"icon\":false,\"key\":\"customer-feedback\",\"used_addons\":[],\"expires\":\"\",\"code\":\"\",\"date\":\"\",\"type\":\"free\",\"is_new\":false},\"28019202\":{\"name\":\"Sponsorship Form Template\",\"slug\":\"sponsorship-form\",\"description\":\"A simple form for use in managing business sponsorships.\",\"id\":28019202,\"released\":\"2020-10-01 08:18:17\",\"categories\":[\"Basic\",\"Business Operations\",\"Nonprofit\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/sponsorship-form\\/\",\"icon\":false,\"key\":\"sponsorship\",\"used_addons\":[],\"expires\":\"\",\"code\":\"\",\"date\":\"\",\"type\":\"free\",\"is_new\":false},\"28314884\":{\"name\":\"Electronic Fund Transfer Form Template\",\"slug\":\"electronic-fund-transfer-form\",\"description\":\"Securely collect and process electronic fund transfer requests with this streamlined form.\",\"id\":28314884,\"released\":\"2025-03-07 13:21:43\",\"categories\":[\"Business\",\"Business Operations\",\"Multi-Page\",\"Signature\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/electronic-fund-transfer-form\\/\",\"icon\":false,\"key\":\"electronic-fund-transfer\",\"used_addons\":[\"Digital Signatures\"],\"expires\":\"\",\"code\":\"\",\"date\":\"\",\"type\":\"free\",\"is_new\":false},\"28054276\":{\"name\":\"Pay Raise Percent Calculator Template\",\"slug\":\"pay-raise-percent-calculator-form\",\"description\":\"Enter a wage before and after a raise to find out how large your raise was.\",\"id\":28054276,\"released\":\"2021-04-14 11:59:56\",\"categories\":[\"Business\",\"Business Operations\",\"Calculator\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/pay-raise-percent-calculator-form\\/\",\"icon\":false,\"key\":\"pay-raise-percent-calculator\",\"used_addons\":[],\"expires\":\"\",\"code\":\"\",\"date\":\"\",\"type\":\"free\",\"is_new\":false},\"28028164\":{\"name\":\"Referral Form Template\",\"slug\":\"referral-form\",\"description\":\"Get referrals from people easily with this short and effective referral form.\",\"id\":28028164,\"released\":\"2020-11-23 00:02:17\",\"categories\":[\"Basic\",\"Customer Service\",\"Feedback\"],\"link\":\"https:\\/\\/formidableforms.com\\/form-templates\\/referral-form\\/\",\"icon\":false,\"key\":\"referral\",\"used_addons\":[],\"expires\":\"\",\"code\":\"\",\"date\":\"\",\"type\":\"free\",\"is_new\":false},\"28030724\":{\"name\":\"Car Donation Form Template\",\"slug\":\"car-donation-form\",\"description\":\"Collecting vehicle donations? Get all the details you need in this simple online form.\",\"id\":28030724,\"released\":\"2020-12-01 00:01:50\"